package io.github.mianalysis.mia.object.imagej;

import java.awt.Color;
import ij.process.LUT;

import java.util.Random;

/**
 * Created by Stephen on 19/08/2016. LUTs taken from ImageJ and Fiji
 * (https://github.com/fiji/fiji/tree/master/luts)
 */

// Convert uint8 to byte with y = ((x+128) % 256) - 128

public class LUTs {
        public static LUT random = null;
        public static LUT randomVibrant = null;

        private static long randomSeed = 2;


        public static LUT Ice() {
                byte[] reds = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 5, 8, 11, 14, 17, 19, 20, 22, 23, 24,
                                25, 26, 27, 29, 31, 34, 38, 41, 45, 47, 49, 50, 50, 50, 49, 49, 49, 48, 48, 48, 49, 51,
                                55, 60, 65, 70, 75, 79, 83, 87, 92, 96, 101, 105, 108, 112, 115, 118, 121, 123, 126,
                                -127, -125, -122, -119, -116, -113, -110, -107, -104, -101, -98, -95, -91, -87, -83,
                                -79, -76, -73, -70, -68, -66, -64, -62, -60, -59, -57, -55, -53, -51, -49, -47, -45,
                                -43, -41, -39, -37, -36, -34, -33, -31, -30, -29, -27, -25, -24, -22, -20, -18, -17,
                                -15, -14, -13, -11, -10, -9, -8, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
                                -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5,
                                -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
                                -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
                                -5, -5, -5, -5, -6, -7, -8, -9, -10, -12, -13, -14, -16, -17, -19, -20, -22, -24, -26,
                                -28, -30, -32, -34, -36, -38, -41 };

                byte[] greens = new byte[] { -100, -99, -98, -97, -96, -95, -93, -92, -91, -90, -88, -87, -85, -84, -83,
                                -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -70, -69, -68, -67, -67,
                                -66, -65, -64, -63, -62, -61, -61, -60, -60, -60, -60, -61, -61, -61, -62, -62, -63,
                                -64, -65, -66, -67, -68, -69, -71, -72, -73, -75, -77, -78, -80, -82, -84, -85, -86,
                                -87, -88, -89, -90, -91, -93, -94, -96, -97, -99, -101, -103, -105, -108, -110, -112,
                                -115, -118, -120, -123, -126, 127, 125, 123, 120, 118, 116, 113, 111, 109, 107, 105,
                                103, 101, 100, 98, 96, 95, 93, 91, 89, 87, 85, 84, 82, 81, 81, 81, 82, 82, 83, 84, 85,
                                86, 87, 88, 88, 89, 90, 90, 91, 91, 92, 93, 93, 94, 95, 96, 96, 97, 97, 97, 97, 97, 96,
                                96, 96, 95, 95, 95, 94, 94, 94, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
                                92, 92, 91, 91, 90, 90, 90, 89, 89, 88, 87, 87, 86, 85, 84, 82, 79, 77, 75, 72, 70, 69,
                                68, 67, 67, 66, 66, 65, 65, 64, 63, 62, 61, 59, 58, 56, 55, 54, 53, 52, 51, 51, 50, 49,
                                48, 47, 46, 45, 43, 42, 40, 38, 37, 35, 33, 31, 29, 27, 25, 23, 21, 19, 17, 14, 10, 7,
                                4, 2, 1, 0, 0, 1, 1, 2, 3, 3, 4, 4, 4, 4, 3, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0 };

                byte[] blues = new byte[] { -116, -115, -115, -114, -113, -112, -111, -110, -109, -108, -107, -105,
                                -104, -102, -101, -99, -98, -97, -96, -95, -94, -92, -92, -91, -90, -89, -89, -88, -88,
                                -87, -87, -87, -86, -85, -85, -84, -84, -83, -82, -81, -80, -78, -74, -70, -64, -59,
                                -54, -50, -47, -45, -44, -42, -41, -40, -39, -37, -36, -34, -32, -30, -27, -25, -24,
                                -22, -22, -22, -23, -25, -26, -28, -30, -31, -31, -31, -30, -28, -27, -25, -23, -21,
                                -20, -19, -17, -16, -14, -13, -12, -11, -10, -9, -9, -8, -7, -7, -7, -6, -6, -6, -6, -5,
                                -5, -5, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
                                -6, -7, -8, -8, -9, -10, -11, -12, -14, -17, -19, -22, -24, -25, -26, -26, -26, -26,
                                -26, -26, -26, -26, -26, -26, -27, -28, -29, -30, -31, -33, -34, -36, -38, -40, -43,
                                -46, -48, -51, -54, -57, -59, -62, -65, -68, -71, -74, -76, -78, -80, -83, -85, -87,
                                -89, -91, -93, -95, -98, -101, -103, -106, -109, -111, -114, -117, -119, -122, -124,
                                -127, 127, 125, 123, 122, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109,
                                108, 107, 106, 105, 103, 102, 100, 99, 97, 95, 94, 93, 92, 90, 89, 88, 87, 86, 84, 82,
                                80, 78, 76, 73, 70, 67, 64, 60, 54, 48, 42, 36, 31, 27, 26, 26, 26, 26, 26, 26, 26, 27,
                                27, 27, 28, 29, 29, 30, 31, 33 };

                return new LUT(reds, greens, blues);

        }

        public static LUT BlackIce() {
                byte[] reds = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 5, 8, 11, 14, 17, 19, 20, 22, 23, 24,
                                25, 26, 27, 29, 31, 34, 38, 41, 45, 47, 49, 50, 50, 50, 49, 49, 49, 48, 48, 48, 49, 51,
                                55, 60, 65, 70, 75, 79, 83, 87, 92, 96, 101, 105, 108, 112, 115, 118, 121, 123, 126,
                                -127, -125, -122, -119, -116, -113, -110, -107, -104, -101, -98, -95, -91, -87, -83,
                                -79, -76, -73, -70, -68, -66, -64, -62, -60, -59, -57, -55, -53, -51, -49, -47, -45,
                                -43, -41, -39, -37, -36, -34, -33, -31, -30, -29, -27, -25, -24, -22, -20, -18, -17,
                                -15, -14, -13, -11, -10, -9, -8, -7, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
                                -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5,
                                -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
                                -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -5, -5, -5, -5, -5, -5, -5, -5, -5, -5,
                                -5, -5, -5, -5, -6, -7, -8, -9, -10, -12, -13, -14, -16, -17, -19, -20, -22, -24, -26,
                                -28, -30, -32, -34, -36, -38, -41 };

                byte[] greens = new byte[] { 0, -99, -98, -97, -96, -95, -93, -92, -91, -90, -88, -87, -85, -84, -83,
                                -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -70, -69, -68, -67, -67,
                                -66, -65, -64, -63, -62, -61, -61, -60, -60, -60, -60, -61, -61, -61, -62, -62, -63,
                                -64, -65, -66, -67, -68, -69, -71, -72, -73, -75, -77, -78, -80, -82, -84, -85, -86,
                                -87, -88, -89, -90, -91, -93, -94, -96, -97, -99, -101, -103, -105, -108, -110, -112,
                                -115, -118, -120, -123, -126, 127, 125, 123, 120, 118, 116, 113, 111, 109, 107, 105,
                                103, 101, 100, 98, 96, 95, 93, 91, 89, 87, 85, 84, 82, 81, 81, 81, 82, 82, 83, 84, 85,
                                86, 87, 88, 88, 89, 90, 90, 91, 91, 92, 93, 93, 94, 95, 96, 96, 97, 97, 97, 97, 97, 96,
                                96, 96, 95, 95, 95, 94, 94, 94, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93, 93,
                                92, 92, 91, 91, 90, 90, 90, 89, 89, 88, 87, 87, 86, 85, 84, 82, 79, 77, 75, 72, 70, 69,
                                68, 67, 67, 66, 66, 65, 65, 64, 63, 62, 61, 59, 58, 56, 55, 54, 53, 52, 51, 51, 50, 49,
                                48, 47, 46, 45, 43, 42, 40, 38, 37, 35, 33, 31, 29, 27, 25, 23, 21, 19, 17, 14, 10, 7,
                                4, 2, 1, 0, 0, 1, 1, 2, 3, 3, 4, 4, 4, 4, 3, 3, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0 };

                byte[] blues = new byte[] { 0, -115, -115, -114, -113, -112, -111, -110, -109, -108, -107, -105, -104,
                                -102, -101, -99, -98, -97, -96, -95, -94, -92, -92, -91, -90, -89, -89, -88, -88, -87,
                                -87, -87, -86, -85, -85, -84, -84, -83, -82, -81, -80, -78, -74, -70, -64, -59, -54,
                                -50, -47, -45, -44, -42, -41, -40, -39, -37, -36, -34, -32, -30, -27, -25, -24, -22,
                                -22, -22, -23, -25, -26, -28, -30, -31, -31, -31, -30, -28, -27, -25, -23, -21, -20,
                                -19, -17, -16, -14, -13, -12, -11, -10, -9, -9, -8, -7, -7, -7, -6, -6, -6, -6, -5, -5,
                                -5, -5, -5, -5, -5, -5, -5, -5, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6,
                                -7, -8, -8, -9, -10, -11, -12, -14, -17, -19, -22, -24, -25, -26, -26, -26, -26, -26,
                                -26, -26, -26, -26, -26, -27, -28, -29, -30, -31, -33, -34, -36, -38, -40, -43, -46,
                                -48, -51, -54, -57, -59, -62, -65, -68, -71, -74, -76, -78, -80, -83, -85, -87, -89,
                                -91, -93, -95, -98, -101, -103, -106, -109, -111, -114, -117, -119, -122, -124, -127,
                                127, 125, 123, 122, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108,
                                107, 106, 105, 103, 102, 100, 99, 97, 95, 94, 93, 92, 90, 89, 88, 87, 86, 84, 82, 80,
                                78, 76, 73, 70, 67, 64, 60, 54, 48, 42, 36, 31, 27, 26, 26, 26, 26, 26, 26, 26, 27, 27,
                                27, 28, 29, 29, 30, 31, 33 };

                return new LUT(reds, greens, blues);

        }

        public static LUT Spectrum() {
                byte[] reds = new byte[] { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -4, -10, -16, -22, -28, -34, -40, -46, -52, -58, -64, -70, -76, -82, -88, -94,
                                -100, -106, -112, -118, -124, 126, 120, 114, 108, 102, 96, 90, 84, 78, 72, 66, 60, 54,
                                48, 42, 36, 30, 24, 18, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90,
                                96, 102, 108, 114, 120, 126, -124, -118, -112, -106, -100, -94, -88, -82, -76, -70, -64,
                                -58, -52, -46, -40, -34, -28, -22, -16, -10, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] greens = new byte[] { 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96, 102, 108,
                                114, 120, 126, -124, -118, -112, -106, -100, -94, -88, -82, -76, -70, -64, -58, -52,
                                -46, -40, -34, -28, -22, -16, -10, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -4, -10, -16, -22, -28, -34, -40, -46, -52, -58, -64, -70,
                                -76, -82, -88, -94, -100, -106, -112, -118, -124, 126, 120, 114, 108, 102, 96, 90, 84,
                                78, 72, 66, 60, 54, 48, 42, 36, 30, 24, 18, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

                byte[] blues = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96, 102, 108, 114,
                                120, 126, -124, -118, -112, -106, -100, -94, -88, -82, -76, -70, -64, -58, -52, -46,
                                -40, -34, -28, -22, -16, -10, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -4, -10, -16, -22, -28, -34, -40, -46, -52, -58, -64, -70, -76,
                                -82, -88, -94, -100, -106, -112, -118, -124, 126, 120, 114, 108, 102, 96, 90, 84, 78,
                                72, 66, 60, 54, 48, 42, 36, 30, 24, 18, 12, 6, 0 };

                return new LUT(reds, greens, blues);
        }

        public static LUT BlackSpectrum() {
                byte[] reds = new byte[] { 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -4, -10, -16, -22, -28, -34, -40, -46, -52, -58, -64, -70, -76, -82, -88, -94,
                                -100, -106, -112, -118, -124, 126, 120, 114, 108, 102, 96, 90, 84, 78, 72, 66, 60, 54,
                                48, 42, 36, 30, 24, 18, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90,
                                96, 102, 108, 114, 120, 126, -124, -118, -112, -106, -100, -94, -88, -82, -76, -70, -64,
                                -58, -52, -46, -40, -34, -28, -22, -16, -10, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] greens = new byte[] { 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96, 102, 108,
                                114, 120, 126, -124, -118, -112, -106, -100, -94, -88, -82, -76, -70, -64, -58, -52,
                                -46, -40, -34, -28, -22, -16, -10, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -4, -10, -16, -22, -28, -34, -40, -46, -52, -58, -64, -70,
                                -76, -82, -88, -94, -100, -106, -112, -118, -124, 126, 120, 114, 108, 102, 96, 90, 84,
                                78, 72, 66, 60, 54, 48, 42, 36, 30, 24, 18, 12, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

                byte[] blues = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 6, 12, 18, 24, 30, 36, 42, 48, 54, 60, 66, 72, 78, 84, 90, 96, 102, 108, 114,
                                120, 126, -124, -118, -112, -106, -100, -94, -88, -82, -76, -70, -64, -58, -52, -46,
                                -40, -34, -28, -22, -16, -10, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -4, -10, -16, -22, -28, -34, -40, -46, -52, -58, -64, -70, -76,
                                -82, -88, -94, -100, -106, -112, -118, -124, 126, 120, 114, 108, 102, 96, 90, 84, 78,
                                72, 66, 60, 54, 48, 42, 36, 30, 24, 18, 12, 6, 0 };

                return new LUT(reds, greens, blues);
        }

        public static LUT GreyFire() {
                byte[] reds = new byte[] { 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 7, 10, 13, 16, 19,
                                22, 25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85,
                                88, 91, 94, 98, 101, 104, 107, 110, 113, 116, 119, 122, 125, 127, -125, -122, -119,
                                -116, -113, -110, -108, -106, -104, -102, -100, -98, -96, -94, -93, -92, -90, -89, -88,
                                -86, -85, -83, -82, -81, -79, -78, -77, -75, -74, -72, -71, -70, -68, -67, -66, -64,
                                -63, -61, -60, -58, -57, -55, -54, -52, -51, -49, -48, -47, -46, -44, -43, -42, -41,
                                -39, -38, -36, -35, -33, -32, -30, -29, -27, -26, -25, -23, -22, -21, -19, -18, -16,
                                -15, -13, -12, -10, -9, -7, -6, -4, -4, -4, -3, -3, -3, -2, -2, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] greens = new byte[] { 127, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 7, 8, 10, 12, 14, 16, 19, 21, 24,
                                27, 29, 32, 35, 37, 40, 43, 46, 48, 51, 54, 57, 59, 62, 65, 68, 70, 73, 76, 79, 81, 84,
                                87, 90, 92, 95, 98, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125,
                                127, -127, -125, -123, -122, -120, -118, -116, -115, -113, -111, -109, -108, -106, -104,
                                -102, -101, -99, -97, -95, -94, -92, -90, -88, -87, -85, -83, -81, -80, -78, -76, -74,
                                -72, -70, -68, -66, -65, -63, -61, -59, -57, -55, -53, -51, -50, -48, -46, -44, -43,
                                -41, -39, -37, -36, -34, -32, -30, -28, -26, -24, -22, -21, -19, -17, -15, -14, -12,
                                -10, -8, -8, -7, -6, -5, -4, -3, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] blues = new byte[] { 127, 7, 15, 22, 30, 38, 45, 53, 61, 65, 69, 74, 78, 82, 87, 91, 96, 100,
                                104, 108, 113, 117, 121, 125, -126, -122, -118, -113, -109, -105, -100, -96, -91, -88,
                                -85, -81, -78, -75, -71, -68, -64, -61, -57, -54, -50, -47, -43, -40, -36, -36, -35,
                                -34, -33, -32, -31, -30, -29, -32, -34, -36, -38, -40, -42, -44, -46, -50, -54, -57,
                                -61, -65, -68, -72, -75, -79, -83, -87, -90, -94, -98, -102, -105, -109, -113, -116,
                                -120, -124, -127, 125, 122, 118, 114, 111, 107, 103, 100, 96, 93, 89, 85, 82, 78, 74,
                                71, 67, 64, 60, 56, 53, 49, 45, 42, 38, 35, 31, 27, 23, 20, 16, 12, 8, 5, 4, 3, 3, 2, 1,
                                1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 13, 17,
                                21, 26, 30, 35, 42, 50, 58, 66, 74, 82, 90, 98, 105, 113, 121, -127, -120, -112, -104,
                                -96, -89, -81, -73, -65, -57, -49, -41, -33, -29, -25, -21, -17, -13, -9, -5, -1, -1,
                                -1, -1, -1, -1, -1, -1 };

                return new LUT(reds, greens, blues);
        }

        public static LUT BlackFire() {
                byte[] reds = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 7, 10, 13, 16, 19, 22,
                                25, 28, 31, 34, 37, 40, 43, 46, 49, 52, 55, 58, 61, 64, 67, 70, 73, 76, 79, 82, 85, 88,
                                91, 94, 98, 101, 104, 107, 110, 113, 116, 119, 122, 125, 127, -125, -122, -119, -116,
                                -113, -110, -108, -106, -104, -102, -100, -98, -96, -94, -93, -92, -90, -89, -88, -86,
                                -85, -83, -82, -81, -79, -78, -77, -75, -74, -72, -71, -70, -68, -67, -66, -64, -63,
                                -61, -60, -58, -57, -55, -54, -52, -51, -49, -48, -47, -46, -44, -43, -42, -41, -39,
                                -38, -36, -35, -33, -32, -30, -29, -27, -26, -25, -23, -22, -21, -19, -18, -16, -15,
                                -13, -12, -10, -9, -7, -6, -4, -4, -4, -3, -3, -3, -2, -2, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] greens = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 5, 7, 8, 10, 12, 14, 16, 19, 21, 24, 27,
                                29, 32, 35, 37, 40, 43, 46, 48, 51, 54, 57, 59, 62, 65, 68, 70, 73, 76, 79, 81, 84, 87,
                                90, 92, 95, 98, 101, 103, 105, 107, 109, 111, 113, 115, 117, 119, 121, 123, 125, 127,
                                -127, -125, -123, -122, -120, -118, -116, -115, -113, -111, -109, -108, -106, -104,
                                -102, -101, -99, -97, -95, -94, -92, -90, -88, -87, -85, -83, -81, -80, -78, -76, -74,
                                -72, -70, -68, -66, -65, -63, -61, -59, -57, -55, -53, -51, -50, -48, -46, -44, -43,
                                -41, -39, -37, -36, -34, -32, -30, -28, -26, -24, -22, -21, -19, -17, -15, -14, -12,
                                -10, -8, -8, -7, -6, -5, -4, -3, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] blues = new byte[] { 0, 7, 15, 22, 30, 38, 45, 53, 61, 65, 69, 74, 78, 82, 87, 91, 96, 100, 104,
                                108, 113, 117, 121, 125, -126, -122, -118, -113, -109, -105, -100, -96, -91, -88, -85,
                                -81, -78, -75, -71, -68, -64, -61, -57, -54, -50, -47, -43, -40, -36, -36, -35, -34,
                                -33, -32, -31, -30, -29, -32, -34, -36, -38, -40, -42, -44, -46, -50, -54, -57, -61,
                                -65, -68, -72, -75, -79, -83, -87, -90, -94, -98, -102, -105, -109, -113, -116, -120,
                                -124, -127, 125, 122, 118, 114, 111, 107, 103, 100, 96, 93, 89, 85, 82, 78, 74, 71, 67,
                                64, 60, 56, 53, 49, 45, 42, 38, 35, 31, 27, 23, 20, 16, 12, 8, 5, 4, 3, 3, 2, 1, 1, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 13, 17, 21,
                                26, 30, 35, 42, 50, 58, 66, 74, 82, 90, 98, 105, 113, 121, -127, -120, -112, -104, -96,
                                -89, -81, -73, -65, -57, -49, -41, -33, -29, -25, -21, -17, -13, -9, -5, -1, -1, -1, -1,
                                -1, -1, -1, -1 };

                return new LUT(reds, greens, blues);

        }

        public static LUT Thermal() {
                byte[] reds = new byte[] { 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
                                70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 69, 69,
                                68, 67, 66, 64, 63, 61, 59, 57, 55, 53, 51, 48, 45, 43, 40, 37, 34, 31, 28, 26, 23, 20,
                                17, 14, 12, 9, 6, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 7, 11, 16, 21, 27,
                                32, 39, 45, 52, 60, 68, 76, 84, 92, 101, 109, 117, 126, -122, -113, -104, -96, -88, -80,
                                -72, -64, -57, -50, -43, -37, -31, -25, -20, -16, -12, -9, -6, -4, -3, -2, -2, -3, -4,
                                -5, -7, -10, -13, -16, -19, -23, -28, -33, -37, -42, -48, -53, -60, -66, -72, -78, -85,
                                -91, -98, -105, -112, -118, -127, 120, 112, 103, 95, 87, 79, 71, 64, 57, 51, 45, 39, 35,
                                30, 27, 24, 21, 20, 19, 19, 21, 23, 27, 32, 37, 44, 51, 59, 68, 77, 86, 97, 107, 118,
                                125, -125, -119, -112, -106, -100, -94, -88, -82, -76, -71, -65, -59, -54, -49, -44,
                                -39, -34, -29, -25, -21, -18, -14, -11, -8, -5, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] greens = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 9, 13, 17, 22, 27, 32, 38, 44,
                                50, 57, 63, 70, 77, 84, 91, 98, 106, 113, 121, 127, -120, -112, -104, -96, -88, -80,
                                -73, -65, -58, -51, -44, -38, -32, -26, -21, -16, -11, -7, -3, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
                                -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,
                                -2, -4, -4, -6, -7, -8, -10, -11, -13, -15, -17, -19, -21, -23, -27, -30, -34, -38, -43,
                                -48, -53, -58, -64, -69, -75, -81, -87, -94, -100, -107, -113, -120, -127, 122, 116,
                                109, 102, 95, 89, 82, 76, 70, 63, 57, 51, 45, 40, 35, 29, 25, 20, 16, 12, 8, 5, 2, 2 };

                byte[] blues = new byte[] { 114, 115, 116, 118, 120, 122, 124, 126, 127, -125, -123, -120, -117, -115,
                                -112, -109, -105, -102, -99, -96, -92, -89, -86, -82, -79, -75, -72, -68, -62, -56, -50,
                                -45, -39, -34, -29, -24, -20, -16, -12, -8, -5, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -3, -4, -5, -6, -8, -9, -10, -11, -13, -14,
                                -15, -16, -17, -18, -19, -20, -21, -21, -21, -22, -22, -22, -22, -22, -21, -20, -19,
                                -18, -17, -16, -15, -13, -12, -10, -9, -7, -6, -4, -3, -2, -2, -2, -2, -2, -2, -2, -2,
                                -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -4, -7, -10, -13, -17,
                                -20, -25, -29, -33, -38, -43, -48, -53, -58, -64, -69, -75, -81, -87, -93, -99, -105,
                                -111, -118, -124, 126, 118, 110, 102, 94, 87, 79, 72, 65, 58, 51, 45, 38, 32, 27, 22,
                                17, 13, 8, 5, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 5, 8, 10, 12, 14, 16, 17, 19,
                                21, 23, 25, 26, 28, 30, 31, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 43, 43, 44, 44, 44,
                                44, 43, 43, 42, 42, 41, 40, 40, 39, 38, 37, 36, 34, 33, 32, 31, 30, 28, 27, 25, 24, 23,
                                21, 20, 19, 17, 16, 15, 13, 12, 11, 10, 9, 7, 6, 6, 5, 4, 3, 3, 2, 2 };

                return new LUT(reds, greens, blues);
        }

        public static LUT BlackThermal() {
                byte[] reds = new byte[] { 0, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
                                70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 69, 69,
                                68, 67, 66, 64, 63, 61, 59, 57, 55, 53, 51, 48, 45, 43, 40, 37, 34, 31, 28, 26, 23, 20,
                                17, 14, 12, 9, 6, 4, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 4, 7, 11, 16, 21, 27,
                                32, 39, 45, 52, 60, 68, 76, 84, 92, 101, 109, 117, 126, -122, -113, -104, -96, -88, -80,
                                -72, -64, -57, -50, -43, -37, -31, -25, -20, -16, -12, -9, -6, -4, -3, -2, -2, -3, -4,
                                -5, -7, -10, -13, -16, -19, -23, -28, -33, -37, -42, -48, -53, -60, -66, -72, -78, -85,
                                -91, -98, -105, -112, -118, -127, 120, 112, 103, 95, 87, 79, 71, 64, 57, 51, 45, 39, 35,
                                30, 27, 24, 21, 20, 19, 19, 21, 23, 27, 32, 37, 44, 51, 59, 68, 77, 86, 97, 107, 118,
                                125, -125, -119, -112, -106, -100, -94, -88, -82, -76, -71, -65, -59, -54, -49, -44,
                                -39, -34, -29, -25, -21, -18, -14, -11, -8, -5, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 };

                byte[] greens = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 5, 9, 13, 17, 22, 27, 32, 38, 44,
                                50, 57, 63, 70, 77, 84, 91, 98, 106, 113, 121, 127, -120, -112, -104, -96, -88, -80,
                                -73, -65, -58, -51, -44, -38, -32, -26, -21, -16, -11, -7, -3, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
                                -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2,
                                -2, -4, -4, -6, -7, -8, -10, -11, -13, -15, -17, -19, -21, -23, -27, -30, -34, -38, -43,
                                -48, -53, -58, -64, -69, -75, -81, -87, -94, -100, -107, -113, -120, -127, 122, 116,
                                109, 102, 95, 89, 82, 76, 70, 63, 57, 51, 45, 40, 35, 29, 25, 20, 16, 12, 8, 5, 2, 2 };

                byte[] blues = new byte[] { 0, 115, 116, 118, 120, 122, 124, 126, 127, -125, -123, -120, -117, -115,
                                -112, -109, -105, -102, -99, -96, -92, -89, -86, -82, -79, -75, -72, -68, -62, -56, -50,
                                -45, -39, -34, -29, -24, -20, -16, -12, -8, -5, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -3, -4, -5, -6, -8, -9, -10, -11, -13, -14,
                                -15, -16, -17, -18, -19, -20, -21, -21, -21, -22, -22, -22, -22, -22, -21, -20, -19,
                                -18, -17, -16, -15, -13, -12, -10, -9, -7, -6, -4, -3, -2, -2, -2, -2, -2, -2, -2, -2,
                                -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -4, -7, -10, -13, -17,
                                -20, -25, -29, -33, -38, -43, -48, -53, -58, -64, -69, -75, -81, -87, -93, -99, -105,
                                -111, -118, -124, 126, 118, 110, 102, 94, 87, 79, 72, 65, 58, 51, 45, 38, 32, 27, 22,
                                17, 13, 8, 5, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 5, 8, 10, 12, 14, 16, 17, 19,
                                21, 23, 25, 26, 28, 30, 31, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 43, 43, 44, 44, 44,
                                44, 43, 43, 42, 42, 41, 40, 40, 39, 38, 37, 36, 34, 33, 32, 31, 30, 28, 27, 25, 24, 23,
                                21, 20, 19, 17, 16, 15, 13, 12, 11, 10, 9, 7, 6, 6, 5, 4, 3, 3, 2, 2 };

                return new LUT(reds, greens, blues);
        }

        public static LUT HiLo() {
                byte[] reds = new byte[] { 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, -128 };

                byte[] greens = new byte[] { -128, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, -128 };

                byte[] blues = new byte[] { -128, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127,
                                127, 127, 127 };

                return new LUT(reds, greens, blues);

        }

        public static LUT Grey() {
                byte[] reds = new byte[] { -128, -127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116,
                                -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102,
                                -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85,
                                -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68,
                                -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51,
                                -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34,
                                -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17,
                                -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5,
                                6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28,
                                29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50,
                                51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72,
                                73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94,
                                95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,
                                113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127 };

                return new LUT(reds, reds, reds);

        }

        public static LUT Physics() {

                byte[] reds = new byte[] { 47, 46, 45, 44, 42, 41, 40, 39, 37, 36, 35, 33, 32, 30, 29, 27, 26, 24, 23,
                                21, 19, 18, 16, 14, 12, 10, 9, 7, 5, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 3, 4, 5,
                                6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26,
                                26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 25, 25,
                                25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
                                24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 23, 23, 23, 23, 23,
                                23, 23, 23, 23, 23, 23, 23, 23, 22, 22, 22, 27, 32, 37, 42, 48, 53, 58, 63, 69, 74, 79,
                                85, 90, 96, 101, 107, 112, 118, 123, -127, -122, -116, -111, -108, -105, -103, -100,
                                -97, -95, -92, -90, -87, -84, -82, -79, -76, -74, -71, -68, -66, -63, -60, -58, -55,
                                -52, -50, -46, -43, -40, -36, -34, -34, -34, -34, -34, -33, -33, -33, -33, -33, -33,
                                -32, -32, -32, -32, -32, -31, -31, -31, -31, -31, -31, -30, -30, -30, -30, -30, -29,
                                -29, -29, -29, -29, -28, -28, -28, -28, -28, -28, -27, -27, -27, -27, -27, -26, -26,
                                -26, -26, -26, -26, -25, -25, -25, -25, -25, -24, -24, -24, -24, -24, -23 };

                byte[] greens = new byte[] { 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                                1, 0, 0, 0, 0, 0, 1, 3, 5, 7, 9, 11, 13, 15, 18, 20, 23, 26, 28, 31, 33, 36, 39, 41, 44,
                                47, 49, 52, 55, 58, 60, 63, 66, 69, 71, 74, 77, 80, 82, 85, 88, 91, 94, 96, 99, 102,
                                105, 108, 111, 114, 116, 119, 122, 125, -128, -125, -122, -119, -116, -113, -110, -107,
                                -104, -101, -98, -95, -92, -89, -86, -83, -80, -77, -74, -71, -68, -65, -62, -58, -58,
                                -58, -58, -58, -57, -57, -57, -57, -57, -56, -56, -56, -56, -56, -55, -55, -55, -55,
                                -54, -54, -54, -53, -53, -53, -52, -52, -52, -51, -51, -51, -50, -50, -50, -49, -49,
                                -49, -48, -48, -48, -47, -47, -47, -46, -46, -46, -45, -45, -45, -44, -44, -44, -43,
                                -43, -43, -42, -42, -42, -41, -41, -41, -40, -40, -40, -39, -39, -39, -39, -39, -38,
                                -38, -38, -38, -38, -38, -37, -37, -37, -37, -37, -37, -37, -36, -36, -36, -36, -36,
                                -36, -35, -35, -35, -35, -35, -35, -36, -39, -42, -44, -47, -50, -53, -56, -59, -62,
                                -65, -68, -71, -74, -78, -81, -84, -87, -90, -93, -96, -99, -102, -105, -108, -111,
                                -115, -118, -121, -124, -127, 126, 122, 119, 116, 113, 110, 106, 103, 100, 97, 94, 90,
                                87, 84, 80, 77, 74, 71, 67, 64, 61, 57, 54, 51, 47, 44, 41, 37, 34 };

                byte[] blues = new byte[] { 119, 120, 122, 123, 124, 125, 126, 127, -128, -127, -125, -124, -123, -122,
                                -121, -120, -119, -118, -117, -115, -114, -113, -112, -111, -110, -109, -108, -107,
                                -105, -104, -103, -102, -101, -100, -99, -98, -96, -95, -94, -93, -92, -91, -90, -89,
                                -88, -87, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73,
                                -72, -71, -70, -69, -68, -67, -66, -65, -65, -65, -65, -64, -64, -64, -64, -64, -63,
                                -63, -63, -63, -63, -62, -62, -62, -62, -62, -61, -61, -61, -61, -61, -60, -60, -60,
                                -60, -60, -59, -59, -59, -59, -59, -58, -61, -64, -66, -69, -72, -75, -78, -80, -83,
                                -86, -89, -91, -94, -97, -100, -103, -106, -108, -113, -118, -123, -127, 124, 119, 114,
                                109, 104, 99, 94, 89, 84, 79, 74, 69, 64, 59, 54, 49, 44, 39, 33, 28, 23, 22, 22, 22,
                                22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20,
                                20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 19, 19, 19, 19, 19,
                                19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 18, 18, 18, 18, 18, 18, 18,
                                18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17,
                                17, 17, 17, 17, 17, 17, 17, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16 };

                return new LUT(reds, greens, blues);

        }

        public static LUT Jet() {
                byte[] reds = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52,
                                56, 60, 64, 68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, -128,
                                -125, -121, -117, -113, -109, -105, -101, -97, -93, -89, -85, -81, -77, -73, -69, -65,
                                -61, -57, -53, -49, -45, -41, -37, -33, -29, -25, -21, -17, -13, -9, -5, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5, -9, -13, -17,
                                -21, -25, -29, -33, -37, -41, -45, -49, -53, -57, -61, -65, -69, -73, -77, -81, -85,
                                -89, -93, -97, -101, -105, -109, -113, -117, -121, -125 };

                byte[] greens = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 4, 8, 12, 16, 20, 24, 28, 32, 36, 40, 44, 48, 52, 56, 60, 64,
                                68, 72, 76, 80, 84, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, -128, -125, -121,
                                -117, -113, -109, -105, -101, -97, -93, -89, -85, -81, -77, -73, -69, -65, -61, -57,
                                -53, -49, -45, -41, -37, -33, -29, -25, -21, -17, -13, -9, -5, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5, -9, -13, -17, -21, -25,
                                -29, -33, -37, -41, -45, -49, -53, -57, -61, -65, -69, -73, -77, -81, -85, -89, -93,
                                -97, -101, -105, -109, -113, -117, -121, -125, -128, 124, 120, 116, 112, 108, 104, 100,
                                96, 92, 88, 84, 80, 76, 72, 68, 64, 60, 56, 52, 48, 44, 40, 36, 32, 28, 24, 20, 16, 12,
                                8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0 };

                byte[] blues = new byte[] { -128, -125, -121, -117, -113, -109, -105, -101, -97, -93, -89, -85, -81,
                                -77, -73, -69, -65, -61, -57, -53, -49, -45, -41, -37, -33, -29, -25, -21, -17, -13, -9,
                                -5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
                                -5, -9, -13, -17, -21, -25, -29, -33, -37, -41, -45, -49, -53, -57, -61, -65, -69, -73,
                                -77, -81, -85, -89, -93, -97, -101, -105, -109, -113, -117, -121, -125, -128, 124, 120,
                                116, 112, 108, 104, 100, 96, 92, 88, 84, 80, 76, 72, 68, 64, 60, 56, 52, 48, 44, 40, 36,
                                32, 28, 24, 20, 16, 12, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

                return new LUT(reds, greens, blues);

        }

        public static LUT Random(boolean blackBackground) {
                Random random = new Random(randomSeed);

                byte[] r = new byte[256];
                byte[] g = new byte[256];
                byte[] b = new byte[256];

                random.nextBytes(r);
                random.nextBytes(g);
                random.nextBytes(b);

                if (blackBackground)
                        r[0] = g[0] = b[0] = 0;
                else
                        r[0] = g[0] = b[0] = 127;

                return new LUT(8, 256, r, g, b);

        }

        public static LUT Random(boolean blackBackground, boolean regenerate) {
                if (random == null || regenerate)
                        random = Random(blackBackground);

                return random;

        }

        public static LUT RandomVibrant(boolean blackBackground) {
                Random random = new Random(randomSeed);

                byte[] r = new byte[256];
                byte[] g = new byte[256];
                byte[] b = new byte[256];

                for (int i=0;i<256;i++) {
                        Color colour = Color.getHSBColor(random.nextFloat(), 1, 1);
                        r[i] = (byte) colour.getRed();
                        g[i] = (byte) colour.getGreen();
                        b[i] = (byte) colour.getBlue();
                }
                
                if (blackBackground)
                        r[0] = g[0] = b[0] = 0;
                else
                        r[0] = g[0] = b[0] = 127;
                
                return new LUT(8, 256, r, g, b);

        }

        public static LUT RandomVibrant(boolean blackBackground, boolean regenerate) {
                if (randomVibrant == null || regenerate)
                        randomVibrant = RandomVibrant(blackBackground);

                return randomVibrant;

        }
}