"""
This script rewrites the filelist.rst file autogenerated by breathe to organize
the files in the documentation's API into the same directory structure as their
counterparts in the ../Source directory.

Note that we assume here that there is only one level of subdirectories in the
../Source directory and that all the files we want to document are in those
subdirectories (i.e. not in subdirectories of those). If this is not the case,
then you may want to use os.walk(..) rather than os.listdir(..).

We are also not going to include cpp files - doxygen assumes that functions are
documented in the header files, so that's what we'll assume here as well.
"""

import os
import re

# directory of the source files
rootdir = "../Source"

filelist_path = "source/filelist.rst"


def strip_directives(filename, filepath, outpath):
    """
    Read in file, remove all preprocessor directives and output
    """

    r = re.compile(r"^#.*$\n")

    with open(os.path.join(filepath, filename)) as infile:
        txt = infile.read()

        outtxt = re.sub(r, '', txt)

        with open(os.path.join(outpath, filename), 'w') as outfile:
            outfile.write(outtxt)