#ifndef MY_TEST_H_
#define MY_TEST_H_

#include <AMReX_EBFabFactory.H>
#include <AMReX_MLMG.H>
#include <AMReX_Array.H>

class MyTest
{
public:

    MyTest ();

    void solve ();
    void initData ();

private:

    void initializeEB ();
    void readParameters ();
    void initGrids ();

    int max_level = 0;
    int ref_ratio = 2;
    int n_cell = 128;
    int max_grid_size = 64;

    // For MLMG solver
    int verbose = 2;
    int bottom_verbose = 2;
    int max_iter = 100;
    int max_fmg_iter = 0;
    int max_bottom_iter = 1000;
    amrex::Real reltol        = 1.e-12;
    amrex::Real bottom_reltol = 1.e-4;
    int linop_maxorder = 3;
    int max_coarsening_level = 30;
    bool use_hypre = false;

    amrex::Vector<amrex::Geometry> geom;
    amrex::Vector<amrex::BoxArray> grids;
    amrex::Vector<amrex::DistributionMapping> dmap;
    amrex::Vector<std::unique_ptr<amrex::EBFArrayBoxFactory> > factory;

    amrex::Vector<amrex::MultiFab> phi;
    amrex::Vector<amrex::Array<amrex::MultiFab, AMREX_SPACEDIM>> flux;
    amrex::Vector<amrex::Array<amrex::MultiFab, AMREX_SPACEDIM>> grad;
    amrex::Vector<amrex::Array<amrex::fMultiFab, AMREX_SPACEDIM>> fgrad; // Used to test getGradSolution when MF is different from AMF
    amrex::Vector<amrex::MultiFab> rhs;
    amrex::Vector<amrex::MultiFab> acoef;
    amrex::Vector<amrex::Array<amrex::MultiFab,AMREX_SPACEDIM> > bcoef;

    amrex::Real ascalar = 0.0;
    amrex::Real bscalar = 1.0;
};

#endif
