# 25.11

 ## Highlights:

  * AMReX is now compatible with oneAPI 2025.03 that has deprecated a number
    of things such as the `fsycl-device-lib` flag and the
    `mkl::sparse::set_csr_data` function.

  * It used to be an assertion error when the number of ghost cells in the
    MultiFab is different from that in the VisMF file. We now allow them to
    be different. Note that if there are more ghost cells in the MultiFab,
    the extra ghost cell regions are not filled.

  * In `amrex::UtilCreateCleanDirectory`, if a directory already exists, we
    preserve it by renaming it to a directory whose name includes a string
    generated by `amrex::UniqueString()`. However, this string is not
    guaranteed to be unique. The behavior of `std::rename` is
    implementation-defined, and it may fail if the destination already
    exists. This happens rarely, but it does happen. We now addresse the
    issue by removing the existing conflicting directory before
    renaming. This makes the file renaming process more robust.

  * We have reimplemented SumBoundary. In the old approach, we make a
    temporary copy of the data, zero out the original data, and then perform
    parallel add. In the new approach that should be more efficient, we no
    longer need a temporary copy of the entire data. We have also added an
    optional argument that can be used to make SumBoundary
    deterministic. Note that being deterministic does not mean the data are
    consistent on shared nodes. For that, one still needs to call
    OverrideSync, or FillBounaryAndSync.

 ## Other major changes:

  * Allow C++20 HIP builds (#4739)

  * Make transposeCtoF asynchronous (#4738)

  * FFT hybrid Poisson solver: Add support for batched 2d solves (#4732)

  * Cray MPICH/ROCm compatibility for GPU-aware MPI (#4729)

  * Remove final on Fapply, Fsmooth, FFlux, normalize, supportNSolve (#4727)

  * Align fcompare behavior with particle_compare when metadata differ (#4724)

  * Robustify file renaming (#4721)

  * Allow std::string "name" arguments for ParmParse methods (#4695)

  * Add Build with Explicit Multi-Level Geometry for EB (#4714)

  * Add reserve methods to ParticleTile, ArrayOfStructs, and StructOfArrays (#4708)

  * Fix a bug in EB FillPatch for face MultiFab (#4705)

  * Improve usability of amrex::Gpu::Buffer (#4697)

  * Reduce::MinMax: fix function name (#4704)

  * OpenBC FFT Solver: Fix 2d mode bug (#4703)

  * Hypre & PETSc in 1d build (#4692)
    Allow hypre and petsc in 1d build (#4682)

# 25.10

 ## Highlights:

  * Add range-based for and ND to BoxIterator (#4668)

    The new capability allows a range-base for loop for iterating over
    Box. For example
    ```
        for (auto iv : box.iterator()) {
            // do operations involving iv
        }
    ```

  * `AMREX_ENUM`: Cache String Map (#4643)

    This provides significant performance improvement for AMREX_ENUM with a
    large number of values (e.g., > 70).

  * ParmParse: Add prettyPrintUsedInputs and prettyPrintUnusedInputs (#4652)

    This adds two new functions to ParmParse that can be very useful.

  * Fix for CUDA 13 (#4648)

    This makes AMReX compatible wtih CUDA 13.

 ## Other major changes:

  * GNU Make: Add new option DEBUG_OPT_LEVEL (#4674)

  * Add support for make flags to the build info script (#4672)

  * OpenBC FFT Solver: Fix a 2d mode bug. (#4671)

  * Remove no-op Fortran *_destroy blocks (#4666) (#4667)

  * Adding support to memory collection of Particles and MultiFabs within a
    grid (#4629)

  * Use `p.id().is_valid()` consistently (#4635)

  * Updated applyBC to use ParallelFor on Vector of tags for GPU builds
    (#4619)

  * AMReX Enum: Underlying Value (#4616)

  * Print out hypre version (#4650)

  * Curl Curl Solver: Support for 1D spherical and 1D cylindrical (#4611)

# 25.09

 ## Highlights:

  * amrex::callNoinline: Call given function without inline (#4606)

    This new function can be used to force noinlining functions. It can be
    useful when it's necessary to reduce GPU kernel sizes.

  * Incorrect cross term sum for 2D EB terms in MLEBTensor (#4626)

    This fixes a very old bug in the computation of the cross terms of the
    Navier-Stokes stress tensor in the 2D EB case. The bug affected AMReX
    based codes that use the MLEBTensor operator in linear solvers.

  * Add ParallelForOMP (#4595)
    Fix ParallelForOMP introduced in #4595 (#4604)

    amrex::ParallelFor in CPU builds does not spawn OpenMP threads, because
    it is usually used inside coarse-grained OpenMP regions launched at the
    MFIter level. However, in some cases, the users may need to start OpenMP
    parallel regions in the loops over cells. This new function has been
    added for this purpose.

  * Add ToString function for array and tuple (#4584)

    This adds a `ToString` function that can be used with scalars, arrays
    and tuples to write error messages or when debugging.

 ## Other major changes:

  * Delay some synchronize calls in addParticles (#4623)
    Fix a bug in #4623 (#4631)

  * Fix Bug in FaceConservativeLinear (#4630)

  * Generalize the average_*_to_cellcenter routines to take IntVect (#4627)

  * Fix atomicSetID wrapper access (#4625)

  * Fallback to default `CUDA_ARCH` if `nvidia-smi` fails (#4624)

  * Enable OpenMP in addParticles (#4615)

  * Fix potential false sharing in ReduceOps.eval with OMP (#4618)

  * Enable zero-sized Type in TypeMultiplier (#4617)

  * Add ParamParse::getPrefix (#4612)

  * SIMD: Portable Masks, C++20 (#4607)

  * Improve support for Particles with PolymorphicArenaAllocator (#4603)

  * Improvements to AMREX_ASSERT (#4581)

  * SIMD: Remove Unnecessary Namespaces (#4600)

  * Modify how we interpolate velocity from faces to particle position (#4598)

# 25.08

 ## Highlights:

  * EB anisotropic meshes - changes for cut_face_2d routine (#4554)
    EB anisotropic - set_eb_data changes (#4577)
    Correction to EB volume fraction for anisotropic grids (#4587)
    Correction to EB volume centroid for anisotropic case (#4586)

    These make the necessary changes for EB generation on 3D aniostropic
    meshes.

  * SUNDIALS interface updates (#4562)

    Major updates have been made to the SUNDIALS interface.

  * AMReX SIMD Helpers (#4520)

    AMReX does not have a concept yet to help users write effective SIMD
    code on CPU, besides relying on auto-vectorization and pragmas, which
    are unreliable for any complex enough code. This PR adds initial support
    for portable user-code by providing build system support and an
    `AMReX_SIMD.H` header that handles includes & helper types and
    functions.

  * CMake: `AMReX_FASTMATH` (#4545)
    CMake: `AMReX::Flags_FASTMATH` Interface Helper Target (#4591)

    Add new general compiler flag for fast-math optimizations. This does not
    change any defaults

  * Parser: Support comparison chain (#4556)

    Parser now supports comparison chain such as `a <= b <= c`.

 ## Other major changes:

  * CMake: Fix Typo `AMReX_COMPILER_DEFAULT_INLINE` (#4590)

  * Clean #ifdef around default RunOn declaration (#4580)

  * Account for metric term in fluxes due to inhomogeneous Neumann boundary conditions (#4579)

  * Replace `std::numeric_limits<>::infinity()` with `max()` (#4547)

  * Reorganize checkPoint logic into checkPointNow functions (#4567)

  * ParmParse: Remove two Aborts (#4576)

  * FFT Poisson Solver: Support domain not starting with 0 (#4573)

  * Fix Assert in `ReduceToPlaneMF` (#4566)

  * Retry a few times if directory creation fails (#4537)

  * Added GNU compile flags to enable -fPIC for llvm (#4553)

  * ParmParse: Add parser support for bool (#4552)

  * Remove an assertion in AmrLevel::RK (#4551)

  * Reduce use of SuperParticle (#4526)

  * Tweak CArena Defragmentation Strategy (#4531)

# 25.07

  ## Highlights:

  * Fix GPU communication for non-arithmetic types (#4515)

    Previously communication of non-arithmetic types for GPU builds did not
    work if there were race conditions. This has now been fixed.

  * Parallel Copy with Offset (#4510)

    Add new versions of ParallelCopy and ParallelAdd that effectively shift
    the source multifab first and then perform copy/add. Previously, one
    would need to use NonLocalBC::PareallelCopy, which has a relatively more
    complicated interface.

  * Add STLtools::fillSignedDistance (#4501)

    This adds a new approach for computing signed distances for STL files.

  ## Other major changes:

  * AMRErrorTag: Add PARSER (#4534)

  * Support Dirichlet BC in z-direction in hybrid FFT Poisson solver (#4503)

  * Add getInvalidRandomEngine() for CPU (#4528)

  * Spack Smoke Test: Fix HIP and Add SYCL (#4521)

  * Modernize roctx Annotations (#4523)

  * Add `AMReX_Order.H` (#4517)

  * EB: Move EB without regenerating geometry (#4511)

  * hypre with hip GNUmake improvements (#4514)

  * StateData: add new set functions (#4512)

  * Adding a new overload for MultiFab::norm2 (int comp, int numcomp) (#4509)

  * Delay gpu stream sync in MFIter (#4493)

  * Add paramters for controlling CArena defragmentation (#4479)

  * CMake: Need to set CUDA ARCH for plotfile tools (#4485)

  * Replaced depreciated cub::Max, cub::Min cub::Sum with cuda::maximum<>… (#4500)

  * Added option to use either always use BNorm or ResNorm for calculatin… (#4495)

  * Add support for force-inlined methods in GDB (#4492)

  * Always FillSignedDistance with max grid size of 32 (#4489)

  * Workarounds for Lustre I/O issues (#4426)

  * Communication Optimization: Cache GPU kernel metadata (#4462)

  * Fix constexpr evaulation bug for is_box_tag() in CPU version of Paral… (#4487)

  * Adding new assert check for MLMG to allow for staggered and non-cell … (#4488)

  * Add an --output_dir option to makebuildinfo_C.py (#4490)

# 25.06

  ## Highlights:

  * The default constructor of amrex::RandomEngine in GPU builds has been
    removed to prevent a common bug where a RandomEngine object is
    mistakenly created on the device using the default constructor.

  * CArena now uses a new memory defragmentation strategy. It is known that
    this has caused performance regression on Frontier. A fix for this is
    currently under review (https://github.com/AMReX-Codes/amrex/pull/4479),
    and it is expected in the next monthly release.

  * AMReX has previously defined fake MPI data types globally in non-MPI
    builds for convenience. Unfortunately, this can lead to conflicts with
    other libraries doing the same. In this release, we have put these MPI
    data types in non-MPI builds into the amrex namespace. This might break
    non-MPI builds of some application codes. To fix it, you can explicitly
    use these data types with `using amrex::mpidatatypes`. For many codes,
    using a new version of amrex::Initialize that does not need MPI_Comm
    introduced in this release can also fix the issue.

  ## Other major changes:

  * ParallelCopy: Fix a launch region issue (#4481)

  * Reuse MLEBNodeFDLaplacian and MLCurlCurl (#4480)

  * Add new amrex::Initialize (#4476)

  * GNU Make: Use -g1 for optimized builds with GCC and Clang (#4475)

  * Update rules of check-changes (#4474)

  * Fix compilation of PlotfileToMatLab (#4471)

  * Print max CArena usage (#4468)

  * Put MPI datatypes in separate namespace (#4470)

  * Fix incorrect static_cast in amrex::cast (#4465)

  * Avoid polluting global namespace with MPI types for non-MPI builds (#4463)

  * Parser: Support User defined functions (#4425)

  * ParmParse: Fix backward compatibility issue in #4457 (#4460)

  * Fix RealVect::Zero (#4459)

  * Convert RealVect to RealVectND (#4430)

  * New ParmParse Feature: 2d table (#4457)

  * CMake: NVTX is header-only for CUDA >= 11.2 (#4449)

  * Fix new warnings from size 0 arrays (#4429)

  * Parser: Fix a minor memory leak due to exception (#4442)

  * add conservative linear interpolation for spherical 2d geometry (#4441)

  * CArena free unused memory before allocate (#4451)

  * GNU Make: NVTX is now header only (#4452)

  * Parser Optimization: More aggressive cancellation (#4445)

  * Parser: minor optimization (#4444)

  * Delete RandomEngine's default constructor (#4443)

  * Parser Optimization: Local constant folding (#4428)

# 25.05

  -- SYCL on Windows workaround (#4436)

  -- Fix MF ParallelFor<MT> (#4414)

  -- Avoid calling bisection in MFParallelFor (#4392)

  -- SYCL: Update link flag for huge device code in GNU Make file (#4421)

  -- Hypre & PETSc: Fix compilation when MLMG's MF type is not FabArray (#4422)

  -- iMulitFab: Add more methods (#4410)

  -- HIP Debug Build (#4408)

  -- ReduceToPlaneMF (#4384)

  -- Periodicity boundary support for multi-ghost communication (#4405)

  -- Move the implemetation of the idcpu bit packing to standalone functions. (#4413)

  -- Fix safety of amrex::launch (#4419)

  -- Add utility to create non-periodic turbulence files (#4418)

  -- Add new MPI data type for RealVect (#4416)

  -- Env Variable: `AMREX_DEFAULT_INIT`, etc. (#4165)

  -- Fix a bug in 1d Curl Curl Solver (#4407)

  -- Remove stream sync in build_arrays (#4349)

  -- Combine back-to-back saxpy operations, as well as saxpy next to xpay (#4366)

  -- Guard some stream syncs (#4351)

  -- fix multi-level ParticleToMesh when zero_out_input is false (#4396)

  -- print number of cells per level in fboxinfo (#4403)

  -- Bug fix for index_assert in Array4 (#4400)

  -- Added bounds checking to GPUable arrays (#4395)

  -- Add a way to reuse TagParallelFor Tags (#4348)

# 25.04

  -- Use SingleStreamRegion and NoSyncRegion in MLMG solve (#4355)

  -- Force the alignment of SoA and AoS Particles  (#4375)

  -- Put loop over iter in MLMG smooth (#4352)

  -- More Guard of GNU extensions (#4385)

  -- ParmParse: Type Hints (#4364)

  -- Update CMake for Cray compiler (#4379)

  -- CI: New WarpX Repo (#4368)

  -- Add option to pass an IndexSpace to InterpFromCoarse (#4369)

  -- update docs for HYPRE installation (#4372)

  -- Guard the use of GNU extensions (#4374)

  -- Fixed EB data for anisotropic grids: boundary centroid, normal vector (backward compatible) (#4357)

  -- ParmParse: Add getline and queryline (#4367)

  -- update docs on NsightCompute profiling with / in syntax (#4362)

  -- Replace Elixir with Async Arena (#4354)

  -- More efficient OrientationIter (#4350)

# 25.03

  -- Make Parser CI less sensitive to roundoff errors (#4321)

  -- FFT: Add raw pointer interfaces (#4345)

  -- Update SUNDIALS GNUMake (#4344)

  -- Change FFTW rapth flag (#4343)

  -- Copy comm flags in make_alike (#4341)

  -- GPU Mapping (#4326)

  -- Fix FillRandomNormal for odd number of length (#4338)

  -- Fix new bug in pure soa communication (#4337)

  -- Expose MLCellLinOP::setInterpBndryHalfWidth for non-hypre cases (#4334)

  -- GMRESMLMG: Support Multi-level composite solve (#4271)

  -- Fix optional component communication for pure SoA particles (#4333)

  -- SYCL: fix '-flink-huge-device-code' compiler flag (#4332)

  -- compile MLCurlCurl for 1D in cmake (#4331)

  -- GitHub Runner: ubuntu-20.04 -> ubuntu-24.04 (#4330)

  -- FFT: Support complex to complex transforms (#4329)

  -- FFT: Add batch support (#4327)

  -- Fix recursion-related nvlink warning in RandomGamma (#4324)

  -- Fix a number of tests for GPU (#4323)

  -- Fix: Names in `PC::make_alike` (#4322)

  -- Enable GPU-aware MPI by default (#4318)

  -- Preparation for deprecation of `__AMDGCN_WAVEFRONT_SIZE` (#4311)

  -- Speed up CUDA Toolkit installation in Windows CI (#4310)

  -- GNU Make: Remove old machines like summit and cori (#4312)

# 25.02

  -- SpMatrix: Add constructor for CSR format (#4316)

  -- Modify warning messages about number of GPUs (#4315)

  -- Fix Doxygen with default void std::enable_if_t (#4314)

  -- CUDA On Windows (MSVC) (#4309)

  -- Fix includes (#4308)

  -- Fix CMake Compiler Flag Summary: ID Regex Matching (#4272)

  -- Use std::move (#4307)

  -- ParaView: AnyLocation -> Any Location (#4306)

  -- Documentation: Fix malformed table (#4305)

  -- PC: SoA Name Helpers (#4300)

  -- PC: Ensure Uniqueness of SoA Names (#4299)

  -- PC Names: Same Type, Multiple Vars/Instances (#4302)

  -- Use bigint in HypreSolver test (#4297)

  -- CI: Remove ICC/ICPC (Compiler Classic) (#4303)

  -- Fix: PC Tile Copy w/ Names (#4298)

  -- Add argument for NeighborParticleContainer::Redistribute (#4294)

  -- Fix `AMReX::FFTW` Once (#4293)

  -- Make ParmParse Parser more robust (#4291)

  -- std::clamp -> amrex::Clamp (#4292)

  -- Fix a memory leak in Open BC solver (#4290)

  -- Make using The_Comms_Arena() for particle communication opt-in (#4286)

  -- FFTW: Windows, OMP & Floats (#4282)

  -- SmallMatrix: Assert Lower Bound Index (#4283)

  -- ParmParse `queryAddWithParser` No Const (#4285)

  -- Fix bug in EBData::randomPointOnEB (#4277)

# 25.01

  -- Make FFT safe for slabs (#4268)

  -- Fix sumToLine for multiple components (#4266)

  -- Add version of PC::Checkpoint that allows toggling off certain components. (#4264)

  -- Use async sends in particle communication (#4257)

  -- AMReX Algebra: AlgVector and SpMatrix (#4259)

  -- EBData: New class containing Array4's for all EB data (#4238)
     Fix OMP bug in #4238 (#4260)

  -- FFT::OpenBCSolver: Fix batch mode (#4255)

  -- use abs for spherical 2d area (#4256)

  -- Cartesian1D curl-curl  (#4242)

# 24.12

  -- FFT::PoissonHybrid: Add solve() needed by ERF (#4250)

  -- Add CMake option: AMReX_CUDA_OBJDIR_AS_TEMPDIR (#4246)

  -- FFT::PoissonHybrid: Support non-periodic boundaries in x & y directions (#4247)

  -- FFT Poisson Solver: Fill ghost cells in solve() function (#4244)

  -- Update GMRES Comments (#4243)

  -- Fix dangling-reference warnings for particle functions. (#4241)

  -- Parser: Use malloc if Arena is not ready (#4240)

  -- Add portable implementation of random numbers drawn from the Gamma distribution. (#4239)

  -- Implementation of Bessel functions of second kind (yn) (#4234)

  -- FFT: Optimization for single process (#4235)

  -- VisMF::Read: Cache BoxArray and DistributionMapping (#4233)

  -- FFT OpenBC Solver: more optimization (#4232)

  -- FFT::PoissonHybrid: Add interfaces for user provided dz (#4229)

  -- FFT OpenBC Solver: Communication optimization (#4230)

  -- Add local FFT (#4224)

  -- FFT: Add new domain decomposition strategy (#4221)

  -- Skip some CIs if only Docs/ has changed (#4197)

  -- Replace blockDim.x with compile time constant when possible (#4198)

  -- FFT: OpenBC Solver (#4217)

  -- STL: Make the fill(MultiFab) function work with non-nodal types (#4207)

  -- Remove repeated norm_inf calculation in bicgsolver. (#4205)

  -- Initial and final function stacks: Use std::function (#4218)

  -- comply with C++ defect report on user-defined literals (#4215)

  -- Fix a bug in EB2::Level::fillLevelSet (#4208)

  -- HDF5: Fix missing header in GNU Make (#4213)

  -- FFT Poisson Solver: Neumann and Dirichlet Boundaries (#4202)

  -- Remove SWFFT and HPGMG (#4211)

# 24.11

  -- Add option to do stable redistribute with GPUs (#4200)

  -- Remove HIP_INDIRECT_FUNCTION (#4199)

  -- Use The_Comms_Arena in particle communication. (#4175)

  -- Refactor grid-stride loop (#4190)

  -- STL optimization: Bounding volume hierarchy (#4140)

  -- Bounded sampling (#4195)

  -- amrex::FFT (#4193)

  -- SmallMatrix: Structured binding support (#4189)

  -- SmallMatrix: Support 1-based indexing (#4188)

  -- SoA: Public Getter for Names (#4187)

  -- Named SoA Support (#4163)

  -- Fix queryktharr() return value/behaviour. (#4186)

  -- Add more build options for linear solvers (#4181)

  -- New function for domain decomposition (#4183)

  -- SmallMatrix: Matrix class with compile time size (#4176)

  -- modify/remove the assertions about no hidden dimension (#4180)

  -- Add comparison operator for boxarray and distromap. Add hdf5 to dep.py (#4173)

# 24.10

  -- TinyProfiler: Remove unnecessary precision() call (#4174)

  -- Fix GCC 12 & 13 warnings on null-dereference (#4171)

  -- fix: wavefront_size for gfx11* (#4170)

  -- CI: Test GCC-13 (#4169)

  -- allow hidden dimension when calling FFlux routines (#4162)

  -- Deregister BArena from Profiling in Arena::Finalize (#4164)

  -- FillPatchSingleLevel and FillPatchTwoLevels for ERF (#4158)

  -- `ParmParse:addFile`: User-Friendly Error (#4156)

  -- Adding computation of complete elliptic integrals into amrex::Math (#4151)

  -- Fix roundoff issue in SUNDIALS evolve() (#4148) (#4157)

  -- Add a new InterFromCoarseLevel for ERF (#4150)

  -- Add ParmParse features for WarpX (#4149)

  -- ParmParse::queryAsDouble: Support bool and std::optional (#4152)

  -- add geometric terms for spherical 2D support. (#4141)

  -- Add std::setfill to PrintMemStats (#4147)

  -- Add ParmParse::query_enum_sloppy that can ignore characters (#4145)

  -- Fix ParmParse::query_enum_case_insensitive (#4144)

  -- AMREX_ENUM: Add more capabilites (#4143)

  -- Add ParmParse::eval (#4142)

  -- AnyCTO with arbitrary number of functions (#4135)

  -- IOFormatSaver (#4104)

  -- amrex::Stack (#4139)

  -- Use BL_PROFILE instead of BL_PROFILE_VAR to time in knapsack()swap (#4134)

  -- Add iMultiFab::sum that returns the sum over a region (#4132)

  -- EB Boundary Area: Fix issues for anisotropic cell size (#4131)

  -- `ParmParse`: Prefix to `FILE` (#4126)

  -- MLMG: Minimum domain width (#4129)

  -- Capability adds for ParmParse enum (#4119)

  -- use perl instead of sed in style checks for portability to MacOS (#4127)

  -- Fortran Interfaces: Add new average down functions (#4124)

  -- TinyProfiler: A few updates (#4102)

  -- ArenaProfiler: Fix clang-tidy warning (#4128)

  -- CTOParallelFor with BoxND / add AnyCTO (#4109)

  -- TinyProfiler with BArena and PArena (#4113)

  -- Fix Fortran interface compilation issue using `nvfortran` (#4115)

  -- `AMREX_DEVICE_PRINTF`: Host (#4116)

  -- EB: don't abort for no-op case in unsupported addFineLevels functions (#4123)

  -- Fix FillPatchNLevels (#4117)

# 24.09

  -- Curl Curl Solver: Option to use PCG instead of LU (#3812)

  -- Support for multiple periods in FillBoundary and ParallelCopy (#4106)

  -- ParmParse::prettyPrintTable (#4101)

  -- TinyProfiler:: Add more runtime parameters (#4100)

  -- Fix start_comp offset in tracer particle routines (#4098)

  -- ParmParse: queryarrWithParser (#4073)

  -- Add Geometry::RoundoffLo and RoundoffHi functions (#4097)

  -- Fortran BoxArray: Add nboxes function returning the number of boxes. (#4096)

  -- Time integrator interface updates (#4088)

  -- Fix a bug in ParmParse::remove (#4093)

  -- Add Jacobi smoother to ABecLaplacian and Poisson (#4091)

  -- Multi-level Hypre: Fix periodic boundary bug (#4090)

  -- Multi-level Hypre: Fix bugs (#4089)

  -- Add overload for `getParticleCell` that returns local cell index (#4081)

  -- MLEBNodeFDLaplacian: Make it work with AMREX_USE_EB but with no EB (#4083)
     MLEBNodeFDLaplacian: Regression (#4085)

  -- AMREX_ENUM and ParmParse support for enum class (#4069)

  -- BLBackTrace: Check for `addr2line` in path first (#4079)

  -- Make sure ChopGrids does not violate refinement ratio. (#4078)

  -- GPU Device Variable on Intel GPUs (#4056)

  -- ParallelFor with BoxND (#4052)

  -- fix compilation of the Richardson tool (#4072)

  -- HDF5: Update BLProfile Name (#4071)

  -- Bins: Index Type `int` (#3684)

  -- Conduit: Fix SoA Particle (#4065)

  -- Plotfile Particles: Fix Error Message (#4068)

  -- CI: Fix Catalyst CMAKE_PREFIX_PATH (#4067)

  -- Use NVTX3 to avoid conflict with cub in CUDA 12.6 (#4064)

  -- Convert Box to BoxND (#4016)

  -- Use long long for IParser value_t in ParmParse (#4059)

# 24.08

  -- Catalyst support (#4011)

  -- Fix typos in FaceDivFree interior interpolation. (#4048)

  -- ParmParse: Read IntVect & RealVect from array (#4050)
     ParmParse: Fix assertion in new queryarr for IntVect & RealVect (#4051)

  -- IParser: Use long long int (#4046)

  -- ParmParse: Math expression support (#4032)

  -- AmrData: remove dependency on Fortran (#4049)

  -- Remove reliance on managed memory in HDF5 mesh IO (#4047)

  -- New Feature in MLEBNodeFDLaplacian: MultiFab sigma coefficient (#3968)

  -- Nodal Solver: Use multi-color Gauss-Seidel on GPU (#4043)

  -- Use reduction to compute min and max particle distances in NeighborParticles test. (#3212)

  -- ParmParse: Refactoring II (#4035)

  -- Fix deadlock for CUDA (#4044)

  -- ParmParse: Refactoring (#4031)

  -- MLMG: Keep ghost cell values in user's inputs (#4040)

  -- Geometry: Fix operator>> (#4042)

  -- FillPatch for Face Data: Fix Geometry used in creating mask (#4039)

  -- Parser: Allow dots in variable names (#4038)

  -- HDF5: Remove unnecessary casting (#4036)

  -- HDF5: Fix chunking warning (#4033) (#4034)

  -- New parameter amrex::init_snan (#4030)

  -- Change the default max_grid_size in 3D on GPU from 32 to 64 (#4029)

  -- GpuArray: add operator+= (#4028)

  -- FPE traps: Add functions for enabling and disabling FPE traps (#4025)

  -- HDF5: Correctly determine max_mfi_count (#4024)

  -- HDF5: expose ZLIB compression without SZ or ZFP flags (#4015)

  -- Hypre: Use Gpu::hypreSynchronize (#4022)

  -- AmrMesh: add const to a few functions (#4021)

  -- Convexify AMR data (#4013)

  -- Fix BottomSolver::bicgcg (#4020)

  -- Fix some warnings issued by Coverity (#4017)

  -- convert IndexType to IndexTypeND (#3988)

  -- Workaround MSVC issue in tupleToArray (#4000)

# 24.07

  -- HDF5: Correctly handle writing only some components when writing Particle (#4005)

  -- HDF5: Correctly choose datatype of plotfile based on RD numBytes (#4006)

  -- Fix L2 norms in C_util/Convergence codes (#4009)

  -- Match the dimensions of reqd_work_group_size to submitted nd_range (#4002)

  -- GNU Make: try nvidia-smi for CUDA arch if deviceQuery fails (#3997)

  -- Sundials Update (#3984)

  -- Derive: Add MultiFab version of DeriveFunc (#3990)

  -- GNU Make: Add support for CUDA LTO (#3993)

  -- Bottom Solver: Keep the unconverged result if it's an improvement (#3991)

  -- Multi-level composite solver using hypre (#3987)
     Workaround std::exclusive_scan issue with old compilers (#3996)

  -- TableData: Add support for row-major order (amrex::Order::C) (#3973)

  -- Avoid self copy in MultiFab::Copy (#3986)

  -- Convert IntVect to IntVectND (#3969)

  -- GNU Make: Don't replace -I with -isystem for MPI include paths (#3985)

  -- Add pyamrex CI (#3967)

  -- const auto ptd -> const auto& ptd (#3983)

  -- Fix ctests with HIP (#3982)

  -- Add TupleSplit (#3978)

  -- use HIP stream-ordered allocator (#3980)

  -- Add structured binding support to GpuTuple (#3977)

  -- New FillPatch function: FillPatchNLevels (#3974)

  -- Update GNUmake files for NREL machines. (#3975)

  -- SYCL for Nvidia: Re-enable CI without tests (#3971)

  -- Skip empty particle tiles in operator++ to avoid race condition in constructor. (#3951)

  -- adding physical and math BC types for inflow-outflow BCs (#3965)

# 24.06

  -- add missing AMReX_SUNDIALS in AMReXConfig.cmake (#3962)

  -- Linear Solver: Fix semicoarsening issues with multiple AMR levels (#3961)

  -- add DEBUG_LIBSTDCXX option to GNU Make gcc for libstdc++ debug (#3945)

  -- InterpBndryData: Make changes for multi-level hypre (#3959, #3960)

  -- FabArray: Make some functions static (#3958)

  -- MultiArray4: add conversion operator to bool (#3957)

  -- Overloading `Array4::operator()`, `ptr` and `contains` (#3956)

  -- Tune PermutationForDeposition for MI250X (#3925, #3953)

  -- Support size 0 BoxArrays in ParticleLocator (#3949)

  -- Workaround for Windows omp_lock_t issue (#3910)

  -- CMake: No Deprecation Warnings (#3947)

  -- Particle InitBinaryFromFile: Use reference instead of copy (#3946)

  -- Fix particle restart when finestLevel() < finest_level_in_file (#3944)

  -- Delete copy constructor and assignment operator for ParticleTile (#3943)

  -- Fix FillPatcher after enforcing PhysBCFunct operator() fills nghost (#3941)

  -- CTest: Add atomicAdd to small tests (#3915)

  -- Fix 1d HDF5 compilation (#3939)

  -- Update hip installation script for CI (#3938)

  -- GMRES/MLMG: Set the number of MG V-cycles per GMRES iteration (#3875)

  -- Neumann BC at coarse/fine interface for cell-centered solvers (#3926)

  -- Fix assertions involving IntVect (#3919)

  -- Modify Tests/LinearSolvers/ABecLaplacian_C (#3888)

  -- MLNodeLaplacian: 1D support (#3918)

  -- In PhysBCFunct, only fill nghost grow cells (#3914)

# 24.05

  -- 3d anisotropic eb (#3907)
     cleanup of latest changes for 3D EB (#3912)

  -- Update for ROCm 6.1.0 (#3898)

  -- fix a HIP/Frontier issue (#3902)

  -- Set AMD wavefront size according to AMReX_AMD_ARCH (#3881)

  -- Fix offset in recv buffer of single precision particle communication (#3896)

  -- Fix Assertion (#3894)

  -- TinyProfiler: shorten output into "Other" section (#3885)

  -- Fix ReorderParticles for PureSoA (#3890)

  -- Fix full plotfiles with only derived variables (#3892)

  -- FabArray: Update Asserts (#3893)

  -- Add MultiFab::sum(region) and sum_unique(region) (#3871)

  -- TinyProfiler: remove CUPTI (#3886)

  -- ParticleContainer::WritePlotFile: Fix enable_if (#3884)

  -- amrex::tupleToArray (#3880)

  -- Allow plotting only a subset of Amr levels (#2825)

  -- Parser: add error function (#3870)

  -- Add `PODVector::assign(value)` (#3866)

  -- GCC: inline limit (#3841)

# 24.04

  -- `AddRealComp`/`AddIntComp`: Resize SoA (#3615)
     Fix: Resize Component on Add (#3861)

  -- Use less device memory when checkpointing particles (#3238)

  -- FabArray: Option to use a single contiguous chunk of memory (#3857)

  -- AMReX_FLATTEN_FOR (#3855)
     Disable AMReX_FLATTEN_FOR by default (#3860)

  -- Curl Curl Solver: Variable beta coefficient (#3810)

  -- `MultiFab::deepCopy()` (#3848)

  -- `FabArray<FAB>::copy` Argument Name (#3856)

  -- Use Clang-Tidy 17 in GitHub CI (#3845)

  -- Update to SUNDIALS v7 (#3835)

  -- Assert: Geometry's domain is cell-centered (#3853)

  -- Fix ReduceToPlane (#3852)

  -- Clang-Tidy 17: modernize-type-traits (#3844)

  -- Clang-Tidy 17: cppcoreguidelines-rvalue-reference-param-not-moved (#3825)

  -- Clang-Tidy 17: modernize-loop-convert (#3833)
     Revert range based for-loop with OMP (#3839)

  -- Clang-Tidy 17: performance-avoid-endl (#3830)

  -- Fix a memory leak in TableData::operator= (#3807)

  -- Update Copyright Notice and License Agreement (#3829)

  -- Clang-Tidy 17: cppcoreguidelines-missing-std-forward (#3818)

  -- Clang-Tidy 17: cppcoreguidelines-avoid-const-or-ref-data-members (#3817)

  -- Clang-Tidy 17: misc-use-anonymous-namespace (#3824)

  -- Clang-Tidy 17: bugprone-switch-missing-default-case (#3816)

  -- Clang-Tidy 17: performance-noexcept-swap (#3822)

  -- Fix extra indentation in fcompare output (#3823)

  -- Clang-Tidy 17: misc-header-include-cycle (#3820)

  -- New constructor for MPMD::Copier (#3806)

  -- Fix deprecation warning for CUDA 12.4 (#3811)

  -- use emplace_back / emplace where possible (#3814)

  -- In allocateSlice, handle empty list of boxes (#3808)

  -- Explicit Includes: MultiFab -> BaseFab (#3802)

  -- CI: Windows Install & Test Install (#3803)

  -- Add Tests/OpenMP/atomicAdd (#3805)

  -- Minor changes in Src/Base/AMReX_MPMD (#3800)

  -- add ifdefs to enable NVHPC as device compiler (#3801)

  -- CI: Windows MSVC w/ Ninja (#3804)

  -- omp_locks: Avoid extern global variable (#3798)

  -- Add option to interpolate data on faces linearly in the tangential direction (#3794)

  -- `omp_locks`: C Array (#3796)

  -- Port WriteEBSurface by copying EB information to pinned tmps before writing. (#3793)

  -- Robin BC: Abort if solver is not safe for reuse (#3788)

  -- Update GMRES/MLMG for nodal solver (#3787)

  -- TagParallelFor: Add assertion against integer overflow (#3790)

  -- Simplify GMRES/MLMG interface (#3785)

# 24.03

  -- Fix GPU restart for pure SoA particles (#3783)

  -- fix for ref_ratio=1 (#3786)

  -- Update GMRES/MLMG interface (#3779)

  -- Ref ratio 3 (#3781)

  -- Curl Curl solver: 4-color Gauss-Seidel smoother (#3778)

  -- assert wavefront size (#3777)

  -- Curl of Curl solver: Tweak restriction (#3765)

  -- Adjust debug info argument for HIP compiler (#3761)

  -- fixed bug in MLCurlCurL::xdoty() to prevent doing MPI sum twice. (#3774)

  -- Implement portable assumptions with AMREX_ASSUME (#3770)
     Fix bug in AMREX_ASSUME (#3773)

  -- Pure SoA: `NextID` as `Long` (#3772)

  -- GNU Make: set COMP_VERSION for hipcc and nvcc (#3771)

  -- Make MFParallelFor safer from int overflow (#3768)

  -- getParticleTileData: HostVector must be initialized during resize (#3769)

  -- add AMREX_LIKELY and AMREX_UNLIKELY (#3767)

  -- Only do a htod memcpy in getParticleTileData when necessary (#3760)

  -- Sync GPU stream before getting the time in TinyProfiler (#3763)

  -- Add a logspace-like function in AMReX_Algorithm.H (#3754)

  -- Fix offset in send buffer of single precision particle communication (#3758)

  -- EdgeFluxRegister for MHD (#3633)

  -- Fix a typo in SYCL version of scan (#3757)

  -- Interpolation from node-centered general mapped coordinates to tracers (#3750)

  -- Remove various deprecated stuff not prefixed by amrex or bl (#3713)

  -- GNU Make: Link flags (#3711)

  -- Remove UB from is_aligned (#3751)

  -- Add partitionParticles Function (#3743)

  -- Minor new functions in AMReX_MPMD to provide flexibility for python binding (#3748)

  -- Box::numPts() returns 0 for empty boxes (#3747)

  -- New Linear Solver: Curl of Curl (#3682)

  -- Use long integer in GPU kernels (#3742)

  -- Add `ParticleIDWrapper::make_invalid()` (#3735)

# 24.02

  -- Disable m_aos for SoA Particle (#3736)
     Update AoS Restrict (#3738)

  -- Add helper function for setting id and cpu simultaneously. (#3733)

  -- Disable SYCL on Nvidia and AMD CIs (#3726)

  -- ParticleCopyPlan for SoA Particles (#3732)

  -- Do not use std::forward twice on the same object in AmrParticleLocator (#3734)

  -- Particle Copy Plan: Default Vals (#3729)

  -- Fix circular header file dependency (#3725)

  -- Provide portable Gpu::Atomic::Multiply and Gpu::Atomic::Divide implemented with CAS. (#3724)

  -- Plotfile Tools: Add missing option to fcompare usage print (#3722)

  -- Update documentation for STL files (#3723)

  -- Add TypeMultiplier, MakeZeroTuple and IdentityTuple (#3718)

  -- Interpolation routines for tracers with mapped_z. (#3714)

  -- relax constraint that real_comp_names.size() == pc.NumRealComps() + NStructReal for pure SoA plotfiles (#3717)

  -- Fix warnings in DenseBins::build with serial bin policy (#3716)

  -- lockAdd: case of 2D plane in 3D (#3700)

  -- Clean up interpolation routines in AMReX_TracerParticle_mod_K.H and AMReX_Particle_mod_K.H (#3679)

  -- Add macro for loop unrolling across compilers (#3701)

  -- Add a linspace-like function in AMReX_Algorithm.H (#3698)

  -- use amrex::Gpu::memcpy for packParticleIDs (#3699)

  -- BaseFab::lockAdd: Faster version of BaseFab::atomicAdd for OpenMP (#3696)

  -- GMRES (#3648)

  -- Add special named flag for invalid particles (#3688)

  -- Fix BL_PROFILE_TINY_FLUSH (#3695)

  -- Align GpuComplex to its size (#3691)

  -- Fix Advection_AmrCore test (#3690)

# 24.01

  -- MLMG: Use free functions instead of MF member functions (#3681)

  -- Add a few free functions for MLMG (#3680)

  -- Eliminating Matrix operations in MLMG CG bottom solver if initial vector is zero (#3668)

  -- Add a for loop that is unrolled at compile time (#3674)

  -- Add PTD version of getParticleCell (#3675)

  -- Improve ParIter docs (#3676)

  -- Fix CI for ROCm 6.0 (#3673)

  -- PureSoA IdCpu fixes (#3671)

  -- CMake: AMReX_PARALLEL_LINK_JOBS (#3628)

  -- Clang-Tidy in CI: Keep Going after Errors (#3667)

  -- Delete empty below comments on classes and functions (#3669)

  -- Documentation for Profiling: Hot Spots and Load Balance (#3622)

  -- Fix warnings in SortParticlesForDeposition (#3664)

  -- Fix Resize Issue of Fab with the Async Arena (#3663)

  -- Fix SuperParticle `push_back` (#3661)

  -- Pure SoA Particle: Separate Array for IdCPU (#3585)

  -- Limit the scope of gpu_rand_generator (#3659)

  -- Fix a typo in doxygen for NonLocalBC::FillBoundary (#3658)

  -- GNU Make: Fix name collision for aurora (#3656)

  -- two separate fixes -- particle_compare and ref_ratio=1 (#3655)

  -- Clarify documentation on setEBDirchlet() and fix link to AMReX-Hydro (#3652)

  -- Robustify the Cache Cleanup Scripts (#3650)

  -- Disable CodeQL scheduled jobs on forks (#3649)

  -- Work around compiler bug in nvcc 12.2 by using functor instead of lambda (#3653)

# 23.12

  -- solve_cg: avoid use of MF `z` (#3637)

  -- Fix: nosmt OMP Threads Default (#3647)
     `amrex.omp_threads`: Can Avoid SMT (#3607)

  -- When checking for periodic outs on GPU, copy full particle data (#3646)

  -- MLEBABecLap: Support Robin BC at Domain Boundaries (#3617)

  -- Ascent: SoA Particle Support (#3350)

  -- solve_bicgstab: use fewer MFs (#3635)

  -- solve_bicgstab: cut use of `s` (#3629)

  -- Bug fix for amrex::Subtract when called with interger nghost (#3634)

  -- Fix typo in `MLMGT<MF>::getGradSolution` when `MF` is different from `AMF` (#3631)

  -- SUNDIALS: Use sunrealtype instead of realtype (#3632)

  -- SYCL: Use get_multi_ptr instead of get_pointer (#3630)

  -- Plotfile Tools: GPU support (#3626)

  -- solve_cg: use linop.make instead of MF constructor (#3627)

  -- CArena: shrink_in_place and operator<< (#3621)

  -- solve_bicgstab: use linop.make instead of MF constructor (#3619)

  -- replace AMREX_DEVICE_COMPILE with AMREX_IF_ON_DEVICE and AMREX_IF_ON_HOST (#3591)

  -- [Breaking] Prefix `amrex_` to each plotfile Tool (#3600)

  -- FillRandom: Use MKL host API (#3536)

  -- use hipPointerAttribute_t.type as HIP is removing hipPointerAttribute_t.memoryType (#3610)

# 23.11

  -- Give FlashFluxRegisters ways to accumulate data in registers (#3597)

  -- `AMReXBuildInfo.cmake`: AMReX_DIR (#3609)

  -- update doc for amrex::Abort on GPU (#3605)

  -- Add runtime particle components to HDF5 wrapper (#3596)

  -- Windows: Fix Installed AMReXBuildInfo.cmake (#3606)

  -- Print AMReX version at the beginning of Initialize (#3604)

  -- Install Move Tools to `shared/amrex` (#3599)

  -- Revert "Add ability for GCC 8 in CMake to build fgradient which uses std::filesystem" (#3601)

  -- Avoid std::filesystem (#3602)

  -- Fix Assertion in MLEBNodeFDLaplacian (#3594)

  -- Fix a memory "leak" in VisMF's persistent streams (#3592)

  -- RealVect Static: Export (#3589)

  -- change MaxCnt from 4 to max(4,max_level+1) for how many iterations we… (#3588)
     … allow in creation of the initial grid hierarchy

  -- Add Bittree CI (#3577)

  -- BCType::ext_dir_cc (#3581)

  -- Disable CCache in Windows CIs (#3566)

  -- Fix ICC CI by Freeing up Disk Space (#3583)

  -- Docs: Link pyAMReX (#3582)

  -- NodeABecLaplacian: Reuse (#3579)

  -- simplify how 2d surface integrals are computed (#3571)

  -- Adding bittree interface to improve regridding performance in octree mode (#3555)

  -- MLNodeABecLaplacian (#3559)

  -- Fix Boundary Centroid in a Corner Case in 2D (#3568)

# 23.10

  -- Bugfix typo in AMReX_SundialsIntegrator.H Nvar vs NVar, the
     declared/used variable is NVar (#3573)

  -- Code Spell (#3563)

  -- Add Fortran interface for average_down_faces (#3553)

  -- PureSoA: Disable AoS Access (#3290)

  -- Another terrain fix for MPI (#3557)
     Fix Increment, OK, and EnforcePeriodicWhere for terrain-fitted particles. (#3556)

  -- Added cvode functionality to SUNDIALS integrator (#3436)

  -- ParmParse::addfile needs Init (#3440)

  -- Make the same changes to ApplyInitialRedistribution as to ApplyMLRedistribution (#3554)

  -- Reset EB Fab Type (#3552)
     EB Data outside domain (#3549)

  -- We weren't defining cent_hat out far enough (#3548)

  -- Add Fortran interface for FillCoarsePatch for face variables (#3542)

  -- print_state/printCell: Make it work without managed memory (#3543)

  -- FillPatch Fortran Interface: Fix incorrect size of Vector<BCRec> (#3546)

  -- ReduceOps: reset result readiness flag (#3545)

  -- Fix Fortran interface for FillPatch for face variables (#3541)

  -- Support multiple CUDA architectures at compilation (#3535)

  -- Add Kestrel machine and remove Rhodes machine from Make.nrel (#3533)

  -- Explicitly flush when writing to the terse run log (#3532)

  -- Missing header in AMReX_GpuComplex.H (#3531)

  -- Add global domain id offset to conduit wrapper (#3524)

# 23.09

  -- Fix InitRandomPerBox for 1D & 2D (#3527)

  -- Add ability for GCC 8 in CMake to build fgradient which uses std::filesystem (#3523)

  -- Fix: Include Guard 1D for MLPoisson (#3528)

  -- Workaround for Intel compiler classic (#3526)

  -- Constness in buildInfo: num_modules (#3522)

  -- MLABecLaplacian: Tweak kernel fusing (#3521)

  -- UniqueString tweak (#3520)

  -- faverage fix (#3519)

  -- Empty level fix (#3517)

  -- Simplify filterParticles Kernel (#3510)

  -- Generalize particle-to-cell assignment function (#3499)
     Follow-on to 3499 (#3514)
     ParticleLocator: Make Assignor optional template parameter (#3515)

  -- GPU Launch Min Blocks (#3503)

  -- Remove unsafe std::forward (#3513)

  -- Fix Bug in FaceLinear Interpolater (#3483)

  -- Add test on whether we are in the valid box when updating drho_as_crs… (#3506)

  -- Fix backtrace nullptrs (#3505)

  -- Skip ubsan lib on OSX (#3504)

  -- SYCL: Add table of GNU Make config vars to docs (#3400)

  -- Fix: Backtraces will NULL Addresses (#3502)

  -- Update gpu elixir and async array synchronization for sycl (#3498)

  -- SundialsIntegrator: Fix memory deallocation (#3501)

  -- FillRandom & FillRandomNormal (#3500)

  -- Update position in 2nd pass for tracer advect with Ucc. (#3496)

  -- Move use of bcrec back onto GPU (#3494)

  -- fix bug in StateRedist and add multi-level functionality for FluxRedi… (#3491)

  -- fgradient: A new plotfile tool for computing gradient (#3490)

  -- CI: Remove redundancy in nvcc dependencies files (#3387)

  -- CMake: HIP Debug with -O1 (#3487)

  -- Fix overflow in ParallelFor(Long n, ...) (#3489)

  -- Adjust build for upstream Mpich and OpenMPI modules on Perlmutter. (#3486)

  -- CArena: Implement alloc_in_place (#3426)

  -- Clang-Tidy: Add more checks (#3466)
     Fix a bug in #3466 (#3485)

  -- Option to force regrid level zero (#3484)

  -- Fix typo introduced in PR 3452 (#3482)

  -- Clang-Tidy changes in Src/LinearSolvers (#3475)

  -- Update FluxRedist and comments for StateItracker (#3481)

  -- Clang-Tidy changes in Src/EB (#3473)

  -- Clang-Tidy changes in Src/Boundary (#3471)

  -- Clang-Tidy changes in Src/F_Interfaces (#3474)

  -- Clang-Tidy changes in Src/Particle (#3476)

  -- Clang-Tidy changes in Src/Extern (#3472)

  -- Clang-Tidy changes in Tests (#3477)

  -- Clang-Tidy changes in Tools (#3478)

  -- Change the default value of The_Pinned_Arena release threshold (#3479)

  -- Handle ThetaGPU in GNU make system (#3469)

  -- Clang-Tidy changes in Src/AmrCore (#3468)

  -- Clang-Tidy changes in Src/Amr (#3467)

  -- Fix a bug in EB tensor solver's cross term (#3465)

  -- Add misc-misplaced-const check to clang-tidy CI test (#3464)

  -- Suppress implicit return warnings with nvcc (#3463)

  -- Silence "unreachable loop" warning for GPU builds (#3462)

  -- PlotFileUtil: Add Direct Includes (#3446)

# 23.08

  -- Fix a bug in AmrMesh::ChopGrids (#3460)

  -- Remove use of managed memory from TracerParticleContainer::TimeStamp (#3457)

  -- Mac Arm64 Architecture fpe handling (#3447)

  -- SYCL: Remove Workaround no longer needed (#3455)

  -- SENSEI: SoA Particle Support (#3349)

  -- Warn if USE_GPU_RDC=TRUE when HIP_SAVE_TEMPS=TRUE (#3454)

  -- SYCL: Allocate 3/4 of total global memory by default (#3431)

  -- GPU Assignment (#3382)

  -- call_f refactor (#3452)

  -- HDF5 bug fix for vol-async and compression (#3451)

  -- Add second template parameter to other AoS for swap (#3450)

  -- Refactor call_f in ParticleTransformation and WriteBinaryParticleData
     to use constexpr if (#3448)

  -- Fix this version of WritePlotFile to use SuperParticle, as expected by
     WriteBinaryParticleData (#3449)

  -- PODVector: Add a Missing STL Include (#3445)

  -- Disable Managed Memory for The_Arena by default. (#3438)

  -- SYCL RelWithDebInfo Build: Add -g1 (#3429)

  -- Clang Tidy: +modernize-use-using (#3420)

  -- Intel CI: Update Warning Flags (#3443)

  -- In MLEBABecLap::compGrad, add missing call to addInhomogNeumannFlux (#3441)

  -- Doxygen: SoA Get[Real/Int]Data (#3439)

  -- ParmParse: Line Continuation (#3437)

  -- SYCL: Get Pointer Type (#3434)

  -- SYCL: UUID (#3432)

  -- Re-Enable FPE Trap for SYCL (#3430)

  -- Memory Efficient AoS Particle Sorting (#3427)

  -- Use MPI_IN_PLACE (#3428)

  -- PODVector Updates (#3425)

  -- generalize interpolaters to not need or use extra values in a direction
     for which the refinement ratio is 1 (#3415)

  -- Fix Fortran module installation (#3411)

  -- Fix allocateSlice for EB (#3391)

  -- Update Intel compiler installation (#3423)

  -- Improve comments and documentation on FaceDivFree Interpolater. (#3422)

  -- Add the option to throw an exception on MLMG failure rather than aborting (#3424)

  -- Make ReduceData::value safer (#3421)

  -- Use atomic load in SYCL version of the single-pass scan (#3419)

  -- GPU: Add Device::deviceVendor() function and fix #3416 (#3418)

  -- New feature in EB: Add regular coarse levels (#3414)

  -- add access function for EBFactory (moved out of IAMR) (#3417)

  -- DataServices: Qualify math functions with `std::` namespace specifier (#3406)

  -- Update CleanUpCache workflow (#3403)

  -- Add some profilers to AmrLevel and FillPatcher (#3402)

  -- Update the clang-tidy/ccache script (#3399)

  -- Update Git workflow in CONTRIBUTING.md (#3397)

  -- move redist into amrex (#3378)

  -- Amr: Add printing of simulation time (#3392)

  -- Add function for setting growth factor (#3394)

  -- Updates Ascent Github Actions CI to use 0.9.2 (latest release)

# 23.07

  -- Allow users to change the default vector growth strategy (#3389)

  -- Communications arena implementation (#3388)

  -- CI: oneAPI SYCL for AMD GPUs (#3341)

  -- GPU: Always deallocate gpu_rand_state in Finalize() (#3384)

  -- Hypre ILU options (#3381)

  -- Amr Class: Synchronization of StateData's Time (#3375)

  -- EB 2D: Fix levelset on nodes adjacent to covered edges (#3370)

  -- Add workflow for oneAPI SYCL on Nvidia GPUs (#3360)

  -- CMake: Enforce >= C++17 for ROCm (#3355)

  -- Use device arena for the_fa_arena when activating GPU-aware MPI (#3362)

  -- Coverity Scan (#3361)

  -- CMake: AMReX_TEST_TYPE (#3357)

  -- CMake: Enable AMReX_PARTICLES by default (#3358)

  -- Add AMReX Apps to CI (#3348)

  -- Make sure amrex::Long is wider than int. (#3345)

  -- Particle Ids: Add int Constants (#3338)

  -- CI: Clang CUDA (#3184)

  -- Reinforce __CUDACC__ conditionals w/ AMREX_USE_CUDA (#3331)

  -- CMake: Link option when HIP is a language (#3335)

# 23.06

  -- Implement Checkpoint, Restart, and Plotfile for pure SOA (#3332)

  -- Clang: -Wno-null-conversion for Lexer (#3333)

  -- Fix Pure SOA RedistributeGPU: size from ptile, not the AoS (#3330)

  -- cleaning and fixes for PureSoA ParticleTile (#3327)

  -- RealBox: Accept RealVect Setters (#3328)

  -- Port InitRandom for pure SoA (#3325)

  -- FillBoundary for Spherical Coordinates (#3286)

  -- Fix: AMReXConfig.cmake Multi-Dim (#3324)

  -- HypreSolver: a new interface for Hypre (#3269)

  -- Fix Tests/EB_CNS in 2D (#3323)

  -- Fix CodeQL warnings (#3318)

  -- Add get/set of AMRErrorTagInfo in AMRErrorTag (#3317)

  -- GNU Make: allow skipping paths when running clang-tidy (#3316)

  -- Multi-Dim Buildsystem Support (#3309)

  -- GNU Make: use CLANG_TIDY_CONFIG_FILE if it's set (#3315)

  -- Refactor Parser (#3265)

  -- Enable binning for ParticleTileData (#3307)

  -- ParticleTile: More SoA Updates (#3305)

  -- HIP Debug Build (#3311)

  -- Run PODVector::push_back on GPU (#3308)

  -- ParticleInit: Implicit Int Float Conversion (#3304)

  -- More constexpr if for pure soa in RedistributeCPU (#3299)

  -- MLEBNodeFDLaplacian: Implement the alpha term (#3301)

  -- Fixing the ParIter numParticles functions for pure SOA (#3303)

  -- Add .mailmap (#3295)

  -- Implement StructOfArray::empty() and ParticleTile::empty() for pure SoA (#3296)

  -- port the old BoxLib faverage tool to AMReX (#3293)

  -- GNU Make: add -pthread for HIP (#3294)

  -- Github Cache: Path and Hypre (#3288)

# 23.05

  -- Support SoA-Only Particles (#2878)
     Conduit: Update ParticleTile API (#3260)
     Fix default template parameter for ParConstIter (#3262)
     Update SortParticlesForDeposition for pure SoA (#3277)
     Implement increment for pure SoA (#3278)
     Fix RealVect version of pos() for pure SoA (#3283)
     Fix increment for pure SoA (follow on to #3278) (#3284)

  -- handle divide by 0 in signed distance function (#3279)

  -- Work-Around: CUDA 12.1 Non-Default Codelines (#3275)

  -- CMake: Fix CUDA Options Order (#3274)

  -- Fix bug in EBNodeFDLap (#3271)

  -- update ci to use ascent 0.9.1 (#3266)

  -- Add powi function in AMReX_Math.H (#3251)

  -- update hiprand header path (#3252)

  -- Installation using configure: Forgot to install Parser headers (#3249)

  -- ParticleTileData: No Restrict in Storage (#3245)

  -- CI: Retry Apt Repos (#3242)

  -- Silence SWFFT (#3240)

  -- Support complete elliptic integrals of 1st and 2nd type in Parser (#3225)

  -- Rework handling of roundoff domain extent (#3199)
     Fix periodic boundary bug in #3199 (#3243)
     Fix Roundoff Domain (#3247)
     Roundoff errors in computeRoundoffDomain (#3255)
     Ensure that particles are always < rhi after applying periodic bcs. (#3263)

  -- Fix: queryAdd for resizing vectors (#3220)

# 23.04

  -- Speedup clang tidy (#3219)

  -- Use ccache in Github Actions (#3218)

  -- Clang-tidy fixes
     #3227, #3224, #3222, #3206, #3203, #3202, #3201, #3200, #3197, #3190, #3188, #3176

  -- bug fix in creating EB from STL files (#3223)

  -- Fix bug in MLEBABecLap getEBFluxes(). (#3217)

  -- Add build option for Intel SYCL AOT GRF mode (#3173)

  -- SYCL sub-group size (#3180)

  -- Warning about CPU core oversubscription (#3211)

  -- Fix issues in ParticleContainerBase (#3208)

  -- Add assert that we are not inside threaded region when InitRandom is called. (#3204)

  -- Sorting for faster current deposition (#3198)

  -- Update SUNDIALS NVector constructors (#3165)

  -- ReduceToPlane (#3187)

  -- ParticleContainer: Resize runtime components (#3186)

  -- SYCL: Tweak #3164 and switch to multi_ptr for sincos (#3185)

  -- Fix race condition with TinyProfiler for memory (#3169)

# 23.03

  -- GNU Make: Allow customizing tmp_build_dir (#3177)
     fix recently introduced tmp_build_dir build bug (#3179)

  -- GNU Make: Allow choice of Intel compiler variant (#3175)

  -- CMake: Parallel HDF5 Detection (#3170)

  -- TableData: Relax the static assertion (#3174)

  -- SYCL: Group and subgroup size (#3172)

  -- Add Make.local-pre to gitignore (#3171)

  -- New functions for getting data in cell or line. (#3166)

  -- SYCL: Optimization of small reduction (#3167)

  -- amrex::Math: No longer need to use sycl math functions (#3164)

  -- gitignore: Editors & IDEs (#3163)

  -- SYCL Device Info (#3161)

  -- SYCL AOT: Fix warning (#3159)

  -- GNU Make: make it an error if intel gpu arch for aot is unknown (#3157)

  -- Update Build Systems for oneAPI (#3123)
     SYCL: Fix AOT (#3155)

  -- CI: Add sundials (#3153)

  -- Add static_assert to Mpi_typemap<GpuComplex> (#3154)

  -- SUNDIALS: Replace SUNDIALS math macros with std math functions (#3151)

  -- Fix case where a norm is 1e-15 but not technically zero (#3149)

  -- Fix bug in async IO for particles (#3150)

  -- DPCPP -> SYCL (#3140)

  -- Add MPI support to GpuComplex (#3148)

  -- GNU Make: Add support for Intel LLVM compiler in CPU builds (#3126)

  -- SYCL: Fix the order of destruction (#3146)

  -- Adjust subgroup size for Intel GPUs (#3139)

  -- Runtime parameters for Signal handling controls (#3125)

  -- FillPatcher: Update interpolation in time (#3106)

  -- AmrLevel::FillPatch: Abort if grids are not properly nested for GPU or EB (#3098)

  -- Fix FabArray::shift (#3147)

  -- Fix nl test (#3142)

  -- Fix bug in Device::Finalize: Forgot to clear streams (#3143)

  -- Add a compute face-centered velocity gradient in MLEBTensor (#3133)

  -- Test: Reinit AMReX (#3141)

  -- Functional: Less -> Minimum, Greater -> Maximum (#3138)

  -- Profile memory allocations of the CArena using TinyProfiler (#3105)
     Fix #3105: missing include (#3134)
     Initialize TinyProfiler earlier only for memory (#3137)

  -- PODVector: Add some stream synchronization (#3130)

  -- SENSIE CI: run on ubuntu-20.04. 18.04 is deprecated. (#3131)

  -- NeighborParticles: memcpy -> memcpy_async (#3129)

  -- Rename AMReX_CUDA_MAX_THREADS to AMReX_GPU_MAX_THREADS (#3115)

  -- CI: NVHPC 23.1 (#3122)
     NVHPC: CUDA (#3124)

  -- NVHPC: OpenMP Atomic Capture Fixed (#2378)

  -- oneAPI: Work around compiler bug (#3121)

  -- Multi-grid NeighborList GPU Sync (#3120)

  -- Modify the neighbor particles test to also test selectActualNeighbors. (#3118)

  -- Remove Atomic::Inc and Dec (#3117)

# 23.02

  -- update github actions to use ascent 0.9.0 release (#3114)

  -- CMake 3.18+: Stay OLD CUDA_ARCHITECTURES Policy (#3112)

  -- OpenBCSolver: Fix reuse (#3111)

  -- CMake: Fix AMD Flags for ROCm 5.5 and Bump cmake minimum version to
     3.18 (#3107)

  -- Check component and derive names for `canDerive` and `get` (#3109)

  -- CMake clean up (#3100)

  -- Replace sprintf with snprintf to fix compiler warnings (#3108)

  -- ParmParse: support nan and inf (#3101)

  -- CMake: add offload linker option --whole-archive for ROCm hipcc (#3097)

  -- SinCos: AppleClang Fix (#3094) (#3096)

  -- CMake: Make hypre and PETSc available only if it's not 1D. (#3093)

  -- introduce amrex code of conduct (#3092)

  -- SYCL: Reinforce device compilation preprocessor conditionals (#3090)

  -- New knapsack function to reduce the cost of data movement in load
     balancing (#3079)

  -- GPU single stream region and no sync region (#3073)

  -- Check for small cell before checking for multi-cut (#3088)

  -- Improve AmrMesh::ChopGrids (#3081)

  -- Add extra check for multicut cell (#3087)

  -- Polydisperse neighbor search algorithm (#3060)

  -- GPU UUID and Arena initial size (#3085)

  -- Use IsCallable to detect if F is callable (#3080)

  -- GNU Make: No need to do GCC version check for make clean etc. (#3084)

  -- Mlebabeclap aniso (#2640)

# 23.01

  -- amrex::fillAsync (#3076)

  -- CI: Ascent (#3078)

  -- Add forward declarations for class template friends (#3077)

  -- Update GNU Make file for OLCF (#3070)

  -- HIP: amdgpu-target -> offload-arch (#3069)

  -- GPU kernel fusing in MLPoisson (#3071)

  -- Docs: Sync Before Comms (#3075)

  -- Remove deprecated SYCL declaration (#3074)

  -- Change the type of DeriveRec::DeriveBoxMap to std::function (#3068)

  -- Add CodeQL Scanning (#3059)

  -- Remove old python scripts for releasing (#3066)

  -- Plotfile Reader: Allow multi-word variable names (#3067)

  -- Fix FPE in FillPatcher for RK (#3065)

  -- Fix: Shared CMake builds w/ `AMReX_BUILD_SHARED_LIBS` (#3057)

  -- Add PETSc CI (#3049)

  -- remove plotsinglevar.py (#3063)

  -- Remove old python build scripts from Castro / Maestro (#3064)

  -- Add math functions to amrex::Math (#3008)

  -- remove some astro-specific python routines (#3062)

  -- Gpu Streams: Performance Tuning (#3058)

  -- MLMG: template (#3035)

  -- Add Hypre CI (#3048)

  -- Print host name in backtrace files (#3054)

# 22.12

  -- SYCL: Remove floating-point specialisations for atomic adds (#3050)

  -- Template average down (#2980)

  -- fix compilation of RichardsonConvergenceTest (#3046)

  -- Refactor Boundary Registers (#3028)

  -- Fix Multi-Level Open BC Solver (#3032)

  -- Template average_down_faces (#3040)

  -- Add FabArray::LocalCopy and LocalAdd (#3043)

  -- FabArray::sum (#3041)

  -- amrex::Any::hasValue() (#3025)

  -- Make YAFluxRegister template (#3030)

  -- FabArray::norminf (#3039)

  -- amrex::Dot (#3042)

  -- template FabArray::Saxpy, Xpay and LinComb (#3044)

  -- Use std::max when coarsening a TagBox to preserve TagBox::SET values (#3045)

  -- Update for oneAPI 2023 (#3024)

  -- min/max- and linear combination-preserving interpolater (#3020)

  -- template Xpay (#3031)

  -- CMake: AMReX_BUILD_SHARED_LIBS (#3013)

  -- Fix mis-matched array type that broke mixed-precision restarts (#3026)

  -- Add amrex::demangle for demangling C++ names (#3022)

  -- Add more functionalities to TypeList (#3021)

  -- Add muller to NERSC machines (#3019)

  -- Fix -lquadmath in GNU Make (#3018)

  -- Fix EB tensor solver's boundary when EB is tilted. (#3002)

  -- Add -Wmissing-include-dirs to gcc warning flags (#3012)

  -- A better fix for the PETSc compilation issue (#3011)

  -- Replace all `sprintf` by `snprintf` (#3010)

  -- Use std::less for comparison of pointers (#3007)

  -- Add YAFluxRegister::getFineData (#3004)

  -- C++17 Transition (#2992)

# 22.11

  -- MPI Reduce for ValLocPair (#3003)

  -- `FabArray::isDefined` (#2997)

  -- Make The_Device_Arena non-managed (#2998)

  -- Add alias template Gpu::NonManagedDeviceVector (#2999)

  -- Pre- and Post-interpolation hook interface (#2991)

  -- Add user defined BC types (#2995)

  -- Add BCRec::set for convenience (#2993)

  -- ParallelFor with compile time optimization of kernels with run time parameters (#2954)

  -- 2D RZ solver for WarpX: Arbitrary coefficient (#2986)

  -- Runge-Kutta support for AMR (#2974)

  -- Fourth-order interpolation from fine to coarse level (#2987)

  -- Fix EB data inconsistency when fixing small cells and multiple cuts (#2943)

  -- MFIter::Finalize (#2983, #2985, #2988)

  -- Fix MLMG::getGradSolution & getFluxes for inhomogeneous Neumann and Robin BC (#2984)

  -- MLLinOp::postSolve (#2981)

  -- add templating for the cell bilinear interpolators (#2979)

  -- FillPatcher class (#2972)

  -- Remove sycl namespace alias (#2971)

  -- Fix Tensor Solver BC (#2930)

  -- Disable host device for macros for SYCL/DPC++ (#2969)

# 22.10

  -- Solve an issue with particles async IO when having runtime added variables (#2966)

  -- Fix int overflow in amrex::bisect (#2964)

  -- Fix MLEBNodeFDLaplacian bottom solver (#2963)

  -- make tagging routines EB_aware (#2962)

  -- Volume weighted sum (#2961)

  -- CellData: data in a single cell (#2959)

  -- Quartic interpolation for cell centered data (#2960)

  -- Add GPU-compatible upper bound and lower bound algorithms to AMReX_Algorithm (#2958)

  -- add option for makebuildsources to specify the style arguments for 'git describe'. (#2957)

  -- Add roundoff_lo corresponding to roundoff_hi for domains that don't start at 0 (#2950)

  -- Add template parameter to ParallelFor and launch specifying block size (#2947)

  -- Byte spread fixes (#2949)

  -- CMake: HIP_PATH from ROCM_PATH (#2948)

  -- Fix: Make Finalize->Initialize->F->I->... Work (#2944)

  -- Changes for Cray & Clang (#2941)

  -- Link to cublas when using CUDA and Hypre (#2933)

  -- HIP: use coarse grained host memory (#2932)

  -- EB checkpoint files (#2897)

  -- Fix: Loading Files Again (#2936)

  -- Check if boundary particles container has been created before clearance. (#2935)

  -- SYCL: Replace deprecated atomic types and operations (#2921)

# 22.09

  -- Preserve neighbor particles when sorting particles. (#2923)

  -- Scope of NonLocalBC::ParallelCopy (#2922)

  -- Open Boundary Poisson Solver (#2912)
     Add hypre as an option for OpenBCSolver (#2931)

  -- Fix OOB access of ref ratio on HDF write header (#2919)

  -- Add Polaris to GNUMake (#2908)

  -- Export GpuDevice Globals (#2918)

  -- enable LinOp to use the right Factory (fixes moving geometry problem) (#2916)

  -- Use 1 atomic instead of two per item in DenseBins::build (#2911)

  -- [SYCL] Remove amrex::oneapi and update deprecated device descriptors (#2910)

  -- Add: `MultiFab::sum_unique` (#2909)

  -- In MLMG::mgFcycle, assert that for EB the linop is cell-centered. (#2905)

  -- EB: Add Fine Levels (#2881)

  -- Add rpath to lib64 for ZFP. (#2902)

  -- change data types from double to amrex::Real, and thus we can use single precision for the hypre IJ interface (#2896)

  -- MPMD Support (#2895)

  -- MLMG interface (#2858)

# 22.08

  -- Let `selectActualNeighbors` return right after starting if there are no
     particles for communication. (#2886)

  -- Add Comm Sync to Redistribute (#2891)

  -- Multi-materials and derived variable output (#2888)

  -- Fix host / device sync bug in PODVector (#2890)

  -- MinLoc and MaxLoc Support (#2885)

  -- HIP: Remove the call to hipDeviceSetSharedMemConfig (#2884)

  -- Add Frontier to GNU Make (#2879)

  -- Add option to derefine to AMRErrorTag (#2875)

  -- Fix the segmentation fault in selecting actual neighbor particles. (#2877)

  -- Workaround to bypass issue observed at very large scale with Fujitsu MPI (#2874)
     `TagBoxArray::collate`: Fujitsu Clang (#2889)

  -- Allow zero components MultiFab and BaseFab (#2873)

  -- New EB optimization parameter: eb2.num_coarsen_opt (#2872)

  -- SENSEI 4.0: Fix Build for Particles (#2869)

  -- Cache the neighbor comm tags for the CPU implementation of fillNeighbors. (#2862)

  -- Remove some hard checks in check_mvmc for 3D (#2864)

  -- Carry over fix for ngbxy.smallEnd typo (#2868)

# 22.07

  -- Adding control APIs and namespacing for core algorithm paths like SpGEMM, SpMV, and SpTrans. (#2859)

  -- update the SENSEI in situ coupling for SENSEI v4.0.0 (#2785)

  -- Write runtime attribs to checkpoints on GPUs (#2856)

  -- Fix gnu make on Crusher for mpi_gtl_hsa (#2857)

  -- CMake: FindDependency CUDAToolkit (#2849)

  -- NERSC Programming Environment prototype (#2848)

  -- GNU Make: No need to query mpif90 if Fortran is not used. (#2852)

  -- Remove f90doc (#2851)

  -- Explicitly invoke python3 (#2850)

  -- Maintain the high end of the 'roundoff domain' in both float and double precision (#2839)

  -- add Ok to coordsys (#2844)

  -- ParamParse: Add Files at Runtime (#2842)

  -- Fix a pathological case for 2d EB (#2840)

  -- add fvolumesum to GNUmakefile (#2836)

  -- Clamp particles shifted from plo boundary against rhi, rather than back to plo (#2814)

  -- Fix: CMake NVTX not only Hypre (#2837)

  -- Update sensei CI container for sensei v4.0 integration (#2834)

  -- HIP Memory Advise : Set managed memory to coarse grain (#2835)

  -- CMake: Fix `export` with `AMReX_INSTALL=OFF` (#2838)

  -- make PODVector work with PolymorphicArenaAllocator (#2829)

  -- Re-implement FaceLinear::interp() for InterpFromCoarseLevel (#2831)

  -- Make regrid method of Amr class public (#2833)

  -- amrex::Any (#2827)

  -- Fix line integral computation (#2830)

  -- Fix a bug in multigrid grids (#2823)

  -- Add html, additional sections to README.md (#2775)

  -- Allow StateDataPhysBCFunct to operate on face-centered data (#2819)

  -- Fix Parser ODR (#2820)

  -- CMake: Cleanup old nvToolsExt (#2817)

  -- Handle the case where we don't have enough device memory for the snd_buffer (#2705)

  -- CMake: 3.17+ (#2813)

  -- Landon/fix bug ghost particles (#2812)

  -- Follow-on to 2809; update selectActualNeighbors as well. (#2810)

  -- Generalize the type of callables that can be passed into the neighbor list build function (#2809)

  -- Add AVX2 instructions flag. (#2803)

  -- Avoid M_PI because it's not in the C++ standard (#2807)

  -- In the array version of FillPatchTwoLevels, allow specifying an (#2800)

# 22.06

  -- Fix solvability issue in the nodal solver RAP approach (#2783, #2801)

  -- Profiler Sync Timers (#2784)

  -- Implement Serial ParallelDescriptor::Gather (#2793)

  -- Renamed new internal class variables using m_ convention to fix compiler warnings in debug mode. (#2790)

  -- Make IntVectFromLocation const (#2789)

  -- make sure m_particles is sized properly when numLocalTilesAtLevel is called (#2782)

  -- Fix for small cells (#2781)

  -- Add some timestep controls to the AMReX TimeIntegrator class for its integrate() driver function. (#2780)

  -- Fix the bug in the CMake build with AMReX_BASE_PROFILE. (#2774)

  -- configure value of AMReX_GPU_RDC flag for use in cmake find_package(AMReX ...) (#2770)

  -- Add an optional volume weighting to AMRErrorTag (#2772)

  -- Fix: AmrCore Move (#2773)

  -- Update particle << operator after changes to id/cpu (#2769)

  -- this updates to recent Hypre API changes (#2765)

  -- multilevel version of writeplotfiletoascii (#2742)

  -- Avoid the use of null stream (#2754)

  -- add scomp and ncomp arguments to IntegratorOps functions. (#2759)

  -- Add HDF5 H5Z-ZFP support in CMake (#2753)

  -- CUDA On Cray: More Robust w/o Wrapper (#2757)

  -- Reimplement amrex::min and max to Work around an nvcc bug (#2756)

  -- Revert "Turn on managed memory by default in The_Arena for HIP (#2734)" (#2752)

  -- Add methods for resetting the ParGDB of a ParticleContainer (#2732)

  -- Switch nvtxRangeStart to nvtxRangePush (#2746)

  -- Eb flow diffusive solve (#2741)

# 22.05

  -- Update Required SUNDIALS version (#2743)

  -- EB: Geometry generation from STL file (#2728)

  -- Drop CUDA 9 support (#2736)

  -- Disable AsyncOut by default for HIP and DPC++ (#2735)

  -- Turn on managed memory by default in The_Arena for HIP (#2734)

  -- Update WarpX's MLEBNodeFDLaplacian for 2D RZ (#2733)

  -- Adding more recent Hypre APIs to initialize the library. (#2729)

  -- Allow the computation of neighbor lists between particles of different types. (#2727)

  -- Add option for face linear interpolater in fortran interface (#2726)

  -- Allow some EB code to handle single precision (#2723, #2719)

  -- Allow `FillBoundary` to cast messages from double to single precision. (#2708)

  -- Fix FluxRegister::SumReg for GPU builds (#2718)

  -- Swap hip lib and include ordering (#2717)

  -- Fix integer overflow warnings in FabConv (#2716)

  -- Make AsyncOut::Finish safe to call when async_out is not enabled. (#2715)

  -- flushParForInfo: remove erroneous assertion (#2712)

  -- Link particles in ghost cells to closest box (#2685)

  -- Generalize the type of lambdas that can be passed into ParticleReduce (#2697)

  -- Return non-zero if nans were found when using fnan. (#2704)

  -- Reorganize Make.package in Src/Particle (#2703)

  -- FillPatchUtil edge interpolater fix (#2701)

  -- Adds SUNDIALS integrator options for flexibility. (#2700)

  -- Only error if HDF5 is not parallel if MPI is enabled. (#2699)

  -- Make the ParticleReduce functions not rely on ParIter. (#2695)

  -- Semicoarsening in WarpX Linear Solvers (#2690)

  -- FillBoundaryAndSync (#2683)

  -- macOS: Fix Warning (ranlib, profiler) (#2688)

# 22.04

  -- Fix parser expressions (#2682)

  -- fixes to build CUDA with Clang (#2681)

  -- CI: Apple Silicon (#2672)

  -- Use the roundoff domain in enforcePeriodic. (#2679)

  -- Catch CUDA 11.6 bug at compile time (#2677)

  -- MPI+OMP+HIP build capability (#2676)

  -- EB Flow (#2661)

  -- BackTrace workarounds (#2667)

  -- Redefine ParticleContainter multifab after setting particle boxarray and dmap (#2673)

  -- Handle the case where we lose a level in RedistributeGPU (#2670)

  -- Add int overflow assert check before Bcast wrapper (#2649)

  -- Allow ParticleToMesh and MeshToParticle to access runtime particle components (#2668)

  -- Fix bugs in the MultiBlock test (#2662)

  -- Separate version strings for particle plotfiles and checkpoints. (#2663)

  -- Add support for SZ compression in HDF5 output (#2644)

  -- Removed the use of H5Aget_storage_size (#2656)

  -- Add prefetchToHost and prefetchToDevice for GPU containers (#2655)

  -- Introduce `AMReX_Version.H` (#2653)

  -- Add move assignment operator to Fab (#2652)

  -- Added an option to set fast MRI dt directly instead of using the integer ratio of slow/fast dt. (#2651)

  -- AMReX_Config.H: AMREX_EXPORT_DYNAMIC (#2650)

  -- Fix bug affecting neighbor proc calculation with mesh refinement. (#2646)

  -- Update flags for DPC++ AOT (#2643)

  -- Doc + CMake: AMREX_EXPORT_DYNAMIC (#2635)

  -- Update SpackSmokeTest to run with Fortran and/or HIP. (#2629)

  -- Simplify CoordSys::IsRZ and IsSPHERICAL (#2642)

  -- Take advantage of async copies in PODVector. (#2641)

  -- HIP: atomicAddNoRet (#1809)

# 22.03

  -- ParticleTile: push_back_real/int w/ Vector (#2634)

  -- Update Docs to reflect newer options in MLMG (#2620)

  -- Allow the ghost-particle exchange to communicate different variables (#2627)

  -- Fix AmrParticleContainer::AssignDensity when ncomp == AMREX_SPACEDIM+1. (#2632)

  -- Use async version of cuda/hipMemcpy in PODVector::resize() (#2631)

  -- ParticleContainer::make_alike (#2630)

  -- Update checkpoint format to account for expanded particle ids. (#2624)

  -- Update FabArray::copyTo (#2603)

  -- explicitly request python3 for makebuildinfo_C.py (#2621)

  -- store the CUDA version in build info (#2617)

  -- missing check for mapped solver support when not using GPU (#2616)

  -- Remove ifdefs for older compiler version. (#2614)

  -- Allow a descriptor component's BndryFuncFabDefault to be stateful. (#2612)

  -- TableData: fix missing return in operator= (#2613)

  -- SUNDIALS MRI Interface for AMReX TimeIntegrator class (#2600)

# 22.02

  -- Fix I/O bug in Amr class (#2609)

  -- Spack install instructions for Building section. (#2602)

  -- Kernel fusing in Geometry (#2606)

  -- Kernel fusing in FluxRegister (#2605)

  -- TableData: A Multi-Dimensional Array Class (#2601)

  -- FabSet::multiFab (#2604)

  -- Disable EB solver's phi-on-centroid for hip for now (#2598)

  -- Update locations for tutorials and minor formatting. (#2583)

  -- CI: AMD `hip::device` also for Fortran (#2595)

  -- fix vol initialization for Cartesian in fvolumesum (#2596)

  -- Add headings and steps to plot vector field in ParaView doc section (#2588)

  -- Kernel fusing in FabArrayUtility (#2593)

  -- Change FPinfo's fact_fine_patch to always have ng=1. (#2591)

  -- Support arbitrary refinement ratio in FaceLinear Interpolater (#2590)

  -- Default Arena for MultiFab/iMultiFab/FabArray (#2589)

  -- `add_par` precedence in Docs. (#2575)

  -- Fix typo in 1D version of AMREX_LAUNCH_DEVICE_LAMBDA_DIM (#2587)

  -- CMake: remove nonexistent header file, update minimum sundials version (#2586)

  -- Enable CUDA in CMakeLists.txt for Spack smoke test. (#2581)

  -- Fix warning from hiprand header (#2585)

  -- HIP: amdclang++ (#2582)

  -- Update sundials sycl memory helper interface (#2580)

  -- HIP: Add -munsafe-fp-atomics to CMake (#2577)

  -- ParmPaser::queryAdd (#2573)

  -- Fix regression test configuration (#2574)

  -- Convert switch statement to if statement (#2570)

  -- remove erroneous BL_ASSERT in sundials initialization (#2568)

  -- Support implicit function class defined on host when using device memory explicitly.  (#2563)

  -- HIP: Add -munsafe-fp-atomics to GNU Make (#2567)

  -- GNU Make: Add a new machine, crusher (#2566)

  -- Mapped solver support (#2088)

  -- Update to SUNDIALS 6 (#2551)

  -- Return a zero-size vector in ParallelDescriptor::Gather. (#2560)

  -- Add option not to remove particles with negative ids when calling Redistribute. (#2561)

  -- Update FillPatchTwoLevels for single component face-centered data (#2539)

  -- Kernel fusing in FabArray Comm (#2559)

  -- Use MF ParallelFor in error tagging (#2558)

  -- iMultiFab I/O (#2495)

  -- Embed more EB data in EBFArrayBox (#2550)

  -- CpuBndryFuncFab: Face Data (#2545)

  -- Fix bug in Parser (#2555)

# 22.01

  -- Add Gatherv for USE_MPI=FALSE. (#2549)

  -- Resize vector inside GatherLayoutDataToVector (#2548)

  -- Add missing FillBoundary_nowait (#2546)

  -- add a tool to compute the volume integral of a plotfile field (#2541)

  -- Update MLEBNodeFDLaplacian (#2538)

  -- Update NVector_MultiFab functionality from ATPESC-codes and add to Src/Extern/SUNDIALS (#2505)

  -- Projections migrated to AMReX-Hydro (#2530)

  -- Fix a bug in Robin BC (#2477)

  -- Add ParallelCopyToGhost and fix a bug in FillPatch (#2523)

  -- CMake 3.22+: Policy CMP0127 (#2525)

  -- Add function for make a dmap that is similar to an input MultiFab. (#2526)

  -- Specify dimensions that can be refined with `refine_grid_layout` (#2516)

  -- DPCPP: AMREX_INTEL_ARCH (#2459)

  -- Generalize problem size specification (#2518)

  -- Use specific targets for make uninstall (#2471)

  -- Move Basic Time Integration into AMReX (#2503)

  -- allow the use of SuperParticle in amrex::ParticleToMesh (#2514)

  -- ANSI Escape Codes (#2509)

# 21.12

  -- AMREX_RELEASE_NUMBER (#2448)

  -- Add a function for detecting whether amrex::Initialize has been called or not. (#2501)

  -- Fix fcompare's --abs_tol (#2504)

  -- HDF5: Fix an issue when some MPI ranks have no box at all (#2494)

  -- Signed distance function in 2D (#2490)

  -- Reduce ghost particles in particle communication. (#2480)

  -- Assign initial value to prevent (likely spurious) -Wmaybe_unitialized compiler warning. (#2484)

  -- Fix a corner case in fixing small cells. (#2489)

  -- Added special case for Mac when using rpath (#2479)

  -- Fix multi-level EB nodal solver solvability fix (#2473)

  -- Disable warning on atomicAddNoRet in HIP (#2466)

  -- DPCPP: workaround for the scan issue (#2462)

  -- DPCPP: AOT in GNU Make (#2463)

  -- Implement HOEXTRAPCC for more than single ghost cell (#2456)

  -- Spack Smoke Test (#2460)

  -- Support fmod in Parser (#2395)

  -- HIP: ftrapv causes issues with DEBUG linking (#2455)

  -- DPCPP:  Enable early optimizations (#2454)

  -- New HDF5 schema with separate datasets for different variables (#2432)

  -- InterpFaceRegister (#2452)
    
  -- Fix WarpX EB solver's grad phi computation (#2453)

# 21.11

  -- Set to never write fill values to the dataset for HDF5 output (#2450)

  -- Lower Hypre minimum version to 2.20. (#2446)

  -- Fix use-after-free in the flush of parallel copy meta-data cache. (#2443)

  -- Update MPI config checking to include Intel MPI wrappers for DPCPP (#2435)

  -- Add EBCellFlagFab::getNumRegularCells, getNumCutCells and getNumCoveredCells (#2422)

  -- ExclusiveSum on GPU: return 0 when size of pointer is 0 (#2440)

  -- Multi-component overset solver (#2429)

  -- Use -rpath=dir instead of -rpath dir for dpcpp. (#2439)

  -- DPCPP: Use -g1 for non-debug build (#2438)

  -- DPCPP: Fix warning on tautological-constant-compare (#2436)

  -- Tests: Safe-Guard Module Dirs (#2434)

  -- Remove deprecated BaseUmap (#2425)

  -- Update WarpX EB solver (#2421)

  -- MLNodeLaplacian: Fix max coarsening level for enclosed EB (#2431)

  -- Fix two IO overflow bugs uncovered by NyX. (#2417)

  -- Cleanup of amrdata (#2430)

  -- Set options to allow other Doxygen docs to link to AMReX. (#2424)

  -- Remove DArena and EArena (#2426)

  -- Update MLNodeTensorLap for WarpX (#2416)

  -- Reduce peak memory usage when sorting particles. (#2414)

  -- Extend CellQuadratic Interpolater to 3D (#2409)

  -- Fix 2D bug in EB2::SplineIF (#2407)

  -- Cleanup Tools/Postprocessing/C_src (#2398)

  -- Port CellQuadratic to C++ with GPU support (#2369)

  -- added bamg option to set restriction type (#2402)

  -- Fix dot product mask in EB nodal solver (#2404)

  -- Move Tools/C_util/Convergence/WritePlotFile to Src/Extern/amrdata. (#2397)

  -- Arena Document and PrintUsage (#2403)

  -- BArena: Make a static BArena object (#2401)

  -- Make fcompare print usage and exit if only one plotfile is provided. (#2388)

  -- Add Arena::PrintUsageToFiles for debugging (#2392)

  -- Update c util (#2390)

  -- Adding ILU smoothing parameters for Hypre interface. (#2382)

  -- Avoid free after amrex::Finalize (#2389)

  -- Workaround for nvcc bug that (sometimes) incorrectly complains about unused TinyProfiler variables. (#2383)

  -- Add floor and ceil to parser (#2380)

  -- CI: Groups Include Branch (#2379)

  -- Fix bug in the particle communication routines when the number of chars in the message is > MAXINT. (#2376)

  -- ROCm now supports __managed__ (#2377)

  -- Fix read unitialized memory issue in MLMG solver (#2373)

# 21.10

  -- Update for oneapi 2021.4.0 (#2368)

  -- Port CellConservativeQuartic to C++ with GPU support (#2362)

  -- Port CellConservativeProtected::protect() to C++ with GPU support (#2347)

  -- CMake CUDA Debug: -G by Default (#2355)

  -- OverlapSync nowait and finish. (#2346)

  -- Add another overload for PC::Checkpoint (#2353)

  -- Call setLevelBC from getFluxes in case we have set up the projector
     class but not yet called project (#2345)

  -- Function to atomically set particle ids (#2344)

  -- Remove macro: CRSEGRNDOMP and AMREX_CRSEGRNDOMP (#2339)

  -- Don't rely on mananaged memory in PC::InitOnePerCell (#2337)

  -- TinyProfile parser that saves data in a machine-readable format (#2335)

  -- Fix return type of MLEBNodeFDLaplacian::setEBDirichlet (#2329)

  -- ParReduce (#2327)

  -- Remove some versions of ParallelFor(MF) (#2326)

  -- Update MLMG solver to allow variable number of ghost nodes for variable refinement ratios (#2319)

  -- CMake: Always CUDA Perf-Neutral Debug (#2321)

  -- Add version of SumBoundary that takes src_nghost (#2322)

  -- Remove the Old Fusing Approach (#2308)

  -- Add const to Array's sum and product functions (#2316)

  -- Fix signed/unsigned comparison in diagnostic neighbor list function. (#2312)

  -- HDF5 I/O and Compression  (#2220)

  -- Use ParallelFor(Tag) in Linear Solver Preparation (#2297)

  -- TagBoxArray: Remove omp parallel inside GPU launch region (#2309)

  -- Update DiffMultiFab tool (#2307)

  -- Kernel fusing in linear solver's applyBC (#2295)

  -- Adding new parallel for into normalize method of node laplacian. (#2299)

  -- Gpu::Atomic::If (#2301)

  -- add adaptor and bridge for amrMesh+Particles (#2285, #2364)

# 21.09

  -- Migrate Fortran kernles in the Advection_AmrLevel test to C++. (#2296,
     #2268)

  -- Move slope routines out of amrex into AMReX-Hydro (#2294)
    
  -- GNU Make: Fix GNU builds on Perlmutter, + some bug fixes. (#2286,
     #2293)

  -- Use ParallelFor(Tag) (#2292, #2267)

  -- Optimization of thread safety check in building communication metadata
     (#2288)

  -- SENSEI: Remove amr adaptor/bridge when AMRLEVEL is off (#2258, #2283)
    
  -- ParallelFor(Tag) (#2281)
    
  -- Protect against nullptr when calling PODVector dtor. (#2272)

  -- Parser: Hide local symbols (#2274)
    
  -- Add EditorConfig section for rst files (#2273)
    
  -- Fix bug in the dual grid PC restart in the case where there are no
     particles on some levels. (#2276)

  -- Fix FabArray move-ctor and move-= (#2270)

  -- Fine-tune FabArray::setBndry (#2269)

  -- MF ParallelFor: PETSc (#2262)
    
  -- MF ParallelFor: HYPRE (#2257)

  -- MF ParallelFor: MultiFabUtil (#2256)

  -- Fix Particle CI Tests (#2252)

  -- Github Action Concurrency (#2254)
    
  -- MF ParallelFor: MultiFab (#2249)
    
  -- Reimplement AddParticlesAtLevel for GPU (#2236)

  -- Enable mixed (face) GpuBndryFuncFab (#2238)

  -- Use the new ParallelFor in some FabArrayUtility functions (#2246)

  -- Use new ParallelFor in FabArray (#2245)

  -- CI: Build Embedded Boundaries (#2232)

  -- Also remove empty map entries when calling clearParticles (#2248)

  -- Bug fix of rarely met issue from Tools/CMake/AMReXUtils.cmake file (#2244)

  -- Move MF ParallelFor out of experimental:: (#2241)

  -- Option for dynamic tiling in CPU build of MF ParallelFor (#2235)

  -- Add sum(), product(), size(), {x,y,z}{lo,hi,len}() member functions to
     GpuArray and Array?D (#2217)

  -- Fix derive data in AmrLevel::writePlotFile (#2234)

  -- Add MFNodeBilinear for nodal linear interpolation (#2202)

  -- Adding experimental parfor into the FSmooth method (#2230)
    
  -- Parser: Exception handling (#2233)

  -- Parser: Noinline transcendental functions (#2229)

  -- Adding experimental parfor into the restriction operator (#2204)

  -- Fix PArena (#2221)

  -- Test Build Variant (#2223)

  -- EB: Fix small cells and multicuts (#2225)

  -- Make CreateVirtualParticles use GPU functions for aggregation_type=Cell (#2219)

  -- Change getgradphi in nodalproj (#2222)

  -- Fix EBInterpolater (#2214)

  -- Add EBMFCellConsLinInterp for EB cell data interpolation (#2203)

  -- Bilinear interpolation for cell data (#2205)

  -- CMake: Prebuild & SetupCUDA (#2209)

  -- Reduction of MulitFab to 1D data (#2182)

  -- YAFluxRegister with blocking factor of 1 (#2155)

  -- Fix lincc_interp (#2201)

  -- Add MFPCInterp for piece-wise constant interpolation (#2200)

  -- Fix Coarse/Fine Boundary BoxArray generated in FPInfo for FillPatch (#2207)

# 21.08

  -- Add AsyncVector. (#2197)

  -- Make CreateVirtualParticles use GPU functions for aggregation_type=None
     (#2195)

  -- Change mask for ctr to ctroid interp (#2196)

  -- Add OpenMP support to DenseBins::build (#2193)

  -- Integration of experimental parfor into NodeLaplacian Fapply. (#2190)

  -- Fix filter functions for callables that return bool. (#2192)

  -- MFCellConsLinInterp (#2189)

  -- Introduction of the experimental parfor into NodeLaplacian
     interpolation (#2183)

  -- Enable default construction for AmrParticleContainer and add
     isDefined() method. (#2188) A Particle container is considered
     "defined" if it has been given a set of grids, otherwise not.

  -- Make CreateGhostParticles use GPU functions (#2185)

  -- Add ROCMClang as an LLVM compiler to cmake (#2184)

  -- Scale uniform random interval to account for gridbox length in
     ParticleInit (#2179)

  -- Optimization of ParallelFor for single box FabArray (#2176)

  -- Add ns to gpu cns (#2177)

  -- CI: IntelLLVM known to CMake (#2136)

  -- Add default move constructors / assignment operators for other pc
     types. (#2174)

  -- Gradient in WarpX EB nodal solver (#2171)

  -- Update MacProjector::project to check if m_umac is nullptr (#2166)

  -- EB nodal solver (#2145) New EB nodal solver with Dirichlet EB.  This
     uses a finite-difference stencil.  It will be used by WarpX's static
     solver.

  -- Workaround for a DPC++ reduction issue (#2165)
     More reliable workaround for DPCPP reduction issue (#2167)

  -- Add ParmParse::remove (#2160)

  -- Remove MFGhostIter (#2162)

  -- Fix typos with the help of codespell (#2163)

  -- Parser Precision (#2154) Use double internally.  If the arguments are
     all floats, the final result will be converted to float.

  -- IParser: Integer Parser (#2158)

  -- Disable `jn` in Parser on Windows (#2152)

  -- Fix the size of the BC Vector in the multi-level version of
     ParticleToMesh. (#2149)

  -- Make ParticleToMesh and MeshToParticle support iMultifab. (#2137)

  -- Fix crashes with Conduit Blueprint Code (#2144)

  -- CMake: HIP Modernizing & RDC (#2031)

# 21.07

  -- Parser: This can be used at runtime to evaluate math expressions given
     by strings. It's ported from WarpX. (#2121, #2129, #2132)

  -- Bug fix in neighbor particle list construction. (#2131)

  -- Bug fix in multi-level nodal solver with non-uniform cell size. (#2126)

  -- Add SENSEI Adaptor for Particles Containers (#2016)

  -- Enhance DiffSameGrid2.cpp (#2114)

  -- Don't rely on managed memory in ParticleCopyPlan (#2116)

  -- HIP: Increase to C++17 (#2113)

  -- Port remaining Fortran and CPU kernels in FluxRegister to GPU (#2112)

  -- Reimplement partitionParticlesByDest (#2109)

  -- Fix a bug in in-place ExclusiveSum (#2105)

  -- Add AUTO_BUILD_SOURCES to the dependencies for GNU make (#2101)

  -- Add a number of forward declaration headers (#2100)

  -- CMake 3.20+ CUDA: Fast Math (#2094) Honor CUDA fast math option
    `AMReX_CUDA_FASTMATH` (default: ON) in modernized CUDA CMake logic.

  -- Remove VecReduce and FabReduce (#2091)

  -- Fix indexes bug for particles output in GPU version of packIOData (#2087)

  -- Remove deprecated Reduce functions (#2086)

  -- Disable kernel fusing if gpu rdc is off. (#2083) Because the kernel
     fusing depends on rdc.

  -- ParallelFor for MultiFab/FabArray (#2073, #2089)

  -- ParticleContainer-level reduction functions that work on tuples of data at once. (#2082)

  -- AMReX_PROBINT: Depends on AMReX_AMRLEVEL (#2081)

  -- Arena aliases (#2078)

  -- CMake 3.20+ CUDA: Policy & Include (#2074)

  -- GPU RDC Support (#2061)

  -- Generalize fextract allowing to specify coords perpendicular to slicedir (#2035)

  -- Add interface between sundials SUNMemory and the Arena (#1800)

  -- Do not rely on managed memory in ParticleContainer::WriteAsciiFile (#2070)

  -- Particle plotfile/checkpoint without managed memory. (#2063)

  -- Support preprocessing of AMREX_SPACEDIM in input files. (#2049)

# 21.06

  -- Add roctx ranges to TinyProfiler (#2057)

  -- CMake: Link with HIP_LIBRARIES (#2055)

  -- Extrapolator with nGrow > 1. (#2054)

  -- Perlmutter make (#2058)

  -- Fix to correct CUDA flag and add missing libraries in hypre cmake (#2056)

  -- Remove IndexSequence (#2052)

  -- CMake link with roc::rocprim for HIP (#2050)

  -- Fix PODVector to work without managed memory. (#2048)

  -- When building neighbor masks, perform setVal on device so it will work
     without managed memory. (#2046)

  -- Async Output Docs (#2041)

  -- Option to set amd gpu targets (#2038)

  -- Work-Around: oneAPI 2021.3.0 SYCL with oneDPL (#2025)

  -- ParamParse: Find Entries under Prefix (#2043)

  -- Add relative gradient to AMRErrorTag (#2044)

  -- Workaround argument mismatch in MPI reduce for gfortran >= 10 (#2042)

  -- Wrappers for builtin clz extensions and tests thereof. (#2036)

  -- HIP: AMREX_AMD_ARCH Env Variable (#2034)

  -- Add spock support to GNU make (#2028)

  -- nvcc --display-error-number --diag-error errNum (#2033)

  -- Build neighbor masks without managed memory (#2030)

  -- Option to use oneDPL (#2027)

  -- CMake: add support for CMake >= 3.20 (#2012)

  -- Turn on RDC support for HIP (#2029)

  -- Device profilerStart and profilerStop APIs (#2026)

  -- Launch bounds (#2013)

  -- Arena initial size (#2007)

  -- Use CPU memory in memory pools for OpenMP threads (#2006)

  -- No casting to unsigned long long needed in iMultiFab::sum (#2005)

  -- Arm Clang (#2002)

  -- Templated implementation of ostream operator for both Dim3 and XDim3 (#1997)

  -- Generalize elemwiseMin and elemwiseMax. (#1996)

  -- Optimizing away temporary BoxArrays in AmrMesh::MakeNewGrids (#1994)

  -- Non-blocking SumBoundary (#1991)

  -- Deprecate FabArray::copy() (#1985)

  -- Fix proper nesting issue for large error buffer (#1987)

  -- Update HDF5 I/O to use new HDF5 Async VOL APIs (#1948)

# 21.05

  -- Support OpenMP offload with the NVHPC compiler in GNU make (#1980)

  -- In GNU make, use -MMD -MP instead of -MM to generate dependency if
     supported (#1967)

  -- Workaround compile error on Apple M1 (ARM64) (#1969)

  -- Changes to EB slopes (#1965)

  -- In GNU make, use `LOG_BUILD_TIME=TRUE` to log build time. (#1963)

  -- Using rocPRIM in HIP Version of Scan (#1962)

  -- Reimplementation of ReduceOps (#1955) The new approach does reduction
     in two passes and therefore does not require atomics.

  -- CMake: implement logic to support compiler ID IntelLLVM (new in CMake
     3.20) (#1959)

  -- CPU version of TagBox::buffer (#1957)

  -- Fix out of bound error in AsyncWrite (#1753)

  -- Use pinned memory ad buffer in Fab data I/O (#1956)

  -- Allow user to opt out of renaming MTMPI suffix (#1954)

  -- Port FluxRegister::ClearInternalBorders to GPU (#1952)

  -- Skip temporary in ParticleToMesh when it is not needed. (#1949)

  -- Multilevel version of ParticleToMesh (#1945)

  -- Use CUB for block reduction (#1943)

  -- Reimplementation of PrefixSum with cub (#1942)

  -- Cell-Centered Overset Solver Coarsening (#1915)

  -- Hypre Nodal Setup (#1906) Allow CoarseningStrategy::Sigma in Hypre
     nodal solver and port setup to GPU.

  -- CMake: add support for BOUND_CHECK (#1934)

  -- Alias HostVector to PinnedVector and update documentation. (#1931)

  -- Make CNS work on CPU too (#1930)

  -- std::isfinite/inf for SYCL (#1929)

  -- Update RNG for latest oneAPI (#1928)

  -- Use pinned memory for data transfer between host and device (#1923)

# 21.04

  -- ParmParse parameter, nodal_proj.normalization_threshold, for setting
     the normalization threshold of the bottom linear solver. (#1917)
     The default value of the threshold has been changed from 1e-10 to
     1e-8. (#1914)

  -- Fix a bug in BaseFab::resize. (#1916)  This caused performance issues
     on systems with managed memory and crashes if not.

  -- Option to not zero out input multifab in amrex::ParticleToMesh (#1910)

  -- CMake: add test_install (#1894)

  -- Reimplement increment and incrementwithtotal for particles to take
     advantage of GPUs and OpenMP (#1899)

  -- Return const& in Particle rdata and idata and disallow returning copies
     for rvalues. (#1895)

  -- Update ALaplacian for multi-component and reuse (#1891)

  -- CMake: IPO/LTO (#1890)

  -- Make FabArray::setFab safer (#1884) Instead of taking a raw pointer, it
     takes std::unique_ptr or rvalue FAB, so that the ownership is very
     clear.  It also deletes the old FAB if not null.

  -- Flags: RelWithDebInfo (#1879) Add warning control to CMake Build mode
     `RelWithDebugInfo` (currently default for WarpX).

  -- Build: Windows with Shared Libs (.dll) (#1847)

  -- Remove tutorials documentation from main repo; it now lives at
     https://github.com/AMReX-Codes/amrex-tutorials (#1877)

  -- 2D Poisson and ALaplacian Solvers in 3D Build of AMReX (#1805) New
     capability of solving 2D cell-centered Poisson's and ALaplacian
     equation with 3D build of amrex.

  -- Add FabArray::release and Make BaseFab virtual (#1873)

  -- Robin BC in Linear Solver (#1848)

  -- LevelBld (#1852) This is a breaking change for Amr/AmrLevel based
     codes.

  -- Optimization of CArena::freeUnused (#1865)

  -- CI for macOS: Build a shared library. This is the default in
     Spack. (#1836)

  -- Remove tabs and trailing white spaces (#1860)

  -- Free unused memory (#1861) If Arena is asked to allocate more than
     what's available in the system, try to free unused memory first.

  -- Fortran Interfaces for new FillPatch (#1793)

  -- Arena Release Threshold (#1857)

  -- Feature/non local parallel copy (#1842) This PR introduces "Multiblock"
     capabilities to AMReX.

  -- AMREX_NO_PROBINIT (#1846) For Amr/AmrLevel based codes, there is now a
     compile time option AMREX_NO_PROBINIT=[TRUE|FALSE] for the support of
     the probin file and amrex_probinit function.

  -- Add EditorConfig (#1841)

  -- Fix ncomp bug in linear solver (#1832)

  -- CMake: AMReX_INSTALL (#1831) Add an `AMReX_INSTALL` option that
     controls `install()` generation.

# 21.03

  -- Support multiple components in the ABecLaplacian solver. (#1825)

  -- Add query functions to Arena. (#1823) They can be used to find out the
     memory type and if the memory is accessible on device or host.

  -- CMake: add -Wno-pass-failed to Clang-based compilers (#1815)

  -- Option to cover multiple cuts in EB generation (#1810)

  -- The_Async_Arena and Elixir::append (#1804)

  -- Add function name output option to TinyProfiler. (#1803)

  -- DPCPP: Use codeplay_host_task (#1797)

  -- Add ParticleArray classes (#1796)

  -- ParallelCopy_nowait & ParallelCopy_finish (#1765)

  -- Add FabArray::tags() to return the tags. (#1794)

  -- Bump minimum C++ standard from 11 to 14. (#1787)

  -- Update the preferred short name of NVIDIA HPC SDK to nvhpc (#1788)

  -- Fix precision issue in ParmParse::add (#1783)

  -- Overset Solver with Refinement Ratio of 4 (#1778)

  -- Refinement Ratio of 4 Support in Nodal Solver (#1774)

  -- MSVC: Proper __cplusplus macro (#1773)

# 21.02

  -- Abort when MLMG is detected as failing regardless of verbosity
     setting. (#1762)

  -- Update DPC++ version of Anyof (#1757)

  -- Use ParticleReal for particle interpolation (#1763)

  -- Remove obsolete functions from AMReX particle classes (#1754, #1755)

  -- Make ParticleContainer::Geom always refer to the particle one. (#1470)

  -- Gpu Docs Update (#1758)

  -- Add IntVect versions of numParticlesOutOfRange. (#1751)

  -- Improve the interpolation from cell centroids to face centroids:
     (#1750)

  -- In ParticleToMesh and MeshToParticle, use nGrowVect() to accommodate
     different a different number of grow cells in each dimension. (#1748)

  -- HIP: New Warp Size Macro (#1742) Use new the HIP macro for the warp
     size on various AMD devices.

  -- Add allocator template parameter to ParticleContainer (#1416)

  -- Add ability to calculate slopes on face centroids (#1707) And apply the
     explicit stencil when computing the laplacian.

  -- HIP indirect function and kernel fusing (#1739) Add a GNU Make flag,
     HIP_INDIRECT_FUNCTION=[TRUE|FALSE], and modify the Gpu kernel fusing
     test.

  -- When using CMake 3.15+ allow for MSVC runtime library changes (#1736)

  -- RoundRobin: option to not sort processes (#1721)

  -- EB: edge centroid (#1730) Add edge centroid to the database and make it
     available via EBFArrayBoxFactory.

  -- Fix RegridOnly to regrid even with single level grids (#1722)

  -- Define: _OPENMP -> AMREX_USE_OMP (#1560) Replace the define `_OPENMP`
     with `AMREX_USE_OMP` for all parallel "backend" implementations and
     control of MFIter loops.

  -- Update Make.nrel to accommodate MPT MPI with CUDA enabled (#1726)

  -- Cell-centered Hypre and Petsc setup on GPU (#1709)

  -- ParmParse::hasUnusedInputs & getUnusedInputs (#1716) Add functions to
     find if there are unused `ParmParse` parameters starting with
     `prefix.`.  If `prefix` is empty, all unused `ParmParse` parameters are
     included.

  -- CMake: offer option to exclude Src/Amr from build (#1714)

  -- Make bisect more robust (#1708)

  -- Support single precision build with configure (#1706) Add new arguments
     `--single-precision` and `--single-precision-particles` to `configure`.

  -- Support when CMake 3.18 policy 105 is set to new (#1696)

  -- Optimized function for filling BaseFab of GpuArray (#1692)

  -- BaseFab::minmax (#1691)  Add BaseFab::minmax function and use it in
     VisMF.

  -- New feature in the fextract tool to directly export in the csv format
     (#1634)

# 21.01

  -- Optimization of MLCellLinOp::applyBC (#1690)

  -- Optimization of iMultiFab sum (#1684)

  -- Sanitize the input of mkconfig (#1685)

  -- New versions of Reduce::Min, Max and MinMax taking callable (#1679)

  -- Only issue prefetch if arena uses managed memory (#1678)

  -- GNU Make: Fix the library flags (#1641)

  -- PolymorphicArray4, a thin layer around Array4 allowing us to access
     both AoS and SoA data with operator() (#1643)

  -- CMake: dowstream projects must enable Fortran if AMReX_FORTRAN=ON
     (#1669)

  -- Optimization of FaceLinear interpolater (#1663)

  -- Allow alternate form of "check_pair" function (#1667)

  -- ParallelFor for Reduction (#1658)

  -- Add features to fextract (#1657)

  -- Fix parallel add bug when both USE_GPU and USE_OMP are defined (#1654)

  -- Write a plotfile to ASCII (#1638)

  -- Fix NodalProjector::getGradPhi for multilevel case (#1642)

  -- Remove GPU pragma support (#1650) (#1649)

  -- Remove custom MFIter reduction code (#1648)

  -- Remove support for old versions of DPCPP (#1644)

  -- Fused FillBoundary (#1570)

  -- Divergence Free FillPatch (#1483)

  -- Optimization of constant coefficient MacProjector (#1636)

  -- Optimization of nodal solver with constant coefficient (#1629)

  -- Expose the index of the neighboring particle to users of the
     iterator. (#1628)

  -- Implement overset mask for MLPoisson too (#1604)

  -- Fuse nodal jacobi smoother for GPU (#1625)

  -- Support for SoA data for neighbor particles. (#1590)

  -- Fix a bug that causes errors when writing HDF5 plotfile and particle
     (#1621)

  -- Fortran Interface: Porting more MultiFab functions (#1609)

  -- Remove alternative operators from AMReX (#1599)

  -- EB from STL (#1592)

  -- AMReX_Config.H generated at built time is included in all
     headers. (#1566)

  -- MacProjector: Update setDomainBC API (#1589)

  -- Reimplement NumParticlesAtLevel (#1581)

  -- Add msvc cuda support (#1573)

# 20.12

  -- EB2::PolyIF (#1567) The existing PolynomialIF contains a dynamic size
     vector.  This makes it hard to support it on GPU.  This new PolyIF
     class uses fixed size array and has GPU support.

  -- Tools/Plotfile works for for single precision now. (#1577)

  -- Arena: Add accessor to query Arena attributes through info object
     (#1575)

  -- Allow MacProjection reuse (#1574)

  -- Remove SUNDIALS Fortran interface support (#1559)

  -- Allow MLEBABecLap to solve for multiple components (#1557)

  -- DPCPP: MPI (#1556) Allow MPI for dpcpp build in gnu make assuming
     mpiicpx is used.

  -- Non-local boundary conditions (#1544)

  -- If TheZeroVector() is passed in to SortParticlesByBin, do nothing
     instead of crashing. (#1564)

  -- Scan size type (#1521) Make the size type a template parameter to
     support the scan of more than INT_MAX elements.

  -- DPCPP: Fortran (#1554) Switch from gfortran to ifx that comes with
     oneapi in GNU make.

  -- CMake: generate_buildinfo target (#1545) This commit generates a static
     library `buildInfo::<target>` for the passed user target. This target
     is then automatically linked.  Also, the generated `.cpp` file is now
     scoped properly, avoiding collisions.

  -- nvcc --Werror cross-execution-space-call (#1540) This is turned on by
     default in GNU make, and can be turned on in CMake.

  -- fcompare: Add option for an absolute tolerance check (#1537)

  -- Remove call to cudaDeviceSetCacheConfig (#1536) No longer set CUDA
     device cache configuration to prefer L1 cache.

  -- Assert no nested MFIters (#1530) Add assertion to catch nested MFIters
     (e.g., MultiFab functions are called inside MFIter).

  -- Free MPI_Datatype defined by AMReX (#1527) This fixes a one-time memory
     leak in MPI_Datatypes defined by AMReX as reported in #1525.

  -- make clean & make cleanconfig (#1520) `make clean` now does what `make
     realclean` does.  `make realclean` is kept.  `make cleanconfig` is
     introduced to do what `make clean` used to do.  For most users, `make
     clean` is the one that should be used.

  -- hypre: Adjust singular matrices before hypre solves (#1519)

  -- CMake: overhaul options (#1490)

  -- New Reduce::Sum function taking lambda function (#1508)

  -- GNU Make: AMREX_CUDA_ARCH (#1507) Option to use AMREX_CUDA_ARCH in
     addition to CUDA_ARCH to set CUDA arch.  If AMREX_CUDA is set, it will
     be used over CUDA_ARCH.

  -- Add option for device sync at beginning and end of TinyProfiler region
     (#1505) Now when setting
     `tiny_profiler.device_synchronize_on_region_end = 1` in the inputs
     file, we will synchronize before calling nvtxRangePop() and
     nvtxRangePush(), which means that TINY_PROFILE regions will include the
     full kernel time, rather than just the kernel launch time.

  -- CMake; bump up hypre minimi required version (#1503)

# 20.11

  -- The default hypre interface in MLMG is now IJ matrix for both EB and
     non-EB.  Previously, it was semi-struct for non-EB. (#1492)

  -- USE_SAVE_TEMPS option in GNU Make system for HIP. (#1492)

  -- The device version of `Error`, `Abort` and `Warning` is no-op, unless
     `NDEBUG` is defined. (#1492)

  -- Ascent: Use Default Name for Mesh Ghost (#1488)

  -- Add fill method to GpuArray (#1472)

  -- Add Gpu::Atomic::AddNoRet (#1469)

  -- Option to make the code NOT enforce solvability in MLMG for singular
     problems. (#1471)

  -- CMake: improve HDF5 support (#1468)

  -- CMake: FindPETSc must not overwrite CMAKE_Fortran_FLAGS (#1464)

  -- CMake: prevent in-source builds (#1453)

  -- change char * to char const* so SWFFT code compiles with USE_CUDA=TRUE
     (#1454)

  -- Fix when small_volfrac is used -- we need to adjust the data in cut
     cell neighbors as well as regular neighbors. (#1451)

  -- Allow users to set a Geometry object for ParticleContainer
     independently of the AmrCore / AmrLevel object. (#1446)

  -- HDF5 plotfile write bug fix and performance improvement (#1448)

  -- CMake: add HIP support (#1316)

  -- NodalProjector: use volume-weighted average down (#1444)

  -- Fix race conditions in EB interpolation from cell centers to faces
     (#1443)

  -- Allow tagging value to vary by level (#1441)

  -- Hypre with overset (#1439)

  -- Hypre IJ interface: Enable access to additional solvers and
     preconditioners available in Hypre (#1437)

  -- Fix CPU version of uninitailiedFillNImpl in PODVector (#1435)

  -- CMake: Fix missing compile time definitions for HYPRE/PETSc (#1436)

  -- Fix bug in EB extdir slopes (#1434)

  -- Make the id and cpu members of amrex_particle private, as they should
     no longer be accessed directly. (#1433)

  -- Disable OpenMPI C++ binding in GNU make system (#1398)

  -- Fix a long standing bug in eb levelset (#1432)

# 20.10

  -- CMake: fix ENABLE_PROFPARSER and ENABLE_SENSEI options (#1428)

  -- Remove EB LSCore and levelset, and reimplement signed distance function
     capability. (#1429 & #1425)

  -- Remove flags setCGVerbose and setCGMaxIter since those are more
     accurately called setBottomVerbose and setBottomMaxIter.  The
     "setCG..."  flags are misleading since they actually apply to non-CG
     bottom solvers as well. (#1413)

  -- Remove GetPosition and SetPosition from ParIter.  These were added for
     WarpX, but they are not used any more. (#1408)

  -- Only check the requested MPI Threading level if AMReX also initialized
     MPI. (#1406)

  -- DPCPP support for multiple GPUs (#1392)

  -- Random Number Generation on Device (#1363) In order to support RNG on
     device with DPC++, we have to change the API because DPC++ does not
     support global device variables.

  -- Remove redundant particle tests and old/obsolete/non-test tests (#1389
     & #1381)

  -- Gpu kernel fusing is integrated in MFIter. (#1332)

  -- New runtime parameter, amrex.max_gpu_streams. (#1386)

  -- Switch to `use mpi` from `include 'mpif.h'` (#1385)

  -- Remove reliance on managed memory from
     AMReX_ParticleCommunication.H/.cpp (#1380)

  -- CMake: re-organize tutorials (#1333)

  -- Implement Particle in a way that does not involve UB. (#1337)

  -- amrex::EB_average_down(): Fix indexing error. (#1360)

  -- Only add one copy of the ghost particle regardless of how many isects
     we have (#1359)

  -- Add non-EB slopes and extend the generality of EB slope routines in 2D
     and 3D (#1350)

  -- Async IO: Check Runtime Threading (#1351)

  -- Changes to make AMR codes compiled with EB but not building any
     Geometry work as if it is all regular. (#1349)

  -- Fix mkconfig.py (#1344)

  -- Add -Xcudafe --diag_suppress=esa_on_defaulted_function_ignored to
     suppress spurious warnings from nvcc. (#1342)

  -- EB extend_domain_face (#1321)

  -- Add parameter that stores OpenMP support version (#1325)

# 20.09

  -- Fix interpolation coefficients for EB stencil in cell-centered linear
     solvers when the EB surface at the domain boundary is tilted.

  -- Add a parameter to `AMReX_omp_mod` that can be used by Fortran code to
     check whether AMReX was built with OpenMP support, and, if yes, what
     the version number (_OPENMP) was at the time AMReX was compiled.

  -- CMake: re-write genex evaluation functions.

  -- Extend the number of unique particles per cpu we can have at once.

  -- Add a new method to the `amrex_distromap` type in
     F_Interfaces. `get_pmap` fills a caller-owned array of PEs.

  -- Fix a long standing bug in GNU make system on the use of HOST and
     HOSTNAME.

  -- Add Scan::InclusiveSum and ExclusiveSum for CPU to avoid ifdef.

  -- Add check for empty probin_file in Amr::restart.

  -- Update Sundials interface, documentation, and build to be version
     agnostic.

  -- Updates for ROCm 3.6 and 3.7.

  -- Add section to Make.unknown for intel mpi.

  -- CMake: re-factor third party libraries setup.

  -- Port TagBoxArray to GPU.

  -- Fix a bug in matching of COMP_VERSION to correctly treat CCE > 9.

  -- By default, EB outside the domain will be generated by extending from
     the domain faces.

  -- Fix an issues due to roundoff error in determining whether particles
     are inside the domain.

  -- Remove Perilla because it's incompatible with our GPU strategy and it's
     no longer being maintained.

  -- Switch the overset mask convention to that 1 means unknown and 0 means
     known.  The new convention is more convenient for AMR-Wind.

  -- Remove old solvers, Src/LinearSolvers/C_CellMG and C_TensorMG.  They
     have been superseded by Src/LinearSolvers/MLMG.

  -- MacProjector: allow for re-use of the object and enhance multi-level
     algorithm.

  -- Add asserts for bounds checking to Array1D and Array2D.

  -- Optimization of the construction of SFC.

  -- Refactoring of particle buffer map.

  -- Optimization of FPinfo and complementIn.

  -- Move the Amr/Extrapolater used in IAMR/PeleLM to C++/GPU compliant.

  -- Less surprising behavior for the ok() method of FabArray. This makes
     the `ok()` method of FabArray return `false` instead of crashing if the
     `define()` method has yet to be called.

  -- Optimization of regrid.

  -- Special FillBoundary for Almo.

  -- Fix the average_down_faces calls in linear solvers to see periodicity.

  -- Make sure the calculation of divu at inflow face in nodal projection
     does not use tangential velocities on an inflow face.

# 20.08

  -- New average_down_faces functions that take periodic boundary into account.

  -- Update the documentation for Nsight.

  -- Fix a bug with HDF5 boxcenter data.

  -- New runtime parameter, `eb2.extend_domain_face`, that can be used to extraploate EB information
     from domain faces.

  -- New GNU Make options for GCC and Clang, `WARN_ALL` and `WARN_ERROR`. `WARN_ALL` turns on more
     compiler warnings.  `WARN_ERROR` turns warnings into errors.

  -- Fix various compiler warnings.

  -- Fix memory fragmentation issue with communication buffer.

  -- Semi-coarsening support in linear solvers.

  -- Fix virtual particle issues.

  -- Capability to fuse GPU kernel launches.

  -- Make ghost particles support soa data.

  -- CMake: ability to export build tree.

  -- Reset amrex_geometry_module initialization state when finalizing.

  -- Remove Long version of Gatherv.

  -- Optimization of TagBoxArray::collate.

  -- CMake: fix missing PETSc setup in Config file.

  -- BndryFunc for nodal data.

  -- MLMG Hypre fix for singular problems.

  -- Add particle copy filters.

  -- Async output support for particles.

  -- BackgroundThread class.

# 20.07

  -- Nodal hypre solver now supports coarsening before hypre is called.

  -- A new ParmParse parameter, `amrex.the_arena_is_managed` is introduced to set the default memory
     type of `The_Arena`.

  -- MFIter is now OMP thread safe when it is compiled with GPU support.

  -- Overset support is added to cell-center and tensor linear solvers.

  -- Remove compile time flag, BACKTRACE, for simplicity.

  -- Updates on Blueprint and Ascent.

  -- HDF5 support in GNU Make and CMake.

  -- CMake support for DPC++.

  -- Add -DNDEBUG for non-debug build.

  -- Support for Windows.

  -- Support for ParallelContext in Particles.

  -- Non const iterator for neighbor list.

  -- Tool for comparing single-level plotfiles of all nodalities.

  -- GNU Make: Use -M instead the perl script to generate dependencies.

  -- Particle: Remove directly accessing the m_idata and m_rdata structs internally.

  -- Extend the makeSFC method to take an additional argument where the user can override the number
     of processes a BoxArray is distributed to.

  -- Turn tiling off by default for gpu.

# 20.06

  -- Set a non-default CMAKE_INSTALL_PREFIX only if AMReX is the
     top-level CMake project. Otherwise, the default of a downstream
     project using AMReX as subproject will be placed in a quite
     confusing, temporary directory.

  -- C order support for Array2D and Array3D.

  -- Disable unqualified abs function within amrex namespace.

  -- Updates for SENSEI 3.2.

  -- CMake: link to OpenMP::Fortran only when needed.

  -- DPC++ support.

  -- Add non-const data() to GpuArray.

  -- Fix HIP version of scan.

  -- Return immediately from GPU memcpy if size is zero.

  -- Documentation on EB linear solvers.

# 20.05

  -- AMReX's git history has been rewritten.  If you have problems due
     to this, follow the instruction here. https://xkcd.com/1597/  We
     also have a new CONTRIBUTING.md.

  -- EB linear solvers: You now need to specify the location of
     diffusion coefficient (face center or face centroid) and the
     location of the unknowns (cell center or cell centroid).

  -- Optimization of makeKnapSack and makeSFC.

  -- Unification of GPU and CPU versions of neighbor particle /
     neighbor list implementations.

  -- New HostDeviceParallelFor functions that can run on either host
     or device depending on the launch region flag.

  -- Add CUPTI trace for CUDA kernel timing.

  -- Implement AMReX_FORTRAN (BL_NO_FORT) option in CMake.

  -- Fix CUDA build of tools.

  -- Fix invalid git version in CMake.

# 20.04

  -- BaseFab can no longer be used on device.  Many BaseFab functions
     now requires RunOn::Device or RunOn::Host template parameter when
     GPU support is enabled.

  -- FillPatch* functions are now templated to support FabArray in
     addition to MultiFab.

  -- Fix -pthread for nvcc by default in Make.unknown

  -- EB now has the option to build coarse level from GeometryShop
     when coarsening from fine level fails.  This could be used for
     hyperbolic system with EB resolved to the finest level

  -- CMake: add C++ 17 among valid options for AMREX_CXX_STANDARD

  -- Add option to set fixed number of iterations in the Fortran
     interface of linear solver

  -- Fabs in alias FabArray now carries EB information.

  -- Add AMREX_LOOP_3D and 4D macros.

  -- Make amrex::Random() return numbers in the same interval for both
     CPU and GPU: [0:1)

  -- More flux register functionality for flash

  -- Chunked partition in particle redistribution to use less memory.

# 20.03

  -- AmrCore can now be built without using ParmParse.

  -- Improve BL_NO_FORT support.

  -- Fix OMP bug in MFIter constructors taking BoxArray and
     DistributionMapping.

  -- Cray compiler has been re-enabled in CMake.

  -- For device only code, the users can now use #if AMREX_DIVICE_COMPILE.

  -- Fix an integer overflow issue in TileArray cache.

# 20.02

  -- RealVect updated for GPU.

  -- Support for restarting from HDF5 particle checkpoint file.

  -- Improvement of MacProjector and NodalProjector

# 20.01

  -- GPU host device version of swap.

  -- Fix an edge case of gpu block reduce where the block size is less
     than a warp.

  -- Always check MPI buffer size for overflow.

  -- CMake support for PETSc.

  -- Include C sources in the CUDA proprecessing.

  -- It's now safe to construct a zero components Fab.

  -- CXXSTD: option to set c++ standard in GNU make system

  -- Improve performance of the nodal linear solver on GPU.

# 19.12

  -- Fix potential deadlocks in amrex::Random.

  -- MultiFab::Swap that does shallow swap if it can, does deep swap
     otherwise.

  -- FabArray::arena function that returns the Arena used to build.

  -- Nodal projection sync residuals are implemented for RAP.

  -- GPU support for initializing Fabs to NaNs.

# 19.11

  -- AmrCore::regrid will now simply return instead of abort if the
     base level is already the maximal level.

  -- Add NodalProjector that wraps MLMG for convenience.

  -- Enforce in AmrCore that blocking factor must be a power of 2.

  -- Add support to write plotfile in HDF5 format.

  -- FabArray's Reduce functions can now take lambda working on Array4
     in addition of FAB.

  -- Add AMREX_REAL_MIN, AMREX_REAL_MAX and AMREX_REAL_LOWEST for
     convenience.

  -- GPU launch functions and macros are now safe with empty boxes.

  -- Remove FabView from BaseFab.

  -- Avoid race conditions in GPU reduction code called multiple
     times.

  -- MLMG tensor solver is fixed for AMR.

# 19.10

  -- Add inhomogeneous Neumann BC to MLMG for convenience.

  -- Fix a corner case of tensor solver.

  -- Various fixes for single precision and particle real.

  -- Add amrex::Long that has a size of 8.

  -- Add int8_t support in typecheck.

  -- C++ user literal _rt for amrex::Real and _prt for
     amrex::ParticleReal.

  -- EB MAC projector now requires the user to specify whether the
     face velocities are defined on face centers or centroids.

# 19.09

  -- First pass of Sr/EB on GPU.

  -- Optimization of particle redistribution.

  -- EB integral: add integral of x*y*z

  -- HostDevice::Atomic::Add that does atomic add for both device and
     host omp code.

  -- makeFineMask: optional arguments specifying coarse and fine flag
     values.

  -- Optimization of FabArray communication for GPU by merging small
     kernels.

# 19.08

  -- MacProjector has the option to set maximal coarsening level.

  -- OwnerMask and OverlapMask are now built on GPU.

  -- Random number generation on GPU no longer requires an call to
     initialize seeds.  They are done in amrex::Initialize and resize
     is not needed when launching with more threads than the size of
     seed array.

  -- Optimization of NeighborParticles.

# 19.07

  -- Geometry/CoordSys: Static class members have been removed.
     Functions such as `isPeriodic`, `isAnyPeriodic`, `isAllPeriodic`,
     `ProbLo`, `ProbHi`, `IsCartesian`, `IsRZ`, and `IsSPHERICAL` are
     now non-static.  The default Geometry can been obtained via
     `DefaultGeometry()` function.

  -- Function amrex::Loop and amrex:LoopConcurrent are added to help
     looping over cells in a Box.

  -- Nodal solver: A bug in nodal owner mask that could affect
     covergence was fixed.

  -- Fortran amrex_amrcore_module: add amrex_set_boxarray,
     amrex_set_distromap, and amrex_set_finest_level.

  -- Option to allocate MultiFab data in arenas different from
     The_Arena().

  -- Option to tag MultiFabs and query their memory usages.

  -- AsyncFab has been deleted.

# 19.06

  -- Geometry/CoordSys: New constructor and define function are added.
     We plan to remove static data from Geometry and its base CoordSys
     in the next release.  This means most of the static functions in
     Geometry class will become non-static.  These include
     `isPeriodic`, `isAnyPeriodic`, `isAllPeriodic`, `ProbLo`,
     `ProbHi`, `IsCartesian`, `IsRZ`, and `IsSPHERICAL`.  You can
     prepare codes now for the upcoming changes.  In almost all cases,
     all you have to do is replace `Geometry::function` with
     `DefaultGeometry().function`.

  -- Add tensor linear solvers for viscous flows with and without EB.

  -- Algoim: A modified version of Algoim is added.  This removes the
     dependence of 3d EB nodal MLMG solver on the official Algoim code
     and Blitz.

  -- EB: Fix the potential ownership issue is IndexSpace.

  -- Add a new FillPatchTwoLevels for EB.

# 19.05

  -- Interface of virtual function Interpolater::interp has changed.

  -- Add Fortran funcntions for shared memory reductions.

  -- EB nodal linear solver: The default bottom solver is now bicgcg.
     It starts with bicgstab and switches cg if bicgstab fails.

  -- EB nodal linear solver: Finished the implementation of matrix
     coarsening with RAP.

  -- Particle: Option for adding runtime struct of array components.

  -- Add a trilinear interpolation option for 3D.

  -- Add more support for non-uniform grow vectors to MultiFab and
     FabArray.

  -- AmrMesh: n_error_buf is now IntVect.  This allows for different
     number of error buffer cells in different directions.

  -- Using PETSc as bottom solver no longer requires Hypre.
 
# 19.04

  -- SUNDIALS 4 support.

  -- Option to disable device sync in MFIter.

  -- Functions for prefetch unified memory.

  -- GNU Make system: It is now an error if a function with return
     type does not return.

  -- GNU Make system: Pass C++ flags to nvcc when compiling C codes.

  -- Allocate 3/4 of gpu memory upfront in The_Arena.

  -- BaseFab now has Allocator template parameter.

  -- Random number generation on gpu.

# 19.03

  -- Deprecated Fortran framework F_BaseLib and linear solver F_MG
     have been removed.  A number of tools written in F_BaseLib have
     been migrated to Tools/Plotfile/.  Note that the Fortran wrappers
     to C++ (F_Interfaces) are still there.

  -- In addition to launch macros, there are now functions for
     launching, amrex::launch, amrex::For and amrex::ParallelFor.
     These improves debuggability. 

  -- If compiled with BASEFAB_IS_PINNED, pinned memory will be used
     for BaseFab meta-data.  On systems with nvlink, this improves the
     performance a little bit.

  -- Performance improvement in particle redistribution.

  -- Particle NeighborList has been moved from tutorial to AMReX
     proper.

  -- Cell-centered MLMG linear solver have been ported to GPU.

# 19.02

  -- Array4 class that contains the important information in BaseFab
     class.  It can be captured by lambda and used on gpu.

  -- A number of new macros for launching for loops: AMREX_FOR_1D,
     AMREX_FOR_3D, AMREX_FOR_4D, AMREX_PARALLEL_FOR_1D,
     AMREX_PARALLEL_FOR_3D, and AMREX_PARALLEL_FOR_4D.

  -- Disable cuda aware MPI by default.  It can be enabled with
     parameter amrex.use_gpu_aware_mpi.

# 19.01

  -- Documentation and Tutorials on GPU

  -- EB implicit function using spline

  -- FabArray::fabPtr() function takes MFIter and returns a device
     pointer to BaseFab.

# 18.12

  -- More GPU supports

# 18.11

  -- GPU support in Base and Particle

  -- BaseFab is no longer polymorphic

  -- EB now supports ghost cells outside physical domain

# 18.10

  -- MacProjector class for MAC projection

  -- Support for Dirichlet EB in linear solver

  -- Option to use PETSc as bottom solver

  -- Multi-level linear solver with EB not crossing coarse/fine
     boundary. 

  -- Sundials 3 support

# 18.09

  -- Cell-centered linear solver with homogeneous Neumann embedded
     boundary. 

  -- Hypre as a bottom solver has a IJ matrix interface and supports
     homogeneous Neumann boundary condition on embedded boundary.

  -- Old embedded boundary codes have been removed.

# 18.08

  -- Faster geometry generation is available at Src/EB2.
     Tutorials/EB/CNS is now based on EB2.

  -- AMReX is now fully compliant with xSDK.

  -- Fortran interface for particles.  See Tutorials/Amr/Advection_F/
     for an example.

# 18.07

  -- Pre- and post-interpolation hooks in FillPatch.

  -- NDEBUG is no longer defined in xSDK mode.

# 18.06

  -- When amrex::Initialize is called, optional std::ostream arguments
     can be passed in and their defaults are std::cout and std::cerr.

  -- ParmParse inputs files can now contain Fortran namelist that can
     be accessed from Fortran (and Frotran only).  These Fortran inputs
     are stored in amrex_namelist character variable in
     amrex_parmparse_module, and can be read with standard Fortran
     I/O.
     
  -- There is a new non-blocking parallel copy function in
     MultiFab/FabArray called ParallelCopy_nowait.  It returns a
     CopierHandle object and can later be used to finish the
     communication with CopierHandle::finish().

# 18.05

  -- FillBoundary and ParallelCopy functions can now take IntVect
     arguments as the number of ghost cells.  That is the number of
     ghost cells could be different for different directions.

  -- MultiFab, iMultiFab and FabArray can have different number of
     ghost cells in different directions.

  -- Fortran module mempool_module has been renamed amrex_mempool_module.

  -- Many macros have been renamed.
     * USE_PARTICLES and PARTICLES have been renamed AMREX_PARTICLES
     * DIMENSION_AGNOSTIC has been renamed AMREX_DIMENSION_AGNOSTIC
     * USE_CVODE has been renamed AMREX_USE_CVODE
     * DEBUG has been renamed AMREX_DEBUG

 -- amrex::Array is now an alias to std::array in stead of amrex::Vector.

# 18.04

  -- New BoxList constructors making a given number of Boxes from a
     single Box.

  -- Optimization of particle redistribution

  -- MLMG nodal linear solver: add solvability fix

  -- Modification to amrex::Initialize and Finalize to make it
     suitable as a library in an application that does not use AMReX
     as a framework.

# 18.03

  -- STL support for EB

# 18.02

  -- Fortran interface: added new functions amrex_multifab_build_alias
     and amrex_imultifab_build_alias.

  -- Documentation in reST/Sphinx.  See Docs/Readme.sphinx for more
     details.

  -- Src/LinearSolvers/MLMG now supports nodal based data.

  -- Fortran module AMReX_fillpatch_module takes a user provided
     callback function for filling physical boundary conditions.  That
     function used to use 0-based index for component (i.e., the last
     index).  For consistence with 1-based index for component in
     other Fortran modules, this has been changed to 1-based index for
     component.

# 18.01

  -- New linear solver MLMG at Src/LinearSolvers/MLMG/.  Currently it
     supports cell-centered single level and multi-level composite
     solve.  Fortran interface is also available at
     Src/F_Interfaces/LinearSolvers/.  See Tutorials/LinearSolvers for
     tutorials.

# 17.12

  -- Ported more features (including dynamic scheduling and explicit
     tile size) of MFIter from C++ to Fortran.

  -- Added procedures to Fortran amrex_multifab_module to add,
     subtract, multiply, divide, saxpy and lincomb (linear
     combination).  Note that we call it saxpy, but it doesn't mean
     single precision.

  -- The `configure; make; make install` build approach enables linear
     solvers by default now.

  -- MultiFab and iMultiFab now support move assignment operator.
     This allows for swapping two MultiFabs without deep copying.  For
     instance, std::swap(mf1, mf2);

  -- Tutorials/Amr/Advection_AmrCore changes from using
     `Vector<unique_ptr<MultiFab>>` to `Vector<MultiFab>`.

# 17.11

  -- AMREX_ASSERT_WITH_MESSAGE and AMREX_ALWAYS_ASSERT_WITH_MESSAGE
     are new macros for assertion when it fails additional message
     will be printed.   For example:

         AMREX_ASSERT_WITH_MESSAGE(x > y, "reason why x > y must be true");

  -- amrex::Array is deprecated and replaced by amrex::Vector.
     Currently Array is an alias to Vector.  So this should not break
     any codes.  In the future, we will remove Array completely.
     Therefore it is recommended that application codes should start
     replacing Array with Vector.  There is a script,
     amrex/Tools/Migration/amrex_array_to_vector.sh, to help.  But use
     it with caution.   If it is completely gibberish to you, you
     probably shouldn't use the script. 

  -- functions for printing to a file in a parallel and thread-safe manner
     have been added. For example:

        amrex::AllPrintToFile("output") << "Hello from rank " << rank << 
                                           " and thread " << thread << "\n";

     will print out the requested information to separate files for each 
     rank and thread.

# 17.10

  -- Added a load balance approach to Amr/AmrLevel.  The runtime
     parameters for this is amr.loadbalance_with_workestimates and
     amr.loadbalance_level0_int.  The latter is for single level
     (i.e., amr.max_level=0) only.  For multi-level runs, load balance
     is done during regrid and thus the load balance interval is
     controlled by amr.regrid_int.  To use this approach, AmrLevel
     derivative must has a StateData for work estimates and its index
     is returned by virtual function int WorkEstType().

  -- MFIter now supports dynamic scheduling of OpenMP threads.  For
     example,
 
       for (MFIter mfi(mf, MFItInfo().SetDynamic(true).EnableTiling(tile_size);
            mfi.isValid(); ++mfi)
       { ... }

  -- Added EBFluxRegister to Src/EB for refluxing and
     re-redistribution in EB.

  -- amrex.signal_handling = 1 is a new runtime parameter that can be
     used to control whether AMReX should handle signals like SIGSEGV
     etc. 
