# Notes on the Cache Cleanup Workflows

There are two cache cleanup workflows, [CleanUpCache](cleanup-cache.yml) and
[CleanUpCachePostPR](cleanup-cache-postpr.yml). The former is triggered by
workflows listed in [clean-cache.yml](cleanup-cache.yml) (e.g., LinuxClang,
cuda, LinuxGcc, etc.). The latter is triggered by the close or merge of a
PR. The CleanupCache workflow will keep the last used cache and delete all
others, whereas the CleanupCachePostPR workflow will delete all caches
associated with the PR. Note that these workflows always run on the default
branch. That is the yml files on the default branch are used.

Below are more details of these events.

## If a cache cleanup workflow is triggered by

### Push to a feature branch on a fork

The workflow below runs on the fork, not the main repo. However, if a PR of
this branch has been submitted to the main repo, it will also trigger the PR
workflows on the main repo.

<details>
  <summary>Information of CleanupCache workflow</summary>

```
github.ref = refs/heads/main
github.head_ref = refs/heads/main
github.event =
{
  "action": "completed",
  "repository": {
    "allow_forking": true,
    "archive_url": "https://api.github.com/repos/WeiqunZhang/test_ci/{archive_format}{/ref}",
    "archived": false,
    "assignees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/assignees{/user}",
    "blobs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/blobs{/sha}",
    "branches_url": "https://api.github.com/repos/WeiqunZhang/test_ci/branches{/branch}",
    "clone_url": "https://github.com/WeiqunZhang/test_ci.git",
    "collaborators_url": "https://api.github.com/repos/WeiqunZhang/test_ci/collaborators{/collaborator}",
    "comments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/comments{/number}",
    "commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/commits{/sha}",
    "compare_url": "https://api.github.com/repos/WeiqunZhang/test_ci/compare/{base}...{head}",
    "contents_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contents/{+path}",
    "contributors_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contributors",
    "created_at": "2023-03-29T23:33:24Z",
    "default_branch": "main",
    "deployments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/deployments",
    "description": null,
    "disabled": false,
    "downloads_url": "https://api.github.com/repos/WeiqunZhang/test_ci/downloads",
    "events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/events",
    "fork": true,
    "forks": 0,
    "forks_count": 0,
    "forks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/forks",
    "full_name": "WeiqunZhang/test_ci",
    "git_commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/commits{/sha}",
    "git_refs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/refs{/sha}",
    "git_tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/tags{/sha}",
    "git_url": "git://github.com/WeiqunZhang/test_ci.git",
    "has_discussions": false,
    "has_downloads": true,
    "has_issues": false,
    "has_pages": false,
    "has_projects": true,
    "has_wiki": true,
    "homepage": null,
    "hooks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/hooks",
    "html_url": "https://github.com/WeiqunZhang/test_ci",
    "id": 621066743,
    "is_template": false,
    "issue_comment_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/comments{/number}",
    "issue_events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/events{/number}",
    "issues_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues{/number}",
    "keys_url": "https://api.github.com/repos/WeiqunZhang/test_ci/keys{/key_id}",
    "labels_url": "https://api.github.com/repos/WeiqunZhang/test_ci/labels{/name}",
    "language": "C++",
    "languages_url": "https://api.github.com/repos/WeiqunZhang/test_ci/languages",
    "license": {
      "key": "bsd-3-clause",
      "name": "BSD 3-Clause \"New\" or \"Revised\" License",
      "node_id": "MDc6TGljZW5zZTU=",
      "spdx_id": "BSD-3-Clause",
      "url": "https://api.github.com/licenses/bsd-3-clause"
    },
    "merges_url": "https://api.github.com/repos/WeiqunZhang/test_ci/merges",
    "milestones_url": "https://api.github.com/repos/WeiqunZhang/test_ci/milestones{/number}",
    "mirror_url": null,
    "name": "test_ci",
    "node_id": "R_kgDOJQS59w",
    "notifications_url": "https://api.github.com/repos/WeiqunZhang/test_ci/notifications{?since,all,participating}",
    "open_issues": 0,
    "open_issues_count": 0,
    "owner": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "private": false,
    "pulls_url": "https://api.github.com/repos/WeiqunZhang/test_ci/pulls{/number}",
    "pushed_at": "2023-04-01T17:08:01Z",
    "releases_url": "https://api.github.com/repos/WeiqunZhang/test_ci/releases{/id}",
    "size": 2,
    "ssh_url": "git@github.com:WeiqunZhang/test_ci.git",
    "stargazers_count": 0,
    "stargazers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/stargazers",
    "statuses_url": "https://api.github.com/repos/WeiqunZhang/test_ci/statuses/{sha}",
    "subscribers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscribers",
    "subscription_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscription",
    "svn_url": "https://github.com/WeiqunZhang/test_ci",
    "tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/tags",
    "teams_url": "https://api.github.com/repos/WeiqunZhang/test_ci/teams",
    "topics": [],
    "trees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/trees{/sha}",
    "updated_at": "2023-04-01T17:06:26Z",
    "url": "https://api.github.com/repos/WeiqunZhang/test_ci",
    "visibility": "public",
    "watchers": 0,
    "watchers_count": 0,
    "web_commit_signoff_required": false
  },
  "sender": {
    "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
    "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
    "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
    "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
    "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
    "gravatar_id": "",
    "html_url": "https://github.com/WeiqunZhang",
    "id": 7862753,
    "login": "WeiqunZhang",
    "node_id": "MDQ6VXNlcjc4NjI3NTM=",
    "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
    "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
    "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
    "site_admin": false,
    "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
    "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
    "type": "User",
    "url": "https://api.github.com/users/WeiqunZhang"
  },
  "workflow": {
    "badge_url": "https://github.com/WeiqunZhang/test_ci/workflows/Gcc/badge.svg",
    "created_at": "2023-03-29T23:33:38.000Z",
    "html_url": "https://github.com/WeiqunZhang/test_ci/blob/main/.github/workflows/gcc.yml",
    "id": 52767442,
    "name": "Gcc",
    "node_id": "W_kwDOJQS5984DJSrS",
    "path": ".github/workflows/gcc.yml",
    "state": "active",
    "updated_at": "2023-03-29T23:33:38.000Z",
    "url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/workflows/52767442"
  },
  "workflow_run": {
    "actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "artifacts_url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/runs/4584289327/artifacts",
    "cancel_url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/runs/4584289327/cancel",
    "check_suite_id": 11964509924,
    "check_suite_node_id": "CS_kwDOJQS5988AAAACySPu5A",
    "check_suite_url": "https://api.github.com/repos/WeiqunZhang/test_ci/check-suites/11964509924",
    "conclusion": "success",
    "created_at": "2023-04-01T17:08:03Z",
    "display_title": "minor change on feature branch of fork",
    "event": "push",
    "head_branch": "feature",
    "head_commit": {
      "author": {
        "email": "weiqunzhang@lbl.gov",
        "name": "Weiqun Zhang"
      },
      "committer": {
        "email": "weiqunzhang@lbl.gov",
        "name": "Weiqun Zhang"
      },
      "id": "582054dbf016d0db6a96756d9d855b2c4a65c58e",
      "message": "minor change on feature branch of fork",
      "timestamp": "2023-04-01T17:07:48Z",
      "tree_id": "f2073305e78daf775e7bf68d5a8ca682b12b6f79"
    },
    "head_repository": {
      "archive_url": "https://api.github.com/repos/WeiqunZhang/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/WeiqunZhang/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/WeiqunZhang/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/WeiqunZhang/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/WeiqunZhang/test_ci/downloads",
      "events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/events",
      "fork": true,
      "forks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/forks",
      "full_name": "WeiqunZhang/test_ci",
      "git_commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/hooks",
      "html_url": "https://github.com/WeiqunZhang/test_ci",
      "id": 621066743,
      "issue_comment_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/WeiqunZhang/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/WeiqunZhang/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/WeiqunZhang/test_ci/languages",
      "merges_url": "https://api.github.com/repos/WeiqunZhang/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/WeiqunZhang/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQS59w",
      "notifications_url": "https://api.github.com/repos/WeiqunZhang/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
        "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
        "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
        "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
        "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/WeiqunZhang",
        "id": 7862753,
        "login": "WeiqunZhang",
        "node_id": "MDQ6VXNlcjc4NjI3NTM=",
        "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
        "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
        "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
        "type": "User",
        "url": "https://api.github.com/users/WeiqunZhang"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/WeiqunZhang/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/WeiqunZhang/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/WeiqunZhang/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/tags",
      "teams_url": "https://api.github.com/repos/WeiqunZhang/test_ci/teams",
      "trees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/WeiqunZhang/test_ci"
    },
    "head_sha": "582054dbf016d0db6a96756d9d855b2c4a65c58e",
    "html_url": "https://github.com/WeiqunZhang/test_ci/actions/runs/4584289327",
    "id": 4584289327,
    "jobs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/runs/4584289327/jobs",
    "logs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/runs/4584289327/logs",
    "name": "Gcc",
    "node_id": "WFR_kwLOJQS5988AAAABET60Lw",
    "path": ".github/workflows/gcc.yml",
    "previous_attempt_url": null,
    "pull_requests": [],
    "referenced_workflows": [],
    "repository": {
      "archive_url": "https://api.github.com/repos/WeiqunZhang/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/WeiqunZhang/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/WeiqunZhang/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/WeiqunZhang/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/WeiqunZhang/test_ci/downloads",
      "events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/events",
      "fork": true,
      "forks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/forks",
      "full_name": "WeiqunZhang/test_ci",
      "git_commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/hooks",
      "html_url": "https://github.com/WeiqunZhang/test_ci",
      "id": 621066743,
      "issue_comment_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/WeiqunZhang/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/WeiqunZhang/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/WeiqunZhang/test_ci/languages",
      "merges_url": "https://api.github.com/repos/WeiqunZhang/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/WeiqunZhang/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQS59w",
      "notifications_url": "https://api.github.com/repos/WeiqunZhang/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
        "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
        "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
        "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
        "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/WeiqunZhang",
        "id": 7862753,
        "login": "WeiqunZhang",
        "node_id": "MDQ6VXNlcjc4NjI3NTM=",
        "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
        "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
        "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
        "type": "User",
        "url": "https://api.github.com/users/WeiqunZhang"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/WeiqunZhang/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/WeiqunZhang/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/WeiqunZhang/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/tags",
      "teams_url": "https://api.github.com/repos/WeiqunZhang/test_ci/teams",
      "trees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/WeiqunZhang/test_ci"
    },
    "rerun_url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/runs/4584289327/rerun",
    "run_attempt": 1,
    "run_number": 24,
    "run_started_at": "2023-04-01T17:08:03Z",
    "status": "completed",
    "triggering_actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "updated_at": "2023-04-01T17:08:44Z",
    "url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/runs/4584289327",
    "workflow_id": 52767442,
    "workflow_url": "https://api.github.com/repos/WeiqunZhang/test_ci/actions/workflows/52767442"
  }
}
```
</details>

### Pull request from a feature branch on a fork

The CleanupCache workflow will run on the default branch of the main repo.

<details>
  <summary>Information of CleanupCache workflow</summary>

```
github.ref = refs/heads/main
github.head_ref = refs/heads/main
github.event =
{
  "action": "completed",
  "organization": {
    "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
    "description": "AMReX-Codes: Block-Structured AMR Software Framework and Applications",
    "events_url": "https://api.github.com/orgs/AMReX-Codes/events",
    "hooks_url": "https://api.github.com/orgs/AMReX-Codes/hooks",
    "id": 25084337,
    "issues_url": "https://api.github.com/orgs/AMReX-Codes/issues",
    "login": "AMReX-Codes",
    "members_url": "https://api.github.com/orgs/AMReX-Codes/members{/member}",
    "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
    "public_members_url": "https://api.github.com/orgs/AMReX-Codes/public_members{/member}",
    "repos_url": "https://api.github.com/orgs/AMReX-Codes/repos",
    "url": "https://api.github.com/orgs/AMReX-Codes"
  },
  "repository": {
    "allow_forking": true,
    "archive_url": "https://api.github.com/repos/AMReX-Codes/test_ci/{archive_format}{/ref}",
    "archived": false,
    "assignees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/assignees{/user}",
    "blobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/blobs{/sha}",
    "branches_url": "https://api.github.com/repos/AMReX-Codes/test_ci/branches{/branch}",
    "clone_url": "https://github.com/AMReX-Codes/test_ci.git",
    "collaborators_url": "https://api.github.com/repos/AMReX-Codes/test_ci/collaborators{/collaborator}",
    "comments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/comments{/number}",
    "commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/commits{/sha}",
    "compare_url": "https://api.github.com/repos/AMReX-Codes/test_ci/compare/{base}...{head}",
    "contents_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contents/{+path}",
    "contributors_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contributors",
    "created_at": "2023-03-29T23:11:15Z",
    "default_branch": "main",
    "deployments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/deployments",
    "description": null,
    "disabled": false,
    "downloads_url": "https://api.github.com/repos/AMReX-Codes/test_ci/downloads",
    "events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/events",
    "fork": false,
    "forks": 1,
    "forks_count": 1,
    "forks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/forks",
    "full_name": "AMReX-Codes/test_ci",
    "git_commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/commits{/sha}",
    "git_refs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/refs{/sha}",
    "git_tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/tags{/sha}",
    "git_url": "git://github.com/AMReX-Codes/test_ci.git",
    "has_discussions": false,
    "has_downloads": true,
    "has_issues": true,
    "has_pages": false,
    "has_projects": true,
    "has_wiki": true,
    "homepage": null,
    "hooks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/hooks",
    "html_url": "https://github.com/AMReX-Codes/test_ci",
    "id": 621061581,
    "is_template": false,
    "issue_comment_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/comments{/number}",
    "issue_events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/events{/number}",
    "issues_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues{/number}",
    "keys_url": "https://api.github.com/repos/AMReX-Codes/test_ci/keys{/key_id}",
    "labels_url": "https://api.github.com/repos/AMReX-Codes/test_ci/labels{/name}",
    "language": "C++",
    "languages_url": "https://api.github.com/repos/AMReX-Codes/test_ci/languages",
    "license": {
      "key": "bsd-3-clause",
      "name": "BSD 3-Clause \"New\" or \"Revised\" License",
      "node_id": "MDc6TGljZW5zZTU=",
      "spdx_id": "BSD-3-Clause",
      "url": "https://api.github.com/licenses/bsd-3-clause"
    },
    "merges_url": "https://api.github.com/repos/AMReX-Codes/test_ci/merges",
    "milestones_url": "https://api.github.com/repos/AMReX-Codes/test_ci/milestones{/number}",
    "mirror_url": null,
    "name": "test_ci",
    "node_id": "R_kgDOJQSlzQ",
    "notifications_url": "https://api.github.com/repos/AMReX-Codes/test_ci/notifications{?since,all,participating}",
    "open_issues": 1,
    "open_issues_count": 1,
    "owner": {
      "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
      "events_url": "https://api.github.com/users/AMReX-Codes/events{/privacy}",
      "followers_url": "https://api.github.com/users/AMReX-Codes/followers",
      "following_url": "https://api.github.com/users/AMReX-Codes/following{/other_user}",
      "gists_url": "https://api.github.com/users/AMReX-Codes/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/AMReX-Codes",
      "id": 25084337,
      "login": "AMReX-Codes",
      "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
      "organizations_url": "https://api.github.com/users/AMReX-Codes/orgs",
      "received_events_url": "https://api.github.com/users/AMReX-Codes/received_events",
      "repos_url": "https://api.github.com/users/AMReX-Codes/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/AMReX-Codes/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/AMReX-Codes/subscriptions",
      "type": "Organization",
      "url": "https://api.github.com/users/AMReX-Codes"
    },
    "private": false,
    "pulls_url": "https://api.github.com/repos/AMReX-Codes/test_ci/pulls{/number}",
    "pushed_at": "2023-04-01T17:17:54Z",
    "releases_url": "https://api.github.com/repos/AMReX-Codes/test_ci/releases{/id}",
    "size": 27,
    "ssh_url": "git@github.com:AMReX-Codes/test_ci.git",
    "stargazers_count": 0,
    "stargazers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/stargazers",
    "statuses_url": "https://api.github.com/repos/AMReX-Codes/test_ci/statuses/{sha}",
    "subscribers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscribers",
    "subscription_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscription",
    "svn_url": "https://github.com/AMReX-Codes/test_ci",
    "tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/tags",
    "teams_url": "https://api.github.com/repos/AMReX-Codes/test_ci/teams",
    "topics": [],
    "trees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/trees{/sha}",
    "updated_at": "2023-03-29T23:32:27Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci",
    "visibility": "public",
    "watchers": 0,
    "watchers_count": 0,
    "web_commit_signoff_required": false
  },
  "sender": {
    "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
    "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
    "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
    "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
    "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
    "gravatar_id": "",
    "html_url": "https://github.com/WeiqunZhang",
    "id": 7862753,
    "login": "WeiqunZhang",
    "node_id": "MDQ6VXNlcjc4NjI3NTM=",
    "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
    "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
    "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
    "site_admin": false,
    "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
    "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
    "type": "User",
    "url": "https://api.github.com/users/WeiqunZhang"
  },
  "workflow": {
    "badge_url": "https://github.com/AMReX-Codes/test_ci/workflows/Gcc/badge.svg",
    "created_at": "2023-03-29T23:32:25.000Z",
    "html_url": "https://github.com/AMReX-Codes/test_ci/blob/main/.github/workflows/gcc.yml",
    "id": 52767392,
    "name": "Gcc",
    "node_id": "W_kwDOJQSlzc4DJSqg",
    "path": ".github/workflows/gcc.yml",
    "state": "active",
    "updated_at": "2023-03-30T17:04:11.000Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/workflows/52767392"
  },
  "workflow_run": {
    "actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "artifacts_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584337976/artifacts",
    "cancel_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584337976/cancel",
    "check_suite_id": 11964598047,
    "check_suite_node_id": "CS_kwDOJQSlzc8AAAACySVHHw",
    "check_suite_url": "https://api.github.com/repos/AMReX-Codes/test_ci/check-suites/11964598047",
    "conclusion": "success",
    "created_at": "2023-04-01T17:17:57Z",
    "display_title": "Feature",
    "event": "pull_request",
    "head_branch": "feature",
    "head_commit": {
      "author": {
        "email": "weiqunzhang@lbl.gov",
        "name": "Weiqun Zhang"
      },
      "committer": {
        "email": "weiqunzhang@lbl.gov",
        "name": "Weiqun Zhang"
      },
      "id": "6dccce9ae4c709b60590e48a62766eb0b5ac9838",
      "message": "add notes",
      "timestamp": "2023-04-01T17:16:59Z",
      "tree_id": "73d7cf644e8a6e1ffdfa1d09da2a34d067c49ad5"
    },
    "head_repository": {
      "archive_url": "https://api.github.com/repos/WeiqunZhang/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/WeiqunZhang/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/WeiqunZhang/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/WeiqunZhang/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/WeiqunZhang/test_ci/downloads",
      "events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/events",
      "fork": true,
      "forks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/forks",
      "full_name": "WeiqunZhang/test_ci",
      "git_commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/hooks",
      "html_url": "https://github.com/WeiqunZhang/test_ci",
      "id": 621066743,
      "issue_comment_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/WeiqunZhang/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/WeiqunZhang/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/WeiqunZhang/test_ci/languages",
      "merges_url": "https://api.github.com/repos/WeiqunZhang/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/WeiqunZhang/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQS59w",
      "notifications_url": "https://api.github.com/repos/WeiqunZhang/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
        "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
        "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
        "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
        "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/WeiqunZhang",
        "id": 7862753,
        "login": "WeiqunZhang",
        "node_id": "MDQ6VXNlcjc4NjI3NTM=",
        "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
        "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
        "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
        "type": "User",
        "url": "https://api.github.com/users/WeiqunZhang"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/WeiqunZhang/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/WeiqunZhang/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/WeiqunZhang/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/tags",
      "teams_url": "https://api.github.com/repos/WeiqunZhang/test_ci/teams",
      "trees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/WeiqunZhang/test_ci"
    },
    "head_sha": "6dccce9ae4c709b60590e48a62766eb0b5ac9838",
    "html_url": "https://github.com/AMReX-Codes/test_ci/actions/runs/4584337976",
    "id": 4584337976,
    "jobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584337976/jobs",
    "logs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584337976/logs",
    "name": "Gcc",
    "node_id": "WFR_kwLOJQSlzc8AAAABET9yOA",
    "path": ".github/workflows/gcc.yml",
    "previous_attempt_url": null,
    "pull_requests": [],
    "referenced_workflows": [],
    "repository": {
      "archive_url": "https://api.github.com/repos/AMReX-Codes/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/AMReX-Codes/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/AMReX-Codes/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/AMReX-Codes/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/AMReX-Codes/test_ci/downloads",
      "events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/events",
      "fork": false,
      "forks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/forks",
      "full_name": "AMReX-Codes/test_ci",
      "git_commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/hooks",
      "html_url": "https://github.com/AMReX-Codes/test_ci",
      "id": 621061581,
      "issue_comment_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/AMReX-Codes/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/AMReX-Codes/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/AMReX-Codes/test_ci/languages",
      "merges_url": "https://api.github.com/repos/AMReX-Codes/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/AMReX-Codes/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQSlzQ",
      "notifications_url": "https://api.github.com/repos/AMReX-Codes/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
        "events_url": "https://api.github.com/users/AMReX-Codes/events{/privacy}",
        "followers_url": "https://api.github.com/users/AMReX-Codes/followers",
        "following_url": "https://api.github.com/users/AMReX-Codes/following{/other_user}",
        "gists_url": "https://api.github.com/users/AMReX-Codes/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/AMReX-Codes",
        "id": 25084337,
        "login": "AMReX-Codes",
        "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
        "organizations_url": "https://api.github.com/users/AMReX-Codes/orgs",
        "received_events_url": "https://api.github.com/users/AMReX-Codes/received_events",
        "repos_url": "https://api.github.com/users/AMReX-Codes/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/AMReX-Codes/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/AMReX-Codes/subscriptions",
        "type": "Organization",
        "url": "https://api.github.com/users/AMReX-Codes"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/AMReX-Codes/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/AMReX-Codes/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/AMReX-Codes/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/tags",
      "teams_url": "https://api.github.com/repos/AMReX-Codes/test_ci/teams",
      "trees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/AMReX-Codes/test_ci"
    },
    "rerun_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584337976/rerun",
    "run_attempt": 1,
    "run_number": 53,
    "run_started_at": "2023-04-01T17:17:57Z",
    "status": "completed",
    "triggering_actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "updated_at": "2023-04-01T17:18:26Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584337976",
    "workflow_id": 52767392,
    "workflow_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/workflows/52767392"
  }
}
```
</details>

### Closing a pull request from a feature branch on a fork

This will trigger the CleanupCachePostPR workflow to run on the default
branch of the main repo. It will remove all the caches associated with the
PR.

<details>
  <summary>Information of CleanupCachePostPR workflow</summary>

```
github.ref = refs/heads/main
github.head_ref = refs/heads/main
github.event =
{
  "action": "completed",
  "organization": {
    "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
    "description": "AMReX-Codes: Block-Structured AMR Software Framework and Applications",
    "events_url": "https://api.github.com/orgs/AMReX-Codes/events",
    "hooks_url": "https://api.github.com/orgs/AMReX-Codes/hooks",
    "id": 25084337,
    "issues_url": "https://api.github.com/orgs/AMReX-Codes/issues",
    "login": "AMReX-Codes",
    "members_url": "https://api.github.com/orgs/AMReX-Codes/members{/member}",
    "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
    "public_members_url": "https://api.github.com/orgs/AMReX-Codes/public_members{/member}",
    "repos_url": "https://api.github.com/orgs/AMReX-Codes/repos",
    "url": "https://api.github.com/orgs/AMReX-Codes"
  },
  "repository": {
    "allow_forking": true,
    "archive_url": "https://api.github.com/repos/AMReX-Codes/test_ci/{archive_format}{/ref}",
    "archived": false,
    "assignees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/assignees{/user}",
    "blobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/blobs{/sha}",
    "branches_url": "https://api.github.com/repos/AMReX-Codes/test_ci/branches{/branch}",
    "clone_url": "https://github.com/AMReX-Codes/test_ci.git",
    "collaborators_url": "https://api.github.com/repos/AMReX-Codes/test_ci/collaborators{/collaborator}",
    "comments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/comments{/number}",
    "commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/commits{/sha}",
    "compare_url": "https://api.github.com/repos/AMReX-Codes/test_ci/compare/{base}...{head}",
    "contents_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contents/{+path}",
    "contributors_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contributors",
    "created_at": "2023-03-29T23:11:15Z",
    "default_branch": "main",
    "deployments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/deployments",
    "description": null,
    "disabled": false,
    "downloads_url": "https://api.github.com/repos/AMReX-Codes/test_ci/downloads",
    "events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/events",
    "fork": false,
    "forks": 1,
    "forks_count": 1,
    "forks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/forks",
    "full_name": "AMReX-Codes/test_ci",
    "git_commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/commits{/sha}",
    "git_refs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/refs{/sha}",
    "git_tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/tags{/sha}",
    "git_url": "git://github.com/AMReX-Codes/test_ci.git",
    "has_discussions": false,
    "has_downloads": true,
    "has_issues": true,
    "has_pages": false,
    "has_projects": true,
    "has_wiki": true,
    "homepage": null,
    "hooks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/hooks",
    "html_url": "https://github.com/AMReX-Codes/test_ci",
    "id": 621061581,
    "is_template": false,
    "issue_comment_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/comments{/number}",
    "issue_events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/events{/number}",
    "issues_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues{/number}",
    "keys_url": "https://api.github.com/repos/AMReX-Codes/test_ci/keys{/key_id}",
    "labels_url": "https://api.github.com/repos/AMReX-Codes/test_ci/labels{/name}",
    "language": "C++",
    "languages_url": "https://api.github.com/repos/AMReX-Codes/test_ci/languages",
    "license": {
      "key": "bsd-3-clause",
      "name": "BSD 3-Clause \"New\" or \"Revised\" License",
      "node_id": "MDc6TGljZW5zZTU=",
      "spdx_id": "BSD-3-Clause",
      "url": "https://api.github.com/licenses/bsd-3-clause"
    },
    "merges_url": "https://api.github.com/repos/AMReX-Codes/test_ci/merges",
    "milestones_url": "https://api.github.com/repos/AMReX-Codes/test_ci/milestones{/number}",
    "mirror_url": null,
    "name": "test_ci",
    "node_id": "R_kgDOJQSlzQ",
    "notifications_url": "https://api.github.com/repos/AMReX-Codes/test_ci/notifications{?since,all,participating}",
    "open_issues": 0,
    "open_issues_count": 0,
    "owner": {
      "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
      "events_url": "https://api.github.com/users/AMReX-Codes/events{/privacy}",
      "followers_url": "https://api.github.com/users/AMReX-Codes/followers",
      "following_url": "https://api.github.com/users/AMReX-Codes/following{/other_user}",
      "gists_url": "https://api.github.com/users/AMReX-Codes/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/AMReX-Codes",
      "id": 25084337,
      "login": "AMReX-Codes",
      "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
      "organizations_url": "https://api.github.com/users/AMReX-Codes/orgs",
      "received_events_url": "https://api.github.com/users/AMReX-Codes/received_events",
      "repos_url": "https://api.github.com/users/AMReX-Codes/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/AMReX-Codes/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/AMReX-Codes/subscriptions",
      "type": "Organization",
      "url": "https://api.github.com/users/AMReX-Codes"
    },
    "private": false,
    "pulls_url": "https://api.github.com/repos/AMReX-Codes/test_ci/pulls{/number}",
    "pushed_at": "2023-04-01T17:44:50Z",
    "releases_url": "https://api.github.com/repos/AMReX-Codes/test_ci/releases{/id}",
    "size": 27,
    "ssh_url": "git@github.com:AMReX-Codes/test_ci.git",
    "stargazers_count": 0,
    "stargazers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/stargazers",
    "statuses_url": "https://api.github.com/repos/AMReX-Codes/test_ci/statuses/{sha}",
    "subscribers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscribers",
    "subscription_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscription",
    "svn_url": "https://github.com/AMReX-Codes/test_ci",
    "tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/tags",
    "teams_url": "https://api.github.com/repos/AMReX-Codes/test_ci/teams",
    "topics": [],
    "trees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/trees{/sha}",
    "updated_at": "2023-03-29T23:32:27Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci",
    "visibility": "public",
    "watchers": 0,
    "watchers_count": 0,
    "web_commit_signoff_required": false
  },
  "sender": {
    "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
    "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
    "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
    "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
    "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
    "gravatar_id": "",
    "html_url": "https://github.com/WeiqunZhang",
    "id": 7862753,
    "login": "WeiqunZhang",
    "node_id": "MDQ6VXNlcjc4NjI3NTM=",
    "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
    "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
    "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
    "site_admin": false,
    "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
    "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
    "type": "User",
    "url": "https://api.github.com/users/WeiqunZhang"
  },
  "workflow": {
    "badge_url": "https://github.com/AMReX-Codes/test_ci/workflows/PostPR/badge.svg",
    "created_at": "2023-03-30T18:51:44.000Z",
    "html_url": "https://github.com/AMReX-Codes/test_ci/blob/main/.github/workflows/post-pr.yml",
    "id": 52867039,
    "name": "PostPR",
    "node_id": "W_kwDOJQSlzc4DJq_f",
    "path": ".github/workflows/post-pr.yml",
    "state": "active",
    "updated_at": "2023-03-30T19:16:16.000Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/workflows/52867039"
  },
  "workflow_run": {
    "actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "artifacts_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584442986/artifacts",
    "cancel_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584442986/cancel",
    "check_suite_id": 11964804514,
    "check_suite_node_id": "CS_kwDOJQSlzc8AAAACyShtog",
    "check_suite_url": "https://api.github.com/repos/AMReX-Codes/test_ci/check-suites/11964804514",
    "conclusion": "success",
    "created_at": "2023-04-01T17:46:18Z",
    "display_title": "another minor change on the feature branch",
    "event": "pull_request",
    "head_branch": "feature",
    "head_commit": {
      "author": {
        "email": "weiqunzhang@lbl.gov",
        "name": "Weiqun Zhang"
      },
      "committer": {
        "email": "weiqunzhang@lbl.gov",
        "name": "Weiqun Zhang"
      },
      "id": "937a47a762975538160014a7981687ce7f95910c",
      "message": "another minor change on the feature branch",
      "timestamp": "2023-04-01T17:34:14Z",
      "tree_id": "981672f4d4f4e2dbf23d2686f49cb727114fdb23"
    },
    "head_repository": {
      "archive_url": "https://api.github.com/repos/WeiqunZhang/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/WeiqunZhang/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/WeiqunZhang/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/WeiqunZhang/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/WeiqunZhang/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/WeiqunZhang/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/WeiqunZhang/test_ci/downloads",
      "events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/events",
      "fork": true,
      "forks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/forks",
      "full_name": "WeiqunZhang/test_ci",
      "git_commits_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/WeiqunZhang/test_ci/hooks",
      "html_url": "https://github.com/WeiqunZhang/test_ci",
      "id": 621066743,
      "issue_comment_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/WeiqunZhang/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/WeiqunZhang/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/WeiqunZhang/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/WeiqunZhang/test_ci/languages",
      "merges_url": "https://api.github.com/repos/WeiqunZhang/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/WeiqunZhang/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQS59w",
      "notifications_url": "https://api.github.com/repos/WeiqunZhang/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
        "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
        "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
        "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
        "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/WeiqunZhang",
        "id": 7862753,
        "login": "WeiqunZhang",
        "node_id": "MDQ6VXNlcjc4NjI3NTM=",
        "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
        "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
        "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
        "type": "User",
        "url": "https://api.github.com/users/WeiqunZhang"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/WeiqunZhang/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/WeiqunZhang/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/WeiqunZhang/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/WeiqunZhang/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/WeiqunZhang/test_ci/tags",
      "teams_url": "https://api.github.com/repos/WeiqunZhang/test_ci/teams",
      "trees_url": "https://api.github.com/repos/WeiqunZhang/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/WeiqunZhang/test_ci"
    },
    "head_sha": "937a47a762975538160014a7981687ce7f95910c",
    "html_url": "https://github.com/AMReX-Codes/test_ci/actions/runs/4584442986",
    "id": 4584442986,
    "jobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584442986/jobs",
    "logs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584442986/logs",
    "name": "PostPR",
    "node_id": "WFR_kwLOJQSlzc8AAAABEUEMag",
    "path": ".github/workflows/post-pr.yml",
    "previous_attempt_url": null,
    "pull_requests": [],
    "referenced_workflows": [],
    "repository": {
      "archive_url": "https://api.github.com/repos/AMReX-Codes/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/AMReX-Codes/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/AMReX-Codes/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/AMReX-Codes/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/AMReX-Codes/test_ci/downloads",
      "events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/events",
      "fork": false,
      "forks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/forks",
      "full_name": "AMReX-Codes/test_ci",
      "git_commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/hooks",
      "html_url": "https://github.com/AMReX-Codes/test_ci",
      "id": 621061581,
      "issue_comment_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/AMReX-Codes/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/AMReX-Codes/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/AMReX-Codes/test_ci/languages",
      "merges_url": "https://api.github.com/repos/AMReX-Codes/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/AMReX-Codes/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQSlzQ",
      "notifications_url": "https://api.github.com/repos/AMReX-Codes/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
        "events_url": "https://api.github.com/users/AMReX-Codes/events{/privacy}",
        "followers_url": "https://api.github.com/users/AMReX-Codes/followers",
        "following_url": "https://api.github.com/users/AMReX-Codes/following{/other_user}",
        "gists_url": "https://api.github.com/users/AMReX-Codes/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/AMReX-Codes",
        "id": 25084337,
        "login": "AMReX-Codes",
        "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
        "organizations_url": "https://api.github.com/users/AMReX-Codes/orgs",
        "received_events_url": "https://api.github.com/users/AMReX-Codes/received_events",
        "repos_url": "https://api.github.com/users/AMReX-Codes/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/AMReX-Codes/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/AMReX-Codes/subscriptions",
        "type": "Organization",
        "url": "https://api.github.com/users/AMReX-Codes"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/AMReX-Codes/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/AMReX-Codes/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/AMReX-Codes/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/tags",
      "teams_url": "https://api.github.com/repos/AMReX-Codes/test_ci/teams",
      "trees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/AMReX-Codes/test_ci"
    },
    "rerun_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584442986/rerun",
    "run_attempt": 1,
    "run_number": 5,
    "run_started_at": "2023-04-01T17:46:18Z",
    "status": "completed",
    "triggering_actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "updated_at": "2023-04-01T17:46:30Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584442986",
    "workflow_id": 52867039,
    "workflow_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/workflows/52867039"
  }
}
```
</details>

### Merging a pull request from a feature branch on a fork

The merge closes the PR and therefore triggers the CleanupCachePostPR
workflow. The merge will also update the default branch on the main
repo. This is considered a push event even though it's not pushed by a
normal user. So this will trigger all the push triggerable workflows (e.g.,
cuda.yml), which will in turn trigger the CleanupCache workflow.

<details>
  <summary>Information of CleanupCache workflow</summary>

```
github.ref = refs/heads/main
github.head_ref = refs/heads/main
github.event =
{
  "action": "completed",
  "organization": {
    "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
    "description": "AMReX-Codes: Block-Structured AMR Software Framework and Applications",
    "events_url": "https://api.github.com/orgs/AMReX-Codes/events",
    "hooks_url": "https://api.github.com/orgs/AMReX-Codes/hooks",
    "id": 25084337,
    "issues_url": "https://api.github.com/orgs/AMReX-Codes/issues",
    "login": "AMReX-Codes",
    "members_url": "https://api.github.com/orgs/AMReX-Codes/members{/member}",
    "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
    "public_members_url": "https://api.github.com/orgs/AMReX-Codes/public_members{/member}",
    "repos_url": "https://api.github.com/orgs/AMReX-Codes/repos",
    "url": "https://api.github.com/orgs/AMReX-Codes"
  },
  "repository": {
    "allow_forking": true,
    "archive_url": "https://api.github.com/repos/AMReX-Codes/test_ci/{archive_format}{/ref}",
    "archived": false,
    "assignees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/assignees{/user}",
    "blobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/blobs{/sha}",
    "branches_url": "https://api.github.com/repos/AMReX-Codes/test_ci/branches{/branch}",
    "clone_url": "https://github.com/AMReX-Codes/test_ci.git",
    "collaborators_url": "https://api.github.com/repos/AMReX-Codes/test_ci/collaborators{/collaborator}",
    "comments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/comments{/number}",
    "commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/commits{/sha}",
    "compare_url": "https://api.github.com/repos/AMReX-Codes/test_ci/compare/{base}...{head}",
    "contents_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contents/{+path}",
    "contributors_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contributors",
    "created_at": "2023-03-29T23:11:15Z",
    "default_branch": "main",
    "deployments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/deployments",
    "description": null,
    "disabled": false,
    "downloads_url": "https://api.github.com/repos/AMReX-Codes/test_ci/downloads",
    "events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/events",
    "fork": false,
    "forks": 1,
    "forks_count": 1,
    "forks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/forks",
    "full_name": "AMReX-Codes/test_ci",
    "git_commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/commits{/sha}",
    "git_refs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/refs{/sha}",
    "git_tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/tags{/sha}",
    "git_url": "git://github.com/AMReX-Codes/test_ci.git",
    "has_discussions": false,
    "has_downloads": true,
    "has_issues": true,
    "has_pages": false,
    "has_projects": true,
    "has_wiki": true,
    "homepage": null,
    "hooks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/hooks",
    "html_url": "https://github.com/AMReX-Codes/test_ci",
    "id": 621061581,
    "is_template": false,
    "issue_comment_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/comments{/number}",
    "issue_events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/events{/number}",
    "issues_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues{/number}",
    "keys_url": "https://api.github.com/repos/AMReX-Codes/test_ci/keys{/key_id}",
    "labels_url": "https://api.github.com/repos/AMReX-Codes/test_ci/labels{/name}",
    "language": "C++",
    "languages_url": "https://api.github.com/repos/AMReX-Codes/test_ci/languages",
    "license": {
      "key": "bsd-3-clause",
      "name": "BSD 3-Clause \"New\" or \"Revised\" License",
      "node_id": "MDc6TGljZW5zZTU=",
      "spdx_id": "BSD-3-Clause",
      "url": "https://api.github.com/licenses/bsd-3-clause"
    },
    "merges_url": "https://api.github.com/repos/AMReX-Codes/test_ci/merges",
    "milestones_url": "https://api.github.com/repos/AMReX-Codes/test_ci/milestones{/number}",
    "mirror_url": null,
    "name": "test_ci",
    "node_id": "R_kgDOJQSlzQ",
    "notifications_url": "https://api.github.com/repos/AMReX-Codes/test_ci/notifications{?since,all,participating}",
    "open_issues": 0,
    "open_issues_count": 0,
    "owner": {
      "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
      "events_url": "https://api.github.com/users/AMReX-Codes/events{/privacy}",
      "followers_url": "https://api.github.com/users/AMReX-Codes/followers",
      "following_url": "https://api.github.com/users/AMReX-Codes/following{/other_user}",
      "gists_url": "https://api.github.com/users/AMReX-Codes/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/AMReX-Codes",
      "id": 25084337,
      "login": "AMReX-Codes",
      "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
      "organizations_url": "https://api.github.com/users/AMReX-Codes/orgs",
      "received_events_url": "https://api.github.com/users/AMReX-Codes/received_events",
      "repos_url": "https://api.github.com/users/AMReX-Codes/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/AMReX-Codes/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/AMReX-Codes/subscriptions",
      "type": "Organization",
      "url": "https://api.github.com/users/AMReX-Codes"
    },
    "private": false,
    "pulls_url": "https://api.github.com/repos/AMReX-Codes/test_ci/pulls{/number}",
    "pushed_at": "2023-04-01T17:54:37Z",
    "releases_url": "https://api.github.com/repos/AMReX-Codes/test_ci/releases{/id}",
    "size": 27,
    "ssh_url": "git@github.com:AMReX-Codes/test_ci.git",
    "stargazers_count": 0,
    "stargazers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/stargazers",
    "statuses_url": "https://api.github.com/repos/AMReX-Codes/test_ci/statuses/{sha}",
    "subscribers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscribers",
    "subscription_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscription",
    "svn_url": "https://github.com/AMReX-Codes/test_ci",
    "tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/tags",
    "teams_url": "https://api.github.com/repos/AMReX-Codes/test_ci/teams",
    "topics": [],
    "trees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/trees{/sha}",
    "updated_at": "2023-03-29T23:32:27Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci",
    "visibility": "public",
    "watchers": 0,
    "watchers_count": 0,
    "web_commit_signoff_required": false
  },
  "sender": {
    "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
    "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
    "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
    "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
    "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
    "gravatar_id": "",
    "html_url": "https://github.com/WeiqunZhang",
    "id": 7862753,
    "login": "WeiqunZhang",
    "node_id": "MDQ6VXNlcjc4NjI3NTM=",
    "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
    "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
    "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
    "site_admin": false,
    "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
    "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
    "type": "User",
    "url": "https://api.github.com/users/WeiqunZhang"
  },
  "workflow": {
    "badge_url": "https://github.com/AMReX-Codes/test_ci/workflows/Clang/badge.svg",
    "created_at": "2023-03-29T23:32:25.000Z",
    "html_url": "https://github.com/AMReX-Codes/test_ci/blob/main/.github/workflows/clang.yml",
    "id": 52767391,
    "name": "Clang",
    "node_id": "W_kwDOJQSlzc4DJSqf",
    "path": ".github/workflows/clang.yml",
    "state": "active",
    "updated_at": "2023-03-30T17:04:11.000Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/workflows/52767391"
  },
  "workflow_run": {
    "actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "artifacts_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584469723/artifacts",
    "cancel_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584469723/cancel",
    "check_suite_id": 11964859542,
    "check_suite_node_id": "CS_kwDOJQSlzc8AAAACySlElg",
    "check_suite_url": "https://api.github.com/repos/AMReX-Codes/test_ci/check-suites/11964859542",
    "conclusion": "success",
    "created_at": "2023-04-01T17:54:40Z",
    "display_title": "Merge pull request #9 from WeiqunZhang/feature",
    "event": "push",
    "head_branch": "main",
    "head_commit": {
      "author": {
        "email": "WeiqunZhang@lbl.gov",
        "name": "Weiqun Zhang"
      },
      "committer": {
        "email": "noreply@github.com",
        "name": "GitHub"
      },
      "id": "019bb8571e19f01c2afa4a06885c60fa75983d10",
      "message": "Merge pull request #9 from WeiqunZhang/feature\n\nanother minor change on the feature branch",
      "timestamp": "2023-04-01T17:54:37Z",
      "tree_id": "981672f4d4f4e2dbf23d2686f49cb727114fdb23"
    },
    "head_repository": {
      "archive_url": "https://api.github.com/repos/AMReX-Codes/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/AMReX-Codes/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/AMReX-Codes/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/AMReX-Codes/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/AMReX-Codes/test_ci/downloads",
      "events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/events",
      "fork": false,
      "forks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/forks",
      "full_name": "AMReX-Codes/test_ci",
      "git_commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/hooks",
      "html_url": "https://github.com/AMReX-Codes/test_ci",
      "id": 621061581,
      "issue_comment_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/AMReX-Codes/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/AMReX-Codes/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/AMReX-Codes/test_ci/languages",
      "merges_url": "https://api.github.com/repos/AMReX-Codes/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/AMReX-Codes/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQSlzQ",
      "notifications_url": "https://api.github.com/repos/AMReX-Codes/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
        "events_url": "https://api.github.com/users/AMReX-Codes/events{/privacy}",
        "followers_url": "https://api.github.com/users/AMReX-Codes/followers",
        "following_url": "https://api.github.com/users/AMReX-Codes/following{/other_user}",
        "gists_url": "https://api.github.com/users/AMReX-Codes/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/AMReX-Codes",
        "id": 25084337,
        "login": "AMReX-Codes",
        "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
        "organizations_url": "https://api.github.com/users/AMReX-Codes/orgs",
        "received_events_url": "https://api.github.com/users/AMReX-Codes/received_events",
        "repos_url": "https://api.github.com/users/AMReX-Codes/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/AMReX-Codes/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/AMReX-Codes/subscriptions",
        "type": "Organization",
        "url": "https://api.github.com/users/AMReX-Codes"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/AMReX-Codes/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/AMReX-Codes/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/AMReX-Codes/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/tags",
      "teams_url": "https://api.github.com/repos/AMReX-Codes/test_ci/teams",
      "trees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/AMReX-Codes/test_ci"
    },
    "head_sha": "019bb8571e19f01c2afa4a06885c60fa75983d10",
    "html_url": "https://github.com/AMReX-Codes/test_ci/actions/runs/4584469723",
    "id": 4584469723,
    "jobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584469723/jobs",
    "logs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584469723/logs",
    "name": "Clang",
    "node_id": "WFR_kwLOJQSlzc8AAAABEUF02w",
    "path": ".github/workflows/clang.yml",
    "previous_attempt_url": null,
    "pull_requests": [],
    "referenced_workflows": [],
    "repository": {
      "archive_url": "https://api.github.com/repos/AMReX-Codes/test_ci/{archive_format}{/ref}",
      "assignees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/assignees{/user}",
      "blobs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/blobs{/sha}",
      "branches_url": "https://api.github.com/repos/AMReX-Codes/test_ci/branches{/branch}",
      "collaborators_url": "https://api.github.com/repos/AMReX-Codes/test_ci/collaborators{/collaborator}",
      "comments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/comments{/number}",
      "commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/commits{/sha}",
      "compare_url": "https://api.github.com/repos/AMReX-Codes/test_ci/compare/{base}...{head}",
      "contents_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contents/{+path}",
      "contributors_url": "https://api.github.com/repos/AMReX-Codes/test_ci/contributors",
      "deployments_url": "https://api.github.com/repos/AMReX-Codes/test_ci/deployments",
      "description": null,
      "downloads_url": "https://api.github.com/repos/AMReX-Codes/test_ci/downloads",
      "events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/events",
      "fork": false,
      "forks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/forks",
      "full_name": "AMReX-Codes/test_ci",
      "git_commits_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/commits{/sha}",
      "git_refs_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/refs{/sha}",
      "git_tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/tags{/sha}",
      "hooks_url": "https://api.github.com/repos/AMReX-Codes/test_ci/hooks",
      "html_url": "https://github.com/AMReX-Codes/test_ci",
      "id": 621061581,
      "issue_comment_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/comments{/number}",
      "issue_events_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues/events{/number}",
      "issues_url": "https://api.github.com/repos/AMReX-Codes/test_ci/issues{/number}",
      "keys_url": "https://api.github.com/repos/AMReX-Codes/test_ci/keys{/key_id}",
      "labels_url": "https://api.github.com/repos/AMReX-Codes/test_ci/labels{/name}",
      "languages_url": "https://api.github.com/repos/AMReX-Codes/test_ci/languages",
      "merges_url": "https://api.github.com/repos/AMReX-Codes/test_ci/merges",
      "milestones_url": "https://api.github.com/repos/AMReX-Codes/test_ci/milestones{/number}",
      "name": "test_ci",
      "node_id": "R_kgDOJQSlzQ",
      "notifications_url": "https://api.github.com/repos/AMReX-Codes/test_ci/notifications{?since,all,participating}",
      "owner": {
        "avatar_url": "https://avatars.githubusercontent.com/u/25084337?v=4",
        "events_url": "https://api.github.com/users/AMReX-Codes/events{/privacy}",
        "followers_url": "https://api.github.com/users/AMReX-Codes/followers",
        "following_url": "https://api.github.com/users/AMReX-Codes/following{/other_user}",
        "gists_url": "https://api.github.com/users/AMReX-Codes/gists{/gist_id}",
        "gravatar_id": "",
        "html_url": "https://github.com/AMReX-Codes",
        "id": 25084337,
        "login": "AMReX-Codes",
        "node_id": "MDEyOk9yZ2FuaXphdGlvbjI1MDg0MzM3",
        "organizations_url": "https://api.github.com/users/AMReX-Codes/orgs",
        "received_events_url": "https://api.github.com/users/AMReX-Codes/received_events",
        "repos_url": "https://api.github.com/users/AMReX-Codes/repos",
        "site_admin": false,
        "starred_url": "https://api.github.com/users/AMReX-Codes/starred{/owner}{/repo}",
        "subscriptions_url": "https://api.github.com/users/AMReX-Codes/subscriptions",
        "type": "Organization",
        "url": "https://api.github.com/users/AMReX-Codes"
      },
      "private": false,
      "pulls_url": "https://api.github.com/repos/AMReX-Codes/test_ci/pulls{/number}",
      "releases_url": "https://api.github.com/repos/AMReX-Codes/test_ci/releases{/id}",
      "stargazers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/stargazers",
      "statuses_url": "https://api.github.com/repos/AMReX-Codes/test_ci/statuses/{sha}",
      "subscribers_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscribers",
      "subscription_url": "https://api.github.com/repos/AMReX-Codes/test_ci/subscription",
      "tags_url": "https://api.github.com/repos/AMReX-Codes/test_ci/tags",
      "teams_url": "https://api.github.com/repos/AMReX-Codes/test_ci/teams",
      "trees_url": "https://api.github.com/repos/AMReX-Codes/test_ci/git/trees{/sha}",
      "url": "https://api.github.com/repos/AMReX-Codes/test_ci"
    },
    "rerun_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584469723/rerun",
    "run_attempt": 1,
    "run_number": 57,
    "run_started_at": "2023-04-01T17:54:40Z",
    "status": "completed",
    "triggering_actor": {
      "avatar_url": "https://avatars.githubusercontent.com/u/7862753?v=4",
      "events_url": "https://api.github.com/users/WeiqunZhang/events{/privacy}",
      "followers_url": "https://api.github.com/users/WeiqunZhang/followers",
      "following_url": "https://api.github.com/users/WeiqunZhang/following{/other_user}",
      "gists_url": "https://api.github.com/users/WeiqunZhang/gists{/gist_id}",
      "gravatar_id": "",
      "html_url": "https://github.com/WeiqunZhang",
      "id": 7862753,
      "login": "WeiqunZhang",
      "node_id": "MDQ6VXNlcjc4NjI3NTM=",
      "organizations_url": "https://api.github.com/users/WeiqunZhang/orgs",
      "received_events_url": "https://api.github.com/users/WeiqunZhang/received_events",
      "repos_url": "https://api.github.com/users/WeiqunZhang/repos",
      "site_admin": false,
      "starred_url": "https://api.github.com/users/WeiqunZhang/starred{/owner}{/repo}",
      "subscriptions_url": "https://api.github.com/users/WeiqunZhang/subscriptions",
      "type": "User",
      "url": "https://api.github.com/users/WeiqunZhang"
    },
    "updated_at": "2023-04-01T17:55:18Z",
    "url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/runs/4584469723",
    "workflow_id": 52767391,
    "workflow_url": "https://api.github.com/repos/AMReX-Codes/test_ci/actions/workflows/52767391"
  }
}
```
</details>
