# -*- coding: utf-8 -*-
"""
Created on Mon Dec 9 10:30:58 2024

@author: BasnayakeBMV
"""

#Import libraries
import pandas as pd
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D
from pathlib import Path

##-----------------------------------------------------------------------------------------------------------
#Input data

#Folder
script_dir = Path(__file__).resolve().parent


f_con = script_dir/'Indicator_contribution/'


'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Read data
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''  

M1 = pd.read_csv(f_con/'Indicator_contribution.csv')
print(list(M1.columns))

extra_cl = ['Unnamed: 0']

for i in extra_cl:
    M1.drop(i, axis=1, inplace=True)
#--------------------------------------------------------------------------------

# plot a Stacked Bar Chart representing the % of locations with vulnerability levels 
fig = plt.figure(figsize=(30,36))

gs = fig.add_gridspec(2,2, width_ratios=[1, 1], height_ratios=[100, 1])
ax = fig.add_subplot(gs[:, :])
ax1 = fig.add_subplot(gs[1, :])
ax2 = fig.add_subplot(gs[0, 0])
ax3 = fig.add_subplot(gs[0, 1])

a = M1[: 73][:].plot( ax=ax3, x = 'COUNTRY_name',  kind = 'barh',  stacked = True,    
  mark_right = True, width = 0.2,
  color = ['royalblue', 'darkorange', 'darkred', 'gold', 'grey', 'limegreen'],legend=False) 

b = M1[73: 146][:].plot( ax=ax2, x = 'COUNTRY_name',  kind = 'barh',  stacked = True,    
  mark_right = True, width = 0.2,
  color = ['royalblue', 'darkorange', 'darkred', 'gold', 'grey', 'limegreen'],legend=False) 

#ax.set_title('Indicator contribution for CVI per country',fontsize='xx-large')
ax.axis('off')

ax2.set_xlabel('Indicator contribution (%)', fontsize=30) #
ax2.tick_params(axis='y', labelsize=23)
ax2.tick_params(axis='x', labelsize=23)
ax2.set_ylabel('Country',fontsize=30)
ax2.annotate("", (105, 0), (105, 33), arrowprops={'arrowstyle':'|-|', 'linewidth':5, 'color':'yellow', 'shrinkA': 0, 'shrinkB': 0, })
ax2.annotate("", (105, 34), (105, 55), arrowprops={'arrowstyle':'|-|', 'linewidth':5, 'color':'yellowgreen', 'shrinkA': 0, 'shrinkB': 0, })
ax2.annotate("", (105, 56), (105, 72), arrowprops={'arrowstyle':'|-|', 'linewidth':5, 'color':'darkgreen', 'shrinkA': 0, 'shrinkB': 0, })

ax2.annotate("Moderate vulnerability", xy=(105, (34/2)), xytext=(10, -10),fontsize=28, rotation=-90,va="center", ha="left", textcoords='offset points')
ax2.annotate("Low vulnerability", xy=(105, (35+21/2)), xytext=(10, -10),fontsize=28, rotation=-90,va="center", ha="left", textcoords='offset points')
ax2.annotate("Very Low\n vulnerability", xy=(105, (57+16/2)), xytext=(10, -10),fontsize=28, rotation=-90, va="center", ha="left", textcoords='offset points')


ax3.set_xlabel('Indicator contribution (%)', fontsize=30)
ax3.tick_params(axis='y', labelsize=22)
ax3.tick_params(axis='x', labelsize=22)
ax3.set_ylabel('')
ax3.annotate("", (105, 0), (105, 18), arrowprops={'arrowstyle':'|-|', 'linewidth':5, 'color':'darkred', 'shrinkA': 0, 'shrinkB': 0, })
ax3.annotate("", (105, 19), (105, 70), arrowprops={'arrowstyle':'|-|', 'linewidth':5, 'color':'orange', 'shrinkA': 0, 'shrinkB': 0, })
ax3.annotate("", (105, 71), (105, 72), arrowprops={'arrowstyle':'|-|', 'linewidth':5, 'color':'yellow', 'shrinkA': 0, 'shrinkB': 0, })

ax3.annotate("Very High vulnerability", xy=(105, 19/2), xytext=(10, -10),fontsize=28, rotation=-90,va="center", ha="left", textcoords='offset points')
ax3.annotate("High vulnerability", xy=(105, (20+52/2)), xytext=(10, -10),fontsize=28, rotation=-90, va="center", ha="left",textcoords='offset points')

      
legend_elements = [Line2D([0], [0], marker='s', color='w', label='Geomorphology', markerfacecolor='royalblue', markersize=18),
                    Line2D([0], [0], marker='s', color='w', label='Coastal slope', markerfacecolor='darkorange', markersize=18),
                    Line2D([0], [0], marker='s', color='w', label='Wave climate', markerfacecolor='darkred', markersize=18),
                    Line2D([0], [0], marker='s', color='w', label='Mean tidal range', markerfacecolor='gold', markersize=18),
                    Line2D([0], [0], marker='s', color='w', label='Relative sea level change', markerfacecolor='grey', markersize=18),
                    Line2D([0], [0], marker='s', color='w', label='Shoreline change', markerfacecolor='limegreen', markersize=18)]

#Add boxes to represent countrywise median CVI class
ax1.legend(handles=legend_elements, ncol = 6, loc='center', frameon=False, title= 'Indicator', title_fontsize = 28, fontsize=28)
ax1.axis('off')

fig.tight_layout(h_pad=-0.5)
plt.tight_layout()
plt.savefig('Indicator_contributions_countrywise.pdf', transparent=None, format='pdf',
                metadata=None, bbox_inches='tight', facecolor='auto', edgecolor='white', backend=None)

plt.savefig('Indicator_contributions_countrywise.png', transparent=None, format='png', dpi=300,
                metadata=None, bbox_inches='tight', pad_inches=0.5, facecolor='auto', edgecolor='white', backend=None)


