# -*- coding: utf-8 -*-
"""
Created on Fri Nov 15 17:28:33 2024

@author: BasnayakeBMV
"""

import matplotlib.pyplot as plt
import pandas as pd
from matplotlib.lines import Line2D
from pathlib import Path

'''
USER-DEFINED INPUTS
'''

#Folder
script_dir = Path(__file__).resolve().parent

#-----------------------------------------------------------------------------------------------------------------
'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Read data
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''  

# -------------------------------------------------
df = pd.read_csv(script_dir/"Typology_based_CVI/Typology_based_CVI.csv")
ranges = pd.read_csv(script_dir/"CVI_Percentile_ranges/CVI_percentiles.csv")

#Extract ordered bounds
bounds = [
    ranges.loc[ranges["Percentile"] == "min", "M1"].values[0],
    ranges.loc[ranges["Percentile"] == "p_20", "M1"].values[0],
    ranges.loc[ranges["Percentile"] == "p_40", "M1"].values[0],
    ranges.loc[ranges["Percentile"] == "p_60", "M1"].values[0],
    ranges.loc[ranges["Percentile"] == "p_80", "M1"].values[0],
    ranges.loc[ranges["Percentile"] == "max", "M1"].values[0]
]

#Define colors
colors = ['darkgreen', 'yellowgreen', 'yellow', 'orange', 'darkred']

#-----------------------------------------------------------------------------------------------------------------
'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Create Plots and Maps
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''

box_data = []
for _, row in df.iterrows():
    box = {
        "label": row["C_Type"],
        "whislo": row["min"],
        "q1": row["p10"],
        "med": row["median"],
        "q3": row["p90"],
        "whishi": row["max"],
        "fliers": []
    }
    box_data.append(box)

# -------------------------------------------------
# Plotting
# -------------------------------------------------
fig = plt.figure(figsize=(13, 8))

gs = fig.add_gridspec(2,1, height_ratios=[10, 1])
ax1 = fig.add_subplot(gs[0, :])
ax2 = fig.add_subplot(gs[1, :])

# Draw background color bands using percentile boundaries
for i in range(5):
    ax1.axhspan(
        bounds[i],
        bounds[i+1],
        facecolor=colors[i],
        alpha=0.5
    )

for i, c_type in enumerate(df.index):
    ax1.boxplot([df.loc[c_type, 'min'], df.loc[c_type, 'p10'], df.loc[c_type, 'median'], df.loc[c_type, 'p90'], df.loc[c_type, 'max']],
                positions=[i], widths=0.5,
                medianprops=dict(color='red'))
    ax1.scatter([i], df.loc[c_type, 'min'], color='black', marker='o')
    ax1.scatter([i], df.loc[c_type, 'max'], color='black', marker='o')

ax1.set_xticks(range(len(df.C_Type)), df.C_Type,fontsize=14)
ax1.set_xlabel('Coastal typology',fontsize=14)
ax1.set_ylabel('CVI',fontsize=14)
plt.xticks(rotation=0, ha='right')

#Draw legend
legend_elements = [Line2D([0], [0], marker='s', color='w', label='Very Low ('+str(round(ranges['M1'][0],1))+'-'+str(round(ranges['M1'][1],1))+')', markerfacecolor='darkgreen', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='Low ('+str(round(ranges['M1'][1],1))+'-'+str(round(ranges['M1'][2],1))+')', markerfacecolor='yellowgreen', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='Moderate ('+str(round(ranges['M1'][2],1))+'-'+str(round(ranges['M1'][3],1))+')', markerfacecolor='yellow', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='High ('+str(round(ranges['M1'][3],1))+'-'+str(round(ranges['M1'][4],1))+')', markerfacecolor='orange', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='Very High ('+str(round(ranges['M1'][4],1))+'-'+str(round(ranges['M1'][5],1))+')', markerfacecolor='darkred', markersize=12)]

ax2.legend(handles=legend_elements, loc='center', ncol = 5, frameon= False, title= 'CVI class', title_fontsize = 13, fontsize=13)
ax2.set_frame_on(False)
ax2.set_xticks([]) 
ax2.set_yticks([]) 

fig.tight_layout()
plt.subplots_adjust(wspace=0.03)
plt.tight_layout()
plt.savefig('Typology_based_CVI_distribution.pdf',transparent=None, format='pdf', 
            metadata=None, bbox_inches=None, pad_inches=0.3, facecolor='auto', edgecolor='auto', backend=None)

plt.savefig('Typology_based_CVI_distribution.png',transparent=None, dpi= 700, format='png', 
            metadata=None, bbox_inches=None, pad_inches=0.3, facecolor='auto', edgecolor='auto', backend=None)

