# -*- coding: utf-8 -*-
"""
Created on Fri Nov 15 10:02:18 2024

@author: BasnayakeBMV
"""


#------------------------------------------------------------------------------------------------------------------------
#Import libraries
import pandas as pd
import geopandas as gpd
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D
from pathlib import Path

'''
USER-DEFINED INPUTS
'''

#Folder
script_dir = Path(__file__).resolve().parent

f1 = script_dir/'CVI_Percentile_ranges/'
f2 = script_dir/'IPCC_Regions_CVI/'


#---------------------------------------------------------------------------------------------------------------------------
'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
STEP01: Read data
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''  

ranges = pd.read_csv(f1/'CVI_percentiles.csv')
gdf_CVI_IPCC = gpd.read_file(f2/'CVI_for_IPCC_regions.shp')


#--------------------------------------------------------------------------------------------------------------------------
'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Create Maps
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''

# For Creating vulnerability maps define number of methods and source
M = [1,2,3,4]
Authors = ['Lopez et al., 2016', 'Thieler and Hammar-Klose, 2000', 'Shaw et al., 1998', 'Gornitz, 1991']

gdf_CVI_IPCC['coords'] = gdf_CVI_IPCC['geometry'].apply(lambda x: x.representative_point().coords[:])
gdf_CVI_IPCC['coords'] = [coords[0] for coords in gdf_CVI_IPCC['coords']]

print(list(gdf_CVI_IPCC.columns))

plots = ['Median', '10th percentile', '90th percentile']
sym = ['M1_media_1', 'M1_p10_col', 'M1_p90_col']

#load the world map
url = "https://naturalearth.s3.amazonaws.com/110m_cultural/ne_110m_admin_0_countries.zip"
world = gpd.read_file(url)


##Median CVIs for IPCC regions
fig = plt.figure(figsize=(16,9), dpi=600)
gs = fig.add_gridspec(2,1, height_ratios=[12, 1])
ax1 = fig.add_subplot(gs[0, 0])
ax2 = fig.add_subplot(gs[1, 0])

# plot a basic map of the world
world.plot(ax=ax1, color="lightgray", edgecolor="black", alpha=0.5)

ax1.set_xlabel('Longitude (°)', fontsize='x-large')
ax1.set_ylabel('Latitude (°)', fontsize='x-large')
ax1.set_xlim([-180, 180])
ax1.set_ylim([-80, 90])


#cmap = ListedColormap(['darkgreen', 'yellowgreen','yellow', 'orange', 'darkred'])    
gdf_CVI_IPCC.plot(ax=ax1, color=gdf_CVI_IPCC['M1_media_1'],legend=False, alpha=0.7, edgecolor="black", zorder=2,
                     legend_kwds={"labels":['Very Low','Low','Moderate','High','Very High'],"fontsize": 12,"title_fontsize": 12, "loc": "lower right", "bbox_to_anchor": (0.15, 0.3)})

ax1.axhline(y=0, color='blue', linestyle='--', linewidth=1.5, label='Equator')
ax1.axhline(y=23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Cancer')
ax1.axhline(y=-23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Capricon')

x1, y1 = -150, 5  # Center point of the equator in lon/lat
ax1.text(x1, y1, 'Equator', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x2, y2 = -150, 28.43604  # Center point of the equator in lon/lat
ax1.text(x2, y2, 'Tropic of Cancer', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x3, y3 = -150, -18.43604  # Center point of the equator in lon/lat
ax1.text(x3, y3, 'Tropic of Capricon', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')

for idx, row in gdf_CVI_IPCC.iterrows():
    ax1.annotate(text=row['Acronym'], xy=row['coords'], horizontalalignment='center')

#Draw legend
legend_elements = [Line2D([0], [0], marker='o', color='w', label='Very Low ('+str(round(ranges['M1'][0],1))+'-'+str(round(ranges['M1'][1],1))+')', markerfacecolor='darkgreen', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Low ('+str(round(ranges['M1'][1],1))+'-'+str(round(ranges['M1'][2],1))+')', markerfacecolor='yellowgreen', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Moderate ('+str(round(ranges['M1'][2],1))+'-'+str(round(ranges['M1'][3],1))+')', markerfacecolor='yellow', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='High ('+str(round(ranges['M1'][3],1))+'-'+str(round(ranges['M1'][4],1))+')', markerfacecolor='orange', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Very High ('+str(round(ranges['M1'][4],1))+'-'+str(round(ranges['M1'][5],1))+')', markerfacecolor='darkred', markersize=15)]
ax2.legend(handles=legend_elements, loc='center', ncol = 5, frameon=False, title= 'Median CVI', title_fontsize = 15, fontsize=15)
ax2.set_frame_on(False)
ax2.set_xticks([]) 
ax2.set_yticks([])
fig.tight_layout()
plt.tight_layout()
plt.savefig('IPCC_regions median CVI_Method suggested by Lopez et al.pdf',format="pdf",transparent=None,metadata=None,
            bbox_inches='tight', facecolor='auto', edgecolor='auto', backend=None)    
plt.savefig('IPCC_regions median CVI_Method suggested by Lopez et al.png', transparent=None, format='png', dpi=600,
                metadata=None, bbox_inches='tight', pad_inches=0.1, facecolor='auto', edgecolor='auto', backend=None)


#-----------------------------------------------------------------------------
##Subplots for 10th and 90th %
fig = plt.figure(figsize=(20,7), dpi=600)

gs = fig.add_gridspec(2,2, width_ratios=[1, 1], height_ratios=[12, 1])

ax1 = fig.add_subplot(gs[0, 0])
ax2 = fig.add_subplot(gs[0, 1])
ax3 = fig.add_subplot(gs[1, :])

##p10
# plot a basic map of the world
world.plot(ax=ax1, color="lightgray", edgecolor="black", alpha=0.5)

ax1.set_xlabel('Longitude (°)', fontsize='xx-large')
ax1.set_ylabel('Latitude (°)', fontsize='xx-large')
ax1.set_xlim([-180, 180])
ax1.set_ylim([-80, 90])


#cmap = ListedColormap(['darkgreen', 'yellowgreen','yellow', 'orange', 'darkred'])    
gdf_CVI_IPCC.plot(ax=ax1, color=gdf_CVI_IPCC['M1_p10_col'], legend=False, alpha=0.7, zorder=2,edgecolor="black",
                     legend_kwds={"labels":['Very Low','Low','Moderate','High','Very High'],"fontsize": 12,"title_fontsize": 12, "loc": "lower right", "bbox_to_anchor": (0.15, 0.3)})

ax1.axhline(y=0, color='blue', linestyle='--', linewidth=1.5, label='Equator')
ax1.axhline(y=23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Cancer')
ax1.axhline(y=-23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Capricon')

x1, y1 = -140, 8  # Center point of the equator in lon/lat
ax1.text(x1, y1, 'Equator', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x2, y2 = -140, 31.43604  # Center point of the equator in lon/lat
ax1.text(x2, y2, 'Tropic of Cancer', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x3, y3 = -140, -15.43604  # Center point of the equator in lon/lat
ax1.text(x3, y3, 'Tropic of Capricon', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')

for idx, row in gdf_CVI_IPCC.iterrows():
    ax1.annotate(text=row['Acronym'], xy=row['coords'], horizontalalignment='center')

ax1.set_title('(a)', loc='center', fontsize='xx-large')

#P90
world.plot(ax=ax2, color="lightgray", edgecolor="black", alpha=0.5)
ax2.set_xlabel('Longitude (°)', fontsize='xx-large')
#ax2.set_ylabel('Latitude (°)', fontsize='x-large')
ax2.set_xlim([-180, 180])
ax2.set_ylim([-80, 90])
ax2.set_yticks([]) 

#cmap = ListedColormap(['darkgreen', 'yellowgreen','yellow', 'orange', 'darkred'])    
gdf_CVI_IPCC.plot(ax=ax2, color=gdf_CVI_IPCC['M1_p90_col'], legend=False, alpha=0.7, zorder=2,edgecolor="black",
                     legend_kwds={"labels":['Very Low','Low','Moderate','High','Very High'],"fontsize": 12,"title_fontsize": 12, "loc": "lower right", "bbox_to_anchor": (0.15, 0.3)})

ax2.axhline(y=0, color='blue', linestyle='--', linewidth=1.5, label='Equator')
ax2.axhline(y=23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Cancer')
ax2.axhline(y=-23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Capricon')

x1, y1 = -140, 8  # Center point of the equator in lon/lat
ax2.text(x1, y1, 'Equator', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x2, y2 = -140, 31.43604  # Center point of the equator in lon/lat
ax2.text(x2, y2, 'Tropic of Cancer', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x3, y3 = -140, -15.43604  # Center point of the equator in lon/lat
ax2.text(x3, y3, 'Tropic of Capricon', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')


for idx, row in gdf_CVI_IPCC.iterrows():
    ax2.annotate(text=row['Acronym'], xy=row['coords'], horizontalalignment='center')

ax2.set_title('(b)', loc='center', fontsize='xx-large')

#Draw legend
legend_elements = [Line2D([0], [0], marker='o', color='w', label='Very Low ('+str(round(ranges['M1'][0],1))+'-'+str(round(ranges['M1'][1],1))+')', markerfacecolor='darkgreen', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Low ('+str(round(ranges['M1'][1],1))+'-'+str(round(ranges['M1'][2],1))+')', markerfacecolor='yellowgreen', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Moderate ('+str(round(ranges['M1'][2],1))+'-'+str(round(ranges['M1'][3],1))+')', markerfacecolor='yellow', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='High ('+str(round(ranges['M1'][3],1))+'-'+str(round(ranges['M1'][4],1))+')', markerfacecolor='orange', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Very High ('+str(round(ranges['M1'][4],1))+'-'+str(round(ranges['M1'][5],1))+')', markerfacecolor='darkred', markersize=15)]

ax3.legend(handles=legend_elements, loc='center', ncol = 5, frameon= False, title= 'CVI class', title_fontsize = 16, fontsize=16)
ax3.set_frame_on(False)
ax3.set_xticks([]) 
ax3.set_yticks([]) 
fig.tight_layout()
plt.subplots_adjust(wspace=0.03)
plt.savefig('IPCC_regions p10 p90 CVI_RSLC.pdf', transparent=None, format='pdf',
                metadata=None, bbox_inches='tight', pad_inches=0.1, facecolor='auto', edgecolor='auto', backend=None)

plt.savefig('IPCC_regions p10 p90 CVI_RSLC.png', transparent=None, format='png', dpi=600,
                metadata=None, bbox_inches='tight', pad_inches=0.1, facecolor='auto', edgecolor='auto', backend=None)


