# -*- coding: utf-8 -*-
"""
Created on Thu Nov 14 10:02:18 2024

@author: BasnayakeBMV
"""

#------------------------------------------------------------------------------------------------------------------------
#Import libraries
import pandas as pd
import geopandas as gpd
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D
from pathlib import Path

'''
USER-DEFINED INPUTS
'''
#Folder
script_dir = Path(__file__).resolve().parent
f1 = script_dir/"CVI_Percentile_ranges"
f2 = script_dir/'Countrywise_CVI'

#Read CVI data for countries
ranges = pd.read_csv(f1/'CVI_percentiles.csv')
gdf_CVI_Country = gpd.read_file(f2/'CVI_for_countries.shp')




#-------------------------------------------------------------
'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Create Maps
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''

# For Creating vulnerability maps define number of methods and source
M = [1,2,3,4]
Authors = ['Lopez et al., 2016', 'Thieler and Hammar-Klose, 2000', 'Shaw et al., 1998', 'Gornitz, 1991']

#Create a shapefile
gdf_CVI_Country['coords'] = gdf_CVI_Country['geometry'].apply(lambda x: x.representative_point().coords[:])
gdf_CVI_Country['coords'] = [coords[0] for coords in gdf_CVI_Country['coords']]

print(list(gdf_CVI_Country.columns))

plots = ['Median', '10th percentile', '90th percentile']
sym = ['M1_media_1', 'M1_p10_col', 'M1_p90_col']

#load the world map
url = "https://naturalearth.s3.amazonaws.com/110m_cultural/ne_110m_admin_0_countries.zip"
world = gpd.read_file(url)


#--------------------------------------------------------------------
##Subplots for median, 10th and 90th %
fig = plt.figure(figsize=(18,13), dpi=600)

gs = fig.add_gridspec(3,2, width_ratios=[1, 1], height_ratios=[12,6, 1])

ax1 = fig.add_subplot(gs[0, :])
ax2 = fig.add_subplot(gs[1, 0])
ax3 = fig.add_subplot(gs[1, 1])
ax4 = fig.add_subplot(gs[2, :])

##Median
world.plot(ax=ax1, color="lightgray", edgecolor="black", alpha=0.5)

ax1.set_xlabel('Longitude (°)', fontsize='x-large')
ax1.set_ylabel('Latitude (°)', fontsize='x-large')
ax1.set_xlim([-180, 180])
ax1.set_ylim([-80, 90])

#cmap = ListedColormap(['darkgreen', 'yellowgreen','yellow', 'orange', 'darkred'])    
gdf_CVI_Country.plot(ax=ax1, color=gdf_CVI_Country['M1_media_1'],legend=False, alpha=1, edgecolor="gray", zorder=2,
                     legend_kwds={"labels":['Very Low','Low','Moderate','High','Very High'],"fontsize": 12,"title_fontsize": 12, "loc": "lower right", "bbox_to_anchor": (0.15, 0.3)})
ax1.set_title('(a)', loc='center', fontsize='xx-large')
ax1.axhline(y=0, color='blue', linestyle='--', linewidth=1.5, label='Equator')
ax1.axhline(y=23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Cancer')
ax1.axhline(y=-23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Capricon')

x1, y1 = -150, 5  # Center point of the equator in lon/lat
ax1.text(x1, y1, 'Equator', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x2, y2 = -150, 28.43604  # Center point of the equator in lon/lat
ax1.text(x2, y2, 'Tropic of Cancer', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x3, y3 = -150, -18.43604  # Center point of the equator in lon/lat
ax1.text(x3, y3, 'Tropic of Capricon', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')

##p10
# plot a basic map of the world
world.plot(ax=ax2, color="lightgray", edgecolor="black", alpha=0.5)

ax2.set_xlabel('Longitude (°)', fontsize='xx-large')
ax2.set_ylabel('Latitude (°)', fontsize='xx-large')
ax2.set_xlim([-180, 180])
ax2.set_ylim([-80, 90])

#cmap = ListedColormap(['darkgreen', 'yellowgreen','yellow', 'orange', 'darkred'])    
gdf_CVI_Country.plot(ax=ax2, color=gdf_CVI_Country['M1_p10_col'],legend=False, alpha=1, edgecolor="gray", zorder=2,
                     legend_kwds={"labels":['Very Low','Low','Moderate','High','Very High'],"fontsize": 12,"title_fontsize": 12, "loc": "lower right", "bbox_to_anchor": (0.15, 0.3)})

ax2.set_title('(b)', loc='center', fontsize='xx-large')
ax2.axhline(y=0, color='blue', linestyle='--', linewidth=1.5, label='Equator')
ax2.axhline(y=23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Cancer')
ax2.axhline(y=-23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Capricon')

x1, y1 = -140, 8  # Center point of the equator in lon/lat
ax2.text(x1, y1, 'Equator', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x2, y2 = -140, 31.43604  # Center point of the equator in lon/lat
ax2.text(x2, y2, 'Tropic of Cancer', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x3, y3 = -140, -15.43604  # Center point of the equator in lon/lat
ax2.text(x3, y3, 'Tropic of Capricon', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')


#P90
world.plot(ax=ax3, color="lightgray", edgecolor="black", alpha=0.5)
ax3.set_xlabel('Longitude (°)', fontsize='xx-large')
ax3.set_xlim([-180, 180])
ax3.set_ylim([-80, 90])
ax3.set_yticks([]) 

#cmap = ListedColormap(['darkgreen', 'yellowgreen','yellow', 'orange', 'darkred'])    
gdf_CVI_Country.plot(ax=ax3, color=gdf_CVI_Country['M1_p90_col'], legend=False, alpha=1, zorder=2,edgecolor="gray",
                     legend_kwds={"labels":['Very Low','Low','Moderate','High','Very High'],"fontsize": 12,"title_fontsize": 12, "loc": "lower right", "bbox_to_anchor": (0.15, 0.3)})

ax3.set_title('(b)', loc='center', fontsize='xx-large')
ax3.axhline(y=0, color='blue', linestyle='--', linewidth=1.5, label='Equator')
ax3.axhline(y=23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Cancer')
ax3.axhline(y=-23.43604, color='blue', linestyle='--', linewidth=1.5, label='Topic of Capricon')

x1, y1 = -140, 8  # Center point of the equator in lon/lat
ax3.text(x1, y1, 'Equator', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x2, y2 = -140, 31.43604  # Center point of the equator in lon/lat
ax3.text(x2, y2, 'Tropic of Cancer', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')
x3, y3 = -140, -15.43604  # Center point of the equator in lon/lat
ax3.text(x3, y3, 'Tropic of Capricon', fontsize=14, color='darkblue', ha='center', va='center', backgroundcolor='white')

#Draw legend
legend_elements = [Line2D([0], [0], marker='o', color='w', label='Very Low ('+str(round(ranges['M1'][0],1))+'-'+str(round(ranges['M1'][1],1))+')', markerfacecolor='darkgreen', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Low ('+str(round(ranges['M1'][1],1))+'-'+str(round(ranges['M1'][2],1))+')', markerfacecolor='yellowgreen', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Moderate ('+str(round(ranges['M1'][2],1))+'-'+str(round(ranges['M1'][3],1))+')', markerfacecolor='yellow', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='High ('+str(round(ranges['M1'][3],1))+'-'+str(round(ranges['M1'][4],1))+')', markerfacecolor='orange', markersize=15),
                    Line2D([0], [0], marker='o', color='w', label='Very High ('+str(round(ranges['M1'][4],1))+'-'+str(round(ranges['M1'][5],1))+')', markerfacecolor='darkred', markersize=15)]

ax4.legend(handles=legend_elements, loc='center', ncol = 5, frameon= False, title= 'CVI class', title_fontsize = 16, fontsize=16)
ax4.set_frame_on(False)
ax4.set_xticks([]) 
ax4.set_yticks([]) 
plt.tight_layout()
plt.subplots_adjust(wspace=0.02)
plt.savefig('Countrywise_CVI.pdf',format="pdf",transparent=None,metadata=None,
            bbox_inches='tight', facecolor='auto', edgecolor='auto', backend=None)
plt.savefig('Countrywise_CVI.png', transparent=None, format='png', dpi=600,
                metadata=None, bbox_inches='tight', pad_inches=0.1, facecolor='auto', edgecolor='auto', backend=None)

