# -*- coding: utf-8 -*-
"""
Created on Tue Oct  8 16:53:49 2024

@author: BasnayakeBMV
"""

#import libraries
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D
from pathlib import Path

##-----------------------------------------------------------------------------------------------------------
#Input data for each case study (excel with the summary)
script_dir = Path(__file__).resolve().parent

#Path to rescaled results
F = script_dir/"Validation"
fin = 'Rescaled_results.xlsx'

'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
STEP01: Read data
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''  

data = pd.read_excel(F/fin, sheet_name='Bar_WA')
data_2 = pd.read_excel(F/fin, sheet_name='Australia_Ghana')

print(data)

#-----------------------------------------------------------------------------------------------------------------
'''
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
STEP02: Create Plot
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'''

categories = ['M1', 'M2', 'M3', 'M4']

# Number of categories
n = len(categories)

# Create a bar width
bar_width = 0.25

# Create a figure and axis
fig, ax = plt.subplots()
fig = plt.figure(figsize=(12, 6))
gs = fig.add_gridspec(3,2, width_ratios=[1, 1], height_ratios= [5,5, 0.8])
ax1 = fig.add_subplot(gs[0, 0])
ax2 = fig.add_subplot(gs[0, 1])
#ax3 = fig.add_subplot(gs[1, :])
ax4 = fig.add_subplot(gs[1, 0])
ax6 = fig.add_subplot(gs[1, 1])
ax8 = fig.add_subplot(gs[2, :])

# Set the positions of the bars on the x-axis
index = np.arange(n)

## 1. Barcelona
data1 = data['Barcelona_CVI classes rescaled  to regional/ local scale'][:]

# Plot bars for data1 and data2
bar1 = ax1.bar(index, data1, bar_width, color='m', label='CVI classes rescaled \nto regional/ local scale')

# Add labels, title, and legend
ax1.set_xlabel('CVI method', fontsize=11)
ax1.set_ylabel('Matched locations (%)',fontsize=11)
ax1.set_title('(a) Percentage match with the local study \n for Barcelona')
ax1.set_xticks(index)
ax1.set_xticklabels(categories,rotation=0)
#ax1.legend()

## 2. West Africa
data1 = data['WA_CVI classes rescaled  to regional/ local scale'][:]
#data2 = data['WA_Global CVI classes'][:]
bar1 = ax2.bar(index, data1, bar_width, color='m', label='CVI classes rescaled \nto regional/ local scale')
#bar2 = ax2.bar(index + bar_width, data2, bar_width, color='g', label='Global CVI classes')

# Add labels, title, and legend
ax2.set_xlabel('CVI method',fontsize=11)
ax2.set_ylabel('Matched locations (%)',fontsize=11)
ax2.set_title('(b) Percentage match with the regional study \n for West Africa')
ax2.set_xticks(index)
ax2.set_xticklabels(categories,rotation=0)


## 3. Ghana, Rescaled
# Convert qualitative data to numerical values for plotting
def convert_to_numeric(data):
    mapping = {'Very High': 5, 'High': 4, 'Moderate': 3, 'Low': 2, 'Very Low':1}
    return [mapping[val] for val in data]

##Y axis
ys = [0, 1,2,3,4,5]
labels = [' ','VL','L','M','H','VH']

region = ['West Accra', 'Central Accra', 'East Accra']
local_study = data_2['Local_R'][6:9]
lopez_2016 = data_2['M1_R'][6:9]
thiler_2000 = data_2['M2_R'][6:9]
shaw_1998 = data_2['M3_R'][6:9]
gornitz_1991 = data_2['M4_R'][6:9]
local_study_numeric = convert_to_numeric(local_study)
lopez_2016_numeric = convert_to_numeric(lopez_2016)
thiler_2000_numeric = convert_to_numeric(thiler_2000)
shaw_1998_numeric = convert_to_numeric(shaw_1998)
gornitz_1991_numeric = convert_to_numeric(gornitz_1991)

bar_width = 0.1
index = np.arange(len(region))

ax4.bar(region, local_study_numeric, bar_width, label='Local CVI', color='royalblue')
ax4.bar(index + bar_width, lopez_2016_numeric, bar_width, color='darkorange', label='Global CVI - Lopez et al. (2016) Method')
ax4.bar(index + 2 * bar_width, thiler_2000_numeric, bar_width, color='forestgreen', label='Global CVI - Thiler and Hammar-klose (2000) Method')
ax4.bar(index + 3 * bar_width, shaw_1998_numeric, bar_width,color='crimson', label='Global CVI - Shaw et al. (1998) Method')
ax4.bar(index + 4 * bar_width, gornitz_1991_numeric, bar_width, color='darkorchid',label='Global CVI - Gornitz (1991) Method')
ax4.set_xlabel('Location',fontsize=11)
ax4.set_ylabel('Median CVI class',fontsize=11)
ax4.set_title('(c) Comparison of global CVIs rescaled \n for Accra, Ghana')
ax4.set_xticks(index + 2 * bar_width, region)
ax4.set_yticks(ys, labels)

region = ['West Accra', 'Central Accra', 'East Accra']
local_study = data_2['Local_G'][6:9]
lopez_2016 = data_2['M1_G'][6:9]
thiler_2000 = data_2['M2_G'][6:9]
shaw_1998 = data_2['M3_G'][6:9]
gornitz_1991 = data_2['M4_G'][6:9]
local_study_numeric = convert_to_numeric(local_study)
lopez_2016_numeric = convert_to_numeric(lopez_2016)
thiler_2000_numeric = convert_to_numeric(thiler_2000)
shaw_1998_numeric = convert_to_numeric(shaw_1998)
gornitz_1991_numeric = convert_to_numeric(gornitz_1991)

bar_width = 0.1
index = np.arange(len(region))


## 4. Australia
region = data_2['Unnamed: 0'][0:6]
local_study = data_2['Local_R'][0:6]
lopez_2016 = data_2['M1_R'][0:6]
thiler_2000 = data_2['M2_R'][0:6]
shaw_1998 = data_2['M3_R'][0:6]
gornitz_1991 = data_2['M4_R'][0:6]
local_study_numeric = convert_to_numeric(local_study)
lopez_2016_numeric = convert_to_numeric(lopez_2016)
thiler_2000_numeric = convert_to_numeric(thiler_2000)
shaw_1998_numeric = convert_to_numeric(shaw_1998)
gornitz_1991_numeric = convert_to_numeric(gornitz_1991)


bar_width = 0.11
index = np.arange(len(region))

ax6.bar(region, local_study_numeric, bar_width, label='Local CVI', color='royalblue')
ax6.bar(index + bar_width, lopez_2016_numeric, bar_width, color='darkorange', label='Global CVI - Lopez et al. (2016) Method')
ax6.bar(index + 2 * bar_width, thiler_2000_numeric, bar_width, color='forestgreen', label='Global CVI - Thiler and Hammar-klose (2000) Method')
ax6.bar(index + 3 * bar_width, shaw_1998_numeric, bar_width,color='crimson', label='Global CVI - Shaw et al. (1998) Method')
ax6.bar(index + 4 * bar_width, gornitz_1991_numeric, bar_width, color='darkorchid',label='Global CVI - Gornitz (1991) Method')
ax6.set_xlabel('Location',fontsize=12)
ax6.set_ylabel('Median CVI class',fontsize=12)
ax6.set_title('(d) Comparison of global CVIs rescaled \n for Illawarra, Australia')
ax6.set_xticks(index + 2 * bar_width, ['Stanwell \n Park', 'Coledale','Bulli','Perkins','Warilla','Seven \n Mile'])

ax6.set_yticks(ys, labels)

region = data_2['Unnamed: 0'][0:6]
local_study = data_2['Local_G'][0:6]
lopez_2016 = data_2['M1_G'][0:6]
thiler_2000 = data_2['M2_G'][0:6]
shaw_1998 = data_2['M3_G'][0:6]
gornitz_1991 = data_2['M4_G'][0:6]
local_study_numeric = convert_to_numeric(local_study)
lopez_2016_numeric = convert_to_numeric(lopez_2016)
thiler_2000_numeric = convert_to_numeric(thiler_2000)
shaw_1998_numeric = convert_to_numeric(shaw_1998)
gornitz_1991_numeric = convert_to_numeric(gornitz_1991)

bar_width = 0.11
index = np.arange(len(region))

# Place the legend outside the plot
legend_elements = [Line2D([0], [0], marker='s', color='w', label='Local/ regional study', markerfacecolor='royalblue', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='Lopez et al. (2016)', markerfacecolor='darkorange', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='Thieler and Hammar-Klose (2000)', markerfacecolor='forestgreen', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='Shaw et al. (1998)', markerfacecolor='crimson', markersize=12),
                    Line2D([0], [0], marker='s', color='w', label='Gornitz (1991)', markerfacecolor='darkorchid', markersize=12)]
ax8.legend(handles=legend_elements, loc='center', ncol = 5, frameon=False, title= 'CVI calculation method', title_fontsize = 11, fontsize=10)
ax8.set_frame_on(False)
ax8.set_xticks([]) 
ax8.set_yticks([])
plt.tight_layout()
plt.savefig('Validation_plots.pdf', transparent=None, format='pdf', 
                metadata=None, bbox_inches='tight', pad_inches=0.1, facecolor='auto', 
                edgecolor='auto', backend=None)

plt.savefig('Validation_plots.png', transparent=None, format='png', dpi=600,
                metadata=None, bbox_inches='tight', pad_inches=0.1, facecolor='auto', 
                edgecolor='auto', backend=None)



