def validate_agent(agent_name):
    """Check if agent_name is predefined or not."""
    
    AGENTS = {
    "gemini-1.5-pro": "scripts/llms/gemini.py",
    "gemini-1.5-flash": "scripts/llms/gemini.py",
    "gpt-4o": "scripts/llms/gpt.py",
    "gpt-4o-mini": "scripts/llms/gpt.py",
    "mistral-large-latest": "scripts/llms/mistral.py",
    "codestral-latest": "scripts/llms/mistral.py",
    "llama3.2": "scripts/llms/llama.py"
    }
    
    if agent_name in AGENTS:
        return AGENTS[agent_name]
    else:
        raise ValueError(f"Agent not found: {agent_name}")

def validate_framework(framework_name):
    """Check if framework_name is predefined or not."""
    
    FRAMEWORKS = {
    "autogen": "scripts/agent_frameworks/autogen_agent.py",
    "crewai": "scripts/agent_frameworks/crew_framework/crew.py",
    "two_agent": "scripts/agent_frameworks/two_agent/two_agent.py",
    }
    
    if framework_name in FRAMEWORKS:
        return FRAMEWORKS[framework_name]
    else:
        raise ValueError(f"Framework not found: {framework_name}")
    
def validate_crew_model(model):
    # In addition to providing the model name, CrewAI requires the name 
    # of the model provider. So instead of "gemini-1.5-pro", it should
    # be "gemini/gemini-1.5-pro" etc. 
    """Check if model is predefined or not."""
    
    MODELS = {
    "gemini-1.5-pro": "gemini/gemini-1.5-pro",
    "gemini-1.5-flash": "gemini/gemini-1.5-flash",
    "gpt-4o": "gpt-4o",
    "gpt-4o-mini": "gpt-4o-mini",
    "mistral-large-latest": "mistral/mistral-large-latest",
    "codestral-latest": "mistral/codestral-latest",
    "llama3.2": "ollama/llama3.2"
    }
    
    if model in MODELS:
        return MODELS[model]
    else:
        raise ValueError(f"Model not found: {model}")