import subprocess

def run_and_log(command, log_file_path):
    """
    Runs a shell command, logs its output to a file, and prints it to the console.
    """
    try:
        with open(log_file_path, "a") as log_file:
            process = subprocess.Popen(
                command,
                shell=True,
                stdout=subprocess.PIPE,
                stderr=subprocess.STDOUT,
                universal_newlines=True
            )
            for line in process.stdout:
                print(line, end="")  # Print to console
                log_file.write(line)  # Write to log file
            process.wait()
            return process.returncode
    except Exception as e:
        print(f"Error while running command: {e}")
        return -1
