import json

def get_api_key(model):
    # Load API_KEYS file
    try:
        with open('scripts/API_KEYS', 'r') as file:
            api_keys = json.load(file)
    except FileNotFoundError:
        raise FileNotFoundError("API_KEYS not found. Please make sure the file exists in the scripts directory.")
            
    # Search for the API key corresponding to the model
    api_key = None
    for config in api_keys:
        if config.get('model') == model:
            api_key = config.get('api_key')
            break

    if api_key is None:
        raise ValueError(f"No API key found for model '{model}' in API_KEYS.")
        
    return api_key