import difflib
import os

def read_file(file_path):
    with open(file_path, 'r') as file:
        return file.readlines()


def write_code_diff(p1, p2):
    print(os.getcwd())
    file1 = read_file(p1)
    file2 = read_file(p2)
    diff = difflib.unified_diff(file1, file2, fromfile=p1, tofile=p2)

    diff_file_path = os.path.join(os.path.dirname(p1),"diff.txt")
    with open(diff_file_path, "a") as f:
        f.write("".join(diff))
        f.write("/"*100 + "\n")