from pathlib import Path
import subprocess
import tempfile

def apply_diff(original_file_path, diff_content):
    
    with tempfile.NamedTemporaryFile(delete=False, mode='w') as temp_patch_file:
        temp_patch_file.write(diff_content)
        temp_patch_file_path = temp_patch_file.name

    try:
        subprocess.run(['patch', original_file_path, temp_patch_file_path], check=True)
        print(f"Patch applied successfully to {original_file_path}")
    except subprocess.CalledProcessError as e:
        print(f"Failed to apply patch: {e}")
    finally:
        Path(temp_patch_file_path).unlink()