from crewai import Task
import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../../')))
from scripts.utils.load_prompts import load_prompts
from tools import FileReadTool

prompts = load_prompts()

optimize_task = Task(
    description="The file at {file_path} " + prompts['system_message'] + prompts['system_message'],
    expected_output="""
        The entire code with the changes applied to it, with 
        an explanation of the changes made.
    """,
    tools=[FileReadTool],
    async_execution=False
)

optimitize_again = Task(
    description="""
        Implementing the changes you suggested yields the results in the csv file found at 
        {results_file}. Keeping in mind what changes you suggested earlier and the results 
        that were generated, make some further changes to the code that could help decrease
        the relative error estimation
        even further. Please output the entire code I give you and do it in one codeblock.
    """,
    expected_output="""
        The entire code with the changes applied to it, with an explanation of the changes made.""",
    tools=[FileReadTool],
    async_execution=False
)