from crewai import Agent, LLM
from tools import FileReadTool
from dotenv import load_dotenv
import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../../')))
from scripts.utils.validation import validate_crew_model
from scripts.utils.get_api_key import get_api_key
from scripts.utils.load_prompts import load_prompts

load_dotenv()

def create_optimizer(model):
    api_key = get_api_key(model)
 
    model = validate_crew_model(model)
   
    prompts = load_prompts()
    llm = LLM(model=model,
              api_key=api_key)
    
    optimizer = Agent(
        role="Reader",
        goal="The file at {file_path} " + prompts['system_message'] + prompts['system_message'],
        verbose=True,
        memory=True,
        backstory=(
             "With a flair for machine learning algorithms, you are"
             "excellent at optimizing code for machine learning."
        ),
        tools=[FileReadTool],
        llm=llm,
        allow_delegation=False,
    )
    
    return optimizer