"""Two-agent entry point.

Main entry point for the two-agent optimisation framework.
"""
import argparse
import sys

# Import the orchestrator
from orchestrator import main, TwoAgentCriticalFailure


if __name__ == "__main__":
    parser = argparse.ArgumentParser(
        description="Two-agent framework for iterative hyperparameter optimisation."
    )
    parser.add_argument("input_path", type=str, help="Path to the input notebook or Python file")
    parser.add_argument("model", type=str, help="Language model to use (e.g., gemini-1.5-flash)")
    parser.add_argument(
        "-opt", "--option", 
        type=str, 
        default="whole_code", 
        choices=['manual_patch', 'whole_code', 'agent_applies'], 
        help="Output option for code modifications"
    )
    
    args = parser.parse_args()
    main(args.input_path, args.model, args.option) 