from crewai import Task
import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../../../')))
from scripts.utils.load_prompts import load_prompts
from tools import FileReadTool

prompts = load_prompts()

optimize_task = Task(
    description=("The file at {file_path} " + prompts['system_message']),
    expected_output="An explanation of the changes made to the code.",
    tools=[FileReadTool],
    async_execution=False
)

apply_task = Task(
    description="Apply the generated patch to the file at {file_path}.",
    expected_output="The patch has been applied successfully and returned in a single python codeblock.",
    tools=[FileReadTool],
    async_execution=False
)