import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..', '..')))
from scripts.utils.parse_agent_output import parse
from scripts.utils.apply_diff import apply_diff
from scripts.utils.load_prompts import load_prompts
from crewai import Crew, Process
from tasks import optimize_task, apply_task
from agents import create_optimizer, create_applier
import argparse

def main(input_path, model, option):
    print(f"Running {model}...with option={option}")
    
    prompts = load_prompts()
    
    if option=="whole_code":
        prompt = prompts['whole_code']
    else:
        prompt = prompts['diff']
    
    # Create the optimizer agent based on model
    optimizer = create_optimizer(model)
    optimizer.goal += prompt
    optimize_task.agent = optimizer
    optimize_task.description += prompt
    
    if option == "agent_applies":
        applier = create_applier(model)
        apply_task.agent = applier
        crew = Crew(
            agents=[optimizer, applier],
            tasks=[optimize_task, apply_task],
            process=Process.sequential,
        )
    else:
        crew = Crew(
            agents=[optimizer],
            tasks=[optimize_task],
            process=Process.sequential,
        )

    result = crew.kickoff(inputs={'file_path': input_path})
    parsed_response = parse(result.raw)
    print("parsed_response:", parsed_response)
    
    if option=="manual_patch":
        apply_diff(input_path, parsed_response)
    else: # whole_code or agent_applies
        with open(input_path, "w") as f:
            f.write(parsed_response)
    
if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Modify hyperparameters of a notebook to decrease relative error estimation.")
    parser.add_argument("input_path", type=str, help="Path to the input notebook file")
    parser.add_argument("model", type=str, help="Specify the model to use")
    parser.add_argument("-opt", "--option", type=str, default="manual_patch", choices=['manual_patch', 'whole_code', 'agent_applies'], help="Choose how to apply the agent's changes")
    args = parser.parse_args()

    main(args.input_path, args.model, args.option)
    