from crewai import Agent, LLM
from tools import FileReadTool
from dotenv import load_dotenv
import sys
import os
sys.path.append(os.path.abspath(os.path.join(os.path.dirname(__file__), '../../../')))
from scripts.utils.validation import validate_crew_model
from scripts.utils.get_api_key import get_api_key
from scripts.utils.load_prompts import load_prompts

load_dotenv()

def create_optimizer(model):
    api_key = get_api_key(model)
 
    model = validate_crew_model(model)
   
    prompts = load_prompts()
    llm = LLM(model=model,
              api_key=api_key)
    
    optimizer = Agent(
        role="Reader",
        goal="The file at {file_path} " + prompts['system_message'],
        verbose=True,
        memory=True,
        backstory=(
             "With a flair for simplifying complex topics, you are"
             "excellent at optimizing code."
        ),
        tools=[FileReadTool],
        llm=llm,
        allow_delegation=False
    )
    
    return optimizer

def create_applier(model):
    api_key = get_api_key(model)
 
    model = validate_crew_model(model)

    llm = LLM(model=model,
              api_key=api_key)
    
    applier = Agent(
        role="Applier",
        goal="Apply the generated patch to the file at {file_path}.",
        verbose=True,
        memory=True,
        backstory=(
             "With a flair for applying changes, you are"
             "excellent at implementing code modifications."
        ),
        tools=[FileReadTool],
        llm=llm,
        allow_delegation=False
    )
    
    return applier