# FRA-RIG-breast — code-only demo

**Research demo** of the RIG–FRA block-weighted risk scoring for breast cancer (sklearn).  
This package contains **code only**. Model weights and the calibration report are available on Zenodo.

- **Dataset DOI (weights & report):** https://doi.org/10.5281/zenodo.17489822
- **License:** MIT
- **Status:** experimental / research-only (not for clinical or diagnostic use).

## Quick run

1) Download the model weights (`fra_rig_breast.joblib`) from the Zenodo record above
   and place the file at: `models/fra_rig_breast.joblib` (relative to this README).
2) Create a Python environment and install requirements:
```bash
pip install -r requirements.txt
```
3) Run the demo:
```bash
python predict_demo.py
```
By default, the demo prints probabilities for a few samples and the internal block scores **S_R, S_I, S_G**.

## Notes
- The model uses a transparent three-block design: **R** (morphology/size), **I** (texture/symmetry/fractal properties), **G** (geometry/compactness/concavity).
- Final probability is computed by a logistic regression head on the block indices.
- For citation, you may cite the Zenodo dataset DOI above. If you later archive the **software** on Zenodo,
  update `CITATION.cff` with the software DOI.
