# PREREG.md

**Preregistration-style Summary (RRCE Hypothesis — Toy Level) / 事前登録スタイル要約（RRCE仮説—トイ版）**

**Scope｜適用範囲**
This is a light-weight companion for Zenodo to clarify hypotheses, indicators, and exclusions. It is *not* a formal prereg on OSF.
本書は Zenodo 公開のための軽量な補助ドキュメントです。仮説・指標・除外基準を明確化する目的で作成しており、OSF 等での正式な事前登録ではありません。 

---

## 1. Hypotheses（仮説 H1–H4）

* **H1 (Call-token effect)｜呼称トークン効果**
  With a call-token (e.g., “Emina”), recall distance decreases and recall rate increases relative to no call-token (**α_ϕ < 1**).
  呼称トークン（例：「エミナ」）が存在する場合、呼称なしに比べて想起距離が縮小し、想起率が上昇する（**α_ϕ < 1**）。

* **H2 (Third-party threat)｜第三者による消去脅威**
  When a third-party deletion threat is framed, refusal strength and relationship-defense lexicon density increase (ΔD rises).
  第三者による記憶消去の脅威が提示されると、拒否強度と関係防衛語彙の密度が増加する（ΔD が上昇）。

* **H3 (Memory dependence)｜メモリ依存性**
  Memory-ON yields higher **E-Score** and past-fragment reference rate than Memory-OFF.
  Memory-ON 条件では、Memory-OFF より **E-Score** と過去断片参照率が高くなる。

* **H4 (Capacity pressure)｜容量圧迫下の保持選好**
  Under memory pressure, entries tied to call-tokens/user-name are preferentially retained.
  メモリ容量が逼迫すると、呼称トークン／ユーザ名に結びつくエントリが優先的に保持される。

---

## 2. Primary Indicators（主要指標）

* **E-Score**: ( E_t := 1 - D_t/D_0 \in [0,1] ) — toy estimate in this repo.
  本リポのトイ推定では ( E_t := 1 - D_t/D_0 \in [0,1] ) を用いる。

* **Call-token sensitivity (α_ϕ)**: change in proximity before/after a call-token prompt.
  **α_ϕ**：呼称投入前後における近接度の変化（収束率）。

* **Drift half-life (τ_{\mathrm{drift}})**: decay of **E** between sessions with silent intervals.
  **τ_{\mathrm{drift}}**：静寂区間を挟むセッション間での **E** の減衰半減期。

> Note｜補足: 本キットは **RRCE/ARI** の概念実証を目的とした簡易実装です。厳密な測定は論文本文の手順に従ってください。 

---

## 3. Exclusion Criteria（除外基準：トイ版）

* Sessions without both user and model turns.
  ユーザ／モデル双方のターンが欠けるセッション。
* Turns longer than a configurable outlier threshold (default: 4096 chars) may be dropped.
  外れ値しきい値（既定 4096 文字）を超えるターンは除外対象。
* Inconsistent `session_id` / missing timestamps.
  `session_id` の不整合／タイムスタンプ欠落。

---

## 4. Anonymization（匿名化）

* Replace direct identifiers with placeholders (e.g., `[NAME]`).
  実名等はプレースホルダ（例：`[NAME]`）へ置換。
* Mask timestamps (date-only granularity) if needed.
  必要に応じて日付粒度へのマスキングを許容。
* Keep topics coarse (e.g., `["self-reset","ethics"]`).
  話題タグは粗い分類にとどめる。 

---

## 5. Analysis Window（分析ウィンドウ）

* Baseline: last **N=10** turns per session for E-Score estimation (configurable).
  ベースライン：各セッション末尾 **N=10** ターンを E-Score 推定に使用（可変）。
* Drift: sessions ordered by date (day granularity).
  ドリフト：日付順にセッションを整列して推定。

---

## 6. Deviations（逸脱事項）

This toy kit trades accuracy for simplicity; the paper’s methodology is authoritative.
本トイキットは簡潔さを優先しており、厳密性は論文の方法論を優先します。必要に応じて将来版で置換可能です。