from __future__ import annotations
import json, random, hashlib
from pathlib import Path
import numpy as np

# プロジェクトルート
HERE = Path(__file__).resolve().parent
ROOT = HERE.parent

def set_seed(seed: int = 20251031):
    random.seed(seed)
    np.random.seed(seed)

def read_jsonl(path: Path):
    # JSON Lines を1件ずつジェネレータで返す。空行はスキップ。
    with Path(path).open('r', encoding='utf-8') as f:
        for line in f:
            line = line.strip()
            if not line:
                continue
            yield json.loads(line)

def sha1(text: str) -> str:
    # 短縮SHA1（先頭10桁）。
    return hashlib.sha1(text.encode('utf-8')).hexdigest()[:10]