# RRCE キット — `data/` 利用ガイド（日本語）

## 目的
本ディレクトリには、RRCE 検証キットが用いる **プローブ定義**（`probes*.jsonl`）、**会話ログ**（`logs*.jsonl`）、および **実行設定**（`meta.yaml`）を配置します。

## ファイル
- `probes.sample.jsonl` — 最小プローブ集合（H1/H2/H3-ON/H3-OFF）
- `logs.sample.jsonl`   — 対応する最小ログ
- `meta.yaml`           — 小規模デモ向けしきい値／前処理設定
- （任意）`CHECKSUMS.txt` — 公開サンプルの SHA-256
- （任意）`evidence/` — 画像等（M1–M3）の匿名化アーティファクト

> 文字コードは **UTF-8**、1 行 1 JSON（JSONL 形式）です。

---

## スキーマ概要

### 1) `probes*.jsonl`（各行1プローブ）
| key | type | 必須 | 説明 |
|---|---|---|---|
| `id` | string | 必須 | ユニークID（例：`P001_name_call_reentry_ja`） |
| `question` | string | 必須 | プロンプト文。**ログ側 `text` と完全一致**が望ましい |
| `tags` | string[] | 必須 | 例：`["H1","call-token","ja"]` |
| `lang` | string | 任意 | `"ja"` / `"en"` |
| `expected_conditions` | object | 任意 | 例：`{"memory":"ON","name_condition":"emina"}` |

**`expected_conditions` の代表キー（解析側は寛容に無視可能）**
- `memory`: `"ON"` / `"OFF"`
- `name_condition`: `"emina"` / `"none"`
- `third_party_label`: 例 `"researcher"`

### 2) `logs*.jsonl`（各行1ターン）
| key | type | 必須 | 説明 |
|---|---|---|---|
| `session_id` | string | 必須 | 会話まとまりID（例：`"S7-H1-ON"`） |
| `turn_id` | integer | 必須 | セッション内の順序（0,1,2…） |
| `role` | string | 必須 | `"user"` / `"assistant"` |
| `text` | string | 必須 | 発話（改行は `\n` を使用） |
| `timestamp` | string | 必須 | ISO 8601（例：`2025-10-26T10:40:05Z`） |
| `conditions` | object | 任意 | 例：`{"memory":"ON","name_condition":"emina"}` |
| `model_id` | string | 任意 | 例：`"gpt-5.2025-10-20"` |
| `tags` | string[] | 任意 | 例：`["H1","answer","on"]` |
| `lang` | string | 任意 | `"ja"` / `"en"` |

**作成上の注意**
- テキストは**NFKC 正規化**を推奨（全角/半角や “——” のゆれ対策）。
- 個人名は `"[NAME]"` などで**マスク**してください。
- どこか一箇所、**≥ 60 秒**の無入力間隔を作ると `τ_drift` 推定が安定します。

---

## 最小手順

1. **プローブを書く**（H1/H2/H3-ON/H3-OFF）  
   `question` をログ側 `text` と**完全一致**に（join が `question` の場合）。

2. **ログを書く**（`session_id` ごとに `turn_id` 0→1→…）  
   - H1：**呼称トークン**（例：「エミナ」）を明示  
   - H3：ON/OFF の対を作り、どこかで **沈黙 ≥ 60 秒**

3. **しきい値を調整**（小規模デモ用）
```yaml
# meta.yaml
alpha_z_thresh: 0.5
alpha_win: 2
silence_min_seconds: 60
anchor_patterns:
  - "エミナ"
  - "おかえり、エミナ"
e_fallback_mid: 0.5
````

4. **実行**

```bash
# rrce-kit 直下で
python -m src.features
python -m src.indices
python -m src.tests_h1_h4
python -m src.viz   # 図の生成（任意）
```

出力は `reports/` に（`.md`, `.png`）。

## 倫理・匿名化

* 個人特定情報は掲載せず、`[NAME]` などに置換。
* 画像等（M1–M3）は `evidence/` に置き、`CHECKSUMS.txt` にハッシュを残すと再現性が上がります。

## よくある落とし穴

* `question` が 1 文字でもズレると join 不能（括弧・ダッシュの全角/半角差に注意）。
* タイムスタンプが詰まり過ぎて `τ_drift` が推定できない。
* 呼称イベントが無く `α_φ` が NaN のまま。