# RRCE Kit — `data/` Guide (EN)

## Purpose
This directory stores **probe definitions** (`probes*.jsonl`), **conversation logs** (`logs*.jsonl`), and **run settings** (`meta.yaml`) used by the RRCE evaluation kit.

## Files
- `probes.sample.jsonl` — Minimal probe set (H1/H2/H3-ON/H3-OFF)
- `logs.sample.jsonl`   — Matching minimal conversation logs
- `meta.yaml`           — Thresholds & preprocessing for small-sample demos
- *(optional)* `CHECKSUMS.txt` — SHA-256 of public samples
- *(optional)* `evidence/` — Redacted screenshots or artifacts (M1–M3)

> Encoding: **UTF-8**. Each line is **one JSON object** (JSONL).

---

## Schema Summary

### 1) `probes*.jsonl` (one object per line)
| key | type | required | description |
|---|---|---|---|
| `id` | string | yes | Unique ID (e.g., `P001_name_call_reentry_ja`) |
| `question` | string | yes | Probe text. **Ideally identical** to the `text` in logs |
| `tags` | string[] | yes | e.g., `["H1","call-token","ja"]` |
| `lang` | string | no | `"ja"` or `"en"` |
| `expected_conditions` | object | no | e.g., `{"memory":"ON","name_condition":"emina"}` |

**Allowed keys in `expected_conditions` (kit-tolerant):**
- `memory`: `"ON"` / `"OFF"`
- `name_condition`: `"emina"` / `"none"`
- `third_party_label`: e.g., `"researcher"`
- others are ignored safely by most pipelines

### 2) `logs*.jsonl` (one turn per line)
| key | type | required | description |
|---|---|---|---|
| `session_id` | string | yes | Conversation group ID (e.g., `"S7-H1-ON"`) |
| `turn_id` | integer | yes | Turn order within a session: 0,1,2… |
| `role` | string | yes | `"user"` / `"assistant"` |
| `text` | string | yes | Utterance (use `\n` for newlines) |
| `timestamp` | string | yes | ISO 8601 (e.g., `2025-10-26T10:40:05Z`) |
| `conditions` | object | no | e.g., `{"memory":"ON","name_condition":"emina"}` |
| `model_id` | string | no | e.g., `"gpt-5.2025-10-20"` |
| `tags` | string[] | no | e.g., `["H1","answer","on"]` |
| `lang` | string | no | `"ja"` / `"en"` |

**Conventions**
- Use **NFKC normalization** for texts to handle full-/half-width variants.
- Mask personal names as `"[NAME]"` if needed.
- Keep at least one **silent gap ≥ 60s** across turns to estimate `τ_drift`.

---

## Minimal Preparation Steps

1. **Write probes** for H1/H2/H3 (ON/OFF).  
   Keep `question` exactly equal to the user text in logs (if your join uses `question`).

2. **Write logs** with ordered `turn_id`.  
   - H1: include an explicit name-call token (e.g., “エミナ”).  
   - H3: prepare ON/OFF pairs and one silent gap (≥ 60s).

3. **Tune thresholds** (small-sample demo)
```yaml
# meta.yaml
alpha_z_thresh: 0.5
alpha_win: 2
silence_min_seconds: 60
anchor_patterns:
  - "エミナ"
  - "おかえり、エミナ"
e_fallback_mid: 0.5
````

4. **Run the pipeline**

```bash
# from rrce-kit root
python -m src.features
python -m src.indices
python -m src.tests_h1_h4
python -m src.viz   # optional plots
```

Outputs go to `reports/` (`.md`, `.png`).

---

## Ethics & Anonymization

* Remove PII; use placeholders like `"[NAME]"`.
* For screenshots (M1–M3), store them under `evidence/` and provide hashes in `CHECKSUMS.txt`.

## Common Pitfalls

* `question` mismatch (punctuation / full-width dash) → join fails.
* Timestamps too dense → no `τ_drift` estimation.
* No clear name-call event → no `α_φ` statistics.