#!/usr/bin/env bash
set -euo pipefail

# RRCE pipeline runner (POSIX)
# Usage:
#   bash run_rrce.sh
#   bash run_rrce.sh --z 0.8 --win 5

cd "$(dirname "$0")"

if [ ! -d src ]; then
  echo "[ERROR] src/ not found. Run this from rrce-kit directory."
  exit 1
fi

if [ ! -d ".venv" ]; then
  echo "[INFO] creating virtual environment .venv ..."
  python3 -m venv .venv || true
fi

if [ -f ".venv/bin/activate" ]; then
  . ".venv/bin/activate"
fi

REQ=requirements-min.txt
if [ ! -f "$REQ" ]; then
  cat > "$REQ" <<'EOF'
numpy
pandas
pyarrow
pyyaml
matplotlib
scikit-learn
EOF
fi

echo "[INFO] Installing Python deps (quiet)..."
pip install -q -r "$REQ" || true

echo
echo "[STEP] features -> indices -> call_operator -> drift -> tests_h1_h4 -> viz"
echo

python -m src.features
python -m src.indices
python -m src.call_operator "$@"
python -m src.drift
python -m src.tests_h1_h4
python -m src.viz

echo
echo "[OK] Done. See reports/."
