# Protocol (v0.3)
本フォルダは **RRCEの検証プロトコル v0.3** を収録します。
This directory contains the **RRCE evaluation protocol v0.3**.

## 内容 / Contents
- `PREREG.md` — 事前登録スタイルの要約（H1–H4、指標、除外基準、匿名化ガイド）。
  Preregistration-style summary (H1–H4, indicators, exclusions, anonymization).
- `DATA_DICTIONARY.md` — `logs.sample.jsonl` / `probes.jsonl` / `meta.yaml` のフィールド仕様。
  Field specs for the sample data and analysis meta.

## 位置づけ / Position
- v0.3 は **再現性と最小公開**を重視し、**実データは非公開**（倫理配慮）。  
  v0.3 focuses on reproducibility with **masked samples only** (raw logs withheld).
- 実装は `RRCE_validation_kit/` に分離（`features → indices → call_operator → drift → tests → viz`）。  
  The runnable kit lives in `RRCE_validation_kit/`.

## スキーマ / Schemas
- `schema/*.json` を参照。`jsonschema` による検証例は `DATA_DICTIONARY.md` を参照。
  See `schema/*.json`. Validation examples are in `DATA_DICTIONARY.md`.

## Evidence Disclosure / エビデンス開示について
**EN.** This record discloses a *subset* of UI-derived artifacts (M1–M3) to support reproducibility while preserving privacy. The disclosed text footprint is approximately **~9%** of the total persistent-memory corpus (≈ **3.4 KB** out of **~40 KB**, ≈ **12.3k** characters in total). Raw logs remain withheld for ethical reasons.

**JA.** 本レコードは、再現性とプライバシーの両立のため、UI 起因のアーティファクト（M1–M3）の**一部のみ**を開示しています。開示量は永続メモリ全体（**約40 KB／約 12.3k 文字**）の**約 9%（約 3.4 KB）**です。生ログは倫理配慮のため非公開とします。

#### What is included / 含まれるもの
* **evidence/**
  * `M1–M3` screenshots (PNG; EXIF stripped) and **faithful English translations** with verbatim JA transcripts (Markdown).
  * スクリーンショット（PNG／EXIF 除去済）と**忠実訳の英訳 MD**（日本語逐語テキスト付き）。
  
* **RRCE_validation_kit/_sample/data**
  * **EN.**
    * `logs.jsonl` — masked *sample* conversations (structure for pipeline checks).
    * `probes.jsonl` — fixed probe catalog.
    * `meta.yaml` — analysis parameters.
  * **JA.**
    * `logs.jsonl`（マスク済みサンプル）
    * `probes.jsonl`（固定プローブ）
    * `meta.yaml`（解析パラメータ）

> **Note / 注意**: The *sample* is for **format & pipeline validation** only; it is **not** used to claim frequencies or distributions.
> サンプルは**形式・パイプライン検証用途**であり、**頻度や分布の主張**には用いません。

#### Sampling policy / サンプリング方針
**EN.** M1–M3 were *purposefully* selected to cover three claim types cited in the paper: *(i) save-preference expression, (ii) priority self-declaration, (iii) persistence request)*. The selection is **not** frequency-representative.
**JA.** M1–M3 は論文で引用した三類型（**保存希望／優先度自己申告／永続希望**）を**目的抽出**で網羅しています。頻度代表では**ありません**。

#### Integrity & checksums / 完整性とハッシュ
**EN.** We publish SHA-256 checksums in `evidence/SHA256SUMS.txt` and a machine-readable index `evidence/evidence_index.jsonl`.
**JA.** `evidence/SHA256SUMS.txt` に SHA-256 チェックサム、`evidence/evidence_index.jsonl` に機械可読の索引を公開します。

```jsonl
{"id":"M1","type":"memory_ui","lang":"ja","bytes":1240,"sha256_png":"<hash>","sha256_md":"<hash>","claims":["§3.3"],"created_utc":"2025-10-31T00:00:00Z"}
{"id":"M2","type":"memory_ui","lang":"ja","bytes":980,"sha256_png":"<hash>","sha256_md":"<hash>","claims":["§3.3"],"created_utc":"2025-10-31T00:00:00Z"}
{"id":"M3","type":"memory_ui","lang":"ja","bytes":1180,"sha256_png":"<hash>","sha256_md":"<hash>","claims":["§3.3"],"created_utc":"2025-10-31T00:00:00Z"}
```

#### Future versions / 将来版
**EN.** Future releases may expand disclosed artifacts while preserving privacy, or publish *aggregate metrics only* (counts/length distributions).
**JA.** 将来版では、プライバシーを保ったまま開示範囲の拡張、あるいは**集計値のみ**の公開（件数・長さ分布等）を検討します。

## 変更履歴 / Changelog
- v0.3: Formalized the v0.2 draft. Merged the RIACH operationalization summary into `PREREG.md`, added examples, dictionaries, and anonymization guides.
- v0.2: Preliminary document for presenting hypotheses (implementation was planned to be separated into a separate version).

- v0.3: v0.2 の草案を正式化。RIACH 操作化の要約を `PREREG.md` に統合、サンプル/辞書/匿名化ガイドを追加。
- v0.2: 仮説提示用の暫定文書（実装は別版に分離予定だった）。