function alias = set_up_Reg(engine)
% Imports a given registration engine. If no engine is given, a default is used.
% The engine can optionally be returned as an alias (actually a struct).
% e.g., eng=set_up_Reg() enables opening a Nifti ImageData with eng.ImageData
% Caveat: help(eng.ImageData) etc. will work, but help(eng) will not (because eng is just a struct).
% See also set_up_engine and set_up_PET and set_up_Reg

% SyneRBI Synergistic Image Reconstruction Framework (SIRF).
% Copyright 2015 - 2017 Rutherford Appleton Laboratory STFC.
% Copyright 2018 - 2019 University College London.
% 
% This is software developed for the Collaborative Computational
% Project in Synergistic Reconstruction for Biomedical Imaging (formerly CCP PETMR)
% (http://www.ccpsynerbi.ac.uk/).
% 
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
% http://www.apache.org/licenses/LICENSE-2.0
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.

    if nargin == 0 || isempty(engine)
        engine = 'Reg';
    end
    if nargout == 0
        set_up_engine(engine);
    else
        alias = set_up_engine(engine);
    end
end
