function acquisition_data_from_scanner_info(engine)
% A demo showing basics of PET acquisition data handling.

% SyneRBI Synergistic Image Reconstruction Framework (SIRF).
% Copyright 2018 - 2019 Rutherford Appleton Laboratory STFC.
% Copyright 2018 University College London.
% 
% This is software developed for the Collaborative Computational
% Project in Synergistic Reconstruction for Biomedical Imaging (formerly CCP PETMR)
% (http://www.ccpsynerbi.ac.uk/).
% 
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
% http://www.apache.org/licenses/LICENSE-2.0
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.

if nargin < 1
    engine = [];
end
% import_str = set_up_PET(engine);
% eval(import_str)
PET = set_up_PET(engine);

% all acquisition data generated by this script will be stored in memory
% (the input data remain in the input file);
% default storage scheme 'file' keeps all acquisition data generated by
% the script in scratch files deleted after the script terminates
AD = PET.AcquisitionData();
scheme = AD.get_storage_scheme();
AD.set_storage_scheme('memory');
% scheme = AcquisitionData.get_storage_scheme();
% AcquisitionData.set_storage_scheme('memory');

try
    % create acquisition data from scanner parameters
    acq_data = PET.AcquisitionData('Siemens_mMR');
    % set all values to 1.0
    acq_data.fill(1.0);

    % copy the acquisition data into a Python array
    %acq_array = acq_data.as_array();
    acq_dim = acq_data.dimensions();
    fprintf('acquisition data dimensions (maximum resolution):\n')
    fprintf('tang. pos: %d\n', acq_dim(1))
    fprintf('views: %d\n', acq_dim(2))
    fprintf('(non-TOF) sinograms: %d\n', acq_dim(3))
    fprintf('TOF bins: %d\n', acq_dim(4))

    % create acquisition data from scanner parameters but with axial compression etc
    span=11;
    max_ring_diff=-1;
    view_mash_factor=2;
    acq_data = PET.AcquisitionData('Siemens_mMR', span, max_ring_diff, view_mash_factor);
    % copy the acquisition data into a Python array
    %acq_array = acq_data.as_array();
    acq_dim = acq_data.dimensions();
    fprintf('acquisition data dimensions (span 11, view mashing 2):\n')
    fprintf('tang. pos: %d\n', acq_dim(1))
    fprintf('views: %d\n', acq_dim(2))
    fprintf('sinograms: %d\n', acq_dim(3))
    fprintf('TOF bins: %d\n', acq_dim(4))

    % write the acquisition data to a file (commented out for this demo)
    % acq_data.write('example_mMR_ones.hs')

catch err
    % display error information
    fprintf('??? %s\n', err.message)
    fprintf('error id is %s\n', err.identifier)
end
AD.set_storage_scheme(scheme);
%AcquisitionData.set_storage_scheme(scheme);
