/*
SyneRBI Synergistic Image Reconstruction Framework (SIRF)
Copyright 2019 University College London

This is software developed for the Collaborative Computational
Project in Synergistic Reconstruction for Biomedical Imaging (formerly CCP PETMR)
(http://www.ccpsynerbi.ac.uk/).

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

*/

// define some doxygen groups and namespace
// This file does not contain any code

/*! \namespace sirf
  \brief Namespace for the SIRF library (and some/most of its applications)

  This namespace encompasses the whole
  library. All classes, functions and symbols are in this namespace.
  This has the effect that conflicts with any other library is
  impossible (except if that library uses the same namespace...).
*/

/*!
\defgroup Common SIRF common functionality
\ingroup SIRF
All functionality of SIRF common to all engines.
*/

/*!
\defgroup PET SIRF PET
\ingroup SIRF
All PET functionality of SIRF.
*/

/*!
\defgroup MR SIRF MR
\ingroup SIRF
All MR functionality of SIRF.
*/

/*!
\defgroup Registration SIRF registration
\ingroup SIRF
All registration/resampling functionality of SIRF.
*/

/*!
\defgroup Synergistic SIRF synergistic
\ingroup SIRF
All synergistic functionality of SIRF.
*/

/*!
\defgroup CInterface C Interface to C++ Objects
\ingroup SIRF
C Interface to SIRF C++ Objects.
*/

/*!
\defgroup MatlabInterface Matlab interface generator
\ingroup SIRF
Matlab interface generator.
*/

