# Synergistic Image Reconstruction Framework

[![gh-action-badge]][gh-action-link]
<!--
[![coveralls-badge]][coveralls] [![codecov-badge]][codecov] -->
[![style-badge]][style-link]
[![zenodo-badge]][zenodo-link]

This software is the main output of [SyneRBI](https://www.ccpsynerbi.ac.uk), the Collaborative Computational 
Platform for Synergistic Reconstruction for Biomedical Imaging (formerly CCP PETMR).

Please start with our latest [User's Guide](doc/UserGuide.md).

## How to obtain SIRF
There are multiple ways to obtain a binary version of SIRF, please check them out in our documentation page [how to obtain SIRF](https://github.com/SyneRBI/SIRF/wiki/How-to-obtain-SIRF)
or [our Wiki page for installation instructions](https://github.com/SyneRBI/SIRF/wiki/Installation-instructions).

## Where is everything installed?

SIRF largely follows the usual directory structure with some minor tweaks. When using
the default options when building SIRF, you will get (most of the) following, depending
what was found/built:
```
<install-dir>/
    bin/            # executables
    lib/            # libraries
    python/         # Python files
    matlab/         # MATLAB files
    share/SIRF-V.v/ # versioned location (e.g. SIRF-3.0)
       doc/         # doxumentation
          doxygen/  # C++ documentation files generated by doxygen
          examples/ # example scripts
       data/        # data used in example scripts
```

[coveralls-badge]: https://coveralls.io/repos/github/CCPPETMR/SIRF/badge.svg?branch=master
[coveralls]: https://coveralls.io/github/CCPPETMR/SIRF?branch=master
[codecov-badge]: https://codecov.io/gh/SyneRBI/SIRF/branch/master/graph/badge.svg
[codecov]: https://codecov.io/gh/SyneRBI/SIRF
[gh-action-badge]: https://github.com/SyneRBI/SIRF/actions/workflows/build-test.yml/badge.svg
[gh-action-link]: https://github.com/SyneRBI/SIRF/actions/workflows/build-test.yml
[travis-badge]: https://travis-ci.org/SyneRBI/SIRF.svg?branch=master
[travis]: https://travis-ci.org/SyneRBI/SIRF
[style-badge]: https://app.codacy.com/project/badge/Grade/392861b4085f4f438d12c41029f86b47
[style-link]: https://app.codacy.com/gh/SyneRBI/SIRF/dashboard?utm_source=gh&utm_medium=referral&utm_content=&utm_campaign=Badge_grade
[zenodo-badge]: https://zenodo.org/badge/DOI/10.5281/zenodo.2707911.svg
[zenodo-link]: https://doi.org/10.5281/zenodo.2707911
