#!/bin/bash
# this script runs the clustering for the preciously calculated Kennnumber-files

#SPECIFY
TIMEWINDOW=6
NCLUSTERS=4
LOGCWC=True
ALIGN=relative

# Path to the CSV file, SPECIFY, csv file containing all dates for which clustering should be done
INDIR='data_dir'
OUTDIR='outdir'

# Path to the CSV file, SPECIFY, csv file containing all dates for which clustering should be done
CSV_FILE=${OUTDIR}/dates_maxima_minus5.csv
#CSV_FILE="dates_between_minima_maxima.csv"


# Read the CSV file line by line
while IFS=',' read -r YEAR MONTH STARTDAY; do
    # Submit a job for each row
    echo $YEAR $MONTH $STARTDAY

    sbatch 11_TrajectoryClustering.slurm ${TIMEWINDOW}  ${NCLUSTERS} ${LOGCWC} ${ALIGN}  ${YEAR} ${MONTH} ${STARTDAY} ${INDIR} ${OUTDIR}

done < $CSV_FILE
