#!/bin/bash
# author Fiona Fix, 2025 
# this script starts calculation of variables which are used in clustering "Kennnumbers"



# SPECIFY
TIMEWINDOW=6   # for max difference in hamsl
NORTHOF=37     # filter trajectories that never pass north of here


INDIR='data_dir'
OUTDIR='outdir'


# Path to the CSV file, SPECIFY, csv file containing all dates for which clustering should be done
CSV_FILE=${OUTDIR}/dates_maxima_minus5.csv
#CSV_FILE="dates_between_minima_maxima.csv"


# Read the CSV file line by line
while IFS=',' read -r YEAR MONTH STARTDAY; do
    # Submit a job for each row
    echo $YEAR $MONTH $STARTDAY

    sbatch 10_TrajectoryClustering_Kennnumbers.slurm ${TIMEWINDOW} ${NORTHOF} ${YEAR} ${MONTH} ${STARTDAY} ${INDIR} ${OUTDIR}
done < $CSV_FILE
