#!/bin/bash
# author Fiona Fix
module load cdo/2.1.0-gcc-12.2.0-b72jy3p
module load nco/5.0.1-gcc-12.2.0-5yikxow

# SPECIFY  YEAR and MONTHS dor which it should be merged. 
# script is not merging all files at once to keep file size manageable
YEAR=2022
STARTMONTH=5
ENDMONTH=12
LENGTH=120

# SPECIFY location of files 
INDIR=/data/path/

for M in $(seq ${STARTMONTH} ${ENDMONTH}); do
        MONTH=$(printf "%02d" $M)
        infiles=${INDIR}AD_gridded_${YEAR}${MONTH}*_length${LENGTH}tmp.nc
        outfile=${INDIR}AD_gridded_all_${YEAR}${MONTH}_length${LENGTH}.nc
        printf "removing seldate files"
        rm -f ${INDIR}*select*${YEAR}${MONTH}*tmp.nc
        printf "merging gridded files"
        cdo mergetime $infiles $outfile
        printf "removing gridded files, except merge product"
        rm -f ${INDIR}*gridded*${YEAR}${MONTH}*tmp.nc
done

~                                                                                                                                                                                                               
~                  
