#!/bin/bash
# author Fiona Fix


# SPECIFY period for which AD data should be gridded
STARTYEAR=2022
ENDYEAR=2022
STARTMONTH=5
ENDMONTH=5
BLH_THRESHOLD=500   # SPECIFY threshold around BLH for lid detection, +-500m in this case
LENGTH=120          # SPECIFY length of trajectories
OUTDIR='/data_dir/'

# loop through years
for YEAR in $(seq $STARTYEAR $ENDYEAR); do
	# check for leap year
        if (( (YEAR % 4 == 0 && YEAR % 100 != 0) || (YEAR % 400 == 0) )); then
                leap_year=0  # Leap year
        else
                leap_year=1  # Not a leap year
        fi
	# lopo through months
        for MONTH in $(seq $STARTMONTH $ENDMONTH); do
                if [[ ${MONTH} -eq 1 || ${MONTH} -eq 3 || ${MONTH} -eq 5 || ${MONTH} -eq 7 || ${MONTH} -eq 8 || ${MONTH} -eq 10 || ${MONTH} -eq 12 ]]; then
                        days_in_month=31
                elif [[ ${MONTH} -eq 4 || ${MONTH} -eq 6 || ${MONTH} -eq 9 || ${MONTH} -eq 11 ]]; then
                        days_in_month=30
                else
                        # Check for February
                        if [[ $leap_year -eq 0 ]]; then
                                days_in_month=29
                        else
                                days_in_month=28
                        fi
                fi
                # loop through days in month
                for DAY in $(seq 1 $days_in_month); do
                        sbatch --array=0-23 06_grid.slurm ${YEAR} ${MONTH} ${DAY} ${BLH_THRESHOLD} ${LENGTH} ${OUTDIR}
                done
        done
done




