#!/bin/bash
# author: Fiona Fix


# SPECIFY time period over which to calculate gridded AD data, and trajectory length
STARTYEAR=2022
ENDYEAR=2022
STARTMONTH=5
ENDMONTH=5
LENGTH=120
INDIR=/indir/
OUTDIR=/outdir/

# loop over all years
for YEAR in $(seq $STARTYEAR $ENDYEAR); do
	# check leap year
        if (( (YEAR % 4 == 0 && YEAR % 100 != 0) || (YEAR % 400 == 0) )); then
                leap_year=0  # Leap year
        else
                leap_year=1  # Not a leap year
        fi
	# lopp over all months
        for MONTH in $(seq $STARTMONTH $ENDMONTH); do
                if [[ ${MONTH} -eq 1 || ${MONTH} -eq 3 || ${MONTH} -eq 5 || ${MONTH} -eq 7 || ${MONTH} -eq 8 || ${MONTH} -eq 10 || ${MONTH} -eq 12 ]]; then
                        days_in_month=31
                elif [[ ${MONTH} -eq 4 || ${MONTH} -eq 6 || ${MONTH} -eq 9 || ${MONTH} -eq 11 ]]; then
                        days_in_month=30
                else
                        # Check for February
                        if [[ $leap_year -eq 0 ]]; then
                                days_in_month=29
                        else
                                days_in_month=28
                        fi
                fi
                #  loop over all days in month
                for DAY in $(seq 1 $days_in_month); do
                        sbatch --array=0-23 05_seldate.slurm ${YEAR} ${MONTH} ${DAY} ${LENGTH} ${INDIR} ${OUTDIR}
                done
        done
done
