#!/usr/bin/env python
# coding: utf-8
# author: Fiona Fix

##########################################

import netCDF4
import glob
import numpy as np


indir     = '/indir/'    # SPECIFY indir 

##########################################
# ### get list of files to read in
directories        = glob.glob(f"{indir}Lagranto_*")

traj_files  = []
for directory in directories:
    traj_files.extend(glob.glob(directory + '/All_trajtrace_????????_??_corr_new.4'))
traj_files = sorted(traj_files)
print(traj_files)
for f in traj_files:
    print(f)

# ### open every file and add numbering
print("--------------------------------------------------------------")
print("opening every file once to get number of trajectories and to add the traj number to file")
ntraj_total = 0
nmin = 0
nmax = 0
for file in traj_files:
    print(file)
    nc_in       = netCDF4.Dataset(file, mode='r+', format='NETCDF4_CALSSIC')
    ntraj       = nc_in.dimensions["dimx_lon"].size
    nmax        = nmin + ntraj
    if 'traj_number' not in nc_in.variables.keys():
        print('adding traj number variable')
        tmp         = nc_in.createVariable('traj_number',np.int32,("dimx_lon",))
    print('write traj number')
    nc_in['traj_number'][:] = np.arange(nmin,nmax,1)

    ntraj_total = ntraj_total+ntraj
    nc_in.close()
    nmin        = nmax
print(f"number of trajectories in total: {ntraj_total}")


