#!/bin/bash
# calling the slurm script that contains Lagranto calls
# Fiona Fix

########################

datadir='/inputdata_dir/'         # SPECIFY input data dir
script_dir='/script_dir/'         # SPECIFY dir where Lagranto scripts are

# copy necessary files to datadir if they dont exist there yet, SPECIFY if changed
cp  tracevars_short ${datadir}
cp  tracevars_startf ${datadir}
cp  curtain_points ${datadir}

# export variabels correccly:
export LAGRANTO="/lagranto_path/lagranto.era5.test/lagranto.shellscript"   # SPECIFY path to LAGRANTO
export NETCDF="/netcdfpath/netcdf-c-4.9.0"                                 # SPECIFY NETCDf


# SPECIFY 
start_date="20220426"                   # date of first trajectory initialisation
length=120                              # legth of trajectories
hours_no=17664                          # length of the period you want to calculate trajectories for, in hours 
#                                         17664: 2022-04-26 to 2024-04-30


echo "starting Lagranto_job.slurm"
msg=$(sbatch --array=0-${hours_no}%40  ${script_dir}02_Lagranto_job.slurm ${start_date} ${length} ${datadir} ${script_dir})
echo $msg


