/*
    Copyright 2017 Zheyong Fan and GPUMD development team
    This file is part of GPUMD.
    GPUMD is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
    GPUMD is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with GPUMD.  If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

#include "utilities/gpu_macro.cuh"

namespace
{
#define Bohr 0.5291772575069165f
#define Bohr2 0.280028569862541f
#define HartreeBohr6 0.597527426643772f

const int max_elem = 94;
const int max_cn = 5;
const int max_cn2 = 25;
__constant__ int num_cn[max_elem] = {
  2, 1, 2, 3, 5, 5, 4, 3, 2, 1, 2, 3, 4, 5, 4, 3, 2, 1, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 2, 2, 4, 5,
  4, 3, 2, 1, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 4, 5, 4, 3, 2, 1, 2, 3, 3, 1, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 2, 2, 4, 5, 4, 3, 2, 1, 2, 3, 2, 2, 2, 2, 2, 2};

__constant__ float cn_ref[max_cn * max_elem] = {
  0.9118, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000,  0.0000, 0.9865,
  0.0000, 0.0000, 0.0000, 0.0000,  0.9808, 1.9697, 0.0000, 0.0000,  0.0000, 0.9706,  1.9441, 2.9128,
  4.5856, 0.0000, 0.9868, 1.9985,  2.9987, 3.9844, 0.0000, 0.9944,  2.0143, 2.9903,  0.0000, 0.0000,
  0.9925, 1.9887, 0.0000, 0.0000,  0.0000, 0.9982, 0.0000, 0.0000,  0.0000, 0.0000,  0.0000, 0.0000,
  0.0000, 0.0000, 0.0000, 0.9684,  0.0000, 0.0000, 0.0000, 0.0000,  0.9628, 1.9496,  0.0000, 0.0000,
  0.0000, 0.9648, 1.9311, 2.9146,  0.0000, 0.0000, 0.9507, 1.9435,  2.9407, 3.8677,  0.0000, 0.9947,
  2.0102, 2.9859, 0.0000, 0.0000,  0.9948, 1.9903, 0.0000, 0.0000,  0.0000, 0.9972,  0.0000, 0.0000,
  0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0.0000, 0.9767,  0.0000, 0.0000,  0.0000, 0.0000,
  0.9831, 1.9349, 0.0000, 0.0000,  0.0000, 1.8627, 2.8999, 0.0000,  0.0000, 0.0000,  1.8299, 3.8675,
  0.0000, 0.0000, 0.0000, 1.9138,  2.9110, 0.0000, 0.0000, 0.0000,  1.8269, 10.6191, 0.0000, 0.0000,
  0.0000, 1.6406, 9.8849, 0.0000,  0.0000, 0.0000, 1.6483, 9.1376,  0.0000, 0.0000,  0.0000, 1.7149,
  2.9263, 7.7785, 0.0000, 0.0000,  1.7937, 6.5458, 6.2918, 0.0000,  0.0000, 0.9576,  0.0000, 0.0000,
  0.0000, 0.0000, 1.9419, 0.0000,  0.0000, 0.0000, 0.0000, 0.9601,  1.9315, 2.9233,  0.0000, 0.0000,
  0.9434, 1.9447, 2.9186, 3.8972,  0.0000, 0.9889, 1.9793, 2.9709,  0.0000, 0.0000,  0.9901, 1.9812,
  0.0000, 0.0000, 0.0000, 0.9974,  0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000,  0.0000, 0.0000,
  0.0000, 0.9738, 0.0000, 0.0000,  0.0000, 0.0000, 0.9801, 1.9143,  0.0000, 0.0000,  0.0000, 1.9153,
  2.8903, 0.0000, 0.0000, 0.0000,  1.9355, 3.9106, 0.0000, 0.0000,  0.0000, 1.9545,  2.9225, 0.0000,
  0.0000, 0.0000, 1.9420, 11.0556, 0.0000, 0.0000, 0.0000, 1.6682,  9.5402, 0.0000,  0.0000, 0.0000,
  1.8584, 8.8895, 0.0000, 0.0000,  0.0000, 1.9003, 2.9696, 0.0000,  0.0000, 0.0000,  1.8630, 5.7095,
  0.0000, 0.0000, 0.0000, 0.9679,  0.0000, 0.0000, 0.0000, 0.0000,  1.9539, 0.0000,  0.0000, 0.0000,
  0.0000, 0.9633, 1.9378, 2.9353,  0.0000, 0.0000, 0.9514, 1.9505,  2.9259, 3.9123,  0.0000, 0.9749,
  1.9523, 2.9315, 0.0000, 0.0000,  0.9811, 1.9639, 0.0000, 0.0000,  0.0000, 0.9968,  0.0000, 0.0000,
  0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000, 0.0000, 0.9909,  0.0000, 0.0000,  0.0000, 0.0000,
  0.9797, 1.8467, 0.0000, 0.0000,  0.0000, 1.9373, 2.9175, 0.0000,  0.0000, 2.7991,  0.0000, 0.0000,
  0.0000, 0.0000, 0.0000, 2.9425,  0.0000, 0.0000, 0.0000, 0.0000,  2.9455, 0.0000,  0.0000, 0.0000,
  0.0000, 2.9413, 0.0000, 0.0000,  0.0000, 0.0000, 2.9300, 0.0000,  0.0000, 0.0000,  0.0000, 1.8286,
  0.0000, 0.0000, 0.0000, 0.0000,  2.8732, 0.0000, 0.0000, 0.0000,  0.0000, 2.9086,  0.0000, 0.0000,
  0.0000, 0.0000, 2.8965, 0.0000,  0.0000, 0.0000, 0.0000, 2.9242,  0.0000, 0.0000,  0.0000, 0.0000,
  2.9282, 0.0000, 0.0000, 0.0000,  0.0000, 2.9246, 0.0000, 0.0000,  0.0000, 0.0000,  2.8482, 0.0000,
  0.0000, 0.0000, 0.0000, 2.9219,  0.0000, 0.0000, 0.0000, 0.0000,  1.9254, 3.8840,  0.0000, 0.0000,
  0.0000, 1.9459, 2.8988, 0.0000,  0.0000, 0.0000, 1.9292, 10.9153, 0.0000, 0.0000,  0.0000, 1.8104,
  9.8054, 0.0000, 0.0000, 0.0000,  1.8858, 9.1527, 0.0000, 0.0000,  0.0000, 1.8648,  2.9424, 0.0000,
  0.0000, 0.0000, 1.9188, 6.6669,  0.0000, 0.0000, 0.0000, 0.9846,  0.0000, 0.0000,  0.0000, 0.0000,
  1.9896, 0.0000, 0.0000, 0.0000,  0.0000, 0.9267, 1.9302, 2.9420,  0.0000, 0.0000,  0.9383, 1.9356,
  2.9081, 3.9098, 0.0000, 0.9820,  1.9655, 2.9500, 0.0000, 0.0000,  0.9815, 1.9639,  0.0000, 0.0000,
  0.0000, 0.9954, 0.0000, 0.0000,  0.0000, 0.0000, 0.0000, 0.0000,  0.0000, 0.0000,  0.0000, 0.9705,
  0.0000, 0.0000, 0.0000, 0.0000,  0.9662, 1.8075, 0.0000, 0.0000,  0.0000, 2.9070,  0.0000, 0.0000,
  0.0000, 0.0000, 2.8844, 0.0000,  0.0000, 0.0000, 0.0000, 2.8738,  0.0000, 0.0000,  0.0000, 0.0000,
  2.8878, 0.0000, 0.0000, 0.0000,  0.0000, 2.9095, 0.0000, 0.0000,  0.0000, 0.0000,  1.9209, 0.0000,
  0.0000, 0.0000};

__constant__ float r2r4[max_elem] = {
  2.00734898, 1.56637132, 5.01986934, 3.85379032, 3.64446594, 3.10492822, 2.71175247,  2.59361680,
  2.38825250, 2.21522516, 6.58585536, 5.46295967, 5.65216669, 4.88284902, 4.29727576,  4.04108902,
  3.72932356, 3.44677275, 7.97762753, 7.07623947, 6.60844053, 6.28791364, 6.07728703,  5.54643096,
  5.80491167, 5.58415602, 5.41374528, 5.28497229, 5.22592821, 5.09817141, 6.12149689,  5.54083734,
  5.06696878, 4.87005108, 4.59089647, 4.31176304, 9.55461698, 8.67396077, 7.97210197,  7.43439917,
  6.58711862, 6.19536215, 6.01517290, 5.81623410, 5.65710424, 5.52640661, 5.44263305,  5.58285373,
  7.02081898, 6.46815523, 5.98089120, 5.81686657, 5.53321815, 5.25477007, 11.02204549, 10.15679528,
  9.35167836, 9.06926079, 8.97241155, 8.90092807, 8.85984840, 8.81736827, 8.79317710,  7.89969626,
  8.80588454, 8.42439218, 8.54289262, 8.47583370, 8.45090888, 8.47339339, 7.83525634,  8.20702843,
  7.70559063, 7.32755997, 7.03887381, 6.68978720, 6.05450052, 5.88752022, 5.70661499,  5.78450695,
  7.79780729, 7.26443867, 6.78151984, 6.67883169, 6.39024318, 6.09527958, 11.79156076, 11.10997644,
  9.51377795, 8.67197068, 8.77140725, 8.65402716, 8.53923501, 8.85024712};

__constant__ float covalent_radius[max_elem] = {
  0.80628308, 1.15903197, 3.02356173, 2.36845659, 1.94011865, 1.88972601, 1.78894056, 1.58736983,
  1.61256616, 1.68815527, 3.52748848, 3.14954334, 2.84718717, 2.62041997, 2.77159820, 2.57002732,
  2.49443835, 2.41884923, 4.43455700, 3.88023730, 3.35111422, 3.07395437, 3.04875805, 2.77159820,
  2.69600923, 2.62041997, 2.51963467, 2.49443835, 2.54483100, 2.74640188, 2.82199085, 2.74640188,
  2.89757982, 2.77159820, 2.87238349, 2.94797246, 4.76210950, 4.20778980, 3.70386304, 3.50229216,
  3.32591790, 3.12434702, 2.89757982, 2.84718717, 2.84718717, 2.72120556, 2.89757982, 3.09915070,
  3.22513231, 3.17473967, 3.17473967, 3.09915070, 3.32591790, 3.30072128, 5.26603625, 4.43455700,
  4.08180818, 3.70386304, 3.98102289, 3.95582657, 3.93062995, 3.90543362, 3.80464833, 3.82984466,
  3.80464833, 3.77945201, 3.75425569, 3.75425569, 3.72905937, 3.85504098, 3.67866672, 3.45189952,
  3.30072128, 3.09915070, 2.97316878, 2.92277614, 2.79679452, 2.82199085, 2.84718717, 3.32591790,
  3.27552496, 3.27552496, 3.42670319, 3.30072128, 3.47709584, 3.57788113, 5.06446567, 4.56053862,
  4.20778980, 3.98102289, 3.82984466, 3.85504098, 3.88023730, 3.90543362};

const float c6_ref_cpu[111625] = {
  3.0267,    4.7379,    0.0000,    0.0000,    0.0000,    4.7379,    7.5916,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2.0835,    0.0000,
  0.0000,    0.0000,    0.0000,    3.1287,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    38.9448,   14.3165,   0.0000,    0.0000,
  0.0000,    68.9391,   24.0573,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    24.4415,   18.4656,   12.5931,   0.0000,    0.0000,    41.3078,
  30.7866,   20.4039,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    17.3143,   14.7237,   12.4952,   9.7472,    9.2092,    28.2767,   23.8412,   20.0597,
  15.3531,   14.4541,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    12.1402,
  11.3932,   9.4203,    8.8210,    7.3662,    19.2653,   18.0575,   14.7623,   13.7992,   11.3299,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    8.7171,    8.1417,    7.6610,
  6.7746,    0.0000,    13.5164,   12.5980,   11.8214,   10.3987,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    6.7180,    6.0575,    5.3717,    0.0000,    0.0000,
  10.2371,   9.1812,    8.0848,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    5.1616,    4.2672,    0.0000,    0.0000,    0.0000,    7.7441,    6.3000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  4.0112,    0.0000,    0.0000,    0.0000,    0.0000,    5.9403,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    46.8232,   20.7567,
  0.0000,    0.0000,    0.0000,    82.5641,   34.9952,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    38.3531,   31.9913,   21.8370,   0.0000,
  0.0000,    65.3703,   54.1021,   35.9190,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    36.2909,   33.1048,   26.3524,   21.0584,   0.0000,    60.8558,
  55.2636,   43.3661,   34.0700,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    29.5947,   27.4989,   25.7021,   24.9833,   21.0064,   48.5182,   44.9030,   41.8222,
  40.6972,   33.7126,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    23.7604,
  23.0908,   22.7429,   21.2507,   0.0000,    38.1397,   37.0236,   36.4936,   33.9193,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    20.0948,   19.8667,   19.4729,
  0.0000,    0.0000,    31.7713,   31.4127,   30.7747,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    16.7052,   16.5273,   0.0000,    0.0000,    0.0000,
  26.0170,   25.7414,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    13.8700,   0.0000,    0.0000,    0.0000,    0.0000,    21.3055,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  76.2376,   29.3000,   0.0000,    0.0000,    0.0000,    134.4441,  48.4499,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    65.8180,   52.9871,
  30.6783,   0.0000,    0.0000,    113.4857,  90.7927,   50.2368,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    54.9669,   29.9953,   29.8615,   0.0000,
  0.0000,    94.2083,   48.9753,   48.4929,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    53.6875,   29.0009,   30.2593,   0.0000,    0.0000,    91.3334,
  47.2755,   49.0983,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    49.4819,   28.4067,   27.6880,   0.0000,    0.0000,    83.8313,   46.3089,   44.8842,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    39.1221,
  28.0562,   21.3134,   0.0000,    0.0000,    65.9837,   45.8173,   33.9427,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    43.0028,   26.1810,   18.4694,
  0.0000,    0.0000,    72.4111,   42.3927,   29.1208,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    33.9110,   24.3452,   18.0977,   0.0000,    0.0000,
  56.7993,   39.2742,   28.5665,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    36.3234,   23.2310,   20.7741,   18.7500,   0.0000,    60.5746,   37.4496,
  33.3307,   29.7680,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  37.1596,   22.6822,   19.4648,   20.1853,   0.0000,    62.2532,   36.5901,   31.0981,   32.5149,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    28.5940,   22.1550,
  0.0000,    0.0000,    0.0000,    47.6499,   35.9871,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    29.8689,   21.2139,   0.0000,    0.0000,
  0.0000,    49.3469,   34.0312,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    35.1697,   33.2515,   26.9562,   22.5390,   0.0000,    58.4207,
  54.9919,   43.8881,   36.1447,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    31.8170,   29.9527,   28.6359,   25.9255,   23.1784,   51.9905,   48.7247,   46.4409,
  41.7323,   36.9664,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    27.7884,
  27.3574,   26.7042,   25.8144,   0.0000,    44.6512,   43.9067,   42.7789,   41.2434,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    25.3098,   25.3149,   25.1268,
  0.0000,    0.0000,    40.2010,   40.2117,   39.8967,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    22.4834,   22.6230,   0.0000,    0.0000,    0.0000,
  35.2740,   35.5123,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    19.8182,   0.0000,    0.0000,    0.0000,    0.0000,    30.7261,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  85.9499,   35.1963,   0.0000,    0.0000,    0.0000,    150.9340,  57.9039,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    78.3901,   64.4065,
  36.8606,   0.0000,    0.0000,    135.0664,  110.3275,  60.1892,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    70.0570,   51.2356,   36.0543,   0.0000,
  0.0000,    119.2961,  85.6815,   58.2755,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    63.7801,   39.6669,   36.5405,   0.0000,    0.0000,    107.7306,
  64.7068,   58.8625,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    58.6768,   40.0304,   35.3152,   0.0000,    0.0000,    98.5183,   65.3129,   56.8466,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    46.0406,
  37.5478,   31.6681,   0.0000,    0.0000,    76.3661,   60.9773,   50.4173,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    51.0527,   41.3385,   28.2627,
  0.0000,    0.0000,    85.0800,   67.8924,   44.5963,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    39.5745,   33.1875,   26.8142,   0.0000,    0.0000,
  65.0863,   53.3648,   42.1627,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    43.1661,   31.1024,   26.9803,   0.0000,    0.0000,    71.1985,   49.9090,
  42.7714,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  40.2372,   28.9661,   28.0631,   0.0000,    0.0000,    66.1211,   46.3489,   44.6498,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    33.5413,   27.9518,
  0.0000,    0.0000,    0.0000,    54.9658,   44.7835,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    35.6879,   27.9281,   0.0000,    0.0000,
  0.0000,    58.3568,   44.5006,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    44.0417,   42.2827,   34.8931,   30.3193,   0.0000,    72.9076,
  69.6754,   56.5189,   48.4270,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    41.5334,   39.0500,   37.9122,   34.5503,   31.6020,   67.9430,   63.5189,   61.4868,
  55.5643,   50.3940,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    37.7681,
  37.1186,   36.2277,   35.0939,   0.0000,    60.9470,   59.7796,   58.1962,   56.1946,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    35.4841,   35.4861,   35.2461,
  0.0000,    0.0000,    56.7427,   56.7156,   56.2769,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    32.5171,   32.8151,   0.0000,    0.0000,    0.0000,
  51.4656,   51.9496,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    29.6055,   0.0000,    0.0000,    0.0000,    0.0000,    46.3794,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  105.0096,  42.3058,   0.0000,    0.0000,    0.0000,    184.0223,  68.9537,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    99.4579,   83.0141,
  44.8321,   0.0000,    0.0000,    171.7033,  142.5680,  72.9013,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    89.1018,   64.6906,   46.8202,   0.0000,
  0.0000,    152.1106,  108.3059,  75.8394,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    44.5104,   0.0000,    0.0000,    0.0000,    0.0000,    71.8830,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    88.6877,   43.2202,   0.0000,    0.0000,    0.0000,    152.4502,  69.7341,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    85.4080,
  42.3343,   0.0000,    0.0000,    0.0000,    146.5851,  68.2931,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    83.3310,   41.0356,   0.0000,
  0.0000,    0.0000,    142.9620,  66.1439,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    81.4123,   41.1186,   0.0000,    0.0000,    0.0000,
  139.6254,  66.4057,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    79.7138,   39.2564,   0.0000,    0.0000,    0.0000,    136.6695,  63.7629,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  64.1880,   41.3275,   0.0000,    0.0000,    0.0000,    108.3662,  66.8235,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    70.1794,   38.9150,
  0.0000,    0.0000,    0.0000,    120.4056,  62.7971,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    67.9580,   39.3967,   0.0000,    0.0000,
  0.0000,    116.3178,  63.7816,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    72.2203,   37.0295,   0.0000,    0.0000,    0.0000,    123.5220,
  59.6586,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    70.7154,   36.0084,   0.0000,    0.0000,    0.0000,    120.9302,  57.9760,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    69.3791,
  35.7480,   0.0000,    0.0000,    0.0000,    118.6070,  57.5937,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    68.4949,   37.3986,   0.0000,
  0.0000,    0.0000,    117.1811,  60.4871,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    58.6519,   34.6012,   0.0000,    0.0000,    0.0000,
  99.2984,   55.7008,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    58.8504,   45.3466,   35.2195,   0.0000,    0.0000,    98.5136,   74.6292,
  56.4513,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  54.4015,   42.5991,   36.5951,   0.0000,    0.0000,    90.2858,   69.5172,   58.8038,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    46.4813,   39.3530,
  34.4352,   0.0000,    0.0000,    76.4150,   63.6550,   54.7934,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    47.4814,   39.3902,   31.5928,   0.0000,
  0.0000,    77.8793,   64.1643,   49.8616,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    43.5027,   35.4646,   29.9597,   0.0000,    0.0000,    70.8024,
  56.6567,   46.9793,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    40.1928,   33.5117,   30.2294,   0.0000,    0.0000,    64.9890,   53.3255,   47.7107,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    33.7374,
  32.0917,   31.7368,   0.0000,    0.0000,    54.0451,   50.9366,   50.1899,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    31.6431,   30.6757,   0.0000,
  0.0000,    0.0000,    50.5086,   48.6478,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    32.6475,   29.9203,   0.0000,    0.0000,    0.0000,
  52.0547,   47.1662,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    45.5659,   45.6578,   37.6407,   34.0440,   0.0000,    74.8817,   74.8265,
  60.4792,   54.1121,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  45.1786,   42.4340,   39.7922,   39.2018,   36.7836,   73.6692,   68.7009,   63.9796,   62.8530,
  58.5875,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    42.2419,   41.5964,
  40.7649,   39.7438,   0.0000,    68.1031,   66.8857,   65.3536,   63.4976,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    40.7106,   40.7840,   40.6835,   0.0000,
  0.0000,    65.1605,   65.2146,   64.9760,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    38.0468,   38.5121,   0.0000,    0.0000,    0.0000,    60.3338,
  61.0757,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    35.2750,   0.0000,    0.0000,    0.0000,    0.0000,    55.4345,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    100.7494,
  47.7016,   0.0000,    0.0000,    0.0000,    174.9212,  77.7055,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    99.4131,   83.6090,   49.4359,
  0.0000,    0.0000,    170.5082,  142.5589,  80.3048,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    89.4060,   51.1073,   0.0000,    0.0000,    0.0000,
  151.8139,  82.5273,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    82.0836,   58.0420,   0.0000,    0.0000,    0.0000,    137.4724,  94.6418,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  80.7260,   52.2645,   0.0000,    0.0000,    0.0000,    135.8701,  84.7238,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    78.2034,   46.7559,
  0.0000,    0.0000,    0.0000,    131.5644,  75.2066,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    79.4391,   45.1236,   0.0000,    0.0000,
  0.0000,    134.7304,  72.4272,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    77.1021,   52.3919,   0.0000,    0.0000,    0.0000,    130.5946,
  86.0052,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1.5583,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    22.1508,
  8.7773,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    14.8246,   11.4655,   8.1628,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    11.0975,   9.5836,    8.2586,    6.6434,    6.3181,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    8.1841,    7.7065,    6.5027,    6.1196,    5.2567,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  6.1380,    5.7601,    5.4559,    4.8836,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4.8949,    4.4593,
  4.0179,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3.8825,    3.3077,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3.1025,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    26.8628,   12.7287,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    23.0320,
  19.4648,   13.8496,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    22.3224,   20.5158,   16.7031,
  13.6982,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    18.8500,   17.6356,   16.5806,   16.1104,   13.8547,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    15.6689,   15.2619,   15.0245,   14.1577,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  13.6108,   13.4598,   13.2090,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    11.6302,   11.5092,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    9.9130,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    44.0411,   18.6655,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    39.0701,   31.8796,   19.7247,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    32.8995,
  19.3841,   19.4304,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    32.5316,   18.8084,   19.7205,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    30.1851,   18.4359,   18.1127,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    24.1463,   18.1754,   14.4051,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  26.4978,   17.1526,   12.6985,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    21.1750,   16.0560,
  12.4277,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    22.7233,   15.3545,   13.8804,   12.7523,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    23.0792,   14.9833,   13.0979,   13.4305,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    18.0216,   14.5147,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    18.9695,
  14.1185,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    22.0458,   20.9874,   17.4392,
  14.9296,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    20.4318,   19.3761,   18.6186,   17.0614,   15.4801,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    18.3284,   18.0816,   17.7051,   17.1900,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  17.0243,   17.0280,   16.9157,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    15.4553,   15.5387,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    13.9211,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    50.0491,   22.6231,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    46.6658,   38.8333,   23.8401,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    42.4195,
  31.9889,   23.6462,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    39.1088,   25.7037,   24.0883,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    36.3418,   25.9534,   23.3592,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    29.1617,   24.5530,   21.3516,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  32.0588,   26.6217,   19.3556,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    25.4622,   22.0616,
  18.4864,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    27.5745,   20.7776,   18.4026,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    25.8716,   19.4689,   19.0208,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    21.7896,   18.7731,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    23.1563,
  18.8607,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    27.9586,   27.0236,   22.9076,
  20.3402,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    26.7862,   25.4105,   24.7833,   22.8875,   21.2154,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    24.8583,   24.5068,   24.0141,   23.3792,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  23.6911,   23.7100,   23.5851,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    22.0813,   22.2717,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    20.4594,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    61.3184,   27.4695,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    59.1141,   49.9232,   29.1864,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    53.7982,
  40.3329,   30.5886,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    29.3081,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    53.1523,   28.5060,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    51.2952,   27.9324,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  50.0748,   27.1150,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    48.9406,   27.0910,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    47.9365,   25.6913,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    39.5786,   27.1595,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    42.3679,   25.6695,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    41.1622,
  25.8658,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    43.5711,   24.4806,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    42.6658,   23.8289,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    41.8727,   23.6297,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  41.2866,   24.5435,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    35.9516,   22.8926,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    36.5749,   28.9986,   23.4106,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    34.2834,   27.6208,   24.2814,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    29.8206,   25.8916,   23.2301,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    30.5492,
  25.6614,   21.6210,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    28.3546,   23.8125,   20.7321,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    26.4936,   22.6779,   20.7608,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    22.6550,   21.8338,   21.7064,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  21.4057,   20.9410,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    22.0837,   20.5852,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    29.3832,   29.5289,   25.0875,   23.0696,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    29.3963,   27.9073,   26.4467,   26.1542,   24.7926,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    27.9329,   27.6093,   27.1746,   26.6278,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    27.2118,
  27.2927,   27.2690,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    25.8071,   26.1111,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    24.2886,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    59.6594,   30.9827,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  59.6740,   50.7965,   32.2205,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    54.4613,   33.6398,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    51.1103,   37.7171,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    50.0052,   34.3329,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    48.4980,   31.0746,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    48.7241,
  30.0978,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    47.3798,   33.8615,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1163.4454, 282.2106,  0.0000,    0.0000,    0.0000,
  282.2106,  85.3197,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    494.6190,  352.2160,  194.7036,  0.0000,    0.0000,    148.1323,  107.5083,
  66.2009,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  283.7308,  231.4209,  188.7611,  129.9875,  120.6628,  93.6729,   77.6633,   64.2553,   47.0338,
  43.9746,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    169.9030,  160.4590,
  123.7707,  115.9498,  87.8183,   60.0860,   56.3468,   44.9320,   41.9713,   33.2158,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    108.4854,  101.2701,  94.0060,   81.9770,
  0.0000,    40.2944,   37.4939,   35.0194,   30.6022,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    76.9613,   67.9312,   58.6703,   0.0000,    0.0000,    29.5575,
  26.2708,   22.8930,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    55.0933,   42.0627,   0.0000,    0.0000,    0.0000,    21.7605,   17.1733,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    40.4731,
  0.0000,    0.0000,    0.0000,    0.0000,    16.3388,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1367.3272, 425.7161,  0.0000,
  0.0000,    0.0000,    335.3450,  125.8245,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    830.8156,  670.0330,  370.8190,  0.0000,    0.0000,
  240.1627,  195.7057,  120.7808,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    705.8254,  627.5309,  456.3613,  322.7925,  0.0000,    214.7265,  193.0707,
  146.4426,  110.2136,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  495.3449,  450.9583,  412.4323,  408.0802,  308.7953,  162.0508,  148.7478,  137.4458,  134.4490,
  107.2721,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    350.8030,  339.6693,
  337.4662,  304.7707,  0.0000,    121.5067,  117.7472,  116.3941,  106.8466,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    273.7867,  271.3011,  265.5464,  0.0000,
  0.0000,    98.1249,   97.0849,   95.0531,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    210.6626,  208.7743,  0.0000,    0.0000,    0.0000,    77.9865,
  77.2023,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    163.5497,  0.0000,    0.0000,    0.0000,    0.0000,    62.2205,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2387.1574,
  560.2954,  0.0000,    0.0000,    0.0000,    555.1516,  168.7412,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1614.4719, 1310.0314, 525.3196,
  0.0000,    0.0000,    434.1576,  345.6120,  168.9009,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1278.1183, 504.8268,  481.9586,  0.0000,    0.0000,
  354.0317,  163.6446,  159.5715,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1192.9128, 488.2931,  486.2098,  0.0000,    0.0000,    337.3896,  157.6667,
  161.3013,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1069.0426, 479.1402,  448.2923,  0.0000,    0.0000,    306.5482,  154.5762,  147.6410,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    844.0936,  480.5944,
  314.2807,  0.0000,    0.0000,    240.5033,  153.7539,  107.7527,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    891.9756,  416.0836,  256.5689,  0.0000,
  0.0000,    260.9019,  138.7491,  90.4231,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    698.4539,  379.2117,  253.2432,  0.0000,    0.0000,    203.6149,
  127.5492,  88.9538,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    701.5324,  362.3746,  319.8448,  270.7598,  0.0000,    212.8978,  121.6037,  107.5582,
  93.8356,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    738.8580,
  355.9606,  291.0488,  320.6585,  0.0000,    221.1739,  119.0725,  99.3454,   106.1545,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    569.4526,  367.4308,  0.0000,
  0.0000,    0.0000,    168.8075,  119.4397,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    540.9160,  317.8826,  0.0000,    0.0000,    0.0000,
  169.4949,  109.0127,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    656.7441,  602.8104,  441.4888,  332.3464,  0.0000,    202.6900,  188.7622,
  145.1043,  115.1284,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  527.9268,  484.0165,  454.1125,  392.4109,  330.5666,  172.9425,  160.4502,  151.8759,  134.1408,
  116.2577,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    415.1532,  406.3427,
  392.4365,  373.0901,  0.0000,    142.8471,  140.1353,  135.9832,  130.3034,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    354.5429,  355.0450,  351.8104,  0.0000,
  0.0000,    125.4768,  125.5564,  124.4868,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    294.7897,  297.6835,  0.0000,    0.0000,    0.0000,    107.3380,
  108.2048,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    244.5554,  0.0000,    0.0000,    0.0000,    0.0000,    91.3333,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2647.3331,
  657.4076,  0.0000,    0.0000,    0.0000,    618.5681,  199.6771,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1944.2260, 1618.2465, 628.2399,
  0.0000,    0.0000,    517.8393,  421.4610,  201.6900,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1585.3950, 1074.5875, 567.3202,  0.0000,    0.0000,
  442.9448,  306.8862,  189.8894,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1363.2842, 678.4810,  562.1583,  0.0000,    0.0000,    391.9179,  216.7170,
  190.2283,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1209.0304, 684.1040,  549.6114,  0.0000,    0.0000,    353.5008,  218.9706,  184.1222,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    890.5126,  628.1817,
  461.5751,  0.0000,    0.0000,    267.3761,  202.5173,  159.4404,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1011.6099, 763.7814,  391.4255,  0.0000,
  0.0000,    300.6533,  232.9539,  138.3613,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    730.5533,  517.3330,  364.4102,  0.0000,    0.0000,    223.8871,
  172.9708,  129.8907,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    794.2006,  482.4342,  390.2766,  0.0000,    0.0000,    245.2561,  161.3499,  134.6931,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    722.4294,
  443.9106,  412.2171,  0.0000,    0.0000,    225.8042,  149.1209,  141.5639,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    614.1477,  432.6078,  0.0000,
  0.0000,    0.0000,    188.3374,  144.6563,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    621.0536,  408.4429,  0.0000,    0.0000,    0.0000,
  197.0940,  141.0901,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    828.9673,  769.2514,  565.2654,  444.6978,  0.0000,    253.1370,  239.0419,
  185.9170,  153.8264,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  708.4597,  642.4190,  611.5612,  527.1851,  455.9199,  228.0814,  210.3815,  202.2053,  179.0706,
  159.1376,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    586.6888,  569.5020,
  546.8547,  518.6427,  0.0000,    197.7698,  193.0801,  186.8353,  179.0274,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    521.2511,  519.4518,  512.7164,  0.0000,
  0.0000,    180.3056,  179.9812,  178.1745,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    449.8512,  454.3954,  0.0000,    0.0000,    0.0000,    159.8670,
  161.4303,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    386.9969,  0.0000,    0.0000,    0.0000,    0.0000,    140.9818,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3242.2404,
  732.9120,  0.0000,    0.0000,    0.0000,    752.3418,  231.4165,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2551.5260, 2180.4015, 750.3227,
  0.0000,    0.0000,    664.5719,  551.0792,  242.2872,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2085.0661, 1384.1283, 748.9052,  0.0000,    0.0000,
  570.4266,  389.9070,  248.4867,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    704.3345,  0.0000,    0.0000,    0.0000,    0.0000,    234.5271,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2210.3168, 680.2479,  0.0000,    0.0000,    0.0000,    583.9797,  227.0579,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2091.5068, 665.5329,
  0.0000,    0.0000,    0.0000,    558.6972,  222.2883,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2031.2740, 642.1808,  0.0000,    0.0000,
  0.0000,    544.1232,  214.9157,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1976.6955, 653.7125,  0.0000,    0.0000,    0.0000,    530.7909,
  216.8695,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1928.0810, 653.6846,  0.0000,    0.0000,    0.0000,    518.9498,  211.7400,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1407.7335,
  659.0924,  0.0000,    0.0000,    0.0000,    396.7223,  218.6195,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1802.3852, 612.8166,  0.0000,
  0.0000,    0.0000,    463.5442,  204.5514,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1720.7353, 638.4850,  0.0000,    0.0000,    0.0000,
  445.0101,  209.6685,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1704.9679, 575.7499,  0.0000,    0.0000,    0.0000,    465.4100,  193.4738,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1664.7700, 557.2454,  0.0000,    0.0000,    0.0000,    455.2827,  187.7050,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1627.0951, 555.2598,
  0.0000,    0.0000,    0.0000,    446.0030,  186.7210,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1612.7581, 592.3651,  0.0000,    0.0000,
  0.0000,    441.3220,  197.5946,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1294.7583, 533.4581,  0.0000,    0.0000,    0.0000,    364.7467,
  180.1292,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1177.2268, 833.4475,  525.3124,  0.0000,    0.0000,    350.0617,  255.9208,  180.3567,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1027.3577,
  738.8089,  566.1059,  0.0000,    0.0000,    314.2483,  233.6075,  189.8611,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    842.4123,  642.2239,  499.4807,
  0.0000,    0.0000,    261.3833,  209.4301,  172.9883,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    840.3029,  677.9021,  437.5796,  0.0000,    0.0000,
  264.3697,  215.0782,  154.7098,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    731.9234,  530.6603,  399.4623,  0.0000,    0.0000,    236.0258,  180.8322,
  143.7193,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  649.2225,  491.4721,  426.3638,  0.0000,    0.0000,    213.4644,  168.9331,  148.7741,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    523.2922,  465.2011,
  448.1737,  0.0000,    0.0000,    174.6132,  160.6472,  156.8327,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    482.7120,  446.1908,  0.0000,    0.0000,
  0.0000,    162.1342,  153.5237,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    487.4020,  413.1061,  0.0000,    0.0000,    0.0000,    166.0489,
  146.2575,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    841.5620,  818.9371,  584.8796,  489.8797,  0.0000,    257.3823,  254.7991,  195.8113,
  170.5218,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    770.4985,
  688.0756,  614.8841,  592.3075,  531.2245,  246.8355,  226.0586,  206.9127,  201.7030,  184.9914,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    661.5278,  639.1391,  613.1828,
  583.2198,  0.0000,    221.4325,  215.9908,  209.4372,  201.7042,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    607.3151,  603.7828,  597.0483,  0.0000,    0.0000,
  208.1269,  207.7296,  206.3143,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    535.6521,  541.7823,  0.0000,    0.0000,    0.0000,    188.6073,  190.8807,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  471.2994,  0.0000,    0.0000,    0.0000,    0.0000,    169.8943,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2894.5966, 821.2898,
  0.0000,    0.0000,    0.0000,    697.6449,  260.2443,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2434.0697, 2063.7836, 822.1500,  0.0000,
  0.0000,    649.0325,  539.8661,  266.2038,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2008.2591, 806.0243,  0.0000,    0.0000,    0.0000,    561.3519,
  268.9814,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1672.4768, 1008.8719, 0.0000,    0.0000,    0.0000,    491.0777,  317.8125,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1730.6038,
  890.7015,  0.0000,    0.0000,    0.0000,    493.4651,  281.4599,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1671.6156, 731.9805,  0.0000,
  0.0000,    0.0000,    477.4254,  244.0301,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1800.5066, 695.0128,  0.0000,    0.0000,    0.0000,
  499.5202,  233.7727,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1727.8140, 977.2027,  0.0000,    0.0000,    0.0000,    482.3466,  295.6875,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  257.4863,  186.3453,  113.9677,  0.0000,    0.0000,    186.3453,  135.8445,  84.4000,   0.0000,
  0.0000,    113.9677,  84.4000,   55.1364,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    161.5971,  133.7265,
  110.4185,  80.4276,   75.1311,   119.0815,  98.9938,   82.1430,   60.5234,   56.6527,   76.7230,
  64.4301,   53.9919,   40.9358,   38.4745,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    102.9560,  96.5431,   76.7552,   71.6818,
  56.4662,   77.0951,   72.3162,   57.8805,   54.0770,   43.0620,   51.5628,   48.3072,   39.2814,
  36.6977,   29.8819,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    68.6458,   63.8580,   59.5983,   52.0237,   0.0000,    52.0852,
  48.4885,   45.3164,   39.6478,   0.0000,    35.7902,   33.3274,   31.2407,   27.4225,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    50.1252,   44.4968,   38.7027,   0.0000,    0.0000,    38.4132,   34.1983,   29.8523,
  0.0000,    0.0000,    26.8954,   24.0592,   21.1282,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    36.7453,
  28.8615,   0.0000,    0.0000,    0.0000,    28.4098,   22.5413,   0.0000,    0.0000,    0.0000,
  20.2083,   16.3185,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    27.4867,   0.0000,    0.0000,
  0.0000,    0.0000,    21.4067,   0.0000,    0.0000,    0.0000,    0.0000,    15.4176,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    587.4563,  218.6572,  0.0000,    0.0000,    0.0000,
  418.6488,  158.3268,  0.0000,    0.0000,    0.0000,    232.8060,  96.5125,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    418.2164,  340.2602,  208.6769,  0.0000,    0.0000,    301.3777,  246.2227,
  153.1575,  0.0000,    0.0000,    181.1653,  149.3832,  97.8101,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  372.6302,  334.7335,  253.0649,  189.6605,  0.0000,    270.7461,  243.7612,  185.7310,  140.5632,
  0.0000,    167.2929,  151.5931,  118.1233,  92.0126,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    279.7863,  256.5881,
  236.8991,  231.8251,  184.2566,  205.7544,  189.1090,  174.9315,  171.0398,  137.1783,  131.8920,
  121.8333,  113.2820,  110.3134,  90.6956,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    208.7331,  202.2282,  199.9576,  183.3056,
  0.0000,    155.3644,  150.6068,  148.8194,  136.8674,  0.0000,    102.6176,  99.5656,   98.1859,
  91.0206,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    167.9513,  166.1807,  162.6875,  0.0000,    0.0000,    126.0993,
  124.7512,  122.1534,  0.0000,    0.0000,    84.8691,   83.9181,   82.1973,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    132.9808,  131.6498,  0.0000,    0.0000,    0.0000,    100.7212,  99.6995,   0.0000,
  0.0000,    0.0000,    69.0069,   68.2806,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    105.7229,
  0.0000,    0.0000,    0.0000,    0.0000,    80.7174,   0.0000,    0.0000,    0.0000,    0.0000,
  56.1517,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    972.3197,  292.2224,  0.0000,
  0.0000,    0.0000,    694.8596,  213.4444,  0.0000,    0.0000,    0.0000,    379.4225,  132.4751,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    757.9070,  602.5661,  291.7021,  0.0000,    0.0000,
  543.5842,  434.0284,  214.3171,  0.0000,    0.0000,    316.5102,  252.5778,  136.5998,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    617.3358,  282.4420,  275.0061,  0.0000,    0.0000,    443.7190,  207.8107,
  203.0678,  0.0000,    0.0000,    261.9443,  132.9868,  131.2980,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  587.4898,  272.0201,  277.9371,  0.0000,    0.0000,    423.6217,  200.3669,  205.3134,  0.0000,
  0.0000,    253.0543,  128.2862,  132.8881,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    533.3499,  266.7050,
  254.3767,  0.0000,    0.0000,    385.2754,  196.4027,  187.9531,  0.0000,    0.0000,    231.8065,
  125.6778,  121.4601,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    418.1635,  265.4088,  184.9079,  0.0000,
  0.0000,    302.6061,  195.2317,  137.8919,  0.0000,    0.0000,    182.1558,  124.4645,  91.0985,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    453.3686,  238.9606,  154.7687,  0.0000,    0.0000,    328.4012,
  176.6817,  116.1032,  0.0000,    0.0000,    199.6426,  114.6465,  77.7823,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    353.5358,  219.4775,  152.2986,  0.0000,    0.0000,    256.6043,  162.6108,  114.1613,
  0.0000,    0.0000,    156.2845,  106.0286,  76.3494,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    369.1928,
  209.2227,  184.8938,  160.8870,  0.0000,    268.6284,  155.0554,  137.2998,  120.1880,  0.0000,
  166.2166,  101.0801,  89.7891,   79.7845,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    383.9140,  204.9086,  170.5936,
  182.6955,  0.0000,    278.7116,  151.7798,  126.9812,  135.2702,  0.0000,    171.2043,  98.8004,
  83.6030,   87.7852,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    292.7955,  205.9313,  0.0000,    0.0000,    0.0000,
  212.9797,  151.8426,  0.0000,    0.0000,    0.0000,    130.8012,  97.5340,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    293.3106,  187.3012,  0.0000,    0.0000,    0.0000,    214.4256,  139.2420,
  0.0000,    0.0000,    0.0000,    134.7933,  91.6227,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  351.1141,  326.6672,  250.1889,  197.7454,  0.0000,    256.2049,  238.9068,  184.5744,  147.1923,
  0.0000,    159.9273,  150.2148,  118.9619,  97.2346,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    298.4220,  276.5717,
  261.6034,  230.6287,  199.4034,  219.7375,  204.1690,  193.4457,  171.2891,  148.9411,  141.1489,
  131.9934,  125.6209,  112.4708,  99.1700,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    245.4831,  240.7559,  233.5151,  223.6099,
  0.0000,    182.5338,  179.1390,  173.9415,  166.8295,  0.0000,    120.2224,  118.1520,  115.0137,
  110.7405,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    215.0238,  215.1671,  213.3149,  0.0000,    0.0000,    160.9687,
  161.0637,  159.7099,  0.0000,    0.0000,    107.6371,  107.6713,  106.8086,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    183.3742,  184.8832,  0.0000,    0.0000,    0.0000,    138.2747,  139.3617,  0.0000,
  0.0000,    0.0000,    93.8911,   94.5515,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    155.5616,
  0.0000,    0.0000,    0.0000,    0.0000,    118.1240,  0.0000,    0.0000,    0.0000,    0.0000,
  81.3306,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1082.7052, 345.4378,  0.0000,
  0.0000,    0.0000,    774.9656,  252.9574,  0.0000,    0.0000,    0.0000,    425.1704,  157.9479,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    903.9265,  734.7926,  348.1690,  0.0000,    0.0000,
  648.6422,  529.5494,  256.1295,  0.0000,    0.0000,    376.6468,  306.9433,  163.4621,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    771.4844,  532.5110,  326.9186,  0.0000,    0.0000,    556.1503,  387.6564,
  242.0080,  0.0000,    0.0000,    330.7190,  235.5232,  157.4277,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  681.5283,  374.0135,  327.2192,  0.0000,    0.0000,    493.0100,  275.3644,  242.7264,  0.0000,
  0.0000,    297.4750,  175.6564,  158.7442,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    613.9850,  377.9693,
  316.7162,  0.0000,    0.0000,    445.3736,  278.0881,  234.9568,  0.0000,    0.0000,    271.2606,
  177.3357,  153.2948,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    463.3065,  349.1897,  273.5446,  0.0000,
  0.0000,    337.9035,  257.6088,  204.1519,  0.0000,    0.0000,    209.0959,  165.2066,  135.2428,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    521.4249,  402.7727,  236.8457,  0.0000,    0.0000,    379.5254,
  295.3816,  177.6837,  0.0000,    0.0000,    233.4606,  185.0244,  119.1206,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    387.2681,  297.5186,  222.1489,  0.0000,    0.0000,    283.5695,  220.6746,  166.9872,
  0.0000,    0.0000,    177.5174,  143.8851,  112.4391,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    424.4120,
  277.4174,  230.8996,  0.0000,    0.0000,    310.3781,  205.9530,  172.6021,  0.0000,    0.0000,
  194.3984,  134.4576,  114.5587,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    390.4310,  256.2327,  242.8825,
  0.0000,    0.0000,    286.0395,  190.4826,  181.1811,  0.0000,    0.0000,    180.2178,  124.7151,
  119.7960,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    325.5775,  248.6573,  0.0000,    0.0000,    0.0000,
  238.6962,  184.6530,  0.0000,    0.0000,    0.0000,    149.7198,  120.5975,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    340.4122,  242.0950,  0.0000,    0.0000,    0.0000,    249.9915,  180.5207,
  0.0000,    0.0000,    0.0000,    158.6937,  119.4623,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  438.3396,  413.4965,  320.2807,  264.0439,  0.0000,    320.0912,  302.6678,  236.6771,  196.7454,
  0.0000,    199.4111,  190.1313,  152.9239,  130.1139,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    393.7991,  362.7434,
  348.3949,  307.8814,  273.0046,  289.4713,  267.5036,  257.3551,  228.5584,  203.7227,  184.6849,
  172.1767,  166.4248,  149.7680,  135.2605,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    340.3030,  332.0665,  321.1170,  307.4421,
  0.0000,    252.1649,  246.3580,  238.6037,  228.8894,  0.0000,    164.5348,  161.2234,  156.7541,
  151.1215,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    309.5439,  308.9426,  305.7629,  0.0000,    0.0000,    230.6309,
  230.2641,  228.0340,  0.0000,    0.0000,    152.4956,  152.3806,  151.1275,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    273.7398,  276.4309,  0.0000,    0.0000,    0.0000,    205.2237,  207.2185,  0.0000,
  0.0000,    0.0000,    137.6192,  138.9273,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    240.7689,
  0.0000,    0.0000,    0.0000,    0.0000,    181.6260,  0.0000,    0.0000,    0.0000,    0.0000,
  123.4070,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1316.2189, 399.4020,  0.0000,
  0.0000,    0.0000,    943.8547,  294.1459,  0.0000,    0.0000,    0.0000,    517.8726,  187.1318,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1160.4419, 961.1049,  417.8652,  0.0000,    0.0000,
  832.6251,  692.8415,  308.1410,  0.0000,    0.0000,    479.3661,  397.2194,  197.5839,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    994.0316,  676.7374,  428.0498,  0.0000,    0.0000,    716.0758,  492.5824,
  316.4815,  0.0000,    0.0000,    422.2754,  297.9018,  205.0850,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  403.7427,  0.0000,    0.0000,    0.0000,    0.0000,    298.8782,  0.0000,    0.0000,    0.0000,
  0.0000,    194.1728,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1018.9540, 390.7983,
  0.0000,    0.0000,    0.0000,    732.1642,  289.4434,  0.0000,    0.0000,    0.0000,    424.7883,
  188.2849,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    974.6167,  382.5760,  0.0000,    0.0000,
  0.0000,    700.4442,  283.3715,  0.0000,    0.0000,    0.0000,    408.1203,  184.3805,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    949.1255,  369.8142,  0.0000,    0.0000,    0.0000,    682.1901,
  274.0453,  0.0000,    0.0000,    0.0000,    397.9479,  178.5085,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    925.8158,  373.3538,  0.0000,    0.0000,    0.0000,    665.4868,  276.3828,  0.0000,
  0.0000,    0.0000,    388.5925,  179.3900,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    905.1101,
  365.1112,  0.0000,    0.0000,    0.0000,    650.6557,  269.2305,  0.0000,    0.0000,    0.0000,
  380.3011,  172.7866,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    689.9287,  376.4610,  0.0000,
  0.0000,    0.0000,    499.1837,  278.5080,  0.0000,    0.0000,    0.0000,    299.3233,  180.6115,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    808.4866,  352.0753,  0.0000,    0.0000,    0.0000,
  582.1224,  260.7245,  0.0000,    0.0000,    0.0000,    335.3665,  169.5717,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    775.7718,  361.1822,  0.0000,    0.0000,    0.0000,    559.2917,  266.9922,
  0.0000,    0.0000,    0.0000,    323.5941,  172.5188,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  811.3688,  332.8646,  0.0000,    0.0000,    0.0000,    583.7067,  246.7464,  0.0000,    0.0000,
  0.0000,    343.2850,  160.9616,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    793.6877,  322.8840,
  0.0000,    0.0000,    0.0000,    571.0039,  239.4431,  0.0000,    0.0000,    0.0000,    336.0507,
  156.3709,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    777.4602,  321.2393,  0.0000,    0.0000,
  0.0000,    559.3898,  238.1420,  0.0000,    0.0000,    0.0000,    329.5355,  155.3867,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    769.3983,  340.2385,  0.0000,    0.0000,    0.0000,    553.4266,
  251.7223,  0.0000,    0.0000,    0.0000,    325.6844,  163.4855,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    634.5881,  309.8245,  0.0000,    0.0000,    0.0000,    458.6582,  229.8095,  0.0000,
  0.0000,    0.0000,    274.5969,  150.2119,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    607.5859,
  442.5636,  309.8467,  0.0000,    0.0000,    441.3789,  324.4323,  230.5206,  0.0000,    0.0000,
  270.8085,  203.4999,  151.8710,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    544.4355,  403.2239,  326.4469,
  0.0000,    0.0000,    397.1312,  296.8173,  242.4429,  0.0000,    0.0000,    247.1551,  188.7818,
  158.4438,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    451.9861,  360.7558,  296.7361,  0.0000,    0.0000,
  331.2124,  266.7623,  221.5526,  0.0000,    0.0000,    208.2905,  172.1206,  146.9377,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    456.8687,  371.1348,  264.8378,  0.0000,    0.0000,    335.2261,  273.3273,
  198.6764,  0.0000,    0.0000,    212.0183,  174.1266,  133.1934,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  407.1646,  310.5224,  245.6049,  0.0000,    0.0000,    299.9565,  231.2409,  184.9738,  0.0000,
  0.0000,    192.0317,  152.2648,  125.1034,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    367.6819,  289.8298,
  254.7475,  0.0000,    0.0000,    271.8119,  216.2569,  190.9548,  0.0000,    0.0000,    175.7148,
  143.0584,  127.5067,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    300.1624,  275.4563,  268.6491,  0.0000,
  0.0000,    222.9157,  205.7859,  201.1687,  0.0000,    0.0000,    145.5219,  136.5000,  134.2472,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    278.4874,  263.2230,  0.0000,    0.0000,    0.0000,    207.1831,
  196.6570,  0.0000,    0.0000,    0.0000,    135.7863,  130.3449,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    285.0617,  250.3021,  0.0000,    0.0000,    0.0000,    212.3132,  187.7979,  0.0000,
  0.0000,    0.0000,    139.8351,  125.9710,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    445.0990,
  440.3147,  336.7292,  292.4030,  0.0000,    326.1068,  323.0933,  249.8440,  218.3876,  0.0000,
  204.1814,  203.7192,  163.0325,  145.0784,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    425.9877,  389.4357,  355.8205,
  346.5936,  317.3206,  313.4675,  287.7587,  264.0083,  257.6239,  236.8318,  200.0235,  185.8638,
  172.4904,  169.2036,  157.1991,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    381.0307,  371.4051,  359.8482,  346.2383,  0.0000,
  282.2935,  275.6211,  267.5491,  257.9955,  0.0000,    183.8379,  180.3069,  175.9082,  170.6122,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    357.4603,  356.6773,  354.1279,  0.0000,    0.0000,    266.0200,  265.6196,
  263.9351,  0.0000,    0.0000,    175.2516,  175.3047,  174.5535,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  323.1540,  327.0460,  0.0000,    0.0000,    0.0000,    241.8688,  244.7940,  0.0000,    0.0000,
  0.0000,    161.5240,  163.5087,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    290.4079,  0.0000,
  0.0000,    0.0000,    0.0000,    218.5687,  0.0000,    0.0000,    0.0000,    0.0000,    147.7541,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1218.9348, 449.0776,  0.0000,    0.0000,
  0.0000,    875.8563,  330.8667,  0.0000,    0.0000,    0.0000,    490.0315,  210.8125,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1132.0344, 940.4274,  458.9956,  0.0000,    0.0000,    814.1308,
  679.2931,  338.7013,  0.0000,    0.0000,    474.5100,  395.7560,  217.5284,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    977.2148,  463.0230,  0.0000,    0.0000,    0.0000,    705.4011,  342.8238,  0.0000,
  0.0000,    0.0000,    420.3679,  222.8978,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    852.5249,
  548.4203,  0.0000,    0.0000,    0.0000,    619.0605,  403.9969,  0.0000,    0.0000,    0.0000,
  378.1169,  256.9426,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    857.6379,  485.0227,  0.0000,
  0.0000,    0.0000,    621.3399,  358.5914,  0.0000,    0.0000,    0.0000,    374.7279,  229.3998,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    829.7132,  419.7564,  0.0000,    0.0000,    0.0000,
  601.1496,  311.3204,  0.0000,    0.0000,    0.0000,    362.7869,  202.8197,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    869.5641,  401.9035,  0.0000,    0.0000,    0.0000,    627.6385,  298.4076,
  0.0000,    0.0000,    0.0000,    373.0473,  195.1232,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  839.4478,  511.2028,  0.0000,    0.0000,    0.0000,    606.2139,  374.9686,  0.0000,    0.0000,
  0.0000,    361.3553,  234.4102,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    107.1777,  89.7429,
  74.9865,   56.4116,   52.9606,   89.7429,   75.3686,   63.1685,   47.8580,   44.9888,   74.9865,
  63.1685,   53.1128,   40.5192,   38.1398,   56.4116,   47.8580,   40.5192,   31.4436,   29.6804,
  52.9606,   44.9888,   38.1398,   29.6804,   28.0315,   71.2794,   66.7986,   54.0854,   50.5303,
  40.8962,   60.2996,   56.5295,   45.9632,   42.9646,   34.9990,   50.9090,   47.7462,   38.9834,
  36.4604,   29.8916,   39.2449,   36.8166,   30.3536,   28.4121,   23.6210,   37.0042,   34.7226,
  28.6763,   26.8506,   22.3797,   49.1132,   45.7319,   42.8348,   37.5685,   0.0000,    41.9015,
  39.0433,   36.6063,   32.1644,   0.0000,    35.6778,   33.2677,   31.2221,   27.4842,   0.0000,
  28.0129,   26.1481,   24.5919,   21.7205,   0.0000,    26.5083,   24.7525,   23.2900,   20.5886,
  0.0000,    36.7247,   32.8136,   28.7713,   0.0000,    0.0000,    31.5354,   28.2327,   24.8185,
  0.0000,    0.0000,    27.0247,   24.2416,   21.3648,   0.0000,    0.0000,    21.4989,   19.3571,
  17.1424,   0.0000,    0.0000,    20.3998,   18.3831,   16.2987,   0.0000,    0.0000,    27.4821,
  22.0931,   0.0000,    0.0000,    0.0000,    23.7369,   19.2029,   0.0000,    0.0000,    0.0000,
  20.4592,   16.6531,   0.0000,    0.0000,    0.0000,    16.4607,   13.5581,   0.0000,    0.0000,
  0.0000,    15.6578,   12.9291,   0.0000,    0.0000,    0.0000,    20.9022,   0.0000,    0.0000,
  0.0000,    0.0000,    18.1424,   0.0000,    0.0000,    0.0000,    0.0000,    15.7127,   0.0000,
  0.0000,    0.0000,    0.0000,    12.7577,   0.0000,    0.0000,    0.0000,    0.0000,    12.1608,
  0.0000,    0.0000,    0.0000,    0.0000,    338.7212,  136.9536,  0.0000,    0.0000,    0.0000,
  276.5671,  113.4016,  0.0000,    0.0000,    0.0000,    225.7843,  93.7159,   0.0000,    0.0000,
  0.0000,    156.1138,  68.2755,   0.0000,    0.0000,    0.0000,    145.0020,  63.8123,   0.0000,
  0.0000,    0.0000,    258.1303,  212.2180,  136.9932,  0.0000,    0.0000,    212.9979,  175.5646,
  114.4190,  0.0000,    0.0000,    175.3914,  144.9783,  95.3575,   0.0000,    0.0000,    126.5425,
  105.3054,  71.3023,   0.0000,    0.0000,    118.0748,  98.3724,   66.8696,   0.0000,    0.0000,
  236.4780,  213.8848,  165.5938,  127.9645,  0.0000,    196.2014,  177.7254,  138.2838,  107.5158,
  0.0000,    162.4473,  147.3766,  115.2480,  90.1440,   0.0000,    119.1545,  108.5517,  86.0532,
  68.4330,   0.0000,    111.4377,  101.5889,  80.7005,   64.3332,   0.0000,    184.5111,  170.1891,
  158.0165,  154.0388,  125.7764,  154.2901,  142.5123,  132.4831,  129.0898,  105.9826,  128.7459,
  119.0889,  110.8447,  107.9647,  89.1190,   96.5313,   89.5948,   83.6586,   81.3478,   68.1106,
  90.5740,   84.1158,   78.5835,   76.4038,   64.1083,   142.3481,  138.0774,  136.2402,  126.0194,
  0.0000,    119.9353,  116.3818,  114.7968,  106.3923,  0.0000,    100.8432,  97.8947,   96.5324,
  89.6391,   0.0000,    77.0429,   74.8497,   73.7397,   68.8007,   0.0000,    72.5145,   70.4629,
  69.4115,   64.8127,   0.0000,    117.1121,  115.8168,  113.4324,  0.0000,    0.0000,    99.2159,
  98.1139,   96.1100,   0.0000,    0.0000,    83.8847,   82.9497,   81.2693,   0.0000,    0.0000,
  64.8918,   64.1573,   62.8783,   0.0000,    0.0000,    61.2184,   60.5255,   59.3239,   0.0000,
  0.0000,    94.7612,   93.7743,   0.0000,    0.0000,    0.0000,    80.7272,   79.8833,   0.0000,
  0.0000,    0.0000,    68.6331,   67.9132,   0.0000,    0.0000,    0.0000,    53.7343,   53.1638,
  0.0000,    0.0000,    0.0000,    50.8102,   50.2708,   0.0000,    0.0000,    0.0000,    76.7949,
  0.0000,    0.0000,    0.0000,    0.0000,    65.7580,   0.0000,    0.0000,    0.0000,    0.0000,
  56.1926,   0.0000,    0.0000,    0.0000,    0.0000,    44.4613,   0.0000,    0.0000,    0.0000,
  0.0000,    42.1324,   0.0000,    0.0000,    0.0000,    0.0000,    554.1980,  186.9566,  0.0000,
  0.0000,    0.0000,    452.5193,  155.7781,  0.0000,    0.0000,    0.0000,    370.1535,  129.5963,
  0.0000,    0.0000,    0.0000,    254.2237,  95.8497,   0.0000,    0.0000,    0.0000,    236.1802,
  89.8569,   0.0000,    0.0000,    0.0000,    454.8439,  362.6862,  191.4135,  0.0000,    0.0000,
  373.8815,  298.7264,  160.0734,  0.0000,    0.0000,    306.9078,  245.9498,  133.5995,  0.0000,
  0.0000,    217.9457,  175.1434,  100.0610,  0.0000,    0.0000,    203.0679,  163.3534,  93.9194,
  0.0000,    0.0000,    375.0418,  186.1419,  183.2413,  0.0000,    0.0000,    308.8721,  155.8228,
  153.7050,  0.0000,    0.0000,    253.9534,  130.1725,  128.6716,  0.0000,    0.0000,    181.6834,
  97.7550,   97.1632,   0.0000,    0.0000,    169.4186,  91.7951,   91.3072,   0.0000,    0.0000,
  361.0865,  179.5077,  185.4074,  0.0000,    0.0000,    298.0871,  150.3520,  155.5661,  0.0000,
  0.0000,    245.6647,  125.7017,  130.2662,  0.0000,    0.0000,    177.0660,  94.4758,   98.4363,
  0.0000,    0.0000,    165.2912,  88.7389,   92.5154,   0.0000,    0.0000,    330.1023,  175.8909,
  169.5221,  0.0000,    0.0000,    272.8747,  147.3153,  142.2728,  0.0000,    0.0000,    225.1783,
  123.1529,  119.1771,  0.0000,    0.0000,    162.9990,  92.5451,   90.0574,   0.0000,    0.0000,
  152.2500,  86.9264,   84.6570,   0.0000,    0.0000,    259.3021,  174.3719,  126.3736,  0.0000,
  0.0000,    214.6360,  145.9477,  106.7244,  0.0000,    0.0000,    177.4000,  121.9340,  89.9610,
  0.0000,    0.0000,    128.7233,  91.4528,   68.9958,   0.0000,    0.0000,    120.3278,  85.8806,
  65.0349,   0.0000,    0.0000,    283.4744,  159.8492,  107.4866,  0.0000,    0.0000,    234.8000,
  134.2136,  91.1091,   0.0000,    0.0000,    194.1378,  112.4648,  77.0812,   0.0000,    0.0000,
  141.4071,  85.1312,   59.6313,   0.0000,    0.0000,    132.1984,  80.0375,   56.2921,   0.0000,
  0.0000,    221.7547,  147.6298,  105.5581,  0.0000,    0.0000,    183.9737,  124.1170,  89.4354,
  0.0000,    0.0000,    152.3887,  104.1437,  75.6327,   0.0000,    0.0000,    111.3569,  79.0832,
  58.4515,   0.0000,    0.0000,    104.1990,  74.3930,   55.1698,   0.0000,    0.0000,    234.8693,
  140.7428,  124.9087,  110.5365,  0.0000,    195.1731,  118.3530,  105.2019,  93.4541,   0.0000,
  161.8720,  99.3343,   88.4405,   78.8624,   0.0000,    119.1091,  75.4525,   67.3932,   60.6537,
  0.0000,    111.5063,  70.9871,   63.4543,   57.1987,   0.0000,    242.4174,  137.6254,  116.0923,
  122.3915,  0.0000,    201.1351,  115.7000,  97.9268,   102.9220,  0.0000,    166.5614,  97.0816,
  82.4474,   86.3895,   0.0000,    122.0144,  73.6865,   63.0740,   65.5618,   0.0000,    114.1506,
  69.3194,   59.4247,   61.6974,   0.0000,    185.1741,  136.3705,  0.0000,    0.0000,    0.0000,
  153.8824,  114.3466,  0.0000,    0.0000,    0.0000,    127.6686,  95.7007,   0.0000,    0.0000,
  0.0000,    93.7660,   72.1216,   0.0000,    0.0000,    0.0000,    87.8052,   67.7835,   0.0000,
  0.0000,    0.0000,    189.6293,  127.2488,  0.0000,    0.0000,    0.0000,    158.0848,  107.2026,
  0.0000,    0.0000,    0.0000,    131.5252,  90.1351,   0.0000,    0.0000,    0.0000,    97.6845,
  68.8077,   0.0000,    0.0000,    0.0000,    91.5728,   64.7798,   0.0000,    0.0000,    0.0000,
  225.3933,  211.2756,  166.1525,  134.8856,  0.0000,    187.5797,  176.0976,  139.2546,  113.6748,
  0.0000,    155.8080,  146.4890,  116.4830,  95.6039,   0.0000,    115.1706,  108.7508,  87.7688,
  73.0754,   0.0000,    107.8705,  101.9223,  82.4447,   68.7935,   0.0000,    197.3448,  184.2055,
  175.0938,  156.2783,  137.2617,  165.1930,  154.4409,  146.9606,  131.5234,  115.9145,  137.9956,
  129.2227,  123.0969,  110.4653,  97.6880,   103.6947,  97.4953,   93.1301,   84.1398,   75.0316,
  97.3490,   91.5895,   87.5282,   79.1656,   70.6917,   166.9060,  163.9655,  159.4969,  153.4055,
  0.0000,    140.5625,  138.1446,  134.4704,  129.4615,  0.0000,    118.1354,  116.1535,  113.1412,
  109.0331,  0.0000,    90.1373,   88.7108,   86.5486,   83.6036,   0.0000,    84.8298,   83.5023,
  81.4896,   78.7478,   0.0000,    148.8008,  148.8590,  147.6502,  0.0000,    0.0000,    125.8437,
  125.8888,  124.8845,  0.0000,    0.0000,    106.2140,  106.2491,  105.4167,  0.0000,    0.0000,
  81.8381,   81.8564,   81.2400,   0.0000,    0.0000,    77.1533,   77.1700,   76.5939,   0.0000,
  0.0000,    129.2495,  130.1881,  0.0000,    0.0000,    0.0000,    109.8060,  110.5802,  0.0000,
  0.0000,    0.0000,    93.1003,   93.7374,   0.0000,    0.0000,    0.0000,    72.4613,   72.9221,
  0.0000,    0.0000,    0.0000,    68.4416,   68.8714,   0.0000,    0.0000,    0.0000,    111.5371,
  0.0000,    0.0000,    0.0000,    0.0000,    95.1763,   0.0000,    0.0000,    0.0000,    0.0000,
  81.0518,   0.0000,    0.0000,    0.0000,    0.0000,    63.6768,   0.0000,    0.0000,    0.0000,
  0.0000,    60.2544,   0.0000,    0.0000,    0.0000,    0.0000,    620.0878,  222.5081,  0.0000,
  0.0000,    0.0000,    506.9421,  185.7206,  0.0000,    0.0000,    0.0000,    415.2201,  154.7827,
  0.0000,    0.0000,    0.0000,    286.2486,  114.9721,  0.0000,    0.0000,    0.0000,    266.1018,
  107.8668,  0.0000,    0.0000,    0.0000,    541.5729,  441.1261,  228.9512,  0.0000,    0.0000,
  445.2608,  363.3607,  191.6429,  0.0000,    0.0000,    365.6571,  299.2914,  160.1098,  0.0000,
  0.0000,    259.5279,  212.8759,  120.1300,  0.0000,    0.0000,    241.8504,  198.5660,  112.8093,
  0.0000,    0.0000,    472.4364,  334.1351,  219.3347,  0.0000,    0.0000,    389.8823,  277.4050,
  184.2847,  0.0000,    0.0000,    321.2652,  230.1384,  154.5280,  0.0000,    0.0000,    231.1173,
  168.1354,  117.1570,  0.0000,    0.0000,    215.7263,  157.3598,  110.1737,  0.0000,    0.0000,
  423.2302,  246.0147,  220.8361,  0.0000,    0.0000,    350.1970,  206.0014,  185.7762,  0.0000,
  0.0000,    289.2869,  172.1810,  155.9706,  0.0000,    0.0000,    209.9066,  129.2409,  118.6243,
  0.0000,    0.0000,    196.1543,  121.3842,  111.6080,  0.0000,    0.0000,    384.9072,  248.4266,
  213.3735,  0.0000,    0.0000,    319.1151,  207.9943,  179.5291,  0.0000,    0.0000,    264.1285,
  173.7946,  150.7698,  0.0000,    0.0000,    192.7765,  130.4379,  114.6328,  0.0000,    0.0000,
  180.3042,  122.5075,  107.8711,  0.0000,    0.0000,    295.3592,  231.0449,  187.4666,  0.0000,
  0.0000,    245.8527,  193.7557,  158.3563,  0.0000,    0.0000,    204.3092,  162.1983,  133.5090,
  0.0000,    0.0000,    150.7447,  122.1941,  102.4883,  0.0000,    0.0000,    141.2522,  114.8462,
  96.6030,   0.0000,    0.0000,    330.3257,  260.3796,  164.5777,  0.0000,    0.0000,    274.5334,
  217.4762,  139.4763,  0.0000,    0.0000,    227.7959,  181.3885,  117.9758,  0.0000,    0.0000,
  167.3783,  134.9705,  91.2518,   0.0000,    0.0000,    156.7256,  126.6571,  86.1276,   0.0000,
  0.0000,    249.9382,  200.3299,  155.1628,  0.0000,    0.0000,    208.6362,  168.5944,  131.6650,
  0.0000,    0.0000,    173.8767,  141.6201,  111.5108,  0.0000,    0.0000,    129.2726,  107.7128,
  86.4986,   0.0000,    0.0000,    121.2876,  101.3825,  81.6853,   0.0000,    0.0000,    273.7195,
  187.1327,  158.7124,  0.0000,    0.0000,    228.2822,  157.5949,  134.2505,  0.0000,    0.0000,
  190.0445,  132.4776,  113.3508,  0.0000,    0.0000,    141.1109,  100.8958,  87.2376,   0.0000,
  0.0000,    132.3281,  94.9987,   82.2887,   0.0000,    0.0000,    253.3425,  173.4360,  166.1533,
  0.0000,    0.0000,    211.5559,  146.2020,  140.3599,  0.0000,    0.0000,    176.3381,  123.0227,
  118.3487,  0.0000,    0.0000,    131.4019,  93.8997,   90.8284,   0.0000,    0.0000,    123.2913,
  88.4515,   85.6281,   0.0000,    0.0000,    210.6811,  167.8350,  0.0000,    0.0000,    0.0000,
  176.0603,  141.4060,  0.0000,    0.0000,    0.0000,    146.9017,  118.9236,  0.0000,    0.0000,
  0.0000,    109.4741,  90.6508,   0.0000,    0.0000,    0.0000,    102.7753,  85.3773,   0.0000,
  0.0000,    0.0000,    222.6273,  165.6587,  0.0000,    0.0000,    0.0000,    186.2199,  139.8793,
  0.0000,    0.0000,    0.0000,    155.4778,  117.8843,  0.0000,    0.0000,    0.0000,    116.3922,
  90.4277,   0.0000,    0.0000,    0.0000,    109.2887,  85.2274,   0.0000,    0.0000,    0.0000,
  281.1737,  267.4750,  213.4484,  180.4568,  0.0000,    234.2171,  223.1629,  179.1755,  152.2615,
  0.0000,    194.7649,  185.8576,  150.1267,  128.2191,  0.0000,    144.1259,  138.1855,  113.4826,
  98.2235,   0.0000,    135.0814,  129.5979,  106.6946,  92.5355,   0.0000,    258.7146,  240.5934,
  232.2513,  208.2379,  187.3808,  216.4276,  201.6758,  194.8895,  175.2745,  158.2137,  180.6996,
  168.7248,  163.2184,  147.2385,  133.3214,  135.4439,  127.1409,  123.3340,  112.1331,  102.3247,
  127.1521,  119.4559,  115.9286,  105.5295,  96.4179,   229.0421,  224.2438,  217.7905,  209.6745,
  0.0000,    192.5542,  188.6577,  183.4000,  176.7743,  0.0000,    161.5570,  158.4037,  154.1335,
  148.7395,  0.0000,    122.6873,  120.5099,  117.5338,  113.7542,  0.0000,    115.4018,  113.3867,
  110.6276,  107.1200,  0.0000,    211.4898,  211.2799,  209.4559,  0.0000,    0.0000,    178.3919,
  178.2509,  176.7765,  0.0000,    0.0000,    150.1754,  150.0870,  148.8998,  0.0000,    0.0000,
  114.9752,  114.9640,  114.1553,  0.0000,    0.0000,    108.2922,  108.2898,  107.5434,  0.0000,
  0.0000,    190.1094,  191.9273,  0.0000,    0.0000,    0.0000,    160.9679,  162.4939,  0.0000,
  0.0000,    0.0000,    136.0239,  137.3020,  0.0000,    0.0000,    0.0000,    105.0660,  106.0350,
  0.0000,    0.0000,    0.0000,    99.1109,   100.0210,  0.0000,    0.0000,    0.0000,    169.8578,
  0.0000,    0.0000,    0.0000,    0.0000,    144.3697,  0.0000,    0.0000,    0.0000,    0.0000,
  122.4634,  0.0000,    0.0000,    0.0000,    0.0000,    95.3973,   0.0000,    0.0000,    0.0000,
  0.0000,    90.1296,   0.0000,    0.0000,    0.0000,    0.0000,    754.9243,  262.2387,  0.0000,
  0.0000,    0.0000,    617.6058,  219.6387,  0.0000,    0.0000,    0.0000,    506.5054,  183.6568,
  0.0000,    0.0000,    0.0000,    349.4860,  137.8005,  0.0000,    0.0000,    0.0000,    324.9872,
  129.4461,  0.0000,    0.0000,    0.0000,    690.6852,  572.3002,  276.3430,  0.0000,    0.0000,
  567.5136,  471.0503,  231.6543,  0.0000,    0.0000,    465.9766,  388.0268,  193.8381,  0.0000,
  0.0000,    329.4784,  274.5914,  145.9330,  0.0000,    0.0000,    306.9686,  256.0547,  137.1250,
  0.0000,    0.0000,    604.4915,  423.0815,  286.0290,  0.0000,    0.0000,    498.4534,  351.1166,
  240.1361,  0.0000,    0.0000,    410.5123,  291.2744,  201.2083,  0.0000,    0.0000,    294.1692,
  212.3569,  152.2250,  0.0000,    0.0000,    274.4932,  198.7197,  143.1068,  0.0000,    0.0000,
  270.6187,  0.0000,    0.0000,    0.0000,    0.0000,    227.4189,  0.0000,    0.0000,    0.0000,
  0.0000,    190.7463,  0.0000,    0.0000,    0.0000,    0.0000,    144.6238,  0.0000,    0.0000,
  0.0000,    0.0000,    136.0287,  0.0000,    0.0000,    0.0000,    0.0000,    610.7615,  262.3192,
  0.0000,    0.0000,    0.0000,    502.4967,  220.5170,  0.0000,    0.0000,    0.0000,    413.1209,
  185.0194,  0.0000,    0.0000,    0.0000,    293.4486,  140.3959,  0.0000,    0.0000,    0.0000,
  273.5743,  132.0706,  0.0000,    0.0000,    0.0000,    586.1896,  256.8646,  0.0000,    0.0000,
  0.0000,    482.5077,  215.9438,  0.0000,    0.0000,    0.0000,    396.7581,  181.1913,  0.0000,
  0.0000,    0.0000,    282.4641,  137.5122,  0.0000,    0.0000,    0.0000,    263.3886,  129.3614,
  0.0000,    0.0000,    0.0000,    571.4113,  248.6071,  0.0000,    0.0000,    0.0000,    470.4029,
  209.0627,  0.0000,    0.0000,    0.0000,    386.8363,  175.4697,  0.0000,    0.0000,    0.0000,
  275.5610,  133.2643,  0.0000,    0.0000,    0.0000,    256.9654,  125.3807,  0.0000,    0.0000,
  0.0000,    557.8380,  250.0690,  0.0000,    0.0000,    0.0000,    459.2753,  210.1448,  0.0000,
  0.0000,    0.0000,    377.7092,  176.2659,  0.0000,    0.0000,    0.0000,    269.1899,  133.6061,
  0.0000,    0.0000,    0.0000,    251.0346,  125.6675,  0.0000,    0.0000,    0.0000,    545.8015,
  241.6343,  0.0000,    0.0000,    0.0000,    449.4102,  202.6148,  0.0000,    0.0000,    0.0000,
  369.6195,  169.5824,  0.0000,    0.0000,    0.0000,    263.5484,  127.7725,  0.0000,    0.0000,
  0.0000,    245.7832,  120.0875,  0.0000,    0.0000,    0.0000,    426.4897,  251.8424,  0.0000,
  0.0000,    0.0000,    352.9087,  211.5485,  0.0000,    0.0000,    0.0000,    291.6491,  177.3613,
  0.0000,    0.0000,    0.0000,    211.2565,  134.3264,  0.0000,    0.0000,    0.0000,    197.4553,
  126.3205,  0.0000,    0.0000,    0.0000,    482.7977,  236.2659,  0.0000,    0.0000,    0.0000,
  397.4499,  198.6025,  0.0000,    0.0000,    0.0000,    327.2333,  166.6202,  0.0000,    0.0000,
  0.0000,    232.1028,  126.4184,  0.0000,    0.0000,    0.0000,    216.4708,  118.9198,  0.0000,
  0.0000,    0.0000,    465.2439,  240.7836,  0.0000,    0.0000,    0.0000,    383.2952,  202.1595,
  0.0000,    0.0000,    0.0000,    315.8875,  169.4228,  0.0000,    0.0000,    0.0000,    224.5940,
  128.1009,  0.0000,    0.0000,    0.0000,    209.5360,  120.4474,  0.0000,    0.0000,    0.0000,
  491.8875,  224.0856,  0.0000,    0.0000,    0.0000,    405.3285,  188.4765,  0.0000,    0.0000,
  0.0000,    333.5597,  158.2170,  0.0000,    0.0000,    0.0000,    238.5984,  120.2375,  0.0000,
  0.0000,    0.0000,    222.5870,  113.1311,  0.0000,    0.0000,    0.0000,    481.4385,  217.6279,
  0.0000,    0.0000,    0.0000,    396.7377,  183.0885,  0.0000,    0.0000,    0.0000,    326.4963,
  153.7302,  0.0000,    0.0000,    0.0000,    233.6155,  116.9007,  0.0000,    0.0000,    0.0000,
  217.9416,  110.0016,  0.0000,    0.0000,    0.0000,    471.9860,  216.3099,  0.0000,    0.0000,
  0.0000,    388.9890,  181.9383,  0.0000,    0.0000,    0.0000,    320.1437,  152.7300,  0.0000,
  0.0000,    0.0000,    229.1777,  116.0754,  0.0000,    0.0000,    0.0000,    213.8101,  109.2144,
  0.0000,    0.0000,    0.0000,    466.6099,  227.8802,  0.0000,    0.0000,    0.0000,    384.4701,
  191.4109,  0.0000,    0.0000,    0.0000,    316.3522,  160.4620,  0.0000,    0.0000,    0.0000,
  226.3056,  121.5617,  0.0000,    0.0000,    0.0000,    211.1076,  114.3083,  0.0000,    0.0000,
  0.0000,    391.4652,  209.0059,  0.0000,    0.0000,    0.0000,    323.6450,  175.8502,  0.0000,
  0.0000,    0.0000,    267.2409,  147.6636,  0.0000,    0.0000,    0.0000,    193.1889,  112.3244,
  0.0000,    0.0000,    0.0000,    180.4856,  105.6965,  0.0000,    0.0000,    0.0000,    383.5084,
  286.2831,  210.8417,  0.0000,    0.0000,    318.2872,  238.9767,  177.6918,  0.0000,    0.0000,
  263.6848,  199.1929,  149.4557,  0.0000,    0.0000,    193.1702,  148.1225,  114.1794,  0.0000,
  0.0000,    180.7434,  138.9431,  107.5053,  0.0000,    0.0000,    348.6285,  264.5808,  220.4197,
  0.0000,    0.0000,    290.1801,  221.5085,  185.5749,  0.0000,    0.0000,    241.0799,  185.1452,
  155.9549,  0.0000,    0.0000,    178.1249,  138.8171,  118.7315,  0.0000,    0.0000,    166.8741,
  130.3755,  111.7577,  0.0000,    0.0000,    292.9015,  240.2982,  203.6120,  0.0000,    0.0000,
  244.5675,  201.8058,  172.0316,  0.0000,    0.0000,    203.8567,  169.1811,  145.0689,  0.0000,
  0.0000,    151.7946,  127.9252,  111.4262,  0.0000,    0.0000,    142.4140,  120.3020,  105.0350,
  0.0000,    0.0000,    297.6936,  243.9489,  184.0194,  0.0000,    0.0000,    248.7775,  204.3487,
  155.9432,  0.0000,    0.0000,    207.5237,  170.8918,  131.8957,  0.0000,    0.0000,    154.9564,
  128.3062,  102.0081,  0.0000,    0.0000,    145.4248,  120.5408,  96.2759,   0.0000,    0.0000,
  268.7304,  211.4105,  172.4260,  0.0000,    0.0000,    225.1819,  178.3469,  146.4712,  0.0000,
  0.0000,    188.3408,  150.1755,  124.1821,  0.0000,    0.0000,    141.6661,  114.8945,  96.5706,
  0.0000,    0.0000,    133.1038,  108.2446,  91.2325,   0.0000,    0.0000,    245.2381,  198.3807,
  176.3501,  0.0000,    0.0000,    205.9702,  167.5869,  149.4170,  0.0000,    0.0000,    172.6661,
  141.3085,  126.3658,  0.0000,    0.0000,    130.6536,  108.4580,  97.6238,   0.0000,    0.0000,
  122.8762,  102.2436,  92.1458,   0.0000,    0.0000,    202.5408,  189.1485,  185.7195,  0.0000,
  0.0000,    170.6556,  159.9284,  157.2466,  0.0000,    0.0000,    143.5317,  134.9708,  132.8868,
  0.0000,    0.0000,    109.4040,  103.7977,  102.5451,  0.0000,    0.0000,    103.0421,  97.8898,
  96.7591,   0.0000,    0.0000,    188.7859,  180.6582,  0.0000,    0.0000,    0.0000,    159.2635,
  152.7829,  0.0000,    0.0000,    0.0000,    134.1189,  128.9734,  0.0000,    0.0000,    0.0000,
  102.5201,  99.2050,   0.0000,    0.0000,    0.0000,    96.6130,   93.5748,   0.0000,    0.0000,
  0.0000,    194.1615,  174.0294,  0.0000,    0.0000,    0.0000,    163.8820,  147.5240,  0.0000,
  0.0000,    0.0000,    138.0677,  124.8168,  0.0000,    0.0000,    0.0000,    105.7384,  96.6002,
  0.0000,    0.0000,    0.0000,    99.6561,   91.1930,   0.0000,    0.0000,    0.0000,    287.4346,
  286.2525,  226.9393,  200.9621,  0.0000,    240.0000,  239.2545,  191.0352,  169.8480,  0.0000,
  200.0898,  199.6443,  160.5147,  143.2743,  0.0000,    148.8227,  148.9993,  122.1541,  110.1523,
  0.0000,    139.6481,  139.8637,  114.9901,  103.8543,  0.0000,    280.1714,  259.4598,  240.0262,
  235.1145,  217.7973,  234.6048,  217.8236,  202.0191,  198.0952,  183.9560,  196.0895,  182.5270,
  169.7077,  166.5821,  155.0685,  147.2178,  137.9942,  129.1524,  127.1338,  119.0738,  138.2841,
  129.7527,  121.5600,  119.7071,  112.2254,  256.0537,  250.8181,  244.3568,  236.6200,  0.0000,
  215.3027,  211.1078,  205.8985,  199.6369,  0.0000,    180.6882,  177.3400,  173.1544,  168.1026,
  0.0000,    137.2028,  135.0047,  132.1947,  128.7589,  0.0000,    129.0834,  127.0629,  124.4711,
  121.2957,  0.0000,    243.3057,  243.2553,  242.0722,  0.0000,    0.0000,    205.1334,  205.1682,
  204.2639,  0.0000,    0.0000,    172.6136,  172.7071,  172.0238,  0.0000,    0.0000,    131.9596,
  132.1597,  131.7889,  0.0000,    0.0000,    124.2802,  124.4851,  124.1567,  0.0000,    0.0000,
  223.3971,  226.1285,  0.0000,    0.0000,    0.0000,    188.9991,  191.3087,  0.0000,    0.0000,
  0.0000,    159.5852,  161.5337,  0.0000,    0.0000,    0.0000,    123.0101,  124.5148,  0.0000,
  0.0000,    0.0000,    116.0097,  117.4266,  0.0000,    0.0000,    0.0000,    203.6621,  0.0000,
  0.0000,    0.0000,    0.0000,    172.8854,  0.0000,    0.0000,    0.0000,    0.0000,    146.4721,
  0.0000,    0.0000,    0.0000,    0.0000,    113.7716,  0.0000,    0.0000,    0.0000,    0.0000,
  107.4421,  0.0000,    0.0000,    0.0000,    0.0000,    710.6585,  295.2992,  0.0000,    0.0000,
  0.0000,    582.9815,  247.3831,  0.0000,    0.0000,    0.0000,    478.9676,  206.8979,  0.0000,
  0.0000,    0.0000,    334.3564,  155.3487,  0.0000,    0.0000,    0.0000,    311.3222,  145.9399,
  0.0000,    0.0000,    0.0000,    681.3789,  567.8107,  304.0917,  0.0000,    0.0000,    561.0086,
  468.4069,  255.0141,  0.0000,    0.0000,    461.4715,  386.4580,  213.4683,  0.0000,    0.0000,
  328.6797,  275.9578,  160.8674,  0.0000,    0.0000,    306.5067,  257.5846,  151.1796,  0.0000,
  0.0000,    600.0533,  310.5859,  0.0000,    0.0000,    0.0000,    495.6389,  261.0234,  0.0000,
  0.0000,    0.0000,    408.8321,  218.9430,  0.0000,    0.0000,    0.0000,    294.7200,  166.0489,
  0.0000,    0.0000,    0.0000,    275.2171,  156.1808,  0.0000,    0.0000,    0.0000,    536.0858,
  360.0553,  0.0000,    0.0000,    0.0000,    444.8102,  301.5264,  0.0000,    0.0000,    0.0000,
  368.4688,  252.1485,  0.0000,    0.0000,    0.0000,    269.5021,  189.1137,  0.0000,    0.0000,
  0.0000,    252.1649,  177.6375,  0.0000,    0.0000,    0.0000,    533.0818,  320.8497,  0.0000,
  0.0000,    0.0000,    441.5578,  269.2438,  0.0000,    0.0000,    0.0000,    365.2479,  225.7100,
  0.0000,    0.0000,    0.0000,    265.4503,  170.0195,  0.0000,    0.0000,    0.0000,    248.2156,
  159.8452,  0.0000,    0.0000,    0.0000,    516.0195,  282.4312,  0.0000,    0.0000,    0.0000,
  427.4807,  237.6634,  0.0000,    0.0000,    0.0000,    353.6401,  199.6277,  0.0000,    0.0000,
  0.0000,    257.1254,  151.7709,  0.0000,    0.0000,    0.0000,    240.4492,  142.8451,  0.0000,
  0.0000,    0.0000,    532.8988,  271.4539,  0.0000,    0.0000,    0.0000,    440.2710,  228.5997,
  0.0000,    0.0000,    0.0000,    363.2803,  192.1504,  0.0000,    0.0000,    0.0000,    261.8283,
  146.3889,  0.0000,    0.0000,    0.0000,    244.5726,  137.8226,  0.0000,    0.0000,    0.0000,
  515.7977,  330.0255,  0.0000,    0.0000,    0.0000,    426.3255,  275.6697,  0.0000,    0.0000,
  0.0000,    351.9041,  230.0003,  0.0000,    0.0000,    0.0000,    254.0263,  171.0645,  0.0000,
  0.0000,    0.0000,    237.3277,  160.5488,  0.0000,    0.0000,    0.0000,    49.1130,   46.0681,
  37.8419,   35.4129,   29.2830,   46.0681,   43.2452,   35.5219,   33.2540,   27.5206,   37.8419,
  35.5219,   29.3602,   27.5063,   22.9517,   35.4129,   33.2540,   27.5063,   25.7809,   21.5377,
  29.2830,   27.5206,   22.9517,   21.5377,   18.2067,   34.8146,   32.4848,   30.5305,   26.9351,
  0.0000,    32.7009,   30.5410,   28.6938,   25.3318,   0.0000,    27.1704,   25.3827,   23.8965,
  21.1488,   0.0000,    25.4799,   23.8136,   22.4279,   19.8669,   0.0000,    21.4199,   20.0468,
  18.9172,   16.8169,   0.0000,    26.5929,   23.9120,   21.1428,   0.0000,    0.0000,    25.0097,
  22.5178,   19.9090,   0.0000,    0.0000,    20.9597,   18.9034,   16.7855,   0.0000,    0.0000,
  19.6943,   17.7750,   15.8009,   0.0000,    0.0000,    16.7544,   15.1751,   13.5525,   0.0000,
  0.0000,    20.2827,   16.6373,   0.0000,    0.0000,    0.0000,    19.0974,   15.6857,   0.0000,
  0.0000,    0.0000,    16.1312,   13.3529,   0.0000,    0.0000,    0.0000,    15.1883,   12.5970,
  0.0000,    0.0000,    0.0000,    13.0546,   10.9391,   0.0000,    0.0000,    0.0000,    15.6740,
  0.0000,    0.0000,    0.0000,    0.0000,    14.7716,   0.0000,    0.0000,    0.0000,    0.0000,
  12.5629,   0.0000,    0.0000,    0.0000,    0.0000,    11.8513,   0.0000,    0.0000,    0.0000,
  0.0000,    10.2716,   0.0000,    0.0000,    0.0000,    0.0000,    203.7631,  87.3956,   0.0000,
  0.0000,    0.0000,    192.3729,  82.0144,   0.0000,    0.0000,    0.0000,    148.7618,  65.2739,
  0.0000,    0.0000,    0.0000,    139.3753,  61.0174,   0.0000,    0.0000,    0.0000,    105.9248,
  48.1622,   0.0000,    0.0000,    0.0000,    162.6082,  134.9227,  90.3305,   0.0000,    0.0000,
  152.6130,  126.6657,  84.6178,   0.0000,    0.0000,    120.7386,  100.5817,  68.2984,   0.0000,
  0.0000,    112.8210,  93.9978,   63.7944,   0.0000,    0.0000,    88.2620,   74.0028,   51.3525,
  0.0000,    0.0000,    152.0934,  138.3254,  109.0541,  86.1605,   0.0000,    142.6094,  129.6922,
  102.2095,  80.7111,   0.0000,    113.8560,  103.7907,  82.4303,   65.6968,   0.0000,    106.3508,
  96.9560,   77.0087,   61.3829,   0.0000,    84.3073,   77.1362,   61.9610,   50.0397,   0.0000,
  122.1387,  113.2046,  105.5713,  102.7202,  85.5223,   114.4405,  106.0806,  98.9278,   96.2872,
  80.1427,   92.4931,   85.9068,   80.2619,   78.0574,   65.4879,   86.3999,   80.2618,   74.9967,
  72.9530,   61.2169,   69.7224,   64.9672,   60.8687,   59.1583,   50.2053,   96.7503,   93.9663,
  92.6080,   86.2427,   0.0000,    90.6767,   88.0769,   86.8128,   80.8496,   0.0000,    74.0784,
  71.9914,   70.9269,   66.2343,   0.0000,    69.2515,   67.3088,   66.3194,   61.9433,   0.0000,
  56.7852,   55.2375,   54.3941,   51.0048,   0.0000,    81.0919,   80.1804,   78.5729,   0.0000,
  0.0000,    76.0552,   75.2039,   73.7006,   0.0000,    0.0000,    62.5953,   61.8916,   60.6690,
  0.0000,    0.0000,    58.5776,   57.9221,   56.7826,   0.0000,    0.0000,    48.5681,   48.0221,
  47.0943,   0.0000,    0.0000,    66.8407,   66.1354,   0.0000,    0.0000,    0.0000,    62.7465,
  62.0864,   0.0000,    0.0000,    0.0000,    52.0208,   51.4721,   0.0000,    0.0000,    0.0000,
  48.7448,   48.2328,   0.0000,    0.0000,    0.0000,    40.8516,   40.4209,   0.0000,    0.0000,
  0.0000,    55.0898,   0.0000,    0.0000,    0.0000,    0.0000,    51.7684,   0.0000,    0.0000,
  0.0000,    0.0000,    43.2064,   0.0000,    0.0000,    0.0000,    0.0000,    40.5441,   0.0000,
  0.0000,    0.0000,    0.0000,    34.3050,   0.0000,    0.0000,    0.0000,    0.0000,    332.2694,
  121.9292,  0.0000,    0.0000,    0.0000,    314.5800,  114.5723,  0.0000,    0.0000,    0.0000,
  242.6366,  92.0240,   0.0000,    0.0000,    0.0000,    227.6600,  86.1481,   0.0000,    0.0000,
  0.0000,    172.9685,  69.0434,   0.0000,    0.0000,    0.0000,    281.7035,  225.9629,  126.6836,
  0.0000,    0.0000,    265.1206,  212.8957,  118.8255,  0.0000,    0.0000,    208.0223,  167.4145,
  96.0553,   0.0000,    0.0000,    194.6719,  156.7702,  89.8285,   0.0000,    0.0000,    150.8203,
  122.0707,  72.5524,   0.0000,    0.0000,    234.1950,  123.6379,  122.6115,  0.0000,    0.0000,
  220.1854,  115.9726,  114.9710,  0.0000,    0.0000,    173.4630,  93.8911,   93.3603,   0.0000,
  0.0000,    162.2609,  87.8153,   87.3048,   0.0000,    0.0000,    126.3491,  71.0854,   70.9670,
  0.0000,    0.0000,    227.5723,  119.4376,  124.1849,  0.0000,    0.0000,    213.8682,  112.0523,
  116.4471,  0.0000,    0.0000,    169.2064,  90.7838,   94.6013,   0.0000,    0.0000,    158.2705,
  84.9253,   88.4703,   0.0000,    0.0000,    124.0013,  68.8297,   71.9595,   0.0000,    0.0000,
  209.1450,  117.0098,  113.6129,  0.0000,    0.0000,    196.4885,  109.7797,  106.5711,  0.0000,
  0.0000,    155.8387,  88.9429,   86.6060,   0.0000,    0.0000,    145.7580,  83.2111,   81.0229,
  0.0000,    0.0000,    114.5870,  67.4383,   65.9473,   0.0000,    0.0000,    164.9882,  115.7182,
  86.5464,   0.0000,    0.0000,    155.1171,  108.5820,  81.2335,   0.0000,    0.0000,    123.2591,
  87.8889,   66.6131,   0.0000,    0.0000,    115.3697,  82.2331,   62.3963,   0.0000,    0.0000,
  91.0233,   66.5568,   51.4610,   0.0000,    0.0000,    181.0035,  107.3382,  74.5511,   0.0000,
  0.0000,    169.9796,  100.6463,  69.9883,   0.0000,    0.0000,    135.2994,  81.8731,   57.6893,
  0.0000,    0.0000,    126.5416,  76.5846,   54.0676,   0.0000,    0.0000,    99.9768,   62.3931,
  44.9179,   0.0000,    0.0000,    142.3467,  99.5880,   73.1079,   0.0000,    0.0000,    133.7700,
  93.3848,   68.6293,   0.0000,    0.0000,    106.7326,  76.1132,   56.5429,   0.0000,    0.0000,
  99.9017,   71.2110,   52.9928,   0.0000,    0.0000,    79.2630,   58.1776,   43.9902,   0.0000,
  0.0000,    151.8703,  95.0051,   84.7552,   76.0072,   0.0000,    142.5140,  89.0992,   79.5273,
  71.3318,   0.0000,    114.0913,  72.6443,   64.9856,   58.6057,   0.0000,    106.6917,  67.9774,
  60.8513,   54.9066,   0.0000,    84.9547,   55.5654,   49.9148,   45.3891,   0.0000,    155.8507,
  92.8107,   79.2056,   82.5930,   0.0000,    146.2711,  87.0432,   74.3149,   77.5124,   0.0000,
  116.8072,  70.9444,   60.8678,   63.2092,   0.0000,    109.2305,  66.3897,   57.0046,   59.1980,
  0.0000,    86.6601,   54.2397,   46.9071,   48.4149,   0.0000,    119.6350,  91.1025,   0.0000,
  0.0000,    0.0000,    112.3914,  85.4731,   0.0000,    0.0000,    0.0000,    89.9515,   69.4058,
  0.0000,    0.0000,    0.0000,    84.2028,   64.9641,   0.0000,    0.0000,    0.0000,    67.0823,
  52.7984,   0.0000,    0.0000,    0.0000,    124.1032,  86.4709,   0.0000,    0.0000,    0.0000,
  116.3987,  81.0686,   0.0000,    0.0000,    0.0000,    93.6870,   66.2838,   0.0000,    0.0000,
  0.0000,    87.6124,   62.0228,   0.0000,    0.0000,    0.0000,    70.2820,   50.8856,   0.0000,
  0.0000,    0.0000,    146.5544,  138.1497,  110.8384,  91.7661,   0.0000,    137.4723,  129.5670,
  103.9180,  86.0172,   0.0000,    110.2770,  104.1881,  84.2691,   70.3184,   0.0000,    103.0738,
  97.3838,   78.7812,   65.7584,   0.0000,    82.3248,   78.0505,   63.9117,   53.9617,   0.0000,
  131.0954,  123.0574,  117.4198,  105.8004,  94.0357,   122.8805,  115.3488,  110.0651,  99.1763,
  88.1532,   99.4698,   93.5893,   89.4448,   80.9084,   72.2595,   92.9621,   87.4781,   83.6131,
  75.6514,   67.5854,   75.2076,   71.0143,   68.0343,   61.9038,   55.6857,   113.2616,  111.4257,
  108.6407,  104.8462,  0.0000,    106.1686,  104.4532,  101.8469,  98.2930,   0.0000,    86.6895,
  85.3379,   83.2865,   80.4902,   0.0000,    81.0563,   79.7986,   77.8874,   75.2808,   0.0000,
  66.4147,   65.4414,   63.9621,   61.9438,   0.0000,    102.4346,  102.4620,  101.6786,  0.0000,
  0.0000,    96.0599,   96.0872,   95.3553,   0.0000,    0.0000,    78.8838,   78.9029,   78.3177,
  0.0000,    0.0000,    73.8064,   73.8257,   73.2814,   0.0000,    0.0000,    60.9913,   61.0041,
  60.5723,   0.0000,    0.0000,    90.3424,   90.9343,   0.0000,    0.0000,    0.0000,    84.7723,
  85.3265,   0.0000,    0.0000,    0.0000,    70.0352,   70.4744,   0.0000,    0.0000,    0.0000,
  65.5868,   65.9967,   0.0000,    0.0000,    0.0000,    54.6824,   55.0029,   0.0000,    0.0000,
  0.0000,    79.1080,   0.0000,    0.0000,    0.0000,    0.0000,    74.2865,   0.0000,    0.0000,
  0.0000,    0.0000,    61.7254,   0.0000,    0.0000,    0.0000,    0.0000,    57.8665,   0.0000,
  0.0000,    0.0000,    0.0000,    48.6500,   0.0000,    0.0000,    0.0000,    0.0000,    373.5384,
  145.9974,  0.0000,    0.0000,    0.0000,    353.6302,  137.2125,  0.0000,    0.0000,    0.0000,
  273.3757,  110.4856,  0.0000,    0.0000,    0.0000,    256.5198,  103.4559,  0.0000,    0.0000,
  0.0000,    195.5996,  83.2418,   0.0000,    0.0000,    0.0000,    335.4597,  274.7031,  151.9745,
  0.0000,    0.0000,    315.8923,  258.9885,  142.6113,  0.0000,    0.0000,    247.8285,  203.5706,
  115.4107,  0.0000,    0.0000,    232.0032,  190.6976,  107.9688,  0.0000,    0.0000,    179.8395,
  148.5141,  87.3891,   0.0000,    0.0000,    297.2171,  214.7760,  147.6049,  0.0000,    0.0000,
  279.4727,  201.9744,  138.4353,  0.0000,    0.0000,    220.8830,  161.1115,  112.6680,  0.0000,
  0.0000,    206.6589,  150.7894,  105.3858,  0.0000,    0.0000,    161.7738,  119.7654,  85.9668,
  0.0000,    0.0000,    269.0490,  163.4548,  149.2658,  0.0000,    0.0000,    252.8213,  153.4229,
  139.9877,  0.0000,    0.0000,    200.7817,  124.1920,  114.1335,  0.0000,    0.0000,    187.8203,
  116.1973,  106.7629,  0.0000,    0.0000,    148.0069,  94.1173,   87.3116,   0.0000,    0.0000,
  246.5241,  164.9980,  144.2558,  0.0000,    0.0000,    231.5976,  154.8764,  135.3493,  0.0000,
  0.0000,    184.5477,  125.3625,  110.3639,  0.0000,    0.0000,    172.6395,  117.3051,  103.2775,
  0.0000,    0.0000,    136.7050,  95.0009,   84.5041,   0.0000,    0.0000,    191.9528,  154.3288,
  128.4978,  0.0000,    0.0000,    180.3390,  144.8738,  120.5946,  0.0000,    0.0000,    144.6355,
  117.5524,  98.8903,   0.0000,    0.0000,    135.3716,  110.0255,  92.5983,   0.0000,    0.0000,
  108.2356,  89.4229,   76.3869,   0.0000,    0.0000,    213.4799,  171.2581,  114.0774,  0.0000,
  0.0000,    200.5464,  160.9223,  107.0906,  0.0000,    0.0000,    160.4520,  129.7079,  88.2158,
  0.0000,    0.0000,    150.1398,  121.4381,  82.6496,   0.0000,    0.0000,    119.5995,  97.8417,
  68.6237,   0.0000,    0.0000,    164.1279,  135.5517,  108.0200,  0.0000,    0.0000,    154.1938,
  127.2125,  101.4184,  0.0000,    0.0000,    124.2389,  103.7956,  83.6946,   0.0000,    0.0000,
  116.3247,  97.1744,   78.4368,   0.0000,    0.0000,    93.6269,   79.5750,   65.2905,   0.0000,
  0.0000,    179.2708,  126.9085,  109.2841,  0.0000,    0.0000,    168.3115,  119.1265,  102.6155,
  0.0000,    0.0000,    135.4760,  97.2961,   84.3298,   0.0000,    0.0000,    126.7778,  91.1171,
  79.0279,   0.0000,    0.0000,    101.8194,  74.7287,   65.3949,   0.0000,    0.0000,    166.7111,
  118.0137,  113.9126,  0.0000,    0.0000,    156.5006,  110.7946,  106.9320,  0.0000,    0.0000,
  126.2362,  90.6249,   87.7320,   0.0000,    0.0000,    118.1427,  84.8954,   82.1930,   0.0000,
  0.0000,    95.1612,   69.7730,   67.8363,   0.0000,    0.0000,    138.8758,  113.9993,  0.0000,
  0.0000,    0.0000,    130.5144,  107.0286,  0.0000,    0.0000,    0.0000,    105.3572,  87.4951,
  0.0000,    0.0000,    0.0000,    98.7032,   81.9715,   0.0000,    0.0000,    0.0000,    79.6657,
  67.3070,   0.0000,    0.0000,    0.0000,    147.4138,  113.4369,  0.0000,    0.0000,    0.0000,
  138.3672,  106.4332,  0.0000,    0.0000,    0.0000,    111.9252,  87.2915,   0.0000,    0.0000,
  0.0000,    104.7692,  81.7500,   0.0000,    0.0000,    0.0000,    84.7139,   67.4028,   0.0000,
  0.0000,    0.0000,    183.3368,  175.4585,  143.1602,  123.2705,  0.0000,    172.1229,  164.6812,
  134.3014,  115.6130,  0.0000,    138.2831,  132.6505,  109.2000,  94.7153,   0.0000,    129.3853,
  124.1085,  102.1877,  88.6572,   0.0000,    103.6198,  99.7522,   83.2270,   72.9703,   0.0000,
  171.4367,  160.5876,  155.6083,  141.0407,  128.3113,  160.7910,  150.6040,  145.9274,  132.2562,
  120.3190,  130.0766,  122.2030,  118.5942,  107.9636,  98.6540,   121.6598,  114.3072,  110.9372,
  101.0131,  92.3260,   98.3431,   92.8021,   90.2683,   82.7170,   76.0810,   154.4851,  151.6334,
  147.7519,  142.8348,  0.0000,    144.8462,  142.1737,  138.5349,  133.9240,  0.0000,    118.0337,
  115.9742,  113.1548,  109.5710,  0.0000,    110.4089,  108.4883,  105.8584,  102.5148,  0.0000,
  90.1797,   88.7434,   86.7574,   84.2177,   0.0000,    144.3032,  144.2600,  143.1947,  0.0000,
  0.0000,    135.3122,  135.2720,  134.2742,  0.0000,    0.0000,    110.7747,  110.7711,  110.0087,
  0.0000,    0.0000,    103.6503,  103.6477,  102.9373,  0.0000,    0.0000,    85.2343,   85.2657,
  84.7425,   0.0000,    0.0000,    131.4051,  132.6251,  0.0000,    0.0000,    0.0000,    123.2538,
  124.3958,  0.0000,    0.0000,    0.0000,    101.4216,  102.3489,  0.0000,    0.0000,    0.0000,
  94.9489,   95.8139,   0.0000,    0.0000,    0.0000,    78.6686,   79.3716,   0.0000,    0.0000,
  0.0000,    118.9178,  0.0000,    0.0000,    0.0000,    0.0000,    111.5923,  0.0000,    0.0000,
  0.0000,    0.0000,    92.2876,   0.0000,    0.0000,    0.0000,    0.0000,    86.4581,   0.0000,
  0.0000,    0.0000,    0.0000,    72.1617,   0.0000,    0.0000,    0.0000,    0.0000,    455.6960,
  174.2718,  0.0000,    0.0000,    0.0000,    431.5172,  163.6715,  0.0000,    0.0000,    0.0000,
  333.8130,  132.4662,  0.0000,    0.0000,    0.0000,    313.2347,  123.9803,  0.0000,    0.0000,
  0.0000,    239.2442,  100.4742,  0.0000,    0.0000,    0.0000,    426.3667,  354.8466,  184.3462,
  0.0000,    0.0000,    401.8774,  334.9207,  173.0249,  0.0000,    0.0000,    314.6837,  262.6181,
  140.2904,  0.0000,    0.0000,    294.7168,  246.1256,  131.2676,  0.0000,    0.0000,    228.0556,
  191.2494,  106.5800,  0.0000,    0.0000,    378.7928,  271.4248,  191.9355,  0.0000,    0.0000,
  356.4610,  255.3534,  180.0326,  0.0000,    0.0000,    281.1504,  203.4829,  146.3330,  0.0000,
  0.0000,    263.1381,  190.4785,  136.8686,  0.0000,    0.0000,    205.5407,  151.1411,  111.4633,
  0.0000,    0.0000,    182.2164,  0.0000,    0.0000,    0.0000,    0.0000,    170.9262,  0.0000,
  0.0000,    0.0000,    0.0000,    139.1811,  0.0000,    0.0000,    0.0000,    0.0000,    130.2341,
  0.0000,    0.0000,    0.0000,    0.0000,    106.3035,  0.0000,    0.0000,    0.0000,    0.0000,
  379.1038,  176.8339,  0.0000,    0.0000,    0.0000,    357.1399,  165.8805,  0.0000,    0.0000,
  0.0000,    280.4649,  135.1380,  0.0000,    0.0000,    0.0000,    262.6644,  126.4572,  0.0000,
  0.0000,    0.0000,    204.0039,  103.2933,  0.0000,    0.0000,    0.0000,    364.6519,  173.1933,
  0.0000,    0.0000,    0.0000,    343.4153,  162.4665,  0.0000,    0.0000,    0.0000,    269.9865,
  132.3691,  0.0000,    0.0000,    0.0000,    252.8197,  123.8682,  0.0000,    0.0000,    0.0000,
  196.6165,  101.1917,  0.0000,    0.0000,    0.0000,    355.6712,  167.7968,  0.0000,    0.0000,
  0.0000,    334.9245,  157.4078,  0.0000,    0.0000,    0.0000,    263.3922,  128.3013,  0.0000,
  0.0000,    0.0000,    246.6348,  120.0668,  0.0000,    0.0000,    0.0000,    191.8733,  98.1467,
  0.0000,    0.0000,    0.0000,    347.3921,  168.3507,  0.0000,    0.0000,    0.0000,    327.0991,
  157.9406,  0.0000,    0.0000,    0.0000,    257.3029,  128.5963,  0.0000,    0.0000,    0.0000,
  240.9233,  120.3408,  0.0000,    0.0000,    0.0000,    187.4818,  98.2270,   0.0000,    0.0000,
  0.0000,    340.0580,  161.3933,  0.0000,    0.0000,    0.0000,    320.1657,  151.4713,  0.0000,
  0.0000,    0.0000,    251.9099,  122.9404,  0.0000,    0.0000,    0.0000,    235.8641,  115.0733,
  0.0000,    0.0000,    0.0000,    183.5940,  93.5193,   0.0000,    0.0000,    0.0000,    270.9183,
  169.3159,  0.0000,    0.0000,    0.0000,    254.8122,  158.8301,  0.0000,    0.0000,    0.0000,
  202.2978,  129.2461,  0.0000,    0.0000,    0.0000,    189.3824,  120.9324,  0.0000,    0.0000,
  0.0000,    149.2918,  98.6213,   0.0000,    0.0000,    0.0000,    299.8469,  159.2422,  0.0000,
  0.0000,    0.0000,    282.8547,  149.3811,  0.0000,    0.0000,    0.0000,    222.0934,  121.6899,
  0.0000,    0.0000,    0.0000,    208.1604,  113.8754,  0.0000,    0.0000,    0.0000,    161.9091,
  93.0070,   0.0000,    0.0000,    0.0000,    289.8455,  161.5691,  0.0000,    0.0000,    0.0000,
  273.3375,  151.5963,  0.0000,    0.0000,    0.0000,    214.9399,  123.2619,  0.0000,    0.0000,
  0.0000,    201.4294,  115.3491,  0.0000,    0.0000,    0.0000,    156.9831,  93.9771,   0.0000,
  0.0000,    0.0000,    307.5198,  151.3607,  0.0000,    0.0000,    0.0000,    289.3920,  141.9797,
  0.0000,    0.0000,    0.0000,    228.0857,  115.7612,  0.0000,    0.0000,    0.0000,    213.5146,
  108.3262,  0.0000,    0.0000,    0.0000,    166.5380,  88.5822,   0.0000,    0.0000,    0.0000,
  301.0692,  147.1244,  0.0000,    0.0000,    0.0000,    283.3001,  138.0041,  0.0000,    0.0000,
  0.0000,    223.3166,  112.5588,  0.0000,    0.0000,    0.0000,    209.0416,  105.3302,  0.0000,
  0.0000,    0.0000,    163.0702,  86.1743,   0.0000,    0.0000,    0.0000,    295.3014,  146.1173,
  0.0000,    0.0000,    0.0000,    277.8493,  137.0581,  0.0000,    0.0000,    0.0000,    219.0722,
  111.7498,  0.0000,    0.0000,    0.0000,    205.0594,  104.5694,  0.0000,    0.0000,    0.0000,
  160.0071,  85.5107,   0.0000,    0.0000,    0.0000,    291.6817,  153.2146,  0.0000,    0.0000,
  0.0000,    274.4500,  143.6930,  0.0000,    0.0000,    0.0000,    216.3044,  116.9313,  0.0000,
  0.0000,    0.0000,    202.4669,  109.3879,  0.0000,    0.0000,    0.0000,    157.8890,  89.1915,
  0.0000,    0.0000,    0.0000,    247.9557,  141.3458,  0.0000,    0.0000,    0.0000,    233.1394,
  132.5755,  0.0000,    0.0000,    0.0000,    184.8705,  108.1430,  0.0000,    0.0000,    0.0000,
  173.0176,  101.1905,  0.0000,    0.0000,    0.0000,    136.0882,  82.7986,   0.0000,    0.0000,
  0.0000,    246.6826,  187.9882,  143.4200,  0.0000,    0.0000,    231.6334,  176.5408,  134.5100,
  0.0000,    0.0000,    184.9362,  142.1837,  109.9534,  0.0000,    0.0000,    172.9593,  133.0363,
  102.8724,  0.0000,    0.0000,    137.2924,  107.0183,  84.4451,   0.0000,    0.0000,    226.7159,
  175.6268,  149.3290,  0.0000,    0.0000,    212.8041,  164.8922,  140.1249,  0.0000,    0.0000,
  170.7285,  133.4248,  114.3514,  0.0000,    0.0000,    159.6769,  124.8613,  107.0216,  0.0000,
  0.0000,    127.6207,  101.1019,  87.6809,   0.0000,    0.0000,    192.5984,  161.3287,  139.6713,
  0.0000,    0.0000,    180.8462,  151.4399,  131.0744,  0.0000,    0.0000,    145.7774,  123.1362,
  107.5164,  0.0000,    0.0000,    136.4210,  115.2606,  100.6727,  0.0000,    0.0000,    109.8377,
  93.9601,   83.0805,   0.0000,    0.0000,    196.4073,  162.2579,  127.5271,  0.0000,    0.0000,
  184.3586,  152.3577,  119.7110,  0.0000,    0.0000,    148.8321,  123.4063,  98.6019,   0.0000,
  0.0000,    139.2585,  115.5178,  92.3748,   0.0000,    0.0000,    112.3274,  93.6672,   76.6867,
  0.0000,    0.0000,    179.0563,  144.2494,  120.4752,  0.0000,    0.0000,    168.0477,  135.3783,
  113.1148,  0.0000,    0.0000,    136.2410,  110.8275,  93.4738,   0.0000,    0.0000,    127.5031,
  103.7767,  87.6064,   0.0000,    0.0000,    103.4616,  85.3925,   73.0666,   0.0000,    0.0000,
  164.7586,  136.0069,  122.1088,  0.0000,    0.0000,    154.6248,  127.6665,  114.6749,  0.0000,
  0.0000,    125.8004,  104.7264,  94.4422,   0.0000,    0.0000,    117.7618,  98.0987,   88.5227,
  0.0000,    0.0000,    96.0333,   80.9552,   73.4853,   0.0000,    0.0000,    137.5762,  130.0701,
  128.3281,  0.0000,    0.0000,    129.1835,  122.1108,  120.4733,  0.0000,    0.0000,    105.5920,
  100.3012,  99.1426,   0.0000,    0.0000,    98.9287,   93.9793,   92.9010,   0.0000,    0.0000,
  81.2363,   77.6997,   77.0124,   0.0000,    0.0000,    128.7843,  124.3133,  0.0000,    0.0000,
  0.0000,    120.9485,  116.7335,  0.0000,    0.0000,    0.0000,    99.0454,   95.9227,   0.0000,
  0.0000,    0.0000,    92.8272,   89.9052,   0.0000,    0.0000,    0.0000,    76.4282,   74.3763,
  0.0000,    0.0000,    0.0000,    132.7317,  120.7605,  0.0000,    0.0000,    0.0000,    124.5951,
  113.3605,  0.0000,    0.0000,    0.0000,    102.1266,  93.4628,   0.0000,    0.0000,    0.0000,
  95.6853,   87.5930,   0.0000,    0.0000,    0.0000,    78.8500,   72.7832,   0.0000,    0.0000,
  0.0000,    188.9137,  188.8968,  153.7020,  138.0532,  0.0000,    177.4853,  177.3933,  144.2377,
  129.5334,  0.0000,    143.0720,  143.2496,  117.7589,  106.3656,  0.0000,    133.9718,  134.1084,
  110.2611,  99.6175,   0.0000,    107.8976,  108.2417,  90.3467,   82.2825,   0.0000,    186.2235,
  174.0789,  162.5036,  159.7857,  149.2968,  174.7675,  163.3324,  152.4495,  149.8821,  140.0380,
  141.5746,  132.8283,  124.4398,  122.5321,  114.8824,  132.5017,  124.3208,  116.4811,  114.6932,
  107.5512,  107.3665,  101.2882,  95.3973,   94.1315,   88.7030,   172.7831,  169.8421,  166.1189,
  161.5922,  0.0000,    162.0740,  159.3045,  155.8032,  151.5488,  0.0000,    132.1155,  130.0404,
  127.3832,  124.1305,  0.0000,    123.6424,  121.7014,  119.2179,  116.1790,  0.0000,    101.0571,
  99.6679,   97.8517,   95.6018,   0.0000,    165.7327,  165.9180,  165.3751,  0.0000,    0.0000,
  155.4506,  155.6188,  155.1060,  0.0000,    0.0000,    127.1952,  127.3976,  127.0566,  0.0000,
  0.0000,    119.0531,  119.2401,  118.9208,  0.0000,    0.0000,    97.8332,   98.0575,   97.8817,
  0.0000,    0.0000,    153.9883,  155.8682,  0.0000,    0.0000,    0.0000,    144.4532,  146.2118,
  0.0000,    0.0000,    0.0000,    118.7550,  120.1967,  0.0000,    0.0000,    0.0000,    111.1930,
  112.5373,  0.0000,    0.0000,    0.0000,    91.9990,   93.1069,   0.0000,    0.0000,    0.0000,
  141.9946,  0.0000,    0.0000,    0.0000,    0.0000,    133.2432,  0.0000,    0.0000,    0.0000,
  0.0000,    110.0314,  0.0000,    0.0000,    0.0000,    0.0000,    103.0788,  0.0000,    0.0000,
  0.0000,    0.0000,    85.8432,   0.0000,    0.0000,    0.0000,    0.0000,    434.1967,  196.4082,
  0.0000,    0.0000,    0.0000,    410.5860,  184.4431,  0.0000,    0.0000,    0.0000,    319.5738,
  149.3279,  0.0000,    0.0000,    0.0000,    299.7237,  139.7510,  0.0000,    0.0000,    0.0000,
  230.7554,  113.3031,  0.0000,    0.0000,    0.0000,    424.1613,  355.4860,  203.1255,  0.0000,
  0.0000,    399.5225,  335.1671,  190.6507,  0.0000,    0.0000,    314.0948,  264.0525,  154.6561,
  0.0000,    0.0000,    294.0959,  247.3730,  144.7067,  0.0000,    0.0000,    228.8220,  193.3777,
  117.5821,  0.0000,    0.0000,    378.6672,  209.1858,  0.0000,    0.0000,    0.0000,    356.1127,
  196.2138,  0.0000,    0.0000,    0.0000,    281.8509,  159.7830,  0.0000,    0.0000,    0.0000,
  263.7570,  149.4998,  0.0000,    0.0000,    0.0000,    206.9466,  122.0402,  0.0000,    0.0000,
  0.0000,    344.3576,  239.2120,  0.0000,    0.0000,    0.0000,    323.4959,  224.5876,  0.0000,
  0.0000,    0.0000,    258.1487,  181.8224,  0.0000,    0.0000,    0.0000,    241.5305,  170.1710,
  0.0000,    0.0000,    0.0000,    191.6443,  137.8768,  0.0000,    0.0000,    0.0000,    339.9863,
  214.6505,  0.0000,    0.0000,    0.0000,    319.6761,  201.5799,  0.0000,    0.0000,    0.0000,
  254.2685,  163.6694,  0.0000,    0.0000,    0.0000,    238.0151,  153.2403,  0.0000,    0.0000,
  0.0000,    188.0965,  124.7098,  0.0000,    0.0000,    0.0000,    329.2802,  191.0223,  0.0000,
  0.0000,    0.0000,    309.6082,  179.2561,  0.0000,    0.0000,    0.0000,    246.3297,  146.2506,
  0.0000,    0.0000,    0.0000,    230.5946,  136.9221,  0.0000,    0.0000,    0.0000,    182.3009,
  112.0980,  0.0000,    0.0000,    0.0000,    336.4627,  184.1095,  0.0000,    0.0000,    0.0000,
  316.5967,  172.7592,  0.0000,    0.0000,    0.0000,    250.6938,  141.1191,  0.0000,    0.0000,
  0.0000,    234.7566,  132.1270,  0.0000,    0.0000,    0.0000,    184.3778,  108.3454,  0.0000,
  0.0000,    0.0000,    326.2500,  217.0925,  0.0000,    0.0000,    0.0000,    306.9303,  204.0310,
  0.0000,    0.0000,    0.0000,    243.2478,  164.5053,  0.0000,    0.0000,    0.0000,    227.7683,
  154.0713,  0.0000,    0.0000,    0.0000,    179.0837,  124.1824,  0.0000,    0.0000,    0.0000,
  25.2685,   23.6295,   22.2794,   19.7707,   0.0000,    23.6295,   22.1241,   20.8501,   18.5180,
  0.0000,    22.2794,   20.8501,   19.6768,   17.4928,   0.0000,    19.7707,   18.5180,   17.4928,
  15.5817,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    19.6546,   17.7698,
  15.8364,   0.0000,    0.0000,    18.4128,   16.6775,   14.8600,   0.0000,    0.0000,    17.4093,
  15.7631,   14.0807,   0.0000,    0.0000,    15.5249,   14.0793,   12.6077,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    15.2418,   12.7107,   0.0000,    0.0000,
  0.0000,    14.3015,   11.9470,   0.0000,    0.0000,    0.0000,    13.5613,   11.3571,   0.0000,
  0.0000,    0.0000,    12.1511,   10.2214,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    11.9479,   0.0000,    0.0000,    0.0000,    0.0000,    11.2243,
  0.0000,    0.0000,    0.0000,    0.0000,    10.6740,   0.0000,    0.0000,    0.0000,    0.0000,
  9.6050,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    130.6563,  58.4853,   0.0000,    0.0000,    0.0000,    121.9601,  54.4454,   0.0000,
  0.0000,    0.0000,    113.3031,  50.8672,   0.0000,    0.0000,    0.0000,    98.8806,   44.4924,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    107.6150,
  89.9646,   61.8372,   0.0000,    0.0000,    100.1443,  83.7703,   57.5398,   0.0000,    0.0000,
  93.4130,   78.1760,   53.8803,   0.0000,    0.0000,    81.5352,   68.3141,   47.2059,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    102.2000,  93.3542,   74.6117,
  59.9074,   0.0000,    95.0916,   86.8728,   69.4501,   55.7793,   0.0000,    88.8407,   81.2026,
  65.0164,   52.3136,   0.0000,    77.6520,   71.0231,   56.9713,   45.9399,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    83.8498,   78.0190,   73.0073,   70.9761,   59.9319,
  78.0466,   72.6373,   67.9820,   66.1052,   55.8394,   73.0858,   68.0504,   63.7151,   61.9530,
  52.4136,   64.0576,   59.6887,   55.9197,   54.3857,   46.1031,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    67.7873,   65.9127,   64.9209,   60.7663,   0.0000,    63.1669,   61.4286,
  60.5085,   56.6508,   0.0000,    59.2859,   57.6632,   56.7981,   53.2076,   0.0000,    52.1509,
  50.7398,   49.9818,   46.8635,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  57.6734,   57.0255,   55.9136,   0.0000,    0.0000,    53.8107,   53.2086,   52.1753,   0.0000,
  0.0000,    50.5946,   50.0298,   49.0629,   0.0000,    0.0000,    44.6529,   44.1581,   43.3130,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    48.2624,   47.7540,
  0.0000,    0.0000,    0.0000,    45.0952,   44.6217,   0.0000,    0.0000,    0.0000,    42.4816,
  42.0367,   0.0000,    0.0000,    0.0000,    37.6295,   37.2381,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    40.3435,   0.0000,    0.0000,    0.0000,
  0.0000,    37.7522,   0.0000,    0.0000,    0.0000,    0.0000,    35.6334,   0.0000,    0.0000,
  0.0000,    0.0000,    31.6804,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    213.2001,  83.2153,   0.0000,    0.0000,    0.0000,    199.4405,
  77.6317,   0.0000,    0.0000,    0.0000,    185.2181,  72.6818,   0.0000,    0.0000,    0.0000,
  162.0160,  63.8686,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    184.5498,  148.9793,  87.1906,   0.0000,    0.0000,    172.0455,  139.0219,  81.2525,
  0.0000,    0.0000,    160.2750,  129.5841,  76.1365,   0.0000,    0.0000,    140.0273,  113.4161,
  66.8706,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    154.2947,
  85.3404,   85.0464,   0.0000,    0.0000,    143.7658,  79.5383,   79.2586,   0.0000,    0.0000,
  134.0314,  74.5587,   74.3297,   0.0000,    0.0000,    117.1112,  65.5203,   65.3415,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    151.0199,  82.5834,   86.2109,
  0.0000,    0.0000,    140.7115,  76.9834,   80.3464,   0.0000,    0.0000,    131.3015,  72.1828,
  75.3609,   0.0000,    0.0000,    114.8256,  63.4645,   66.2607,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    139.3512,  80.9144,   78.9761,   0.0000,    0.0000,
  129.8297,  75.4303,   73.6275,   0.0000,    0.0000,    121.2119,  70.7347,   69.0809,   0.0000,
  0.0000,    106.0489,  62.2020,   60.7834,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    110.4861,  79.9024,   61.2471,   0.0000,    0.0000,    103.0189,  74.4890,
  57.1766,   0.0000,    0.0000,    96.2547,   69.8471,   53.7726,   0.0000,    0.0000,    84.3631,
  61.4202,   47.5033,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  121.3233,  74.6998,   53.2828,   0.0000,    0.0000,    113.0248,  69.6215,   49.7698,   0.0000,
  0.0000,    105.6080,  65.3415,   46.8681,   0.0000,    0.0000,    92.4636,   57.4915,   41.4862,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    95.9782,   69.5638,
  52.2028,   0.0000,    0.0000,    89.4868,   64.8468,   48.7558,   0.0000,    0.0000,    83.6916,
  60.8920,   45.9140,   0.0000,    0.0000,    73.4185,   53.6171,   40.6376,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    102.7503,  66.4218,   59.5628,   53.9695,
  0.0000,    95.7051,   61.9256,   55.5685,   50.3814,   0.0000,    89.5345,   58.1611,   52.2322,
  47.4168,   0.0000,    78.4696,   51.2318,   46.0841,   41.9193,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    104.9834,  64.8519,   55.8954,   57.8469,   0.0000,    97.7761,
  60.4608,   52.1532,   53.9690,   0.0000,    91.4295,   56.7868,   49.0511,   50.7198,   0.0000,
  80.0853,   50.0218,   43.3096,   44.7442,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    81.0855,   63.2709,   0.0000,    0.0000,    0.0000,    75.5987,   58.9903,   0.0000,
  0.0000,    0.0000,    70.7639,   55.3789,   0.0000,    0.0000,    0.0000,    62.1299,   48.7630,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    84.7311,
  60.7331,   0.0000,    0.0000,    0.0000,    78.9183,   56.6140,   0.0000,    0.0000,    0.0000,
  73.9210,   53.2070,   0.0000,    0.0000,    0.0000,    64.8633,   46.8911,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    99.4407,   94.1329,   76.6641,
  64.3977,   0.0000,    92.6025,   87.6645,   71.4234,   60.0229,   0.0000,    86.6194,   82.0402,
  66.9550,   56.3612,   0.0000,    75.8800,   71.9079,   58.8126,   49.6159,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    90.3328,   85.1621,   81.5019,   73.9675,   66.3293,
  84.1276,   79.3278,   75.9287,   68.9323,   61.8399,   78.8235,   74.3627,   71.2017,   64.6946,
  58.0974,   69.1710,   65.3041,   62.5609,   56.9134,   51.1874,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    79.3086,   78.1138,   76.2992,   73.8246,   0.0000,    73.9142,   72.8073,
  71.1238,   68.8264,   0.0000,    69.3770,   68.3477,   66.7818,   64.6446,   0.0000,    61.0425,
  60.1519,   58.7945,   56.9398,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  72.5403,   72.5567,   72.0328,   0.0000,    0.0000,    67.6636,   67.6796,   67.1936,   0.0000,
  0.0000,    63.5919,   63.6074,   63.1549,   0.0000,    0.0000,    56.0812,   56.0962,   55.7037,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    64.7632,   65.1543,
  0.0000,    0.0000,    0.0000,    60.4728,   60.8359,   0.0000,    0.0000,    0.0000,    56.9187,
  57.2578,   0.0000,    0.0000,    0.0000,    50.3344,   50.6298,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    57.3895,   0.0000,    0.0000,    0.0000,
  0.0000,    53.6496,   0.0000,    0.0000,    0.0000,    0.0000,    50.5746,   0.0000,    0.0000,
  0.0000,    0.0000,    44.8546,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    240.6940,  100.1418,  0.0000,    0.0000,    0.0000,    225.1919,
  93.4584,   0.0000,    0.0000,    0.0000,    209.2378,  87.5447,   0.0000,    0.0000,    0.0000,
  183.1486,  77.0040,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    219.9608,  181.1973,  104.9004,  0.0000,    0.0000,    205.1574,  169.1772,  97.8085,
  0.0000,    0.0000,    191.1268,  157.6836,  91.6725,   0.0000,    0.0000,    167.0865,  138.0927,
  80.5868,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    197.0611,
  144.9207,  102.8479,  0.0000,    0.0000,    183.6851,  135.1839,  95.8897,   0.0000,    0.0000,
  171.3574,  126.3470,  89.9626,   0.0000,    0.0000,    149.8906,  110.8238,  79.1550,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    179.7777,  112.9339,  104.3380,
  0.0000,    0.0000,    167.5501,  105.3151,  97.2881,   0.0000,    0.0000,    156.4540,  98.7165,
  91.3072,   0.0000,    0.0000,    136.9578,  86.8035,   80.3758,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    165.6943,  113.9989,  100.9460,  0.0000,    0.0000,
  154.4356,  106.3141,  94.1631,   0.0000,    0.0000,    144.3122,  99.6625,   88.3944,   0.0000,
  0.0000,    126.4307,  87.6504,   77.8681,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    130.6045,  107.1304,  90.9043,   0.0000,    0.0000,    121.8066,  99.9381,
  84.8582,   0.0000,    0.0000,    114.0004,  93.7434,   79.7672,   0.0000,    0.0000,    100.1080,
  82.5251,   70.4244,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  144.5697,  117.6479,  81.4217,   0.0000,    0.0000,    134.7887,  109.7755,  76.0532,   0.0000,
  0.0000,    126.0801,  102.8506,  71.5723,   0.0000,    0.0000,    110.6119,  90.4660,   63.3081,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    112.6378,  95.0190,
  77.3772,   0.0000,    0.0000,    105.0905,  88.6613,   72.2950,   0.0000,    0.0000,    98.4728,
  83.2744,   68.0720,   0.0000,    0.0000,    86.6163,   73.4259,   60.2641,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    122.6426,  89.1659,   77.7074,   0.0000,
  0.0000,    114.3496,  83.2227,   72.5863,   0.0000,    0.0000,    107.1084,  78.1976,   68.3029,
  0.0000,    0.0000,    94.1007,   69.0005,   60.4149,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    114.4763,  83.1710,   80.7118,   0.0000,    0.0000,    106.7438,
  77.6479,   75.3636,   0.0000,    0.0000,    100.0370,  72.9965,   70.8909,   0.0000,    0.0000,
  87.9430,   64.4651,   62.6532,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    95.7137,   80.2663,   0.0000,    0.0000,    0.0000,    89.3419,   74.9354,   0.0000,
  0.0000,    0.0000,    83.7875,   70.4509,   0.0000,    0.0000,    0.0000,    73.8057,   62.2209,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    101.7377,
  80.2492,   0.0000,    0.0000,    0.0000,    94.8770,   74.8925,   0.0000,    0.0000,    0.0000,
  88.9858,   70.4420,   0.0000,    0.0000,    0.0000,    78.3016,   62.2131,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    124.9798,  120.1279,  99.6435,
  86.9569,   0.0000,    116.4959,  111.9707,  92.9086,   81.1110,   0.0000,    109.0825,  104.8972,
  87.2076,   76.2530,   0.0000,    95.7727,   92.1403,   76.7798,   67.2704,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    118.1509,  111.2768,  108.1299,  98.8025,   90.6184,
  110.0951,  103.7070,  100.7826,  92.1154,   84.5138,   103.2113,  97.2826,   94.5696,   86.5174,
  79.4522,   90.6876,   85.5479,   83.1968,   76.2100,   70.0800,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    107.8436,  106.0538,  103.5908,  100.4500,  0.0000,    100.5182,  98.8583,
  96.5724,   93.6562,   0.0000,    94.3654,   92.8262,   90.7043,   87.9958,   0.0000,    83.0577,
  81.7279,   79.8912,   77.5440,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  101.6124,  101.6315,  100.9745,  0.0000,    0.0000,    94.7508,   94.7705,   94.1622,   0.0000,
  0.0000,    89.0359,   89.0582,   88.4953,   0.0000,    0.0000,    78.4819,   78.5067,   78.0224,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    93.4562,   94.2991,
  0.0000,    0.0000,    0.0000,    87.2028,   87.9869,   0.0000,    0.0000,    0.0000,    82.0374,
  82.7713,   0.0000,    0.0000,    0.0000,    72.4531,   73.0954,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    85.4293,   0.0000,    0.0000,    0.0000,
  0.0000,    79.7773,   0.0000,    0.0000,    0.0000,    0.0000,    75.1427,   0.0000,    0.0000,
  0.0000,    0.0000,    66.5081,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    294.1483,  120.4982,  0.0000,    0.0000,    0.0000,    275.2567,
  112.4278,  0.0000,    0.0000,    0.0000,    255.7499,  105.3726,  0.0000,    0.0000,    0.0000,
  223.9076,  92.7050,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    279.0742,  233.5006,  127.7419,  0.0000,    0.0000,    260.4481,  218.1596,  119.1434,
  0.0000,    0.0000,    242.5528,  203.2396,  111.7057,  0.0000,    0.0000,    212.1297,  178.0536,
  98.2670,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    250.5577,
  182.9391,  133.4410,  0.0000,    0.0000,    233.6619,  170.6938,  124.4124,  0.0000,    0.0000,
  217.8948,  159.4968,  116.6803,  0.0000,    0.0000,    190.6370,  139.9128,  102.6251,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    127.1355,  0.0000,    0.0000,
  0.0000,    0.0000,    118.5470,  0.0000,    0.0000,    0.0000,    0.0000,    111.2827,  0.0000,
  0.0000,    0.0000,    0.0000,    97.9882,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    249.2633,  123.4955,  0.0000,    0.0000,    0.0000,
  232.5783,  115.1605,  0.0000,    0.0000,    0.0000,    216.7820,  108.1159,  0.0000,    0.0000,
  0.0000,    189.7084,  95.2178,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    240.1139,  120.9759,  0.0000,    0.0000,    0.0000,    224.0040,  112.8134,
  0.0000,    0.0000,    0.0000,    208.8357,  105.9150,  0.0000,    0.0000,    0.0000,    182.7560,
  93.2841,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  234.2913,  117.3026,  0.0000,    0.0000,    0.0000,    218.5611,  109.3944,  0.0000,    0.0000,
  0.0000,    203.7729,  102.7150,  0.0000,    0.0000,    0.0000,    178.3241,  90.4807,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    228.9065,  117.4740,
  0.0000,    0.0000,    0.0000,    213.5277,  109.5523,  0.0000,    0.0000,    0.0000,    199.0885,
  102.8398,  0.0000,    0.0000,    0.0000,    174.2214,  90.5682,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    224.1383,  112.0512,  0.0000,    0.0000,
  0.0000,    209.0700,  104.5097,  0.0000,    0.0000,    0.0000,    194.9397,  98.0628,   0.0000,
  0.0000,    0.0000,    170.5870,  86.3386,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    181.2581,  117.9977,  0.0000,    0.0000,    0.0000,    169.0556,
  110.0265,  0.0000,    0.0000,    0.0000,    157.9221,  103.2648,  0.0000,    0.0000,    0.0000,
  138.4298,  90.9100,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    197.6234,  111.2043,  0.0000,    0.0000,    0.0000,    184.5904,  103.7034,  0.0000,
  0.0000,    0.0000,    172.0857,  97.3591,   0.0000,    0.0000,    0.0000,    150.8204,  85.7475,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    191.4550,
  112.4836,  0.0000,    0.0000,    0.0000,    178.8074,  104.8991,  0.0000,    0.0000,    0.0000,
  166.7356,  98.4445,   0.0000,    0.0000,    0.0000,    146.1445,  86.6740,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    203.1554,  105.8582,  0.0000,
  0.0000,    0.0000,    189.4531,  98.7212,   0.0000,    0.0000,    0.0000,    176.7026,  92.6939,
  0.0000,    0.0000,    0.0000,    154.6287,  81.6520,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    198.9185,  102.9588,  0.0000,    0.0000,    0.0000,
  185.4931,  96.0193,   0.0000,    0.0000,    0.0000,    173.0120,  90.1627,   0.0000,    0.0000,
  0.0000,    151.3924,  79.4291,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    195.1630,  102.1888,  0.0000,    0.0000,    0.0000,    181.9823,  95.2979,
  0.0000,    0.0000,    0.0000,    169.7429,  89.4774,   0.0000,    0.0000,    0.0000,    148.5273,
  78.8150,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  192.6324,  106.7340,  0.0000,    0.0000,    0.0000,    179.6202,  99.5059,   0.0000,    0.0000,
  0.0000,    167.5247,  93.3808,   0.0000,    0.0000,    0.0000,    146.5709,  82.1806,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    165.4184,  98.9223,
  0.0000,    0.0000,    0.0000,    154.2292,  92.2512,   0.0000,    0.0000,    0.0000,    144.0208,
  86.6202,   0.0000,    0.0000,    0.0000,    126.1445,  76.3004,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    166.2472,  128.7982,  100.7419,  0.0000,
  0.0000,    154.9102,  120.1068,  93.9569,   0.0000,    0.0000,    144.7985,  112.4717,  88.2333,
  0.0000,    0.0000,    126.8521,  98.8025,   77.7379,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    154.0696,  121.3232,  104.6769,  0.0000,    0.0000,    143.5763,
  113.1600,  97.6568,   0.0000,    0.0000,    134.3399,  106.0746,  91.6935,   0.0000,    0.0000,
  117.8208,  93.3008,   80.8052,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    132.1410,  112.4138,  98.8541,   0.0000,    0.0000,    123.2302,  104.8796,  92.2761,
  0.0000,    0.0000,    115.4406,  98.4199,   86.7443,   0.0000,    0.0000,    101.4561,  86.6909,
  76.5852,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    135.0406,
  112.3265,  90.9958,   0.0000,    0.0000,    125.9121,  104.7918,  84.9906,   0.0000,    0.0000,
  117.9845,  98.2720,   79.9790,   0.0000,    0.0000,    103.6967,  86.4983,   70.7353,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    124.0510,  101.7420,  86.5150,
  0.0000,    0.0000,    115.6938,  94.9612,   80.8414,   0.0000,    0.0000,    108.5136,  89.2508,
  76.1365,   0.0000,    0.0000,    95.4919,   78.7735,   67.4272,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    114.8874,  96.3243,   87.1907,   0.0000,    0.0000,
  107.1775,  89.9357,   81.4686,   0.0000,    0.0000,    100.6104,  84.5790,   76.6936,   0.0000,
  0.0000,    88.6413,   74.7269,   67.8885,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    96.8658,   92.3710,   91.4441,   0.0000,    0.0000,    90.4456,   86.2655,
  85.4113,   0.0000,    0.0000,    85.0197,   81.1635,   80.3878,   0.0000,    0.0000,    75.0883,
  71.7624,   71.1120,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  91.0210,   88.3915,   0.0000,    0.0000,    0.0000,    85.0146,   82.5698,   0.0000,    0.0000,
  0.0000,    79.9625,   77.7115,   0.0000,    0.0000,    0.0000,    70.6910,   68.7538,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    93.8836,   86.3382,
  0.0000,    0.0000,    0.0000,    87.6490,   80.6471,   0.0000,    0.0000,    0.0000,    82.4540,
  75.9482,   0.0000,    0.0000,    0.0000,    72.8677,   67.2293,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    129.7759,  130.0791,  107.8602,  97.8835,
  0.0000,    121.0800,  121.3356,  100.6388,  91.3606,   0.0000,    113.4882,  113.7563,  94.5619,
  85.9468,   0.0000,    99.8545,   100.0870,  83.4095,   75.9304,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    128.8243,  121.2408,  113.9262,  112.3115,  105.6030,  120.1268,
  113.0674,  106.2635,  104.7587,  98.5247,   112.6829,  106.1418,  99.8294,   98.4421,   92.6508,
  99.1557,   93.4821,   88.0052,   86.8061,   81.7810,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    120.7993,  119.0347,  116.7503,  113.9364,  0.0000,    112.6485,  111.0078,  108.8847,
  106.2696,  0.0000,    105.7911,  104.2768,  102.3126,  99.8902,   0.0000,    93.2029,   91.8965,
  90.1990,   88.1027,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    116.6615,
  116.8921,  116.6366,  0.0000,    0.0000,    108.8134,  109.0287,  108.7927,  0.0000,    0.0000,
  102.2646,  102.4740,  102.2624,  0.0000,    0.0000,    90.1853,   90.3760,   90.2005,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    109.3618,  110.6820,  0.0000,
  0.0000,    0.0000,    102.0524,  103.2804,  0.0000,    0.0000,    0.0000,    96.0071,   97.1579,
  0.0000,    0.0000,    0.0000,    84.7991,   85.8075,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    101.7340,  0.0000,    0.0000,    0.0000,    0.0000,
  94.9928,   0.0000,    0.0000,    0.0000,    0.0000,    89.4589,   0.0000,    0.0000,    0.0000,
  0.0000,    79.1555,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    282.7763,  135.8619,  0.0000,    0.0000,    0.0000,    264.4430,  126.7534,
  0.0000,    0.0000,    0.0000,    246.0048,  118.8019,  0.0000,    0.0000,    0.0000,    215.4634,
  104.5128,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  279.3602,  235.5160,  140.8773,  0.0000,    0.0000,    260.6529,  219.9373,  131.3980,  0.0000,
  0.0000,    242.9272,  205.0788,  123.1997,  0.0000,    0.0000,    212.5524,  179.7161,  108.3849,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    251.8086,  145.9537,
  0.0000,    0.0000,    0.0000,    234.7652,  136.0895,  0.0000,    0.0000,    0.0000,    219.1064,
  127.7412,  0.0000,    0.0000,    0.0000,    191.7954,  112.4669,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    232.0723,  165.4117,  0.0000,    0.0000,
  0.0000,    216.3074,  154.2679,  0.0000,    0.0000,    0.0000,    202.2394,  144.6629,  0.0000,
  0.0000,    0.0000,    177.2887,  127.2819,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    228.1333,  149.3047,  0.0000,    0.0000,    0.0000,    212.7456,
  139.3121,  0.0000,    0.0000,    0.0000,    198.8169,  130.7332,  0.0000,    0.0000,    0.0000,
  174.3207,  115.1751,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    221.0659,  133.8723,  0.0000,    0.0000,    0.0000,    206.1631,  124.8931,  0.0000,
  0.0000,    0.0000,    192.6840,  117.3247,  0.0000,    0.0000,    0.0000,    168.9680,  103.4489,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    224.2094,
  129.3004,  0.0000,    0.0000,    0.0000,    209.1524,  120.6357,  0.0000,    0.0000,    0.0000,
  195.3222,  113.3581,  0.0000,    0.0000,    0.0000,    171.2063,  99.9878,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    217.6765,  149.2917,  0.0000,
  0.0000,    0.0000,    203.0418,  139.3230,  0.0000,    0.0000,    0.0000,    189.6469,  130.5975,
  0.0000,    0.0000,    0.0000,    166.2420,  114.9538,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    15.5059,   14.0764,   12.6277,   0.0000,    0.0000,
  14.0764,   12.8161,   11.5009,   0.0000,    0.0000,    12.6277,   11.5009,   10.3708,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    12.1834,   10.2867,   0.0000,    0.0000,    0.0000,    11.0994,   9.4048,
  0.0000,    0.0000,    0.0000,    10.0222,   8.5397,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  9.6606,    0.0000,    0.0000,    0.0000,    0.0000,    8.8252,    0.0000,    0.0000,    0.0000,
  0.0000,    8.0175,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    93.0263,   42.8911,
  0.0000,    0.0000,    0.0000,    82.1820,   38.1227,   0.0000,    0.0000,    0.0000,    71.0999,
  33.2636,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    78.2250,   65.7609,   46.0347,   0.0000,
  0.0000,    69.3675,   58.4303,   41.0605,   0.0000,    0.0000,    60.2983,   50.8669,   35.9665,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    75.0755,   68.7983,   55.5250,   45.0876,   0.0000,    66.7451,
  61.2175,   49.5319,   40.3374,   0.0000,    58.1951,   53.4365,   43.3788,   35.4602,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    62.5349,   58.3557,   54.7443,   53.2061,   45.3688,   55.8175,   52.1311,   48.9391,
  47.5664,   40.6635,   48.9066,   45.7273,   42.9679,   41.7687,   35.8247,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    51.3098,
  49.9374,   49.1729,   46.1927,   0.0000,    45.9937,   44.7770,   44.0904,   41.4600,   0.0000,
  40.5167,   39.4617,   38.8578,   36.5875,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    44.1470,   43.6548,   42.8245,
  0.0000,    0.0000,    39.7091,   39.2683,   38.5276,   0.0000,    0.0000,    35.1377,   34.7510,
  34.1042,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    37.3688,   36.9783,   0.0000,    0.0000,    0.0000,
  33.7313,   33.3801,   0.0000,    0.0000,    0.0000,    29.9918,   29.6822,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    31.5783,   0.0000,    0.0000,    0.0000,    0.0000,    28.6000,   0.0000,
  0.0000,    0.0000,    0.0000,    25.5514,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  152.1420,  61.9948,   0.0000,    0.0000,    0.0000,    134.6508,  55.4032,   0.0000,    0.0000,
  0.0000,    116.7069,  48.6380,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    133.3847,  108.2718,
  65.2525,   0.0000,    0.0000,    118.2411,  96.1584,   58.3423,   0.0000,    0.0000,    102.7126,
  83.7279,   51.2425,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    111.9359,  64.0072,   63.9839,   0.0000,
  0.0000,    99.2939,   57.2611,   57.2805,   0.0000,    0.0000,    86.3365,   50.3373,   50.3920,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    110.1452,  62.0309,   64.9037,   0.0000,    0.0000,    97.8345,
  55.5160,   58.1127,   0.0000,    0.0000,    85.2219,   48.8396,   51.1410,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    101.9325,  60.7933,   59.5445,   0.0000,    0.0000,    90.6007,   54.4109,   53.3400,
  0.0000,    0.0000,    79.0003,   47.8815,   46.9875,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    81.2000,
  59.9829,   46.8138,   0.0000,    0.0000,    72.2872,   53.6733,   42.1046,   0.0000,    0.0000,
  63.1867,   47.2297,   37.3024,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    89.1346,   56.3622,   41.0237,
  0.0000,    0.0000,    79.3047,   50.4858,   36.9692,   0.0000,    0.0000,    69.2598,   44.4888,
  32.8495,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    70.8942,   52.6351,   40.1709,   0.0000,    0.0000,
  63.1865,   47.1816,   36.1919,   0.0000,    0.0000,    55.3356,   41.6270,   32.1584,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    75.9912,   50.3016,   45.3066,   41.3623,   0.0000,    67.7117,   45.1002,
  40.6799,   37.2178,   0.0000,    59.2688,   39.8131,   35.9892,   33.0215,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  77.4010,   49.0996,   42.6462,   43.9161,   0.0000,    68.9086,   44.0173,   38.3194,   39.4125,
  0.0000,    60.2575,   38.8597,   33.9427,   34.8596,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    60.1335,   47.7239,
  0.0000,    0.0000,    0.0000,    53.6420,   42.7458,   0.0000,    0.0000,    0.0000,    47.0585,
  37.7083,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    63.0774,   46.1355,   0.0000,    0.0000,
  0.0000,    56.2884,   41.3862,   0.0000,    0.0000,    0.0000,    49.3897,   36.5764,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    73.6253,   69.9039,   57.5425,   48.8310,   0.0000,    65.6214,
  62.3522,   51.4705,   43.7962,   0.0000,    57.4016,   54.5964,   45.2336,   38.6263,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    67.5932,   63.9245,   61.3099,   55.9314,   50.4741,   60.4041,   57.1752,   54.8693,
  50.1269,   45.3141,   53.0110,   50.2343,   48.2476,   44.1611,   40.0132,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    60.0289,
  59.1764,   57.8784,   56.1057,   0.0000,    53.8153,   53.0645,   51.9199,   50.3555,   0.0000,
  47.4202,   46.7753,   45.7899,   44.4417,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    55.3627,   55.3752,   54.9943,
  0.0000,    0.0000,    49.7552,   49.7665,   49.4291,   0.0000,    0.0000,    43.9819,   43.9931,
  43.7022,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    49.8795,   50.1632,   0.0000,    0.0000,    0.0000,
  44.9510,   45.2019,   0.0000,    0.0000,    0.0000,    39.8821,   40.1002,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    44.6003,   0.0000,    0.0000,    0.0000,    0.0000,    40.3043,   0.0000,
  0.0000,    0.0000,    0.0000,    35.8961,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  172.3398,  74.8868,   0.0000,    0.0000,    0.0000,    152.6757,  67.0045,   0.0000,    0.0000,
  0.0000,    132.4879,  58.9015,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    159.1460,  131.7846,
  78.6933,   0.0000,    0.0000,    141.1592,  117.1018,  70.4285,   0.0000,    0.0000,    122.6928,
  102.0116,  61.9159,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    143.6602,  107.0438,  77.6335,   0.0000,
  0.0000,    127.6282,  95.4458,   69.5806,   0.0000,    0.0000,    111.1606,  83.5108,   61.2796,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    131.7852,  84.7876,   78.9339,   0.0000,    0.0000,    117.2328,
  75.8994,   70.7865,   0.0000,    0.0000,    102.2836,  66.7498,   62.3893,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    121.9868,  85.6024,   76.4658,   0.0000,    0.0000,    108.6378,  76.6347,   68.6087,
  0.0000,    0.0000,    94.9281,   67.4128,   60.5217,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    97.0675,
  80.7360,   69.4181,   0.0000,    0.0000,    86.6803,   72.3520,   62.4324,   0.0000,    0.0000,
  76.0239,   63.7402,   55.2484,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    107.0588,  88.0609,   62.5886,
  0.0000,    0.0000,    95.4966,   78.7920,   56.3962,   0.0000,    0.0000,    83.6409,   69.2838,
  50.0406,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    84.2725,   72.1173,   59.6460,   0.0000,    0.0000,
  75.3910,   64.7448,   53.7863,   0.0000,    0.0000,    66.3025,   57.1928,   47.7847,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    91.4959,   67.8114,   59.6194,   0.0000,    0.0000,    81.7640,   60.9159,
  53.6934,   0.0000,    0.0000,    71.8071,   53.8670,   47.6422,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  85.6427,   63.4125,   61.7619,   0.0000,    0.0000,    76.5871,   57.0049,   55.5744,   0.0000,
  0.0000,    67.3354,   50.4709,   49.2629,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    71.8926,   61.1748,
  0.0000,    0.0000,    0.0000,    64.3880,   54.9856,   0.0000,    0.0000,    0.0000,    56.7511,
  48.6912,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    76.4092,   61.3234,   0.0000,    0.0000,
  0.0000,    68.3943,   55.1392,   0.0000,    0.0000,    0.0000,    60.2334,   48.8497,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    92.9968,   89.6520,   75.2351,   66.2741,   0.0000,    83.0278,
  80.0986,   67.4193,   59.5344,   0.0000,    72.8571,   70.3511,   59.4511,   52.6690,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    88.5408,   83.7120,   81.5058,   74.9029,   69.0939,   79.1704,   74.9289,   72.9923,
  67.1811,   62.0665,   69.6046,   65.9635,   64.3022,   59.3029,   54.9005,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    81.5358,
  80.2899,   78.5600,   76.3424,   0.0000,    73.0718,   71.9816,   70.4634,   68.5141,   0.0000,
  64.4291,   63.4972,   62.1954,   60.5209,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    77.2970,   77.3365,   76.8863,
  0.0000,    0.0000,    69.3901,   69.4317,   69.0399,   0.0000,    0.0000,    61.3159,   61.3585,
  61.0258,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    71.6059,   72.2358,   0.0000,    0.0000,    0.0000,
  64.4141,   64.9764,   0.0000,    0.0000,    0.0000,    57.0738,   57.5655,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    65.9403,   0.0000,    0.0000,    0.0000,    0.0000,    59.4468,   0.0000,
  0.0000,    0.0000,    0.0000,    52.8269,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  210.8672,  90.5303,   0.0000,    0.0000,    0.0000,    186.8791,  81.0845,   0.0000,    0.0000,
  0.0000,    162.2001,  71.3269,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    201.7411,  169.6030,
  96.0950,   0.0000,    0.0000,    178.9549,  150.7056,  86.0773,   0.0000,    0.0000,    155.5437,
  131.2633,  75.7417,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    182.4075,  135.0322,  100.5575,  0.0000,
  0.0000,    162.0371,  120.4004,  90.0932,   0.0000,    0.0000,    141.0933,  105.3236,  79.2877,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    96.1189,   0.0000,    0.0000,    0.0000,    0.0000,    86.1665,
  0.0000,    0.0000,    0.0000,    0.0000,    75.9910,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    180.8383,  93.4327,   0.0000,    0.0000,    0.0000,    160.5233,  83.7765,   0.0000,
  0.0000,    0.0000,    139.7472,  73.9032,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    174.3678,
  91.5407,   0.0000,    0.0000,    0.0000,    154.8067,  82.0849,   0.0000,    0.0000,    0.0000,
  134.8019,  72.4156,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    170.1817,  88.8159,   0.0000,
  0.0000,    0.0000,    151.0970,  79.6566,   0.0000,    0.0000,    0.0000,    131.5785,  70.2898,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    166.3004,  88.8332,   0.0000,    0.0000,    0.0000,
  147.6552,  79.6477,   0.0000,    0.0000,    0.0000,    128.5846,  70.2511,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    162.8638,  84.4731,   0.0000,    0.0000,    0.0000,    144.6075,  75.6908,
  0.0000,    0.0000,    0.0000,    125.9329,  66.7166,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  133.1438,  89.1359,   0.0000,    0.0000,    0.0000,    118.5388,  79.8949,   0.0000,    0.0000,
  0.0000,    103.6007,  70.4331,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    143.7754,  84.1363,
  0.0000,    0.0000,    0.0000,    127.7828,  75.4465,   0.0000,    0.0000,    0.0000,    111.4277,
  66.5559,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    139.4937,  84.9288,   0.0000,    0.0000,
  0.0000,    124.0158,  76.1209,   0.0000,    0.0000,    0.0000,    108.1820,  67.1060,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    147.8355,  80.1704,   0.0000,    0.0000,    0.0000,    131.3004,
  71.9104,   0.0000,    0.0000,    0.0000,    114.3820,  63.4527,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    144.7587,  78.0079,   0.0000,    0.0000,    0.0000,    128.5666,  69.9791,   0.0000,
  0.0000,    0.0000,    111.9978,  61.7568,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    142.0478,
  77.3874,   0.0000,    0.0000,    0.0000,    126.1614,  69.4137,   0.0000,    0.0000,    0.0000,
  109.9031,  61.2454,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    140.1300,  80.5863,   0.0000,
  0.0000,    0.0000,    124.4402,  72.2182,   0.0000,    0.0000,    0.0000,    108.3826,  63.6396,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    121.2148,  74.9451,   0.0000,    0.0000,    0.0000,
  107.8351,  67.2308,   0.0000,    0.0000,    0.0000,    94.1431,   59.3224,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    122.5913,  96.1424,   76.4842,   0.0000,    0.0000,    109.2042,  85.9370,
  68.6555,   0.0000,    0.0000,    95.4506,   75.4412,   60.5927,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  114.2967,  91.1025,   79.3968,   0.0000,    0.0000,    101.9734,  81.5610,   71.2644,   0.0000,
  0.0000,    89.3142,   71.7524,   62.8991,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    98.7666,   84.9428,
  75.5088,   0.0000,    0.0000,    88.3156,   76.1747,   67.9119,   0.0000,    0.0000,    77.5895,
  67.1687,   60.1013,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    101.0669,  84.5094,   69.9289,   0.0000,
  0.0000,    90.3918,   75.7020,   63.0032,   0.0000,    0.0000,    79.4398,   66.6682,   55.8946,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    93.3597,   77.5536,   66.7983,   0.0000,    0.0000,    83.6227,
  69.7080,   60.2626,   0.0000,    0.0000,    73.6427,   61.6676,   53.5641,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    86.8793,   73.6634,   67.0913,   0.0000,    0.0000,    77.9194,   66.2743,   60.4749,
  0.0000,    0.0000,    68.7481,   58.7162,   53.7135,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    73.8183,
  70.7975,   70.2472,   0.0000,    0.0000,    66.3591,   63.7364,   63.2803,   0.0000,    0.0000,
  58.7497,   56.5285,   56.1647,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    69.5772,   67.8372,   0.0000,
  0.0000,    0.0000,    62.6008,   61.0971,   0.0000,    0.0000,    0.0000,    55.5020,   54.2352,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    71.7760,   66.4937,   0.0000,    0.0000,    0.0000,
  64.5552,   59.9313,   0.0000,    0.0000,    0.0000,    57.2328,   53.2556,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    97.1887,   97.5510,   81.9547,   74.9096,   0.0000,    86.9552,   87.2983,
  73.5841,   67.3849,   0.0000,    76.5235,   76.8424,   65.0549,   59.7227,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  96.8801,   91.6035,   86.4712,   85.3902,   80.6444,   86.7392,   82.1115,   77.6024,   76.6634,
  72.4872,   76.4013,   72.4353,   68.5632,   67.7670,   64.1744,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    91.4934,   90.3052,
  88.7397,   86.7914,   0.0000,    82.0559,   81.0238,   79.6576,   77.9528,   0.0000,    72.4352,
  71.5603,   70.3961,   68.9389,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    88.7736,   88.9960,   88.8641,   0.0000,
  0.0000,    79.7133,   79.9230,   79.8188,   0.0000,    0.0000,    70.4769,   70.6708,   70.5926,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    83.7437,   84.7401,   0.0000,    0.0000,    0.0000,    75.3268,
  76.2186,   0.0000,    0.0000,    0.0000,    66.7504,   67.5319,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    78.3993,   0.0000,    0.0000,    0.0000,    0.0000,    70.6480,   0.0000,    0.0000,
  0.0000,    0.0000,    62.7578,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    203.9723,
  102.0913,  0.0000,    0.0000,    0.0000,    181.0055,  91.4388,   0.0000,    0.0000,    0.0000,
  157.3695,  80.4326,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    202.8260,  171.8472,  106.0306,
  0.0000,    0.0000,    180.0988,  152.8448,  94.9909,   0.0000,    0.0000,    156.7317,  133.2852,
  83.5912,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    184.0318,  110.3333,  0.0000,    0.0000,    0.0000,
  163.6042,  98.9080,   0.0000,    0.0000,    0.0000,    142.6636,  87.2108,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    171.2418,  124.3280,  0.0000,    0.0000,    0.0000,    152.5650,  111.3012,
  0.0000,    0.0000,    0.0000,    133.4762,  97.9945,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  167.9187,  112.7338,  0.0000,    0.0000,    0.0000,    149.5551,  101.0579,  0.0000,    0.0000,
  0.0000,    130.7999,  89.1421,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    162.7926,  101.5996,
  0.0000,    0.0000,    0.0000,    145.0113,  91.1863,   0.0000,    0.0000,    0.0000,    126.8550,
  80.5724,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    164.2959,  98.2812,   0.0000,    0.0000,
  0.0000,    146.1928,  88.2439,   0.0000,    0.0000,    0.0000,    127.7295,  78.0190,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    159.6435,  111.9054,  0.0000,    0.0000,    0.0000,    142.0775,
  100.1520,  0.0000,    0.0000,    0.0000,    124.1631,  88.1768,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    9.6916,    8.2739,    0.0000,    0.0000,    0.0000,    8.2739,    7.1341,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    7.7691,
  0.0000,    0.0000,    0.0000,    0.0000,    6.6950,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    66.8423,   31.6060,   0.0000,
  0.0000,    0.0000,    51.2498,   24.9560,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    57.1605,   48.2865,   34.3314,   0.0000,    0.0000,
  44.7141,   37.9884,   27.4841,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    55.3412,   50.8577,   41.3914,   33.9334,   0.0000,    43.7364,   40.3220,
  33.1265,   27.4436,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  46.6936,   43.6855,   41.0728,   39.9172,   34.3187,   37.4421,   35.1290,   33.1075,   32.1730,
  27.9086,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    38.8084,   37.8035,
  37.2205,   35.0733,   0.0000,    31.5577,   30.7688,   30.2894,   28.6362,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    33.7264,   33.3550,   32.7365,   0.0000,
  0.0000,    27.7137,   27.4117,   26.9163,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    28.8445,   28.5468,   0.0000,    0.0000,    0.0000,    23.9505,
  23.7059,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    24.6178,   0.0000,    0.0000,    0.0000,    0.0000,    20.6394,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    109.6439,
  46.3520,   0.0000,    0.0000,    0.0000,    84.3688,   37.1982,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    97.0824,   79.2218,   48.9331,
  0.0000,    0.0000,    75.5850,   62.0580,   39.4048,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    81.7242,   48.0936,   48.1892,   0.0000,    0.0000,
  63.8564,   38.8097,   38.9899,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    80.7975,   46.6765,   48.9131,   0.0000,    0.0000,    63.4748,   37.7222,
  39.6015,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  74.9671,   45.7630,   44.9493,   0.0000,    0.0000,    59.0665,   36.9962,   36.4513,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    60.0099,   45.1290,
  35.7811,   0.0000,    0.0000,    47.5318,   36.4594,   29.3923,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    65.8112,   42.5764,   31.5582,   0.0000,
  0.0000,    52.0780,   34.5481,   26.0926,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    52.6310,   39.8628,   30.8925,   0.0000,    0.0000,    41.8942,
  32.4321,   25.5314,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    56.4307,   38.1313,   34.4935,   31.6985,   0.0000,    44.9407,   31.0516,   28.2122,
  26.1031,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    57.3248,
  37.2158,   32.5553,   33.3924,   0.0000,    45.5155,   30.3004,   26.7000,   27.2705,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    44.8098,   36.0749,   0.0000,
  0.0000,    0.0000,    35.8100,   29.2808,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    47.1122,   35.0629,   0.0000,    0.0000,    0.0000,
  37.7559,   28.6291,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    54.6782,   52.0476,   43.2385,   37.0129,   0.0000,    43.5685,   41.5909,
  34.9008,   30.1557,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  50.6412,   48.0233,   46.1468,   42.2879,   38.3697,   40.7500,   38.7583,   37.3202,   34.3642,
  31.3603,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    45.4180,   44.8079,
  43.8762,   42.6013,   0.0000,    36.9389,   36.4728,   35.7582,   34.7785,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    42.1923,   42.2027,   41.9260,   0.0000,
  0.0000,    34.5792,   34.5882,   34.3729,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    38.3225,   38.5294,   0.0000,    0.0000,    0.0000,    31.6699,
  31.8313,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    34.5452,   0.0000,    0.0000,    0.0000,    0.0000,    28.7800,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    124.5879,
  56.1779,   0.0000,    0.0000,    0.0000,    96.2235,   45.2489,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    115.9647,  96.5080,   59.1415,
  0.0000,    0.0000,    90.4081,   75.6758,   47.7411,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    105.3447,  79.4076,   58.6359,   0.0000,    0.0000,
  82.7337,   63.1889,   47.5914,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    97.0977,   63.7680,   59.7299,   0.0000,    0.0000,    76.6712,   51.5158,
  48.5769,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  90.2234,   64.4010,   57.9467,   0.0000,    0.0000,    71.5493,   52.0412,   47.1941,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    72.4186,   60.9414,
  52.9845,   0.0000,    0.0000,    57.9784,   49.4166,   43.4760,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    79.6121,   66.1093,   48.0540,   0.0000,
  0.0000,    63.5079,   53.2880,   39.6668,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    63.2599,   54.7781,   45.9133,   0.0000,    0.0000,    50.9770,
  44.7087,   37.9961,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    68.4888,   51.6117,   45.7289,   0.0000,    0.0000,    55.0240,   42.2084,   37.6967,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    64.2707,
  48.3824,   47.2645,   0.0000,    0.0000,    51.7740,   39.6636,   38.8697,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    54.1903,   46.6726,   0.0000,
  0.0000,    0.0000,    43.8480,   38.2539,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    57.5500,   46.8692,   0.0000,    0.0000,    0.0000,
  46.5340,   38.4906,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    69.4558,   67.1232,   56.8922,   50.5156,   0.0000,    55.6589,   53.9364,
  46.2082,   41.3746,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  66.4996,   63.0806,   61.5214,   56.8151,   52.6661,   53.6243,   51.0492,   49.8778,   46.3030,
  43.1432,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    61.6912,   60.8174,
  59.5937,   58.0176,   0.0000,    50.1473,   49.4970,   48.5766,   47.3835,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    58.7881,   58.8332,   58.5223,   0.0000,
  0.0000,    48.0535,   48.1037,   47.8771,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    54.7990,   55.2689,   0.0000,    0.0000,    0.0000,    45.0848,
  45.4618,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    50.7900,   0.0000,    0.0000,    0.0000,    0.0000,    42.0634,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    152.5672,
  68.1239,   0.0000,    0.0000,    0.0000,    117.9718,  55.0786,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    146.9174,  124.0802,  72.3852,
  0.0000,    0.0000,    114.4676,  97.1926,   58.5836,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    133.6123,  100.1090,  75.8298,   0.0000,    0.0000,
  104.8095,  79.6151,   61.4499,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    72.7359,   0.0000,    0.0000,    0.0000,    0.0000,    59.1379,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  132.1584,  70.7481,   0.0000,    0.0000,    0.0000,    103.3616,  57.5599,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    127.5308,  69.3261,
  0.0000,    0.0000,    0.0000,    99.8331,   56.4117,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    124.4946,  67.2999,   0.0000,    0.0000,
  0.0000,    97.4789,   54.7947,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    121.6727,  67.2415,   0.0000,    0.0000,    0.0000,    95.2846,
  54.6852,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    119.1734,  63.7996,   0.0000,    0.0000,    0.0000,    93.3410,   51.7557,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    98.3573,
  67.4030,   0.0000,    0.0000,    0.0000,    77.8742,   54.7600,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    105.3970,  63.7152,   0.0000,
  0.0000,    0.0000,    82.7154,   51.8414,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    102.3811,  64.2056,   0.0000,    0.0000,    0.0000,
  80.4607,   52.1454,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    108.3076,  60.7598,   0.0000,    0.0000,    0.0000,    84.9478,   49.4793,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  106.0552,  59.1423,   0.0000,    0.0000,    0.0000,    83.1827,   48.1805,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    104.0800,  58.6465,
  0.0000,    0.0000,    0.0000,    81.6437,   47.7551,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    102.6251,  60.9031,   0.0000,    0.0000,
  0.0000,    80.4575,   49.4502,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    89.3405,   56.8124,   0.0000,    0.0000,    0.0000,    70.5522,
  46.2772,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    90.7784,   71.9597,   58.0567,   0.0000,    0.0000,    72.0887,   57.8272,   47.3702,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    85.0814,
  68.5425,   60.2393,   0.0000,    0.0000,    67.9590,   55.3905,   49.1219,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    74.0309,   64.2604,   57.6438,
  0.0000,    0.0000,    59.5758,   52.2335,   47.3086,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    75.8337,   63.7099,   53.6738,   0.0000,    0.0000,
  61.0949,   51.5881,   44.2933,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    70.3954,   59.1204,   51.4839,   0.0000,    0.0000,    57.0111,   48.4383,
  42.6636,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  65.7904,   56.3268,   51.5850,   0.0000,    0.0000,    53.5214,   46.2909,   42.6330,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    56.3053,   54.2516,
  53.9293,   0.0000,    0.0000,    46.1442,   44.6792,   44.5004,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    53.2258,   52.0610,   0.0000,    0.0000,
  0.0000,    43.7468,   42.9339,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    54.9023,   51.1702,   0.0000,    0.0000,    0.0000,    45.1205,
  42.3195,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    73.0353,   73.3784,   62.3317,   57.3189,   0.0000,    58.9129,   59.2550,   50.9307,
  47.1316,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    73.0285,
  69.3207,   65.6888,   64.9548,   61.5737,   59.1097,   56.3445,   53.6109,   53.0888,   50.5222,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    69.3689,   68.5593,   67.4750,
  66.1131,   0.0000,    56.5007,   55.9216,   55.1283,   54.1197,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    67.5672,   67.7625,   67.6992,   0.0000,    0.0000,
  55.2614,   55.4450,   55.4264,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    64.0797,   64.8287,   0.0000,    0.0000,    0.0000,    52.7033,   53.3092,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  60.3208,   0.0000,    0.0000,    0.0000,    0.0000,    49.8927,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    148.3584,  76.8281,
  0.0000,    0.0000,    0.0000,    115.4321,  62.1219,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    148.2516,  126.1953,  79.8957,   0.0000,
  0.0000,    116.0062,  99.2802,   64.6894,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    135.2792,  83.4761,   0.0000,    0.0000,    0.0000,    106.5303,
  67.8586,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    126.9393,  93.6408,   0.0000,    0.0000,    0.0000,    100.9029,  75.7461,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    124.2642,
  85.2621,   0.0000,    0.0000,    0.0000,    98.5768,   69.2707,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    120.5290,  77.1764,   0.0000,
  0.0000,    0.0000,    95.6625,   62.9867,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    121.1667,  74.7584,   0.0000,    0.0000,    0.0000,
  95.7322,   61.0993,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    117.8193,  84.1628,   0.0000,    0.0000,    0.0000,    93.1614,   67.9514,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  6.2896,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    49.2799,   23.7745,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    42.6771,   36.1911,   26.0533,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    41.5966,   38.3154,   31.3944,   25.9335,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    35.4550,   33.2416,   31.3107,   30.4338,   26.3358,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    29.7767,
  29.0280,   28.5805,   26.9990,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    26.0940,   25.8107,   25.3435,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    22.5121,   22.2832,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    19.3774,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  81.0861,   35.2969,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    72.3072,   59.2779,
  37.3258,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    61.0154,   36.7468,   36.8800,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    60.5594,   35.7117,   37.4554,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    56.3108,   35.0290,   34.4789,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    45.2820,
  34.5350,   27.7372,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    49.5959,   32.6806,   24.5957,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    39.8659,   30.6648,   24.0741,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    42.7270,   29.3598,   26.6627,   24.6343,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  43.3129,   28.6554,   25.2210,   25.7940,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    34.0544,   27.7282,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    35.8427,   27.0524,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    41.3681,   39.4587,   33.0228,   28.4654,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    38.5746,   36.6615,   35.2842,   32.4515,   29.5740,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    34.8686,
  34.4226,   33.7391,   32.8021,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    32.5843,   32.5935,   32.3892,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    29.7958,   29.9501,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    27.0430,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  92.3827,   42.8957,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    86.4627,   72.2703,
  45.1941,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    78.9316,   60.0628,   44.9753,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    73.0315,   48.7600,   45.8824,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    68.0769,   49.2635,   44.5776,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    55.0487,
  46.7498,   41.0035,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    60.3521,   50.5087,   37.3723,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    48.3429,   42.2432,   35.7884,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    52.2072,   39.8762,   35.5563,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  49.0990,   37.4647,   36.6837,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    41.5780,   36.1486,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    44.1062,   36.3401,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    52.8517,   51.1747,   43.7215,   39.0674,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    50.8110,   48.3258,   47.1942,   43.7556,   40.7195,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    47.4073,
  46.7775,   45.8894,   44.7408,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    45.3613,   45.4044,   45.1836,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    42.4954,   42.8512,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    39.5951,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  113.1764,  52.1041,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    109.5000,  92.8494,
  55.4092,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    100.0277,  75.6791,   58.0795,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    55.9048,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    98.8220,   54.4061,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    95.4202,
  53.3201,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    93.1635,   51.7860,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    91.0614,   51.6977,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    89.1988,   48.9809,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  74.1912,   51.7756,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    79.0484,   49.0050,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    76.8557,   49.3166,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    81.1416,   46.7595,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    79.4539,   45.5279,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    77.9788,
  45.1298,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    76.8581,   46.7569,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    67.2575,   43.7263,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    68.5505,   54.8167,   44.7120,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  64.5238,   52.4358,   46.3878,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    56.4767,   49.3830,
  44.6145,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    57.8970,   48.8329,   41.7310,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    53.9642,   45.7205,   40.1666,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    50.6159,   43.6773,   40.1846,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    43.5930,
  42.1499,   41.9574,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    41.3166,   40.5092,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    42.6085,   39.8974,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    55.8782,   56.1746,   48.1368,   44.4781,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  55.9909,   53.3105,   50.6707,   50.1543,   47.6844,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    53.4204,   52.8501,
  52.0759,   51.0961,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    52.1881,   52.3520,   52.3237,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    49.7043,   50.2741,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    46.9970,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    110.5120,
  58.7599,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    110.8126,  94.7035,   61.1676,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    101.5857,  64.1443,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    95.9845,   71.7185,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  93.8663,   65.5331,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    91.0869,   59.5271,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    91.3090,   57.7290,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    88.8365,   64.4333,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1608.0286, 505.4363,  0.0000,    0.0000,    0.0000,    505.4363,  186.1052,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    985.1697,
  794.7597,  442.4019,  0.0000,    0.0000,    355.9180,  289.6082,  176.8683,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    838.9648,  746.3419,  543.9378,
  386.0980,  0.0000,    316.4588,  284.2251,  214.6796,  160.6594,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    591.0458,  538.3412,  492.6562,  487.1761,  369.7717,
  237.1326,  217.5049,  200.8038,  196.6526,  156.1545,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    420.0064,  406.7150,  403.9802,  365.2110,  0.0000,    176.9205,  171.4469,
  169.5698,  155.4495,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  328.5990,  325.5969,  318.7120,  0.0000,    0.0000,    142.5430,  141.0599,  138.1166,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    253.5136,  251.2326,
  0.0000,    0.0000,    0.0000,    113.1025,  111.9829,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    197.3440,  0.0000,    0.0000,    0.0000,
  0.0000,    90.1735,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2798.6124, 666.0357,  0.0000,    0.0000,    0.0000,    840.8299,
  249.2200,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1907.7081, 1545.7064, 626.5526,  0.0000,    0.0000,    648.3105,  516.6917,  247.8223,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1512.5338,
  602.4929,  575.7400,  0.0000,    0.0000,    527.0917,  239.9714,  233.4674,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1413.1570, 582.5270,  580.9067,
  0.0000,    0.0000,    501.2393,  231.2612,  235.9718,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1267.3139, 571.6455,  535.4483,  0.0000,    0.0000,
  454.8030,  226.7886,  216.1867,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1000.4652, 573.1436,  376.4906,  0.0000,    0.0000,    357.1508,  225.7837,
  157.3830,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1058.5103, 497.3582,  307.9557,  0.0000,    0.0000,    386.3426,  202.9676,  131.8257,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    828.8936,  453.5444,
  303.9124,  0.0000,    0.0000,    301.7401,  186.4669,  129.7332,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    834.1826,  433.3736,  382.6821,  324.6241,
  0.0000,    314.1718,  177.8355,  157.3578,  136.9841,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    877.9354,  425.6455,  348.5798,  383.3773,  0.0000,    326.8271,
  174.2001,  145.1854,  155.5786,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    676.4773,  438.7198,  0.0000,    0.0000,    0.0000,    249.8197,  175.2531,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    644.3408,
  380.6568,  0.0000,    0.0000,    0.0000,    249.3925,  159.1228,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    781.3524,  717.7531,  527.0671,
  398.0180,  0.0000,    298.4007,  277.5143,  212.3618,  167.7278,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    630.1041,  578.0882,  542.6657,  469.5496,  396.2431,
  253.1433,  234.6048,  221.9031,  195.6231,  169.1405,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    496.9338,  486.4638,  469.9596,  447.0179,  0.0000,    208.1802,  204.1937,
  198.0692,  189.6770,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  425.1864,  425.7733,  421.9195,  0.0000,    0.0000,    182.4744,  182.6062,  181.0487,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    354.2869,  357.7246,
  0.0000,    0.0000,    0.0000,    155.8202,  157.1005,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    294.5574,  0.0000,    0.0000,    0.0000,
  0.0000,    132.4348,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3104.1016, 781.8527,  0.0000,    0.0000,    0.0000,    936.3006,
  294.6795,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2296.1906, 1907.9592, 749.3005,  0.0000,    0.0000,    773.9854,  630.8304,  296.0005,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1876.8634,
  1272.7028, 678.1726,  0.0000,    0.0000,    658.7963,  454.9928,  277.5701,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1616.2863, 808.9973,  672.4303,
  0.0000,    0.0000,    581.2480,  318.1678,  277.7936,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1434.6641, 816.0317,  657.1151,  0.0000,    0.0000,
  523.4058,  321.5378,  269.1778,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1058.3899, 749.4974,  553.0357,  0.0000,    0.0000,    395.0058,  297.1713,
  232.5932,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1201.5234, 908.4025,  469.7696,  0.0000,    0.0000,    444.5269,  343.5592,  201.5403,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    869.3774,  618.6669,
  437.6491,  0.0000,    0.0000,    330.2273,  253.0900,  189.1300,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    945.4221,  577.0181,  467.8086,  0.0000,
  0.0000,    361.4287,  236.1444,  196.6926,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    860.6209,  531.1676,  493.9241,  0.0000,    0.0000,    332.4392,
  218.2333,  206.7940,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    731.0832,  517.5680,  0.0000,    0.0000,    0.0000,    277.9428,  211.8419,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    740.5787,
  489.5129,  0.0000,    0.0000,    0.0000,    289.8474,  205.9647,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    986.0999,  915.9413,  675.2268,
  532.8538,  0.0000,    373.3794,  352.0074,  272.3735,  224.4097,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    845.1348,  767.0955,  730.6587,  630.8687,  546.5096,
  334.7023,  308.2470,  296.0155,  261.5400,  231.9019,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    701.6903,  681.3650,  654.5716,  621.1943,  0.0000,    288.9888,  281.9923,
  272.6893,  261.0668,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  624.4076,  622.3099,  614.3523,  0.0000,    0.0000,    262.8846,  262.3697,  259.6698,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    539.8536,  545.2855,
  0.0000,    0.0000,    0.0000,    232.6053,  234.8776,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    465.2817,  0.0000,    0.0000,    0.0000,
  0.0000,    204.7986,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3798.9439, 873.2665,  0.0000,    0.0000,    0.0000,    1138.9256,
  340.0624,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    3009.7233, 2565.9398, 895.1626,  0.0000,    0.0000,    995.3660,  826.9565,  355.3439,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2465.5965,
  1637.7878, 894.7448,  0.0000,    0.0000,    850.0768,  578.7007,  363.4612,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    841.8986,  0.0000,    0.0000,
  0.0000,    0.0000,    343.1382,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2609.0440, 813.2353,  0.0000,    0.0000,    0.0000,
  873.5134,  332.1495,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2470.6020, 795.6873,  0.0000,    0.0000,    0.0000,    834.9263,  325.1636,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2399.8207, 767.8676,  0.0000,    0.0000,    0.0000,    812.9350,  314.3316,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2335.6474, 781.2050,
  0.0000,    0.0000,    0.0000,    792.8336,  317.4096,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2278.4898, 780.2674,  0.0000,    0.0000,
  0.0000,    774.9719,  310.6864,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1667.3895, 787.6187,  0.0000,    0.0000,    0.0000,    589.6821,
  319.9572,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2124.0831, 732.6457,  0.0000,    0.0000,    0.0000,    695.0211,  299.2468,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2027.8568,
  762.5439,  0.0000,    0.0000,    0.0000,    666.6515,  307.1464,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2016.3392, 688.5910,  0.0000,
  0.0000,    0.0000,    694.0742,  282.8651,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1968.9928, 666.5534,  0.0000,    0.0000,    0.0000,
  678.8486,  274.3732,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1924.6593, 664.0994,  0.0000,    0.0000,    0.0000,    664.8580,  272.9668,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1907.5332, 708.0629,  0.0000,    0.0000,    0.0000,    657.9922,  289.0123,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1533.2675, 638.1634,
  0.0000,    0.0000,    0.0000,    542.0872,  263.2219,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1398.1254, 991.3402,  628.9308,  0.0000,
  0.0000,    517.4295,  376.9954,  263.0701,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1222.0335, 880.3532,  676.8713,  0.0000,    0.0000,    463.2724,
  343.2801,  277.5361,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1002.9508, 766.7477,  598.5348,  0.0000,    0.0000,    384.9091,  306.9894,  252.2899,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1001.1833,
  808.1000,  525.1483,  0.0000,    0.0000,    388.7971,  316.0786,  225.3330,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    873.3589,  635.3072,  480.0206,
  0.0000,    0.0000,    346.3997,  264.1479,  209.0919,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    775.6337,  588.8318,  511.4316,  0.0000,    0.0000,
  312.8132,  246.6792,  217.0607,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    625.9625,  557.6048,  537.6428,  0.0000,    0.0000,    255.7289,  234.5604,
  228.7358,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  577.7550,  534.8076,  0.0000,    0.0000,    0.0000,    237.4044,  224.3164,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    583.7960,  496.0003,
  0.0000,    0.0000,    0.0000,    242.7919,  213.1668,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1001.3499, 975.3275,  699.5701,  587.3739,
  0.0000,    379.7209,  375.2846,  286.5556,  248.7497,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    919.1257,  821.9796,  735.5782,  709.0607,  636.8215,  362.5649,
  331.2846,  302.5882,  294.6514,  269.7377,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    791.0868,  764.7264,  734.1232,  698.7686,  0.0000,    323.9350,  315.6947,  305.8218,
  294.2073,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    727.2631,
  723.1832,  715.2918,  0.0000,    0.0000,    303.8303,  303.1305,  300.9390,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    642.5599,  649.9141,  0.0000,
  0.0000,    0.0000,    274.7315,  278.0094,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    566.3047,  0.0000,    0.0000,    0.0000,    0.0000,
  247.0635,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    3398.6461, 978.7272,  0.0000,    0.0000,    0.0000,    1052.1318, 382.2708,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2874.5717, 2433.4034, 980.9636,  0.0000,    0.0000,    969.7421,  807.4609,  390.2839,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2377.4617, 963.5350,
  0.0000,    0.0000,    0.0000,    834.8650,  393.4383,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1985.2103, 1201.7562, 0.0000,    0.0000,
  0.0000,    726.9387,  467.1567,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2051.1151, 1060.8040, 0.0000,    0.0000,    0.0000,    732.6554,
  413.5128,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1981.4675, 875.1861,  0.0000,    0.0000,    0.0000,    708.7936,  357.1582,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2131.3007,
  831.4952,  0.0000,    0.0000,    0.0000,    743.9190,  341.9302,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2045.9284, 1161.7208, 0.0000,
  0.0000,    0.0000,    717.9100,  436.5100,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    683.3758,  554.5967,  334.2493,  0.0000,    0.0000,
  554.5967,  451.2708,  274.1590,  0.0000,    0.0000,    334.2493,  274.1590,  175.5616,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    603.4689,  541.0285,  406.0687,  301.3307,  0.0000,    492.0829,  441.7322,
  333.0505,  248.5692,  0.0000,    304.7337,  275.2609,  212.1971,  163.1100,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  447.6423,  409.9174,  377.8360,  370.3778,  291.8716,  367.5811,  337.0250,  310.9897,  304.6797,
  241.3903,  236.1388,  217.5471,  201.7758,  196.7841,  159.9115,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    330.7801,  320.4176,
  317.0824,  289.9090,  0.0000,    273.5268,  265.0378,  262.1696,  240.1582,  0.0000,    180.9843,
  175.5006,  173.2227,  159.9562,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    264.6665,  261.9437,  256.4315,  0.0000,
  0.0000,    219.9489,  217.6629,  213.1036,  0.0000,    0.0000,    148.2130,  146.5849,  143.5523,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    208.4978,  206.4521,  0.0000,    0.0000,    0.0000,    174.1399,
  172.4148,  0.0000,    0.0000,    0.0000,    119.3911,  118.1567,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    165.1006,  0.0000,    0.0000,    0.0000,    0.0000,    138.5190,  0.0000,    0.0000,
  0.0000,    0.0000,    96.3813,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1642.0587,
  473.7661,  0.0000,    0.0000,    0.0000,    1327.3176, 387.3349,  0.0000,    0.0000,    0.0000,
  723.6346,  240.1725,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1252.5932, 997.2486,  468.1527,
  0.0000,    0.0000,    1013.7695, 809.2182,  384.1308,  0.0000,    0.0000,    590.8737,  470.3059,
  245.0983,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1015.5454, 452.7600,  439.2030,  0.0000,    0.0000,
  822.8957,  371.7768,  361.4502,  0.0000,    0.0000,    486.4653,  238.1540,  234.0068,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    962.9831,  436.1091,  443.7557,  0.0000,    0.0000,    781.6993,  358.3602,
  365.2736,  0.0000,    0.0000,    467.4506,  229.5754,  236.7246,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  872.2579,  427.7156,  406.5642,  0.0000,    0.0000,    708.7684,  351.3928,  334.6783,  0.0000,
  0.0000,    426.8815,  224.9822,  216.4395,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    684.4015,  426.2276,
  293.6777,  0.0000,    0.0000,    556.6127,  349.9328,  243.0049,  0.0000,    0.0000,    335.0118,
  223.1855,  160.5554,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    739.0411,  381.2968,  244.7517,  0.0000,
  0.0000,    601.4499,  314.0119,  203.2173,  0.0000,    0.0000,    366.0024,  204.0446,  136.1619,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    576.5121,  349.7116,  240.9962,  0.0000,    0.0000,    469.6437,
  288.3371,  200.0041,  0.0000,    0.0000,    285.9969,  188.2525,  133.7853,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    598.3302,  333.4767,  294.6091,  255.1561,  0.0000,    488.1715,  274.9840,  243.1809,
  211.3388,  0.0000,    302.4518,  179.4553,  159.0980,  140.3518,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    623.6305,
  326.7864,  271.2223,  291.9263,  0.0000,    508.1585,  269.3779,  224.1812,  240.5302,  0.0000,
  312.5862,  175.5343,  147.6912,  156.1327,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    476.2426,  330.0018,  0.0000,
  0.0000,    0.0000,    388.4209,  271.2755,  0.0000,    0.0000,    0.0000,    238.5370,  174.3619,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    472.9143,  297.5440,  0.0000,    0.0000,    0.0000,
  386.8884,  245.8054,  0.0000,    0.0000,    0.0000,    243.5663,  162.0032,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    567.1638,  526.4236,  399.9263,  313.4658,  0.0000,    463.5691,  430.8297,
  328.9697,  259.2061,  0.0000,    289.7425,  271.2420,  212.3044,  171.5385,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  477.3744,  441.5239,  417.0307,  366.3319,  315.2720,  392.2533,  363.3320,  343.5106,  302.5213,
  261.2272,  252.3964,  235.2670,  223.4249,  198.9542,  174.2312,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    389.4927,  381.8396,
  370.0638,  353.9178,  0.0000,    321.8732,  315.6688,  306.1275,  293.0440,  0.0000,    212.3392,
  208.5236,  202.7244,  194.8198,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    339.5742,  339.8427,  336.8869,  0.0000,
  0.0000,    281.7173,  281.9249,  279.5035,  0.0000,    0.0000,    188.6214,  188.7025,  187.1504,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    288.2736,  290.7276,  0.0000,    0.0000,    0.0000,    240.1565,
  242.1476,  0.0000,    0.0000,    0.0000,    163.2221,  164.4383,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    243.5965,  0.0000,    0.0000,    0.0000,    0.0000,    203.7473,  0.0000,    0.0000,
  0.0000,    0.0000,    140.3605,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1826.4648,
  559.1337,  0.0000,    0.0000,    0.0000,    1477.6556, 457.7831,  0.0000,    0.0000,    0.0000,
  808.8537,  285.4219,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1495.8141, 1218.1274, 558.7819,
  0.0000,    0.0000,    1210.9593, 988.7857,  458.8001,  0.0000,    0.0000,    703.3906,  571.9448,
  292.9174,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1266.7602, 869.3739,  521.1430,  0.0000,    0.0000,
  1028.1365, 709.6961,  429.5059,  0.0000,    0.0000,    611.6961,  430.3940,  279.6834,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1113.8339, 600.5511,  520.6868,  0.0000,    0.0000,    905.7750,  493.3057,
  429.6462,  0.0000,    0.0000,    546.7935,  314.6402,  281.2950,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1000.5663, 607.0073,  504.6753,  0.0000,    0.0000,    814.9289,  498.3486,  416.4183,  0.0000,
  0.0000,    496.4807,  317.7923,  271.7876,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    751.6628,  559.8856,
  433.8278,  0.0000,    0.0000,    614.0265,  460.4234,  359.1888,  0.0000,    0.0000,    379.7626,
  295.1816,  238.0169,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    847.3497,  651.2564,  374.2691,  0.0000,
  0.0000,    691.4497,  533.7085,  310.8083,  0.0000,    0.0000,    425.2656,  333.8166,  208.4131,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    626.2104,  474.4180,  350.6141,  0.0000,    0.0000,    512.6759,
  391.3606,  291.4916,  0.0000,    0.0000,    320.6678,  255.2289,  196.3102,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    685.6628,  442.3381,  366.3245,  0.0000,    0.0000,    561.0010,  365.0705,  303.5312,
  0.0000,    0.0000,    351.4302,  238.3187,  201.3988,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    629.5912,
  408.3022,  385.7118,  0.0000,    0.0000,    515.6457,  337.2256,  319.2176,  0.0000,    0.0000,
  324.9551,  220.7375,  211.0831,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    526.4776,  396.6125,  0.0000,
  0.0000,    0.0000,    431.2807,  327.3509,  0.0000,    0.0000,    0.0000,    270.1633,  213.7477,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    547.6721,  384.1728,  0.0000,    0.0000,    0.0000,
  449.1567,  317.9002,  0.0000,    0.0000,    0.0000,    285.2161,  210.5498,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    709.3565,  667.2844,  512.0902,  418.8567,  0.0000,    579.9234,  546.2762,
  421.5573,  346.4940,  0.0000,    361.3835,  343.3098,  272.5677,  229.4425,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  631.9434,  580.4500,  556.6241,  489.7532,  432.3765,  518.6518,  477.2848,  458.1425,  404.2763,
  358.0089,  331.2828,  307.5475,  296.6147,  265.2575,  238.0549,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    541.9826,  528.3545,
  510.2824,  487.7418,  0.0000,    446.9230,  435.9923,  421.4626,  403.3092,  0.0000,    292.0246,
  285.7251,  277.2781,  266.6745,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    490.8760,  489.7820,  484.5038,  0.0000,
  0.0000,    406.0728,  405.2529,  401.0304,  0.0000,    0.0000,    268.8595,  268.5418,  266.1377,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    432.1792,  436.4452,  0.0000,    0.0000,    0.0000,    358.8052,
  362.3258,  0.0000,    0.0000,    0.0000,    240.8943,  243.2097,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    378.6134,  0.0000,    0.0000,    0.0000,    0.0000,    315.4581,  0.0000,    0.0000,
  0.0000,    0.0000,    214.5479,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2220.9652,
  642.1846,  0.0000,    0.0000,    0.0000,    1799.0180, 527.5630,  0.0000,    0.0000,    0.0000,
  983.9584,  335.2430,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1926.3504, 1599.6001, 669.7642,
  0.0000,    0.0000,    1559.5050, 1298.9425, 550.6761,  0.0000,    0.0000,    897.4029,  742.3673,
  353.0531,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1637.1586, 1106.7221, 683.2371,  0.0000,    0.0000,
  1328.2510, 903.4563,  562.6808,  0.0000,    0.0000,    783.1302,  545.0752,  364.9162,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    644.2220,  0.0000,    0.0000,    0.0000,    0.0000,    530.8650,  0.0000,
  0.0000,    0.0000,    0.0000,    345.1382,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1687.5419, 623.3223,  0.0000,    0.0000,    0.0000,    1367.2714, 513.7956,  0.0000,    0.0000,
  0.0000,    792.9063,  334.4652,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1611.7831, 610.1625,
  0.0000,    0.0000,    0.0000,    1305.9000, 502.9655,  0.0000,    0.0000,    0.0000,    760.7352,
  327.4991,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1568.9885, 589.6141,  0.0000,    0.0000,
  0.0000,    1271.2883, 486.1582,  0.0000,    0.0000,    0.0000,    741.4881,  316.8969,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1529.9120, 596.0022,  0.0000,    0.0000,    0.0000,    1239.6749,
  491.1385,  0.0000,    0.0000,    0.0000,    723.8209,  318.9485,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1495.1792, 585.2367,  0.0000,    0.0000,    0.0000,    1211.5825, 481.1216,  0.0000,
  0.0000,    0.0000,    708.1495,  308.8219,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1130.8198,
  601.0384,  0.0000,    0.0000,    0.0000,    919.6329,  495.1147,  0.0000,    0.0000,    0.0000,
  551.1193,  321.3077,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1343.3651, 561.5991,  0.0000,
  0.0000,    0.0000,    1089.8214, 462.8827,  0.0000,    0.0000,    0.0000,    626.4637,  301.2799,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1287.2471, 577.4805,  0.0000,    0.0000,    0.0000,
  1045.1961, 475.4827,  0.0000,    0.0000,    0.0000,    603.2928,  307.3477,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1337.4783, 530.3870,  0.0000,    0.0000,    0.0000,    1084.2313, 437.4255,
  0.0000,    0.0000,    0.0000,    637.8198,  285.5962,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1307.9814, 514.2872,  0.0000,    0.0000,    0.0000,    1060.3386, 424.2493,  0.0000,    0.0000,
  0.0000,    624.2488,  277.3103,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1280.7911, 511.8009,
  0.0000,    0.0000,    0.0000,    1038.3601, 422.1177,  0.0000,    0.0000,    0.0000,    611.9392,
  275.6811,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1267.8866, 542.7763,  0.0000,    0.0000,
  0.0000,    1027.7356, 447.1652,  0.0000,    0.0000,    0.0000,    605.0843,  290.7410,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1040.1825, 493.2883,  0.0000,    0.0000,    0.0000,    845.5386,
  406.9926,  0.0000,    0.0000,    0.0000,    506.2365,  266.2926,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    987.5239,  714.7572,  491.8846,  0.0000,    0.0000,    805.0014,  585.7053,  406.5820,
  0.0000,    0.0000,    494.2290,  367.1079,  268.1594,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    880.8469,
  648.2981,  519.9846,  0.0000,    0.0000,    719.7152,  532.4766,  429.3240,  0.0000,    0.0000,
  448.1992,  338.4615,  280.6157,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    729.3352,  577.3002,  470.4046,
  0.0000,    0.0000,    597.4344,  475.3884,  389.5721,  0.0000,    0.0000,    375.5975,  306.6214,
  258.4639,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    735.6553,  596.5347,  418.4768,  0.0000,    0.0000,
  603.0907,  490.0563,  347.5163,  0.0000,    0.0000,    381.4793,  311.9868,  233.0361,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    653.0750,  493.5592,  387.0327,  0.0000,    0.0000,    536.6221,  408.1131,
  322.1398,  0.0000,    0.0000,    343.6107,  268.7831,  217.9320,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  587.9487,  460.1061,  403.3963,  0.0000,    0.0000,    484.0716,  380.8614,  334.7856,  0.0000,
  0.0000,    312.9994,  251.9665,  223.4506,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    478.8535,  437.0099,
  425.3166,  0.0000,    0.0000,    395.2401,  361.9867,  352.7890,  0.0000,    0.0000,    257.8921,
  240.1040,  235.4609,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    443.8491,  417.8850,  0.0000,    0.0000,
  0.0000,    366.7017,  346.1262,  0.0000,    0.0000,    0.0000,    240.1781,  229.3401,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    453.3596,  395.6174,  0.0000,    0.0000,    0.0000,    374.8552,
  328.5343,  0.0000,    0.0000,    0.0000,    246.9009,  220.4740,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    719.8428,  710.2404,  536.9006,  463.3959,  0.0000,    589.5395,  582.2068,  442.9848,
  383.8279,  0.0000,    368.7594,  366.9136,  289.1580,  255.1940,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    684.1011,
  622.8471,  566.8872,  551.1519,  502.8081,  561.7298,  512.6793,  467.7576,  455.2629,  416.3367,
  358.5506,  331.3135,  305.8390,  299.2984,  276.6755,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    607.6008,  591.3242,  571.9311,
  549.1966,  0.0000,    500.9223,  487.9884,  472.5158,  454.3280,  0.0000,    326.5044,  319.5504,
  311.0143,  300.8277,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    567.8072,  566.1891,  561.7309,  0.0000,    0.0000,
  469.3523,  468.2106,  464.7507,  0.0000,    0.0000,    309.5177,  309.3423,  307.7075,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    511.0472,  517.1372,  0.0000,    0.0000,    0.0000,    423.8500,  428.9192,
  0.0000,    0.0000,    0.0000,    283.3481,  286.8021,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  457.5207,  0.0000,    0.0000,    0.0000,    0.0000,    380.6793,  0.0000,    0.0000,    0.0000,
  0.0000,    257.5824,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2044.6296, 721.6286,
  0.0000,    0.0000,    0.0000,    1657.5070, 592.9795,  0.0000,    0.0000,    0.0000,    924.2573,
  377.4216,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1871.9600, 1557.0501, 735.2872,  0.0000,
  0.0000,    1517.3457, 1265.5466, 604.7908,  0.0000,    0.0000,    883.8111,  735.1978,  388.3439,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1604.0300, 738.5419,  0.0000,    0.0000,    0.0000,    1302.8376,
  608.6709,  0.0000,    0.0000,    0.0000,    776.4074,  396.0686,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1388.3756, 881.9628,  0.0000,    0.0000,    0.0000,    1131.3898, 724.7302,  0.0000,
  0.0000,    0.0000,    691.1271,  460.5673,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1403.0924,
  778.8806,  0.0000,    0.0000,    0.0000,    1141.8668, 641.4675,  0.0000,    0.0000,    0.0000,
  688.3015,  409.7423,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1357.1628, 669.5851,  0.0000,
  0.0000,    0.0000,    1104.5083, 552.3275,  0.0000,    0.0000,    0.0000,    666.2269,  359.9011,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1429.4308, 640.3104,  0.0000,    0.0000,    0.0000,
  1160.8135, 528.5114,  0.0000,    0.0000,    0.0000,    689.6518,  345.7120,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1378.5876, 827.4875,  0.0000,    0.0000,    0.0000,    1119.8466, 678.2067,
  0.0000,    0.0000,    0.0000,    667.2949,  423.2252,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  540.5406,  486.2365,  369.3829,  278.5639,  0.0000,    486.2365,  437.7575,  333.5341,  252.4953,
  0.0000,    369.3829,  333.5341,  256.7497,  196.9411,  0.0000,    278.5639,  252.4953,  196.9411,
  153.5945,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    408.9606,  375.5233,
  347.1154,  339.4502,  271.3202,  369.6232,  339.6516,  314.1809,  307.1015,  246.3013,  285.4825,
  262.9770,  243.8407,  237.9434,  193.0534,  219.9479,  203.2226,  189.0034,  184.0291,  151.4603,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    307.2965,  297.8076,  294.3403,  270.3535,
  0.0000,    278.9272,  270.3580,  267.1404,  245.6529,  0.0000,    218.5302,  211.9205,  209.2061,
  193.1132,  0.0000,    171.3557,  166.2698,  163.9565,  152.0452,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    248.5008,  245.8568,  240.7165,  0.0000,    0.0000,    226.2156,
  223.7942,  219.1285,  0.0000,    0.0000,    178.8926,  176.9365,  173.2779,  0.0000,    0.0000,
  141.8517,  140.2618,  137.3907,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    197.7594,  195.7647,  0.0000,    0.0000,    0.0000,    180.5430,  178.7127,  0.0000,
  0.0000,    0.0000,    144.0669,  142.5806,  0.0000,    0.0000,    0.0000,    115.4552,  114.2405,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    157.9595,
  0.0000,    0.0000,    0.0000,    0.0000,    144.5798,  0.0000,    0.0000,    0.0000,    0.0000,
  116.2817,  0.0000,    0.0000,    0.0000,    0.0000,    94.0428,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1387.9361, 424.8926,  0.0000,
  0.0000,    0.0000,    1233.2237, 382.6422,  0.0000,    0.0000,    0.0000,    894.6228,  291.6028,
  0.0000,    0.0000,    0.0000,    628.9537,  220.7264,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1088.8420, 866.9517,  426.0568,  0.0000,    0.0000,
  973.0493,  775.0832,  384.8555,  0.0000,    0.0000,    721.4089,  575.4721,  296.5572,  0.0000,
  0.0000,    525.8367,  419.7129,  227.8108,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    888.6025,  412.9058,  402.9357,  0.0000,    0.0000,    795.2206,  373.1845,
  364.6668,  0.0000,    0.0000,    592.7050,  288.0834,  282.8628,  0.0000,    0.0000,    435.4205,
  221.8339,  219.1014,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  847.4615,  397.8618,  407.3331,  0.0000,    0.0000,    759.4532,  359.6497,  368.7014,  0.0000,
  0.0000,    568.9077,  277.8074,  286.1317,  0.0000,    0.0000,    420.8711,  214.0193,  221.7708,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    770.3432,  390.0432,
  372.8019,  0.0000,    0.0000,    690.9156,  352.5575,  337.4128,  0.0000,    0.0000,    519.1328,
  272.2496,  261.7283,  0.0000,    0.0000,    385.6611,  209.6742,  202.7168,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    604.4071,  387.8695,  272.5015,  0.0000,
  0.0000,    542.2459,  350.4296,  247.4372,  0.0000,    0.0000,    407.7288,  270.1623,  193.9815,
  0.0000,    0.0000,    303.1266,  207.6299,  152.2308,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    656.0738,  350.4522,  228.9125,  0.0000,    0.0000,    589.1475,
  317.3287,  208.2902,  0.0000,    0.0000,    444.6283,  246.5588,  164.4045,  0.0000,    0.0000,
  332.3156,  191.3897,  130.0809,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    512.0823,  322.2781,  225.1663,  0.0000,    0.0000,    460.0496,  292.0247,  204.8282,
  0.0000,    0.0000,    347.6394,  227.4327,  161.5357,  0.0000,    0.0000,    260.2229,  177.0542,
  127.6833,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    535.9706,
  307.2540,  271.8226,  237.3961,  0.0000,    482.2990,  278.4173,  246.4539,  215.7066,  0.0000,
  366.7236,  216.8393,  192.2755,  169.4903,  0.0000,    276.8948,  168.8027,  149.9951,  133.3820,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    556.5389,  300.8271,  251.1877,
  268.1207,  0.0000,    500.3525,  272.5409,  227.9565,  242.8419,  0.0000,    379.2280,  212.1194,
  178.3984,  188.7699,  0.0000,    285.1174,  164.9924,  139.7108,  146.6121,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    424.7723,  301.4650,  0.0000,    0.0000,    0.0000,
  381.9923,  272.6384,  0.0000,    0.0000,    0.0000,    289.6824,  210.9019,  0.0000,    0.0000,
  0.0000,    217.8958,  162.8021,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    427.1610,  275.6299,  0.0000,    0.0000,    0.0000,    385.1449,  250.0730,
  0.0000,    0.0000,    0.0000,    294.9017,  195.5973,  0.0000,    0.0000,    0.0000,    224.7197,
  153.0776,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  510.5854,  475.7318,  366.3371,  291.1704,  0.0000,    459.9544,  428.9521,  331.4055,  264.2993,
  0.0000,    351.1192,  328.5100,  256.7121,  207.0871,  0.0000,    266.4534,  250.3494,  198.4813,
  162.4065,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    436.5060,  405.1611,
  383.6305,  339.1034,  294.1970,  394.6650,  366.6561,  347.3879,  307.5504,  267.3616,  305.1643,
  284.3739,  269.9943,  240.2935,  210.2972,  235.4382,  220.2317,  209.6430,  187.7933,  165.6908,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    361.1913,  354.3706,  343.9343,  329.6624,
  0.0000,    327.7229,  321.6043,  312.2501,  299.4628,  0.0000,    256.4231,  251.8127,  244.7896,
  235.2041,  0.0000,    200.7514,  197.3088,  192.0916,  184.9886,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    317.6182,  317.8133,  315.1147,  0.0000,    0.0000,    288.8485,
  289.0163,  286.5809,  0.0000,    0.0000,    227.6936,  227.7982,  225.9245,  0.0000,    0.0000,
  179.8635,  179.9198,  178.4835,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    272.0098,  274.1894,  0.0000,    0.0000,    0.0000,    247.9692,  249.9248,  0.0000,
  0.0000,    0.0000,    196.9743,  198.4473,  0.0000,    0.0000,    0.0000,    157.0191,  158.1182,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    231.6904,
  0.0000,    0.0000,    0.0000,    0.0000,    211.6949,  0.0000,    0.0000,    0.0000,    0.0000,
  169.3547,  0.0000,    0.0000,    0.0000,    0.0000,    136.1238,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1546.9229, 502.9933,  0.0000,
  0.0000,    0.0000,    1375.2558, 453.3636,  0.0000,    0.0000,    0.0000,    999.7400,  346.4959,
  0.0000,    0.0000,    0.0000,    704.9609,  263.2439,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1298.5356, 1057.0218, 508.8061,  0.0000,    0.0000,
  1160.2539, 944.7535,  459.7370,  0.0000,    0.0000,    859.5678,  700.6746,  354.5526,  0.0000,
  0.0000,    625.6996,  509.9927,  272.6252,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1112.2980, 771.8606,  479.6884,  0.0000,    0.0000,    996.3757,  693.4732,
  434.5102,  0.0000,    0.0000,    745.1801,  524.2267,  338.0153,  0.0000,    0.0000,    549.9242,
  392.0660,  262.7634,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  985.0494,  546.7176,  480.7313,  0.0000,    0.0000,    883.8541,  494.0245,  435.7814,  0.0000,
  0.0000,    665.0386,  381.0309,  339.8622,  0.0000,    0.0000,    494.9507,  292.9765,  265.0243,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    889.0302,  552.3550,
  465.2259,  0.0000,    0.0000,    798.6094,  499.0761,  421.6461,  0.0000,    0.0000,    603.3575,
  384.7678,  328.5727,  0.0000,    0.0000,    451.5308,  295.7786,  255.9320,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    673.1193,  511.0810,  403.2914,  0.0000,
  0.0000,    605.9135,  462.1678,  366.3171,  0.0000,    0.0000,    461.0586,  357.3576,  287.5225,
  0.0000,    0.0000,    348.3397,  275.6435,  225.9636,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    756.6195,  586.9862,  350.2804,  0.0000,    0.0000,    680.5427,
  529.3043,  318.7388,  0.0000,    0.0000,    516.4766,  405.2011,  251.6421,  0.0000,    0.0000,
  388.8226,  308.4359,  199.1588,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    564.0716,  437.0209,  328.9434,  0.0000,    0.0000,    508.5289,  396.0634,  299.5256,
  0.0000,    0.0000,    388.9956,  308.5459,  236.9854,  0.0000,    0.0000,    295.9256,  240.2687,
  188.0446,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    617.9244,
  407.6999,  340.7455,  0.0000,    0.0000,    557.0043,  369.5814,  309.6367,  0.0000,    0.0000,
  425.9837,  288.1291,  243.3210,  0.0000,    0.0000,    324.0408,  224.5657,  191.4938,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    569.1410,  376.8776,  358.0287,
  0.0000,    0.0000,    513.4163,  341.7946,  325.1370,  0.0000,    0.0000,    393.6776,  266.8484,
  254.9948,  0.0000,    0.0000,    300.4977,  208.3470,  200.2114,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    474.5713,  365.5269,  0.0000,    0.0000,    0.0000,
  427.9962,  331.3832,  0.0000,    0.0000,    0.0000,    327.7472,  258.4065,  0.0000,    0.0000,
  0.0000,    249.6759,  201.4661,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    497.0337,  356.8654,  0.0000,    0.0000,    0.0000,    448.8071,  324.0830,
  0.0000,    0.0000,    0.0000,    345.2997,  254.2236,  0.0000,    0.0000,    0.0000,    264.7291,
  199.6670,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  637.5832,  602.4143,  469.4540,  389.0698,  0.0000,    574.3420,  543.2188,  424.8967,  353.2654,
  0.0000,    438.2474,  416.0033,  329.5920,  276.9940,  0.0000,    332.3410,  316.9852,  255.2803,
  217.4318,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    575.4018,  531.0794,
  510.6087,  452.6192,  402.6252,  519.8424,  480.3735,  462.1521,  410.4176,  365.7711,  400.7894,
  371.8779,  358.5500,  320.3924,  287.3337,  308.0840,  287.3337,  277.7927,  250.1421,  226.0504,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    499.7292,  487.9847,  472.3352,  452.7605,
  0.0000,    452.8494,  442.3946,  428.4437,  410.9788,  0.0000,    352.7849,  345.1303,  334.8650,
  321.9748,  0.0000,    274.7333,  269.2400,  261.8224,  252.4713,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    456.0400,  455.2477,  450.7267,  0.0000,    0.0000,    414.0544,
  413.3856,  409.3685,  0.0000,    0.0000,    324.6278,  324.2349,  321.3129,  0.0000,    0.0000,
  254.7805,  254.5963,  252.5189,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    404.7631,  408.7149,  0.0000,    0.0000,    0.0000,    368.2792,  371.8615,  0.0000,
  0.0000,    0.0000,    290.7378,  293.5337,  0.0000,    0.0000,    0.0000,    230.0798,  232.2617,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    357.2960,
  0.0000,    0.0000,    0.0000,    0.0000,    325.7625,  0.0000,    0.0000,    0.0000,    0.0000,
  258.8687,  0.0000,    0.0000,    0.0000,    0.0000,    206.4581,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1881.7164, 583.6850,  0.0000,
  0.0000,    0.0000,    1673.1922, 527.3282,  0.0000,    0.0000,    0.0000,    1217.3141, 406.3724,
  0.0000,    0.0000,    0.0000,    858.6799,  312.0540,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1665.7662, 1381.4389, 611.4261,  0.0000,    0.0000,
  1487.2964, 1233.5817, 552.8634,  0.0000,    0.0000,    1098.7485, 911.8321,  427.3949,  0.0000,
  0.0000,    796.1066,  659.7476,  329.5915,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1431.7496, 980.4376,  627.5348,  0.0000,    0.0000,    1281.5229, 880.4900,
  568.1457,  0.0000,    0.0000,    955.5488,  664.5904,  441.2004,  0.0000,    0.0000,    701.9398,
  495.8077,  342.2242,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  592.4047,  0.0000,    0.0000,    0.0000,    0.0000,    536.5626,  0.0000,    0.0000,    0.0000,
  0.0000,    417.2208,  0.0000,    0.0000,    0.0000,    0.0000,    324.1533,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1464.4446, 573.5902,
  0.0000,    0.0000,    0.0000,    1308.6041, 519.6165,  0.0000,    0.0000,    0.0000,    969.7366,
  404.2910,  0.0000,    0.0000,    0.0000,    705.7873,  314.3449,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1401.3191, 561.5498,  0.0000,    0.0000,
  0.0000,    1252.6928, 508.7250,  0.0000,    0.0000,    0.0000,    929.6042,  395.8577,  0.0000,
  0.0000,    0.0000,    678.1931,  307.8310,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1364.8494, 542.9683,  0.0000,    0.0000,    0.0000,    1220.2246,
  491.9700,  0.0000,    0.0000,    0.0000,    905.8860,  383.0238,  0.0000,    0.0000,    0.0000,
  661.3178,  298.0452,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1331.4786, 547.7742,  0.0000,    0.0000,    0.0000,    1190.5003, 496.0959,  0.0000,
  0.0000,    0.0000,    884.1322,  385.6361,  0.0000,    0.0000,    0.0000,    645.7939,  299.4728,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1301.8438,
  534.3757,  0.0000,    0.0000,    0.0000,    1164.1089, 483.2415,  0.0000,    0.0000,    0.0000,
  864.8322,  373.6925,  0.0000,    0.0000,    0.0000,    632.0359,  288.3313,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    996.7924,  552.1545,  0.0000,
  0.0000,    0.0000,    893.9515,  499.9820,  0.0000,    0.0000,    0.0000,    671.2900,  388.4558,
  0.0000,    0.0000,    0.0000,    498.0207,  301.4874,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1162.1560, 516.7263,  0.0000,    0.0000,    0.0000,
  1038.1047, 468.0868,  0.0000,    0.0000,    0.0000,    768.1313,  364.1571,  0.0000,    0.0000,
  0.0000,    557.1841,  283.1061,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1116.0341, 529.4209,  0.0000,    0.0000,    0.0000,    997.3837,  479.1923,
  0.0000,    0.0000,    0.0000,    739.4538,  371.7482,  0.0000,    0.0000,    0.0000,    537.7266,
  287.9502,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1167.9358, 488.8472,  0.0000,    0.0000,    0.0000,    1045.0038, 443.0078,  0.0000,    0.0000,
  0.0000,    778.1323,  345.1182,  0.0000,    0.0000,    0.0000,    570.6508,  268.7620,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1142.5656, 474.3095,
  0.0000,    0.0000,    0.0000,    1022.3674, 429.8982,  0.0000,    0.0000,    0.0000,    761.4623,
  335.0783,  0.0000,    0.0000,    0.0000,    558.6379,  261.1100,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1119.3391, 471.7945,  0.0000,    0.0000,
  0.0000,    1001.6784, 427.5655,  0.0000,    0.0000,    0.0000,    746.3210,  333.1239,  0.0000,
  0.0000,    0.0000,    547.8252,  259.4546,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1107.5215, 499.1071,  0.0000,    0.0000,    0.0000,    990.9808,
  452.0055,  0.0000,    0.0000,    0.0000,    738.0233,  351.3735,  0.0000,    0.0000,    0.0000,
  541.3978,  272.9068,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    916.3824,  455.1960,  0.0000,    0.0000,    0.0000,    821.6005,  412.6170,  0.0000,
  0.0000,    0.0000,    616.4715,  321.7317,  0.0000,    0.0000,    0.0000,    456.8325,  250.8283,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    880.7902,
  644.9282,  456.0290,  0.0000,    0.0000,    791.8456,  581.5718,  413.8249,  0.0000,    0.0000,
  600.0308,  445.3815,  323.8740,  0.0000,    0.0000,    450.8979,  339.1942,  253.6433,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    791.4135,  589.2301,  479.7941,
  0.0000,    0.0000,    712.7422,  532.2864,  434.9778,  0.0000,    0.0000,    543.4462,  410.1206,
  339.2839,  0.0000,    0.0000,    411.7737,  314.8567,  264.5600,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    658.7471,  528.7559,  437.5983,  0.0000,    0.0000,
  594.1616,  478.5546,  397.5411,  0.0000,    0.0000,    455.3313,  371.0891,  312.1979,  0.0000,
  0.0000,    347.2309,  287.2588,  245.5149,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    666.5308,  542.5411,  391.6700,  0.0000,    0.0000,    601.5780,  490.2212,
  356.3985,  0.0000,    0.0000,    462.1194,  377.9737,  281.3708,  0.0000,    0.0000,    353.5264,
  290.4649,  222.6831,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  595.5628,  457.2124,  364.0853,  0.0000,    0.0000,    538.3855,  414.9465,  331.7452,  0.0000,
  0.0000,    415.8526,  324.7873,  263.0472,  0.0000,    0.0000,    320.3875,  254.3721,  209.2591,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    538.9992,  427.2647,
  376.5339,  0.0000,    0.0000,    487.8984,  388.0383,  342.4732,  0.0000,    0.0000,    378.5524,
  304.4031,  269.9296,  0.0000,    0.0000,    293.3116,  239.0673,  213.1931,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    441.2014,  406.3872,  396.9123,  0.0000,
  0.0000,    399.9768,  369.2333,  360.9354,  0.0000,    0.0000,    311.8450,  290.0391,  284.3328,
  0.0000,    0.0000,    243.0764,  228.1594,  224.4480,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    409.7864,  388.3446,  0.0000,    0.0000,    0.0000,    371.7210,
  352.8244,  0.0000,    0.0000,    0.0000,    290.3777,  277.0789,  0.0000,    0.0000,    0.0000,
  226.8850,  217.8961,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    419.8384,  370.2981,  0.0000,    0.0000,    0.0000,    381.0590,  336.9822,  0.0000,
  0.0000,    0.0000,    298.3006,  266.1165,  0.0000,    0.0000,    0.0000,    233.6927,  210.6925,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    648.5037,
  642.2899,  494.7723,  431.4299,  0.0000,    584.6972,  579.5600,  448.4570,  392.0185,  0.0000,
  447.3949,  444.7526,  349.5092,  308.0881,  0.0000,    340.4316,  339.7431,  272.3038,  242.5139,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    622.7134,  570.7867,  522.8751,
  509.9025,  468.0184,  562.6875,  516.5979,  473.9754,  462.5420,  425.1844,  433.9837,  400.6554,
  369.5628,  361.5162,  333.9862,  333.7314,  310.2718,  288.0954,  282.6647,  262.7383,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    559.4336,  545.8655,  529.4977,  510.1646,  0.0000,
  506.8663,  494.8807,  480.3772,  463.2133,  0.0000,    394.5702,  386.0564,  375.6290,  363.1985,
  0.0000,    306.9884,  301.1489,  293.8651,  285.0890,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    526.2600,  525.3265,  521.8274,  0.0000,    0.0000,    477.5862,  476.8590,
  473.8214,  0.0000,    0.0000,    373.8151,  373.5651,  371.5511,  0.0000,    0.0000,    292.7959,
  292.9032,  291.6714,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  477.3816,  483.1435,  0.0000,    0.0000,    0.0000,    434.0969,  439.3457,  0.0000,    0.0000,
  0.0000,    342.0211,  346.1857,  0.0000,    0.0000,    0.0000,    270.0313,  273.3456,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    430.4070,  0.0000,
  0.0000,    0.0000,    0.0000,    392.1169,  0.0000,    0.0000,    0.0000,    0.0000,    310.8162,
  0.0000,    0.0000,    0.0000,    0.0000,    247.1615,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1746.5418, 656.4658,  0.0000,    0.0000,
  0.0000,    1555.8848, 593.1905,  0.0000,    0.0000,    0.0000,    1139.7020, 457.4294,  0.0000,
  0.0000,    0.0000,    813.1166,  351.5586,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1627.9493, 1354.4541, 671.8572,  0.0000,    0.0000,    1455.4241,
  1211.4303, 607.6450,  0.0000,    0.0000,    1080.3973, 900.6966,  470.1071,  0.0000,    0.0000,
  788.4198,  657.7011,  362.8733,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1409.8711, 679.4726,  0.0000,    0.0000,    0.0000,    1263.3724, 615.4785,  0.0000,
  0.0000,    0.0000,    945.9883,  478.7430,  0.0000,    0.0000,    0.0000,    699.1260,  372.1080,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1235.2681,
  801.6846,  0.0000,    0.0000,    0.0000,    1110.0628, 724.2663,  0.0000,    0.0000,    0.0000,
  839.7674,  558.2191,  0.0000,    0.0000,    0.0000,    629.5576,  428.6120,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1240.3071, 710.3488,  0.0000,
  0.0000,    0.0000,    1113.0738, 642.3616,  0.0000,    0.0000,    0.0000,    837.8184,  496.7556,
  0.0000,    0.0000,    0.0000,    623.6462,  382.8186,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1200.0275, 616.5426,  0.0000,    0.0000,    0.0000,
  1077.0005, 558.7128,  0.0000,    0.0000,    0.0000,    810.8538,  435.1351,  0.0000,    0.0000,
  0.0000,    603.7975,  338.7023,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1254.3604, 590.7744,  0.0000,    0.0000,    0.0000,    1123.8008, 535.6195,
  0.0000,    0.0000,    0.0000,    840.6989,  417.8268,  0.0000,    0.0000,    0.0000,    620.5111,
  325.9088,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1211.4443, 745.0109,  0.0000,    0.0000,    0.0000,    1085.6846, 671.6972,  0.0000,    0.0000,
  0.0000,    813.1095,  513.9366,  0.0000,    0.0000,    0.0000,    601.1350,  390.8283,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    317.8574,  292.9994,
  271.8844,  265.1189,  215.8998,  292.9994,  270.2650,  250.9376,  244.6288,  199.7530,  271.8844,
  250.9376,  233.1254,  227.1882,  185.9996,  265.1189,  244.6288,  227.1882,  221.5046,  181.0237,
  215.8998,  199.7530,  185.9996,  181.0237,  149.7734,  244.3546,  236.9864,  233.8752,  216.1303,
  0.0000,    226.0657,  219.2863,  216.3693,  200.1422,  0.0000,    210.4840,  204.1998,  201.4465,
  186.5031,  0.0000,    204.8770,  198.7616,  196.1196,  181.4840,  0.0000,    169.4356,  164.4669,
  162.1289,  150.6308,  0.0000,    200.5374,  198.3266,  194.2314,  0.0000,    0.0000,    186.0051,
  183.9483,  180.1622,  0.0000,    0.0000,    173.5798,  171.6537,  168.1302,  0.0000,    0.0000,
  168.8225,  166.9597,  163.5352,  0.0000,    0.0000,    140.9955,  139.4086,  136.5758,  0.0000,
  0.0000,    161.8686,  160.1879,  0.0000,    0.0000,    0.0000,    150.5231,  148.9559,  0.0000,
  0.0000,    0.0000,    140.7824,  139.3125,  0.0000,    0.0000,    0.0000,    136.8460,  135.4234,
  0.0000,    0.0000,    0.0000,    115.3542,  114.1358,  0.0000,    0.0000,    0.0000,    130.8927,
  0.0000,    0.0000,    0.0000,    0.0000,    122.0012,  0.0000,    0.0000,    0.0000,    0.0000,
  114.3348,  0.0000,    0.0000,    0.0000,    0.0000,    111.1044,  0.0000,    0.0000,    0.0000,
  0.0000,    94.4027,   0.0000,    0.0000,    0.0000,    0.0000,    967.6283,  322.8233,  0.0000,
  0.0000,    0.0000,    881.2624,  296.9409,  0.0000,    0.0000,    0.0000,    805.4924,  274.8056,
  0.0000,    0.0000,    0.0000,    798.8390,  268.9778,  0.0000,    0.0000,    0.0000,    602.2116,
  215.8797,  0.0000,    0.0000,    0.0000,    790.6347,  630.0456,  329.8171,  0.0000,    0.0000,
  722.5111,  576.2962,  303.9725,  0.0000,    0.0000,    664.0977,  529.8946,  281.9814,  0.0000,
  0.0000,    653.4174,  521.7535,  275.2242,  0.0000,    0.0000,    507.2703,  405.6765,  223.6162,
  0.0000,    0.0000,    651.2040,  320.5896,  315.2655,  0.0000,    0.0000,    595.6725,  295.6101,
  291.0037,  0.0000,    0.0000,    548.2115,  274.3493,  270.3548,  0.0000,    0.0000,    538.5754,
  267.7120,  263.5853,  0.0000,    0.0000,    420.8895,  217.9628,  215.7027,  0.0000,    0.0000,
  626.2353,  309.1081,  318.9550,  0.0000,    0.0000,    573.4988,  285.0957,  294.4479,  0.0000,
  0.0000,    528.4593,  264.6302,  273.5887,  0.0000,    0.0000,    518.6333,  258.2554,  266.7243,
  0.0000,    0.0000,    407.8160,  210.3904,  218.3896,  0.0000,    0.0000,    572.1129,  302.8985,
  291.6318,  0.0000,    0.0000,    524.2808,  279.3563,  269.2413,  0.0000,    0.0000,    483.4599,
  259.2925,  250.1591,  0.0000,    0.0000,    474.1585,  253.0661,  243.9654,  0.0000,    0.0000,
  374.2069,  206.1062,  199.6661,  0.0000,    0.0000,    449.2216,  300.3928,  216.8001,  0.0000,
  0.0000,    411.8879,  276.9512,  200.7344,  0.0000,    0.0000,    379.9385,  256.9682,  187.0036,
  0.0000,    0.0000,    372.7838,  250.8827,  182.1854,  0.0000,    0.0000,    294.5037,  203.9633,
  150.8344,  0.0000,    0.0000,    490.8156,  274.9257,  184.0945,  0.0000,    0.0000,    450.2234,
  253.8800,  170.7515,  0.0000,    0.0000,    415.6112,  235.9676,  159.3286,  0.0000,    0.0000,
  407.2425,  230.0182,  155.1095,  0.0000,    0.0000,    323.0948,  188.5834,  129.3324,  0.0000,
  0.0000,    383.7445,  253.7638,  180.8346,  0.0000,    0.0000,    352.2408,  234.4843,  167.6917,
  0.0000,    0.0000,    325.3117,  218.0646,  156.4437,  0.0000,    0.0000,    318.8589,  212.5126,
  152.3164,  0.0000,    0.0000,    253.3965,  174.6758,  126.8932,  0.0000,    0.0000,    405.9907,
  241.9159,  214.5726,  189.5488,  0.0000,    373.0125,  223.5548,  198.4174,  175.5963,  0.0000,
  344.9479,  207.9084,  184.6285,  163.6721,  0.0000,    337.4624,  202.6388,  179.9690,  159.4063,
  0.0000,    270.0881,  166.5674,  148.2259,  132.2884,  0.0000,    419.3593,  236.5952,  199.2855,
  210.4188,  0.0000,    385.0048,  218.6066,  184.4175,  194.4184,  0.0000,    355.7641,  203.2777,
  171.7269,  180.7673,  0.0000,    348.2477,  198.1506,  167.3173,  176.3143,  0.0000,    277.6794,
  162.7632,  138.2635,  144.6644,  0.0000,    320.1913,  234.7548,  0.0000,    0.0000,    0.0000,
  294.1406,  216.6154,  0.0000,    0.0000,    0.0000,    271.8911,  201.1573,  0.0000,    0.0000,
  0.0000,    266.3120,  196.2996,  0.0000,    0.0000,    0.0000,    212.5281,  160.1946,  0.0000,
  0.0000,    0.0000,    327.2810,  218.5282,  0.0000,    0.0000,    0.0000,    301.1709,  202.1306,
  0.0000,    0.0000,    0.0000,    278.9696,  188.1613,  0.0000,    0.0000,    0.0000,    272.5606,
  183.2556,  0.0000,    0.0000,    0.0000,    219.8870,  151.3141,  0.0000,    0.0000,    0.0000,
  389.2656,  364.6110,  285.9761,  231.5432,  0.0000,    357.9411,  335.5206,  263.8740,  214.2270,
  0.0000,    331.2849,  310.7704,  245.0585,  199.4760,  0.0000,    323.8179,  303.5907,  238.9624,
  194.1778,  0.0000,    260.3091,  244.9446,  195.2461,  160.6091,  0.0000,    339.8328,  316.9700,
  301.1380,  268.4370,  235.3944,  313.3911,  292.5335,  278.0671,  248.1965,  218.0074,  290.9092,
  271.7438,  258.4338,  230.9563,  203.1783,  283.6909,  264.8945,  251.8482,  224.9146,  197.6946,
  231.3302,  216.7246,  206.5206,  185.4774,  164.1811,  286.5909,  281.4893,  273.7334,  263.1595,
  0.0000,    265.0711,  260.4044,  253.3112,  243.6410,  0.0000,    246.7379,  242.4359,  235.9012,
  226.9949,  0.0000,    240.2303,  236.0287,  229.6362,  220.9165,  0.0000,    198.4079,  195.0844,
  190.0483,  183.1915,  0.0000,    255.0099,  255.1153,  253.0289,  0.0000,    0.0000,    236.3323,
  236.4253,  234.5066,  0.0000,    0.0000,    220.3806,  220.4624,  218.6853,  0.0000,    0.0000,
  214.4121,  214.4981,  212.7679,  0.0000,    0.0000,    178.4799,  178.5302,  177.1287,  0.0000,
  0.0000,    221.0537,  222.6812,  0.0000,    0.0000,    0.0000,    205.2976,  206.7880,  0.0000,
  0.0000,    0.0000,    191.7992,  193.1738,  0.0000,    0.0000,    0.0000,    186.4927,  187.8378,
  0.0000,    0.0000,    0.0000,    156.4781,  157.5423,  0.0000,    0.0000,    0.0000,    190.3934,
  0.0000,    0.0000,    0.0000,    0.0000,    177.1811,  0.0000,    0.0000,    0.0000,    0.0000,
  165.8230,  0.0000,    0.0000,    0.0000,    0.0000,    161.1703,  0.0000,    0.0000,    0.0000,
  0.0000,    136.2102,  0.0000,    0.0000,    0.0000,    0.0000,    1082.0563, 383.9084,  0.0000,
  0.0000,    0.0000,    986.0438,  353.4142,  0.0000,    0.0000,    0.0000,    901.7739,  327.3080,
  0.0000,    0.0000,    0.0000,    894.0072,  320.2665,  0.0000,    0.0000,    0.0000,    675.8635,
  257.9020,  0.0000,    0.0000,    0.0000,    941.4121,  766.3847,  394.3455,  0.0000,    0.0000,
  860.3421,  701.0009,  363.5872,  0.0000,    0.0000,    790.6765,  644.4017,  337.3757,  0.0000,
  0.0000,    778.3539,  634.9125,  329.3386,  0.0000,    0.0000,    603.7134,  492.9574,  267.8525,
  0.0000,    0.0000,    819.5418,  578.0550,  377.0639,  0.0000,    0.0000,    750.3817,  530.8180,
  348.3162,  0.0000,    0.0000,    691.2029,  490.2154,  323.8305,  0.0000,    0.0000,    678.7577,
  480.7496,  315.6210,  0.0000,    0.0000,    532.6876,  382.0537,  259.1062,  0.0000,    0.0000,
  733.1807,  423.6992,  379.4212,  0.0000,    0.0000,    672.1834,  390.7192,  350.7076,  0.0000,
  0.0000,    620.0792,  362.5672,  326.2431,  0.0000,    0.0000,    608.0848,  354.0018,  317.8567,
  0.0000,    0.0000,    480.7318,  287.9444,  261.6469,  0.0000,    0.0000,    666.1507,  427.8837,
  366.6169,  0.0000,    0.0000,    611.3147,  394.5403,  338.8785,  0.0000,    0.0000,    564.4901,
  366.0984,  315.2073,  0.0000,    0.0000,    553.1447,  357.4612,  307.2381,  0.0000,    0.0000,
  439.4281,  290.6641,  252.7061,  0.0000,    0.0000,    510.2352,  397.6602,  321.5163,  0.0000,
  0.0000,    469.1092,  366.9549,  297.7436,  0.0000,    0.0000,    433.9678,  340.7358,  277.4312,
  0.0000,    0.0000,    424.8072,  332.5980,  270.1899,  0.0000,    0.0000,    340.3478,  271.2960,
  223.9586,  0.0000,    0.0000,    571.0501,  449.1191,  281.8480,  0.0000,    0.0000,    524.6479,
  413.5991,  261.4105,  0.0000,    0.0000,    485.0098,  383.1734,  243.9188,  0.0000,    0.0000,
  474.9418,  374.8284,  237.4146,  0.0000,    0.0000,    379.3148,  302.3644,  197.9963,  0.0000,
  0.0000,    431.2132,  344.2113,  265.5808,  0.0000,    0.0000,    396.9862,  318.1795,  246.4680,
  0.0000,    0.0000,    367.7306,  295.9631,  230.0988,  0.0000,    0.0000,    359.6929,  288.5406,
  223.9239,  0.0000,    0.0000,    289.9361,  237.2798,  187.1659,  0.0000,    0.0000,    472.3738,
  321.4594,  272.0913,  0.0000,    0.0000,    434.7251,  297.2339,  252.1101,  0.0000,    0.0000,
  402.6239,  276.5427,  235.0108,  0.0000,    0.0000,    393.6613,  269.6241,  228.9329,  0.0000,
  0.0000,    317.2064,  221.9100,  190.0213,  0.0000,    0.0000,    436.9463,  297.8174,  285.0138,
  0.0000,    0.0000,    402.3662,  275.4925,  263.9234,  0.0000,    0.0000,    372.8898,  256.4133,
  245.8989,  0.0000,    0.0000,    364.4241,  249.9808,  239.5605,  0.0000,    0.0000,    294.5220,
  206.0675,  198.4222,  0.0000,    0.0000,    363.3585,  288.2863,  0.0000,    0.0000,    0.0000,
  334.6673,  266.6008,  0.0000,    0.0000,    0.0000,    310.1186,  248.0750,  0.0000,    0.0000,
  0.0000,    303.3752,  241.8989,  0.0000,    0.0000,    0.0000,    244.8685,  199.1553,  0.0000,
  0.0000,    0.0000,    383.6790,  284.2139,  0.0000,    0.0000,    0.0000,    353.5976,  263.1438,
  0.0000,    0.0000,    0.0000,    327.9622,  245.1614,  0.0000,    0.0000,    0.0000,    320.3429,
  238.7691,  0.0000,    0.0000,    0.0000,    259.8815,  197.7904,  0.0000,    0.0000,    0.0000,
  485.5392,  461.5093,  367.2028,  309.6779,  0.0000,    446.5937,  424.8293,  339.0315,  286.6412,
  0.0000,    413.3754,  393.5617,  315.0177,  266.9974,  0.0000,    404.3294,  384.6752,  307.2515,
  259.9858,  0.0000,    324.9345,  310.4122,  251.4716,  215.2424,  0.0000,    445.7623,  414.1403,
  399.5774,  357.7428,  321.4363,  410.8960,  382.1255,  368.8796,  330.7531,  297.6403,  381.2230,
  354.8687,  342.7407,  307.7570,  277.3459,  372.0785,  346.1431,  334.2022,  299.8218,  269.9679,
  302.4879,  282.6684,  273.5628,  247.0572,  223.9283,  393.6899,  385.3102,  374.0566,  359.9159,
  0.0000,    363.7846,  356.1681,  345.9236,  333.0384,  0.0000,    338.3189,  331.3449,  321.9519,
  310.1284,  0.0000,    329.6625,  322.8072,  313.5794,  301.9669,  0.0000,    271.0387,  265.8053,
  258.7140,  249.7552,  0.0000,    362.9518,  362.5561,  359.3640,  0.0000,    0.0000,    335.9240,
  335.5914,  332.6960,  0.0000,    0.0000,    312.8750,  312.5939,  309.9478,  0.0000,    0.0000,
  304.6285,  304.3388,  301.7357,  0.0000,    0.0000,    252.1604,  252.0272,  250.0579,  0.0000,
  0.0000,    325.6912,  328.8157,  0.0000,    0.0000,    0.0000,    301.9852,  304.8715,  0.0000,
  0.0000,    0.0000,    281.7256,  284.4096,  0.0000,    0.0000,    0.0000,    274.1045,  276.7161,
  0.0000,    0.0000,    0.0000,    228.5370,  230.6872,  0.0000,    0.0000,    0.0000,    290.4985,
  0.0000,    0.0000,    0.0000,    0.0000,    269.8372,  0.0000,    0.0000,    0.0000,    0.0000,
  252.1337,  0.0000,    0.0000,    0.0000,    0.0000,    245.1798,  0.0000,    0.0000,    0.0000,
  0.0000,    205.8095,  0.0000,    0.0000,    0.0000,    0.0000,    1317.0056, 451.6171,  0.0000,
  0.0000,    0.0000,    1200.5803, 416.4861,  0.0000,    0.0000,    0.0000,    1098.1239, 386.4327,
  0.0000,    0.0000,    0.0000,    1088.8566, 377.4920,  0.0000,    0.0000,    0.0000,    823.8201,
  306.7839,  0.0000,    0.0000,    0.0000,    1201.2021, 994.8926,  475.6506,  0.0000,    0.0000,
  1097.3980, 909.6567,  438.8597,  0.0000,    0.0000,    1007.8503, 835.4801,  407.4620,  0.0000,
  0.0000,    993.2763,  824.3552,  397.6803,  0.0000,    0.0000,    767.6095,  637.1516,  324.2955,
  0.0000,    0.0000,    1049.1934, 732.1211,  491.8929,  0.0000,    0.0000,    960.2332,  672.1591,
  454.2176,  0.0000,    0.0000,    883.8815,  620.5160,  422.1202,  0.0000,    0.0000,    868.8607,
  608.8756,  411.5436,  0.0000,    0.0000,    679.3502,  482.9601,  337.2225,  0.0000,    0.0000,
  465.2631,  0.0000,    0.0000,    0.0000,    0.0000,    429.8074,  0.0000,    0.0000,    0.0000,
  0.0000,    399.5853,  0.0000,    0.0000,    0.0000,    0.0000,    389.5669,  0.0000,    0.0000,
  0.0000,    0.0000,    319.6854,  0.0000,    0.0000,    0.0000,    0.0000,    1061.5213, 450.9253,
  0.0000,    0.0000,    0.0000,    970.3957,  416.6272,  0.0000,    0.0000,    0.0000,    891.9042,
  387.3888,  0.0000,    0.0000,    0.0000,    878.3222,  377.6480,  0.0000,    0.0000,    0.0000,
  681.4251,  310.1096,  0.0000,    0.0000,    0.0000,    1018.5098, 441.5369,  0.0000,    0.0000,
  0.0000,    931.2917,  407.9629,  0.0000,    0.0000,    0.0000,    856.2817,  379.3429,  0.0000,
  0.0000,    0.0000,    842.8268,  369.7985,  0.0000,    0.0000,    0.0000,    655.1209,  303.6993,
  0.0000,    0.0000,    0.0000,    992.7507,  427.2858,  0.0000,    0.0000,    0.0000,    907.7970,
  394.8501,  0.0000,    0.0000,    0.0000,    834.7641,  367.1968,  0.0000,    0.0000,    0.0000,
  821.5324,  357.9364,  0.0000,    0.0000,    0.0000,    638.9063,  294.1261,  0.0000,    0.0000,
  0.0000,    969.1026,  429.9494,  0.0000,    0.0000,    0.0000,    886.2193,  397.1752,  0.0000,
  0.0000,    0.0000,    814.9918,  369.2253,  0.0000,    0.0000,    0.0000,    801.9751,  360.0151,
  0.0000,    0.0000,    0.0000,    623.9763,  295.3345,  0.0000,    0.0000,    0.0000,    948.1288,
  415.9150,  0.0000,    0.0000,    0.0000,    867.0844,  383.7764,  0.0000,    0.0000,    0.0000,
  797.4609,  356.3677,  0.0000,    0.0000,    0.0000,    784.6310,  347.8087,  0.0000,    0.0000,
  0.0000,    610.7486,  283.7443,  0.0000,    0.0000,    0.0000,    739.0200,  433.0662,  0.0000,
  0.0000,    0.0000,    677.4806,  399.9816,  0.0000,    0.0000,    0.0000,    624.7321,  371.7819,
  0.0000,    0.0000,    0.0000,    613.2627,  362.5021,  0.0000,    0.0000,    0.0000,    483.6888,
  297.2065,  0.0000,    0.0000,    0.0000,    839.1776,  406.1522,  0.0000,    0.0000,    0.0000,
  767.3055,  375.2459,  0.0000,    0.0000,    0.0000,    705.0006,  348.9033,  0.0000,    0.0000,
  0.0000,    695.1617,  340.1321,  0.0000,    0.0000,    0.0000,    538.2012,  279.2705,  0.0000,
  0.0000,    0.0000,    808.3322,  414.1717,  0.0000,    0.0000,    0.0000,    739.3975,  382.4286,
  0.0000,    0.0000,    0.0000,    679.6544,  355.3534,  0.0000,    0.0000,    0.0000,    669.8712,
  346.6120,  0.0000,    0.0000,    0.0000,    519.8201,  283.7221,  0.0000,    0.0000,    0.0000,
  854.0740,  385.0952,  0.0000,    0.0000,    0.0000,    781.3748,  355.8982,  0.0000,    0.0000,
  0.0000,    719.0323,  331.0143,  0.0000,    0.0000,    0.0000,    706.9630,  322.6156,  0.0000,
  0.0000,    0.0000,    551.8787,  265.2733,  0.0000,    0.0000,    0.0000,    835.8969,  373.9540,
  0.0000,    0.0000,    0.0000,    764.7668,  345.6425,  0.0000,    0.0000,    0.0000,    703.7881,
  321.5131,  0.0000,    0.0000,    0.0000,    691.9095,  313.3296,  0.0000,    0.0000,    0.0000,
  540.2901,  257.7790,  0.0000,    0.0000,    0.0000,    819.4280,  371.7271,  0.0000,    0.0000,
  0.0000,    749.7413,  343.5475,  0.0000,    0.0000,    0.0000,    690.0184,  319.5322,  0.0000,
  0.0000,    0.0000,    678.2927,  311.4138,  0.0000,    0.0000,    0.0000,    529.8922,  256.0890,
  0.0000,    0.0000,    0.0000,    810.1845,  391.8451,  0.0000,    0.0000,    0.0000,    741.2030,
  361.9140,  0.0000,    0.0000,    0.0000,    682.0827,  336.4239,  0.0000,    0.0000,    0.0000,
  670.5479,  327.9441,  0.0000,    0.0000,    0.0000,    523.5513,  269.0182,  0.0000,    0.0000,
  0.0000,    678.5541,  359.1141,  0.0000,    0.0000,    0.0000,    621.8169,  331.9451,  0.0000,
  0.0000,    0.0000,    573.2433,  308.7930,  0.0000,    0.0000,    0.0000,    562.6706,  300.9015,
  0.0000,    0.0000,    0.0000,    443.2950,  247.6499,  0.0000,    0.0000,    0.0000,    663.3314,
  493.8480,  361.9455,  0.0000,    0.0000,    609.0608,  454.7127,  334.8490,  0.0000,    0.0000,
  562.7866,  421.2426,  311.7468,  0.0000,    0.0000,    551.0457,  411.8870,  303.5984,  0.0000,
  0.0000,    439.2791,  332.3458,  250.8445,  0.0000,    0.0000,    602.1347,  455.7565,  378.6269,
  0.0000,    0.0000,    553.6542,  420.2326,  350.0849,  0.0000,    0.0000,    512.3504,  389.8713,
  325.7067,  0.0000,    0.0000,    501.0728,  380.8064,  317.4639,  0.0000,    0.0000,    402.3253,
  309.3879,  261.3808,  0.0000,    0.0000,    505.1890,  413.3044,  349.1691,  0.0000,    0.0000,
  465.1942,  381.6600,  323.3890,  0.0000,    0.0000,    431.0518,  354.6271,  301.3608,  0.0000,
  0.0000,    421.3667,  346.0161,  293.4671,  0.0000,    0.0000,    340.3120,  283.1217,  243.3863,
  0.0000,    0.0000,    513.2145,  420.1303,  315.1488,  0.0000,    0.0000,    472.7923,  387.4693,
  292.2910,  0.0000,    0.0000,    438.3213,  359.5564,  272.7289,  0.0000,    0.0000,    428.2245,
  351.1848,  265.4501,  0.0000,    0.0000,    346.7667,  285.5672,  221.3716,  0.0000,    0.0000,
  462.6840,  362.8363,  294.9748,  0.0000,    0.0000,    426.7980,  335.7886,  273.8926,  0.0000,
  0.0000,    396.1989,  312.6836,  255.8261,  0.0000,    0.0000,    386.7313,  304.6532,  248.8943,
  0.0000,    0.0000,    315.0876,  251.7856,  208.4942,  0.0000,    0.0000,    421.7839,  340.2737,
  302.0956,  0.0000,    0.0000,    389.4988,  315.1057,  280.1335,  0.0000,    0.0000,    361.9628,
  293.5928,  261.3179,  0.0000,    0.0000,    353.0858,  286.0024,  254.4841,  0.0000,    0.0000,
  289.0970,  236.9427,  211.8881,  0.0000,    0.0000,    347.8817,  324.3237,  318.2285,  0.0000,
  0.0000,    321.7183,  300.4531,  295.0071,  0.0000,    0.0000,    299.3564,  280.0395,  275.1421,
  0.0000,    0.0000,    291.9288,  272.7791,  267.9011,  0.0000,    0.0000,    240.3103,  226.3141,
  222.9268,  0.0000,    0.0000,    324.0925,  309.7648,  0.0000,    0.0000,    0.0000,    299.8858,
  286.9806,  0.0000,    0.0000,    0.0000,    279.1827,  267.4853,  0.0000,    0.0000,    0.0000,
  272.2192,  260.6047,  0.0000,    0.0000,    0.0000,    224.5609,  216.1705,  0.0000,    0.0000,
  0.0000,    333.2167,  298.0483,  0.0000,    0.0000,    0.0000,    308.4263,  276.4586,  0.0000,
  0.0000,    0.0000,    287.2476,  257.9876,  0.0000,    0.0000,    0.0000,    279.9239,  251.1154,
  0.0000,    0.0000,    0.0000,    231.4100,  209.4860,  0.0000,    0.0000,    0.0000,    495.8892,
  493.5629,  389.9229,  344.6238,  0.0000,    456.5872,  454.6872,  360.4734,  319.2229,  0.0000,
  422.9687,  421.4777,  335.3401,  297.5340,  0.0000,    413.7495,  411.9935,  326.9218,  289.7071,
  0.0000,    333.6081,  333.2692,  268.9609,  240.4518,  0.0000,    482.5881,  446.3476,  412.4108,
  403.7564,  373.5814,  445.0036,  412.1123,  381.2538,  373.4529,  345.9586,  412.9602,  382.9249,
  354.6840,  347.6124,  322.3895,  403.1954,  373.5243,  345.6909,  338.6601,  313.8684,  327.9673,
  305.6761,  284.5181,  279.4395,  260.3468,  440.1343,  430.9272,  419.5989,  406.0593,  0.0000,
  406.7017,  398.3895,  388.1313,  375.8478,  0.0000,    378.2078,  370.6542,  361.3025,  350.0833,
  0.0000,    368.6712,  361.1883,  351.9496,  340.8827,  0.0000,    302.9030,  297.4219,  290.5376,
  282.2078,  0.0000,    417.6844,  417.5182,  415.3936,  0.0000,    0.0000,    386.4675,  386.3885,
  384.5110,  0.0000,    0.0000,    359.8412,  359.8342,  358.1639,  0.0000,    0.0000,    350.4967,
  350.4417,  348.7639,  0.0000,    0.0000,    289.6447,  289.8561,  288.7638,  0.0000,    0.0000,
  382.8914,  387.5689,  0.0000,    0.0000,    0.0000,    354.8666,  359.2039,  0.0000,    0.0000,
  0.0000,    330.9249,  334.9723,  0.0000,    0.0000,    0.0000,    322.0794,  326.0077,  0.0000,
  0.0000,    0.0000,    268.0024,  271.2916,  0.0000,    0.0000,    0.0000,    348.5324,  0.0000,
  0.0000,    0.0000,    0.0000,    323.5411,  0.0000,    0.0000,    0.0000,    0.0000,    302.1462,
  0.0000,    0.0000,    0.0000,    0.0000,    293.9018,  0.0000,    0.0000,    0.0000,    0.0000,
  246.0855,  0.0000,    0.0000,    0.0000,    0.0000,    1237.8269, 508.4877,  0.0000,    0.0000,
  0.0000,    1129.8915, 468.9906,  0.0000,    0.0000,    0.0000,    1035.3860, 435.2078,  0.0000,
  0.0000,    0.0000,    1024.4219, 425.0723,  0.0000,    0.0000,    0.0000,    782.4574,  345.6972,
  0.0000,    0.0000,    0.0000,    1183.7103, 985.8045,  523.3093,  0.0000,    0.0000,    1082.5018,
  902.3443,  482.9264,  0.0000,    0.0000,    995.3732,  830.0097,  448.4545,  0.0000,    0.0000,
  979.7618,  817.5351,  437.6413,  0.0000,    0.0000,    761.8362,  636.7053,  357.1817,  0.0000,
  0.0000,    1040.5681, 533.9456,  0.0000,    0.0000,    0.0000,    953.1426,  493.2792,  0.0000,
  0.0000,    0.0000,    878.2550,  458.6209,  0.0000,    0.0000,    0.0000,    862.4189,  447.0785,
  0.0000,    0.0000,    0.0000,    677.8043,  367.0047,  0.0000,    0.0000,    0.0000,    927.5107,
  620.2040,  0.0000,    0.0000,    0.0000,    851.4758,  571.9434,  0.0000,    0.0000,    0.0000,
  786.5317,  530.6548,  0.0000,    0.0000,    0.0000,    770.6095,  518.3645,  0.0000,    0.0000,
  0.0000,    613.1574,  421.2601,  0.0000,    0.0000,    0.0000,    923.2496,  552.1913,  0.0000,
  0.0000,    0.0000,    846.7959,  509.7163,  0.0000,    0.0000,    0.0000,    781.3133,  473.2924,
  0.0000,    0.0000,    0.0000,    766.5520,  462.2417,  0.0000,    0.0000,    0.0000,    606.3220,
  376.9828,  0.0000,    0.0000,    0.0000,    893.6444,  485.3372,  0.0000,    0.0000,    0.0000,
  819.6856,  448.6113,  0.0000,    0.0000,    0.0000,    756.3527,  417.2588,  0.0000,    0.0000,
  0.0000,    742.0253,  406.8282,  0.0000,    0.0000,    0.0000,    587.1009,  334.4442,  0.0000,
  0.0000,    0.0000,    924.1970,  466.3023,  0.0000,    0.0000,    0.0000,    846.5543,  431.1741,
  0.0000,    0.0000,    0.0000,    779.9636,  401.1937,  0.0000,    0.0000,    0.0000,    766.3010,
  391.0575,  0.0000,    0.0000,    0.0000,    601.6779,  322.0437,  0.0000,    0.0000,    0.0000,
  894.3255,  569.3203,  0.0000,    0.0000,    0.0000,    819.3698,  524.2927,  0.0000,    0.0000,
  0.0000,    755.1229,  485.6800,  0.0000,    0.0000,    0.0000,    741.6702,  475.2597,  0.0000,
  0.0000,    0.0000,    583.1471,  383.1338,  0.0000,    0.0000,    0.0000,    191.6887,  186.0684,
  183.4322,  170.4045,  0.0000,    186.0684,  180.6238,  178.0622,  165.4518,  0.0000,    183.4322,
  178.0622,  175.5534,  163.0764,  0.0000,    170.4045,  165.4518,  163.0764,  151.6886,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    159.4898,  157.6971,  154.4935,  0.0000,
  0.0000,    154.9229,  153.1823,  150.0748,  0.0000,    0.0000,    152.6470,  150.9364,  147.8750,
  0.0000,    0.0000,    142.2982,  140.6958,  137.8540,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    130.4725,  129.0956,  0.0000,    0.0000,    0.0000,    126.8312,
  125.4930,  0.0000,    0.0000,    0.0000,    124.9162,  123.6011,  0.0000,    0.0000,    0.0000,
  116.8355,  115.6006,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    106.7698,  0.0000,    0.0000,    0.0000,    0.0000,    103.8653,  0.0000,    0.0000,
  0.0000,    0.0000,    102.2701,  0.0000,    0.0000,    0.0000,    0.0000,    95.9336,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    684.4968,
  244.5729,  0.0000,    0.0000,    0.0000,    663.1184,  237.2191,  0.0000,    0.0000,    0.0000,
  659.2394,  234.4921,  0.0000,    0.0000,    0.0000,    595.1033,  215.8467,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    575.4627,  460.2635,  253.1519,
  0.0000,    0.0000,    557.4255,  446.0170,  245.5654,  0.0000,    0.0000,    552.4889,  442.0702,
  242.4454,  0.0000,    0.0000,    502.9654,  402.8286,  223.9566,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    477.2797,  246.7358,  244.1234,  0.0000,    0.0000,
  462.3511,  239.3701,  236.8740,  0.0000,    0.0000,    457.9608,  236.2965,  233.7282,  0.0000,
  0.0000,    417.7400,  218.4319,  216.4038,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    462.3247,  238.1644,  247.1603,  0.0000,    0.0000,    447.9590,  231.0773,
  239.8294,  0.0000,    0.0000,    443.4723,  228.1087,  236.6374,  0.0000,    0.0000,    405.3462,
  210.9228,  219.1391,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  424.1470,  233.3176,  225.9849,  0.0000,    0.0000,    411.0121,  226.3767,  219.3033,  0.0000,
  0.0000,    406.7672,  223.4784,  216.4101,  0.0000,    0.0000,    372.2326,  206.6274,  200.4053,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    333.8380,  230.9090,
  170.6767,  0.0000,    0.0000,    323.5914,  224.0303,  165.7628,  0.0000,    0.0000,    320.2734,
  221.1986,  163.4733,  0.0000,    0.0000,    293.2680,  204.4081,  152.0010,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    366.1204,  213.4101,  146.3175,  0.0000,
  0.0000,    354.8432,  207.0995,  142.1674,  0.0000,    0.0000,    351.0224,  204.3319,  140.1443,
  0.0000,    0.0000,    321.7679,  189.3102,  130.6248,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    287.1606,  197.6569,  143.5585,  0.0000,    0.0000,    278.4020,
  191.8429,  139.4802,  0.0000,    0.0000,    275.4138,  189.2497,  137.5043,  0.0000,    0.0000,
  252.6740,  175.4919,  128.1271,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    305.9256,  188.4852,  167.7356,  149.6709,  0.0000,    296.5789,  182.9511,  162.8541,
  145.3801,  0.0000,    293.1661,  180.4846,  160.6578,  143.3518,  0.0000,    269.4807,  167.3765,
  149.1158,  133.3956,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    314.5698,
  184.1847,  156.4432,  163.7299,  0.0000,    304.9145,  178.7735,  151.9152,  158.9453,  0.0000,
  301.4974,  176.3750,  149.8328,  156.8549,  0.0000,    276.7985,  163.5301,  139.2201,  145.4133,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    240.7974,  181.3267,  0.0000,
  0.0000,    0.0000,    233.4898,  175.9628,  0.0000,    0.0000,    0.0000,    230.9091,  173.7006,
  0.0000,    0.0000,    0.0000,    212.1340,  160.7225,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    248.9743,  171.1889,  0.0000,    0.0000,    0.0000,
  241.4380,  166.1887,  0.0000,    0.0000,    0.0000,    238.5063,  163.8884,  0.0000,    0.0000,
  0.0000,    219.8016,  152.2000,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    294.7925,  277.3523,  220.9763,  181.6981,  0.0000,    285.8072,  268.9370,
  214.3903,  176.3816,  0.0000,    282.3871,  265.6407,  211.5571,  173.8931,  0.0000,    259.9184,
  244.7964,  195.7667,  161.5591,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  261.8235,  245.2683,  233.7044,  209.8561,  185.7226,  253.9744,  237.9580,  226.7660,  203.6865,
  180.3305,  250.6401,  234.7785,  223.7008,  200.8543,  177.7373,  231.7564,  217.3350,  207.2390,
  186.4258,  165.3571,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    224.4774,  220.7146,
  215.0103,  207.2419,  0.0000,    217.8920,  214.2514,  208.7309,  201.2119,  0.0000,    214.8363,
  211.2380,  205.7784,  198.3402,  0.0000,    199.5009,  196.2122,  191.2265,  184.4364,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    201.9019,  201.9603,  200.3747,  0.0000,
  0.0000,    196.0806,  196.1374,  194.6017,  0.0000,    0.0000,    193.2410,  193.2996,  191.7848,
  0.0000,    0.0000,    179.9374,  179.9862,  178.5907,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    176.9930,  178.1984,  0.0000,    0.0000,    0.0000,    171.9910,
  173.1582,  0.0000,    0.0000,    0.0000,    169.4313,  170.5858,  0.0000,    0.0000,    0.0000,
  158.2104,  159.2666,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    154.0575,  0.0000,    0.0000,    0.0000,    0.0000,    149.7933,  0.0000,    0.0000,
  0.0000,    0.0000,    147.5193,  0.0000,    0.0000,    0.0000,    0.0000,    138.1076,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    768.1335,
  292.1604,  0.0000,    0.0000,    0.0000,    744.2475,  283.4368,  0.0000,    0.0000,    0.0000,
  739.7269,  280.1183,  0.0000,    0.0000,    0.0000,    668.4401,  258.1520,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    684.9632,  559.3821,  303.2521,
  0.0000,    0.0000,    663.5656,  542.1262,  294.2134,  0.0000,    0.0000,    657.7877,  537.4352,
  290.4761,  0.0000,    0.0000,    598.7498,  489.5943,  268.4526,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    603.9916,  433.0171,  293.2324,  0.0000,    0.0000,
  585.2467,  419.8718,  284.5819,  0.0000,    0.0000,    579.5105,  415.3578,  280.7471,  0.0000,
  0.0000,    529.4213,  381.1414,  260.2254,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    544.8882,  326.0087,  296.0806,  0.0000,    0.0000,    528.0841,  316.3169,
  287.3830,  0.0000,    0.0000,    522.5721,  312.3050,  283.4537,  0.0000,    0.0000,    478.5196,
  288.6637,  262.9675,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  497.9703,  329.0947,  285.9926,  0.0000,    0.0000,    482.7036,  319.3099,  277.6188,  0.0000,
  0.0000,    477.4772,  315.2763,  273.8649,  0.0000,    0.0000,    437.9280,  291.3813,  254.0460,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    385.5895,  307.1384,
  253.4123,  0.0000,    0.0000,    373.9427,  298.0661,  246.1086,  0.0000,    0.0000,    369.6794,
  294.2436,  242.6676,  0.0000,    0.0000,    340.0592,  272.2421,  225.7030,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    429.7677,  342.4883,  224.0034,  0.0000,
  0.0000,    416.7080,  332.2783,  217.6347,  0.0000,    0.0000,    412.0413,  328.3317,  214.5176,
  0.0000,    0.0000,    378.6058,  302.7493,  199.9418,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    328.4072,  268.5416,  211.7390,  0.0000,    0.0000,    318.5912,
  260.7012,  205.7533,  0.0000,    0.0000,    314.8297,  257.2059,  202.7848,  0.0000,    0.0000,
  290.2077,  238.6014,  189.1560,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    359.2547,  251.1477,  215.0145,  0.0000,    0.0000,    348.4449,  243.8439,  208.8723,
  0.0000,    0.0000,    344.2987,  240.5751,  205.9678,  0.0000,    0.0000,    317.2629,  223.2549,
  191.6962,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    333.5219,
  233.2106,  224.5211,  0.0000,    0.0000,    323.5276,  226.4605,  218.0675,  0.0000,    0.0000,
  319.6077,  223.4125,  215.0564,  0.0000,    0.0000,    294.7986,  207.4505,  199.9979,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    277.3577,  225.3945,  0.0000,
  0.0000,    0.0000,    269.1220,  218.8617,  0.0000,    0.0000,    0.0000,    265.9503,  215.9419,
  0.0000,    0.0000,    0.0000,    245.2996,  200.4348,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    294.2465,  223.7783,  0.0000,    0.0000,    0.0000,
  285.4802,  217.3199,  0.0000,    0.0000,    0.0000,    281.9469,  214.2984,  0.0000,    0.0000,
  0.0000,    260.3892,  199.2714,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    368.0275,  351.5157,  284.6146,  243.5106,  0.0000,    356.9069,  340.9396,
  276.2154,  236.4461,  0.0000,    352.7247,  336.8285,  272.5864,  233.1422,  0.0000,    324.7346,
  310.5048,  252.4456,  216.7223,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  342.4169,  319.9307,  309.5992,  279.5392,  253.3166,  332.1722,  310.4238,  300.4318,  271.3488,
  245.9773,  327.9460,  306.3712,  296.4572,  267.6299,  242.4940,  303.0033,  283.4898,  274.5293,
  248.3782,  225.5418,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    306.6912,  300.7558,
  292.7145,  282.5564,  0.0000,    297.6598,  291.9225,  284.1462,  274.3202,  0.0000,    293.6168,
  287.9266,  280.2178,  270.4800,  0.0000,    272.2813,  267.1401,  260.1578,  251.3243,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    285.2779,  285.1239,  282.8902,  0.0000,
  0.0000,    276.9809,  276.8372,  274.6795,  0.0000,    0.0000,    273.0920,  272.9417,  270.8005,
  0.0000,    0.0000,    253.8269,  253.7228,  251.7949,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    258.5121,  260.9446,  0.0000,    0.0000,    0.0000,    251.1081,
  253.4677,  0.0000,    0.0000,    0.0000,    247.4732,  249.7992,  0.0000,    0.0000,    0.0000,
  230.5860,  232.7426,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    232.7786,  0.0000,    0.0000,    0.0000,    0.0000,    226.2211,  0.0000,    0.0000,
  0.0000,    0.0000,    222.8660,  0.0000,    0.0000,    0.0000,    0.0000,    208.1507,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    936.3069,
  347.4030,  0.0000,    0.0000,    0.0000,    907.2993,  337.1135,  0.0000,    0.0000,    0.0000,
  901.7293,  332.8876,  0.0000,    0.0000,    0.0000,    815.1518,  307.6574,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    871.1647,  723.2504,  367.1449,
  0.0000,    0.0000,    844.0120,  700.9983,  356.2697,  0.0000,    0.0000,    836.9970,  695.2639,
  351.6844,  0.0000,    0.0000,    761.1433,  632.6159,  325.3328,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    770.4924,  547.4653,  381.6757,  0.0000,    0.0000,
  746.5993,  530.8573,  370.3899,  0.0000,    0.0000,    739.5674,  525.2515,  365.4498,  0.0000,
  0.0000,    674.9489,  481.7395,  338.5362,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    361.8015,  0.0000,    0.0000,    0.0000,    0.0000,    351.1585,  0.0000,
  0.0000,    0.0000,    0.0000,    346.4675,  0.0000,    0.0000,    0.0000,    0.0000,    321.1378,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  773.1721,  350.9578,  0.0000,    0.0000,    0.0000,    749.1438,  340.6470,  0.0000,    0.0000,
  0.0000,    742.6702,  336.0824,  0.0000,    0.0000,    0.0000,    676.2031,  311.5824,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    743.2407,  343.7019,
  0.0000,    0.0000,    0.0000,    720.1450,  333.6065,  0.0000,    0.0000,    0.0000,    713.7913,
  329.1343,  0.0000,    0.0000,    0.0000,    650.2639,  305.1528,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    724.8197,  332.8624,  0.0000,    0.0000,
  0.0000,    702.2959,  323.0966,  0.0000,    0.0000,    0.0000,    696.0628,  318.7539,  0.0000,
  0.0000,    0.0000,    634.2089,  295.5871,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    707.8604,  334.2517,  0.0000,    0.0000,    0.0000,    685.8620,
  324.4246,  0.0000,    0.0000,    0.0000,    679.7433,  320.1057,  0.0000,    0.0000,    0.0000,
  619.4176,  296.6816,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    692.8338,  321.2120,  0.0000,    0.0000,    0.0000,    671.3009,  311.7158,  0.0000,
  0.0000,    0.0000,    665.2819,  307.7168,  0.0000,    0.0000,    0.0000,    606.3141,  284.7085,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    548.3633,
  336.3700,  0.0000,    0.0000,    0.0000,    531.5424,  326.4592,  0.0000,    0.0000,    0.0000,
  526.1827,  322.1177,  0.0000,    0.0000,    0.0000,    481.6031,  298.4773,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    610.8318,  316.0555,  0.0000,
  0.0000,    0.0000,    592.0135,  306.7678,  0.0000,    0.0000,    0.0000,    587.0972,  302.6610,
  0.0000,    0.0000,    0.0000,    534.4195,  280.5856,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    589.8941,  321.1363,  0.0000,    0.0000,    0.0000,
  571.7481,  311.6696,  0.0000,    0.0000,    0.0000,    566.8734,  307.5736,  0.0000,    0.0000,
  0.0000,    516.3864,  284.8700,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    625.9394,  300.1974,  0.0000,    0.0000,    0.0000,    606.4940,  291.3907,
  0.0000,    0.0000,    0.0000,    600.8855,  287.4557,  0.0000,    0.0000,    0.0000,    548.0877,
  266.6113,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  612.7809,  291.7100,  0.0000,    0.0000,    0.0000,    593.7403,  283.1587,  0.0000,    0.0000,
  0.0000,    588.2297,  279.3232,  0.0000,    0.0000,    0.0000,    536.5858,  259.1140,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    600.9701,  289.8009,
  0.0000,    0.0000,    0.0000,    582.2956,  281.2978,  0.0000,    0.0000,    0.0000,    576.8643,
  277.4949,  0.0000,    0.0000,    0.0000,    526.2842,  257.3786,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    593.7911,  304.4460,  0.0000,    0.0000,
  0.0000,    575.3262,  295.4611,  0.0000,    0.0000,    0.0000,    569.9851,  291.5055,  0.0000,
  0.0000,    0.0000,    519.9103,  270.1359,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    502.5517,  280.2406,  0.0000,    0.0000,    0.0000,    487.0619,
  272.0239,  0.0000,    0.0000,    0.0000,    482.1627,  268.3264,  0.0000,    0.0000,    0.0000,
  441.0913,  248.9375,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    497.7015,  376.4065,  283.8239,  0.0000,    0.0000,    482.4616,  365.1235,  275.5427,
  0.0000,    0.0000,    477.0759,  360.7292,  271.7071,  0.0000,    0.0000,    438.0080,  332.5812,
  252.3861,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    455.6970,
  350.3154,  295.8053,  0.0000,    0.0000,    441.8616,  339.9122,  287.1696,  0.0000,    0.0000,
  436.6757,  335.6479,  283.2719,  0.0000,    0.0000,    401.8555,  310.1525,  262.8722,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    385.4109,  320.4932,  275.3876,
  0.0000,    0.0000,    373.8654,  311.0737,  267.4548,  0.0000,    0.0000,    369.3512,  307.0136,
  263.7024,  0.0000,    0.0000,    340.6238,  284.3515,  245.3082,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    392.6604,  323.3397,  250.4475,  0.0000,    0.0000,
  380.9120,  313.7661,  243.3234,  0.0000,    0.0000,    376.2190,  309.8275,  239.8356,  0.0000,
  0.0000,    347.2272,  286.3906,  223.5344,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    356.7088,  284.9170,  235.8544,  0.0000,    0.0000,    346.1326,  276.6705,
  229.2131,  0.0000,    0.0000,    341.7156,  272.8650,  225.8709,  0.0000,    0.0000,    316.0198,
  253.5499,  210.8422,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  327.2304,  268.1083,  239.7434,  0.0000,    0.0000,    317.6085,  260.3972,  232.9410,  0.0000,
  0.0000,    313.4498,  256.7878,  229.6574,  0.0000,    0.0000,    290.3581,  238.8181,  213.9730,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    271.9872,  256.0743,
  252.2194,  0.0000,    0.0000,    264.1091,  248.7407,  245.0309,  0.0000,    0.0000,    260.5907,
  245.2806,  241.5709,  0.0000,    0.0000,    241.8740,  228.2377,  225.0027,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    254.1496,  244.6055,  0.0000,    0.0000,
  0.0000,    246.8308,  237.6179,  0.0000,    0.0000,    0.0000,    243.5211,  234.3332,  0.0000,
  0.0000,    0.0000,    226.2053,  218.0572,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    261.8584,  236.9831,  0.0000,    0.0000,    0.0000,    254.3128,
  230.2585,  0.0000,    0.0000,    0.0000,    250.8427,  226.9709,  0.0000,    0.0000,    0.0000,
  233.1364,  211.5777,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    377.8606,  377.4089,  304.3783,  272.0320,  0.0000,    366.5842,  366.1607,  295.5027,
  264.2073,  0.0000,    362.2556,  361.7246,  291.5389,  260.4972,  0.0000,    333.9709,  333.7972,
  270.4942,  242.3861,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    371.2939,
  345.9762,  321.9613,  316.1825,  294.5285,  360.2631,  335.7795,  312.5506,  306.9694,  286.0200,
  355.7163,  331.3845,  308.3268,  302.7590,  281.9915,  328.7945,  306.9029,  286.0787,  281.1375,
  262.3048,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    342.7788,  336.5482,  328.7291,
  319.2724,  0.0000,    332.7186,  326.7015,  319.1459,  310.0046,  0.0000,    328.2537,  322.2607,
  314.7479,  305.6669,  0.0000,    304.3790,  299.0380,  292.3022,  284.1318,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    327.7136,  327.9420,  326.6948,  0.0000,    0.0000,
  318.1841,  318.4162,  317.2192,  0.0000,    0.0000,    313.7802,  313.9859,  312.7804,  0.0000,
  0.0000,    291.5130,  291.7857,  290.7612,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    303.1717,  306.8904,  0.0000,    0.0000,    0.0000,    294.4710,  298.0806,
  0.0000,    0.0000,    0.0000,    290.2629,  293.8159,  0.0000,    0.0000,    0.0000,    270.2909,
  273.6027,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  278.3441,  0.0000,    0.0000,    0.0000,    0.0000,    270.4677,  0.0000,    0.0000,    0.0000,
  0.0000,    266.5063,  0.0000,    0.0000,    0.0000,    0.0000,    248.7032,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    888.8225,  391.4528,
  0.0000,    0.0000,    0.0000,    861.3824,  379.8612,  0.0000,    0.0000,    0.0000,    855.3214,
  375.0717,  0.0000,    0.0000,    0.0000,    775.4670,  346.7152,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    864.3429,  722.4419,  404.3688,  0.0000,
  0.0000,    837.5128,  700.2807,  392.4061,  0.0000,    0.0000,    830.0834,  694.0552,  387.3287,
  0.0000,    0.0000,    756.3233,  632.9758,  358.4059,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    768.5132,  415.3453,  0.0000,    0.0000,    0.0000,    744.7632,
  403.1240,  0.0000,    0.0000,    0.0000,    737.4095,  397.7211,  0.0000,    0.0000,    0.0000,
  674.0628,  368.6754,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    694.7983,  476.9709,  0.0000,    0.0000,    0.0000,    673.5688,  462.8322,  0.0000,
  0.0000,    0.0000,    666.2141,  457.0273,  0.0000,    0.0000,    0.0000,    611.3824,  422.3705,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    687.2914,
  426.8075,  0.0000,    0.0000,    0.0000,    666.2582,  414.2703,  0.0000,    0.0000,    0.0000,
  659.3738,  408.9930,  0.0000,    0.0000,    0.0000,    604.0542,  378.4719,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    665.4965,  378.5025,  0.0000,
  0.0000,    0.0000,    645.1405,  367.4499,  0.0000,    0.0000,    0.0000,    638.4646,  362.5338,
  0.0000,    0.0000,    0.0000,    584.9601,  336.2789,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    682.2750,  364.4433,  0.0000,    0.0000,    0.0000,
  661.2805,  353.8278,  0.0000,    0.0000,    0.0000,    654.8973,  349.0507,  0.0000,    0.0000,
  0.0000,    598.5678,  323.9548,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    661.2092,  433.9874,  0.0000,    0.0000,    0.0000,    640.8761,  421.0798,
  0.0000,    0.0000,    0.0000,    634.6074,  416.1319,  0.0000,    0.0000,    0.0000,    580.2672,
  383.6707,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  134.0066,  132.4922,  129.8413,  0.0000,    0.0000,    132.4922,  130.9965,  128.3764,  0.0000,
  0.0000,    129.8413,  128.3764,  125.8109,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    110.7006,  109.5270,
  0.0000,    0.0000,    0.0000,    109.4486,  108.2893,  0.0000,    0.0000,    0.0000,    107.2964,
  106.1606,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    91.4014,   0.0000,    0.0000,    0.0000,
  0.0000,    90.3716,   0.0000,    0.0000,    0.0000,    0.0000,    88.6268,   0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    535.2384,  199.4672,  0.0000,    0.0000,    0.0000,    530.5192,
  197.3806,  0.0000,    0.0000,    0.0000,    519.3802,  193.3412,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    456.8443,  366.7711,  207.8531,  0.0000,    0.0000,    452.3745,  363.1951,  205.6006,
  0.0000,    0.0000,    442.8735,  355.6161,  201.3895,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    380.4107,
  202.9672,  201.5466,  0.0000,    0.0000,    376.6142,  200.7622,  199.3322,  0.0000,    0.0000,
  368.7131,  196.6601,  195.2671,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    370.2631,  196.1128,  204.1620,
  0.0000,    0.0000,    366.5151,  193.9845,  201.9181,  0.0000,    0.0000,    358.8554,  190.0290,
  197.8037,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    340.6020,  192.1113,  186.7665,  0.0000,    0.0000,
  337.1250,  190.0299,  184.7241,  0.0000,    0.0000,    330.0938,  186.1576,  180.9710,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    268.8029,  189.9052,  142.6795,  0.0000,    0.0000,    266.0762,  187.8570,
  141.1092,  0.0000,    0.0000,    260.5647,  184.0280,  138.2944,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  295.1737,  176.5165,  123.1170,  0.0000,    0.0000,    292.1257,  174.5775,  121.7541,  0.0000,
  0.0000,    286.0527,  171.0306,  119.3486,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    232.2625,  163.8794,
  120.7060,  0.0000,    0.0000,    229.8776,  162.0750,  119.3719,  0.0000,    0.0000,    225.1357,
  158.7933,  117.0121,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    248.2116,  156.3423,  139.5430,  125.3725,
  0.0000,    245.5988,  154.6243,  138.0159,  123.9905,  0.0000,    240.5175,  151.4983,  135.2456,
  121.5256,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    254.4683,  152.7036,  130.5102,  135.8470,  0.0000,    251.8097,
  151.0286,  129.0763,  134.3737,  0.0000,    246.5864,  147.9753,  126.4947,  131.6741,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    195.4075,  149.6421,  0.0000,    0.0000,    0.0000,    193.3865,  148.0244,  0.0000,
  0.0000,    0.0000,    189.4122,  145.0250,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    203.2427,
  142.4591,  0.0000,    0.0000,    0.0000,    201.0704,  140.8804,  0.0000,    0.0000,    0.0000,
  196.9331,  138.0396,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    239.8183,  226.2796,  182.1380,
  151.2611,  0.0000,    237.2563,  223.8453,  180.1361,  149.5674,  0.0000,    232.3409,  219.2194,
  176.4499,  146.5382,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    215.3101,  202.2863,  193.1315,  174.2716,  155.1691,
  212.9437,  200.0526,  190.9927,  172.3272,  153.4225,  208.5685,  195.9558,  187.0906,  168.8263,
  150.3278,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    186.6348,  183.6462,  179.1160,  172.9456,  0.0000,    184.5467,  181.5905,
  177.1085,  171.0030,  0.0000,    180.8007,  177.9088,  173.5234,  167.5491,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  169.1308,  169.1712,  167.8868,  0.0000,    0.0000,    167.2264,  167.2672,  165.9975,  0.0000,
  0.0000,    163.8681,  163.9083,  162.6659,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    149.4563,  150.4203,
  0.0000,    0.0000,    0.0000,    147.7679,  148.7219,  0.0000,    0.0000,    0.0000,    144.8387,
  145.7724,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    131.0928,  0.0000,    0.0000,    0.0000,
  0.0000,    129.6123,  0.0000,    0.0000,    0.0000,    0.0000,    127.0791,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    602.2221,  239.0572,  0.0000,    0.0000,    0.0000,    596.8763,
  236.5467,  0.0000,    0.0000,    0.0000,    584.3784,  231.7265,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    543.9627,  445.7860,  249.4267,  0.0000,    0.0000,    538.6724,  441.4719,  246.7293,
  0.0000,    0.0000,    527.3838,  432.2783,  241.6949,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    483.3797,
  350.5775,  242.8256,  0.0000,    0.0000,    478.5204,  346.9710,  240.1493,  0.0000,    0.0000,
  468.5269,  339.8082,  235.2717,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    438.3890,  268.3077,  245.7286,
  0.0000,    0.0000,    433.9036,  265.4089,  243.0089,  0.0000,    0.0000,    424.8748,  259.9991,
  238.0843,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    402.1974,  270.8059,  237.4448,  0.0000,    0.0000,
  398.0419,  267.8858,  234.8321,  0.0000,    0.0000,    389.7889,  262.4295,  230.0871,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    313.8657,  253.4985,  211.9069,  0.0000,    0.0000,    310.5861,  250.7573,
  209.5599,  0.0000,    0.0000,    304.2109,  245.6719,  205.3695,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  348.7744,  280.5613,  188.4044,  0.0000,    0.0000,    345.1434,  277.6002,  186.3093,  0.0000,
  0.0000,    338.0296,  271.9434,  182.6170,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    268.7824,  223.0883,
  178.4935,  0.0000,    0.0000,    265.9528,  220.6477,  176.5078,  0.0000,    0.0000,    260.5335,
  216.2066,  173.0241,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    293.5214,  208.9067,  180.2700,  0.0000,
  0.0000,    290.4146,  206.6258,  178.2877,  0.0000,    0.0000,    284.4682,  202.4803,  174.7517,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    273.1568,  194.3373,  187.8007,  0.0000,    0.0000,    270.2524,
  192.2172,  185.7368,  0.0000,    0.0000,    264.7345,  188.3752,  182.0388,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    227.5024,  187.6597,  0.0000,    0.0000,    0.0000,    225.1181,  185.6197,  0.0000,
  0.0000,    0.0000,    220.5585,  181.9100,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    241.7614,
  187.0163,  0.0000,    0.0000,    0.0000,    239.1784,  184.9522,  0.0000,    0.0000,    0.0000,
  234.3154,  181.2582,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    299.9853,  287.3922,  235.3301,
  203.2097,  0.0000,    296.8214,  284.3350,  232.7649,  200.9558,  0.0000,    290.7255,  278.5087,
  228.0473,  196.9225,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    281.3255,  263.8277,  255.8013,  232.2434,  211.6318,
  278.2787,  260.9497,  253.0003,  229.6756,  209.2713,  272.5881,  255.6336,  247.8563,  225.0338,
  205.0687,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    254.2418,  249.6469,  243.3785,  235.4268,  0.0000,    251.4344,  246.8844,
  240.6781,  232.8057,  0.0000,    246.3350,  241.8844,  235.8128,  228.1108,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  237.9018,  237.8571,  236.1456,  0.0000,    0.0000,    235.2519,  235.2059,  233.5109,  0.0000,
  0.0000,    230.5137,  230.4702,  228.8128,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    217.0337,  219.0430,
  0.0000,    0.0000,    0.0000,    214.6002,  216.5866,  0.0000,    0.0000,    0.0000,    210.3176,
  212.2628,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    196.7374,  0.0000,    0.0000,    0.0000,
  0.0000,    194.5237,  0.0000,    0.0000,    0.0000,    0.0000,    190.6822,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    735.0061,  286.0418,  0.0000,    0.0000,    0.0000,    728.4653,
  282.9669,  0.0000,    0.0000,    0.0000,    713.2229,  277.2121,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    690.8651,  575.3317,  302.7908,  0.0000,    0.0000,    684.2353,  569.8509,  299.5059,
  0.0000,    0.0000,    669.9106,  557.9918,  293.4143,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    615.5559,
  442.8799,  315.6193,  0.0000,    0.0000,    609.4420,  438.3496,  312.1500,  0.0000,    0.0000,
  596.7186,  429.3015,  305.7996,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    299.7447,  0.0000,    0.0000,
  0.0000,    0.0000,    296.4581,  0.0000,    0.0000,    0.0000,    0.0000,    290.4555,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    614.8652,  290.9369,  0.0000,    0.0000,    0.0000,
  608.9119,  287.7449,  0.0000,    0.0000,    0.0000,    596.1986,  281.9238,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    591.6752,  284.9529,  0.0000,    0.0000,    0.0000,    585.9134,  281.8265,
  0.0000,    0.0000,    0.0000,    573.6840,  276.1263,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  577.1696,  276.1129,  0.0000,    0.0000,    0.0000,    571.5397,  273.0819,  0.0000,    0.0000,
  0.0000,    559.6108,  267.5627,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    563.7890,  276.9116,
  0.0000,    0.0000,    0.0000,    558.2816,  273.8804,  0.0000,    0.0000,    0.0000,    546.6292,
  268.3382,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    551.9390,  265.0869,  0.0000,    0.0000,
  0.0000,    546.5395,  262.2219,  0.0000,    0.0000,    0.0000,    535.1318,  256.9068,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    441.2303,  278.4551,  0.0000,    0.0000,    0.0000,    436.7785,
  275.4054,  0.0000,    0.0000,    0.0000,    427.7338,  269.8237,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    486.2319,  261.9772,  0.0000,    0.0000,    0.0000,    481.5894,  259.1043,  0.0000,
  0.0000,    0.0000,    471.5858,  253.8632,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    470.2977,
  265.6124,  0.0000,    0.0000,    0.0000,    465.7758,  262.7163,  0.0000,    0.0000,    0.0000,
  456.1062,  257.3927,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    499.4576,  249.0984,  0.0000,
  0.0000,    0.0000,    494.5285,  246.3593,  0.0000,    0.0000,    0.0000,    484.2101,  241.3800,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    489.0107,  242.1588,  0.0000,    0.0000,    0.0000,
  484.1791,  239.4936,  0.0000,    0.0000,    0.0000,    474.0753,  234.6551,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    479.6909,  240.4740,  0.0000,    0.0000,    0.0000,    474.9443,  237.8283,
  0.0000,    0.0000,    0.0000,    465.0326,  233.0206,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  473.7390,  251.9975,  0.0000,    0.0000,    0.0000,    469.0567,  249.2287,  0.0000,    0.0000,
  0.0000,    459.2634,  244.1704,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    403.6718,  232.6687,
  0.0000,    0.0000,    0.0000,    399.5952,  230.1040,  0.0000,    0.0000,    0.0000,    391.2939,
  225.4533,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    402.7947,  307.9813,  236.3271,  0.0000,
  0.0000,    398.5915,  304.7056,  233.6999,  0.0000,    0.0000,    390.3288,  298.4642,  228.9830,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    370.8723,  288.2197,  245.8675,  0.0000,    0.0000,    366.9477,
  285.1197,  243.1608,  0.0000,    0.0000,    359.3797,  279.3141,  238.2558,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    315.5632,  265.2113,  230.3666,  0.0000,    0.0000,    312.2081,  262.3293,  227.8118,
  0.0000,    0.0000,    305.8261,  257.0235,  223.2570,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    322.0022,
  266.3253,  210.6191,  0.0000,    0.0000,    318.5556,  263.4658,  208.2754,  0.0000,    0.0000,
  312.0468,  258.1172,  204.1455,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    294.0021,  237.7045,  199.1859,
  0.0000,    0.0000,    290.8263,  235.0860,  196.9631,  0.0000,    0.0000,    284.9183,  230.3770,
  193.0829,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    270.8551,  224.2493,  201.5855,  0.0000,    0.0000,
  267.9114,  221.7788,  199.3618,  0.0000,    0.0000,    262.4983,  217.3574,  195.4229,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    226.4710,  214.5308,  211.8121,  0.0000,    0.0000,    224.0100,  212.1692,
  209.4703,  0.0000,    0.0000,    219.5335,  207.9536,  205.3192,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  212.1039,  205.0205,  0.0000,    0.0000,    0.0000,    209.7998,  202.7728,  0.0000,    0.0000,
  0.0000,    205.6260,  198.7551,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    218.7185,  199.4350,
  0.0000,    0.0000,    0.0000,    216.3253,  197.2252,  0.0000,    0.0000,    0.0000,    212.0159,
  193.3290,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    309.4057,  309.6161,  252.9803,  227.7137,
  0.0000,    306.1509,  306.3303,  250.2153,  225.1930,  0.0000,    299.9198,  300.0969,  245.1867,
  220.7025,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    305.6389,  286.1418,  267.4961,  263.1882,  246.2323,  302.3505,
  283.0298,  264.5600,  260.2857,  243.4969,  296.2052,  277.3019,  259.2302,  255.0496,  238.6223,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    284.2948,  279.6150,  273.6574,  266.3909,  0.0000,    281.1773,  276.5367,  270.6323,
  263.4327,  0.0000,    275.4969,  270.9585,  265.1832,  258.1402,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    273.0995,
  273.4676,  272.6447,  0.0000,    0.0000,    270.0779,  270.4365,  269.6172,  0.0000,    0.0000,
  264.6481,  265.0016,  264.2022,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    254.1899,  257.3000,  0.0000,
  0.0000,    0.0000,    251.3550,  254.4284,  0.0000,    0.0000,    0.0000,    246.3395,  249.3496,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    234.7563,  0.0000,    0.0000,    0.0000,    0.0000,
  232.1258,  0.0000,    0.0000,    0.0000,    0.0000,    227.5338,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    701.9761,  322.4346,  0.0000,    0.0000,    0.0000,    695.5353,  318.9608,
  0.0000,    0.0000,    0.0000,    681.0241,  312.4727,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  688.3756,  577.4268,  333.7171,  0.0000,    0.0000,    681.6558,  571.8025,  330.0901,  0.0000,
  0.0000,    667.4195,  559.9281,  323.3788,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    616.1319,  344.1377,
  0.0000,    0.0000,    0.0000,    609.9341,  340.3586,  0.0000,    0.0000,    0.0000,    597.2320,
  333.4638,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    562.0636,  392.6218,  0.0000,    0.0000,
  0.0000,    556.2492,  388.4028,  0.0000,    0.0000,    0.0000,    544.7449,  380.5036,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    554.1274,  352.6477,  0.0000,    0.0000,    0.0000,    548.4971,
  348.8497,  0.0000,    0.0000,    0.0000,    537.1536,  341.7951,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    536.7089,  314.3700,  0.0000,    0.0000,    0.0000,    531.2554,  310.9334,  0.0000,
  0.0000,    0.0000,    520.2752,  304.6744,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    547.3189,
  303.1150,  0.0000,    0.0000,    0.0000,    541.8703,  299.7938,  0.0000,    0.0000,    0.0000,
  530.6421,  293.7697,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    530.8828,  355.5941,  0.0000,
  0.0000,    0.0000,    525.5777,  351.8623,  0.0000,    0.0000,    0.0000,    514.6914,  344.7117,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    92.3460,   91.3667,   0.0000,    0.0000,    0.0000,
  91.3667,   90.3985,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    76.9383,   0.0000,    0.0000,    0.0000,    0.0000,    76.1256,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  413.1512,  160.3304,  0.0000,    0.0000,    0.0000,    409.5105,  158.7330,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    357.4737,  288.2182,
  168.0065,  0.0000,    0.0000,    354.0935,  285.4905,  166.2878,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    298.7686,  164.3655,  163.7482,  0.0000,
  0.0000,    295.9028,  162.6806,  162.0542,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    292.1853,  158.9892,  165.9632,  0.0000,    0.0000,    289.3512,
  157.3604,  164.2459,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    269.4863,  155.7507,  151.9416,  0.0000,    0.0000,    266.8557,  154.1576,  150.3757,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    213.3668,
  153.8057,  117.4258,  0.0000,    0.0000,    211.2928,  152.2383,  116.2100,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    234.4533,  143.7001,  101.9746,
  0.0000,    0.0000,    232.1447,  142.2151,  100.9143,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    185.1823,  133.7324,  99.9119,   0.0000,    0.0000,
  183.3661,  132.3480,  98.8747,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    198.3570,  127.6513,  114.3091,  103.3931,  0.0000,    196.3755,  126.3319,
  113.1318,  102.3223,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  202.7705,  124.6317,  107.1976,  111.0248,  0.0000,    200.7571,  123.3457,  106.0905,  109.8900,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    156.3161,  121.6329,
  0.0000,    0.0000,    0.0000,    154.7756,  120.3927,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    163.3848,  116.6637,  0.0000,    0.0000,
  0.0000,    161.7337,  115.4501,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    192.0578,  181.7178,  147.7169,  123.8442,  0.0000,    190.1139,
  179.8683,  146.1873,  122.5429,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    174.1969,  164.1266,  157.0031,  142.3413,  127.4785,  172.3933,  162.4206,  155.3672,
  140.8492,  126.1326,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    152.6035,
  150.2742,  146.7405,  141.9245,  0.0000,    150.9999,  148.6943,  145.1961,  140.4282,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    139.3163,  139.3453,  138.3253,
  0.0000,    0.0000,    137.8443,  137.8735,  136.8644,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    124.0909,  124.8495,  0.0000,    0.0000,    0.0000,
  122.7763,  123.5274,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    109.6839,  0.0000,    0.0000,    0.0000,    0.0000,    108.5226,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  466.1565,  192.7877,  0.0000,    0.0000,    0.0000,    462.0252,  190.8602,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    425.8997,  350.4273,
  201.9997,  0.0000,    0.0000,    421.8867,  347.1255,  199.9353,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    381.2462,  279.7355,  197.8796,  0.0000,
  0.0000,    377.5642,  276.9773,  195.8267,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    347.5334,  217.4322,  200.6665,  0.0000,    0.0000,    344.1318,
  215.2101,  198.5775,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    320.0676,  219.4462,  194.0301,  0.0000,    0.0000,    316.9110,  217.2078,  192.0192,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    251.7723,
  206.0459,  174.3920,  0.0000,    0.0000,    249.2671,  203.9397,  172.5758,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    278.9123,  226.4833,  155.9405,
  0.0000,    0.0000,    276.1455,  224.2095,  154.3118,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    216.8070,  182.4721,  148.0763,  0.0000,    0.0000,
  214.6380,  180.5916,  146.5298,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    236.2750,  171.1187,  148.8148,  0.0000,    0.0000,    233.9031,  169.3584,
  147.2755,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  220.4099,  159.4914,  154.6693,  0.0000,    0.0000,    218.1903,  157.8524,  153.0708,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    183.9876,  153.9032,
  0.0000,    0.0000,    0.0000,    182.1547,  152.3270,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    195.7044,  153.8592,  0.0000,    0.0000,
  0.0000,    193.7273,  152.2646,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    240.9104,  231.4554,  191.5816,  166.8867,  0.0000,    238.4988,
  229.1229,  189.6139,  165.1495,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    227.5635,  214.1723,  208.0402,  189.8824,  173.9517,  225.2381,  211.9709,  205.8954,
  187.9096,  172.1318,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    207.4043,
  203.9103,  199.1082,  192.9893,  0.0000,    205.2512,  201.7898,  197.0330,  190.9724,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    195.1861,  195.2131,  193.9269,
  0.0000,    0.0000,    193.1449,  193.1704,  191.8960,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    179.2306,  180.8604,  0.0000,    0.0000,    0.0000,
  177.3458,  178.9581,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    163.5368,  0.0000,    0.0000,    0.0000,    0.0000,    161.8119,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  569.6701,  231.9483,  0.0000,    0.0000,    0.0000,    564.6006,  229.5837,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    540.3160,  451.5825,
  245.8635,  0.0000,    0.0000,    535.2678,  447.3680,  243.3421,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    484.7691,  353.1467,  256.8455,  0.0000,
  0.0000,    480.1244,  349.6764,  254.1851,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    244.4468,  0.0000,    0.0000,    0.0000,    0.0000,    241.9223,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    482.2509,  237.4072,  0.0000,    0.0000,    0.0000,    477.7197,  234.9544,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    464.5062,
  232.5513,  0.0000,    0.0000,    0.0000,    460.1250,  230.1488,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    453.2313,  225.4562,  0.0000,
  0.0000,    0.0000,    448.9517,  223.1261,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    442.8095,  225.8370,  0.0000,    0.0000,    0.0000,
  438.6243,  223.5079,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    433.5831,  215.4603,  0.0000,    0.0000,    0.0000,    429.4810,  213.2614,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  350.0369,  226.9109,  0.0000,    0.0000,    0.0000,    346.6461,  224.5698,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    381.9584,  213.7617,
  0.0000,    0.0000,    0.0000,    378.3984,  211.5547,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    369.9833,  216.2940,  0.0000,    0.0000,
  0.0000,    366.5166,  214.0702,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    392.9385,  203.4529,  0.0000,    0.0000,    0.0000,    389.1985,
  201.3478,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    384.7496,  197.8642,  0.0000,    0.0000,    0.0000,    381.0847,  195.8155,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    377.4873,
  196.4062,  0.0000,    0.0000,    0.0000,    373.8878,  194.3732,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    372.6267,  205.2969,  0.0000,
  0.0000,    0.0000,    369.0769,  203.1740,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    319.6286,  190.1219,  0.0000,    0.0000,    0.0000,
  316.5327,  188.1509,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    321.1145,  248.2122,  193.6020,  0.0000,    0.0000,    317.9239,  245.7048,
  191.5796,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  297.2839,  233.5360,  201.1396,  0.0000,    0.0000,    294.2982,  231.1571,  199.0537,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    254.5287,  216.1034,
  189.6418,  0.0000,    0.0000,    251.9616,  213.8855,  187.6647,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    260.0805,  216.0769,  174.2982,  0.0000,
  0.0000,    257.4447,  213.8802,  172.4766,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    238.6415,  195.2190,  165.5184,  0.0000,    0.0000,    236.2065,
  193.1956,  163.7850,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    220.7763,  184.6517,  166.8722,  0.0000,    0.0000,    218.5134,  182.7385,  165.1413,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    185.7464,
  176.9516,  175.1017,  0.0000,    0.0000,    183.8435,  175.1199,  173.2829,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    174.3808,  169.2271,  0.0000,
  0.0000,    0.0000,    172.5955,  167.4819,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    179.9124,  165.2099,  0.0000,    0.0000,    0.0000,
  178.0605,  163.4921,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    249.7152,  250.2872,  207.0428,  187.6239,  0.0000,    247.2190,  247.7688,
  204.9123,  185.6743,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  247.8141,  233.0385,  218.7940,  215.6394,  202.5803,  245.2950,  230.6495,  216.5348,  213.4044,
  200.4687,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    232.1219,  228.6709,
  224.2102,  218.7208,  0.0000,    229.7267,  226.3038,  221.8815,  216.4408,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    223.9850,  224.4164,  223.9035,  0.0000,
  0.0000,    221.6567,  222.0800,  221.5689,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    209.6951,  212.2457,  0.0000,    0.0000,    0.0000,    207.5008,
  210.0233,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    194.7778,  0.0000,    0.0000,    0.0000,    0.0000,    192.7316,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    547.2712,
  261.5363,  0.0000,    0.0000,    0.0000,    542.2953,  258.8652,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    540.5868,  455.2593,  271.1408,
  0.0000,    0.0000,    535.4706,  450.9431,  268.3553,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    486.8835,  280.6567,  0.0000,    0.0000,    0.0000,
  482.1772,  277.7545,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    448.0486,  318.3137,  0.0000,    0.0000,    0.0000,    443.6262,  315.0738,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  440.4418,  286.9998,  0.0000,    0.0000,    0.0000,    436.1526,  284.0725,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    426.7354,  257.0875,
  0.0000,    0.0000,    0.0000,    422.5804,  254.4397,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    433.0105,  248.2186,  0.0000,    0.0000,
  0.0000,    428.8619,  245.6584,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    420.3498,  287.2061,  0.0000,    0.0000,    0.0000,    416.3115,
  284.3372,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    64.6462,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    322.1155,
  129.4283,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    281.6823,  228.0892,  136.1638,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    236.1417,  133.4404,  133.2865,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    231.9208,  129.2180,  135.1586,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  214.4002,  126.6027,  123.8635,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    170.3465,  124.9265,
  96.7593,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    187.1728,  117.2057,  84.5107,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    148.4319,  109.3155,  82.7591,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    159.1957,  104.4091,  93.8084,   85.3616,   0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    162.3264,
  101.9116,  88.1829,   90.9553,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    125.6776,  99.1398,   0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    131.8119,  95.6586,   0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    154.3423,  146.3855,  120.0234,  101.4572,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  141.2063,  133.3794,  127.8113,  116.3589,  104.7412,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    124.8561,  123.0358,
  120.2698,  116.4964,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    114.7449,  114.7677,  113.9577,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    102.9471,  103.5467,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    91.6430,   0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    364.4067,
  156.1010,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    335.8690,  277.4759,  164.0275,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    302.5143,  224.3126,  161.5056,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    276.9908,  176.6690,  164.0761,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  255.9769,  178.3183,  158.7915,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    202.8572,  167.9014,
  143.6389,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    224.0794,  183.5205,  129.1105,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    175.5876,  149.5222,  122.8625,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    190.9352,  140.4273,  122.9822,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    178.5021,
  131.1338,  127.5483,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    149.4269,  126.4825,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    158.9650,  126.7356,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    194.2646,  187.0916,  156.3179,  137.2010,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  184.5845,  174.2639,  169.5457,  155.4627,  143.0794,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    169.4533,  166.7796,
  163.0783,  158.3420,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    160.2674,  160.3331,  159.3608,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    148.0216,  149.3430,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    135.8592,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    445.8171,
  188.5950,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    425.7909,  357.1935,  200.1094,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    384.2306,  283.0351,  209.3707,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    199.7138,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  381.0503,  194.0698,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    367.3163,  190.1224,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    358.4721,  184.4110,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    350.2812,  184.5332,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    343.0307,  175.5908,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    279.3515,
  185.2621,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    302.4149,  174.7380,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    293.2905,  176.5117,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    311.2487,  166.4466,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  304.7748,  161.9300,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    299.0622,  160.6761,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    295.0836,  167.5526,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    254.5979,  155.5916,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    257.1651,  200.7343,  158.7463,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    239.2291,
  189.7641,  164.7805,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    206.0286,  176.4763,  156.2347,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    210.7497,  175.8214,  144.2814,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    194.2314,  160.5301,  137.5233,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  180.3711,  152.2203,  138.2371,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    152.6567,  146.1166,
  144.8625,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    143.6486,  139.8632,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    148.2325,  136.9373,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    202.3639,  203.0702,  169.7709,  154.7419,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    201.5330,
  190.2365,  179.2701,  176.9336,  166.8114,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    189.8756,  187.3061,  183.9368,
  179.7560,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    183.9223,  184.3601,  184.0479,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    173.0668,  175.1529,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  161.5778,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    430.4468,  212.6910,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    427.5147,  361.4493,  220.7874,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    387.0720,  229.2849,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    358.9273,  258.8120,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    352.0743,
  234.1847,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    341.2340,  210.6366,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    344.8305,  203.6156,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    334.9759,  232.9196,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  4983.5009, 1112.2277, 0.0000,    0.0000,    0.0000,    1112.2277, 338.0207,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3240.4393, 2661.0830,
  1030.5394, 0.0000,    0.0000,    860.1771,  688.9911,  337.7795,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2549.9412, 988.5881,  943.3962,  0.0000,
  0.0000,    700.7281,  327.7092,  320.0043,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2374.6690, 960.3376,  951.6268,  0.0000,    0.0000,    668.7546,
  316.2518,  323.6190,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2124.1985, 941.9837,  879.7445,  0.0000,    0.0000,    607.9951,  310.1108,  296.7431,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1683.6701,
  945.8700,  617.0566,  0.0000,    0.0000,    478.9744,  308.3901,  218.9044,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1768.0322, 814.2468,  503.8621,
  0.0000,    0.0000,    518.0583,  278.7259,  184.8170,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1388.9522, 742.2520,  497.3105,  0.0000,    0.0000,
  406.0876,  256.7579,  181.7040,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1382.9771, 710.1818,  628.1238,  531.3044,  0.0000,    423.3809,  245.0188,
  217.5967,  190.9521,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1458.4501, 697.7650,  570.8659,  630.1412,  0.0000,    439.2845,  239.8849,  201.3799,  214.4961,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1129.9518, 722.0002,
  0.0000,    0.0000,    0.0000,    337.1117,  240.1791,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1062.5928, 621.4841,  0.0000,    0.0000,
  0.0000,    337.8986,  219.9852,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1292.8121, 1184.8327, 865.1066,  648.6879,  0.0000,    403.0745,
  375.8495,  290.5739,  231.9989,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1032.6651, 946.5756,  887.7075,  766.5714,  645.2973,  345.4434,  321.1574,  304.4222,
  269.8403,  234.9742,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    810.6554,
  793.6306,  766.5311,  728.6195,  0.0000,    287.5535,  282.3070,  274.2325,  263.1547,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    692.9116,  693.9818,  687.7370,
  0.0000,    0.0000,    254.3670,  254.5376,  252.4498,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    577.2318,  582.8914,  0.0000,    0.0000,    0.0000,
  219.4647,  221.1642,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    480.2472,  0.0000,    0.0000,    0.0000,    0.0000,    188.4819,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  5530.2806, 1305.8840, 0.0000,    0.0000,    0.0000,    1240.8631, 401.0371,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3915.3529, 3302.2504,
  1234.9320, 0.0000,    0.0000,    1027.9671, 841.9983,  404.3537,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3166.0625, 2163.7031, 1110.5426, 0.0000,
  0.0000,    879.0346,  613.8463,  381.7778,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2711.1542, 1335.9899, 1099.8393, 0.0000,    0.0000,    778.5238,
  435.0649,  383.0224,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2400.6918, 1343.3714, 1078.8336, 0.0000,    0.0000,    703.3060,  439.5228,  371.4433,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1765.8946,
  1237.9643, 905.0848,  0.0000,    0.0000,    534.6303,  407.5906,  323.6381,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2007.6137, 1518.8755, 767.9339,
  0.0000,    0.0000,    599.9302,  468.0977,  282.4384,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1447.3048, 1015.7997, 715.2376,  0.0000,    0.0000,
  449.3030,  349.4753,  265.8033,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1567.4954, 948.5140,  767.4205,  0.0000,    0.0000,    490.5807,  326.5947,
  274.5928,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1424.0271, 873.2984,  809.4255,  0.0000,    0.0000,    452.2464,  302.4635,  287.8260,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1218.4699, 851.0088,
  0.0000,    0.0000,    0.0000,    379.0836,  293.2911,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1222.5553, 800.2593,  0.0000,    0.0000,
  0.0000,    395.5135,  286.2735,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1638.8153, 1517.3687, 1110.1907, 869.9598,  0.0000,    505.6838,
  478.0141,  374.0585,  311.3187,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1390.2912, 1259.5964, 1198.2993, 1031.5350, 891.2091,  456.4613,  422.0055,  406.0845,
  360.9675,  322.1273,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1147.6700,
  1113.9369, 1069.4211, 1013.8323, 0.0000,    397.8416,  388.7844,  376.6755,  361.4928,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1019.3121, 1015.7738, 1002.5559,
  0.0000,    0.0000,    364.4090,  363.8482,  360.3799,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    880.1741,  889.0026,  0.0000,    0.0000,    0.0000,
  325.1068,  328.2207,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    758.3253,  0.0000,    0.0000,    0.0000,    0.0000,    288.7275,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  6808.3900, 1449.5860, 0.0000,    0.0000,    0.0000,    1511.8898, 465.5182,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    5171.2978, 4495.8369,
  1476.8694, 0.0000,    0.0000,    1322.2619, 1104.1068, 486.9346,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4185.8968, 2800.9569, 1467.2405, 0.0000,
  0.0000,    1133.7749, 780.6806,  499.2067,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1381.0183, 0.0000,    0.0000,    0.0000,    0.0000,    472.2455,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    4473.7784, 1333.7958, 0.0000,    0.0000,    0.0000,    1162.2835, 457.4338,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4216.3998,
  1304.7563, 0.0000,    0.0000,    0.0000,    1111.2638, 447.8636,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4092.0575, 1259.0280, 0.0000,
  0.0000,    0.0000,    1082.0865, 433.2074,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    3979.6309, 1283.6315, 0.0000,    0.0000,    0.0000,
  1055.3891, 436.8854,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    3879.4729, 1285.6965, 0.0000,    0.0000,    0.0000,    1031.6716, 425.9370,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2817.6333, 1292.7733, 0.0000,    0.0000,    0.0000,    790.7854,  439.9765,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3687.6305, 1201.3307,
  0.0000,    0.0000,    0.0000,    927.3672,  412.0655,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3526.9705, 1255.3434, 0.0000,    0.0000,
  0.0000,    890.5056,  422.0535,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3419.5160, 1127.9480, 0.0000,    0.0000,    0.0000,    924.6197,
  389.9518,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    3337.2227, 1091.5091, 0.0000,    0.0000,    0.0000,    904.3257,  378.4205,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3259.9368,
  1087.6970, 0.0000,    0.0000,    0.0000,    885.7538,  376.3047,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3231.7117, 1160.0767, 0.0000,
  0.0000,    0.0000,    876.2899,  397.2856,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2592.1299, 1044.4701, 0.0000,    0.0000,    0.0000,
  725.6441,  363.0799,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2330.0562, 1653.9476, 1027.4537, 0.0000,    0.0000,    696.1831,  512.8153,
  364.0815,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2026.6698, 1460.4707, 1112.6264, 0.0000,    0.0000,    626.3442,  469.4105,  383.5190,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1664.4321, 1265.2105,
  979.1991,  0.0000,    0.0000,    523.6892,  422.2410,  351.1876,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1656.3829, 1339.3807, 858.3565,  0.0000,
  0.0000,    529.6249,  432.7098,  315.7277,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1439.6620, 1042.0654, 783.9818,  0.0000,    0.0000,    474.2539,
  366.5511,  294.5515,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1275.5198, 965.0626,  838.8447,  0.0000,    0.0000,    430.1964,  343.3431,  304.1340,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1029.9899,
  913.8533,  879.7634,  0.0000,    0.0000,    354.1411,  327.1139,  319.9170,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    950.6218,  877.5783,  0.0000,
  0.0000,    0.0000,    329.6471,  313.0324,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    957.3617,  810.5040,  0.0000,    0.0000,    0.0000,
  337.3335,  298.8719,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1669.9732, 1619.9398, 1148.8307, 959.7442,  0.0000,    516.9533,  511.6460,
  395.8624,  346.4279,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1516.4193, 1351.4635, 1205.8672, 1160.2124, 1039.5015, 495.6981,  455.1207,  417.7483,  407.6191,
  375.0355,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1296.6253, 1251.9864,
  1200.4050, 1140.9307, 0.0000,    446.3033,  435.7852,  423.0909,  408.0824,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1189.1902, 1181.9863, 1168.5636, 0.0000,
  0.0000,    420.8684,  420.2116,  417.5603,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1048.6754, 1060.5365, 0.0000,    0.0000,    0.0000,    383.3533,
  387.9111,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    923.4896,  0.0000,    0.0000,    0.0000,    0.0000,    347.3437,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    6020.9123,
  1623.5241, 0.0000,    0.0000,    0.0000,    1400.1686, 523.4690,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4912.8581, 4218.9528, 1618.3210,
  0.0000,    0.0000,    1291.5073, 1080.6042, 535.2211,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    4017.4782, 1579.6611, 0.0000,    0.0000,    0.0000,
  1115.9288, 541.5052,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    3320.8171, 2000.7417, 0.0000,    0.0000,    0.0000,    978.1928,  639.2447,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  3457.0434, 1778.9468, 0.0000,    0.0000,    0.0000,    983.9131,  568.3831,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3337.6961, 1438.7994,
  0.0000,    0.0000,    0.0000,    952.0627,  493.0590,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3608.5602, 1364.3503, 0.0000,    0.0000,
  0.0000,    995.3527,  472.7221,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3458.6883, 1950.9820, 0.0000,    0.0000,    0.0000,    961.0543,
  595.0456,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2352.6862, 1886.4221, 832.2379,  0.0000,    0.0000,    1886.4221, 1525.1891, 664.0620,
  0.0000,    0.0000,    832.2379,  664.0620,  343.3343,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1888.7902,
  803.2380,  774.1368,  0.0000,    0.0000,    1510.1427, 640.7076,  618.1676,  0.0000,    0.0000,
  683.8786,  333.6780,  327.6458,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1779.5162, 774.6863,  781.7679,
  0.0000,    0.0000,    1422.3244, 619.4301,  624.3036,  0.0000,    0.0000,    656.7474,  321.8441,
  331.4851,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1604.9178, 760.0718,  718.1630,  0.0000,    0.0000,
  1282.1610, 607.5571,  574.2351,  0.0000,    0.0000,    599.4521,  315.4686,  303.3970,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1263.0809, 759.3684,  513.7768,  0.0000,    0.0000,    1011.5955, 607.0700,
  412.0610,  0.0000,    0.0000,    471.3832,  313.0538,  225.6881,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1351.4785, 670.8337,  425.2382,  0.0000,    0.0000,    1079.1532, 535.8149,  341.7674,  0.0000,
  0.0000,    513.6516,  285.8068,  191.6322,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1056.5193, 613.9233,
  419.0635,  0.0000,    0.0000,    845.4686,  490.7481,  336.7038,  0.0000,    0.0000,    402.1872,
  263.7930,  188.2696,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1081.7690, 585.9578,  517.8769,  445.0681,
  0.0000,    862.5036,  468.6899,  414.8338,  357.0721,  0.0000,    423.9523,  251.5841,  223.4273,
  197.3201,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1132.1074, 574.7522,  474.8225,  515.5415,  0.0000,    902.6014,
  459.6812,  380.4201,  412.6142,  0.0000,    438.2482,  246.1156,  207.4440,  219.3679,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    868.3674,  585.3704,  0.0000,    0.0000,    0.0000,    694.5058,  467.9156,  0.0000,
  0.0000,    0.0000,    335.3592,  244.6716,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    846.8527,
  519.5182,  0.0000,    0.0000,    0.0000,    675.0299,  415.5638,  0.0000,    0.0000,    0.0000,
  341.1923,  227.0118,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1019.8835, 942.5828,  706.2041,
  545.4548,  0.0000,    813.4943,  751.8144,  564.1147,  436.2844,  0.0000,    405.6488,  379.6650,
  297.1084,  240.0800,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    843.3644,  777.5361,  732.6433,  639.8000,  546.4784,
  672.6917,  620.6735,  585.0515,  511.5374,  437.6779,  352.9336,  329.0554,  312.5424,  278.4205,
  243.9590,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    679.0044,  665.3221,  644.0351,  614.6705,  0.0000,    543.0123,  532.2461,
  515.4323,  492.1704,  0.0000,    297.1426,  291.8601,  283.8013,  272.7959,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  587.9647,  588.5763,  583.4009,  0.0000,    0.0000,    471.4822,  471.9821,  467.8832,  0.0000,
  0.0000,    264.3790,  264.5072,  262.3613,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    495.9754,  500.4152,
  0.0000,    0.0000,    0.0000,    399.0226,  402.5380,  0.0000,    0.0000,    0.0000,    229.3147,
  231.0107,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    416.9777,  0.0000,    0.0000,    0.0000,
  0.0000,    336.6483,  0.0000,    0.0000,    0.0000,    0.0000,    197.7645,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3599.4349, 1013.0706, 0.0000,    0.0000,    0.0000,    2958.0410,
  812.3489,  0.0000,    0.0000,    0.0000,    1152.0197, 401.6572,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2819.4935, 2314.8420, 994.4676,  0.0000,    0.0000,    2265.4155, 1876.9417, 794.5479,
  0.0000,    0.0000,    991.9143,  808.6909,  410.7857,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2350.8018,
  1603.6362, 916.0855,  0.0000,    0.0000,    1882.1338, 1293.5159, 732.1243,  0.0000,    0.0000,
  860.3229,  605.8453,  391.8360,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2048.5251, 1070.9104, 912.5205,
  0.0000,    0.0000,    1637.9667, 856.7131,  729.6211,  0.0000,    0.0000,    768.2000,  441.4951,
  394.1110,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1830.8523, 1081.9930, 887.6167,  0.0000,    0.0000,
  1463.8890, 864.1411,  710.7573,  0.0000,    0.0000,    697.3148,  445.9895,  381.2592,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1365.4837, 996.0157,  757.0858,  0.0000,    0.0000,    1092.6733, 797.4773,
  607.0919,  0.0000,    0.0000,    533.7978,  414.4811,  334.3206,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1543.4258, 1178.3302, 649.5000,  0.0000,    0.0000,    1234.9316, 945.9943,  521.8458,  0.0000,
  0.0000,    597.4915,  469.5752,  293.1198,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1131.1769, 835.2692,
  607.2921,  0.0000,    0.0000,    905.7515,  668.7646,  488.3352,  0.0000,    0.0000,    450.9597,
  358.3732,  276.2842,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1234.6013, 779.0547,  640.1431,  0.0000,
  0.0000,    986.3727,  624.2850,  514.1385,  0.0000,    0.0000,    493.3926,  334.8827,  283.4399,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1129.6670, 718.4983,  674.5740,  0.0000,    0.0000,    902.4405,
  576.1374,  541.0773,  0.0000,    0.0000,    456.2063,  310.3909,  296.8146,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    951.4935,  698.8618,  0.0000,    0.0000,    0.0000,    762.6174,  560.1298,  0.0000,
  0.0000,    0.0000,    380.4283,  300.6094,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    978.4251,
  670.2633,  0.0000,    0.0000,    0.0000,    781.6600,  537.0889,  0.0000,    0.0000,    0.0000,
  400.4535,  295.6941,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1281.2612, 1198.9287, 905.1186,
  729.9594,  0.0000,    1024.1614, 957.9897,  723.9814,  584.4834,  0.0000,    507.2605,  481.6729,
  382.2720,  321.8065,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1123.0616, 1026.6097, 981.8206,  857.4537,  751.4576,
  896.4155,  819.9926,  784.4219,  685.8003,  601.8691,  464.1193,  430.8853,  415.5727,  371.7123,
  333.7206,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    950.6543,  925.3266,  891.8232,  850.0618,  0.0000,    759.7988,  739.8380,
  713.3777,  680.3184,  0.0000,    409.0173,  400.2337,  388.4468,  373.6423,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  855.1882,  852.9036,  843.0540,  0.0000,    0.0000,    684.7073,  682.9621,  675.2096,  0.0000,
  0.0000,    376.8093,  376.3706,  373.0245,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    747.9306,  755.3478,
  0.0000,    0.0000,    0.0000,    600.2698,  606.1859,  0.0000,    0.0000,    0.0000,    338.0494,
  341.2732,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    651.5392,  0.0000,    0.0000,    0.0000,
  0.0000,    524.3547,  0.0000,    0.0000,    0.0000,    0.0000,    301.6273,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    4387.1669, 1149.8295, 0.0000,    0.0000,    0.0000,    3619.2660,
  921.7934,  0.0000,    0.0000,    0.0000,    1402.1290, 471.0509,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    3659.1655, 3070.4624, 1190.5306, 0.0000,    0.0000,    2951.3362, 2505.6537, 952.5771,
  0.0000,    0.0000,    1267.8490, 1051.9461, 495.4172,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3059.8941,
  2050.4253, 1204.1091, 0.0000,    0.0000,    2456.7601, 1658.3459, 962.2662,  0.0000,    0.0000,
  1103.1556, 767.9412,  511.3063,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1134.6748, 0.0000,    0.0000,
  0.0000,    0.0000,    907.4012,  0.0000,    0.0000,    0.0000,    0.0000,    483.9715,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    3190.2086, 1097.1659, 0.0000,    0.0000,    0.0000,
  2571.5319, 877.5528,  0.0000,    0.0000,    0.0000,    1119.4842, 469.0498,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    3036.3662, 1073.8235, 0.0000,    0.0000,    0.0000,    2442.0495, 858.8383,
  0.0000,    0.0000,    0.0000,    1073.3952, 459.2919,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2952.9794, 1037.1340, 0.0000,    0.0000,    0.0000,    2374.0445, 829.6408,  0.0000,    0.0000,
  0.0000,    1046.0388, 444.4629,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2877.0680, 1050.9848,
  0.0000,    0.0000,    0.0000,    2312.2147, 841.0519,  0.0000,    0.0000,    0.0000,    1020.9351,
  447.3826,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2809.5233, 1039.4662, 0.0000,    0.0000,
  0.0000,    2257.1993, 831.2750,  0.0000,    0.0000,    0.0000,    998.6585,  433.5252,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2094.5326, 1059.7192, 0.0000,    0.0000,    0.0000,    1680.6338,
  847.4486,  0.0000,    0.0000,    0.0000,    776.0695,  450.5280,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2564.1443, 988.5095,  0.0000,    0.0000,    0.0000,    2081.6173, 790.5227,  0.0000,
  0.0000,    0.0000,    887.0421,  422.5156,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2451.7734,
  1021.3342, 0.0000,    0.0000,    0.0000,    1992.8728, 817.4261,  0.0000,    0.0000,    0.0000,
  853.8199,  431.1749,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2501.4164, 931.7443,  0.0000,
  0.0000,    0.0000,    2006.2958, 745.1781,  0.0000,    0.0000,    0.0000,    898.6515,  400.4754,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2444.6758, 902.8445,  0.0000,    0.0000,    0.0000,
  1960.2391, 722.1111,  0.0000,    0.0000,    0.0000,    879.3887,  388.8507,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2391.9954, 898.8634,  0.0000,    0.0000,    0.0000,    1917.4640, 718.8719,
  0.0000,    0.0000,    0.0000,    861.8975,  386.5382,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2369.0958, 955.0787,  0.0000,    0.0000,    0.0000,    1899.1306, 763.2645,  0.0000,    0.0000,
  0.0000,    852.2547,  407.3976,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1925.5453, 865.2829,
  0.0000,    0.0000,    0.0000,    1544.6852, 692.0083,  0.0000,    0.0000,    0.0000,    712.2608,
  373.3213,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1797.1024, 1289.4650, 858.7351,  0.0000,
  0.0000,    1435.1503, 1034.1456, 687.2356,  0.0000,    0.0000,    693.4471,  515.5477,  375.8352,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1589.4883, 1159.7504, 914.4703,  0.0000,    0.0000,    1268.7518,
  929.4379,  732.9927,  0.0000,    0.0000,    628.5566,  475.2624,  393.7862,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1311.7641, 1023.7513, 820.2766,  0.0000,    0.0000,    1049.3296, 820.1982,  657.8095,
  0.0000,    0.0000,    527.4527,  430.5842,  363.0051,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1317.2961,
  1066.4078, 726.1164,  0.0000,    0.0000,    1052.9922, 854.4309,  583.3720,  0.0000,    0.0000,
  535.3314,  438.3207,  327.7019,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1161.2618, 864.5271,  668.7458,
  0.0000,    0.0000,    928.4521,  693.1742,  538.1181,  0.0000,    0.0000,    482.2294,  377.5370,
  306.7634,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1039.8993, 804.3806,  703.0610,  0.0000,    0.0000,
  831.8752,  645.3069,  565.3470,  0.0000,    0.0000,    439.4127,  354.2005,  314.6586,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    844.4387,  763.2799,  740.1981,  0.0000,    0.0000,    676.9902,  612.6615,
  594.4240,  0.0000,    0.0000,    362.7872,  337.7333,  331.2432,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  781.6044,  730.9466,  0.0000,    0.0000,    0.0000,    627.0853,  586.9804,  0.0000,    0.0000,
  0.0000,    338.1275,  322.8524,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    794.6585,  686.3343,
  0.0000,    0.0000,    0.0000,    637.1112,  551.4220,  0.0000,    0.0000,    0.0000,    347.2100,
  310.2090,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1301.2325, 1276.8842, 944.9475,  806.8500,
  0.0000,    1043.0556, 1022.4025, 756.7881,  646.8975,  0.0000,    518.7107,  515.6440,  406.0640,
  358.4368,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1218.7009, 1101.5257, 995.7893,  964.8298,  874.8589,  974.2845,
  880.9955,  797.0009,  772.3000,  700.9780,  503.2187,  464.8762,  429.1133,  419.8573,  388.2085,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1068.6331, 1037.1898, 1000.1815, 957.0936,  0.0000,    854.6640,  829.7866,  800.5025,
  766.3809,  0.0000,    457.9078,  448.1223,  436.1382,  421.8520,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    992.2125,
  988.2709,  979.2896,  0.0000,    0.0000,    794.4491,  791.4164,  784.3917,  0.0000,    0.0000,
  434.1487,  433.8711,  431.5673,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    886.7938,  897.1564,  0.0000,
  0.0000,    0.0000,    711.4143,  719.7141,  0.0000,    0.0000,    0.0000,    397.7546,  402.5559,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    789.4651,  0.0000,    0.0000,    0.0000,    0.0000,
  634.7921,  0.0000,    0.0000,    0.0000,    0.0000,    362.0675,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    3988.5535, 1290.6007, 0.0000,    0.0000,    0.0000,    3271.2563, 1034.5424,
  0.0000,    0.0000,    0.0000,    1313.9837, 530.1889,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  3528.9590, 2955.5781, 1306.0236, 0.0000,    0.0000,    2840.9447, 2400.4019, 1045.2655, 0.0000,
  0.0000,    1247.1871, 1039.8007, 544.9337,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2977.1478, 1299.8428,
  0.0000,    0.0000,    0.0000,    2386.7637, 1039.3542, 0.0000,    0.0000,    0.0000,    1092.5678,
  555.2692,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2537.7308, 1579.5049, 0.0000,    0.0000,
  0.0000,    2029.6245, 1268.2110, 0.0000,    0.0000,    0.0000,    970.9362,  646.8911,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2589.2888, 1393.9683, 0.0000,    0.0000,    0.0000,    2076.1172,
  1124.3632, 0.0000,    0.0000,    0.0000,    968.7708,  576.0927,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2503.3576, 1179.8248, 0.0000,    0.0000,    0.0000,    2006.6915, 945.1224,  0.0000,
  0.0000,    0.0000,    937.7422,  505.3448,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2661.1178,
  1125.4292, 0.0000,    0.0000,    0.0000,    2135.2269, 901.2992,  0.0000,    0.0000,    0.0000,
  972.0352,  485.4245,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2561.2750, 1501.0394, 0.0000,
  0.0000,    0.0000,    2054.0131, 1207.4896, 0.0000,    0.0000,    0.0000,    940.2033,  595.8471,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1522.4676, 660.6780,  638.4869,  0.0000,    0.0000,
  660.6780,  324.5068,  318.8004,  0.0000,    0.0000,    638.4869,  318.8004,  313.9846,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1438.2841, 636.8706,  644.9388,  0.0000,    0.0000,    635.0457,  312.9202,
  322.5705,  0.0000,    0.0000,    615.2494,  307.5913,  317.7589,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1299.5197, 624.7801,  591.8695,  0.0000,    0.0000,    579.9584,  306.7389,  295.2374,  0.0000,
  0.0000,    562.7180,  301.4420,  290.7309,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1021.6871, 623.5332,
  425.4745,  0.0000,    0.0000,    456.2023,  304.3094,  220.1013,  0.0000,    0.0000,    442.6736,
  298.8190,  217.6494,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1097.1539, 553.7931,  353.3283,  0.0000,
  0.0000,    497.3474,  278.1965,  187.1364,  0.0000,    0.0000,    483.5993,  274.1703,  185.5544,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    857.1730,  507.3401,  348.0642,  0.0000,    0.0000,    389.5974,
  256.8889,  183.8257,  0.0000,    0.0000,    378.9366,  253.4168,  182.2062,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    882.4503,  484.0723,  427.8866,  369.0835,  0.0000,    411.0572,  245.0035,  217.6909,
  192.5221,  0.0000,    401.1295,  241.6833,  214.8399,  190.5518,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    921.8990,
  474.6254,  393.0487,  425.1277,  0.0000,    424.6693,  239.6563,  202.2392,  213.6129,  0.0000,
  413.7841,  236.3296,  199.8502,  210.4559,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    706.0720,  481.6472,  0.0000,
  0.0000,    0.0000,    325.0850,  238.0128,  0.0000,    0.0000,    0.0000,    316.7102,  234.0374,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    693.6787,  430.3675,  0.0000,    0.0000,    0.0000,
  331.2310,  221.2467,  0.0000,    0.0000,    0.0000,    324.2891,  218.6603,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    833.7424,  771.9763,  581.9150,  452.4148,  0.0000,    393.5300,  368.5417,
  288.9924,  234.0165,  0.0000,    384.8172,  360.9196,  284.4870,  231.5184,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  694.7024,  641.4064,  605.0343,  529.7799,  454.0771,  343.1679,  320.1342,  304.1902,  271.2475,
  237.9706,  337.5761,  315.3367,  299.9014,  268.0269,  235.8103,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    562.6947,  551.4999,
  534.1575,  510.2912,  0.0000,    289.5582,  284.4516,  276.6634,  266.0294,  0.0000,    286.3045,
  281.3331,  273.7684,  263.4496,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    488.8715,  489.3305,  485.0594,  0.0000,
  0.0000,    258.0084,  258.1295,  256.0474,  0.0000,    0.0000,    255.8702,  255.9746,  253.9272,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    413.7468,  417.3648,  0.0000,    0.0000,    0.0000,    224.1375,
  225.7784,  0.0000,    0.0000,    0.0000,    222.9256,  224.5209,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    348.8474,  0.0000,    0.0000,    0.0000,    0.0000,    193.5868,  0.0000,    0.0000,
  0.0000,    0.0000,    193.0224,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2834.0920,
  826.1041,  0.0000,    0.0000,    0.0000,    1105.4608, 389.9057,  0.0000,    0.0000,    0.0000,
  1056.1444, 381.2151,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2260.4217, 1849.7319, 816.9275,
  0.0000,    0.0000,    957.2271,  779.9488,  399.3277,  0.0000,    0.0000,    922.1430,  752.1641,
  392.1967,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1896.7809, 1297.2964, 756.5443,  0.0000,    0.0000,
  831.6679,  586.3135,  381.4719,  0.0000,    0.0000,    805.0465,  570.8618,  376.1623,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1659.1156, 879.0165,  754.6182,  0.0000,    0.0000,    743.4318,  429.3019,
  383.8645,  0.0000,    0.0000,    721.7837,  421.5388,  378.9395,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1486.0620, 888.3356,  733.0114,  0.0000,    0.0000,    675.3314,  433.7865,  371.3244,  0.0000,
  0.0000,    656.9546,  425.7299,  366.3716,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1112.0098, 818.5161,
  627.5560,  0.0000,    0.0000,    517.7340,  403.1540,  326.0787,  0.0000,    0.0000,    505.2346,
  396.3470,  322.6655,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1255.3446, 961.3657,  539.8662,  0.0000,
  0.0000,    579.1623,  455.9109,  286.2241,  0.0000,    0.0000,    564.5560,  446.1492,  283.8784,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    923.5811,  689.6088,  505.2854,  0.0000,    0.0000,    437.8432,
  349.0702,  269.9059,  0.0000,    0.0000,    428.2629,  344.2948,  267.9088,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1009.1933, 643.1893,  530.5111,  0.0000,    0.0000,    478.9598,  326.2503,  276.5669,
  0.0000,    0.0000,    468.5358,  321.8583,  273.7179,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    924.8556,
  593.4994,  558.7593,  0.0000,    0.0000,    443.0816,  302.4898,  289.4965,  0.0000,    0.0000,
  433.9484,  298.5692,  286.3025,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    776.8914,  576.9636,  0.0000,
  0.0000,    0.0000,    369.4933,  292.9063,  0.0000,    0.0000,    0.0000,    361.5057,  288.9408,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    802.6020,  555.6679,  0.0000,    0.0000,    0.0000,
  389.1859,  288.3875,  0.0000,    0.0000,    0.0000,    381.7298,  285.2814,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1045.8401, 980.8464,  745.8282,  605.3047,  0.0000,    492.1904,  467.6700,
  372.0117,  313.7920,  0.0000,    481.0066,  457.8184,  366.3017,  310.4193,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  923.0182,  845.5447,  809.6247,  709.4418,  623.8277,  451.1340,  419.1432,  404.4096,  362.1394,
  325.5023,  443.0605,  412.3939,  398.2795,  357.6129,  322.2908,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    785.8323,  765.4303,
  738.4121,  704.7245,  0.0000,    398.3152,  389.8645,  378.5124,  364.2456,  0.0000,    393.0115,
  384.9081,  373.9963,  360.2627,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    709.1303,  707.3769,  699.4586,  0.0000,
  0.0000,    367.3908,  366.9900,  363.7755,  0.0000,    0.0000,    363.4777,  363.1446,  360.0716,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    622.1841,  628.3317,  0.0000,    0.0000,    0.0000,    330.0418,
  333.1801,  0.0000,    0.0000,    0.0000,    327.4340,  330.5365,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    543.5631,  0.0000,    0.0000,    0.0000,    0.0000,    294.8706,  0.0000,    0.0000,
  0.0000,    0.0000,    293.2741,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3450.8369,
  942.2745,  0.0000,    0.0000,    0.0000,    1344.5274, 457.9012,  0.0000,    0.0000,    0.0000,
  1285.9957, 449.4774,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2924.4395, 2443.4277, 978.5884,
  0.0000,    0.0000,    1222.7426, 1013.0298, 481.8238,  0.0000,    0.0000,    1176.2602, 975.9665,
  473.6984,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2461.7619, 1655.7011, 993.2805,  0.0000,    0.0000,
  1065.8140, 742.6398,  497.6257,  0.0000,    0.0000,    1030.0975, 722.8068,  490.3181,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    936.4068,  0.0000,    0.0000,    0.0000,    0.0000,    471.1854,  0.0000,
  0.0000,    0.0000,    0.0000,    464.4600,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2554.7353, 905.7241,  0.0000,    0.0000,    0.0000,    1079.9647, 456.7087,  0.0000,    0.0000,
  0.0000,    1040.8154, 450.3076,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2435.0889, 886.5266,
  0.0000,    0.0000,    0.0000,    1036.2055, 447.2220,  0.0000,    0.0000,    0.0000,    998.9971,
  440.9674,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2369.1244, 856.4434,  0.0000,    0.0000,
  0.0000,    1009.8893, 432.8276,  0.0000,    0.0000,    0.0000,    973.8228,  426.8683,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2308.9962, 866.9228,  0.0000,    0.0000,    0.0000,    985.7264,
  435.5172,  0.0000,    0.0000,    0.0000,    950.6909,  429.2527,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2255.5157, 854.8216,  0.0000,    0.0000,    0.0000,    964.2855,  421.6969,  0.0000,
  0.0000,    0.0000,    930.1750,  414.5893,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1691.7052,
  874.1314,  0.0000,    0.0000,    0.0000,    750.7848,  438.5550,  0.0000,    0.0000,    0.0000,
  728.1122,  432.1441,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2045.4927, 816.0391,  0.0000,
  0.0000,    0.0000,    855.1471,  411.3969,  0.0000,    0.0000,    0.0000,    823.6822,  405.6040,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1957.4581, 841.3784,  0.0000,    0.0000,    0.0000,
  822.8420,  419.5774,  0.0000,    0.0000,    0.0000,    793.8541,  413.1795,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2012.0352, 769.8336,  0.0000,    0.0000,    0.0000,    868.1104,  390.0277,
  0.0000,    0.0000,    0.0000,    838.3710,  384.7744,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1966.9050, 746.1810,  0.0000,    0.0000,    0.0000,    849.5394,  378.7408,  0.0000,    0.0000,
  0.0000,    820.5423,  373.7251,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1925.1263, 742.7390,
  0.0000,    0.0000,    0.0000,    832.6961,  376.4552,  0.0000,    0.0000,    0.0000,    804.4238,
  371.4100,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1906.2802, 788.4325,  0.0000,    0.0000,
  0.0000,    823.3089,  396.5845,  0.0000,    0.0000,    0.0000,    795.1856,  390.9216,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1555.3939, 715.3652,  0.0000,    0.0000,    0.0000,    688.6242,
  363.6319,  0.0000,    0.0000,    0.0000,    667.8924,  358.8895,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1461.9589, 1053.0789, 711.4013,  0.0000,    0.0000,    671.9258,  500.4528,  366.3074,
  0.0000,    0.0000,    654.6200,  489.9850,  362.1428,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1297.7826,
  950.6862,  755.2519,  0.0000,    0.0000,    609.7515,  461.9376,  383.5932,  0.0000,    0.0000,
  595.7700,  453.4554,  378.6235,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1072.8050, 842.4987,  680.1597,
  0.0000,    0.0000,    512.2105,  419.0383,  354.0876,  0.0000,    0.0000,    501.5307,  412.4826,
  350.4674,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1079.3168, 874.5439,  603.5688,  0.0000,    0.0000,
  520.0578,  426.1339,  319.9881,  0.0000,    0.0000,    509.8160,  418.3819,  317.3717,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    954.4533,  715.4332,  557.0378,  0.0000,    0.0000,    468.9565,  368.0285,
  299.7987,  0.0000,    0.0000,    460.8387,  363.7522,  297.8485,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  856.7886,  666.3424,  583.4032,  0.0000,    0.0000,    427.6845,  345.4662,  307.2050,  0.0000,
  0.0000,    421.0942,  341.7165,  304.4056,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    696.9272,  632.6433,
  614.5128,  0.0000,    0.0000,    353.4845,  329.5050,  323.3413,  0.0000,    0.0000,    348.6671,
  326.0813,  320.3679,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    645.5750,  605.5453,  0.0000,    0.0000,
  0.0000,    329.5985,  315.0011,  0.0000,    0.0000,    0.0000,    325.3386,  311.6484,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    657.5917,  570.6352,  0.0000,    0.0000,    0.0000,    338.5478,
  302.9513,  0.0000,    0.0000,    0.0000,    334.5310,  300.4649,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1062.1257, 1044.6215, 780.3119,  669.5176,  0.0000,    503.6393,  500.9073,  395.5580,
  349.6976,  0.0000,    492.6887,  490.7086,  390.2082,  346.2056,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1000.8602,
  907.5192,  822.8762,  798.4890,  726.0318,  489.2541,  452.4223,  418.0128,  409.1716,  378.6746,
  480.4497,  445.3967,  412.4946,  404.2011,  374.8744,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    882.5153,  857.5695,  828.0658,
  793.6209,  0.0000,    445.9231,  436.5563,  425.0599,  411.3369,  0.0000,    439.7476,  430.9162,
  420.0045,  406.9281,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    821.7825,  818.9160,  811.9113,  0.0000,    0.0000,
  423.2063,  422.9969,  420.8233,  0.0000,    0.0000,    418.3364,  418.2904,  416.3214,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    736.8768,  745.5450,  0.0000,    0.0000,    0.0000,    388.2122,  392.8995,
  0.0000,    0.0000,    0.0000,    384.7925,  389.4608,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  657.8209,  0.0000,    0.0000,    0.0000,    0.0000,    353.8005,  0.0000,    0.0000,    0.0000,
  0.0000,    351.5142,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3153.3933, 1058.1233,
  0.0000,    0.0000,    0.0000,    1263.0191, 515.4409,  0.0000,    0.0000,    0.0000,    1211.2384,
  506.1252,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2829.2273, 2362.8855, 1073.8645, 0.0000,
  0.0000,    1203.9859, 1003.1278, 530.0511,  0.0000,    0.0000,    1160.9837, 968.7193,  521.2983,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2402.1540, 1073.0233, 0.0000,    0.0000,    0.0000,    1056.3541,
  540.6254,  0.0000,    0.0000,    0.0000,    1023.1422, 533.0015,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2060.8901, 1294.1588, 0.0000,    0.0000,    0.0000,    940.6241,  628.6370,  0.0000,
  0.0000,    0.0000,    915.5214,  617.3054,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2094.5389,
  1142.5935, 0.0000,    0.0000,    0.0000,    937.6579,  559.7347,  0.0000,    0.0000,    0.0000,
  910.3645,  550.8253,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2025.4740, 973.7241,  0.0000,
  0.0000,    0.0000,    907.6956,  492.1797,  0.0000,    0.0000,    0.0000,    881.3428,  485.4071,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2144.9232, 929.8813,  0.0000,    0.0000,    0.0000,
  939.8691,  472.9397,  0.0000,    0.0000,    0.0000,    909.6469,  466.7411,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2066.1768, 1223.4261, 0.0000,    0.0000,    0.0000,    909.2895,  578.2929,
  0.0000,    0.0000,    0.0000,    880.5433,  565.8794,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1361.9185, 612.2225,  621.6228,  0.0000,    0.0000,    612.2225,  301.9988,  311.2408,  0.0000,
  0.0000,    621.6228,  311.2408,  321.5890,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1232.3235, 600.5221,
  570.2282,  0.0000,    0.0000,    559.1157,  296.0029,  284.9497,  0.0000,    0.0000,    568.6316,
  305.0201,  294.2417,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    968.8565,  598.7981,  412.1387,  0.0000,
  0.0000,    440.0762,  293.6598,  212.6450,  0.0000,    0.0000,    447.3763,  302.3474,  220.4170,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1042.6625, 534.1266,  343.4916,  0.0000,    0.0000,    479.4969,
  268.4657,  180.9105,  0.0000,    0.0000,    488.7888,  277.5005,  187.9838,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    814.8402,  489.8996,  338.2283,  0.0000,    0.0000,    375.8242,  247.9636,  177.7007,
  0.0000,    0.0000,    383.0606,  256.5291,  184.5856,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    841.8335,
  467.3984,  413.4479,  357.9783,  0.0000,    396.2748,  236.5325,  210.2464,  186.0369,  0.0000,
  405.5809,  244.6571,  217.5178,  193.0012,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    878.0939,  458.1136,  380.4377,
  410.0129,  0.0000,    409.3555,  231.3631,  195.3516,  206.2651,  0.0000,    418.3113,  239.2323,
  202.3746,  213.0501,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    672.4128,  463.3924,  0.0000,    0.0000,    0.0000,
  313.6026,  229.7226,  0.0000,    0.0000,    0.0000,    320.2198,  236.8532,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    664.1009,  416.5328,  0.0000,    0.0000,    0.0000,    319.3834,  213.6191,
  0.0000,    0.0000,    0.0000,    328.0001,  221.3943,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  796.8617,  739.0281,  560.2945,  438.2812,  0.0000,    379.4109,  355.3498,  278.8293,  225.9136,
  0.0000,    389.1325,  365.0239,  287.8797,  234.4093,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    668.3786,  618.0401,
  583.6237,  512.4274,  440.7662,  330.9710,  308.8304,  293.4899,  261.8074,  229.8053,  341.5627,
  319.1099,  303.5228,  271.3354,  238.8007,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    544.6797,  534.0266,  517.5611,  494.9276,
  0.0000,    279.4990,  274.5929,  267.1055,  256.8763,  0.0000,    289.8560,  284.8345,  277.1939,
  266.7717,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    475.0348,  475.4453,  471.3428,  0.0000,    0.0000,    249.2258,
  249.3437,  247.3402,  0.0000,    0.0000,    259.1489,  259.2539,  257.1841,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    403.6576,  407.0970,  0.0000,    0.0000,    0.0000,    216.6921,  218.2711,  0.0000,
  0.0000,    0.0000,    225.8818,  227.4937,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    341.6273,
  0.0000,    0.0000,    0.0000,    0.0000,    187.3231,  0.0000,    0.0000,    0.0000,    0.0000,
  195.6666,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2641.2435, 789.4117,  0.0000,
  0.0000,    0.0000,    1074.1973, 376.3919,  0.0000,    0.0000,    0.0000,    1065.4841, 385.5830,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2128.3951, 1740.7410, 784.6886,  0.0000,    0.0000,
  923.6557,  754.6753,  385.2756,  0.0000,    0.0000,    931.2172,  759.5978,  396.8216,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1794.3180, 1232.3433, 730.0584,  0.0000,    0.0000,    802.0324,  566.8670,
  368.1481,  0.0000,    0.0000,    813.3302,  577.0286,  380.7419,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1574.1401, 844.1565,  729.1622,  0.0000,    0.0000,    716.8609,  414.2030,  370.5158,  0.0000,
  0.0000,    729.4243,  426.5157,  383.5999,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1412.6818, 853.0464,
  707.8111,  0.0000,    0.0000,    651.2847,  418.3068,  358.5232,  0.0000,    0.0000,    664.0452,
  430.7613,  370.8800,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1060.6255, 787.0565,  608.3000,  0.0000,
  0.0000,    499.5011,  389.1787,  314.9983,  0.0000,    0.0000,    510.8967,  401.0919,  326.7670,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1195.8434, 919.3099,  524.9173,  0.0000,    0.0000,    558.7211,
  440.2561,  276.6567,  0.0000,    0.0000,    570.7922,  451.2866,  287.5807,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    883.1492,  665.8143,  491.8643,  0.0000,    0.0000,    422.5708,  337.0553,  260.9491,
  0.0000,    0.0000,    433.1914,  348.5490,  271.4387,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    965.2308,
  621.1807,  514.4744,  0.0000,    0.0000,    462.0314,  315.0982,  267.2985,  0.0000,    0.0000,
  473.8973,  325.8582,  277.2406,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    885.7657,  573.5972,  541.3741,
  0.0000,    0.0000,    427.4577,  292.2135,  279.7105,  0.0000,    0.0000,    438.9752,  302.3112,
  289.9530,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    743.2041,  557.2880,  0.0000,    0.0000,    0.0000,
  356.7245,  282.9332,  0.0000,    0.0000,    0.0000,    365.7124,  292.5514,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    770.0303,  538.5502,  0.0000,    0.0000,    0.0000,    375.5261,  278.5869,
  0.0000,    0.0000,    0.0000,    386.2241,  288.9111,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  999.0971,  938.7641,  718.5537,  586.5752,  0.0000,    474.8112,  451.1658,  359.1057,  303.0566,
  0.0000,    486.4497,  463.0777,  370.7390,  314.3438,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    886.6318,  813.8964,
  780.2017,  685.8851,  605.1321,  435.1948,  404.4378,  390.2655,  349.6106,  314.3804,  448.2770,
  417.3325,  403.0919,  362.0440,  326.3851,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    758.9406,  739.7751,  714.3497,  682.6170,
  0.0000,    384.4487,  376.3336,  365.4257,  351.7089,  0.0000,    397.8333,  389.6578,  378.6459,
  364.7838,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    687.1235,  685.5687,  678.1485,  0.0000,    0.0000,    354.7793,
  354.4029,  351.3179,  0.0000,    0.0000,    368.0557,  367.7252,  364.6262,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    605.0508,  610.9949,  0.0000,    0.0000,    0.0000,    318.9171,  321.9433,  0.0000,
  0.0000,    0.0000,    331.6800,  334.8197,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    530.4312,
  0.0000,    0.0000,    0.0000,    0.0000,    285.1325,  0.0000,    0.0000,    0.0000,    0.0000,
  297.1871,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3215.8544, 904.2225,  0.0000,
  0.0000,    0.0000,    1308.6418, 442.0547,  0.0000,    0.0000,    0.0000,    1297.3700, 454.7799,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2748.9797, 2294.6062, 940.9324,  0.0000,    0.0000,
  1180.9424, 982.3638,  465.0211,  0.0000,    0.0000,    1187.6789, 985.4293,  479.3449,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2324.7454, 1571.2363, 957.5700,  0.0000,    0.0000,    1028.4169, 718.6782,
  480.2028,  0.0000,    0.0000,    1040.5570, 730.5584,  496.2446,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  903.3306,  0.0000,    0.0000,    0.0000,    0.0000,    454.8200,  0.0000,    0.0000,    0.0000,
  0.0000,    470.1341,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2405.0561, 874.0066,
  0.0000,    0.0000,    0.0000,    1043.3187, 440.8726,  0.0000,    0.0000,    0.0000,    1051.1001,
  455.8234,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2294.2857, 855.5354,  0.0000,    0.0000,
  0.0000,    1000.2155, 431.7097,  0.0000,    0.0000,    0.0000,    1008.9483, 446.3717,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2232.6503, 826.7257,  0.0000,    0.0000,    0.0000,    974.7227,
  417.8360,  0.0000,    0.0000,    0.0000,    983.5427,  432.1120,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2176.4184, 836.0994,  0.0000,    0.0000,    0.0000,    951.3257,  420.4671,  0.0000,
  0.0000,    0.0000,    960.1954,  434.4919,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2126.4190,
  822.1810,  0.0000,    0.0000,    0.0000,    930.5654,  407.0094,  0.0000,    0.0000,    0.0000,
  939.4890,  419.5622,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1602.8927, 842.8840,  0.0000,
  0.0000,    0.0000,    724.5886,  423.3069,  0.0000,    0.0000,    0.0000,    735.7972,  437.4020,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1922.8302, 787.4378,  0.0000,    0.0000,    0.0000,
  827.7970,  397.1190,  0.0000,    0.0000,    0.0000,    831.7726,  410.5703,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1841.5883, 810.5712,  0.0000,    0.0000,    0.0000,    797.2364,  405.0758,
  0.0000,    0.0000,    0.0000,    801.7112,  418.1829,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1899.2044, 743.4069,  0.0000,    0.0000,    0.0000,    837.4618,  376.5089,  0.0000,    0.0000,
  0.0000,    846.8568,  389.5084,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1856.8743, 720.7667,
  0.0000,    0.0000,    0.0000,    819.4973,  365.6231,  0.0000,    0.0000,    0.0000,    828.8555,
  378.3321,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1817.7881, 717.2897,  0.0000,    0.0000,
  0.0000,    803.2032,  363.4076,  0.0000,    0.0000,    0.0000,    812.5860,  375.9796,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1799.6377, 760.5639,  0.0000,    0.0000,    0.0000,    794.1404,
  382.7505,  0.0000,    0.0000,    0.0000,    803.2347,  395.6779,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1473.4091, 691.1573,  0.0000,    0.0000,    0.0000,    664.7727,  351.0309,  0.0000,
  0.0000,    0.0000,    674.8890,  363.3160,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1391.9848,
  1007.3778, 688.6652,  0.0000,    0.0000,    647.8746,  483.1691,  353.6686,  0.0000,    0.0000,
  661.7665,  495.5985,  366.6628,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1239.5033, 912.3291,  729.5649,
  0.0000,    0.0000,    587.9813,  445.9579,  370.4544,  0.0000,    0.0000,    602.4592,  458.7957,
  383.3036,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1026.9214, 811.2804,  659.4850,  0.0000,    0.0000,
  494.2357,  404.5918,  342.0626,  0.0000,    0.0000,    507.3155,  417.4793,  354.9301,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1034.5489, 839.5915,  586.8549,  0.0000,    0.0000,    501.7733,  411.3956,
  309.2852,  0.0000,    0.0000,    515.7464,  423.3401,  321.5086,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  917.4690,  692.4339,  542.8797,  0.0000,    0.0000,    452.5726,  355.5230,  289.8959,  0.0000,
  0.0000,    466.3311,  368.3317,  301.8032,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    825.5125,  645.6738,
  566.6300,  0.0000,    0.0000,    412.8558,  333.7845,  296.9959,  0.0000,    0.0000,    426.2144,
  346.0691,  308.3710,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    673.0527,  613.4456,  596.8009,  0.0000,
  0.0000,    341.4540,  318.4217,  312.5132,  0.0000,    0.0000,    353.0208,  330.2661,  324.5233,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    624.0693,  587.0474,  0.0000,    0.0000,    0.0000,    318.4619,
  304.4479,  0.0000,    0.0000,    0.0000,    329.4445,  315.6575,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    636.5210,  554.9678,  0.0000,    0.0000,    0.0000,    327.0770,  292.8646,  0.0000,
  0.0000,    0.0000,    338.7741,  304.4029,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1015.6676,
  1000.5590, 753.5662,  649.5230,  0.0000,    486.2116,  483.4915,  381.9977,  337.8590,  0.0000,
  498.3709,  496.4262,  395.0466,  350.6404,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    961.3718,  874.2469,  794.9456,
  772.4068,  704.2137,  472.1552,  436.7178,  403.6239,  395.1139,  365.7846,  486.1511,  450.7995,
  417.6039,  409.2513,  379.6507,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    851.8855,  828.7352,  801.2338,  769.0396,  0.0000,
  430.4805,  421.4858,  410.4418,  397.2538,  0.0000,    445.1537,  436.2556,  425.2549,  412.0673,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    795.5384,  793.1270,  786.7561,  0.0000,    0.0000,    408.6951,  408.5100,
  406.4345,  0.0000,    0.0000,    423.5901,  423.5585,  421.5830,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  715.8242,  724.2805,  0.0000,    0.0000,    0.0000,    375.1029,  379.6269,  0.0000,    0.0000,
  0.0000,    389.7559,  394.4833,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    641.0689,  0.0000,
  0.0000,    0.0000,    0.0000,    342.0575,  0.0000,    0.0000,    0.0000,    0.0000,    356.1653,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2948.3214, 1015.7559, 0.0000,    0.0000,
  0.0000,    1226.3970, 497.5952,  0.0000,    0.0000,    0.0000,    1222.4279, 512.1076,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2665.5950, 2225.6317, 1032.9143, 0.0000,    0.0000,    1162.3660,
  971.1709,  511.5959,  0.0000,    0.0000,    1172.5376, 978.4148,  527.5292,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2273.2739, 1035.3252, 0.0000,    0.0000,    0.0000,    1019.1422, 521.8291,  0.0000,
  0.0000,    0.0000,    1033.7520, 539.5156,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1960.2827,
  1241.9423, 0.0000,    0.0000,    0.0000,    907.2367,  607.2695,  0.0000,    0.0000,    0.0000,
  925.4898,  624.5913,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1986.9265, 1097.9705, 0.0000,
  0.0000,    0.0000,    904.8331,  541.6423,  0.0000,    0.0000,    0.0000,    920.0840,  557.4227,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1921.6819, 939.9375,  0.0000,    0.0000,    0.0000,
  875.8748,  475.3101,  0.0000,    0.0000,    0.0000,    890.7699,  491.4026,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2028.7846, 898.4534,  0.0000,    0.0000,    0.0000,    906.9616,  456.7222,
  0.0000,    0.0000,    0.0000,    919.1109,  472.5463,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1955.4505, 1169.4190, 0.0000,    0.0000,    0.0000,    877.3645,  558.8652,  0.0000,    0.0000,
  0.0000,    889.7519,  572.4017,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1116.0984, 548.3908,
  521.4602,  0.0000,    0.0000,    548.3908,  290.1436,  279.2755,  0.0000,    0.0000,    521.4602,
  279.2755,  269.3349,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    877.3855,  546.5244,  378.0660,  0.0000,
  0.0000,    431.6683,  287.8657,  208.4094,  0.0000,    0.0000,    410.5661,  276.8819,  201.8641,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    945.6072,  488.7947,  315.7492,  0.0000,    0.0000,    470.2529,
  263.1127,  177.2993,  0.0000,    0.0000,    448.0698,  253.9370,  172.1980,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    739.0542,  448.6262,  310.8375,  0.0000,    0.0000,    368.6136,  243.0148,  174.1594,
  0.0000,    0.0000,    351.3939,  234.7665,  169.0900,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    765.3178,
  427.9936,  378.7327,  328.6407,  0.0000,    388.5729,  231.8180,  206.0757,  182.3353,  0.0000,
  371.5149,  223.9437,  199.2038,  176.7692,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    797.5195,  419.4037,  348.8510,
  375.1745,  0.0000,    401.4329,  226.7601,  191.4715,  202.2050,  0.0000,    383.2557,  218.9943,
  185.3265,  195.1629,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    610.5700,  423.4193,  0.0000,    0.0000,    0.0000,
  307.5763,  225.2020,  0.0000,    0.0000,    0.0000,    293.6816,  216.9203,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    605.0623,  381.9629,  0.0000,    0.0000,    0.0000,    313.1286,  209.3428,
  0.0000,    0.0000,    0.0000,    300.3130,  202.5980,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  725.2514,  673.2823,  512.2075,  402.1202,  0.0000,    371.9427,  348.3293,  273.2440,  221.3382,
  0.0000,    356.2469,  334.1078,  263.3800,  214.3808,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    610.7639,  565.2639,
  534.1256,  469.7122,  404.8543,  324.3435,  302.6272,  287.5851,  256.5149,  225.1326,  312.4130,
  291.8713,  277.6090,  248.1606,  218.4003,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    499.4970,  489.8210,  474.8898,  454.3822,
  0.0000,    273.8352,  269.0270,  261.6872,  251.6587,  0.0000,    265.0778,  260.4970,  253.5169,
  243.9879,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    436.5718,  436.9293,  433.1830,  0.0000,    0.0000,    244.1554,
  244.2727,  242.3111,  0.0000,    0.0000,    237.0577,  237.1592,  235.2729,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    371.8071,  374.9283,  0.0000,    0.0000,    0.0000,    212.2792,  213.8276,  0.0000,
  0.0000,    0.0000,    206.7277,  208.2022,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    315.3251,
  0.0000,    0.0000,    0.0000,    0.0000,    183.5171,  0.0000,    0.0000,    0.0000,    0.0000,
  179.1965,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2363.7175, 718.2125,  0.0000,
  0.0000,    0.0000,    1053.5834, 369.0649,  0.0000,    0.0000,    0.0000,    984.9504,  353.5929,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1918.6941, 1568.2263, 716.2778,  0.0000,    0.0000,
  906.2364,  740.1763,  377.6508,  0.0000,    0.0000,    855.9005,  699.1302,  363.3125,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1622.4689, 1116.9531, 668.2729,  0.0000,    0.0000,    786.7255,  555.7215,
  360.7708,  0.0000,    0.0000,    746.4335,  529.6824,  348.3728,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1426.0687, 770.4185,  667.9695,  0.0000,    0.0000,    703.0784,  406.0223,  363.0711,  0.0000,
  0.0000,    668.9667,  390.6056,  350.9659,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1281.3349, 778.5266,
  648.1120,  0.0000,    0.0000,    638.7014,  410.1033,  351.3471,  0.0000,    0.0000,    608.8442,
  394.4854,  339.4910,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    963.9434,  718.8469,  558.2324,  0.0000,
  0.0000,    489.8160,  381.4804,  308.6801,  0.0000,    0.0000,    468.4059,  367.3750,  299.1495,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1086.0231, 836.7341,  482.5622,  0.0000,    0.0000,    547.8906,
  431.6391,  271.1001,  0.0000,    0.0000,    523.3223,  413.8230,  263.3409,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    803.8807,  609.6159,  452.4755,  0.0000,    0.0000,    414.3575,  330.3567,  255.7125,
  0.0000,    0.0000,    397.1558,  319.1584,  248.6021,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    878.8027,
  568.8348,  472.2401,  0.0000,    0.0000,    453.0262,  308.8482,  261.9807,  0.0000,    0.0000,
  434.2176,  298.4577,  253.9853,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    807.1258,  525.4732,  496.6905,
  0.0000,    0.0000,    419.1134,  286.4278,  274.1490,  0.0000,    0.0000,    402.1750,  276.9472,
  265.5767,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    676.6553,  510.3644,  0.0000,    0.0000,    0.0000,
  349.8288,  277.3525,  0.0000,    0.0000,    0.0000,    335.4436,  268.0353,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    702.4213,  494.2237,  0.0000,    0.0000,    0.0000,    368.1871,  273.0331,
  0.0000,    0.0000,    0.0000,    353.8227,  264.5314,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  908.9753,  855.0744,  657.1002,  538.2672,  0.0000,    465.5647,  442.3420,  351.9807,  296.9854,
  0.0000,    445.7766,  424.2272,  339.4399,  287.7026,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    809.4134,  743.9253,
  713.6060,  628.5419,  555.6200,  426.5933,  396.4079,  382.4997,  342.6120,  308.0520,  410.3518,
  381.9818,  368.9209,  331.3093,  298.6591,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    695.0683,  677.8014,  654.8718,  626.2392,
  0.0000,    376.7544,  368.7908,  358.0883,  344.6316,  0.0000,    364.0189,  356.5349,  346.4532,
  333.7597,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    630.4901,  629.1390,  622.4635,  0.0000,    0.0000,    347.6374,
  347.2648,  344.2372,  0.0000,    0.0000,    336.7719,  336.4671,  333.6308,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    556.3166,  561.7643,  0.0000,    0.0000,    0.0000,    312.4714,  315.4349,  0.0000,
  0.0000,    0.0000,    303.5459,  306.4123,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    488.6522,
  0.0000,    0.0000,    0.0000,    0.0000,    279.3612,  0.0000,    0.0000,    0.0000,    0.0000,
  272.0795,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2877.5279, 824.7780,  0.0000,
  0.0000,    0.0000,    1283.1193, 433.3139,  0.0000,    0.0000,    0.0000,    1199.7581, 416.6755,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2475.1427, 2064.0309, 859.3730,  0.0000,    0.0000,
  1158.6662, 963.2725,  455.7896,  0.0000,    0.0000,    1092.6689, 908.1340,  438.9190,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2099.5853, 1423.1173, 876.0050,  0.0000,    0.0000,    1008.8336, 704.4731,
  470.5903,  0.0000,    0.0000,    955.7169,  670.9208,  454.0832,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  826.7047,  0.0000,    0.0000,    0.0000,    0.0000,    445.7570,  0.0000,    0.0000,    0.0000,
  0.0000,    430.3341,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2167.6325, 800.0152,
  0.0000,    0.0000,    0.0000,    1023.5395, 432.0839,  0.0000,    0.0000,    0.0000,    966.6619,
  417.2395,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2068.9809, 783.1386,  0.0000,    0.0000,
  0.0000,    981.3457,  423.1055,  0.0000,    0.0000,    0.0000,    927.5254,  408.5880,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2013.7194, 756.8843,  0.0000,    0.0000,    0.0000,    956.3321,
  409.5058,  0.0000,    0.0000,    0.0000,    904.0753,  395.5412,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1963.2723, 765.0512,  0.0000,    0.0000,    0.0000,    933.3738,  412.0874,  0.0000,
  0.0000,    0.0000,    882.5313,  397.7647,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1918.4254,
  751.0893,  0.0000,    0.0000,    0.0000,    913.0014,  398.9816,  0.0000,    0.0000,    0.0000,
  863.4210,  384.2576,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1450.7174, 771.1840,  0.0000,
  0.0000,    0.0000,    710.7237,  414.8741,  0.0000,    0.0000,    0.0000,    675.5150,  400.3793,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1730.9890, 720.7679,  0.0000,    0.0000,    0.0000,
  811.9905,  389.2080,  0.0000,    0.0000,    0.0000,    766.0776,  375.8195,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1658.7019, 741.1995,  0.0000,    0.0000,    0.0000,    781.8272,  397.0180,
  0.0000,    0.0000,    0.0000,    738.2489,  382.8866,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1714.8635, 680.7697,  0.0000,    0.0000,    0.0000,    821.6274,  368.9941,  0.0000,    0.0000,
  0.0000,    777.8991,  356.5084,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1676.8129, 660.1463,
  0.0000,    0.0000,    0.0000,    803.9989,  358.3213,  0.0000,    0.0000,    0.0000,    761.3040,
  346.2718,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1641.7354, 656.8806,  0.0000,    0.0000,
  0.0000,    788.0064,  356.1503,  0.0000,    0.0000,    0.0000,    746.2943,  344.1155,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1625.1430, 696.0633,  0.0000,    0.0000,    0.0000,    779.1219,
  375.1083,  0.0000,    0.0000,    0.0000,    737.7269,  362.0987,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1333.4027, 633.1163,  0.0000,    0.0000,    0.0000,    651.9794,  344.0112,  0.0000,
  0.0000,    0.0000,    619.4515,  332.4997,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1263.8660,
  917.1452,  631.5437,  0.0000,    0.0000,    635.2996,  473.6414,  346.5441,  0.0000,    0.0000,
  606.4479,  454.1931,  335.4749,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1127.5812, 832.2331,  668.1599,
  0.0000,    0.0000,    576.4946,  437.1397,  363.0328,  0.0000,    0.0000,    551.8530,  420.3192,
  350.9096,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    935.3859,  741.5955,  605.3105,  0.0000,    0.0000,
  484.5583,  396.5636,  335.1953,  0.0000,    0.0000,    464.8433,  382.3628,  324.9190,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    943.1423,  766.0701,  539.5023,  0.0000,    0.0000,    491.9120,  403.2898,
  303.0694,  0.0000,    0.0000,    472.4071,  387.8872,  294.3958,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  837.8455,  634.8838,  499.7380,  0.0000,    0.0000,    443.6413,  348.4172,  284.0641,  0.0000,
  0.0000,    427.0631,  337.2614,  276.4053,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    754.9193,  592.4083,
  520.5585,  0.0000,    0.0000,    404.6864,  327.1273,  291.0741,  0.0000,    0.0000,    390.3055,
  316.9361,  282.5278,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    616.3066,  563.0626,  548.2853,  0.0000,
  0.0000,    334.7153,  312.0815,  306.2733,  0.0000,    0.0000,    323.4494,  302.5159,  297.2341,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    571.7746,  538.7579,  0.0000,    0.0000,    0.0000,    312.1873,
  298.4115,  0.0000,    0.0000,    0.0000,    301.9116,  289.2216,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    583.6657,  510.2800,  0.0000,    0.0000,    0.0000,    320.6012,  287.0169,  0.0000,
  0.0000,    0.0000,    310.3353,  278.8184,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    924.5054,
  911.7000,  690.0666,  596.3924,  0.0000,    476.7596,  474.0521,  374.4199,  331.1074,  0.0000,
  457.0023,  455.0092,  361.7806,  321.0422,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    877.5655,  799.4271,  728.1306,
  708.0447,  646.5526,  462.8741,  428.0767,  395.5906,  387.2267,  358.4493,  445.2862,  412.7929,
  382.3241,  374.6218,  347.4974,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    779.9336,  759.2415,  734.5909,  705.6853,  0.0000,
  421.9181,  413.0794,  402.2324,  389.2837,  0.0000,    407.5036,  399.3221,  389.2203,  377.1177,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    729.5657,  727.5491,  721.9255,  0.0000,    0.0000,    400.5172,  400.3242,
  398.2791,  0.0000,    0.0000,    387.7153,  387.6670,  385.8440,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  657.7700,  665.5600,  0.0000,    0.0000,    0.0000,    367.5588,  371.9863,  0.0000,    0.0000,
  0.0000,    356.7642,  361.0762,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    590.1365,  0.0000,
  0.0000,    0.0000,    0.0000,    335.1610,  0.0000,    0.0000,    0.0000,    0.0000,    326.0951,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2644.1348, 926.7170,  0.0000,    0.0000,
  0.0000,    1202.7024, 487.7415,  0.0000,    0.0000,    0.0000,    1128.6750, 469.1513,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2403.6878, 2006.0593, 943.5738,  0.0000,    0.0000,    1140.3430,
  952.3807,  501.4229,  0.0000,    0.0000,    1077.9350, 900.5592,  483.0222,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2055.9589, 947.6190,  0.0000,    0.0000,    0.0000,    999.6552,  511.4188,  0.0000,
  0.0000,    0.0000,    948.9231,  493.7990,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1778.6546,
  1132.8667, 0.0000,    0.0000,    0.0000,    889.7259,  595.2252,  0.0000,    0.0000,    0.0000,
  848.6235,  572.3495,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1799.6577, 1002.2471, 0.0000,
  0.0000,    0.0000,    887.4880,  530.7576,  0.0000,    0.0000,    0.0000,    844.4635,  510.9977,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1740.7294, 860.4921,  0.0000,    0.0000,    0.0000,
  859.0997,  465.8648,  0.0000,    0.0000,    0.0000,    817.5462,  450.0079,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1834.1800, 822.9830,  0.0000,    0.0000,    0.0000,    889.7719,  447.6449,
  0.0000,    0.0000,    0.0000,    844.2169,  432.7084,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1768.5649, 1064.0685, 0.0000,    0.0000,    0.0000,    860.7178,  547.9234,  0.0000,    0.0000,
  0.0000,    817.0971,  525.1264,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    690.7425,  430.2353,
  298.4894,  0.0000,    0.0000,    430.2353,  285.6905,  206.3426,  0.0000,    0.0000,    298.4894,
  206.3426,  153.3435,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    743.3179,  384.6931,  249.6819,  0.0000,
  0.0000,    468.2961,  260.7773,  175.3867,  0.0000,    0.0000,    326.3558,  190.5528,  131.8288,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    581.8114,  353.2709,  245.7629,  0.0000,    0.0000,    367.0785,
  240.7834,  172.3036,  0.0000,    0.0000,    256.8278,  176.6607,  129.3444,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    601.4178,  337.1436,  298.7169,  259.5722,  0.0000,    386.4486,  229.7022,  204.1750,
  180.4774,  0.0000,    272.6301,  168.5969,  150.4863,  134.6287,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    626.6472,
  330.3808,  275.2551,  295.8599,  0.0000,    399.4530,  224.7176,  189.6203,  200.4598,  0.0000,
  280.2977,  164.7847,  140.4748,  146.9885,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    480.6938,  333.5014,  0.0000,
  0.0000,    0.0000,    306.1181,  223.4009,  0.0000,    0.0000,    0.0000,    215.5023,  162.3545,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    475.5594,  300.9323,  0.0000,    0.0000,    0.0000,
  311.0603,  207.2926,  0.0000,    0.0000,    0.0000,    221.9656,  153.1295,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    569.7645,  529.0006,  402.8309,  316.6134,  0.0000,    369.6302,  345.9796,
  270.9168,  219.0704,  0.0000,    262.1530,  246.6796,  196.7704,  162.0547,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  479.9639,  444.4196,  420.0642,  369.7049,  319.0075,  321.6404,  299.9706,  284.9729,  253.9905,
  222.7038,  232.7992,  218.2207,  208.0381,  187.0285,  165.7746,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    393.1922,  385.6577,
  374.0038,  357.9757,  0.0000,    271.0770,  266.2939,  258.9856,  248.9955,  0.0000,    200.0486,
  196.7631,  191.7598,  184.9307,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    344.2956,  344.5858,  341.6637,  0.0000,
  0.0000,    241.4585,  241.5803,  239.6357,  0.0000,    0.0000,    180.4705,  180.5365,  179.1559,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    293.9185,  296.3607,  0.0000,    0.0000,    0.0000,    209.7393,
  211.2809,  0.0000,    0.0000,    0.0000,    158.8704,  159.9362,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    249.9413,  0.0000,    0.0000,    0.0000,    0.0000,    181.1819,  0.0000,    0.0000,
  0.0000,    0.0000,    138.9788,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1874.0326,
  566.1856,  0.0000,    0.0000,    0.0000,    1057.5718, 366.8686,  0.0000,    0.0000,    0.0000,
  692.7359,  261.7869,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1511.3043, 1238.5036, 563.7114,
  0.0000,    0.0000,    905.6187,  739.8315,  374.7437,  0.0000,    0.0000,    612.3549,  501.5114,
  270.7543,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1276.4352, 880.6069,  526.0324,  0.0000,    0.0000,
  784.7489,  553.4764,  357.4837,  0.0000,    0.0000,    538.9029,  387.0982,  261.7042,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1121.5489, 606.7040,  525.9535,  0.0000,    0.0000,    700.5432,  402.9200,
  359.6267,  0.0000,    0.0000,    485.9447,  291.2297,  264.3347,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1007.8571, 613.0224,  510.7385,  0.0000,    0.0000,    635.9639,  406.9894,  348.1021,  0.0000,
  0.0000,    444.2328,  294.1186,  255.7658,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    758.9955,  566.4300,
  440.5516,  0.0000,    0.0000,    487.1911,  378.4474,  305.5273,  0.0000,    0.0000,    344.8105,
  274.8422,  227.2947,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    854.7474,  659.7201,  381.4006,  0.0000,
  0.0000,    545.1724,  428.9662,  268.1325,  0.0000,    0.0000,    383.9186,  306.7585,  201.4707,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    633.4394,  480.6382,  357.8667,  0.0000,    0.0000,    411.8187,
  327.3553,  252.8515,  0.0000,    0.0000,    294.2258,  240.6605,  190.7170,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    691.6314,  448.7527,  373.2232,  0.0000,    0.0000,    450.1943,  306.0340,  259.3191,
  0.0000,    0.0000,    321.1384,  225.3888,  193.5970,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    635.3257,
  414.7918,  392.2297,  0.0000,    0.0000,    416.3230,  283.7785,  271.4250,  0.0000,    0.0000,
  298.3014,  209.5976,  201.9007,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    533.6878,  402.8383,  0.0000,
  0.0000,    0.0000,    347.6786,  274.8452,  0.0000,    0.0000,    0.0000,    249.1613,  202.6684,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    553.0919,  389.9953,  0.0000,    0.0000,    0.0000,
  365.5531,  270.2890,  0.0000,    0.0000,    0.0000,    263.4511,  200.9381,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    715.2799,  672.8526,  517.5497,  424.4016,  0.0000,    462.8304,  439.4728,
  348.9930,  293.9840,  0.0000,    328.7836,  314.0026,  254.5781,  218.1566,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  636.6561,  585.4069,  561.6694,  495.0936,  438.0628,  423.3208,  393.1215,  379.2021,  339.3449,
  304.8385,  305.5108,  285.6107,  276.4674,  249.8939,  226.7483,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    547.1981,  533.7253,
  515.8152,  493.4310,  0.0000,    373.2591,  365.2940,  354.5977,  341.1548,  0.0000,    273.8552,
  268.6291,  261.5413,  252.5817,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    496.9143,  495.8801,  490.6786,  0.0000,
  0.0000,    344.0982,  343.7087,  340.6774,  0.0000,    0.0000,    255.1077,  254.9795,  253.0195,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    439.1660,  443.4401,  0.0000,    0.0000,    0.0000,    309.0063,
  311.9395,  0.0000,    0.0000,    0.0000,    231.7484,  233.8940,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    386.5067,  0.0000,    0.0000,    0.0000,    0.0000,    276.0406,  0.0000,    0.0000,
  0.0000,    0.0000,    209.3622,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2283.0674,
  650.0627,  0.0000,    0.0000,    0.0000,    1287.9616, 430.1040,  0.0000,    0.0000,    0.0000,
  844.4635,  310.7016,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1952.1126, 1632.7022, 676.8113,
  0.0000,    0.0000,    1158.6672, 963.6534,  452.1352,  0.0000,    0.0000,    780.0838,  649.5624,
  328.0436,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1653.4435, 1122.6576, 689.4794,  0.0000,    0.0000,
  1006.9636, 701.8768,  466.4241,  0.0000,    0.0000,    688.3433,  489.6953,  340.5132,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    651.1440,  0.0000,    0.0000,    0.0000,    0.0000,    441.7809,  0.0000,
  0.0000,    0.0000,    0.0000,    323.4660,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1709.1137, 630.1961,  0.0000,    0.0000,    0.0000,    1022.9773, 428.1936,  0.0000,    0.0000,
  0.0000,    692.4667,  313.8469,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1630.6018, 616.9100,
  0.0000,    0.0000,    0.0000,    980.4829,  419.2898,  0.0000,    0.0000,    0.0000,    665.3571,
  307.3826,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1586.8512, 596.2971,  0.0000,    0.0000,
  0.0000,    955.4042,  405.7835,  0.0000,    0.0000,    0.0000,    648.7727,  297.7522,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1546.9195, 602.7113,  0.0000,    0.0000,    0.0000,    932.3946,
  408.4460,  0.0000,    0.0000,    0.0000,    633.5005,  298.9583,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1511.4156, 591.6660,  0.0000,    0.0000,    0.0000,    911.9735,  395.7987,  0.0000,
  0.0000,    0.0000,    619.9599,  287.5236,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1142.7015,
  607.3487,  0.0000,    0.0000,    0.0000,    708.5769,  411.2230,  0.0000,    0.0000,    0.0000,
  490.5998,  300.6688,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1368.0049, 567.7536,  0.0000,
  0.0000,    0.0000,    812.0495,  385.7107,  0.0000,    0.0000,    0.0000,    548.8466,  282.6706,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1310.7538, 583.8816,  0.0000,    0.0000,    0.0000,
  781.6260,  393.6386,  0.0000,    0.0000,    0.0000,    529.8069,  287.2154,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1350.2932, 536.2731,  0.0000,    0.0000,    0.0000,    820.3071,  365.5972,
  0.0000,    0.0000,    0.0000,    559.7016,  268.4867,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1320.1912, 520.0492,  0.0000,    0.0000,    0.0000,    802.6609,  354.9945,  0.0000,    0.0000,
  0.0000,    547.8503,  260.9096,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1292.4384, 517.4322,
  0.0000,    0.0000,    0.0000,    786.6336,  352.8632,  0.0000,    0.0000,    0.0000,    537.2011,
  259.1578,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1279.3493, 547.9588,  0.0000,    0.0000,
  0.0000,    777.8232,  371.7528,  0.0000,    0.0000,    0.0000,    530.7581,  271.9114,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1049.6142, 498.7053,  0.0000,    0.0000,    0.0000,    650.0572,
  340.7898,  0.0000,    0.0000,    0.0000,    449.0817,  250.5730,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    993.6282,  722.3849,  497.5754,  0.0000,    0.0000,    632.2099,  470.6076,  343.0870,
  0.0000,    0.0000,    443.5762,  336.2445,  253.6388,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    886.5880,
  655.7091,  526.7674,  0.0000,    0.0000,    573.0945,  433.9122,  359.6452,  0.0000,    0.0000,
  406.2841,  313.2187,  264.6919,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    736.5063,  584.5767,  477.7116,
  0.0000,    0.0000,    481.3814,  393.2421,  331.7429,  0.0000,    0.0000,    344.5387,  286.9156,
  246.9804,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    742.3839,  603.7628,  426.3691,  0.0000,    0.0000,
  488.4719,  400.2879,  299.7482,  0.0000,    0.0000,    350.8340,  289.4662,  225.1927,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    659.8204,  500.9367,  395.3965,  0.0000,    0.0000,    440.1655,  345.0165,
  280.7986,  0.0000,    0.0000,    319.0595,  255.5753,  212.4988,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  594.8728,  467.7586,  411.7157,  0.0000,    0.0000,    401.2522,  323.8511,  288.0024,  0.0000,
  0.0000,    293.0705,  240.9060,  216.0731,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    486.5216,  444.8235,
  433.3107,  0.0000,    0.0000,    331.6965,  308.9151,  303.0374,  0.0000,    0.0000,    244.5597,
  230.3970,  227.0237,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    451.6799,  425.8343,  0.0000,    0.0000,
  0.0000,    309.3075,  295.4222,  0.0000,    0.0000,    0.0000,    228.9026,  220.4032,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    460.8509,  403.4450,  0.0000,    0.0000,    0.0000,    317.5149,
  283.8953,  0.0000,    0.0000,    0.0000,    235.5559,  213.5220,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    728.7526,  718.3558,  544.1795,  470.7581,  0.0000,    473.8496,  470.8995,  371.0160,
  327.6896,  0.0000,    338.7402,  338.0513,  272.9894,  244.3195,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    691.0834,
  629.7820,  573.9057,  558.1380,  510.0132,  459.3743,  424.4677,  391.9364,  383.5023,  354.7425,
  332.2299,  309.6941,  288.3802,  283.2023,  264.0532,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    614.4509,  598.2583,  578.9721,
  556.3538,  0.0000,    418.1044,  409.2113,  398.3224,  385.3409,  0.0000,    306.7492,  301.2053,
  294.2659,  285.8831,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    575.1731,  573.6157,  569.2397,  0.0000,    0.0000,
  396.5736,  396.3285,  394.2442,  0.0000,    0.0000,    293.4799,  293.6645,  292.5542,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    519.2280,  525.3466,  0.0000,    0.0000,    0.0000,    363.6068,  367.9773,
  0.0000,    0.0000,    0.0000,    271.9815,  275.2552,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  466.5786,  0.0000,    0.0000,    0.0000,    0.0000,    331.3014,  0.0000,    0.0000,    0.0000,
  0.0000,    250.3325,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2095.1563, 730.3469,
  0.0000,    0.0000,    0.0000,    1205.4436, 484.0680,  0.0000,    0.0000,    0.0000,    800.2739,
  349.9893,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1894.7707, 1585.0984, 743.1942,  0.0000,
  0.0000,    1139.2761, 951.5840,  497.3405,  0.0000,    0.0000,    773.3663,  647.9337,  361.2684,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1618.3634, 746.3020,  0.0000,    0.0000,    0.0000,    997.0249,
  506.8195,  0.0000,    0.0000,    0.0000,    686.3579,  371.2120,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1399.4778, 892.9693,  0.0000,    0.0000,    0.0000,    885.7661,  590.8566,  0.0000,
  0.0000,    0.0000,    620.3270,  426.7284,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1417.3421,
  790.9665,  0.0000,    0.0000,    0.0000,    884.4280,  526.6765,  0.0000,    0.0000,    0.0000,
  614.7556,  382.5478,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1370.9264, 678.5052,  0.0000,
  0.0000,    0.0000,    856.1039,  461.6686,  0.0000,    0.0000,    0.0000,    595.3863,  339.2395,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1445.0682, 648.9935,  0.0000,    0.0000,    0.0000,
  887.7066,  443.5018,  0.0000,    0.0000,    0.0000,    611.0839,  326.7638,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1393.1385, 839.4969,  0.0000,    0.0000,    0.0000,    858.5302,  544.6560,
  0.0000,    0.0000,    0.0000,    592.0830,  389.3650,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  802.7484,  420.4207,  273.3937,  0.0000,    0.0000,    420.4207,  239.5554,  162.6844,  0.0000,
  0.0000,    273.3937,  162.6844,  113.8463,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    627.5403,  386.2602,
  269.0494,  0.0000,    0.0000,    329.6273,  221.5340,  159.7402,  0.0000,    0.0000,    215.5738,
  151.0768,  111.6491,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    651.9688,  368.4719,  326.2603,  284.0167,
  0.0000,    349.1941,  211.3025,  187.9564,  166.9417,  0.0000,    229.5077,  144.2159,  128.9628,
  115.9223,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    678.4531,  360.9692,  300.9640,  322.6845,  0.0000,    360.0172,
  206.6126,  174.9529,  184.0478,  0.0000,    235.4499,  140.9080,  120.6249,  125.7205,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    519.3078,  363.4171,  0.0000,    0.0000,    0.0000,    275.7206,  204.4480,  0.0000,
  0.0000,    0.0000,    181.3482,  138.3572,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    517.0910,
  329.5196,  0.0000,    0.0000,    0.0000,    282.6667,  191.3125,  0.0000,    0.0000,    0.0000,
  187.7214,  131.3100,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    618.8387,  575.3229,  439.8829,
  347.1545,  0.0000,    335.0615,  314.4244,  248.3153,  202.4740,  0.0000,    221.1217,  208.5110,
  167.5629,  138.9928,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    524.1848,  485.7648,  459.4314,  404.9622,  350.0882,
  294.5184,  275.2607,  261.8866,  234.2680,  206.3483,  197.9394,  185.9246,  177.4973,  160.1207,
  142.5295,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    430.9146,  422.6874,  410.0199,  392.6408,  0.0000,    250.2831,  245.9713,
  239.4120,  230.4659,  0.0000,    171.4077,  168.6780,  164.5248,  158.8578,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  377.8276,  378.1133,  374.9026,  0.0000,    0.0000,    223.9857,  224.0757,  222.2961,  0.0000,
  0.0000,    155.4154,  155.4652,  154.3023,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    322.8433,  325.4945,
  0.0000,    0.0000,    0.0000,    195.4536,  196.8395,  0.0000,    0.0000,    0.0000,    137.5406,
  138.4296,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    274.6419,  0.0000,    0.0000,    0.0000,
  0.0000,    169.5097,  0.0000,    0.0000,    0.0000,    0.0000,    120.9219,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1968.7631, 612.6444,  0.0000,    0.0000,    0.0000,    911.9433,
  332.2215,  0.0000,    0.0000,    0.0000,    566.7169,  221.5102,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1614.7190, 1318.8096, 613.8418,  0.0000,    0.0000,    799.0125,  651.8405,  342.1821,
  0.0000,    0.0000,    506.8036,  415.8340,  230.1231,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1371.4492,
  947.5834,  575.0060,  0.0000,    0.0000,    698.6760,  496.3331,  328.6223,  0.0000,    0.0000,
  448.7768,  324.9751,  223.5637,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1208.7451, 660.1005,  575.3920,
  0.0000,    0.0000,    627.0790,  367.7937,  331.1873,  0.0000,    0.0000,    406.3267,  247.5981,
  226.1684,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1087.9837, 667.0305,  557.9514,  0.0000,    0.0000,
  571.1862,  371.4691,  320.2256,  0.0000,    0.0000,    372.5215,  250.0266,  218.8458,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    820.9313,  616.5993,  482.1362,  0.0000,    0.0000,    439.9326,  346.0423,
  282.4334,  0.0000,    0.0000,    290.7494,  234.1315,  195.4456,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  923.8743,  714.1830,  417.8614,  0.0000,    0.0000,    491.3210,  388.9066,  248.7895,  0.0000,
  0.0000,    323.0552,  259.8051,  173.9292,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    686.1772,  524.7748,
  392.1922,  0.0000,    0.0000,    373.3442,  301.0397,  234.9229,  0.0000,    0.0000,    249.0737,
  206.0020,  164.9015,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    750.3251,  489.7933,  408.0411,  0.0000,
  0.0000,    408.3677,  281.5134,  239.7905,  0.0000,    0.0000,    271.6188,  193.0894,  166.7533,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    689.9647,  452.7353,  428.8509,  0.0000,    0.0000,    378.4295,
  261.2635,  250.7187,  0.0000,    0.0000,    252.7595,  179.7824,  173.6495,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    577.8127,  439.5099,  0.0000,    0.0000,    0.0000,    315.3482,  252.8298,  0.0000,
  0.0000,    0.0000,    211.2390,  173.7381,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    601.4053,
  426.8579,  0.0000,    0.0000,    0.0000,    333.1518,  249.8201,  0.0000,    0.0000,    0.0000,
  223.7644,  172.7698,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    775.2736,  730.5221,  564.6362,
  464.8411,  0.0000,    419.0707,  399.1079,  320.0431,  271.7273,  0.0000,    277.6350,  265.7575,
  217.2467,  187.4120,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    693.7442,  638.7587,  613.3230,  541.7184,  480.2245,
  386.6184,  360.1114,  347.9151,  312.7295,  282.1503,  259.5584,  243.2984,  235.8366,  214.0118,
  194.9556,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    598.5168,  584.0079,  564.7110,  540.5946,  0.0000,    343.5205,  336.5178,
  327.0807,  315.1977,  0.0000,    234.1750,  229.9158,  224.1126,  216.7567,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  544.4156,  543.3438,  537.7470,  0.0000,    0.0000,    318.0485,  317.7750,  315.1229,  0.0000,
  0.0000,    219.0427,  218.9858,  217.3993,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    481.8077,  486.5025,
  0.0000,    0.0000,    0.0000,    286.8720,  289.5784,  0.0000,    0.0000,    0.0000,    199.8924,
  201.7229,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    424.4125,  0.0000,    0.0000,    0.0000,
  0.0000,    257.2803,  0.0000,    0.0000,    0.0000,    0.0000,    181.3837,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2396.3445, 706.1412,  0.0000,    0.0000,    0.0000,    1110.3588,
  392.0831,  0.0000,    0.0000,    0.0000,    691.3086,  264.1180,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2079.4950, 1732.0375, 737.0898,  0.0000,    0.0000,    1018.6688, 845.2119,  413.4328,
  0.0000,    0.0000,    644.6600,  537.5804,  279.2953,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1771.7653,
  1206.1393, 753.0932,  0.0000,    0.0000,    893.5056,  628.2340,  428.1805,  0.0000,    0.0000,
  572.2667,  410.7620,  290.5610,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    711.1423,  0.0000,    0.0000,
  0.0000,    0.0000,    405.8737,  0.0000,    0.0000,    0.0000,    0.0000,    276.3955,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1823.7858, 688.3693,  0.0000,    0.0000,    0.0000,
  902.0482,  393.5556,  0.0000,    0.0000,    0.0000,    573.5714,  268.2902,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1742.1942, 673.8862,  0.0000,    0.0000,    0.0000,    866.0442,  385.4043,
  0.0000,    0.0000,    0.0000,    551.6130,  262.7854,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1696.0441, 651.4438,  0.0000,    0.0000,    0.0000,    844.2856,  373.1223,  0.0000,    0.0000,
  0.0000,    537.9977,  254.6469,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1653.8773, 657.9635,
  0.0000,    0.0000,    0.0000,    824.2830,  375.1051,  0.0000,    0.0000,    0.0000,    525.4406,
  255.4370,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1616.4023, 644.4421,  0.0000,    0.0000,
  0.0000,    806.5432,  362.0493,  0.0000,    0.0000,    0.0000,    514.3112,  244.9612,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1228.0426, 663.1313,  0.0000,    0.0000,    0.0000,    632.5743,
  377.5747,  0.0000,    0.0000,    0.0000,    410.0863,  256.7746,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1454.1614, 620.1711,  0.0000,    0.0000,    0.0000,    713.7552,  354.4940,  0.0000,
  0.0000,    0.0000,    454.6351,  241.6291,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1394.4853,
  636.8428,  0.0000,    0.0000,    0.0000,    688.1125,  360.9437,  0.0000,    0.0000,    0.0000,
  439.4052,  245.1092,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1446.6020, 586.1315,  0.0000,
  0.0000,    0.0000,    727.2378,  336.3582,  0.0000,    0.0000,    0.0000,    464.9730,  229.6866,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1414.7048, 568.5111,  0.0000,    0.0000,    0.0000,
  711.8001,  326.7279,  0.0000,    0.0000,    0.0000,    455.1812,  223.2746,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1385.3712, 565.5959,  0.0000,    0.0000,    0.0000,    697.8565,  324.6761,
  0.0000,    0.0000,    0.0000,    446.4219,  221.7117,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1371.1198, 598.7622,  0.0000,    0.0000,    0.0000,    689.7847,  341.5632,  0.0000,    0.0000,
  0.0000,    440.9182,  232.2310,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1128.5309, 545.3391,
  0.0000,    0.0000,    0.0000,    580.1287,  313.7616,  0.0000,    0.0000,    0.0000,    374.9975,
  214.4570,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1074.7287, 783.0802,  544.8626,  0.0000,
  0.0000,    569.4056,  426.9978,  316.7157,  0.0000,    0.0000,    372.5965,  284.6108,  217.5174,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    961.5194,  712.5928,  575.3875,  0.0000,    0.0000,    518.7905,
  395.6116,  331.0001,  0.0000,    0.0000,    342.6995,  266.1950,  226.6492,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    799.1758,  636.8972,  522.9278,  0.0000,    0.0000,    437.2088,  360.3043,  306.7902,
  0.0000,    0.0000,    291.8077,  244.8688,  212.4317,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    806.7845,
  656.1838,  467.1653,  0.0000,    0.0000,    444.5997,  365.1369,  278.1306,  0.0000,    0.0000,
  297.5289,  246.2016,  194.3936,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    718.5059,  547.6522,  433.5746,
  0.0000,    0.0000,    402.3097,  318.3043,  261.2571,  0.0000,    0.0000,    271.5797,  219.4218,
  183.9638,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    648.7085,  511.5236,  450.3559,  0.0000,    0.0000,
  367.9454,  299.1994,  266.8093,  0.0000,    0.0000,    250.2211,  207.1846,  186.4713,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    530.6527,  486.4755,  474.3318,  0.0000,    0.0000,    305.0501,  285.6292,
  280.7518,  0.0000,    0.0000,    209.6330,  198.3651,  195.7919,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  492.7268,  465.4003,  0.0000,    0.0000,    0.0000,    284.8018,  273.0455,  0.0000,    0.0000,
  0.0000,    196.5204,  189.8099,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    503.5540,  441.9908,
  0.0000,    0.0000,    0.0000,    292.9177,  263.4745,  0.0000,    0.0000,    0.0000,    202.4020,
  184.4413,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    789.1704,  779.3852,  594.1725,  515.5142,
  0.0000,    429.5951,  428.0435,  341.2928,  303.2493,  0.0000,    286.8670,  286.7259,  233.7811,
  210.3030,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    752.1156,  686.8786,  627.1392,  610.5295,  558.7815,  419.4149,
  389.1761,  360.7539,  353.6294,  328.2571,  282.5665,  264.3099,  246.9333,  242.8350,  227.1169,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    671.3055,  654.1216,  633.5630,  609.3943,  0.0000,    384.4496,  376.8524,  367.4475,
  356.1642,  0.0000,    262.3487,  257.9329,  252.3482,  245.5607,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    629.4810,
  627.9828,  623.4035,  0.0000,    0.0000,    366.0547,  366.0540,  364.3814,  0.0000,    0.0000,
  251.8481,  252.1251,  251.3144,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    569.1850,  575.9477,  0.0000,
  0.0000,    0.0000,    337.0928,  341.1725,  0.0000,    0.0000,    0.0000,    234.3810,  237.1991,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    512.0069,  0.0000,    0.0000,    0.0000,    0.0000,
  308.2947,  0.0000,    0.0000,    0.0000,    0.0000,    216.5823,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2209.2516, 793.6663,  0.0000,    0.0000,    0.0000,    1047.2098, 441.5259,
  0.0000,    0.0000,    0.0000,    658.3545,  297.6087,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2023.8919, 1688.3164, 809.5501,  0.0000,    0.0000,    1006.2859, 839.8278,  455.0068,  0.0000,
  0.0000,    641.2312,  538.3070,  307.7217,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1738.4495, 815.2919,
  0.0000,    0.0000,    0.0000,    888.2300,  465.7690,  0.0000,    0.0000,    0.0000,    572.2457,
  317.2251,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1511.0816, 969.9993,  0.0000,    0.0000,
  0.0000,    796.3105,  538.6686,  0.0000,    0.0000,    0.0000,    520.7940,  362.8017,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1525.1022, 859.1044,  0.0000,    0.0000,    0.0000,    791.2577,
  480.9895,  0.0000,    0.0000,    0.0000,    514.6731,  326.0607,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1475.3669, 740.6137,  0.0000,    0.0000,    0.0000,    766.0984,  424.4375,  0.0000,
  0.0000,    0.0000,    498.5663,  290.3501,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1550.1899,
  708.9086,  0.0000,    0.0000,    0.0000,    789.9235,  408.2523,  0.0000,    0.0000,    0.0000,
  509.6277,  279.9620,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1495.5657, 907.8874,  0.0000,
  0.0000,    0.0000,    764.8061,  493.3911,  0.0000,    0.0000,    0.0000,    494.1358,  329.8132,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    491.3349,  303.0480,  212.1109,  0.0000,    0.0000,
  303.0480,  204.9925,  148.3171,  0.0000,    0.0000,    212.1109,  148.3171,  109.5041,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    509.7764,  289.1937,  256.4238,  223.6354,  0.0000,    321.3448,  195.5430,
  174.0536,  154.8608,  0.0000,    225.7346,  141.5815,  126.5885,  113.7287,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  530.3221,  283.3011,  236.6842,  253.5365,  0.0000,    331.0614,  191.1798,  162.1293,  170.3117,
  0.0000,    231.6422,  138.3424,  118.3800,  123.4417,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    406.7268,  285.1018,
  0.0000,    0.0000,    0.0000,    253.7038,  188.9445,  0.0000,    0.0000,    0.0000,    178.3924,
  135.9019,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    404.5558,  258.7290,  0.0000,    0.0000,
  0.0000,    260.5341,  177.2034,  0.0000,    0.0000,    0.0000,    184.5403,  128.8760,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    483.7815,  449.9040,  344.5352,  272.3998,  0.0000,    308.5529,
  289.7588,  229.4318,  187.5580,  0.0000,    217.4040,  204.9523,  164.5553,  136.3818,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    410.2106,  380.3853,  359.9172,  317.5943,  274.9614,  271.9711,  254.3735,  242.1349,
  216.8675,  191.3189,  194.4157,  182.5691,  174.2654,  157.1410,  139.8068,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    338.0096,
  331.6389,  321.8092,  308.3075,  0.0000,    231.7618,  227.8113,  221.8034,  213.6098,  0.0000,
  168.1967,  165.5084,  161.4178,  155.8359,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    297.0396,  297.2697,  294.7778,
  0.0000,    0.0000,    207.7948,  207.8748,  206.2367,  0.0000,    0.0000,    152.4128,  152.4629,
  151.3202,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    254.5306,  256.5939,  0.0000,    0.0000,    0.0000,
  181.6836,  182.9550,  0.0000,    0.0000,    0.0000,    134.8051,  135.6806,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    217.2071,  0.0000,    0.0000,    0.0000,    0.0000,    157.8661,  0.0000,
  0.0000,    0.0000,    0.0000,    118.4578,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1547.1982, 480.6236,  0.0000,    0.0000,    0.0000,    831.7960,  306.2720,  0.0000,    0.0000,
  0.0000,    559.2177,  217.7195,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1263.2327, 1034.0602,
  481.0447,  0.0000,    0.0000,    731.2330,  596.9767,  315.9355,  0.0000,    0.0000,    499.4375,
  409.6773,  226.0537,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1072.3265, 742.6641,  450.9120,  0.0000,
  0.0000,    640.6641,  456.3878,  303.9644,  0.0000,    0.0000,    441.9258,  319.6860,  219.4714,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    945.1713,  517.5812,  451.4130,  0.0000,    0.0000,    575.7752,
  339.6278,  306.5124,  0.0000,    0.0000,    399.9295,  243.2086,  221.9858,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    851.0634,  523.0020,  438.0603,  0.0000,    0.0000,    524.9588,  343.0012,  296.3749,
  0.0000,    0.0000,    366.5329,  245.6037,  214.8053,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    643.1247,
  483.8537,  379.2688,  0.0000,    0.0000,    405.0817,  319.7637,  261.8630,  0.0000,    0.0000,
  285.8977,  229.9399,  191.7333,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    723.3202,  560.3648,  329.3116,
  0.0000,    0.0000,    452.0831,  358.6562,  231.0081,  0.0000,    0.0000,    317.7432,  255.3330,
  170.5557,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    538.1435,  412.2468,  309.3380,  0.0000,    0.0000,
  344.2322,  278.6526,  218.2588,  0.0000,    0.0000,    244.8184,  202.2130,  161.6818,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    587.7544,  385.0153,  321.4850,  0.0000,    0.0000,    376.4045,  260.6567,
  222.4640,  0.0000,    0.0000,    267.0048,  189.5285,  163.5813,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  540.6599,  356.1344,  337.5770,  0.0000,    0.0000,    349.0258,  242.0147,  232.4750,  0.0000,
  0.0000,    248.4203,  176.4513,  170.3774,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    453.6327,  345.6995,
  0.0000,    0.0000,    0.0000,    290.9083,  234.1511,  0.0000,    0.0000,    0.0000,    207.6181,
  170.5403,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    471.5329,  335.7642,  0.0000,    0.0000,
  0.0000,    307.5209,  231.6170,  0.0000,    0.0000,    0.0000,    219.8750,  169.5246,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    607.0964,  572.1729,  442.9855,  365.3129,  0.0000,    386.0628,
  367.9592,  295.9209,  251.8512,  0.0000,    272.9769,  261.2268,  213.3373,  183.8976,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    543.3629,  500.6304,  480.8588,  425.1904,  377.4064,  356.9159,  332.7595,  321.6484,
  289.5301,  261.5954,  255.0100,  238.9587,  231.5914,  210.0623,  191.2703,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    469.4569,
  458.2135,  443.2412,  424.5124,  0.0000,    317.8624,  311.4859,  302.8803,  292.0345,  0.0000,
  229.8877,  225.6812,  219.9538,  212.6969,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    427.6439,  426.8361,  422.5068,
  0.0000,    0.0000,    294.7348,  294.5079,  292.0979,  0.0000,    0.0000,    214.9236,  214.8607,
  213.2923,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    379.2212,  382.8900,  0.0000,    0.0000,    0.0000,
  266.2910,  268.7934,  0.0000,    0.0000,    0.0000,    196.0288,  197.8251,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    334.8259,  0.0000,    0.0000,    0.0000,    0.0000,    239.2190,  0.0000,
  0.0000,    0.0000,    0.0000,    177.7905,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1884.2824, 554.0925,  0.0000,    0.0000,    0.0000,    1013.0459, 362.0455,  0.0000,    0.0000,
  0.0000,    682.0579,  259.4193,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1628.4040, 1359.6156,
  578.0899,  0.0000,    0.0000,    931.8610,  773.6698,  381.9591,  0.0000,    0.0000,    635.3811,
  529.7155,  274.2873,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1386.3132, 945.6808,  590.4390,  0.0000,
  0.0000,    818.8994,  577.5263,  395.8945,  0.0000,    0.0000,    563.6245,  404.1026,  285.2677,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    558.0177,  0.0000,    0.0000,    0.0000,    0.0000,    375.4568,
  0.0000,    0.0000,    0.0000,    0.0000,    271.3545,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1428.1039, 540.2311,  0.0000,    0.0000,    0.0000,    825.7735,  364.1170,  0.0000,
  0.0000,    0.0000,    565.2043,  263.3851,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1363.8456,
  528.8780,  0.0000,    0.0000,    0.0000,    793.0239,  356.5850,  0.0000,    0.0000,    0.0000,
  543.5117,  257.9795,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1327.6064, 511.3384,  0.0000,
  0.0000,    0.0000,    773.1575,  345.2676,  0.0000,    0.0000,    0.0000,    530.0826,  249.9799,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1294.4951, 516.3770,  0.0000,    0.0000,    0.0000,
  754.8861,  346.9868,  0.0000,    0.0000,    0.0000,    517.6989,  250.7830,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1265.0643, 505.6064,  0.0000,    0.0000,    0.0000,    738.6836,  334.5615,
  0.0000,    0.0000,    0.0000,    506.7226,  240.5922,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  961.5600,  520.2569,  0.0000,    0.0000,    0.0000,    580.7773,  349.2095,  0.0000,    0.0000,
  0.0000,    403.6739,  252.1075,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1140.8713, 486.6971,
  0.0000,    0.0000,    0.0000,    653.4752,  327.9705,  0.0000,    0.0000,    0.0000,    447.9970,
  237.2164,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1094.0016, 499.7029,  0.0000,    0.0000,
  0.0000,    630.2533,  333.7444,  0.0000,    0.0000,    0.0000,    432.9245,  240.6788,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1131.7710, 460.0415,  0.0000,    0.0000,    0.0000,    666.3378,
  311.2798,  0.0000,    0.0000,    0.0000,    458.0409,  225.4697,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1106.7246, 446.2432,  0.0000,    0.0000,    0.0000,    652.2155,  302.4017,  0.0000,
  0.0000,    0.0000,    448.3896,  219.1675,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1083.6957,
  443.9051,  0.0000,    0.0000,    0.0000,    639.4782,  300.4715,  0.0000,    0.0000,    0.0000,
  439.7506,  217.6401,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1072.4959, 469.5788,  0.0000,
  0.0000,    0.0000,    632.0123,  315.9092,  0.0000,    0.0000,    0.0000,    434.3472,  228.0072,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    883.0217,  428.0177,  0.0000,    0.0000,    0.0000,
  532.4410,  290.4145,  0.0000,    0.0000,    0.0000,    369.1840,  210.5065,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    840.4537,  613.7862,  427.8056,  0.0000,    0.0000,    523.6122,  393.7053,
  293.3646,  0.0000,    0.0000,    366.5303,  279.7124,  213.4398,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  752.3104,  558.9541,  451.9544,  0.0000,    0.0000,    477.7397,  365.2742,  306.4315,  0.0000,
  0.0000,    336.9544,  261.4925,  222.4463,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    626.3380,  500.0445,
  411.3725,  0.0000,    0.0000,    403.1860,  333.1637,  284.4755,  0.0000,    0.0000,    286.7836,
  240.4309,  208.3891,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    632.2088,  514.9199,  368.1340,  0.0000,
  0.0000,    410.1849,  337.2247,  258.2456,  0.0000,    0.0000,    292.3635,  241.8439,  190.6229,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    563.5059,  430.6457,  342.1426,  0.0000,    0.0000,    371.6448,
  294.9542,  242.8399,  0.0000,    0.0000,    266.7559,  215.3079,  180.3419,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    509.2181,  402.5927,  355.1396,  0.0000,    0.0000,    340.2672,  277.4241,  247.7087,
  0.0000,    0.0000,    245.6967,  203.2695,  182.8801,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    417.4314,
  383.1213,  373.7574,  0.0000,    0.0000,    282.5056,  264.9478,  260.5865,  0.0000,    0.0000,
  205.7658,  194.6013,  192.0365,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    387.9196,  366.7116,  0.0000,
  0.0000,    0.0000,    263.9035,  253.2986,  0.0000,    0.0000,    0.0000,    192.8714,  186.2152,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    396.2999,  348.4756,  0.0000,    0.0000,    0.0000,
  271.5075,  244.6952,  0.0000,    0.0000,    0.0000,    198.6237,  180.8840,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    619.1214,  611.3115,  466.8762,  405.6573,  0.0000,    396.1575,  394.9339,
  315.9654,  281.2690,  0.0000,    281.9690,  281.7756,  229.4894,  206.3212,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  589.8085,  539.0190,  492.5359,  479.6119,  439.3830,  387.3404,  359.8544,  333.9698,  327.5382,
  304.3824,  277.5965,  259.5542,  242.3963,  238.3322,  222.8255,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    526.9321,  513.5941,
  497.6326,  478.8606,  0.0000,    355.7528,  348.8825,  340.3515,  330.0977,  0.0000,    257.5598,
  253.1848,  247.6598,  240.9506,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    494.5914,  493.4612,  489.9354,  0.0000,
  0.0000,    339.1478,  339.2062,  337.7270,  0.0000,    0.0000,    247.1479,  247.4035,  246.5894,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    447.9412,  453.2353,  0.0000,    0.0000,    0.0000,    312.7991,
  316.5839,  0.0000,    0.0000,    0.0000,    229.8923,  232.6541,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    403.7162,  0.0000,    0.0000,    0.0000,    0.0000,    286.5017,  0.0000,    0.0000,
  0.0000,    0.0000,    212.3388,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1735.9767,
  622.7390,  0.0000,    0.0000,    0.0000,    956.8205,  407.7462,  0.0000,    0.0000,    0.0000,
  649.1664,  292.3001,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1584.5838, 1324.5409, 634.9950,
  0.0000,    0.0000,    921.4913,  769.6531,  420.4375,  0.0000,    0.0000,    631.7438,  530.1871,
  302.1801,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1360.0663, 639.6818,  0.0000,    0.0000,    0.0000,
  814.8080,  430.8790,  0.0000,    0.0000,    0.0000,    563.4400,  311.4314,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1182.5093, 761.1526,  0.0000,    0.0000,    0.0000,    732.1547,  497.4416,
  0.0000,    0.0000,    0.0000,    512.3750,  356.3970,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1194.1778, 674.9804,  0.0000,    0.0000,    0.0000,    726.8433,  444.5861,  0.0000,    0.0000,
  0.0000,    506.5349,  320.2177,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1155.2737, 581.8378,
  0.0000,    0.0000,    0.0000,    703.7787,  392.8632,  0.0000,    0.0000,    0.0000,    490.6758,
  285.0230,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1213.8708, 557.0572,  0.0000,    0.0000,
  0.0000,    724.6884,  378.0202,  0.0000,    0.0000,    0.0000,    501.8262,  274.7973,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1171.0013, 712.7577,  0.0000,    0.0000,    0.0000,    701.8063,
  455.0423,  0.0000,    0.0000,    0.0000,    486.5324,  324.1654,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    532.7794,  306.4968,  271.6288,  237.6994,  0.0000,    306.4968,  186.5462,  166.0911,
  147.8057,  0.0000,    271.6288,  166.0911,  148.0657,  132.0085,  0.0000,    237.6994,  147.8057,
  132.0085,  118.2863,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    553.0834,
  300.1055,  251.1837,  267.9482,  0.0000,    315.7713,  182.3876,  154.7198,  162.5286,  0.0000,
  279.7052,  162.3831,  138.0223,  144.8424,  0.0000,    244.2053,  144.4518,  123.3171,  128.8641,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    423.0877,  300.7356,  0.0000,
  0.0000,    0.0000,    242.1030,  180.2719,  0.0000,    0.0000,    0.0000,    214.8093,  160.4015,
  0.0000,    0.0000,    0.0000,    187.8440,  142.1634,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    424.8790,  275.0381,  0.0000,    0.0000,    0.0000,
  248.4855,  169.0461,  0.0000,    0.0000,    0.0000,    220.4525,  150.5946,  0.0000,    0.0000,
  0.0000,    193.8570,  134.3706,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    507.1316,  472.6401,  364.4340,  290.1268,  0.0000,    294.2408,  276.3130,
  218.7964,  178.8774,  0.0000,    260.7548,  244.9914,  194.3868,  159.2584,  0.0000,    228.6785,
  215.3374,  172.2004,  142.1634,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  433.8508,  402.9146,  381.6588,  337.6931,  293.3577,  259.3224,  242.5572,  230.8956,  206.8210,
  182.4798,  230.2133,  215.4752,  205.2122,  184.0272,  162.6068,  203.6278,  191.0014,  182.1731,
  163.9594,  145.5291,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    359.7150,  353.0074,
  342.7215,  328.6403,  0.0000,    221.0233,  217.2635,  211.5422,  203.7369,  0.0000,    196.7046,
  193.4021,  188.3702,  181.5005,  0.0000,    175.4121,  172.5578,  168.2143,  162.2878,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    317.0174,  317.2233,  314.5706,  0.0000,
  0.0000,    198.2213,  198.2993,  196.7403,  0.0000,    0.0000,    176.7844,  176.8558,  175.4826,
  0.0000,    0.0000,    158.4907,  158.5463,  157.3426,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    272.3053,  274.4620,  0.0000,    0.0000,    0.0000,    173.3793,
  174.5910,  0.0000,    0.0000,    0.0000,    155.0169,  156.0859,  0.0000,    0.0000,    0.0000,
  139.7541,  140.6812,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    232.7594,  0.0000,    0.0000,    0.0000,    0.0000,    150.7190,  0.0000,    0.0000,
  0.0000,    0.0000,    135.1147,  0.0000,    0.0000,    0.0000,    0.0000,    122.4536,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1541.8997,
  501.5940,  0.0000,    0.0000,    0.0000,    795.8859,  292.2992,  0.0000,    0.0000,    0.0000,
  704.2730,  259.8039,  0.0000,    0.0000,    0.0000,    596.8306,  228.5106,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1290.8718, 1052.2336, 506.7272,
  0.0000,    0.0000,    698.0762,  570.3024,  301.3614,  0.0000,    0.0000,    617.2493,  504.9905,
  267.8234,  0.0000,    0.0000,    530.3589,  434.4503,  236.7608,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1105.3016, 768.2107,  477.8977,  0.0000,    0.0000,
  611.3403,  435.6701,  289.9137,  0.0000,    0.0000,    540.8706,  386.3776,  257.9190,  0.0000,
  0.0000,    467.8612,  336.9173,  229.2527,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    978.9767,  544.6643,  479.1089,  0.0000,    0.0000,    549.3294,  323.9921,
  292.3514,  0.0000,    0.0000,    486.3325,  288.0243,  260.2108,  0.0000,    0.0000,    422.5208,
  254.6698,  231.6783,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  883.8890,  550.4092,  464.0668,  0.0000,    0.0000,    500.8355,  327.1995,  282.7396,  0.0000,
  0.0000,    443.7007,  290.8988,  251.7856,  0.0000,    0.0000,    386.6491,  257.1961,  224.1590,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    670.3490,  509.6999,
  403.1484,  0.0000,    0.0000,    386.5245,  305.0887,  249.8695,  0.0000,    0.0000,    343.0710,
  271.4559,  222.9546,  0.0000,    0.0000,    300.6753,  240.5139,  199.5325,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    752.9678,  585.2935,  350.8564,  0.0000,
  0.0000,    431.3478,  342.2979,  220.4802,  0.0000,    0.0000,    382.5646,  304.2749,  197.0680,
  0.0000,    0.0000,    334.5583,  267.8666,  177.1019,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    562.4800,  436.4054,  329.8121,  0.0000,    0.0000,    328.5015,
  265.8752,  208.3381,  0.0000,    0.0000,    291.9635,  236.9046,  186.3559,  0.0000,    0.0000,
  256.9295,  210.9797,  167.7448,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    615.4364,  407.4574,  341.3760,  0.0000,    0.0000,    359.1057,  248.7388,  212.3500,
  0.0000,    0.0000,    318.8732,  221.7615,  189.7380,  0.0000,    0.0000,    280.3953,  197.6518,
  170.0773,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    567.1044,
  376.9928,  358.3743,  0.0000,    0.0000,    332.9896,  230.9788,  221.8767,  0.0000,    0.0000,
  295.8366,  206.0649,  198.1008,  0.0000,    0.0000,    260.6337,  183.8900,  177.3010,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    473.9244,  365.6925,  0.0000,
  0.0000,    0.0000,    277.6823,  223.4805,  0.0000,    0.0000,    0.0000,    247.0487,  199.3629,
  0.0000,    0.0000,    0.0000,    217.7112,  177.7934,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    495.6313,  356.9172,  0.0000,    0.0000,    0.0000,
  293.4074,  221.0248,  0.0000,    0.0000,    0.0000,    260.8701,  197.2313,  0.0000,    0.0000,
  0.0000,    230.4010,  176.4697,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    634.7263,  599.8255,  468.1580,  388.6270,  0.0000,    368.3224,  351.0300,
  282.3130,  240.2860,  0.0000,    326.8852,  311.6813,  251.2206,  214.2453,  0.0000,    286.9299,
  274.2537,  222.9925,  191.5317,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  572.8169,  528.9965,  508.7598,  451.4360,  402.0434,  340.4265,  317.3978,  306.8041,  276.1884,
  249.5667,  302.4131,  282.1750,  272.8668,  245.9388,  222.5235,  267.2082,  250.0264,  242.1351,
  219.1541,  199.1182,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    498.0472,  486.4645,
  471.0186,  451.6893,  0.0000,    303.1856,  297.1110,  288.9115,  278.5760,  0.0000,    269.8010,
  264.4748,  257.2754,  248.1924,  0.0000,    240.0396,  235.5276,  229.4010,  221.6512,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    455.0836,  454.3170,  449.8664,  0.0000,
  0.0000,    281.1633,  280.9482,  278.6529,  0.0000,    0.0000,    250.5626,  250.3896,  248.3821,
  0.0000,    0.0000,    223.8964,  223.7999,  222.1108,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    404.6929,  408.6064,  0.0000,    0.0000,    0.0000,    254.0877,
  256.4721,  0.0000,    0.0000,    0.0000,    226.8510,  228.9654,  0.0000,    0.0000,    0.0000,
  203.6855,  205.5633,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    358.0954,  0.0000,    0.0000,    0.0000,    0.0000,    228.3256,  0.0000,    0.0000,
  0.0000,    0.0000,    204.2663,  0.0000,    0.0000,    0.0000,    0.0000,    184.2665,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1875.7209,
  581.8458,  0.0000,    0.0000,    0.0000,    969.5462,  345.4470,  0.0000,    0.0000,    0.0000,
  858.1614,  307.2297,  0.0000,    0.0000,    0.0000,    727.5711,  271.6004,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1656.9384, 1375.9674, 609.2865,
  0.0000,    0.0000,    889.9346,  739.5090,  364.3760,  0.0000,    0.0000,    787.1393,  654.9942,
  324.0498,  0.0000,    0.0000,    675.0933,  562.1481,  286.9784,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1423.4023, 975.9836,  625.0103,  0.0000,    0.0000,
  781.6350,  551.4226,  377.5895,  0.0000,    0.0000,    691.6368,  489.0580,  335.8153,  0.0000,
  0.0000,    597.1154,  426.0198,  298.1443,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    590.7387,  0.0000,    0.0000,    0.0000,    0.0000,    358.1677,  0.0000,
  0.0000,    0.0000,    0.0000,    318.8026,  0.0000,    0.0000,    0.0000,    0.0000,    283.4108,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1457.0358, 572.0738,  0.0000,    0.0000,    0.0000,    788.5809,  347.3566,  0.0000,    0.0000,
  0.0000,    697.7563,  309.2299,  0.0000,    0.0000,    0.0000,    599.8783,  275.0230,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1394.0822, 560.0917,
  0.0000,    0.0000,    0.0000,    757.1711,  340.1719,  0.0000,    0.0000,    0.0000,    669.9835,
  302.8447,  0.0000,    0.0000,    0.0000,    576.6205,  269.3672,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1357.7395, 541.6401,  0.0000,    0.0000,
  0.0000,    738.1748,  329.3812,  0.0000,    0.0000,    0.0000,    653.1705,  293.2805,  0.0000,
  0.0000,    0.0000,    562.3122,  260.9610,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1324.4770, 546.3363,  0.0000,    0.0000,    0.0000,    720.7052,
  331.0282,  0.0000,    0.0000,    0.0000,    637.7039,  294.6745,  0.0000,    0.0000,    0.0000,
  549.1278,  261.9299,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1294.9313, 533.0040,  0.0000,    0.0000,    0.0000,    705.2129,  319.1993,  0.0000,
  0.0000,    0.0000,    623.9865,  284.0111,  0.0000,    0.0000,    0.0000,    537.4395,  251.6701,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    992.0673,
  550.5045,  0.0000,    0.0000,    0.0000,    554.3462,  333.1240,  0.0000,    0.0000,    0.0000,
  491.2047,  296.4553,  0.0000,    0.0000,    0.0000,    426.4723,  263.3886,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1157.9011, 515.3839,  0.0000,
  0.0000,    0.0000,    624.4481,  312.8735,  0.0000,    0.0000,    0.0000,    553.1437,  278.5319,
  0.0000,    0.0000,    0.0000,    475.3065,  247.7080,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1111.8174, 527.9435,  0.0000,    0.0000,    0.0000,
  602.2672,  318.4010,  0.0000,    0.0000,    0.0000,    533.5343,  283.3520,  0.0000,    0.0000,
  0.0000,    459.0336,  251.5373,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1161.4905, 487.6202,  0.0000,    0.0000,    0.0000,    636.0357,  296.9473,
  0.0000,    0.0000,    0.0000,    562.7864,  264.4013,  0.0000,    0.0000,    0.0000,    485.4961,
  235.3426,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1136.1897, 473.1486,  0.0000,    0.0000,    0.0000,    622.5372,  288.4783,  0.0000,    0.0000,
  0.0000,    550.8249,  256.8824,  0.0000,    0.0000,    0.0000,    475.2458,  228.7263,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1113.0259, 470.5820,
  0.0000,    0.0000,    0.0000,    610.3600,  286.6332,  0.0000,    0.0000,    0.0000,    540.0415,
  255.2100,  0.0000,    0.0000,    0.0000,    466.0487,  227.1685,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1101.2182, 497.4063,  0.0000,    0.0000,
  0.0000,    603.2352,  301.3273,  0.0000,    0.0000,    0.0000,    533.6923,  268.0922,  0.0000,
  0.0000,    0.0000,    460.4063,  238.2171,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    911.4150,  454.0159,  0.0000,    0.0000,    0.0000,    508.1631,
  277.0338,  0.0000,    0.0000,    0.0000,    449.9922,  246.6776,  0.0000,    0.0000,    0.0000,
  390.2937,  219.6742,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    875.4336,  642.1929,  454.8427,  0.0000,    0.0000,    499.4701,  375.6522,  279.8339,
  0.0000,    0.0000,    442.5145,  333.6302,  249.2727,  0.0000,    0.0000,    386.3350,  293.5672,
  222.4774,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    787.0327,
  587.2474,  478.7837,  0.0000,    0.0000,    455.6866,  348.5157,  292.3568,  0.0000,    0.0000,
  404.1174,  309.8782,  260.4422,  0.0000,    0.0000,    354.3804,  273.8542,  232.0332,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    656.2260,  527.5583,  437.4383,
  0.0000,    0.0000,    384.6723,  317.8847,  271.4443,  0.0000,    0.0000,    341.7207,  283.0005,
  242.2155,  0.0000,    0.0000,    300.9128,  251.2320,  216.8346,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    663.8871,  541.0981,  392.2549,  0.0000,    0.0000,
  391.3110,  321.7792,  246.4711,  0.0000,    0.0000,    347.6512,  286.2438,  220.2800,  0.0000,
  0.0000,    306.5770,  253.1710,  197.9479,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    593.7533,  456.9650,  365.1785,  0.0000,    0.0000,    354.5582,  281.4541,
  231.8089,  0.0000,    0.0000,    315.3464,  251.0341,  207.4367,  0.0000,    0.0000,    279.1748,
  224.2702,  186.9721,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  537.8946,  427.5064,  377.5377,  0.0000,    0.0000,    324.6491,  264.7615,  236.4698,  0.0000,
  0.0000,    289.0431,  236.3485,  211.4541,  0.0000,    0.0000,    256.7126,  211.5286,  189.9313,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    441.4021,  406.9549,
  397.6543,  0.0000,    0.0000,    269.6338,  252.8828,  248.7264,  0.0000,    0.0000,    240.5449,
  225.8799,  222.2868,  0.0000,    0.0000,    214.5085,  202.3866,  199.5323,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    410.4068,  389.1957,  0.0000,    0.0000,
  0.0000,    251.9151,  241.7970,  0.0000,    0.0000,    0.0000,    224.9175,  216.0720,  0.0000,
  0.0000,    0.0000,    200.8940,  193.6361,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    420.2552,  371.2655,  0.0000,    0.0000,    0.0000,    259.1382,
  233.5761,  0.0000,    0.0000,    0.0000,    231.3250,  208.8699,  0.0000,    0.0000,    0.0000,
  206.8147,  187.7962,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    646.8845,  640.5300,  494.2894,  431.6118,  0.0000,    378.0913,  376.8690,  301.4996,
  268.4120,  0.0000,    336.1160,  335.0533,  268.7131,  239.6026,  0.0000,    295.8667,  295.4429,
  239.3999,  214.6371,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    620.8744,
  569.4339,  522.0102,  509.1470,  467.7393,  369.5502,  343.3252,  318.6390,  312.4971,  290.4242,
  328.6327,  305.5829,  283.8768,  278.4951,  259.0820,  290.6684,  271.2766,  252.8942,  248.4710,
  231.9130,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    558.1740,  544.7508,  528.5648,
  509.4485,  0.0000,    339.3939,  332.8405,  324.7053,  314.9283,  0.0000,    302.2080,  296.4710,
  289.3394,  280.7602,  0.0000,    268.8943,  264.1460,  258.1828,  250.9655,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    525.4979,  524.5809,  521.1328,  0.0000,    0.0000,
  323.5710,  323.6247,  322.2142,  0.0000,    0.0000,    288.4150,  288.4923,  287.2780,  0.0000,
  0.0000,    257.5450,  257.7450,  256.8166,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    477.4046,  483.1101,  0.0000,    0.0000,    0.0000,    298.4799,  302.0858,
  0.0000,    0.0000,    0.0000,    266.4595,  269.6630,  0.0000,    0.0000,    0.0000,    239.0010,
  241.8737,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  431.2543,  0.0000,    0.0000,    0.0000,    0.0000,    273.4501,  0.0000,    0.0000,    0.0000,
  0.0000,    244.5308,  0.0000,    0.0000,    0.0000,    0.0000,    220.2545,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1740.6013, 654.3215,
  0.0000,    0.0000,    0.0000,    915.1610,  389.0394,  0.0000,    0.0000,    0.0000,    810.3485,
  345.9951,  0.0000,    0.0000,    0.0000,    690.8529,  305.9775,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1619.2221, 1348.7863, 669.5156,  0.0000,
  0.0000,    879.8339,  735.3257,  401.0824,  0.0000,    0.0000,    778.5193,  651.4943,  356.7321,
  0.0000,    0.0000,    670.1098,  561.6015,  316.0762,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1401.7622, 677.4555,  0.0000,    0.0000,    0.0000,    777.6165,
  411.0232,  0.0000,    0.0000,    0.0000,    688.3516,  365.8247,  0.0000,    0.0000,    0.0000,
  596.1001,  325.2532,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1228.7380, 799.2515,  0.0000,    0.0000,    0.0000,    698.5619,  474.6874,  0.0000,
  0.0000,    0.0000,    619.1558,  422.1621,  0.0000,    0.0000,    0.0000,    540.1665,  373.1793,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1234.4914,
  709.0047,  0.0000,    0.0000,    0.0000,    693.7143,  424.3835,  0.0000,    0.0000,    0.0000,
  614.8490,  377.8279,  0.0000,    0.0000,    0.0000,    534.7226,  334.8134,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1194.5389, 615.6990,  0.0000,
  0.0000,    0.0000,    671.7007,  374.8659,  0.0000,    0.0000,    0.0000,    595.3907,  334.0164,
  0.0000,    0.0000,    0.0000,    517.9239,  297.4082,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1248.7909, 590.1554,  0.0000,    0.0000,    0.0000,
  691.7985,  360.7035,  0.0000,    0.0000,    0.0000,    612.8794,  321.5004,  0.0000,    0.0000,
  0.0000,    530.8043,  286.5840,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1206.0158, 743.4455,  0.0000,    0.0000,    0.0000,    669.9158,  434.3905,
  0.0000,    0.0000,    0.0000,    593.5301,  386.3011,  0.0000,    0.0000,    0.0000,    514.4508,
  340.0600,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  574.7436,  309.2543,  258.3888,  276.2327,  0.0000,    309.2543,  178.3311,  151.2409,  158.9405,
  0.0000,    258.3888,  151.2409,  128.7820,  134.8933,  0.0000,    276.2327,  158.9405,  134.8933,
  141.8763,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    439.6365,  310.5133,
  0.0000,    0.0000,    0.0000,    237.1200,  176.3358,  0.0000,    0.0000,    0.0000,    198.5202,
  149.1479,  0.0000,    0.0000,    0.0000,    212.1434,  157.3396,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    440.0900,  282.9656,  0.0000,    0.0000,
  0.0000,    243.1960,  165.2361,  0.0000,    0.0000,    0.0000,    204.3119,  140.4552,  0.0000,
  0.0000,    0.0000,    216.9447,  147.1597,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    525.8162,  489.5499,  376.1112,  298.3141,  0.0000,    288.0073,
  270.4023,  213.9621,  174.8058,  0.0000,    241.3636,  227.0001,  180.7289,  148.5642,  0.0000,
  256.7960,  241.0016,  190.4799,  155.4813,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    447.9868,  415.6439,  393.4530,  347.5445,  301.2669,  253.6134,  237.1737,  225.7435,
  202.1442,  178.2858,  213.9134,  200.4003,  190.9759,  171.5246,  151.8497,  225.7080,  211.0440,
  200.8574,  179.8178,  158.5536,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    370.0359,
  363.0566,  352.3403,  337.6607,  0.0000,    216.0043,  212.3221,  206.7172,  199.0695,  0.0000,
  183.4110,  180.3695,  175.7399,  169.4227,  0.0000,    192.1103,  188.8450,  183.8623,  177.0557,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    325.3419,  325.5667,  322.8238,
  0.0000,    0.0000,    193.6432,  193.7213,  192.1970,  0.0000,    0.0000,    165.1961,  165.2584,
  163.9864,  0.0000,    0.0000,    172.2718,  172.3493,  171.0031,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    278.7705,  281.0154,  0.0000,    0.0000,    0.0000,
  169.3133,  170.5004,  0.0000,    0.0000,    0.0000,    145.1828,  146.1681,  0.0000,    0.0000,
  0.0000,    150.7426,  151.8006,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    237.7447,  0.0000,    0.0000,    0.0000,    0.0000,    147.1417,  0.0000,
  0.0000,    0.0000,    0.0000,    126.8094,  0.0000,    0.0000,    0.0000,    0.0000,    131.1600,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1625.1034, 519.9826,  0.0000,    0.0000,    0.0000,    781.8441,  286.1241,  0.0000,    0.0000,
  0.0000,    640.5782,  240.6629,  0.0000,    0.0000,    0.0000,    705.9328,  255.8512,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1351.3702, 1101.6666,
  523.7002,  0.0000,    0.0000,    684.7715,  559.3883,  294.8004,  0.0000,    0.0000,    565.7790,
  462.8902,  248.7379,  0.0000,    0.0000,    614.6139,  502.4634,  262.8982,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1153.5737, 799.3710,  492.5198,  0.0000,
  0.0000,    599.2652,  426.7405,  283.4424,  0.0000,    0.0000,    497.3996,  356.4737,  240.1326,
  0.0000,    0.0000,    536.6745,  381.7903,  252.4245,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1019.7589, 562.9344,  493.3692,  0.0000,    0.0000,    538.2480,
  316.9417,  285.7823,  0.0000,    0.0000,    448.1600,  267.4973,  242.4422,  0.0000,    0.0000,
  481.5000,  282.7021,  254.4567,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    919.5354,  568.9088,  478.0372,  0.0000,    0.0000,    490.5973,  320.0960,  276.4113,
  0.0000,    0.0000,    409.4287,  270.1688,  234.5558,  0.0000,    0.0000,    438.6502,  285.5945,
  246.3077,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    695.8348,
  526.3795,  414.3156,  0.0000,    0.0000,    378.4594,  298.4129,  244.1847,  0.0000,    0.0000,
  317.3472,  252.3281,  208.1570,  0.0000,    0.0000,    338.3535,  266.2568,  217.6457,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    782.2483,  606.4740,  359.9017,
  0.0000,    0.0000,    422.4144,  335.0287,  215.4030,  0.0000,    0.0000,    353.5546,  281.9707,
  184.3086,  0.0000,    0.0000,    377.6302,  299.4461,  192.0591,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    582.9014,  449.5806,  338.0805,  0.0000,    0.0000,
  321.5506,  259.9472,  203.5228,  0.0000,    0.0000,    270.5502,  220.7203,  174.4070,  0.0000,
  0.0000,    287.4614,  231.8285,  181.5196,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    637.7634,  419.6709,  350.7171,  0.0000,    0.0000,    351.4986,  243.1909,
  207.5282,  0.0000,    0.0000,    295.4451,  206.6729,  177.2508,  0.0000,    0.0000,    313.9577,
  216.9806,  185.2154,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  587.1819,  388.1200,  368.4032,  0.0000,    0.0000,    325.8858,  225.8165,  216.8602,  0.0000,
  0.0000,    274.3366,  192.1416,  184.9554,  0.0000,    0.0000,    291.0309,  201.5536,  193.4900,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    490.9783,  376.6281,
  0.0000,    0.0000,    0.0000,    271.8088,  218.5075,  0.0000,    0.0000,    0.0000,    229.0537,
  185.8430,  0.0000,    0.0000,    0.0000,    243.2009,  195.0917,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    512.6220,  366.8668,  0.0000,    0.0000,
  0.0000,    287.0958,  216.0211,  0.0000,    0.0000,    0.0000,    242.1824,  184.1433,  0.0000,
  0.0000,    0.0000,    256.3643,  192.6099,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    658.2526,  621.3305,  482.9577,  399.5106,  0.0000,    360.5731,
  343.5620,  276.0871,  234.8390,  0.0000,    302.6341,  288.8824,  233.7477,  199.9712,  0.0000,
  322.0771,  306.7120,  246.1570,  209.2104,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    592.0464,  546.0473,  524.7928,  464.7381,  413.0565,  333.0301,  310.4237,  300.0232,
  269.9857,  243.8751,  280.8455,  262.3696,  253.8779,  229.2387,  207.7855,  296.8872,  276.6393,
  267.3225,  240.4605,  217.1392,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    513.0585,
  500.9011,  484.7111,  464.4665,  0.0000,    296.4064,  290.4433,  282.3973,  272.2578,  0.0000,
  251.3164,  246.4555,  239.8735,  231.5614,  0.0000,    263.9496,  258.6194,  251.4301,  242.3721,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    467.8493,  467.0009,  462.3208,
  0.0000,    0.0000,    274.7751,  274.5580,  272.3038,  0.0000,    0.0000,    233.8236,  233.6876,
  231.8603,  0.0000,    0.0000,    244.6310,  244.4292,  242.4149,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    415.1303,  419.1592,  0.0000,    0.0000,    0.0000,
  248.2237,  250.5536,  0.0000,    0.0000,    0.0000,    212.1168,  214.0853,  0.0000,    0.0000,
  0.0000,    221.0250,  223.0896,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    366.5597,  0.0000,    0.0000,    0.0000,    0.0000,    222.9856,  0.0000,
  0.0000,    0.0000,    0.0000,    191.3621,  0.0000,    0.0000,    0.0000,    0.0000,    198.6584,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1976.8609, 601.5808,  0.0000,    0.0000,    0.0000,    952.3401,  337.9454,  0.0000,    0.0000,
  0.0000,    780.5520,  285.2553,  0.0000,    0.0000,    0.0000,    859.7252,  301.6400,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1736.3987, 1442.5133,
  629.2493,  0.0000,    0.0000,    873.1622,  725.5203,  356.3892,  0.0000,    0.0000,    720.7044,
  599.5116,  301.1629,  0.0000,    0.0000,    784.5252,  652.3996,  317.8255,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1487.1454, 1016.1745, 644.5028,  0.0000,
  0.0000,    766.3677,  540.1679,  369.1952,  0.0000,    0.0000,    635.3561,  450.9348,  312.4878,
  0.0000,    0.0000,    686.9902,  483.4812,  328.8388,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    608.9242,  0.0000,    0.0000,    0.0000,    0.0000,    350.2054,
  0.0000,    0.0000,    0.0000,    0.0000,    296.8236,  0.0000,    0.0000,    0.0000,    0.0000,
  312.1102,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1525.4141, 589.5695,  0.0000,    0.0000,    0.0000,    773.5549,  339.6232,  0.0000,
  0.0000,    0.0000,    639.6214,  287.9649,  0.0000,    0.0000,    0.0000,    694.6969,  302.6820,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1458.7399,
  577.1994,  0.0000,    0.0000,    0.0000,    742.6757,  332.5971,  0.0000,    0.0000,    0.0000,
  614.5241,  282.0297,  0.0000,    0.0000,    0.0000,    666.7343,  296.4247,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1420.5045, 558.0904,  0.0000,
  0.0000,    0.0000,    724.0207,  322.0375,  0.0000,    0.0000,    0.0000,    599.1969,  273.1670,
  0.0000,    0.0000,    0.0000,    649.9094,  287.0163,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1385.5313, 563.2255,  0.0000,    0.0000,    0.0000,
  706.8671,  323.6772,  0.0000,    0.0000,    0.0000,    585.0856,  274.3346,  0.0000,    0.0000,
  0.0000,    634.4415,  288.5206,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1354.4595, 550.3952,  0.0000,    0.0000,    0.0000,    691.6538,  312.2221,
  0.0000,    0.0000,    0.0000,    572.5728,  264.0373,  0.0000,    0.0000,    0.0000,    620.7184,
  278.5957,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1034.1932, 567.6026,  0.0000,    0.0000,    0.0000,    543.2742,  325.7328,  0.0000,    0.0000,
  0.0000,    452.3968,  275.9455,  0.0000,    0.0000,    0.0000,    486.7180,  290.3039,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1213.2014, 531.1595,
  0.0000,    0.0000,    0.0000,    612.6329,  305.9112,  0.0000,    0.0000,    0.0000,    506.6985,
  259.3743,  0.0000,    0.0000,    0.0000,    550.9242,  272.6492,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1164.2755, 544.6244,  0.0000,    0.0000,
  0.0000,    590.7694,  311.3689,  0.0000,    0.0000,    0.0000,    489.0187,  263.6377,  0.0000,
  0.0000,    0.0000,    530.9799,  277.6170,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1213.9348, 502.3206,  0.0000,    0.0000,    0.0000,    623.6996,
  290.3139,  0.0000,    0.0000,    0.0000,    516.8454,  246.3103,  0.0000,    0.0000,    0.0000,
  559.3819,  258.6987,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1187.3873, 487.3312,  0.0000,    0.0000,    0.0000,    610.4511,  282.0254,  0.0000,
  0.0000,    0.0000,    505.9042,  239.3413,  0.0000,    0.0000,    0.0000,    547.4456,  251.2997,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1163.0369,
  484.7511,  0.0000,    0.0000,    0.0000,    598.4935,  280.2274,  0.0000,    0.0000,    0.0000,
  496.0618,  237.7527,  0.0000,    0.0000,    0.0000,    536.6581,  249.6938,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1150.8553, 512.7473,  0.0000,
  0.0000,    0.0000,    591.5255,  294.6262,  0.0000,    0.0000,    0.0000,    490.1530,  249.5747,
  0.0000,    0.0000,    0.0000,    530.4351,  262.4692,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    950.3278,  467.5642,  0.0000,    0.0000,    0.0000,
  498.0253,  270.8278,  0.0000,    0.0000,    0.0000,    414.2968,  229.8523,  0.0000,    0.0000,
  0.0000,    445.9999,  241.2788,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    909.8407,  665.3265,  467.8560,  0.0000,    0.0000,    489.1525,  367.6414,
  273.4930,  0.0000,    0.0000,    408.7169,  309.1510,  232.4905,  0.0000,    0.0000,    437.0033,
  328.2318,  243.4937,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  816.3455,  607.1928,  493.0665,  0.0000,    0.0000,    446.0916,  340.9580,  285.7997,  0.0000,
  0.0000,    374.0020,  287.7037,  242.6850,  0.0000,    0.0000,    398.2274,  304.2647,  254.6976,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    679.6314,  544.3315,
  449.4776,  0.0000,    0.0000,    376.4665,  310.8748,  265.2596,  0.0000,    0.0000,    316.7847,
  263.2796,  226.1706,  0.0000,    0.0000,    336.1845,  277.3159,  236.4040,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    687.0143,  559.3398,  402.3692,  0.0000,
  0.0000,    382.9012,  314.7994,  240.7938,  0.0000,    0.0000,    322.5147,  265.8522,  206.0127,
  0.0000,    0.0000,    341.7364,  281.0326,  214.6759,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    613.3513,  470.0557,  374.0715,  0.0000,    0.0000,    346.8251,
  275.1022,  226.4226,  0.0000,    0.0000,    293.0506,  234.1981,  194.2462,  0.0000,    0.0000,
  309.4326,  245.2844,  201.9163,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    554.8479,  439.4376,  387.5023,  0.0000,    0.0000,    317.4884,  258.7633,  231.0624,
  0.0000,    0.0000,    268.9834,  220.6612,  197.7025,  0.0000,    0.0000,    283.2257,  230.8046,
  206.2272,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    454.6295,
  418.1348,  408.1971,  0.0000,    0.0000,    263.6322,  247.1432,  243.0407,  0.0000,    0.0000,
  224.2160,  210.9851,  207.7935,  0.0000,    0.0000,    235.3968,  220.5141,  216.8140,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    422.4478,  399.9289,  0.0000,
  0.0000,    0.0000,    246.2902,  236.3233,  0.0000,    0.0000,    0.0000,    209.7881,  201.8322,
  0.0000,    0.0000,    0.0000,    219.9967,  210.9862,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    432.2741,  380.8039,  0.0000,    0.0000,    0.0000,
  253.3149,  228.2128,  0.0000,    0.0000,    0.0000,    215.8792,  195.3965,  0.0000,    0.0000,
  0.0000,    226.0929,  203.5907,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    670.3436,  663.1102,  509.1508,  443.3798,  0.0000,    370.0933,  368.8212,
  294.7815,  262.3055,  0.0000,    311.4949,  310.7796,  250.4043,  223.8146,  0.0000,    330.9013,
  329.5207,  262.9421,  233.8462,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  641.6764,  587.4631,  537.6147,  523.9545,  480.5640,  361.5357,  335.7634,  311.5211,  305.4707,
  283.8131,  305.2826,  284.3351,  264.5468,  259.7061,  241.9473,  322.6499,  299.4642,  277.7110,
  272.2302,  252.8569,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    575.1487,  560.9353,
  543.8541,  523.7216,  0.0000,    331.8393,  325.3891,  317.3906,  307.7839,  0.0000,    281.4890,
  276.3091,  269.8411,  262.0399,  0.0000,    295.7851,  289.9658,  282.7718,  274.1459,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    540.5327,  539.4410,  535.7257,  0.0000,
  0.0000,    316.2653,  316.3002,  314.9022,  0.0000,    0.0000,    269.0574,  269.1896,  268.1274,
  0.0000,    0.0000,    281.7843,  281.7769,  280.4988,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    490.0296,  495.8721,  0.0000,    0.0000,    0.0000,    291.6345,
  295.1541,  0.0000,    0.0000,    0.0000,    249.0414,  252.0363,  0.0000,    0.0000,    0.0000,
  259.8070,  262.9168,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    441.8052,  0.0000,    0.0000,    0.0000,    0.0000,    267.0974,  0.0000,    0.0000,
  0.0000,    0.0000,    228.9410,  0.0000,    0.0000,    0.0000,    0.0000,    238.0129,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1830.2286,
  676.3693,  0.0000,    0.0000,    0.0000,    898.4706,  380.5722,  0.0000,    0.0000,    0.0000,
  739.1647,  321.3035,  0.0000,    0.0000,    0.0000,    809.8160,  339.6152,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1694.2469, 1411.1951, 691.2883,
  0.0000,    0.0000,    862.9402,  721.1155,  392.2686,  0.0000,    0.0000,    714.0530,  597.6475,
  331.6029,  0.0000,    0.0000,    774.5473,  647.5774,  349.7788,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1462.5357, 698.2313,  0.0000,    0.0000,    0.0000,
  762.2073,  401.8734,  0.0000,    0.0000,    0.0000,    633.2886,  340.6271,  0.0000,    0.0000,
  0.0000,    682.7156,  358.0940,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1277.7896, 826.3855,  0.0000,    0.0000,    0.0000,    684.2421,  464.3949,
  0.0000,    0.0000,    0.0000,    571.6159,  391.9818,  0.0000,    0.0000,    0.0000,    611.8574,
  414.4715,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1285.9300, 732.4082,  0.0000,    0.0000,    0.0000,    679.7492,  415.0966,  0.0000,    0.0000,
  0.0000,    566.7294,  351.1435,  0.0000,    0.0000,    0.0000,    608.7194,  370.5351,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1244.2037, 634.3664,
  0.0000,    0.0000,    0.0000,    658.1727,  366.5198,  0.0000,    0.0000,    0.0000,    548.8568,
  311.1729,  0.0000,    0.0000,    0.0000,    589.4258,  326.8903,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1303.3334, 607.7150,  0.0000,    0.0000,
  0.0000,    678.1856,  352.6419,  0.0000,    0.0000,    0.0000,    563.8170,  299.6659,  0.0000,
  0.0000,    0.0000,    608.1886,  314.4913,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1258.2170, 770.5407,  0.0000,    0.0000,    0.0000,    656.6800,
  425.2003,  0.0000,    0.0000,    0.0000,    546.2316,  357.9521,  0.0000,    0.0000,    0.0000,
  588.7482,  380.2811,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    337.1808,  238.1207,  0.0000,    0.0000,    0.0000,    238.1207,  174.9969,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    336.6493,
  216.9570,  0.0000,    0.0000,    0.0000,    242.6893,  162.9236,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    401.9613,  374.2537,  287.7668,
  228.4811,  0.0000,    287.8520,  269.7344,  212.0275,  172.1215,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    342.4261,  317.8624,  300.9874,  266.0920,  230.9258,
  251.5386,  234.8327,  223.2574,  199.3430,  175.1844,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    283.3323,  278.0578,  269.9330,  258.7830,  0.0000,    212.8346,  209.1322,
  203.4807,  195.7595,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  249.6385,  249.8210,  247.7460,  0.0000,    0.0000,    190.0771,  190.1685,  188.6560,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    214.5059,  216.2140,
  0.0000,    0.0000,    0.0000,    165.5860,  166.7816,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    183.5347,  0.0000,    0.0000,    0.0000,
  0.0000,    143.4525,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1259.4427, 399.3534,  0.0000,    0.0000,    0.0000,    807.8786,
  286.0131,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1037.7284, 848.7952,  401.1714,  0.0000,    0.0000,    697.8623,  569.9151,  292.9783,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    884.1648,
  614.0983,  377.2375,  0.0000,    0.0000,    606.8585,  429.3743,  280.2569,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    781.1133,  431.5544,  377.9964,
  0.0000,    0.0000,    542.9499,  314.9908,  282.1724,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    704.3789,  436.1042,  366.6648,  0.0000,    0.0000,
  493.6363,  318.2136,  273.1065,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    533.6535,  403.8400,  318.3239,  0.0000,    0.0000,    379.2299,  296.1989,
  240.3673,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  599.6192,  465.8147,  276.9970,  0.0000,    0.0000,    423.9154,  334.5615,  211.4238,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    447.4259,  345.1043,
  260.4199,  0.0000,    0.0000,    321.2502,  256.9480,  199.5641,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    488.7501,  322.3988,  269.9886,  0.0000,
  0.0000,    351.1222,  240.3260,  204.2511,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    450.0559,  298.3894,  283.3292,  0.0000,    0.0000,    325.0466,
  223.0154,  213.6379,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    377.3531,  289.5580,  0.0000,    0.0000,    0.0000,    271.4634,  215.9581,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    393.0510,
  281.8675,  0.0000,    0.0000,    0.0000,    285.8180,  212.7468,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    504.3802,  476.0165,  370.2813,
  306.5977,  0.0000,    360.6626,  342.8931,  273.5167,  231.2700,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    453.2089,  418.1730,  401.9752,  356.2413,  316.9274,
  331.0063,  307.8194,  297.1406,  266.4758,  239.8928,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    393.0249,  383.8010,  371.5028,  356.1095,  0.0000,    292.8589,  286.7436,
  278.5192,  268.1748,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  358.8167,  358.1870,  354.6423,  0.0000,    0.0000,    270.5526,  270.2783,  267.9569,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    318.9642,  322.0346,
  0.0000,    0.0000,    0.0000,    243.5475,  245.8435,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    282.2888,  0.0000,    0.0000,    0.0000,
  0.0000,    218.0929,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1533.4063, 461.7019,  0.0000,    0.0000,    0.0000,    983.5916,
  336.0821,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1335.7319, 1113.8541, 482.4149,  0.0000,    0.0000,    891.6885,  740.9872,  353.7227,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1141.4078,
  781.2881,  493.6053,  0.0000,    0.0000,    777.7070,  544.0661,  365.3990,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    466.8110,  0.0000,    0.0000,
  0.0000,    0.0000,    346.4374,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1172.9549, 452.0342,  0.0000,    0.0000,    0.0000,
  788.3761,  335.8606,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1120.9931, 442.5579,  0.0000,    0.0000,    0.0000,    756.1577,  328.8954,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1091.4214, 427.9630,  0.0000,    0.0000,    0.0000,    736.9509,  318.3642,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1064.3798, 431.9033,
  0.0000,    0.0000,    0.0000,    719.3118,  320.2684,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1040.3490, 422.1376,  0.0000,    0.0000,
  0.0000,    703.6592,  309.8959,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    793.8763,  435.0829,  0.0000,    0.0000,    0.0000,    548.9119,
  322.3728,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    935.7544,  407.2414,  0.0000,    0.0000,    0.0000,    625.2396,  302.5447,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    897.8373,
  417.6349,  0.0000,    0.0000,    0.0000,    602.1416,  308.4467,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    931.6793,  385.1327,  0.0000,
  0.0000,    0.0000,    633.5260,  286.8927,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    911.1707,  373.6528,  0.0000,    0.0000,    0.0000,
  619.9597,  278.6211,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    892.3516,  371.6376,  0.0000,    0.0000,    0.0000,    607.6633,  276.9038,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  882.9919,  392.8083,  0.0000,    0.0000,    0.0000,    600.7572,  291.4639,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    728.8926,  358.4393,
  0.0000,    0.0000,    0.0000,    503.3841,  267.4892,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    696.4283,  510.2862,  358.6850,  0.0000,
  0.0000,    491.2212,  366.9348,  269.5315,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    624.8408,  465.8069,  378.3878,  0.0000,    0.0000,    446.2955,
  339.1050,  282.2514,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    521.0822,  417.7679,  345.3340,  0.0000,    0.0000,    375.6084,  308.0717,  261.0312,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    526.4859,
  429.2869,  309.6449,  0.0000,    0.0000,    381.4584,  313.0042,  236.3389,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    470.2553,  361.1009,  288.2503,
  0.0000,    0.0000,    344.4429,  271.2314,  221.7642,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    425.6788,  337.8831,  298.5525,  0.0000,    0.0000,
  314.5325,  254.8568,  227.0659,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    349.5803,  321.7223,  314.1878,  0.0000,    0.0000,    260.5785,  243.2710,
  238.8650,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  325.1198,  307.9352,  0.0000,    0.0000,    0.0000,    243.2204,  232.6981,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    332.4340,  293.2422,
  0.0000,    0.0000,    0.0000,    249.8231,  224.0178,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    514.7803,  508.8879,  390.9435,  340.7523,
  0.0000,    369.7134,  367.7662,  291.3412,  258.0675,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    491.9976,  450.5486,  412.5016,  402.0369,  368.9934,  359.3822,
  332.6986,  307.7570,  301.3661,  279.2429,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    441.0551,  430.2160,  417.1999,  401.8607,  0.0000,    328.0961,  321.3335,  313.0213,
  303.0894,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    414.7869,
  413.9597,  411.1417,  0.0000,    0.0000,    311.7543,  311.6355,  310.0870,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    376.5450,  380.9995,  0.0000,
  0.0000,    0.0000,    286.4803,  289.9157,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    340.1029,  0.0000,    0.0000,    0.0000,    0.0000,
  261.5923,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1416.8737, 519.0234,  0.0000,    0.0000,    0.0000,    923.4448,  378.3131,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1302.2136, 1087.8878, 530.0149,  0.0000,    0.0000,    878.3888,  733.5428,  389.1542,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1121.7466, 535.1863,
  0.0000,    0.0000,    0.0000,    771.3710,  397.4563,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    979.1984,  634.3124,  0.0000,    0.0000,
  0.0000,    687.9851,  461.8329,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    986.8467,  562.9964,  0.0000,    0.0000,    0.0000,    685.7614,
  412.1000,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    954.8309,  487.0150,  0.0000,    0.0000,    0.0000,    663.9085,  362.3594,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1000.9549,
  466.5966,  0.0000,    0.0000,    0.0000,    686.9409,  348.3305,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    966.0599,  592.3705,  0.0000,
  0.0000,    0.0000,    664.6581,  424.8342,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    340.5213,  223.6622,  0.0000,    0.0000,    0.0000,
  223.6622,  153.4528,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    405.4565,  378.7329,  294.3129,  236.1661,  0.0000,    264.4724,  248.7003,
  197.8459,  162.4735,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  349.9885,  325.6928,  308.9517,  274.3339,  239.3959,  234.3407,  219.4508,  209.0707,  187.6481,
  165.9764,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    292.5030,  287.1778,
  279.0375,  267.9108,  0.0000,    200.6408,  197.2771,  192.1686,  185.2060,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    259.0459,  259.1916,  257.0583,  0.0000,
  0.0000,    180.4189,  180.4812,  179.0747,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    223.6348,  225.3457,  0.0000,    0.0000,    0.0000,    158.2213,
  159.3049,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    192.0484,  0.0000,    0.0000,    0.0000,    0.0000,    137.8590,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1186.2631,
  401.0548,  0.0000,    0.0000,    0.0000,    697.2012,  262.7332,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1009.6809, 822.5167,  407.9499,
  0.0000,    0.0000,    618.5928,  505.2608,  271.9818,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    870.6935,  609.0499,  387.0821,  0.0000,    0.0000,
  544.3140,  389.5811,  262.5735,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    774.5871,  438.4080,  388.7295,  0.0000,    0.0000,    490.5097,  292.4005,
  265.0402,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  701.3549,  442.9886,  376.2399,  0.0000,    0.0000,    448.0328,  295.2762,  256.2171,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    534.5207,  410.9866,
  328.4707,  0.0000,    0.0000,    346.8387,  275.6055,  227.0405,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    599.3141,  468.4529,  286.9927,  0.0000,
  0.0000,    386.6256,  307.8815,  200.7562,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    450.1543,  353.7880,  270.1794,  0.0000,    0.0000,    295.4307,
  240.9124,  189.8458,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    492.6319,  330.4713,  278.3620,  0.0000,    0.0000,    322.9831,  225.4398,  193.0221,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    454.8031,
  306.0633,  291.8725,  0.0000,    0.0000,    299.8317,  209.4546,  201.5508,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    379.5655,  296.6728,  0.0000,
  0.0000,    0.0000,    249.8348,  202.5685,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    398.4572,  290.7895,  0.0000,    0.0000,    0.0000,
  264.5716,  200.8224,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    507.2452,  480.5972,  378.4634,  316.5382,  0.0000,    330.9585,  315.9166,
  255.4101,  218.3027,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  461.1971,  427.1025,  411.3778,  366.5785,  327.8656,  307.2635,  286.9464,  277.6083,  250.5077,
  226.8951,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    403.8621,  394.8434,
  382.7819,  367.6637,  0.0000,    274.7816,  269.4208,  262.1684,  253.0149,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    370.5936,  370.0674,  366.6162,  0.0000,
  0.0000,    255.4289,  255.2713,  253.2520,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    331.0651,  334.2414,  0.0000,    0.0000,    0.0000,    231.4006,
  233.5632,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    294.2138,  0.0000,    0.0000,    0.0000,    0.0000,    208.4055,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1443.0004,
  467.8731,  0.0000,    0.0000,    0.0000,    849.3446,  311.5800,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1292.6630, 1072.0643, 491.2073,
  0.0000,    0.0000,    787.2771,  653.7336,  329.1343,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1118.3973, 772.6650,  505.5837,  0.0000,    0.0000,
  694.7959,  492.6342,  341.7316,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    478.3350,  0.0000,    0.0000,    0.0000,    0.0000,    324.3365,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1139.4352, 463.4148,  0.0000,    0.0000,    0.0000,    698.7243,  314.6193,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1091.5722, 453.7462,
  0.0000,    0.0000,    0.0000,    671.4732,  308.1251,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1063.4898, 438.9546,  0.0000,    0.0000,
  0.0000,    654.7776,  298.4106,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1037.7490, 442.2545,  0.0000,    0.0000,    0.0000,    639.4075,
  299.7092,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1014.8959, 429.9304,  0.0000,    0.0000,    0.0000,    625.7820,  288.4004,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    783.5114,
  445.4982,  0.0000,    0.0000,    0.0000,    494.4243,  301.5583,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    903.5991,  417.4763,  0.0000,
  0.0000,    0.0000,    552.5803,  283.3765,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    868.7577,  426.7546,  0.0000,    0.0000,    0.0000,
  533.3938,  288.0409,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    912.0082,  395.3654,  0.0000,    0.0000,    0.0000,    565.0858,  269.0965,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  892.3332,  383.7696,  0.0000,    0.0000,    0.0000,    553.1687,  261.4745,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    874.3961,  381.5809,
  0.0000,    0.0000,    0.0000,    542.4516,  259.7613,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    864.8546,  402.7269,  0.0000,    0.0000,
  0.0000,    536.0077,  272.8496,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    719.5241,  368.3520,  0.0000,    0.0000,    0.0000,    453.0762,
  251.1407,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    696.2135,  514.1902,  369.9201,  0.0000,    0.0000,    447.4432,  337.9629,  254.0293,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    628.6741,
  472.2547,  388.3794,  0.0000,    0.0000,    409.3369,  314.3617,  265.0166,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    525.8894,  426.2047,  356.5405,
  0.0000,    0.0000,    346.2360,  287.4876,  246.6960,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    532.9962,  435.3944,  320.8518,  0.0000,    0.0000,
  352.5888,  290.3345,  224.4227,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    478.5375,  371.6253,  299.5788,  0.0000,    0.0000,    320.1959,  255.4770,
  211.3939,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  434.8792,  348.2052,  308.4433,  0.0000,    0.0000,    293.7113,  240.5235,  215.1707,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    358.0126,  331.7749,
  324.8266,  0.0000,    0.0000,    244.3721,  229.8439,  226.3043,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    333.3177,  317.2387,  0.0000,    0.0000,
  0.0000,    228.4785,  219.7411,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    341.8710,  303.8144,  0.0000,    0.0000,    0.0000,    235.2469,
  212.7224,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    517.7713,  513.8120,  400.8646,  352.0729,  0.0000,    340.0661,  339.4098,  273.2506,
  244.0416,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    499.9322,
  460.2861,  423.5091,  413.7686,  381.4239,  333.5577,  310.5826,  288.8534,  283.5532,  264.0222,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    452.3678,  442.1285,  429.6851,
  414.9210,  0.0000,    307.4871,  301.7975,  294.6880,  286.1115,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    427.4616,  426.9611,  424.4352,  0.0000,    0.0000,
  293.7622,  293.9063,  292.7333,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    390.0545,  394.7360,  0.0000,    0.0000,    0.0000,    271.6352,  274.9260,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  353.7569,  0.0000,    0.0000,    0.0000,    0.0000,    249.3809,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1346.4975, 526.3991,
  0.0000,    0.0000,    0.0000,    804.9902,  350.9982,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1267.7966, 1055.8450, 540.0198,  0.0000,
  0.0000,    780.2675,  652.1404,  362.3948,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1104.9523, 548.6812,  0.0000,    0.0000,    0.0000,    692.6828,
  372.2513,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    975.8856,  642.8013,  0.0000,    0.0000,    0.0000,    625.2933,  428.1999,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    976.6865,
  571.3150,  0.0000,    0.0000,    0.0000,    619.4384,  383.2282,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    945.2775,  499.0319,  0.0000,
  0.0000,    0.0000,    599.8559,  339.6385,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    983.7215,  478.9052,  0.0000,    0.0000,    0.0000,
  615.9607,  327.0234,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    950.8603,  594.7593,  0.0000,    0.0000,    0.0000,    596.8169,  390.5948,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  483.7516,  451.4003,  349.5389,  279.4346,  0.0000,    451.4003,  421.6497,  327.6772,  262.9134,
  0.0000,    349.5389,  327.6772,  257.8727,  209.5130,  0.0000,    279.4346,  262.9134,  209.5130,
  172.3153,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    415.9530,  386.7129,
  366.5742,  324.9456,  282.9469,  389.7370,  362.6832,  344.0232,  305.4579,  266.5350,  306.0934,
  285.8049,  271.7272,  242.6615,  213.2887,  248.1866,  232.5085,  221.5612,  198.9801,  176.1294,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    346.3508,  339.9625,  330.1881,  316.8201,
  0.0000,    325.7268,  319.7871,  310.7110,  298.3060,  0.0000,    259.1650,  254.6359,  247.7421,
  238.3364,  0.0000,    212.8299,  209.2695,  203.8708,  196.5179,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    305.9501,  306.1275,  303.5764,  0.0000,    0.0000,    288.3934,
  288.5493,  286.1624,  0.0000,    0.0000,    231.3353,  231.4312,  229.5690,  0.0000,    0.0000,
  191.4849,  191.5424,  190.0442,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    263.3458,  265.3939,  0.0000,    0.0000,    0.0000,    248.8211,  250.7247,  0.0000,
  0.0000,    0.0000,    201.2706,  202.7225,  0.0000,    0.0000,    0.0000,    167.9500,  169.0925,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    225.4537,
  0.0000,    0.0000,    0.0000,    0.0000,    213.4821,  0.0000,    0.0000,    0.0000,    0.0000,
  174.0230,  0.0000,    0.0000,    0.0000,    0.0000,    146.2910,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1442.3807, 477.9737,  0.0000,
  0.0000,    0.0000,    1322.7322, 446.0798,  0.0000,    0.0000,    0.0000,    968.1682,  345.9921,
  0.0000,    0.0000,    0.0000,    727.9978,  277.1701,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1216.5138, 991.9123,  484.8813,  0.0000,    0.0000,
  1123.9167, 916.2312,  453.9182,  0.0000,    0.0000,    841.3610,  686.5985,  355.5621,  0.0000,
  0.0000,    649.2640,  530.2448,  287.6167,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1045.5505, 729.5813,  458.9033,  0.0000,    0.0000,    969.0777,  678.2590,
  430.7925,  0.0000,    0.0000,    733.3555,  519.4437,  340.6535,  0.0000,    0.0000,    572.5452,
  410.5273,  278.1125,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  928.1982,  521.1802,  460.4959,  0.0000,    0.0000,    862.0363,  487.8759,  432.6309,  0.0000,
  0.0000,    656.8592,  382.1952,  343.0520,  0.0000,    0.0000,    516.5656,  309.1964,  280.8241,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    839.2828,  526.4964,
  445.7279,  0.0000,    0.0000,    780.4805,  492.8316,  418.6209,  0.0000,    0.0000,    597.4745,
  385.9385,  331.6718,  0.0000,    0.0000,    472.1406,  312.1568,  271.3137,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    637.9233,  487.9858,  388.0446,  0.0000,
  0.0000,    594.5765,  457.1641,  365.2802,  0.0000,    0.0000,    458.8906,  359.1580,  291.7241,
  0.0000,    0.0000,    365.7390,  291.3944,  240.5109,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    715.9811,  558.1522,  338.2627,  0.0000,    0.0000,    666.7601,
  521.1441,  318.9968,  0.0000,    0.0000,    513.0410,  404.9175,  256.3933,  0.0000,    0.0000,
  407.5902,  324.9095,  212.6937,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    536.1093,  418.8573,  318.1224,  0.0000,    0.0000,    500.5162,  393.3571,  300.2053,
  0.0000,    0.0000,    388.6043,  311.5991,  241.8646,  0.0000,    0.0000,    311.6254,  254.8812,
  201.1040,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    586.7732,
  391.0508,  328.3978,  0.0000,    0.0000,    547.8346,  367.3197,  309.2352,  0.0000,    0.0000,
  425.2069,  291.2261,  247.3262,  0.0000,    0.0000,    340.8328,  238.4311,  204.2277,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    541.1501,  361.8780,  344.5686,
  0.0000,    0.0000,    505.6698,  340.0675,  324.2726,  0.0000,    0.0000,    393.6370,  270.0591,
  258.7879,  0.0000,    0.0000,    316.4721,  221.4649,  213.2345,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    451.5887,  350.8010,  0.0000,    0.0000,    0.0000,
  421.7420,  329.5387,  0.0000,    0.0000,    0.0000,    327.8852,  261.3654,  0.0000,    0.0000,
  0.0000,    263.3258,  214.0794,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    473.4203,  343.2943,  0.0000,    0.0000,    0.0000,    442.8639,  323.1080,
  0.0000,    0.0000,    0.0000,    346.0568,  257.9007,  0.0000,    0.0000,    0.0000,    279.2886,
  212.5148,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  604.7183,  572.2658,  448.7448,  373.9479,  0.0000,    564.1564,  534.5127,  420.8557,  351.9154,
  0.0000,    436.7407,  415.4641,  331.7913,  280.7261,  0.0000,    349.1330,  333.4815,  270.0988,
  231.1618,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    548.0549,  506.8838,
  487.8786,  433.8635,  387.2413,  513.0315,  475.1014,  457.6031,  407.7353,  364.6366,  401.7251,
  373.7047,  360.8017,  323.6722,  291.4396,  324.8229,  303.5179,  293.7290,  265.2550,  240.4178,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    478.3993,  467.5119,  452.9662,  434.7417,
  0.0000,    449.3006,  439.2692,  425.8475,  409.0175,  0.0000,    355.8474,  348.4425,  338.4772,
  325.9378,  0.0000,    290.9600,  285.3363,  277.7186,  268.0968,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    438.1102,  437.4417,  433.2665,  0.0000,    0.0000,    412.2793,
  411.7018,  407.8626,  0.0000,    0.0000,    328.8076,  328.4905,  325.6786,  0.0000,    0.0000,
  270.6774,  270.5297,  268.4136,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    390.4542,  394.2289,  0.0000,    0.0000,    0.0000,    368.2183,  371.7655,  0.0000,
  0.0000,    0.0000,    295.8817,  298.6948,  0.0000,    0.0000,    0.0000,    245.3469,  247.6485,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    346.1345,
  0.0000,    0.0000,    0.0000,    0.0000,    327.0838,  0.0000,    0.0000,    0.0000,    0.0000,
  264.7126,  0.0000,    0.0000,    0.0000,    0.0000,    221.0120,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1755.5105, 556.5016,  0.0000,
  0.0000,    0.0000,    1609.8951, 520.7490,  0.0000,    0.0000,    0.0000,    1179.2492, 407.5724,
  0.0000,    0.0000,    0.0000,    887.2092,  329.4410,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1559.7012, 1295.4563, 583.5203,  0.0000,    0.0000,
  1439.3610, 1194.8773, 546.6402,  0.0000,    0.0000,    1073.9458, 891.8106,  429.3221,  0.0000,
  0.0000,    825.7096,  685.5002,  348.1978,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1344.7968, 926.3723,  599.8301,  0.0000,    0.0000,    1245.0382, 860.6632,
  562.7686,  0.0000,    0.0000,    938.9286,  657.9651,  444.1573,  0.0000,    0.0000,    730.3259,
  518.9832,  361.9337,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  566.8783,  0.0000,    0.0000,    0.0000,    0.0000,    532.0683,  0.0000,    0.0000,    0.0000,
  0.0000,    420.5733,  0.0000,    0.0000,    0.0000,    0.0000,    343.2601,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1372.8649, 549.0692,
  0.0000,    0.0000,    0.0000,    1268.2581, 515.4512,  0.0000,    0.0000,    0.0000,    949.6978,
  407.7143,  0.0000,    0.0000,    0.0000,    733.0346,  332.9869,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1314.2306, 537.5790,  0.0000,    0.0000,
  0.0000,    1214.7867, 504.6830,  0.0000,    0.0000,    0.0000,    911.1851,  399.2448,  0.0000,
  0.0000,    0.0000,    704.6787,  326.1098,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1280.1762, 519.9536,  0.0000,    0.0000,    0.0000,    1183.4931,
  488.2162,  0.0000,    0.0000,    0.0000,    888.1417,  386.4453,  0.0000,    0.0000,    0.0000,
  687.2223,  315.8374,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1248.9915, 524.1676,  0.0000,    0.0000,    0.0000,    1154.8172, 491.9157,  0.0000,
  0.0000,    0.0000,    866.9787,  388.7055,  0.0000,    0.0000,    0.0000,    671.1482,  317.1445,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1221.3030,
  510.2157,  0.0000,    0.0000,    0.0000,    1129.3623, 478.0396,  0.0000,    0.0000,    0.0000,
  848.2084,  375.6249,  0.0000,    0.0000,    0.0000,    656.9043,  304.8174,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    939.3652,  528.1305,  0.0000,
  0.0000,    0.0000,    871.6966,  495.5668,  0.0000,    0.0000,    0.0000,    662.7701,  391.3632,
  0.0000,    0.0000,    0.0000,    520.0484,  319.1288,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1090.0939, 494.6170,  0.0000,    0.0000,    0.0000,
  1006.1273, 464.3202,  0.0000,    0.0000,    0.0000,    752.0406,  367.2307,  0.0000,    0.0000,
  0.0000,    579.2127,  299.8930,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1047.5640, 506.1315,  0.0000,    0.0000,    0.0000,    967.4193,  474.6781,
  0.0000,    0.0000,    0.0000,    724.6816,  374.2592,  0.0000,    0.0000,    0.0000,    559.3590,
  304.6980,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1096.4450, 468.2277,  0.0000,    0.0000,    0.0000,    1014.7443, 439.7399,  0.0000,    0.0000,
  0.0000,    764.1475,  348.3079,  0.0000,    0.0000,    0.0000,    593.5044,  284.8492,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1072.6768, 454.4189,
  0.0000,    0.0000,    0.0000,    992.8398,  426.8411,  0.0000,    0.0000,    0.0000,    747.8611,
  338.2814,  0.0000,    0.0000,    0.0000,    581.0286,  276.8003,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1050.9705, 451.9002,  0.0000,    0.0000,
  0.0000,    972.8753,  424.4203,  0.0000,    0.0000,    0.0000,    733.1234,  336.2103,  0.0000,
  0.0000,    0.0000,    569.8286,  274.9818,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1039.6601, 477.3755,  0.0000,    0.0000,    0.0000,    962.2681,
  448.0328,  0.0000,    0.0000,    0.0000,    724.7596,  354.0246,  0.0000,    0.0000,    0.0000,
  563.0164,  288.8264,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    862.9139,  436.1455,  0.0000,    0.0000,    0.0000,    800.5607,  409.7279,  0.0000,
  0.0000,    0.0000,    608.0882,  324.8481,  0.0000,    0.0000,    0.0000,    476.5767,  265.9055,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    832.3249,
  612.8702,  437.6841,  0.0000,    0.0000,    774.7949,  572.3227,  411.6506,  0.0000,    0.0000,
  595.0976,  444.8023,  327.6728,  0.0000,    0.0000,    471.8684,  356.9509,  269.2401,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    749.9776,  561.6079,  459.9876,
  0.0000,    0.0000,    699.5482,  525.5040,  432.1249,  0.0000,    0.0000,    541.0622,  411.2050,
  342.7253,  0.0000,    0.0000,    432.1085,  332.2796,  280.6384,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    626.2203,  505.6085,  421.1500,  0.0000,    0.0000,
  585.0069,  474.0968,  396.5106,  0.0000,    0.0000,    455.0721,  373.6329,  316.8461,  0.0000,
  0.0000,    365.5874,  304.0791,  261.3625,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    634.1662,  517.4305,  378.2013,  0.0000,    0.0000,    592.9066,  484.2884,
  356.6594,  0.0000,    0.0000,    462.4347,  379.2820,  286.6562,  0.0000,    0.0000,    372.4726,
  306.7759,  237.7889,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  568.2251,  439.3263,  352.5240,  0.0000,    0.0000,    532.1950,  413.1839,  332.8931,  0.0000,
  0.0000,    417.6290,  328.9919,  268.8209,  0.0000,    0.0000,    338.4524,  270.4501,  224.0048,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    515.5051,  411.1836,
  363.5410,  0.0000,    0.0000,    483.5090,  386.9891,  342.6407,  0.0000,    0.0000,    381.3209,
  308.9063,  274.9323,  0.0000,    0.0000,    310.5641,  254.5731,  227.7320,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    423.4292,  391.4844,  382.9350,  0.0000,
  0.0000,    397.7391,  368.6028,  360.8797,  0.0000,    0.0000,    315.4011,  294.6746,  289.3931,
  0.0000,    0.0000,    258.2995,  243.2102,  239.5577,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    393.8227,  374.2118,  0.0000,    0.0000,    0.0000,    370.1517,
  352.3067,  0.0000,    0.0000,    0.0000,    294.1677,  281.5915,  0.0000,    0.0000,    0.0000,
  241.4385,  232.3862,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    403.7059,  357.7557,  0.0000,    0.0000,    0.0000,    379.7092,  337.4141,  0.0000,
  0.0000,    0.0000,    302.4340,  271.3018,  0.0000,    0.0000,    0.0000,    248.7334,  225.1561,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    616.5392,
  611.2503,  474.3655,  415.4361,  0.0000,    575.6281,  571.2540,  445.5426,  391.2329,  0.0000,
  447.0673,  445.0912,  353.1112,  312.9041,  0.0000,    358.6139,  358.1693,  288.9768,  258.3342,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    593.7385,  545.6804,  501.2103,
  489.3247,  450.3239,  555.8307,  511.7453,  470.8344,  460.0238,  424.0264,  435.4792,  403.3930,
  373.3126,  365.6931,  338.9165,  352.3614,  328.3665,  305.6116,  300.1272,  279.6136,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    535.7013,  523.2478,  508.1567,  490.2801,  0.0000,
  502.9885,  491.6232,  477.7997,  461.3882,  0.0000,    398.0929,  389.9930,  380.0003,  368.0353,
  0.0000,    325.3228,  319.4128,  311.9993,  303.0357,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    505.3600,  504.6627,  501.5441,  0.0000,    0.0000,    475.3134,  474.7845,
  471.9957,  0.0000,    0.0000,    378.4324,  378.3575,  376.5335,  0.0000,    0.0000,    311.0434,
  311.2526,  310.0655,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  460.1323,  465.6773,  0.0000,    0.0000,    0.0000,    433.6625,  438.9000,  0.0000,    0.0000,
  0.0000,    347.7513,  351.9782,  0.0000,    0.0000,    0.0000,    287.8055,  291.3213,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    416.4072,  0.0000,
  0.0000,    0.0000,    0.0000,    393.1850,  0.0000,    0.0000,    0.0000,    0.0000,    317.3656,
  0.0000,    0.0000,    0.0000,    0.0000,    264.3147,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1633.0869, 626.0266,  0.0000,    0.0000,
  0.0000,    1501.4541, 585.9332,  0.0000,    0.0000,    0.0000,    1108.8359, 458.9149,  0.0000,
  0.0000,    0.0000,    842.2997,  371.1959,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1527.0149, 1272.6682, 641.4292,  0.0000,    0.0000,    1411.5217,
  1176.3896, 601.0295,  0.0000,    0.0000,    1059.0662, 884.0411,  472.4317,  0.0000,    0.0000,
  819.2669,  684.7717,  383.4740,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1326.3601, 650.2347,  0.0000,    0.0000,    0.0000,    1229.7307, 610.3734,  0.0000,
  0.0000,    0.0000,    931.8768,  482.6357,  0.0000,    0.0000,    0.0000,    728.5862,  394.0391,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1167.0583,
  764.3388,  0.0000,    0.0000,    0.0000,    1085.7394, 715.2085,  0.0000,    0.0000,    0.0000,
  832.4224,  559.8251,  0.0000,    0.0000,    0.0000,    658.8710,  452.4786,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1169.9494, 678.7016,  0.0000,
  0.0000,    0.0000,    1086.5380, 635.6287,  0.0000,    0.0000,    0.0000,    828.3485,  499.3495,
  0.0000,    0.0000,    0.0000,    651.8259,  404.9924,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1132.1107, 590.8461,  0.0000,    0.0000,    0.0000,
  1051.4942, 554.8107,  0.0000,    0.0000,    0.0000,    801.8639,  439.3548,  0.0000,    0.0000,
  0.0000,    631.1928,  359.2625,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1180.4499, 566.6240,  0.0000,    0.0000,    0.0000,    1094.1031, 532.3546,
  0.0000,    0.0000,    0.0000,    828.3682,  422.3312,  0.0000,    0.0000,    0.0000,    647.1553,
  345.9563,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1140.5197, 708.5363,  0.0000,    0.0000,    0.0000,    1057.5095, 661.3852,  0.0000,    0.0000,
  0.0000,    801.7037,  513.5961,  0.0000,    0.0000,    0.0000,    627.1891,  411.8656,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    363.5474,  339.2404,
  322.3974,  287.6103,  252.4591,  339.2404,  316.8521,  301.3102,  269.2215,  236.7867,  322.3974,
  301.3102,  286.6545,  256.4009,  225.8139,  287.6103,  269.2215,  256.4009,  229.9498,  203.1922,
  252.4591,  236.7867,  225.8139,  203.1922,  180.2912,  307.1010,  301.6800,  293.4322,  282.1828,
  0.0000,    287.5847,  282.5717,  274.9497,  264.5566,  0.0000,    273.9655,  269.2308,  262.0354,
  252.2261,  0.0000,    245.8719,  241.7135,  235.4019,  226.8019,  0.0000,    217.4476,  213.8707,
  208.4500,  201.0683,  0.0000,    273.6530,  273.7680,  271.5474,  0.0000,    0.0000,    256.8517,
  256.9523,  254.8857,  0.0000,    0.0000,    245.0690,  245.1604,  243.2002,  0.0000,    0.0000,
  220.7846,  220.8565,  219.1161,  0.0000,    0.0000,    196.1962,  196.2489,  194.7306,  0.0000,
  0.0000,    237.6295,  239.3636,  0.0000,    0.0000,    0.0000,    223.5744,  225.1792,  0.0000,
  0.0000,    0.0000,    213.6651,  215.1816,  0.0000,    0.0000,    0.0000,    193.2591,  194.5928,
  0.0000,    0.0000,    0.0000,    172.5823,  173.7316,  0.0000,    0.0000,    0.0000,    205.0598,
  0.0000,    0.0000,    0.0000,    0.0000,    193.3634,  0.0000,    0.0000,    0.0000,    0.0000,
  185.0751,  0.0000,    0.0000,    0.0000,    0.0000,    168.0194,  0.0000,    0.0000,    0.0000,
  0.0000,    150.7260,  0.0000,    0.0000,    0.0000,    0.0000,    1155.1526, 411.0389,  0.0000,
  0.0000,    0.0000,    1059.6044, 382.5012,  0.0000,    0.0000,    0.0000,    994.2046,  362.8020,
  0.0000,    0.0000,    0.0000,    859.6583,  322.1096,  0.0000,    0.0000,    0.0000,    724.9394,
  281.0734,  0.0000,    0.0000,    0.0000,    1004.4824, 818.4887,  422.1813,  0.0000,    0.0000,
  926.0025,  755.0584,  393.7660,  0.0000,    0.0000,    872.4465,  711.5862,  374.0975,  0.0000,
  0.0000,    761.7364,  621.9263,  333.4648,  0.0000,    0.0000,    650.4849,  531.8762,  292.4289,
  0.0000,    0.0000,    874.7836,  617.9985,  403.9646,  0.0000,    0.0000,    808.5991,  573.2139,
  377.6930,  0.0000,    0.0000,    763.3410,  542.3655,  359.4274,  0.0000,    0.0000,    669.7473,
  478.7132,  321.7190,  0.0000,    0.0000,    575.5731,  414.6203,  283.5949,  0.0000,    0.0000,
  782.9442,  453.6905,  406.6196,  0.0000,    0.0000,    724.9805,  423.2076,  380.4575,  0.0000,
  0.0000,    685.2716,  402.0877,  362.2407,  0.0000,    0.0000,    603.1519,  358.4772,  324.6431,
  0.0000,    0.0000,    520.4592,  314.4398,  286.6200,  0.0000,    0.0000,    711.6823,  458.1920,
  393.0366,  0.0000,    0.0000,    659.8039,  427.3622,  367.7137,  0.0000,    0.0000,    624.2061,
  406.0194,  350.0801,  0.0000,    0.0000,    550.6011,  361.9295,  313.6909,  0.0000,    0.0000,
  476.4489,  317.4077,  276.8993,  0.0000,    0.0000,    545.7845,  426.0703,  345.1578,  0.0000,
  0.0000,    507.1503,  397.7592,  323.6293,  0.0000,    0.0000,    480.5552,  378.1231,  308.5781,
  0.0000,    0.0000,    425.5849,  337.5775,  277.5321,  0.0000,    0.0000,    370.1677,  296.6250,
  246.1182,  0.0000,    0.0000,    610.5327,  480.8926,  302.9389,  0.0000,    0.0000,    566.8294,
  447.7131,  284.5505,  0.0000,    0.0000,    536.7795,  424.7791,  271.6474,  0.0000,    0.0000,
  474.6638,  377.4276,  245.0471,  0.0000,    0.0000,    412.0594,  329.6696,  218.1156,  0.0000,
  0.0000,    461.6795,  369.1734,  285.6102,  0.0000,    0.0000,    429.6996,  345.3872,  268.4538,
  0.0000,    0.0000,    407.6339,  328.8341,  256.3994,  0.0000,    0.0000,    362.0366,  294.6634,
  231.5527,  0.0000,    0.0000,    316.0442,  260.1176,  206.3914,  0.0000,    0.0000,    505.4452,
  344.9100,  292.3920,  0.0000,    0.0000,    470.3078,  322.7816,  274.2990,  0.0000,    0.0000,
  446.0876,  307.3740,  261.6413,  0.0000,    0.0000,    396.0183,  275.5707,  235.5323,  0.0000,
  0.0000,    345.5051,  243.4182,  209.1152,  0.0000,    0.0000,    467.7042,  319.6946,  306.1192,
  0.0000,    0.0000,    435.5268,  299.3280,  286.9870,  0.0000,    0.0000,    413.3244,  285.1360,
  273.6234,  0.0000,    0.0000,    367.4287,  255.8441,  246.0490,  0.0000,    0.0000,    321.1117,
  226.2274,  218.1530,  0.0000,    0.0000,    389.3075,  309.4543,  0.0000,    0.0000,    0.0000,
  362.5076,  289.6411,  0.0000,    0.0000,    0.0000,    344.0065,  275.8484,  0.0000,    0.0000,
  0.0000,    305.7755,  247.3728,  0.0000,    0.0000,    0.0000,    267.2135,  218.5854,  0.0000,
  0.0000,    0.0000,    410.9058,  305.1468,  0.0000,    0.0000,    0.0000,    383.0204,  286.0551,
  0.0000,    0.0000,    0.0000,    363.7536,  272.7228,  0.0000,    0.0000,    0.0000,    323.9292,
  245.2119,  0.0000,    0.0000,    0.0000,    283.7237,  217.3760,  0.0000,    0.0000,    0.0000,
  519.3501,  493.7984,  393.4823,  332.2932,  0.0000,    482.9115,  459.6285,  367.6282,  311.4260,
  0.0000,    457.8119,  436.0573,  349.6800,  296.8562,  0.0000,    405.9303,  387.3404,  312.6183,
  266.7944,  0.0000,    353.6035,  338.1831,  275.1658,  236.3761,  0.0000,    477.1034,  443.4892,
  428.0103,  383.5189,  344.9065,  444.9048,  414.0613,  399.8646,  358.9520,  323.4073,  422.6322,
  393.6595,  380.3291,  341.8407,  308.3757,  376.6108,  351.5201,  339.9859,  306.5241,  277.3717,
  330.1301,  308.9411,  299.2117,  270.8052,  245.9922,  421.8616,  412.9661,  401.0098,  385.9785,
  0.0000,    394.5822,  386.4260,  375.4438,  361.6218,  0.0000,    375.6047,  367.9463,  357.6221,
  344.6189,  0.0000,    336.4289,  329.8047,  320.8460,  309.5410,  0.0000,    296.8145,  291.2302,
  283.6451,  274.0484,  0.0000,    389.2997,  388.8946,  385.5109,  0.0000,    0.0000,    364.8243,
  364.4882,  361.3931,  0.0000,    0.0000,    347.7286,  347.4358,  344.5346,  0.0000,    0.0000,
  312.4631,  312.2619,  309.7636,  0.0000,    0.0000,    276.7786,  276.6685,  274.5751,  0.0000,
  0.0000,    349.7760,  353.1156,  0.0000,    0.0000,    0.0000,    328.4750,  331.5987,  0.0000,
  0.0000,    0.0000,    313.5280,  316.5011,  0.0000,    0.0000,    0.0000,    282.7195,  285.3820,
  0.0000,    0.0000,    0.0000,    251.5229,  253.8712,  0.0000,    0.0000,    0.0000,    312.4265,
  0.0000,    0.0000,    0.0000,    0.0000,    293.9966,  0.0000,    0.0000,    0.0000,    0.0000,
  281.0046,  0.0000,    0.0000,    0.0000,    0.0000,    254.2458,  0.0000,    0.0000,    0.0000,
  0.0000,    227.1324,  0.0000,    0.0000,    0.0000,    0.0000,    1406.2206, 483.7117,  0.0000,
  0.0000,    0.0000,    1290.3249, 451.1717,  0.0000,    0.0000,    0.0000,    1210.8497, 428.6170,
  0.0000,    0.0000,    0.0000,    1047.5077, 382.0562,  0.0000,    0.0000,    0.0000,    883.9799,
  335.0524,  0.0000,    0.0000,    0.0000,    1281.9152, 1062.7315, 509.4520,  0.0000,    0.0000,
  1180.9729, 979.5742,  475.5382,  0.0000,    0.0000,    1112.0376, 922.5046,  452.0196,  0.0000,
  0.0000,    969.6559,  804.9599,  403.4560,  0.0000,    0.0000,    826.6644,  686.9957,  354.4023,
  0.0000,    0.0000,    1120.0021, 782.7401,  526.8660,  0.0000,    0.0000,    1034.4900, 725.7474,
  492.3604,  0.0000,    0.0000,    976.0066,  686.4772,  468.3886,  0.0000,    0.0000,    855.1298,
  605.4842,  418.8957,  0.0000,    0.0000,    733.5714,  523.9575,  368.8682,  0.0000,    0.0000,
  498.6284,  0.0000,    0.0000,    0.0000,    0.0000,    466.1880,  0.0000,    0.0000,    0.0000,
  0.0000,    443.6388,  0.0000,    0.0000,    0.0000,    0.0000,    397.0824,  0.0000,    0.0000,
  0.0000,    0.0000,    350.0197,  0.0000,    0.0000,    0.0000,    0.0000,    1133.1627, 483.3174,
  0.0000,    0.0000,    0.0000,    1044.8624, 451.9571,  0.0000,    0.0000,    0.0000,    984.5356,
  430.1513,  0.0000,    0.0000,    0.0000,    859.9043,  385.1320,  0.0000,    0.0000,    0.0000,
  734.6883,  339.6203,  0.0000,    0.0000,    0.0000,    1087.2533, 473.2673,  0.0000,    0.0000,
  0.0000,    1002.9138, 442.5728,  0.0000,    0.0000,    0.0000,    945.3065,  421.2295,  0.0000,
  0.0000,    0.0000,    826.2471,  377.1647,  0.0000,    0.0000,    0.0000,    706.5967,  332.6173,
  0.0000,    0.0000,    0.0000,    1059.7536, 458.0385,  0.0000,    0.0000,    0.0000,    977.6523,
  428.4016,  0.0000,    0.0000,    0.0000,    921.5753,  407.7871,  0.0000,    0.0000,    0.0000,
  805.6691,  365.2295,  0.0000,    0.0000,    0.0000,    689.1790,  322.2035,  0.0000,    0.0000,
  0.0000,    1034.5024, 460.8179,  0.0000,    0.0000,    0.0000,    954.4431,  430.8119,  0.0000,
  0.0000,    0.0000,    899.7622,  409.9536,  0.0000,    0.0000,    0.0000,    786.7340,  366.8929,
  0.0000,    0.0000,    0.0000,    673.1287,  323.3676,  0.0000,    0.0000,    0.0000,    1012.1053,
  445.6375,  0.0000,    0.0000,    0.0000,    933.8615,  416.0190,  0.0000,    0.0000,    0.0000,
  880.4215,  395.4915,  0.0000,    0.0000,    0.0000,    769.9512,  353.0881,  0.0000,    0.0000,
  0.0000,    658.9099,  310.2550,  0.0000,    0.0000,    0.0000,    789.6369,  464.0671,  0.0000,
  0.0000,    0.0000,    730.9227,  433.7675,  0.0000,    0.0000,    0.0000,    690.6823,  412.7144,
  0.0000,    0.0000,    0.0000,    607.5073,  369.2466,  0.0000,    0.0000,    0.0000,    523.7968,
  325.3103,  0.0000,    0.0000,    0.0000,    896.4651,  435.3339,  0.0000,    0.0000,    0.0000,
  826.5104,  407.0718,  0.0000,    0.0000,    0.0000,    778.5964,  387.4235,  0.0000,    0.0000,
  0.0000,    679.7752,  346.8564,  0.0000,    0.0000,    0.0000,    580.5610,  305.8457,  0.0000,
  0.0000,    0.0000,    863.5860,  443.8226,  0.0000,    0.0000,    0.0000,    796.6299,  414.6873,
  0.0000,    0.0000,    0.0000,    750.7323,  394.4535,  0.0000,    0.0000,    0.0000,    656.0889,
  352.6781,  0.0000,    0.0000,    0.0000,    561.0491,  310.4631,  0.0000,    0.0000,    0.0000,
  911.7223,  412.8162,  0.0000,    0.0000,    0.0000,    841.7526,  386.1634,  0.0000,    0.0000,
  0.0000,    793.9592,  367.6206,  0.0000,    0.0000,    0.0000,    695.1305,  329.3403,  0.0000,
  0.0000,    0.0000,    595.7532,  290.6346,  0.0000,    0.0000,    0.0000,    892.3017,  400.8971,
  0.0000,    0.0000,    0.0000,    823.8687,  375.0691,  0.0000,    0.0000,    0.0000,    777.1265,
  357.0949,  0.0000,    0.0000,    0.0000,    680.4664,  319.9904,  0.0000,    0.0000,    0.0000,
  583.2649,  282.4712,  0.0000,    0.0000,    0.0000,    874.7132,  398.4787,  0.0000,    0.0000,
  0.0000,    807.7031,  372.7595,  0.0000,    0.0000,    0.0000,    761.9321,  354.8650,  0.0000,
  0.0000,    0.0000,    667.2758,  317.9241,  0.0000,    0.0000,    0.0000,    572.0834,  280.5719,
  0.0000,    0.0000,    0.0000,    864.7996,  419.8297,  0.0000,    0.0000,    0.0000,    798.4380,
  392.4501,  0.0000,    0.0000,    0.0000,    753.1172,  373.4254,  0.0000,    0.0000,    0.0000,
  659.3910,  334.1439,  0.0000,    0.0000,    0.0000,    565.1383,  294.4333,  0.0000,    0.0000,
  0.0000,    724.7513,  384.9740,  0.0000,    0.0000,    0.0000,    670.6097,  360.2034,  0.0000,
  0.0000,    0.0000,    633.5308,  342.9616,  0.0000,    0.0000,    0.0000,    556.8769,  307.3705,
  0.0000,    0.0000,    0.0000,    479.7277,  271.3793,  0.0000,    0.0000,    0.0000,    708.6971,
  528.4721,  388.1085,  0.0000,    0.0000,    657.5565,  491.9738,  363.5188,  0.0000,    0.0000,
  622.4382,  466.7476,  346.3606,  0.0000,    0.0000,    549.8188,  414.6636,  310.9606,  0.0000,
  0.0000,    476.6268,  362.1217,  275.1466,  0.0000,    0.0000,    643.7301,  488.0790,  406.0097,
  0.0000,    0.0000,    598.3678,  455.1833,  379.9737,  0.0000,    0.0000,    567.1420,  432.3917,
  361.8268,  0.0000,    0.0000,    502.5834,  385.3383,  324.3889,  0.0000,    0.0000,    437.4673,
  337.8356,  286.5355,  0.0000,    0.0000,    540.6984,  442.9999,  374.8540,  0.0000,    0.0000,
  503.4431,  413.9172,  351.5243,  0.0000,    0.0000,    477.7197,  393.7121,  335.2083,  0.0000,
  0.0000,    424.5693,  352.0045,  301.5558,  0.0000,    0.0000,    370.9397,  309.8655,  267.5021,
  0.0000,    0.0000,    549.3281,  450.0785,  338.7095,  0.0000,    0.0000,    511.7975,  419.8502,
  318.1449,  0.0000,    0.0000,    485.8648,  398.9067,  303.7145,  0.0000,    0.0000,    432.2812,
  355.6606,  273.9661,  0.0000,    0.0000,    378.1949,  311.9987,  243.8471,  0.0000,    0.0000,
  495.6146,  389.4139,  317.3118,  0.0000,    0.0000,    462.5042,  364.8336,  298.4387,  0.0000,
  0.0000,    439.5686,  347.6776,  285.1573,  0.0000,    0.0000,    392.1894,  312.2814,  257.7898,
  0.0000,    0.0000,    344.3352,  276.4784,  230.0687,  0.0000,    0.0000,    452.1256,  365.4201,
  324.8101,  0.0000,    0.0000,    422.4876,  342.5994,  304.9894,  0.0000,    0.0000,    401.9118,
  326.6525,  291.0937,  0.0000,    0.0000,    359.4184,  293.7540,  262.4425,  0.0000,    0.0000,
  316.4776,  260.4704,  233.4445,  0.0000,    0.0000,    373.4298,  348.4417,  342.0210,  0.0000,
  0.0000,    349.5160,  326.8247,  321.0664,  0.0000,    0.0000,    332.8663,  311.7083,  306.3878,
  0.0000,    0.0000,    298.4947,  280.5244,  276.1151,  0.0000,    0.0000,    263.7482,  248.9720,
  245.4740,  0.0000,    0.0000,    348.0922,  332.9066,  0.0000,    0.0000,    0.0000,    326.0072,
  312.2554,  0.0000,    0.0000,    0.0000,    310.6148,  297.8170,  0.0000,    0.0000,    0.0000,
  278.8419,  268.0292,  0.0000,    0.0000,    0.0000,    246.7174,  237.8926,  0.0000,    0.0000,
  0.0000,    357.8455,  320.4732,  0.0000,    0.0000,    0.0000,    335.3045,  301.0502,  0.0000,
  0.0000,    0.0000,    319.5808,  287.4267,  0.0000,    0.0000,    0.0000,    287.1270,  259.3347,
  0.0000,    0.0000,    0.0000,    254.3020,  230.8926,  0.0000,    0.0000,    0.0000,    531.0148,
  528.5509,  418.2800,  370.0955,  0.0000,    494.2934,  492.3727,  391.3814,  347.1306,  0.0000,
  468.9426,  467.3755,  372.6603,  331.0729,  0.0000,    416.5710,  415.7313,  334.0141,  297.9467,
  0.0000,    363.7480,  363.6185,  294.9427,  264.4224,  0.0000,    516.8932,  478.3664,  442.2805,
  433.0951,  401.0046,  482.1548,  446.9327,  413.8552,  405.5330,  376.0319,  458.1125,  425.1158,
  394.0690,  386.3229,  358.5747,  408.4395,  380.0597,  353.2253,  346.6758,  322.5630,  358.2779,
  334.5302,  311.9266,  306.5747,  286.1179,  471.8376,  462.0716,  450.0464,  435.6660,  0.0000,
  441.2868,  432.4153,  421.4482,  408.3015,  0.0000,    420.0429,  411.7682,  401.5098,  389.1922,
  0.0000,    376.1815,  369.1481,  360.3629,  349.7673,  0.0000,    331.8378,  326.0484,  318.7416,
  309.8748,  0.0000,    448.0822,  447.9342,  445.7000,  0.0000,    0.0000,    419.7407,  419.7026,
  417.7268,  0.0000,    0.0000,    399.9679,  399.9956,  398.1877,  0.0000,    0.0000,    359.1675,
  359.3358,  357.8794,  0.0000,    0.0000,    317.8930,  318.1991,  317.0936,  0.0000,    0.0000,
  411.1914,  416.1967,  0.0000,    0.0000,    0.0000,    385.9419,  390.6452,  0.0000,    0.0000,
  0.0000,    368.2512,  372.7413,  0.0000,    0.0000,    0.0000,    331.7744,  335.8263,  0.0000,
  0.0000,    0.0000,    294.8476,  298.4552,  0.0000,    0.0000,    0.0000,    374.7378,  0.0000,
  0.0000,    0.0000,    0.0000,    352.3749,  0.0000,    0.0000,    0.0000,    0.0000,    336.6417,
  0.0000,    0.0000,    0.0000,    0.0000,    304.2237,  0.0000,    0.0000,    0.0000,    0.0000,
  271.3855,  0.0000,    0.0000,    0.0000,    0.0000,    1321.9669, 544.6178,  0.0000,    0.0000,
  0.0000,    1215.4454, 508.0674,  0.0000,    0.0000,    0.0000,    1142.3947, 482.7248,  0.0000,
  0.0000,    0.0000,    992.0874,  430.4116,  0.0000,    0.0000,    0.0000,    841.4502,  377.5956,
  0.0000,    0.0000,    0.0000,    1263.5730, 1053.2146, 560.5331,  0.0000,    0.0000,    1165.7107,
  972.4069,  523.3404,  0.0000,    0.0000,    1098.8136, 916.9315,  497.5333,  0.0000,    0.0000,
  960.6062,  802.5738,  444.2516,  0.0000,    0.0000,    821.7173,  687.7017,  390.4281,  0.0000,
  0.0000,    1111.0958, 572.2109,  0.0000,    0.0000,    0.0000,    1027.4859, 535.0233,  0.0000,
  0.0000,    0.0000,    970.2576,  509.1698,  0.0000,    0.0000,    0.0000,    851.9462,  455.7931,
  0.0000,    0.0000,    0.0000,    732.8985,  401.8327,  0.0000,    0.0000,    0.0000,    991.2015,
  664.3007,  0.0000,    0.0000,    0.0000,    919.3517,  619.6074,  0.0000,    0.0000,    0.0000,
  870.0209,  588.6206,  0.0000,    0.0000,    0.0000,    768.0267,  524.6709,  0.0000,    0.0000,
  0.0000,    665.2638,  460.1149,  0.0000,    0.0000,    0.0000,    986.6400,  591.9079,  0.0000,
  0.0000,    0.0000,    913.9023,  552.6796,  0.0000,    0.0000,    0.0000,    864.0175,  525.4062,
  0.0000,    0.0000,    0.0000,    760.9024,  469.1695,  0.0000,    0.0000,    0.0000,    657.0913,
  412.3899,  0.0000,    0.0000,    0.0000,    955.0607,  520.5268,  0.0000,    0.0000,    0.0000,
  884.7153,  486.9543,  0.0000,    0.0000,    0.0000,    836.4744,  463.5903,  0.0000,    0.0000,
  0.0000,    736.7486,  415.3637,  0.0000,    0.0000,    0.0000,    636.3459,  366.6111,  0.0000,
  0.0000,    0.0000,    987.3751,  500.2256,  0.0000,    0.0000,    0.0000,    912.9705,  468.1789,
  0.0000,    0.0000,    0.0000,    862.0587,  445.8627,  0.0000,    0.0000,    0.0000,    756.7971,
  399.7983,  0.0000,    0.0000,    0.0000,    650.9057,  353.2213,  0.0000,    0.0000,    0.0000,
  955.5039,  609.7912,  0.0000,    0.0000,    0.0000,    883.7780,  567.6729,  0.0000,    0.0000,
  0.0000,    834.6893,  538.5580,  0.0000,    0.0000,    0.0000,    733.1891,  478.4556,  0.0000,
  0.0000,    0.0000,    631.0647,  417.8488,  0.0000,    0.0000,    0.0000,    262.9498,  258.5263,
  251.8155,  242.6736,  0.0000,    258.5263,  254.1924,  247.6174,  238.6601,  0.0000,    251.8155,
  247.6174,  241.2494,  232.5744,  0.0000,    242.6736,  238.6601,  232.5744,  224.2851,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    236.3473,  236.4206,  234.5631,  0.0000,
  0.0000,    232.5072,  232.5784,  230.7558,  0.0000,    0.0000,    226.6845,  226.7519,  224.9818,
  0.0000,    0.0000,    218.7531,  218.8149,  217.1161,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    207.0772,  208.4957,  0.0000,    0.0000,    0.0000,    203.8400,
  205.2305,  0.0000,    0.0000,    0.0000,    198.9308,  200.2786,  0.0000,    0.0000,    0.0000,
  192.2421,  193.5315,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    180.1818,  0.0000,    0.0000,    0.0000,    0.0000,    177.4716,  0.0000,    0.0000,
  0.0000,    0.0000,    173.3582,  0.0000,    0.0000,    0.0000,    0.0000,    167.7505,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    909.4257,
  343.3978,  0.0000,    0.0000,    0.0000,    890.4931,  337.2160,  0.0000,    0.0000,    0.0000,
  860.3672,  327.7032,  0.0000,    0.0000,    0.0000,    818.2247,  314.6518,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    808.3370,  660.0928,  355.9394,
  0.0000,    0.0000,    792.0816,  647.0220,  349.6598,  0.0000,    0.0000,    766.7421,  626.5605,
  340.0688,  0.0000,    0.0000,    731.7462,  598.2102,  326.9624,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    711.7506,  509.5503,  343.7975,  0.0000,    0.0000,
  697.8037,  500.0071,  337.9057,  0.0000,    0.0000,    676.2036,  485.2461,  328.9431,  0.0000,
  0.0000,    646.4774,  464.9254,  316.7189,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    641.5564,  382.6458,  347.0371,  0.0000,    0.0000,    629.2190,  375.9179,
  341.1482,  0.0000,    0.0000,    610.1761,  365.6312,  332.1968,  0.0000,    0.0000,    584.0160,
  351.5641,  319.9916,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  586.0084,  386.3091,  335.2921,  0.0000,    0.0000,    574.9009,  379.5097,  329.6139,  0.0000,
  0.0000,    557.7850,  369.1125,  320.9667,  0.0000,    0.0000,    534.2915,  354.8970,  309.1643,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    453.4186,  360.4496,
  296.9165,  0.0000,    0.0000,    445.0799,  354.1868,  292.0475,  0.0000,    0.0000,    432.2496,
  344.6133,  284.6411,  0.0000,    0.0000,    414.6509,  331.5230,  274.5376,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    505.5091,  402.4540,  262.3480,  0.0000,
  0.0000,    496.1023,  395.2472,  258.1617,  0.0000,    0.0000,    481.6229,  384.1644,  251.7973,
  0.0000,    0.0000,    461.7577,  368.9607,  243.1165,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    385.9883,  314.9253,  247.9607,  0.0000,    0.0000,    379.0427,
  309.6035,  244.0467,  0.0000,    0.0000,    368.3695,  301.4924,  238.0966,  0.0000,    0.0000,
  353.7383,  290.4181,  229.9806,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    422.1971,  294.5421,  252.0000,  0.0000,    0.0000,    414.5411,  289.5934,  247.9167,
  0.0000,    0.0000,    402.8017,  282.0464,  241.6956,  0.0000,    0.0000,    386.7290,  271.7387,
  233.2016,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    391.8528,
  273.5010,  263.1821,  0.0000,    0.0000,    384.8152,  268.9427,  258.8699,  0.0000,    0.0000,
  374.0353,  261.9897,  252.3030,  0.0000,    0.0000,    359.2842,  252.4918,  243.3399,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    326.0371,  264.3957,  0.0000,
  0.0000,    0.0000,    320.2231,  259.9706,  0.0000,    0.0000,    0.0000,    311.2799,  253.2180,
  0.0000,    0.0000,    0.0000,    299.0137,  243.9926,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    345.6085,  262.2840,  0.0000,    0.0000,    0.0000,
  339.4814,  257.9689,  0.0000,    0.0000,    0.0000,    330.1075,  251.4082,  0.0000,    0.0000,
  0.0000,    317.2880,  242.4605,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    432.6167,  413.0126,  333.9114,  285.3599,  0.0000,    424.7008,  405.5453,
  328.1518,  280.6350,  0.0000,    412.5541,  394.1073,  319.3719,  273.4592,  0.0000,    395.9157,
  378.4539,  307.3832,  263.6781,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  401.9415,  375.3694,  363.1576,  327.6790,  296.7505,  394.8165,  368.8196,  356.8734,  322.1450,
  291.8644,  383.9466,  358.8398,  347.3049,  313.7342,  284.4506,  369.1013,  345.2176,  334.2483,
  302.2666,  274.3493,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    359.5564,  352.5427,
  343.0487,  331.0618,  0.0000,    353.4245,  346.5656,  337.2763,  325.5439,  0.0000,    344.1036,
  337.4828,  328.5083,  317.1679,  0.0000,    331.3946,  325.0999,  316.5569,  305.7538,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    334.2234,  334.0263,  331.3844,  0.0000,
  0.0000,    328.6756,  328.4909,  325.9092,  0.0000,    0.0000,    320.2529,  320.0878,  317.5986,
  0.0000,    0.0000,    308.7739,  308.6359,  306.2735,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    302.6743,  305.5214,  0.0000,    0.0000,    0.0000,    297.8064,
  300.6043,  0.0000,    0.0000,    0.0000,    290.4211,  293.1445,  0.0000,    0.0000,    0.0000,
  280.3577,  282.9800,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    272.4110,  0.0000,    0.0000,    0.0000,    0.0000,    268.1700,  0.0000,    0.0000,
  0.0000,    0.0000,    261.7361,  0.0000,    0.0000,    0.0000,    0.0000,    252.9678,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1108.3145,
  407.7958,  0.0000,    0.0000,    0.0000,    1085.3677, 400.6439,  0.0000,    0.0000,    0.0000,
  1048.8144, 389.6837,  0.0000,    0.0000,    0.0000,    997.6271,  374.6769,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1028.5424, 853.9157,  430.8021,
  0.0000,    0.0000,    1007.7913, 836.9364,  423.2918,  0.0000,    0.0000,    975.3242,  810.2357,
  411.8184,  0.0000,    0.0000,    930.3838,  773.1293,  396.1357,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    908.3670,  644.3560,  447.5546,  0.0000,    0.0000,
  890.4764,  632.2602,  439.8384,  0.0000,    0.0000,    862.6780,  613.5158,  428.0906,  0.0000,
  0.0000,    824.3488,  587.6805,  412.0610,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    424.2906,  0.0000,    0.0000,    0.0000,    0.0000,    417.0350,  0.0000,
  0.0000,    0.0000,    0.0000,    405.9846,  0.0000,    0.0000,    0.0000,    0.0000,    390.9033,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  912.5263,  411.5533,  0.0000,    0.0000,    0.0000,    894.2815,  404.5340,  0.0000,    0.0000,
  0.0000,    865.7939,  393.8448,  0.0000,    0.0000,    0.0000,    826.4044,  379.2572,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    877.0066,  403.0441,
  0.0000,    0.0000,    0.0000,    859.5248,  396.1729,  0.0000,    0.0000,    0.0000,    832.2670,
  385.7096,  0.0000,    0.0000,    0.0000,    794.6136,  371.4307,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    855.2177,  390.3161,  0.0000,    0.0000,
  0.0000,    838.1837,  383.6775,  0.0000,    0.0000,    0.0000,    811.6356,  373.5692,  0.0000,
  0.0000,    0.0000,    774.9718,  359.7752,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    835.1622,  392.0139,  0.0000,    0.0000,    0.0000,    818.5381,
  385.3099,  0.0000,    0.0000,    0.0000,    792.6385,  375.0947,  0.0000,    0.0000,    0.0000,
  756.8785,  361.1491,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    817.3888,  376.9991,  0.0000,    0.0000,    0.0000,    801.1286,  370.4418,  0.0000,
  0.0000,    0.0000,    775.8051,  360.4255,  0.0000,    0.0000,    0.0000,    740.8479,  346.7365,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    645.9849,
  394.5033,  0.0000,    0.0000,    0.0000,    633.5809,  387.7336,  0.0000,    0.0000,    0.0000,
  614.3654,  377.4212,  0.0000,    0.0000,    0.0000,    587.9119,  363.3458,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    721.2042,  370.6421,  0.0000,
  0.0000,    0.0000,    706.8707,  364.3169,  0.0000,    0.0000,    0.0000,    684.3805,  354.6851,
  0.0000,    0.0000,    0.0000,    653.1815,  341.5412,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    696.2760,  376.7249,  0.0000,    0.0000,    0.0000,
  682.5126,  370.2368,  0.0000,    0.0000,    0.0000,    660.9421,  360.3420,  0.0000,    0.0000,
  0.0000,    631.0316,  346.8276,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    738.2129,  351.9875,  0.0000,    0.0000,    0.0000,    723.6013,  346.0085,
  0.0000,    0.0000,    0.0000,    700.8927,  336.9098,  0.0000,    0.0000,    0.0000,    669.5829,
  324.4969,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  722.6654,  342.0170,  0.0000,    0.0000,    0.0000,    708.3653,  336.2183,  0.0000,    0.0000,
  0.0000,    686.1478,  327.3956,  0.0000,    0.0000,    0.0000,    655.5207,  315.3605,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    708.6950,  339.7906,
  0.0000,    0.0000,    0.0000,    694.6807,  334.0190,  0.0000,    0.0000,    0.0000,    672.9150,
  325.2371,  0.0000,    0.0000,    0.0000,    642.9169,  313.2573,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    700.2718,  357.0217,  0.0000,    0.0000,
  0.0000,    686.4011,  350.8906,  0.0000,    0.0000,    0.0000,    664.8552,  341.5611,  0.0000,
  0.0000,    0.0000,    635.1575,  328.8344,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    592.0587,  328.5454,  0.0000,    0.0000,    0.0000,    580.6117,
  322.9784,  0.0000,    0.0000,    0.0000,    562.8960,  314.5113,  0.0000,    0.0000,    0.0000,
  538.5189,  302.9635,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    585.4250,  442.1870,  332.5587,  0.0000,    0.0000,    574.4090,  434.2287,  326.9981,
  0.0000,    0.0000,    557.4729,  422.0150,  318.5520,  0.0000,    0.0000,    534.2546,  405.2771,
  307.0393,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    535.6015,
  411.2565,  346.7690,  0.0000,    0.0000,    525.7375,  404.0189,  340.9276,  0.0000,    0.0000,
  510.6138,  392.9377,  332.0294,  0.0000,    0.0000,    489.9092,  377.7713,  319.8816,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    452.7837,  375.9984,  322.6401,
  0.0000,    0.0000,    444.6486,  369.5395,  317.3585,  0.0000,    0.0000,    432.1746,  359.6738,
  309.3265,  0.0000,    0.0000,    415.0939,  346.1880,  298.3709,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    461.1531,  379.6101,  293.3096,  0.0000,    0.0000,
  452.9177,  372.9591,  288.6268,  0.0000,    0.0000,    440.3127,  362.7743,  281.5084,  0.0000,
  0.0000,    423.0685,  348.8350,  271.7996,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    418.6892,  333.9602,  276.1337,  0.0000,    0.0000,    411.3669,  328.4253,
  271.8145,  0.0000,    0.0000,    400.1807,  319.9987,  265.2513,  0.0000,    0.0000,    384.8920,
  308.4982,  256.3005,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  383.9265,  314.2292,  280.9006,  0.0000,    0.0000,    377.3328,  309.0810,  276.4120,  0.0000,
  0.0000,    367.2724,  301.2426,  269.5747,  0.0000,    0.0000,    353.5305,  290.5447,  260.2393,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    319.0409,  300.1211,
  295.5118,  0.0000,    0.0000,    313.7040,  295.2402,  290.7602,  0.0000,    0.0000,    305.5560,
  287.8078,  283.5308,  0.0000,    0.0000,    294.4216,  277.6631,  273.6669,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    298.1013,  286.7352,  0.0000,    0.0000,
  0.0000,    293.1656,  282.0818,  0.0000,    0.0000,    0.0000,    285.6294,  274.9895,  0.0000,
  0.0000,    0.0000,    275.3299,  265.3045,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    307.0371,  277.6226,  0.0000,    0.0000,    0.0000,    301.9723,
  273.2027,  0.0000,    0.0000,    0.0000,    294.2547,  266.4833,  0.0000,    0.0000,    0.0000,
  283.7181,  257.3184,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    444.1316,  443.4125,  356.9808,  318.7696,  0.0000,    436.1584,  435.5100,  350.9611,
  313.5655,  0.0000,    423.9023,  423.3891,  341.7870,  305.6561,  0.0000,    407.0958,  406.7876,
  329.2613,  294.8707,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    435.9281,
  405.9374,  377.5368,  370.6520,  345.0898,  428.2639,  398.9425,  371.1603,  364.4441,  339.4241,
  416.5496,  388.2741,  361.4532,  355.0035,  330.8203,  400.5349,  373.7042,  348.2071,  342.1276,
  319.0930,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    401.9920,  394.5852,  385.3125,
  374.1139,  0.0000,    395.1495,  387.9210,  378.8626,  367.9163,  0.0000,    384.7323,  377.7830,
  369.0585,  358.5042,  0.0000,    370.5178,  363.9541,  355.6897,  345.6750,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    384.0853,  384.3087,  382.8003,  0.0000,    0.0000,
  377.6873,  377.9262,  376.4665,  0.0000,    0.0000,    367.9617,  368.2276,  366.8447,  0.0000,
  0.0000,    354.6994,  355.0040,  353.7278,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    355.0899,  359.4322,  0.0000,    0.0000,    0.0000,    349.3407,  353.6122,
  0.0000,    0.0000,    0.0000,    340.6117,  344.7767,  0.0000,    0.0000,    0.0000,    328.7135,
  332.7342,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  325.8468,  0.0000,    0.0000,    0.0000,    0.0000,    320.7197,  0.0000,    0.0000,    0.0000,
  0.0000,    312.9382,  0.0000,    0.0000,    0.0000,    0.0000,    302.3320,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1050.9064, 459.4511,
  0.0000,    0.0000,    0.0000,    1029.5399, 451.4064,  0.0000,    0.0000,    0.0000,    995.6883,
  439.0839,  0.0000,    0.0000,    0.0000,    948.4444,  422.2156,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1019.7251, 852.1795,  474.4189,  0.0000,
  0.0000,    999.4395,  835.4911,  466.1735,  0.0000,    0.0000,    967.7980,  809.3684,  453.5790,
  0.0000,    0.0000,    924.0753,  773.1681,  436.3649,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    905.5342,  487.0472,  0.0000,    0.0000,    0.0000,    887.9112,
  478.7221,  0.0000,    0.0000,    0.0000,    860.6059,  466.0470,  0.0000,    0.0000,    0.0000,
  823.0147,  448.7513,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    817.5552,  559.9626,  0.0000,    0.0000,    0.0000,    802.1553,  550.1341,  0.0000,
  0.0000,    0.0000,    778.4268,  535.0793,  0.0000,    0.0000,    0.0000,    745.8571,  514.4650,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    809.3754,
  500.9407,  0.0000,    0.0000,    0.0000,    793.9473,  492.2929,  0.0000,    0.0000,    0.0000,
  770.0795,  479.0423,  0.0000,    0.0000,    0.0000,    737.2457,  460.8870,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    783.7069,  443.9002,  0.0000,
  0.0000,    0.0000,    768.7821,  436.3941,  0.0000,    0.0000,    0.0000,    745.6954,  424.9509,
  0.0000,    0.0000,    0.0000,    713.9394,  409.3239,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    804.2562,  427.3508,  0.0000,    0.0000,    0.0000,
  788.6402,  420.1677,  0.0000,    0.0000,    0.0000,    764.3973,  409.2244,  0.0000,    0.0000,
  0.0000,    730.9897,  394.2859,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    779.2976,  510.1117,  0.0000,    0.0000,    0.0000,    764.2110,  500.9875,
  0.0000,    0.0000,    0.0000,    740.8098,  486.9403,  0.0000,    0.0000,    0.0000,    708.5774,
  467.6548,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  213.6738,  213.7298,  212.0915,  0.0000,    0.0000,    213.7298,  213.7862,  212.1475,  0.0000,
  0.0000,    212.0915,  212.1475,  210.5231,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    188.3605,  189.5974,
  0.0000,    0.0000,    0.0000,    188.4031,  189.6408,  0.0000,    0.0000,    0.0000,    186.9994,
  188.2263,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    164.8494,  0.0000,    0.0000,    0.0000,
  0.0000,    164.8833,  0.0000,    0.0000,    0.0000,    0.0000,    163.6906,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    778.9204,  304.5312,  0.0000,    0.0000,    0.0000,    780.0986,
  304.7279,  0.0000,    0.0000,    0.0000,    773.1255,  302.2530,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    700.0532,  573.0850,  317.0938,  0.0000,    0.0000,    700.8015,  573.7135,  317.2498,
  0.0000,    0.0000,    694.6556,  568.7416,  314.6933,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    620.3334,
  448.1381,  307.9733,  0.0000,    0.0000,    620.8918,  448.4872,  308.0920,  0.0000,    0.0000,
  615.5317,  444.7322,  305.6508,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    561.5474,  341.0338,  311.4245,
  0.0000,    0.0000,    562.0001,  341.2040,  311.5368,  0.0000,    0.0000,    557.2071,  338.4610,
  309.0838,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    514.5077,  344.2425,  300.9258,  0.0000,    0.0000,
  514.8945,  344.4169,  301.0426,  0.0000,    0.0000,    510.5464,  341.6492,  298.6808,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    400.4998,  321.9415,  267.9623,  0.0000,    0.0000,    400.7722,  322.0978,
  268.0526,  0.0000,    0.0000,    397.4644,  319.5340,  265.9986,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  445.4778,  357.2511,  237.8235,  0.0000,    0.0000,    445.7916,  357.4737,  237.8953,  0.0000,
  0.0000,    442.0786,  354.5768,  236.1084,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    342.3814,  282.7302,
  225.1670,  0.0000,    0.0000,    342.5970,  282.8460,  225.2330,  0.0000,    0.0000,    339.8157,
  280.6374,  223.5555,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    374.0632,  264.6717,  227.8311,  0.0000,
  0.0000,    374.2900,  264.7815,  227.9132,  0.0000,    0.0000,    371.2277,  262.7255,  226.1893,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    347.8393,  246.0921,  237.5192,  0.0000,    0.0000,    348.0402,
  246.1937,  237.6065,  0.0000,    0.0000,    345.2124,  244.2954,  235.7943,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    289.6469,  237.7217,  0.0000,    0.0000,    0.0000,    289.8328,  237.8238,  0.0000,
  0.0000,    0.0000,    287.5025,  235.9871,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    307.5539,
  236.5779,  0.0000,    0.0000,    0.0000,    307.7214,  236.6604,  0.0000,    0.0000,    0.0000,
  305.2454,  234.8470,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    382.5968,  366.1519,  298.6933,
  257.1422,  0.0000,    382.8381,  366.3652,  298.8244,  257.2275,  0.0000,    379.6844,  363.3697,
  296.4552,  255.2418,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    357.7871,  335.1182,  324.7135,  294.2742,  267.6724,
  357.9609,  335.2667,  324.8502,  294.3804,  267.7542,  355.0652,  332.5825,  322.2635,  292.0737,
  265.6909,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    322.3608,  316.3984,  308.2846,  298.0072,  0.0000,    322.4812,  316.5125,
  308.3906,  298.1033,  0.0000,    319.9354,  314.0234,  305.9773,  295.7851,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  301.0545,  300.9617,  298.7331,  0.0000,    0.0000,    301.1506,  301.0567,  298.8255,  0.0000,
  0.0000,    298.8156,  298.7247,  296.5153,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    274.0630,  276.6109,
  0.0000,    0.0000,    0.0000,    274.1377,  276.6862,  0.0000,    0.0000,    0.0000,    272.0583,
  274.5862,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    247.9275,  0.0000,    0.0000,    0.0000,
  0.0000,    247.9867,  0.0000,    0.0000,    0.0000,    0.0000,    246.1495,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    950.1975,  363.5286,  0.0000,    0.0000,    0.0000,    951.6305,
  363.7202,  0.0000,    0.0000,    0.0000,    943.1487,  360.8053,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    889.6147,  740.1496,  384.5873,  0.0000,    0.0000,    890.6264,  741.0220,  384.7697,
  0.0000,    0.0000,    882.8069,  734.5865,  381.6942,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    790.4855,
  566.2920,  400.4704,  0.0000,    0.0000,    791.2471,  566.7513,  400.6320,  0.0000,    0.0000,
  784.4000,  562.0006,  397.4445,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    380.1606,  0.0000,    0.0000,
  0.0000,    0.0000,    380.3160,  0.0000,    0.0000,    0.0000,    0.0000,    377.3149,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    791.0214,  368.9206,  0.0000,    0.0000,    0.0000,
  791.8817,  369.0697,  0.0000,    0.0000,    0.0000,    784.9774,  366.1629,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    760.8949,  361.3222,  0.0000,    0.0000,    0.0000,    761.6998,  361.4679,
  0.0000,    0.0000,    0.0000,    755.0713,  358.6221,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  742.1649,  350.0554,  0.0000,    0.0000,    0.0000,    742.9435,  350.1952,  0.0000,    0.0000,
  0.0000,    736.4811,  347.4428,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    724.8987,  351.2182,
  0.0000,    0.0000,    0.0000,    725.6536,  351.3644,  0.0000,    0.0000,    0.0000,    719.3436,
  348.5929,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    709.6039,  336.6910,  0.0000,    0.0000,
  0.0000,    710.3376,  336.8539,  0.0000,    0.0000,    0.0000,    704.1627,  334.1734,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    565.2991,  353.2521,  0.0000,    0.0000,    0.0000,    565.7914,
  353.3989,  0.0000,    0.0000,    0.0000,    560.9891,  350.6032,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    625.4480,  332.2173,  0.0000,    0.0000,    0.0000,    626.1705,  332.3519,  0.0000,
  0.0000,    0.0000,    620.7464,  329.7337,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    604.6048,
  337.0758,  0.0000,    0.0000,    0.0000,    605.2828,  337.2239,  0.0000,    0.0000,    0.0000,
  600.0555,  334.5522,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    641.7452,  315.7701,  0.0000,
  0.0000,    0.0000,    642.3795,  315.8929,  0.0000,    0.0000,    0.0000,    636.8114,  313.4113,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    628.2934,  306.9300,  0.0000,    0.0000,    0.0000,
  628.9108,  307.0478,  0.0000,    0.0000,    0.0000,    623.4596,  304.6384,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    616.2658,  304.8342,  0.0000,    0.0000,    0.0000,    616.8666,  304.9520,
  0.0000,    0.0000,    0.0000,    611.5213,  302.5558,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  608.7174,  319.6852,  0.0000,    0.0000,    0.0000,    609.3146,  319.8129,  0.0000,    0.0000,
  0.0000,    604.0284,  317.2786,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    517.4576,  294.8812,
  0.0000,    0.0000,    0.0000,    517.9069,  294.9920,  0.0000,    0.0000,    0.0000,    513.4843,
  292.6768,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    514.8784,  392.2456,  299.1967,  0.0000,
  0.0000,    515.2388,  392.4775,  299.2958,  0.0000,    0.0000,    510.9034,  389.2745,  296.9628,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    473.1685,  366.4067,  311.4923,  0.0000,    0.0000,    473.4619,
  366.5983,  311.6121,  0.0000,    0.0000,    469.5352,  363.6525,  309.1767,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    401.8429,  336.5240,  291.2663,  0.0000,    0.0000,    402.0778,  336.6777,  291.3625,
  0.0000,    0.0000,    398.8063,  334.0177,  289.1318,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    409.8108,
  338.4808,  265.8700,  0.0000,    0.0000,    410.0352,  338.6586,  265.9497,  0.0000,    0.0000,
  406.7094,  335.9505,  263.9506,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    373.5590,  300.8318,  251.1164,
  0.0000,    0.0000,    373.7422,  300.9422,  251.1853,  0.0000,    0.0000,    370.7546,  298.6221,
  249.3249,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    343.6833,  283.5975,  254.5338,  0.0000,    0.0000,
  343.8376,  283.6992,  254.6202,  0.0000,    0.0000,    341.1245,  281.5326,  252.7124,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    286.8703,  271.1885,  267.5378,  0.0000,    0.0000,    286.9945,  271.2851,
  267.6261,  0.0000,    0.0000,    284.7786,  269.2265,  265.6099,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  268.5000,  259.1584,  0.0000,    0.0000,    0.0000,    268.6145,  259.2551,  0.0000,    0.0000,
  0.0000,    266.5585,  257.2948,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    276.7697,  251.7520,
  0.0000,    0.0000,    0.0000,    276.8778,  251.8306,  0.0000,    0.0000,    0.0000,    274.7593,
  249.9470,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    394.0893,  394.0800,  320.5921,  287.9015,
  0.0000,    394.3385,  394.3108,  320.7238,  287.9969,  0.0000,    391.1438,  391.1275,  318.2256,
  285.8005,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    388.5373,  363.1743,  338.9950,  333.3205,  311.4041,  388.7357,
  363.3370,  339.1282,  333.4424,  311.5038,  385.6200,  360.4617,  336.4787,  330.8502,  309.1134,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    360.4735,  354.3291,  346.5496,  337.0911,  0.0000,    360.6185,  354.4637,  346.6728,
  337.2018,  0.0000,    357.7845,  351.6912,  343.9761,  334.5957,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    345.7266,
  346.1124,  344.9761,  0.0000,    0.0000,    345.8475,  346.2301,  345.0898,  0.0000,    0.0000,
  343.1666,  343.5506,  342.4249,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    321.1572,  325.0832,  0.0000,
  0.0000,    0.0000,    321.2528,  325.1791,  0.0000,    0.0000,    0.0000,    318.8097,  322.7051,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    296.0591,  0.0000,    0.0000,    0.0000,    0.0000,
  296.1364,  0.0000,    0.0000,    0.0000,    0.0000,    293.9292,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    905.4724,  409.7155,  0.0000,    0.0000,    0.0000,    906.7065,  409.9270,
  0.0000,    0.0000,    0.0000,    898.7234,  406.6434,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  885.0433,  741.5511,  423.7602,  0.0000,    0.0000,    885.9738,  742.3417,  423.9573,  0.0000,
  0.0000,    878.2656,  735.9570,  420.5742,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    790.2645,  436.4377,
  0.0000,    0.0000,    0.0000,    790.9717,  436.6129,  0.0000,    0.0000,    0.0000,    784.1819,
  433.1665,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    718.6679,  499.0729,  0.0000,    0.0000,
  0.0000,    719.2018,  499.3363,  0.0000,    0.0000,    0.0000,    713.1602,  495.3332,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    709.4380,  447.7438,  0.0000,    0.0000,    0.0000,    710.0299,
  447.9718,  0.0000,    0.0000,    0.0000,    704.0315,  444.4244,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    687.0839,  398.4493,  0.0000,    0.0000,    0.0000,    687.6559,  398.6148,  0.0000,
  0.0000,    0.0000,    681.8524,  395.5015,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    702.0311,
  384.0157,  0.0000,    0.0000,    0.0000,    702.6880,  384.1691,  0.0000,    0.0000,    0.0000,
  696.6895,  381.1814,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    680.7355,  452.8313,  0.0000,
  0.0000,    0.0000,    681.3589,  453.1242,  0.0000,    0.0000,    0.0000,    675.5529,  449.4634,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    167.1297,  168.1791,  0.0000,    0.0000,    0.0000,
  168.1791,  169.2375,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    147.1830,  0.0000,    0.0000,    0.0000,    0.0000,    148.0689,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  650.3606,  263.4592,  0.0000,    0.0000,    0.0000,    656.6574,  265.4647,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    590.7326,  485.0650,
  275.4476,  0.0000,    0.0000,    596.0214,  489.3461,  277.4689,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    526.8299,  384.2901,  268.9880,  0.0000,
  0.0000,    531.3426,  387.3876,  270.8810,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    479.0040,  296.3944,  272.4910,  0.0000,    0.0000,    482.9873,
  298.5634,  274.3837,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    440.2999,  299.1535,  263.4034,  0.0000,    0.0000,    443.8848,  301.3463,  265.2340,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    344.9826,
  280.4702,  235.9264,  0.0000,    0.0000,    347.6800,  282.4933,  237.5019,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    382.7591,  309.3530,  210.3812,
  0.0000,    0.0000,    385.7986,  311.6901,  211.7410,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    296.2668,  247.6203,  199.5549,  0.0000,    0.0000,
  298.5174,  249.3404,  200.8289,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    323.1941,  232.0580,  201.0472,  0.0000,    0.0000,    325.6650,  233.6608,
  202.3758,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  301.1390,  216.0945,  209.1971,  0.0000,    0.0000,    303.4107,  217.5738,  210.5970,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    251.1189,  208.6044,
  0.0000,    0.0000,    0.0000,    253.0095,  210.0411,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    266.9700,  208.2113,  0.0000,    0.0000,
  0.0000,    268.9491,  209.6083,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    329.9250,  316.5231,  260.5925,  226.0224,  0.0000,    332.4791,
  318.9305,  262.4494,  227.5472,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    310.5093,  291.7179,  283.1051,  257.7196,  235.4797,  312.7994,  293.8239,  285.1261,
  259.5011,  237.0549,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    281.8050,
  276.8856,  270.1506,  261.5889,  0.0000,    283.7761,  278.8076,  272.0076,  263.3649,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    264.4516,  264.4446,  262.6226,
  0.0000,    0.0000,    266.2386,  266.2278,  264.3868,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    242.0556,  244.2752,  0.0000,    0.0000,    0.0000,
  243.6296,  245.8647,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    220.1581,  0.0000,    0.0000,    0.0000,    0.0000,    221.5367,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  794.2184,  316.0700,  0.0000,    0.0000,    0.0000,    801.8614,  318.3827,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    749.8475,  625.5504,
  334.8115,  0.0000,    0.0000,    756.6271,  631.1397,  337.2327,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    670.3843,  485.2955,  349.3710,  0.0000,
  0.0000,    676.1930,  489.2291,  351.8502,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    332.1884,  0.0000,    0.0000,    0.0000,    0.0000,    334.5262,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    668.3328,  322.5272,  0.0000,    0.0000,    0.0000,    674.2876,  324.7894,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    643.4305,
  315.9132,  0.0000,    0.0000,    0.0000,    649.1282,  318.1278,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    627.7342,  306.1959,  0.0000,
  0.0000,    0.0000,    633.2835,  308.3361,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    613.2405,  306.8959,  0.0000,    0.0000,    0.0000,
  618.6540,  309.0575,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    600.4064,  293.3036,  0.0000,    0.0000,    0.0000,    605.6994,  295.4210,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  482.3172,  308.4763,  0.0000,    0.0000,    0.0000,    486.3444,  310.6569,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    528.9381,  290.4179,
  0.0000,    0.0000,    0.0000,    533.6485,  292.4564,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    511.9716,  294.1510,  0.0000,    0.0000,
  0.0000,    516.4905,  296.2434,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    543.7162,  276.2768,  0.0000,    0.0000,    0.0000,    548.4629,
  278.2032,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    532.3641,  268.6347,  0.0000,    0.0000,    0.0000,    537.0079,  270.5030,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    522.2655,
  266.7093,  0.0000,    0.0000,    0.0000,    526.8147,  268.5684,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    515.6649,  279.1274,  0.0000,
  0.0000,    0.0000,    520.1674,  281.0990,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    440.8428,  258.1129,  0.0000,    0.0000,    0.0000,
  444.5516,  259.9055,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    441.3377,  339.2853,  262.4889,  0.0000,    0.0000,    444.8851,  341.8557,
  264.2782,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  407.4691,  318.3752,  272.9038,  0.0000,    0.0000,    410.6430,  320.7130,  274.7891,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    347.7963,  293.7958,
  256.5170,  0.0000,    0.0000,    350.4234,  295.8832,  258.2257,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    355.1378,  294.3973,  235.1647,  0.0000,
  0.0000,    357.7932,  296.5487,  236.6853,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    325.0694,  264.3845,  222.8746,  0.0000,    0.0000,    327.4317,
  266.1757,  224.2814,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    300.1178,  249.7617,  225.1341,  0.0000,    0.0000,    302.2475,  251.4316,  226.5970,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    251.7482,
  239.1551,  236.3913,  0.0000,    0.0000,    253.4816,  240.7411,  237.9360,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    236.0765,  228.6485,  0.0000,
  0.0000,    0.0000,    237.6832,  230.1639,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    243.4960,  222.8236,  0.0000,    0.0000,    0.0000,
  245.1411,  224.2620,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    341.1542,  341.6552,  280.9002,  253.7108,  0.0000,    343.7404,  344.2133,
  282.8475,  255.3964,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  337.7683,  316.9271,  296.9197,  292.3878,  274.1230,  340.2422,  319.1845,  298.9783,  294.3914,
  275.9534,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    315.2774,  310.3386,
  304.0064,  296.2504,  0.0000,    317.4838,  312.4875,  306.0865,  298.2495,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    303.5448,  304.0401,  303.2344,  0.0000,
  0.0000,    305.6097,  306.0997,  305.2783,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    283.3626,  286.8165,  0.0000,    0.0000,    0.0000,    285.2229,
  288.6991,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    262.4678,  0.0000,    0.0000,    0.0000,    0.0000,    264.1334,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    760.7086,
  356.3324,  0.0000,    0.0000,    0.0000,    767.7906,  358.9324,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    748.6502,  629.2099,  369.1145,
  0.0000,    0.0000,    755.2617,  634.6807,  371.7726,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    672.1658,  381.3870,  0.0000,    0.0000,    0.0000,
  677.8767,  384.0680,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    615.8505,  433.8409,  0.0000,    0.0000,    0.0000,    620.8260,  437.0198,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  606.3026,  390.4314,  0.0000,    0.0000,    0.0000,    611.3075,  393.2367,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    587.3450,  348.9122,
  0.0000,    0.0000,    0.0000,    592.1871,  351.3396,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    597.5035,  336.6552,  0.0000,    0.0000,
  0.0000,    602.5835,  338.9784,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    579.7956,  392.2224,  0.0000,    0.0000,    0.0000,    584.6998,
  395.1888,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    130.4017,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    542.3160,
  226.8590,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    496.9120,  409.3761,  237.9219,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    445.7013,  328.1316,  233.4581,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    406.8727,  256.1501,  236.8855,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  375.1339,  258.5304,  229.1191,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    295.7994,  242.9684,
  206.3637,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    327.3827,  266.5777,  184.8477,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    255.1516,  215.5683,  175.6524,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    277.8680,  202.2567,  176.3002,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    259.3964,
  188.6339,  183.1095,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    216.7336,  182.0016,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    230.5493,  182.0867,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    283.1269,  272.2288,  226.0215,  197.3762,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  267.9532,  252.4408,  245.3409,  224.2655,  205.7618,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    244.7902,  240.7515,
  235.1882,  228.0904,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    230.7426,  230.7947,  229.3135,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    212.2820,  214.2004,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    194.0699,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    662.9556,
  273.2999,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    630.2436,  527.3521,  289.7981,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    566.5101,  414.1664,  302.8960,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    288.5010,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  563.0156,  280.2438,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    542.4383,  274.5224,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    529.3070,  266.1893,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    517.1617,  266.5494,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    506.4098,  254.0859,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    409.9803,
  267.7464,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    446.2084,  252.3325,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    432.3893,  255.1809,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    459.1205,  240.2275,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  449.5592,  233.6551,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    441.0932,  231.9047,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    435.3535,  242.2147,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    374.1402,  224.5110,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    376.5287,  291.9645,  228.7578,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    349.1305,
  275.1274,  237.5951,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    299.4880,  255.0068,  224.4260,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    306.1306,  254.6783,  206.5945,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    281.3019,  230.8914,  196.4301,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  260.5672,  218.5753,  197.8474,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    219.6552,  209.5788,
  207.5157,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    206.3756,  200.4929,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    212.9356,  195.9211,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    293.9464,  294.7351,  244.6590,  222.1354,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    292.0472,
  274.9747,  258.4800,  254.8700,  239.7155,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    274.0755,  270.1200,  264.9847,
  258.6489,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    264.7978,  265.3465,  264.7909,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    248.3169,  251.3275,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  231.0392,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    637.9210,  308.1805,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    631.2757,  532.2890,  319.6386,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    569.5479,  331.2301,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    525.4240,  375.0874,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    516.1425,
  338.5833,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    500.1368,  303.7081,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    506.8216,  293.3488,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    492.1128,  338.1547,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  6138.7755, 1457.7817, 0.0000,    0.0000,    0.0000,    1457.7817, 476.2591,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4349.2577, 3670.9261,
  1380.8411, 0.0000,    0.0000,    1210.8108, 992.7970,  481.0605,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3520.9466, 2411.4577, 1244.1578, 0.0000,
  0.0000,    1037.4434, 726.8613,  455.2460,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3017.6856, 1493.7993, 1232.9252, 0.0000,    0.0000,    920.1358,
  517.6961,  457.0717,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2673.9344, 1501.7789, 1209.2081, 0.0000,    0.0000,    832.1368,  522.9449,  443.2682,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1969.4796,
  1385.1228, 1016.3718, 0.0000,    0.0000,    633.9471,  485.4129,  387.1236,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2237.9665, 1696.1214, 863.7655,
  0.0000,    0.0000,    710.7779,  556.1255,  338.5014,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1615.8387, 1138.5265, 805.0065,  0.0000,    0.0000,
  533.6135,  417.0831,  318.8041,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1749.7615, 1063.3477, 862.1222,  0.0000,    0.0000,    582.3742,  389.9183,
  328.6889,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1590.4415, 979.4032,  908.8152,  0.0000,    0.0000,    537.2565,  361.3047,  344.2670,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1360.7517, 954.1320,
  0.0000,    0.0000,    0.0000,    450.4714,  350.2295,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1366.3938, 898.5342,  0.0000,    0.0000,
  0.0000,    470.3119,  342.3410,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1828.5696, 1694.2091, 1243.0036, 976.6194,  0.0000,    599.8987,
  567.6002,  445.7605,  372.1527,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1554.3698, 1409.5386, 1341.6152, 1156.6447, 1000.9319, 542.8777,  502.4986,  483.8461,
  430.8811,  385.2516,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1286.1750,
  1248.8109, 1199.4646, 1137.8099, 0.0000,    474.5641,  463.9632,  449.7669,  431.9480,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1144.1913, 1140.3397, 1125.7134,
  0.0000,    0.0000,    435.5555,  434.9391,  430.8890,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    989.8921,  999.7871,  0.0000,    0.0000,    0.0000,
  389.4684,  393.1809,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    854.5223,  0.0000,    0.0000,    0.0000,    0.0000,    346.6791,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  7560.4361, 1620.7604, 0.0000,    0.0000,    0.0000,    1776.8880, 553.9780,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    5743.5673, 4997.9230,
  1652.2832, 0.0000,    0.0000,    1556.9958, 1301.3999, 579.7980,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4653.7454, 3121.5559, 1643.0879, 0.0000,
  0.0000,    1337.5010, 924.2203,  594.9926,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1547.0780, 0.0000,    0.0000,    0.0000,    0.0000,    563.1480,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    4971.0778, 1494.4074, 0.0000,    0.0000,    0.0000,    1369.5245, 545.5917,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4685.0846,
  1461.9055, 0.0000,    0.0000,    0.0000,    1309.7014, 534.1947,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4547.0720, 1410.8565, 0.0000,
  0.0000,    0.0000,    1275.3968, 516.8026,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    4422.2696, 1437.9300, 0.0000,    0.0000,    0.0000,
  1243.9950, 520.9703,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    4311.0961, 1438.5445, 0.0000,    0.0000,    0.0000,    1216.1018, 507.2285,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  3135.9242, 1447.9360, 0.0000,    0.0000,    0.0000,    934.6082,  524.5374,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4098.5678, 1345.9552,
  0.0000,    0.0000,    0.0000,    1093.0934, 491.4621,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3921.6962, 1405.6043, 0.0000,    0.0000,
  0.0000,    1050.0925, 503.0095,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3800.8304, 1264.1518, 0.0000,    0.0000,    0.0000,    1090.3500,
  465.2606,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    3709.4297, 1223.4668, 0.0000,    0.0000,    0.0000,    1066.4469, 451.5684,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3623.6511,
  1219.0706, 0.0000,    0.0000,    0.0000,    1044.6045, 448.9840,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3592.0465, 1299.4482, 0.0000,
  0.0000,    0.0000,    1033.3196, 473.6474,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2884.7585, 1170.8400, 0.0000,    0.0000,    0.0000,
  857.2478,  433.2923,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2596.4033, 1846.9699, 1152.8150, 0.0000,    0.0000,    824.2050,  609.1048,
  434.9443,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2260.8400, 1632.8526, 1247.3944, 0.0000,    0.0000,    742.7397,  558.4919,  457.8458,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1858.7683, 1416.5256,
  1099.7481, 0.0000,    0.0000,    622.0977,  503.2886,  420.1356,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1850.6131, 1497.7174, 965.4608,  0.0000,
  0.0000,    629.4728,  514.9747,  378.3875,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1610.3754, 1169.3798, 882.9290,  0.0000,    0.0000,    564.5516,
  438.0962,  353.5225,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1428.2493, 1083.6129, 943.1275,  0.0000,    0.0000,    512.7966,  410.6850,  364.4122,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1154.7638,
  1026.5038, 988.9746,  0.0000,    0.0000,    422.9019,  391.4685,  383.1834,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1066.3289, 985.7235,  0.0000,
  0.0000,    0.0000,    393.9288,  374.6446,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1074.4128, 911.7498,  0.0000,    0.0000,    0.0000,
  403.2645,  358.2372,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1864.6164, 1809.6860, 1287.7826, 1078.1354, 0.0000,    614.0469,  608.1170,
  472.5061,  414.5157,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1695.6909, 1513.1000, 1351.8089, 1301.3911, 1167.5181, 589.8275,  542.3817,  498.6058,  486.8363,
  448.5935,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1452.9418, 1403.6411,
  1346.6051, 1280.7871, 0.0000,    532.3907,  520.1567,  505.3496,  487.8113,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1334.3692, 1326.5708, 1311.8379, 0.0000,
  0.0000,    502.8673,  502.2018,  499.1756,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1178.7843, 1192.1368, 0.0000,    0.0000,    0.0000,    459.0005,
  464.4598,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1039.8788, 0.0000,    0.0000,    0.0000,    0.0000,    416.7321,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    6687.9551,
  1815.4672, 0.0000,    0.0000,    0.0000,    1647.6456, 623.0285,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    5459.4039, 4692.0594, 1810.8441,
  0.0000,    0.0000,    1522.3656, 1275.1297, 637.4404,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    4469.0053, 1769.7228, 0.0000,    0.0000,    0.0000,
  1317.6426, 645.7753,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    3699.6637, 2237.2776, 0.0000,    0.0000,    0.0000,    1157.8649, 760.6745,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  3848.8310, 1991.3447, 0.0000,    0.0000,    0.0000,    1163.4976, 677.1566,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3716.0678, 1612.5430,
  0.0000,    0.0000,    0.0000,    1125.9076, 588.3980,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4013.8973, 1529.6978, 0.0000,    0.0000,
  0.0000,    1175.3584, 564.3865,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3847.7324, 2178.7996, 0.0000,    0.0000,    0.0000,    1135.1209,
  706.9587,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    3381.3672, 2782.4577, 1185.8018, 0.0000,    0.0000,    2782.4577, 2312.6602, 968.0787,
  0.0000,    0.0000,    1185.8018, 968.0787,  491.7448,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2813.7007,
  1920.9295, 1091.2408, 0.0000,    0.0000,    2305.6086, 1586.5402, 890.7440,  0.0000,    0.0000,
  1028.2536, 725.1809,  469.2639,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2449.4723, 1277.5813, 1086.8394,
  0.0000,    0.0000,    2003.7829, 1044.3401, 887.4810,  0.0000,    0.0000,    918.2378,  528.6574,
  472.1081,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2188.2864, 1290.4826, 1057.8748, 0.0000,    0.0000,
  1789.7638, 1052.8629, 865.2462,  0.0000,    0.0000,    833.7135,  534.0203,  456.8822,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1631.5424, 1188.1982, 902.1097,  0.0000,    0.0000,    1335.0700, 972.1233,
  738.6401,  0.0000,    0.0000,    638.7768,  496.5128,  401.0541,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1844.3774, 1408.3895, 773.9463,  0.0000,    0.0000,    1509.2981, 1156.2604, 634.8168,  0.0000,
  0.0000,    714.7188,  562.4313,  351.9564,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1351.1988, 995.6116,
  723.6911,  0.0000,    0.0000,    1106.1259, 814.1975,  594.0387,  0.0000,    0.0000,    539.9639,
  429.5383,  331.8687,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1473.5487, 928.8255,  763.1756,  0.0000,
  0.0000,    1203.4301, 760.2437,  625.8949,  0.0000,    0.0000,    590.3744,  401.5048,  340.2392,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1347.9007, 856.7169,  804.0036,  0.0000,    0.0000,    1100.5370,
  701.6550,  658.5196,  0.0000,    0.0000,    545.9768,  372.2612,  356.1148,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1136.9099, 833.3168,  0.0000,    0.0000,    0.0000,    931.6022,  682.1817,  0.0000,
  0.0000,    0.0000,    455.7267,  360.4891,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1167.0471,
  798.4528,  0.0000,    0.0000,    0.0000,    952.7533,  653.2782,  0.0000,    0.0000,    0.0000,
  479.3797,  354.6096,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1529.6862, 1430.6640, 1078.8447,
  869.2745,  0.0000,    1250.1173, 1168.5036, 881.5739,  710.6790,  0.0000,    606.8145,  576.2896,
  457.8102,  385.7594,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1338.5665, 1223.3073, 1169.7495, 1021.1992, 894.7056,
  1091.6636, 998.1919,  954.6446,  834.0979,  731.6257,  555.3233,  515.7606,  497.5316,  445.2988,
  400.0650,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1132.1713, 1101.9644, 1061.9947, 1012.1518, 0.0000,    924.1369,  899.7796,
  867.4828,  827.1106,  0.0000,    489.8228,  479.3863,  465.3683,  447.7500,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1018.3413, 1015.6122, 1003.8665, 0.0000,    0.0000,    832.5060,  830.3661,  820.9055,  0.0000,
  0.0000,    451.6295,  451.1258,  447.1555,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    890.6723,  899.4930,
  0.0000,    0.0000,    0.0000,    729.7176,  736.9021,  0.0000,    0.0000,    0.0000,    405.6158,
  409.4712,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    776.0859,  0.0000,    0.0000,    0.0000,
  0.0000,    637.4660,  0.0000,    0.0000,    0.0000,    0.0000,    362.3556,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    5305.1627, 1372.8515, 0.0000,    0.0000,    0.0000,    4496.9846,
  1124.9345, 0.0000,    0.0000,    0.0000,    1681.3249, 564.3454,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    4394.3607, 3697.6569, 1419.9417, 0.0000,    0.0000,    3631.4540, 3095.7594, 1160.9040,
  0.0000,    0.0000,    1516.5369, 1260.1619, 593.3572,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3666.6556,
  2458.0845, 1434.6583, 0.0000,    0.0000,    3014.0781, 2036.5362, 1171.1205, 0.0000,    0.0000,
  1319.0312, 919.4490,  612.2994,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1352.0803, 0.0000,    0.0000,
  0.0000,    0.0000,    1104.4325, 0.0000,    0.0000,    0.0000,    0.0000,    579.7357,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    3828.9626, 1307.3665, 0.0000,    0.0000,    0.0000,
  3162.1198, 1068.0684, 0.0000,    0.0000,    0.0000,    1338.9789, 561.9076,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    3642.0492, 1279.5273, 0.0000,    0.0000,    0.0000,    2999.9283, 1045.2541,
  0.0000,    0.0000,    0.0000,    1283.6521, 550.2241,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  3541.4930, 1235.8086, 0.0000,    0.0000,    0.0000,    2915.7949, 1009.7020, 0.0000,    0.0000,
  0.0000,    1250.8766, 532.4996,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3449.9906, 1252.6342,
  0.0000,    0.0000,    0.0000,    2839.3501, 1024.0101, 0.0000,    0.0000,    0.0000,    1220.8006,
  535.9497,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3368.5646, 1239.5504, 0.0000,    0.0000,
  0.0000,    2771.3234, 1012.8078, 0.0000,    0.0000,    0.0000,    1194.1104, 519.2271,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2507.7589, 1262.8491, 0.0000,    0.0000,    0.0000,    2059.4692,
  1031.5808, 0.0000,    0.0000,    0.0000,    928.2866,  539.6227,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    3083.9899, 1177.8523, 0.0000,    0.0000,    0.0000,    2566.8729, 962.0972,  0.0000,
  0.0000,    0.0000,    1062.1534, 506.1454,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2948.5688,
  1217.6072, 0.0000,    0.0000,    0.0000,    2457.8402, 995.6332,  0.0000,    0.0000,    0.0000,
  1022.3708, 516.4699,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2997.0212, 1110.0442, 0.0000,
  0.0000,    0.0000,    2460.9470, 906.7106,  0.0000,    0.0000,    0.0000,    1074.3220, 479.7811,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2928.7164, 1075.5659, 0.0000,    0.0000,    0.0000,
  2404.1111, 878.5837,  0.0000,    0.0000,    0.0000,    1051.2437, 465.8723,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2865.2613, 1070.8351, 0.0000,    0.0000,    0.0000,    2351.2803, 874.6707,
  0.0000,    0.0000,    0.0000,    1030.2928, 463.0740,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2837.9423, 1137.7525, 0.0000,    0.0000,    0.0000,    2328.9369, 928.7123,  0.0000,    0.0000,
  0.0000,    1018.7310, 487.8628,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2304.8558, 1030.7165,
  0.0000,    0.0000,    0.0000,    1892.7447, 841.8543,  0.0000,    0.0000,    0.0000,    851.6022,
  447.2511,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2146.4040, 1540.3424, 1022.6698, 0.0000,
  0.0000,    1752.9565, 1263.2459, 835.7270,  0.0000,    0.0000,    828.9803,  617.1707,  450.4096,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1896.9799, 1384.3496, 1090.1054, 0.0000,    0.0000,    1547.9897,
  1133.9963, 892.5336,  0.0000,    0.0000,    751.6662,  569.1975,  472.0061,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1565.9413, 1221.1434, 977.3503,  0.0000,    0.0000,    1280.4929, 999.6018,  800.2836,
  0.0000,    0.0000,    631.3639,  515.9599,  435.4733,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1571.6863,
  1272.8662, 865.2155,  0.0000,    0.0000,    1284.0434, 1042.3341, 709.6397,  0.0000,    0.0000,
  640.7445,  525.0503,  393.4644,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1384.8254, 1030.3644, 796.8950,
  0.0000,    0.0000,    1131.2913, 843.7177,  654.5233,  0.0000,    0.0000,    577.4594,  452.7634,
  368.5810,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1239.7351, 958.7110,  838.2576,  0.0000,    0.0000,
  1013.1095, 785.3791,  688.2347,  0.0000,    0.0000,    526.4372,  424.9597,  377.9017,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1007.0623, 909.7880,  882.1252,  0.0000,    0.0000,    824.6609,  745.6637,
  723.2477,  0.0000,    0.0000,    435.1078,  405.3197,  397.6511,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  932.2055,  871.4755,  0.0000,    0.0000,    0.0000,    763.8853,  714.6170,  0.0000,    0.0000,
  0.0000,    405.6895,  387.5404,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    947.2011,  817.7856,
  0.0000,    0.0000,    0.0000,    775.5046,  670.7266,  0.0000,    0.0000,    0.0000,    416.4974,
  372.4749,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1554.7036, 1524.5549, 1126.3391, 961.1299,
  0.0000,    1274.2283, 1247.8398, 921.3623,  786.7662,  0.0000,    621.1496,  617.4175,  486.7059,
  429.9551,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1453.4745, 1313.0553, 1186.5298, 1149.3369, 1041.8714, 1187.3359,
  1072.8240, 969.9232,  939.4922,  852.3143,  602.4899,  556.8068,  514.2047,  503.1891,  465.5013,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1273.2370, 1235.5778, 1191.2973, 1139.7642, 0.0000,    1040.0523, 1009.5291, 973.6474,
  931.8633,  0.0000,    548.5516,  536.9214,  522.6714,  505.6763,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1181.8604,
  1177.0902, 1166.3270, 0.0000,    0.0000,    966.3035,  962.5205,  953.8869,  0.0000,    0.0000,
  520.3856,  520.0852,  517.3698,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1056.1781, 1068.4888, 0.0000,
  0.0000,    0.0000,    865.0084,  875.0712,  0.0000,    0.0000,    0.0000,    477.1856,  482.9352,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    940.3766,  0.0000,    0.0000,    0.0000,    0.0000,
  771.7877,  0.0000,    0.0000,    0.0000,    0.0000,    434.8109,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    4814.0613, 1540.7355, 0.0000,    0.0000,    0.0000,    4053.3897, 1262.3248,
  0.0000,    0.0000,    0.0000,    1574.9942, 635.1845,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  4233.9736, 3553.3992, 1557.6903, 0.0000,    0.0000,    3491.0837, 2958.5401, 1273.8440, 0.0000,
  0.0000,    1491.7535, 1245.2372, 652.7258,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3564.3510, 1548.7458,
  0.0000,    0.0000,    0.0000,    2924.8174, 1264.8795, 0.0000,    0.0000,    0.0000,    1306.2558,
  665.1167,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3033.1273, 1886.0887, 0.0000,    0.0000,
  0.0000,    2481.2627, 1548.2877, 0.0000,    0.0000,    0.0000,    1161.0723, 774.8483,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3098.7868, 1665.6547, 0.0000,    0.0000,    0.0000,    2542.5532,
  1374.3437, 0.0000,    0.0000,    0.0000,    1158.7996, 690.5246,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2995.7186, 1406.4978, 0.0000,    0.0000,    0.0000,    2457.2393, 1150.9048, 0.0000,
  0.0000,    0.0000,    1121.7009, 605.6815,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3187.5734,
  1341.3275, 0.0000,    0.0000,    0.0000,    2618.0036, 1097.1255, 0.0000,    0.0000,    0.0000,
  1162.6290, 581.8705,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3067.1463, 1795.0359, 0.0000,
  0.0000,    0.0000,    2517.5053, 1477.1099, 0.0000,    0.0000,    0.0000,    1124.5057, 713.8157,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2365.8925, 1624.3636, 955.0153,  0.0000,    0.0000,
  1624.3636, 1132.2983, 679.4591,  0.0000,    0.0000,    955.0153,  679.4591,  451.0845,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2072.6170, 1106.6630, 953.4821,  0.0000,    0.0000,    1429.3576, 780.8212,
  680.2683,  0.0000,    0.0000,    857.6527,  504.4325,  454.7356,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1858.6377, 1118.1402, 926.1439,  0.0000,    0.0000,    1286.4770, 787.4950,  660.7377,  0.0000,
  0.0000,    781.5377,  509.4181,  439.6548,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1394.0976, 1031.4745,
  795.1764,  0.0000,    0.0000,    971.5959,  730.1446,  571.8530,  0.0000,    0.0000,    602.4253,
  474.6807,  388.0718,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1572.3759, 1207.9868, 685.7489,  0.0000,
  0.0000,    1093.2424, 848.3727,  496.6399,  0.0000,    0.0000,    672.5553,  532.9719,  342.0346,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1159.9071, 871.2600,  642.4279,  0.0000,    0.0000,    812.6286,
  621.3058,  466.5106,  0.0000,    0.0000,    511.4722,  413.1903,  323.0124,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1266.8436, 812.9338,  672.6836,  0.0000,    0.0000,    886.2750,  580.4145,  484.7257,
  0.0000,    0.0000,    559.3453,  386.3915,  329.4057,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1161.9289,
  750.5933,  707.8343,  0.0000,    0.0000,    814.8402,  536.8566,  508.6839,  0.0000,    0.0000,
  518.4374,  358.6133,  344.3053,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    976.2025,  729.3316,  0.0000,
  0.0000,    0.0000,    684.9796,  520.8724,  0.0000,    0.0000,    0.0000,    431.9705,  346.9360,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1009.4418, 703.7992,  0.0000,    0.0000,    0.0000,
  710.2172,  505.6747,  0.0000,    0.0000,    0.0000,    456.4875,  342.9987,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1311.8922, 1231.6979, 940.6363,  766.4059,  0.0000,    916.1592,  862.8833,
  667.6471,  550.2164,  0.0000,    573.8021,  546.6690,  438.9483,  373.0875,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1161.3674, 1065.4342, 1020.9627, 896.6822,  790.3938,  818.4130,  754.1146,  724.2934,  640.4740,
  568.6159,  529.9186,  493.8129,  477.2036,  429.2279,  387.5181,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    992.4001,  967.1672,
  933.6956,  891.9140,  0.0000,    707.0933,  690.2435,  667.7703,  639.6032,  0.0000,    471.4064,
  461.8766,  449.0205,  432.8219,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    897.8043,  895.7304,  885.9576,  0.0000,
  0.0000,    644.4494,  643.2697,  636.7834,  0.0000,    0.0000,    436.8022,  436.4520,  432.8478,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    790.0257,  797.7901,  0.0000,    0.0000,    0.0000,    571.8432,
  577.3805,  0.0000,    0.0000,    0.0000,    394.3185,  398.0382,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    692.2386,  0.0000,    0.0000,    0.0000,    0.0000,    505.2262,  0.0000,    0.0000,
  0.0000,    0.0000,    353.9178,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    4289.6097,
  1186.3885, 0.0000,    0.0000,    0.0000,    2950.2475, 837.6135,  0.0000,    0.0000,    0.0000,
  1515.3755, 537.9093,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3639.4735, 3045.1620, 1233.0006,
  0.0000,    0.0000,    2485.6310, 2101.0372, 872.2882,  0.0000,    0.0000,    1391.1764, 1154.9423,
  567.2445,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    3069.3037, 2072.7978, 1253.1317, 0.0000,    0.0000,
  2105.7491, 1446.2394, 889.9501,  0.0000,    0.0000,    1221.2152, 860.0465,  587.7222,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1182.0124, 0.0000,    0.0000,    0.0000,    0.0000,    840.8410,  0.0000,
  0.0000,    0.0000,    0.0000,    556.9697,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  3181.4405, 1143.5524, 0.0000,    0.0000,    0.0000,    2178.3229, 814.0637,  0.0000,    0.0000,
  0.0000,    1231.9890, 540.0992,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3032.9183, 1119.3527,
  0.0000,    0.0000,    0.0000,    2074.8807, 796.8844,  0.0000,    0.0000,    0.0000,    1182.9141,
  528.9145,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2950.9303, 1081.5963, 0.0000,    0.0000,
  0.0000,    2018.9224, 770.4895,  0.0000,    0.0000,    0.0000,    1153.2166, 512.0867,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2876.1716, 1094.2695, 0.0000,    0.0000,    0.0000,    1967.8827,
  778.5614,  0.0000,    0.0000,    0.0000,    1125.9127, 514.7308,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2809.6885, 1077.0858, 0.0000,    0.0000,    0.0000,    1922.5226, 762.0033,  0.0000,
  0.0000,    0.0000,    1101.7008, 496.5039,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2113.2076,
  1103.0742, 0.0000,    0.0000,    0.0000,    1458.1969, 784.0479,  0.0000,    0.0000,    0.0000,
  865.0011,  518.0912,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2548.5911, 1030.2577, 0.0000,
  0.0000,    0.0000,    1752.1144, 733.2622,  0.0000,    0.0000,    0.0000,    974.9708,  486.4650,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2440.1762, 1061.3052, 0.0000,    0.0000,    0.0000,
  1683.0549, 753.6872,  0.0000,    0.0000,    0.0000,    940.1178,  495.1913,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2507.3572, 972.3864,  0.0000,    0.0000,    0.0000,    1717.0123, 693.0607,
  0.0000,    0.0000,    0.0000,    993.5143,  461.6481,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2451.1775, 942.6854,  0.0000,    0.0000,    0.0000,    1678.5781, 672.2671,  0.0000,    0.0000,
  0.0000,    972.4302,  448.4531,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2399.2487, 938.1873,
  0.0000,    0.0000,    0.0000,    1643.2139, 668.7656,  0.0000,    0.0000,    0.0000,    953.4036,
  445.6186,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2375.4679, 994.9869,  0.0000,    0.0000,
  0.0000,    1626.3339, 707.3910,  0.0000,    0.0000,    0.0000,    942.3249,  468.6784,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1942.1387, 903.8521,  0.0000,    0.0000,    0.0000,    1339.8149,
  644.8013,  0.0000,    0.0000,    0.0000,    793.1059,  430.6794,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1829.7515, 1323.0311, 900.1084,  0.0000,    0.0000,    1268.9492, 929.1165,  644.7928,
  0.0000,    0.0000,    779.3004,  585.2116,  435.0222,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1627.2670,
  1196.7064, 954.6796,  0.0000,    0.0000,    1134.6407, 844.7234,  682.1282,  0.0000,    0.0000,
  710.4790,  542.5268,  454.5024,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1347.8163, 1062.8100, 861.9972,
  0.0000,    0.0000,    945.4099,  754.6966,  620.2744,  0.0000,    0.0000,    599.1342,  494.4099,
  421.5613,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1356.8533, 1101.1436, 766.6493,  0.0000,    0.0000,
  953.5634,  777.6237,  555.2087,  0.0000,    0.0000,    609.3615,  500.7127,  382.3780,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1202.1044, 905.5554,  708.8779,  0.0000,    0.0000,    849.3817,  649.4216,
  516.1183,  0.0000,    0.0000,    551.6890,  437.1359,  359.3289,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1080.8340, 844.2074,  740.7015,  0.0000,    0.0000,    767.3003,  606.9087,  535.7034,  0.0000,
  0.0000,    504.7716,  410.9617,  366.6745,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    880.9993,  801.9793,
  779.8715,  0.0000,    0.0000,    629.1605,  577.4945,  563.3746,  0.0000,    0.0000,    418.6696,
  392.3386,  385.7720,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    816.7465,  767.6316,  0.0000,    0.0000,
  0.0000,    584.6353,  552.7272,  0.0000,    0.0000,    0.0000,    390.9131,  374.9956,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    832.4222,  724.8642,  0.0000,    0.0000,    0.0000,    596.9445,
  525.1179,  0.0000,    0.0000,    0.0000,    402.0942,  362.0333,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1334.1432, 1313.1378, 985.9871,  848.6422,  0.0000,    935.6299,  922.8166,  703.5558,
  611.0884,  0.0000,    588.4579,  586.4827,  468.3267,  416.4727,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1259.8691,
  1144.5456, 1039.7874, 1009.8313, 919.9685,  888.8756,  812.1311,  742.0502,  722.4614,  661.9108,
  574.8974,  533.7582,  495.0513,  485.4008,  450.8116,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1114.3977, 1083.7333, 1047.3694,
  1004.8393, 0.0000,    793.6701,  773.6203,  749.6258,  721.3882,  0.0000,    527.4831,  517.1837,
  504.4104,  489.0684,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1039.8622, 1036.5660, 1028.0879, 0.0000,    0.0000,
  745.1471,  743.4991,  738.2484,  0.0000,    0.0000,    502.5688,  502.6241,  500.3900,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    934.9280,  945.9470,  0.0000,    0.0000,    0.0000,    675.1842,  683.1977,
  0.0000,    0.0000,    0.0000,    463.1644,  468.7850,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  836.8244,  0.0000,    0.0000,    0.0000,    0.0000,    608.8625,  0.0000,    0.0000,    0.0000,
  0.0000,    423.8939,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3923.8630, 1332.5023,
  0.0000,    0.0000,    0.0000,    2698.0970, 941.3182,  0.0000,    0.0000,    0.0000,    1430.0247,
  605.7876,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3524.6180, 2947.7908, 1353.4487, 0.0000,
  0.0000,    2413.4225, 2035.2098, 958.3613,  0.0000,    0.0000,    1374.9340, 1148.1563, 624.3856,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2997.7722, 1354.5806, 0.0000,    0.0000,    0.0000,    2062.2685,
  963.8486,  0.0000,    0.0000,    0.0000,    1214.2860, 639.1977,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2578.7074, 1629.4376, 0.0000,    0.0000,    0.0000,    1787.1863, 1152.2222, 0.0000,
  0.0000,    0.0000,    1089.5911, 738.6104,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2617.9361,
  1440.7783, 0.0000,    0.0000,    0.0000,    1809.2861, 1026.0397, 0.0000,    0.0000,    0.0000,
  1082.1909, 659.7771,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2531.7373, 1230.1136, 0.0000,
  0.0000,    0.0000,    1749.7379, 877.2823,  0.0000,    0.0000,    0.0000,    1047.7793, 582.4722,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2676.6472, 1175.3725, 0.0000,    0.0000,    0.0000,
  1840.6901, 839.4370,  0.0000,    0.0000,    0.0000,    1079.5998, 560.3237,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2579.0022, 1537.2794, 0.0000,    0.0000,    0.0000,    1774.6391, 1080.9253,
  0.0000,    0.0000,    0.0000,    1045.3553, 675.9532,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1822.7181, 987.8257,  857.6011,  0.0000,    0.0000,    987.8257,  568.6789,  507.5216,  0.0000,
  0.0000,    857.6011,  507.5216,  458.6896,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1638.4938, 998.1224,
  832.1743,  0.0000,    0.0000,    896.7952,  574.4591,  491.3081,  0.0000,    0.0000,    782.3088,
  512.4995,  443.4182,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1233.9095, 922.0660,  717.6632,  0.0000,
  0.0000,    687.1848,  534.0108,  431.3512,  0.0000,    0.0000,    604.1475,  477.8870,  392.0655,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1389.5979, 1072.1935, 621.0438,  0.0000,    0.0000,    768.8428,
  605.3389,  378.6511,  0.0000,    0.0000,    674.0068,  535.3153,  346.0266,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1029.7665, 782.7166,  582.5544,  0.0000,    0.0000,    580.9007,  461.9141,  357.0819,
  0.0000,    0.0000,    513.6197,  416.7152,  326.9477,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1125.3403,
  730.4970,  607.3080,  0.0000,    0.0000,    634.8024,  431.8288,  366.0539,  0.0000,    0.0000,
  561.6169,  389.7673,  332.9103,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1033.8735, 674.9929,  638.4463,
  0.0000,    0.0000,    587.0202,  400.4209,  383.0425,  0.0000,    0.0000,    520.8781,  361.8771,
  347.7992,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    867.0056,  655.4329,  0.0000,    0.0000,    0.0000,
  490.3817,  387.7336,  0.0000,    0.0000,    0.0000,    433.9278,  349.9975,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    900.1154,  635.1370,  0.0000,    0.0000,    0.0000,    515.3861,  381.3405,
  0.0000,    0.0000,    0.0000,    459.0164,  346.4792,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1163.5963, 1095.0419, 842.9594,  691.5997,  0.0000,    652.5654,  619.6537,  492.2291,  414.7814,
  0.0000,    575.8020,  549.0572,  442.2260,  376.8173,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1037.2812, 953.9322,
  915.3455,  806.9968,  714.0953,  596.8919,  554.4107,  534.8274,  478.7355,  430.1818,  533.0732,
  497.2424,  480.7668,  433.0658,  391.5532,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    892.0877,  870.1334,  840.9533,  804.4937,
  0.0000,    526.5426,  515.3541,  500.3168,  481.4071,  0.0000,    475.3821,  465.9289,  453.1570,
  437.0500,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    810.1028,  808.4252,  799.9471,  0.0000,    0.0000,    485.6176,
  485.0856,  480.8308,  0.0000,    0.0000,    441.1513,  440.8392,  437.2712,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    715.7318,  722.7240,  0.0000,    0.0000,    0.0000,    436.3046,  440.4474,  0.0000,
  0.0000,    0.0000,    398.8895,  402.6413,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    629.5230,
  0.0000,    0.0000,    0.0000,    0.0000,    389.9385,  0.0000,    0.0000,    0.0000,    0.0000,
  358.5675,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3674.8556, 1057.7660, 0.0000,
  0.0000,    0.0000,    1819.0406, 607.1951,  0.0000,    0.0000,    0.0000,    1502.0119, 541.1259,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    3160.1776, 2637.6782, 1102.2638, 0.0000,    0.0000,
  1635.3622, 1360.4000, 638.0792,  0.0000,    0.0000,    1384.6011, 1149.7163, 571.0295,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2682.0879, 1821.2145, 1124.0457, 0.0000,    0.0000,    1420.6192, 990.1059,
  658.2098,  0.0000,    0.0000,    1218.3604, 860.7503,  592.2396,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1060.9721, 0.0000,    0.0000,    0.0000,    0.0000,    623.2841,  0.0000,    0.0000,    0.0000,
  0.0000,    561.4468,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2767.9894, 1026.8226,
  0.0000,    0.0000,    0.0000,    1442.9680, 604.1250,  0.0000,    0.0000,    0.0000,    1227.1618,
  544.5203,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2642.0526, 1005.1742, 0.0000,    0.0000,
  0.0000,    1383.2190, 591.5630,  0.0000,    0.0000,    0.0000,    1178.7222, 533.2574,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2571.4964, 971.5644,  0.0000,    0.0000,    0.0000,    1347.7804,
  572.5226,  0.0000,    0.0000,    0.0000,    1149.2501, 516.3573,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2507.0805, 981.8553,  0.0000,    0.0000,    0.0000,    1315.2670, 576.2453,  0.0000,
  0.0000,    0.0000,    1122.1393, 518.8345,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2449.8188,
  963.2715,  0.0000,    0.0000,    0.0000,    1286.4106, 558.2951,  0.0000,    0.0000,    0.0000,
  1098.1031, 499.8637,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1854.4837, 989.5940,  0.0000,
  0.0000,    0.0000,    999.3615,  580.1629,  0.0000,    0.0000,    0.0000,    864.5896,  522.1512,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2211.4907, 925.0730,  0.0000,    0.0000,    0.0000,
  1146.1276, 544.1619,  0.0000,    0.0000,    0.0000,    970.8551,  490.4332,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2119.4908, 950.9922,  0.0000,    0.0000,    0.0000,    1102.5614, 555.3166,
  0.0000,    0.0000,    0.0000,    936.5992,  498.9051,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2190.0272, 873.8994,  0.0000,    0.0000,    0.0000,    1156.8729, 515.8086,  0.0000,    0.0000,
  0.0000,    990.8440,  465.5596,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2141.4202, 847.4869,
  0.0000,    0.0000,    0.0000,    1131.9421, 500.8568,  0.0000,    0.0000,    0.0000,    969.8725,
  452.3068,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2096.6400, 843.2361,  0.0000,    0.0000,
  0.0000,    1109.3035, 497.8395,  0.0000,    0.0000,    0.0000,    950.9799,  449.4035,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2075.3417, 893.1595,  0.0000,    0.0000,    0.0000,    1096.8681,
  524.4245,  0.0000,    0.0000,    0.0000,    939.8169,  472.3967,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1704.0440, 812.8125,  0.0000,    0.0000,    0.0000,    916.2925,  480.8236,  0.0000,
  0.0000,    0.0000,    792.5089,  434.4148,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1616.4737,
  1175.0345, 811.3033,  0.0000,    0.0000,    891.4100,  664.0037,  484.2582,  0.0000,    0.0000,
  780.6270,  587.7889,  439.1688,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1443.1973, 1067.0698, 858.1082,
  0.0000,    0.0000,    808.1066,  612.3192,  507.6612,  0.0000,    0.0000,    712.7902,  545.7275,
  458.5024,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1198.3202, 951.6708,  778.2433,  0.0000,    0.0000,
  679.0458,  554.9737,  468.3741,  0.0000,    0.0000,    601.8801,  498.0917,  425.9507,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1208.4737, 982.3390,  694.3157,  0.0000,    0.0000,    688.9719,  564.8182,
  423.3046,  0.0000,    0.0000,    612.4907,  503.7649,  386.8383,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1074.3491, 815.8051,  643.6645,  0.0000,    0.0000,    620.8894,  486.9432,  396.6219,  0.0000,
  0.0000,    555.2609,  441.3526,  363.8839,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    968.6488,  761.5371,
  669.8428,  0.0000,    0.0000,    566.0462,  457.1062,  406.6513,  0.0000,    0.0000,    508.5899,
  415.1517,  370.8343,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    791.5544,  723.9927,  705.3252,  0.0000,
  0.0000,    468.0246,  436.0158,  427.7857,  0.0000,    0.0000,    422.3535,  396.4686,  390.0863,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    734.6152,  692.7566,  0.0000,    0.0000,    0.0000,    436.4322,
  416.9363,  0.0000,    0.0000,    0.0000,    394.5421,  378.9334,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    749.9824,  656.6420,  0.0000,    0.0000,    0.0000,    447.9663,  400.7170,  0.0000,
  0.0000,    0.0000,    406.0045,  366.2855,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1184.3558,
  1168.2143, 886.0018,  766.6967,  0.0000,    668.3672,  664.1554,  523.4025,  462.4046,  0.0000,
  590.9783,  589.3899,  472.3712,  420.8795,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1124.9617, 1025.5674, 934.8232,
  909.3382,  831.0235,  647.8165,  598.6852,  552.8960,  541.0462,  500.5775,  578.4188,  537.7340,
  499.3611,  489.8962,  455.5132,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1001.0315, 974.7789,  943.4690,  906.7257,  0.0000,
  589.7648,  577.2776,  561.9792,  543.7314,  0.0000,    531.8665,  521.7376,  509.1300,  493.9544,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    937.2036,  934.7359,  927.6574,  0.0000,    0.0000,    559.5643,  559.2512,
  556.3468,  0.0000,    0.0000,    507.3933,  507.5476,  505.4054,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  845.9589,  855.9848,  0.0000,    0.0000,    0.0000,    513.2574,  519.4398,  0.0000,    0.0000,
  0.0000,    468.3290,  474.0194,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    759.8686,  0.0000,
  0.0000,    0.0000,    0.0000,    467.8458,  0.0000,    0.0000,    0.0000,    0.0000,    429.2215,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3377.7348, 1188.5781, 0.0000,    0.0000,
  0.0000,    1702.8592, 683.3907,  0.0000,    0.0000,    0.0000,    1420.1434, 609.5011,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    3070.0206, 2564.3290, 1210.4384, 0.0000,    0.0000,    1607.8178,
  1343.4836, 701.9543,  0.0000,    0.0000,    1370.1849, 1144.7357, 628.6689,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2627.0446, 1216.1834, 0.0000,    0.0000,    0.0000,    1406.1219, 715.0636,  0.0000,
  0.0000,    0.0000,    1212.7510, 644.3806,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2274.8325,
  1452.6448, 0.0000,    0.0000,    0.0000,    1249.0250, 833.6152,  0.0000,    0.0000,    0.0000,
  1091.0589, 743.0278,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2300.9943, 1286.0297, 0.0000,
  0.0000,    0.0000,    1247.3212, 742.7923,  0.0000,    0.0000,    0.0000,    1082.3309, 664.2618,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2225.6807, 1104.7666, 0.0000,    0.0000,    0.0000,
  1207.3349, 651.3700,  0.0000,    0.0000,    0.0000,    1047.9820, 587.4053,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2343.7586, 1056.8235, 0.0000,    0.0000,    0.0000,    1251.9154, 625.7334,
  0.0000,    0.0000,    0.0000,    1078.0658, 565.2830,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2260.0639, 1363.4850, 0.0000,    0.0000,    0.0000,    1210.6981, 768.2883,  0.0000,    0.0000,
  0.0000,    1044.1684, 678.8516,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1475.2500, 906.0801,
  758.7789,  0.0000,    0.0000,    906.0801,  580.5824,  496.1127,  0.0000,    0.0000,    758.7789,
  496.1127,  428.8962,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1114.0924, 837.9849,  656.3774,  0.0000,
  0.0000,    694.2983,  539.3532,  435.5692,  0.0000,    0.0000,    585.8126,  462.6546,  379.2075,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1253.3465, 970.2070,  569.4159,  0.0000,    0.0000,    776.7368,
  611.2764,  382.3225,  0.0000,    0.0000,    653.6028,  519.0845,  334.7174,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    931.7445,  713.6477,  534.6266,  0.0000,    0.0000,    586.8945,  466.5358,  360.5430,
  0.0000,    0.0000,    497.9286,  403.2032,  316.2990,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1018.2915,
  666.2259,  555.7204,  0.0000,    0.0000,    641.4164,  436.1440,  369.6744,  0.0000,    0.0000,
  544.0821,  377.2249,  322.2101,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    936.5528,  615.9759,  583.7653,
  0.0000,    0.0000,    593.1414,  404.4300,  386.8574,  0.0000,    0.0000,    504.5037,  350.2910,
  336.5535,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    784.8188,  597.8528,  0.0000,    0.0000,    0.0000,
  495.4800,  391.6637,  0.0000,    0.0000,    0.0000,    420.8552,  338.8335,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    816.5495,  580.8412,  0.0000,    0.0000,    0.0000,    520.7629,  385.1206,
  0.0000,    0.0000,    0.0000,    444.4932,  335.1312,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1051.8917, 991.4013,  767.2243,  632.3580,  0.0000,    659.2865,  626.0254,  497.1382,  418.8482,
  0.0000,    557.9340,  531.7720,  427.8632,  364.3226,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    941.7792,  867.5475,
  833.2050,  736.4802,  653.4187,  602.9692,  559.9850,  540.1792,  483.4478,  434.3422,  515.7374,
  480.9564,  464.9556,  418.6918,  378.4693,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    813.4345,  793.8771,  767.8415,  735.2812,
  0.0000,    531.7424,  520.4182,  505.2035,  486.0786,  0.0000,    459.5750,  450.4159,  438.0410,
  422.4320,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    740.6211,  739.2097,  731.6741,  0.0000,    0.0000,    490.3206,
  489.7750,  485.4685,  0.0000,    0.0000,    426.4202,  426.1118,  422.6552,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    656.2276,  662.6068,  0.0000,    0.0000,    0.0000,    440.4599,  444.6402,  0.0000,
  0.0000,    0.0000,    385.5923,  389.2112,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    578.7876,
  0.0000,    0.0000,    0.0000,    0.0000,    393.6121,  0.0000,    0.0000,    0.0000,    0.0000,
  346.7063,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3256.3633, 959.7908,  0.0000,
  0.0000,    0.0000,    1826.4461, 613.2010,  0.0000,    0.0000,    0.0000,    1473.7970, 524.1562,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2819.5147, 2352.1278, 1001.6660, 0.0000,    0.0000,
  1650.9334, 1369.3825, 644.4515,  0.0000,    0.0000,    1349.3970, 1122.7672, 552.6718,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2401.9326, 1637.9243, 1023.5000, 0.0000,    0.0000,    1434.8956, 997.9222,
  664.7346,  0.0000,    0.0000,    1184.6610, 836.5504,  572.6815,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  966.6201,  0.0000,    0.0000,    0.0000,    0.0000,    629.4977,  0.0000,    0.0000,    0.0000,
  0.0000,    543.0506,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2472.6905, 935.7467,
  0.0000,    0.0000,    0.0000,    1456.5113, 610.1366,  0.0000,    0.0000,    0.0000,    1195.2654,
  526.6759,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2361.6974, 916.0648,  0.0000,    0.0000,
  0.0000,    1397.0298, 597.4603,  0.0000,    0.0000,    0.0000,    1147.4757, 515.7797,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2299.0481, 885.6282,  0.0000,    0.0000,    0.0000,    1361.3178,
  578.2213,  0.0000,    0.0000,    0.0000,    1118.6278, 499.4343,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2241.8085, 894.3917,  0.0000,    0.0000,    0.0000,    1328.5415, 581.9305,  0.0000,
  0.0000,    0.0000,    1092.1025, 501.9170,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2190.9387,
  875.5931,  0.0000,    0.0000,    0.0000,    1299.4488, 563.9816,  0.0000,    0.0000,    0.0000,
  1068.5805, 483.8542,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1665.4372, 901.2747,  0.0000,
  0.0000,    0.0000,    1009.4419, 585.9401,  0.0000,    0.0000,    0.0000,    840.0098,  505.0620,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1973.5648, 843.0014,  0.0000,    0.0000,    0.0000,
  1155.3947, 549.5950,  0.0000,    0.0000,    0.0000,    947.3214,  474.3613,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1892.7858, 865.5324,  0.0000,    0.0000,    0.0000,    1110.6913, 560.7912,
  0.0000,    0.0000,    0.0000,    913.6348,  482.7380,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1960.5194, 796.8327,  0.0000,    0.0000,    0.0000,    1168.8393, 520.9380,  0.0000,    0.0000,
  0.0000,    963.5525,  450.2413,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1917.2203, 772.9187,
  0.0000,    0.0000,    0.0000,    1143.6857, 505.8297,  0.0000,    0.0000,    0.0000,    943.0626,
  437.4079,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1877.4174, 768.9101,  0.0000,    0.0000,
  0.0000,    1120.8436, 502.7808,  0.0000,    0.0000,    0.0000,    924.5841,  434.6007,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1858.0353, 813.6798,  0.0000,    0.0000,    0.0000,    1108.2791,
  529.6376,  0.0000,    0.0000,    0.0000,    913.7740,  456.7992,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1529.9721, 741.4183,  0.0000,    0.0000,    0.0000,    925.2266,  485.5842,  0.0000,
  0.0000,    0.0000,    769.7801,  420.0614,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1457.2492,
  1063.4756, 741.1601,  0.0000,    0.0000,    900.6808,  670.4019,  488.9632,  0.0000,    0.0000,
  756.6313,  569.5935,  424.5140,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1304.3213, 968.2344,  782.6849,
  0.0000,    0.0000,    816.4974,  618.3328,  512.5695,  0.0000,    0.0000,    690.3939,  528.5265,
  443.5425,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1085.0878, 865.8895,  711.9449,  0.0000,    0.0000,
  685.9856,  560.4734,  472.9418,  0.0000,    0.0000,    583.0888,  482.1480,  411.9567,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1095.4282, 891.6575,  636.5901,  0.0000,    0.0000,    696.0040,  570.4594,
  427.4024,  0.0000,    0.0000,    593.0872,  487.9361,  374.1779,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  976.0842,  745.2646,  591.2478,  0.0000,    0.0000,    627.2065,  491.7044,  400.4358,  0.0000,
  0.0000,    537.4630,  426.9773,  352.0085,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    881.7101,  696.3562,
  613.6915,  0.0000,    0.0000,    571.7793,  461.6166,  410.6367,  0.0000,    0.0000,    492.1917,
  401.6831,  358.9272,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    721.9340,  662.4090,  646.1200,  0.0000,
  0.0000,    472.7643,  440.3304,  431.9942,  0.0000,    0.0000,    408.9156,  383.6596,  377.4280,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    670.5517,  633.7593,  0.0000,    0.0000,    0.0000,    440.8597,
  421.0958,  0.0000,    0.0000,    0.0000,    382.0500,  366.8070,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    685.2385,  602.1863,  0.0000,    0.0000,    0.0000,    452.4761,  404.6484,  0.0000,
  0.0000,    0.0000,    392.9405,  354.3780,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1071.6858,
  1058.4151, 807.9821,  701.6905,  0.0000,    675.1518,  670.9256,  528.6320,  466.9543,  0.0000,
  573.0274,  571.1344,  457.0893,  407.0677,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1021.4733, 933.3741,  852.6898,
  830.2965,  760.4022,  654.4451,  604.7275,  558.3930,  546.3988,  505.4645,  559.9755,  520.3442,
  483.0386,  473.7746,  440.4244,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    912.4820,  889.3363,  861.6243,  829.0262,  0.0000,
  595.6640,  583.0094,  567.5150,  549.0417,  0.0000,    514.4452,  504.5697,  492.3013,  477.5480,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    856.2398,  854.2884,  848.1665,  0.0000,    0.0000,    565.0648,  564.7260,
  561.7704,  0.0000,    0.0000,    490.6394,  490.7521,  488.6493,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  775.0077,  784.2171,  0.0000,    0.0000,    0.0000,    518.2124,  524.4449,  0.0000,    0.0000,
  0.0000,    452.8196,  458.3010,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    697.9075,  0.0000,
  0.0000,    0.0000,    0.0000,    472.3058,  0.0000,    0.0000,    0.0000,    0.0000,    415.0605,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    3001.2009, 1078.7813, 0.0000,    0.0000,
  0.0000,    1712.7050, 690.1339,  0.0000,    0.0000,    0.0000,    1390.4637, 590.3080,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2744.2675, 2292.2709, 1100.2859, 0.0000,    0.0000,    1623.5376,
  1353.9176, 708.9273,  0.0000,    0.0000,    1333.9556, 1116.0377, 608.4297,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2356.7083, 1108.1864, 0.0000,    0.0000,    0.0000,    1420.3983, 722.1816,  0.0000,
  0.0000,    0.0000,    1178.2143, 623.2027,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2049.2299,
  1318.1488, 0.0000,    0.0000,    0.0000,    1261.9867, 841.4556,  0.0000,    0.0000,    0.0000,
  1058.2704, 719.7804,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2068.4111, 1168.3462, 0.0000,
  0.0000,    0.0000,    1260.0147, 748.9566,  0.0000,    0.0000,    0.0000,    1051.1231, 643.7098,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2000.9439, 1007.1282, 0.0000,    0.0000,    0.0000,
  1219.7064, 657.8233,  0.0000,    0.0000,    0.0000,    1017.7328, 568.4114,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2101.8417, 964.1266,  0.0000,    0.0000,    0.0000,    1264.8378, 631.9749,
  0.0000,    0.0000,    0.0000,    1048.1038, 546.9287,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2027.7440, 1233.4617, 0.0000,    0.0000,    0.0000,    1223.2638, 775.5180,  0.0000,    0.0000,
  0.0000,    1014.8828, 658.5955,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    845.8972,  643.4721,
  509.7424,  0.0000,    0.0000,    643.4721,  502.0073,  407.0659,  0.0000,    0.0000,    509.7424,
  407.0659,  337.1075,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    949.6490,  739.7915,  444.3471,  0.0000,
  0.0000,    719.3659,  567.7670,  357.9634,  0.0000,    0.0000,    567.4441,  453.7197,  298.8508,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    710.2837,  551.1240,  417.9889,  0.0000,    0.0000,    544.8075,
  435.1062,  337.8186,  0.0000,    0.0000,    435.0888,  356.6338,  282.8832,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    775.8353,  514.9128,  432.2782,  0.0000,    0.0000,    595.1503,  406.9338,  345.7600,
  0.0000,    0.0000,    475.0273,  333.9387,  286.9340,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    714.9495,
  476.7090,  453.3284,  0.0000,    0.0000,    550.7557,  377.5535,  361.5781,  0.0000,    0.0000,
  441.3319,  310.5005,  299.2251,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    599.0530,  462.3383,  0.0000,
  0.0000,    0.0000,    460.2367,  365.5261,  0.0000,    0.0000,    0.0000,    368.2898,  300.1493,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    624.9506,  450.9776,  0.0000,    0.0000,    0.0000,
  484.0286,  359.9059,  0.0000,    0.0000,    0.0000,    389.8300,  297.8478,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    799.9994,  755.8918,  590.4050,  490.5720,  0.0000,    611.3911,  581.0549,
  463.0670,  391.2722,  0.0000,    486.2116,  464.5679,  377.1375,  323.4882,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  721.2906,  666.4197,  641.0643,  569.2766,  507.4919,  560.5104,  521.1563,  503.0236,  450.9840,
  405.9028,  452.4616,  423.1570,  409.6963,  370.5143,  336.3592,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    627.6849,  613.2470,
  593.9624,  569.7978,  0.0000,    495.6948,  485.3374,  471.3990,  453.8578,  0.0000,    406.0312,
  398.3318,  387.8818,  374.6663,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    574.2932,  573.3700,  567.8341,  0.0000,
  0.0000,    457.9302,  457.4717,  453.5417,  0.0000,    0.0000,    378.4312,  378.2579,  375.3725,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    511.6772,  516.5932,  0.0000,    0.0000,    0.0000,    412.2275,
  416.1207,  0.0000,    0.0000,    0.0000,    343.9096,  347.1000,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    453.7998,  0.0000,    0.0000,    0.0000,    0.0000,    369.1531,  0.0000,    0.0000,
  0.0000,    0.0000,    310.7442,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2398.7520,
  735.1498,  0.0000,    0.0000,    0.0000,    1687.7490, 570.2621,  0.0000,    0.0000,    0.0000,
  1239.1934, 460.1263,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2098.4813, 1750.3829, 768.8382,
  0.0000,    0.0000,    1520.1317, 1266.0803, 599.6614,  0.0000,    0.0000,    1148.5106, 956.0229,
  486.0298,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1798.1970, 1235.6226, 787.9045,  0.0000,    0.0000,
  1323.2583, 925.8359,  619.0974,  0.0000,    0.0000,    1015.1154, 723.2437,  504.8956,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    745.1176,  0.0000,    0.0000,    0.0000,    0.0000,    586.6430,  0.0000,
  0.0000,    0.0000,    0.0000,    479.4247,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1844.0715, 721.6673,  0.0000,    0.0000,    0.0000,    1342.8116, 568.7148,  0.0000,    0.0000,
  0.0000,    1019.8084, 465.1818,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1763.1139, 706.5573,
  0.0000,    0.0000,    0.0000,    1287.2763, 556.9066,  0.0000,    0.0000,    0.0000,    980.1462,
  455.5995,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1716.8038, 683.3681,  0.0000,    0.0000,
  0.0000,    1254.4039, 539.0640,  0.0000,    0.0000,    0.0000,    955.7891,  441.3364,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1674.4360, 689.3091,  0.0000,    0.0000,    0.0000,    1224.2314,
  542.3803,  0.0000,    0.0000,    0.0000,    933.3543,  443.0547,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1636.7956, 672.4914,  0.0000,    0.0000,    0.0000,    1197.4564, 524.9085,  0.0000,
  0.0000,    0.0000,    913.4679,  425.7815,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1253.0730,
  694.2958,  0.0000,    0.0000,    0.0000,    932.8332,  545.9255,  0.0000,    0.0000,    0.0000,
  723.9342,  445.6125,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1470.5265, 650.1095,  0.0000,
  0.0000,    0.0000,    1066.7077, 512.2607,  0.0000,    0.0000,    0.0000,    807.7328,  418.9542,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1411.7363, 666.0895,  0.0000,    0.0000,    0.0000,
  1027.1026, 522.4406,  0.0000,    0.0000,    0.0000,    779.9682,  425.5550,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1466.8017, 615.1052,  0.0000,    0.0000,    0.0000,    1077.4205, 485.7214,
  0.0000,    0.0000,    0.0000,    825.0243,  397.9983,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1434.6130, 596.8707,  0.0000,    0.0000,    0.0000,    1054.2484, 471.7011,  0.0000,    0.0000,
  0.0000,    807.5992,  386.7854,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1405.1352, 593.5778,
  0.0000,    0.0000,    0.0000,    1033.2364, 468.8041,  0.0000,    0.0000,    0.0000,    791.9602,
  384.1823,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1390.2059, 626.9602,  0.0000,    0.0000,
  0.0000,    1021.5311, 493.4814,  0.0000,    0.0000,    0.0000,    782.4179,  403.0686,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1150.1604, 572.6625,  0.0000,    0.0000,    0.0000,    855.2457,
  452.8490,  0.0000,    0.0000,    0.0000,    662.6977,  371.5016,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1102.5669, 810.6552,  573.9237,  0.0000,    0.0000,    833.4523,  622.6203,  456.4149,
  0.0000,    0.0000,    655.7541,  497.5872,  376.2853,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    991.1657,
  741.4202,  604.7166,  0.0000,    0.0000,    756.7532,  575.0447,  478.1928,  0.0000,    0.0000,
  601.0596,  463.7843,  392.4448,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    827.8625,  666.2938,  553.0964,
  0.0000,    0.0000,    636.9077,  522.0897,  442.0491,  0.0000,    0.0000,    509.8157,  425.0630,
  366.3303,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    837.0708,  683.3399,  496.7319,  0.0000,    0.0000,
  646.5495,  530.6415,  400.1567,  0.0000,    0.0000,    519.3135,  428.5383,  334.0552,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    748.9418,  577.5839,  463.0215,  0.0000,    0.0000,    583.5257,  459.2650,
  375.4196,  0.0000,    0.0000,    472.4957,  378.8885,  315.2578,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  678.8718,  540.7615,  478.5044,  0.0000,    0.0000,    532.6579,  431.4510,  384.4194,  0.0000,
  0.0000,    434.1316,  357.1156,  320.3109,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    558.2389,  515.0442,
  503.4771,  0.0000,    0.0000,    441.1961,  411.7628,  404.2779,  0.0000,    0.0000,    362.2168,
  341.4967,  336.5858,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    519.4100,  492.8290,  0.0000,    0.0000,
  0.0000,    411.7136,  393.8195,  0.0000,    0.0000,    0.0000,    338.9881,  326.5738,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    531.4562,  470.1749,  0.0000,    0.0000,    0.0000,    422.7191,
  378.9707,  0.0000,    0.0000,    0.0000,    348.9752,  316.5633,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    817.1388,  808.5578,  624.2338,  545.5653,  0.0000,    626.9326,  623.3449,  493.1464,
  436.6063,  0.0000,    500.8333,  500.0588,  404.4518,  362.2260,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    782.9906,
  718.3231,  658.8046,  642.6165,  590.7654,  608.6620,  563.2632,  520.8778,  509.9907,  472.4503,
  491.8144,  458.7239,  427.3690,  419.8126,  391.5834,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    704.0713,  687.2609,  666.9990,
  643.0649,  0.0000,    555.3255,  543.8367,  529.7234,  512.8620,  0.0000,    454.5781,  446.4655,
  436.2842,  423.9671,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    663.3608,  662.2437,  657.9652,  0.0000,    0.0000,
  527.5997,  527.3975,  524.7742,  0.0000,    0.0000,    435.1405,  435.4646,  433.8677,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    603.5186,  610.6965,  0.0000,    0.0000,    0.0000,    484.7890,  490.6173,
  0.0000,    0.0000,    0.0000,    403.4489,  408.3283,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  546.1762,  0.0000,    0.0000,    0.0000,    0.0000,    442.6674,  0.0000,    0.0000,    0.0000,
  0.0000,    371.4277,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2220.8404, 826.6191,
  0.0000,    0.0000,    0.0000,    1581.5449, 641.8884,  0.0000,    0.0000,    0.0000,    1175.8873,
  518.3775,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2048.8350, 1712.6002, 844.9714,  0.0000,
  0.0000,    1496.2077, 1251.5281, 659.7925,  0.0000,    0.0000,    1139.5556, 954.6301,  535.3296,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1769.2538, 854.3876,  0.0000,    0.0000,    0.0000,    1311.2088,
  673.0352,  0.0000,    0.0000,    0.0000,    1012.7341, 550.2508,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1549.1780, 1009.5160, 0.0000,    0.0000,    0.0000,    1167.6309, 783.1123,  0.0000,
  0.0000,    0.0000,    916.5263,  631.7419,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1558.7481,
  896.8839,  0.0000,    0.0000,    0.0000,    1164.9288, 698.9235,  0.0000,    0.0000,    0.0000,
  907.4304,  566.3773,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1508.2494, 777.5767,  0.0000,
  0.0000,    0.0000,    1127.6927, 613.5516,  0.0000,    0.0000,    0.0000,    878.8304,  502.6517,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1577.8736, 745.3354,  0.0000,    0.0000,    0.0000,
  1167.6383, 589.6594,  0.0000,    0.0000,    0.0000,    901.0470,  484.2162,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1523.3742, 940.3177,  0.0000,    0.0000,    0.0000,    1129.4830, 720.8691,
  0.0000,    0.0000,    0.0000,    873.1869,  575.6198,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1067.0169, 829.2408,  493.7430,  0.0000,    0.0000,    829.2408,  649.7143,  397.0367,  0.0000,
  0.0000,    493.7430,  397.0367,  265.8654,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    796.1951,  614.8185,
  464.1239,  0.0000,    0.0000,    623.1386,  488.3264,  374.0345,  0.0000,    0.0000,    380.5730,
  314.9171,  252.0075,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    869.8962,  574.2456,  480.9081,  0.0000,
  0.0000,    680.0524,  456.5618,  385.2595,  0.0000,    0.0000,    415.1463,  295.1012,  254.7749,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    801.0442,  531.3700,  504.6607,  0.0000,    0.0000,    627.5810,
  423.1279,  403.4188,  0.0000,    0.0000,    386.2986,  274.6918,  265.3352,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    671.1717,  515.4953,  0.0000,    0.0000,    0.0000,    526.0977,  410.0667,  0.0000,
  0.0000,    0.0000,    322.5821,  265.4033,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    699.5382,
  502.1168,  0.0000,    0.0000,    0.0000,    549.6338,  401.2382,  0.0000,    0.0000,    0.0000,
  341.9237,  264.0201,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    897.6451,  847.3557,  659.5747,
  546.3930,  0.0000,    700.4229,  663.0380,  521.6978,  436.2161,  0.0000,    424.3145,  406.2117,
  332.1088,  286.5085,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    807.2358,  744.9993,  716.2239,  634.9209,  565.0031,
  634.7831,  587.9355,  566.2902,  504.7650,  451.7317,  396.8920,  372.0410,  360.6378,  327.2637,
  298.1122,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    700.5163,  684.1292,  662.2699,  634.8991,  0.0000,    555.7794,  543.4822,
  527.0000,  506.2976,  0.0000,    358.1519,  351.6390,  342.7635,  331.5119,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  639.7465,  638.6462,  632.3502,  0.0000,    0.0000,    510.5682,  509.8781,  505.1830,  0.0000,
  0.0000,    335.0059,  334.9230,  332.4971,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    568.7909,  574.2805,
  0.0000,    0.0000,    0.0000,    456.9707,  461.3223,  0.0000,    0.0000,    0.0000,    305.6667,
  308.4743,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    503.3811,  0.0000,    0.0000,    0.0000,
  0.0000,    407.0970,  0.0000,    0.0000,    0.0000,    0.0000,    277.2771,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    2726.0486, 822.5829,  0.0000,    0.0000,    0.0000,    2068.8557,
  647.6686,  0.0000,    0.0000,    0.0000,    1053.7818, 403.9077,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    2373.9131, 1980.9508, 859.6392,  0.0000,    0.0000,    1811.0626, 1516.2134, 678.1232,
  0.0000,    0.0000,    984.1861,  820.4174,  427.1818,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2029.6163,
  1390.9989, 880.0314,  0.0000,    0.0000,    1557.0674, 1078.7908, 696.3752,  0.0000,    0.0000,
  874.2449,  627.7003,  444.5757,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    831.8360,  0.0000,    0.0000,
  0.0000,    0.0000,    659.2348,  0.0000,    0.0000,    0.0000,    0.0000,    422.6628,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    2084.5975, 805.5111,  0.0000,    0.0000,    0.0000,
  1593.6331, 638.7376,  0.0000,    0.0000,    0.0000,    875.5927,  410.2593,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1992.1534, 788.6151,  0.0000,    0.0000,    0.0000,    1523.8714, 625.3966,
  0.0000,    0.0000,    0.0000,    842.1651,  401.8371,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1939.6215, 762.6134,  0.0000,    0.0000,    0.0000,    1483.9817, 605.0829,  0.0000,    0.0000,
  0.0000,    821.4043,  389.3842,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1891.5883, 769.5990,
  0.0000,    0.0000,    0.0000,    1447.4665, 609.8655,  0.0000,    0.0000,    0.0000,    802.2571,
  390.5841,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1848.9097, 751.7567,  0.0000,    0.0000,
  0.0000,    1415.0358, 593.2386,  0.0000,    0.0000,    0.0000,    785.2898,  374.4473,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1411.6759, 775.2973,  0.0000,    0.0000,    0.0000,    1088.9839,
  613.9817,  0.0000,    0.0000,    0.0000,    626.3824,  392.6667,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1663.1347, 725.6560,  0.0000,    0.0000,    0.0000,    1272.7235, 575.3515,  0.0000,
  0.0000,    0.0000,    693.6613,  369.4767,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1596.2074,
  744.0872,  0.0000,    0.0000,    0.0000,    1223.2739, 588.6854,  0.0000,    0.0000,    0.0000,
  670.5114,  374.7726,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1655.9466, 686.3381,  0.0000,
  0.0000,    0.0000,    1268.9174, 544.7906,  0.0000,    0.0000,    0.0000,    710.0771,  351.2333,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1619.5186, 665.8997,  0.0000,    0.0000,    0.0000,
  1241.1151, 528.8006,  0.0000,    0.0000,    0.0000,    695.1436,  341.4299,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1586.1100, 662.3109,  0.0000,    0.0000,    0.0000,    1215.7298, 525.7481,
  0.0000,    0.0000,    0.0000,    681.7920,  339.0464,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1569.4426, 700.0676,  0.0000,    0.0000,    0.0000,    1202.5314, 554.4782,  0.0000,    0.0000,
  0.0000,    673.3797,  355.1823,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1296.2701, 638.8488,
  0.0000,    0.0000,    0.0000,    998.8614,  507.4383,  0.0000,    0.0000,    0.0000,    572.8558,
  327.9709,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1239.5201, 908.8421,  639.6388,  0.0000,
  0.0000,    961.3192,  711.7424,  509.6654,  0.0000,    0.0000,    569.6644,  435.1558,  332.7662,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1112.4511, 829.7617,  674.5116,  0.0000,    0.0000,    867.0054,
  653.0406,  536.2636,  0.0000,    0.0000,    524.0213,  407.0101,  346.6274,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    927.7407,  744.2951,  615.6258,  0.0000,    0.0000,    726.7066,  588.9330,  492.4594,
  0.0000,    0.0000,    446.0838,  374.3879,  324.8319,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    937.5301,
  764.5015,  551.9675,  0.0000,    0.0000,    735.5724,  602.1357,  443.8279,  0.0000,    0.0000,
  454.8860,  376.3463,  297.1616,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    837.5275,  643.4864,  513.8061,
  0.0000,    0.0000,    660.1870,  513.2993,  414.8990,  0.0000,    0.0000,    415.1950,  335.4372,
  281.1527,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    758.1834,  601.9936,  531.8513,  0.0000,    0.0000,
  600.0274,  481.2881,  427.3045,  0.0000,    0.0000,    382.4974,  316.6480,  284.8943,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    622.4222,  573.0904,  559.7588,  0.0000,    0.0000,    495.1176,  458.8333,
  449.2979,  0.0000,    0.0000,    320.2724,  303.0984,  299.1785,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  578.7461,  548.3376,  0.0000,    0.0000,    0.0000,    461.3026,  439.0720,  0.0000,    0.0000,
  0.0000,    300.1539,  289.9329,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    591.9216,  522.3659,
  0.0000,    0.0000,    0.0000,    472.4233,  420.2161,  0.0000,    0.0000,    0.0000,    309.1950,
  281.7677,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    915.9493,  905.6928,  696.2987,  607.1105,
  0.0000,    717.2229,  710.5561,  553.2924,  485.9637,  0.0000,    438.2248,  438.1048,  357.2790,
  321.3971,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    875.9582,  802.4242,  734.8703,  716.3526,  657.6194,  689.6435,
  634.6944,  583.9347,  570.3551,  525.9403,  431.8700,  404.0065,  377.4633,  371.2264,  347.1934,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    785.7517,  766.5586,  743.4824,  716.2664,  0.0000,    623.3539,  609.2320,  592.1062,
  571.7958,  0.0000,    401.0700,  394.3395,  385.8174,  375.4533,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    739.1957,
  737.7893,  732.8299,  0.0000,    0.0000,    589.2725,  588.5768,  585.1227,  0.0000,    0.0000,
  385.0417,  385.4828,  384.2563,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    671.2092,  679.1913,  0.0000,
  0.0000,    0.0000,    538.3747,  544.7930,  0.0000,    0.0000,    0.0000,    358.3106,  362.6374,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    606.2881,  0.0000,    0.0000,    0.0000,    0.0000,
  489.1862,  0.0000,    0.0000,    0.0000,    0.0000,    331.0301,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    2518.9457, 924.7992,  0.0000,    0.0000,    0.0000,    1918.4029, 728.4795,
  0.0000,    0.0000,    0.0000,    1004.0757, 455.1575,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  2314.9349, 1934.9917, 944.5755,  0.0000,    0.0000,    1771.5639, 1485.8293, 745.6343,  0.0000,
  0.0000,    979.2530,  821.8739,  470.6961,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1994.8729, 953.7682,
  0.0000,    0.0000,    0.0000,    1534.6792, 756.0091,  0.0000,    0.0000,    0.0000,    874.2843,
  485.1384,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1742.1202, 1129.8359, 0.0000,    0.0000,
  0.0000,    1350.2400, 889.7324,  0.0000,    0.0000,    0.0000,    795.9004,  554.5883,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1754.9706, 1003.0323, 0.0000,    0.0000,    0.0000,    1356.0504,
  792.7535,  0.0000,    0.0000,    0.0000,    786.1896,  498.3202,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1697.9484, 867.5508,  0.0000,    0.0000,    0.0000,    1312.2121, 688.9511,  0.0000,
  0.0000,    0.0000,    761.5579,  443.8041,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1779.0323,
  831.1709,  0.0000,    0.0000,    0.0000,    1368.6610, 660.9505,  0.0000,    0.0000,    0.0000,
  778.1249,  427.9090,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1717.1041, 1054.1841, 0.0000,
  0.0000,    0.0000,    1321.9594, 826.0448,  0.0000,    0.0000,    0.0000,    754.5169,  503.7865,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    598.1988,  468.5695,  358.4840,  0.0000,    0.0000,
  468.5695,  379.2655,  297.6676,  0.0000,    0.0000,    358.4840,  297.6676,  239.0071,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    653.1775,  438.0426,  369.4328,  0.0000,    0.0000,    511.8315,  354.9282,
  303.2934,  0.0000,    0.0000,    390.8937,  279.0333,  241.3497,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  602.7956,  405.9398,  386.9728,  0.0000,    0.0000,    474.6369,  329.6826,  316.7499,  0.0000,
  0.0000,    363.9513,  259.8584,  251.2231,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    505.0269,  393.5088,
  0.0000,    0.0000,    0.0000,    396.2742,  318.9665,  0.0000,    0.0000,    0.0000,    304.0550,
  251.0367,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    527.9387,  384.9436,  0.0000,    0.0000,
  0.0000,    418.2579,  315.3365,  0.0000,    0.0000,    0.0000,    322.4084,  249.9360,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    672.6516,  636.7480,  500.7277,  418.4851,  0.0000,    524.8236,
  500.1628,  402.3825,  342.6308,  0.0000,    399.3109,  382.5457,  313.5888,  271.1133,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    609.6152,  564.4589,  543.6104,  484.3486,  433.2544,  484.8855,  452.1682,  437.1184,
  393.6270,  355.8286,  374.1870,  351.0591,  340.4508,  309.3410,  282.1480,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    533.3804,
  521.5071,  505.6089,  485.6592,  0.0000,    431.9865,  423.3751,  411.7430,  397.0742,  0.0000,
  338.3541,  332.2995,  324.0357,  313.5500,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    489.6956,  489.0100,  484.4740,
  0.0000,    0.0000,    400.8319,  400.5365,  397.2874,  0.0000,    0.0000,    316.9123,  316.8578,
  314.6082,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    437.9992,  442.1710,  0.0000,    0.0000,    0.0000,
  362.5374,  365.9282,  0.0000,    0.0000,    0.0000,    289.6001,  292.2483,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    389.9532,  0.0000,    0.0000,    0.0000,    0.0000,    326.1157,  0.0000,
  0.0000,    0.0000,    0.0000,    263.1051,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1968.3066, 621.1968,  0.0000,    0.0000,    0.0000,    1387.1242, 492.8301,  0.0000,    0.0000,
  0.0000,    982.3016,  380.9010,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1735.4827, 1447.6221,
  650.7128,  0.0000,    0.0000,    1270.1002, 1056.4422, 519.5738,  0.0000,    0.0000,    919.9110,
  767.3168,  403.0280,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1493.8895, 1032.5864, 668.2859,  0.0000,
  0.0000,    1114.5962, 786.5886,  538.1720,  0.0000,    0.0000,    818.6281,  589.4768,  419.6916,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    632.6639,  0.0000,    0.0000,    0.0000,    0.0000,    510.5864,
  0.0000,    0.0000,    0.0000,    0.0000,    399.2351,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1527.6056, 612.9682,  0.0000,    0.0000,    0.0000,    1125.1127, 495.2056,  0.0000,
  0.0000,    0.0000,    819.0425,  387.5759,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1461.6458,
  600.1777,  0.0000,    0.0000,    0.0000,    1080.1628, 484.9704,  0.0000,    0.0000,    0.0000,
  787.9846,  379.6309,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1423.5531, 580.6563,  0.0000,
  0.0000,    0.0000,    1052.9974, 469.6134,  0.0000,    0.0000,    0.0000,    768.6159,  367.9133,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1388.6668, 585.2065,  0.0000,    0.0000,    0.0000,
  1028.0158, 471.9441,  0.0000,    0.0000,    0.0000,    750.7432,  368.9368,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1357.6810, 569.5060,  0.0000,    0.0000,    0.0000,    1005.8586, 455.1389,
  0.0000,    0.0000,    0.0000,    734.9066,  353.3996,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1045.0617, 589.2413,  0.0000,    0.0000,    0.0000,    790.5176,  474.8590,  0.0000,    0.0000,
  0.0000,    587.6156,  370.8350,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1217.3511, 552.1793,
  0.0000,    0.0000,    0.0000,    891.8764,  446.0410,  0.0000,    0.0000,    0.0000,    648.9904,
  349.0479,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1169.6785, 564.8984,  0.0000,    0.0000,
  0.0000,    859.9729,  453.9296,  0.0000,    0.0000,    0.0000,    627.5659,  353.8700,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1218.0651, 522.8164,  0.0000,    0.0000,    0.0000,    906.9214,
  423.3418,  0.0000,    0.0000,    0.0000,    664.7955,  331.8942,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1191.4716, 507.4568,  0.0000,    0.0000,    0.0000,    887.6202,  411.2731,  0.0000,
  0.0000,    0.0000,    650.8338,  322.6630,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1167.1878,
  504.5373,  0.0000,    0.0000,    0.0000,    870.2063,  408.6237,  0.0000,    0.0000,    0.0000,
  638.3682,  320.3788,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1154.5209, 532.1955,  0.0000,
  0.0000,    0.0000,    860.0345,  429.4167,  0.0000,    0.0000,    0.0000,    630.4213,  335.4266,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    958.6992,  486.9465,  0.0000,    0.0000,    0.0000,
  724.2904,  394.9305,  0.0000,    0.0000,    0.0000,    537.1925,  309.9502,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    923.4198,  682.6807,  488.8736,  0.0000,    0.0000,    711.4779,  535.5402,
  398.9804,  0.0000,    0.0000,    535.1160,  409.8023,  314.6598,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  832.8191,  626.4527,  514.2669,  0.0000,    0.0000,    649.1471,  496.9704,  416.9904,  0.0000,
  0.0000,    492.9016,  383.8019,  327.6381,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    697.6346,  564.9808,
  472.2143,  0.0000,    0.0000,    548.4212,  453.4263,  387.4171,  0.0000,    0.0000,    420.1970,
  353.5293,  307.5001,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    706.2358,  577.7356,  425.4154,  0.0000,
  0.0000,    557.7561,  458.9491,  352.0200,  0.0000,    0.0000,    428.6524,  355.0036,  281.6608,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    633.7886,  492.3082,  397.5557,  0.0000,    0.0000,    505.4933,
  401.6241,  331.2590,  0.0000,    0.0000,    391.7261,  317.3701,  266.7522,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    575.9452,  461.5865,  409.6105,  0.0000,    0.0000,    462.9870,  377.9550,  337.8747,
  0.0000,    0.0000,    361.2481,  299.7835,  270.0538,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    475.0715,
  440.0378,  430.8148,  0.0000,    0.0000,    384.9146,  361.0935,  355.2228,  0.0000,    0.0000,
  302.9243,  287.0770,  283.5165,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    442.5921,  421.1084,  0.0000,
  0.0000,    0.0000,    359.7427,  345.3564,  0.0000,    0.0000,    0.0000,    284.0633,  274.6562,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    453.2802,  402.9111,  0.0000,    0.0000,    0.0000,
  369.8952,  333.5982,  0.0000,    0.0000,    0.0000,    292.6744,  267.1668,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    688.3361,  682.0711,  530.9279,  466.1298,  0.0000,    539.2982,  537.4115,
  430.0496,  383.0038,  0.0000,    412.8587,  412.9246,  337.7782,  304.3576,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  662.1675,  609.2472,  560.3504,  547.2593,  504.4697,  526.7738,  489.4453,  454.3352,  445.5869,
  414.2303,  407.3744,  381.5077,  356.8192,  351.0719,  328.6731,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    598.2792,  584.6336,
  568.0989,  548.5041,  0.0000,    483.8143,  474.4987,  462.9393,  449.0481,  0.0000,    378.9740,
  372.7610,  364.8680,  355.2503,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    565.3141,  564.5986,  561.2313,  0.0000,
  0.0000,    461.3936,  461.4745,  459.4787,  0.0000,    0.0000,    364.2197,  364.6873,  363.5898,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    516.1807,  522.3200,  0.0000,    0.0000,    0.0000,    425.8721,
  431.0011,  0.0000,    0.0000,    0.0000,    339.4027,  343.4945,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    468.7527,  0.0000,    0.0000,    0.0000,    0.0000,    390.4711,  0.0000,    0.0000,
  0.0000,    0.0000,    313.9849,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1828.6037,
  698.6886,  0.0000,    0.0000,    0.0000,    1308.6904, 554.9802,  0.0000,    0.0000,    0.0000,
  937.3847,  429.2648,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1698.4672, 1420.5909, 715.4002,
  0.0000,    0.0000,    1255.3593, 1050.0362, 571.9460,  0.0000,    0.0000,    916.2401,  769.5781,
  444.1389,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1473.0457, 725.5272,  0.0000,    0.0000,    0.0000,
  1108.4934, 585.8966,  0.0000,    0.0000,    0.0000,    819.4093,  458.2519,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1296.6551, 853.1336,  0.0000,    0.0000,    0.0000,    995.4823,  676.8518,
  0.0000,    0.0000,    0.0000,    747.5898,  523.0508,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1301.5598, 759.3194,  0.0000,    0.0000,    0.0000,    989.1364,  605.3587,  0.0000,    0.0000,
  0.0000,    737.8924,  470.4022,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1259.6142, 661.0039,
  0.0000,    0.0000,    0.0000,    957.7781,  534.6820,  0.0000,    0.0000,    0.0000,    714.8344,
  419.4840,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1313.7158, 634.1896,  0.0000,    0.0000,
  0.0000,    986.7352,  514.5121,  0.0000,    0.0000,    0.0000,    729.4873,  404.5998,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1269.0647, 792.0047,  0.0000,    0.0000,    0.0000,    955.4249,
  619.7862,  0.0000,    0.0000,    0.0000,    707.5095,  474.6763,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    713.9427,  478.2848,  402.9498,  0.0000,    0.0000,    478.2848,  332.2425,  284.1821,
  0.0000,    0.0000,    402.9498,  284.1821,  244.6586,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    658.8753,
  443.0659,  422.3203,  0.0000,    0.0000,    443.6280,  308.7059,  296.6934,  0.0000,    0.0000,
  374.5394,  264.4321,  254.9713,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    551.0802,  429.5143,  0.0000,
  0.0000,    0.0000,    370.6378,  298.6678,  0.0000,    0.0000,    0.0000,    313.1143,  255.6479,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    577.0107,  420.3746,  0.0000,    0.0000,    0.0000,
  391.0675,  295.3036,  0.0000,    0.0000,    0.0000,    331.0815,  253.6663,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    735.2525,  696.1321,  547.3300,  457.2780,  0.0000,    490.3325,  467.3771,
  376.3625,  320.7454,  0.0000,    412.2889,  394.0370,  320.4011,  275.2351,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  666.8954,  617.3791,  594.5277,  529.5371,  473.4591,  453.1794,  422.7438,  408.7434,  368.2710,
  333.0973,  383.7851,  359.1380,  347.8166,  314.8522,  286.1251,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    583.3346,  570.2790,
  552.8128,  530.9113,  0.0000,    404.0384,  396.0359,  385.2196,  371.5740,  0.0000,    344.8082,
  338.3472,  329.5690,  318.4602,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    535.2189,  534.4511,  529.4579,  0.0000,
  0.0000,    375.1303,  374.8656,  371.8493,  0.0000,    0.0000,    321.7225,  321.5899,  319.1735,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    478.2481,  482.8217,  0.0000,    0.0000,    0.0000,    339.5620,
  342.7279,  0.0000,    0.0000,    0.0000,    292.8227,  295.5179,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    425.2684,  0.0000,    0.0000,    0.0000,    0.0000,    305.7201,  0.0000,    0.0000,
  0.0000,    0.0000,    265.0611,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2129.9275,
  678.2767,  0.0000,    0.0000,    0.0000,    1295.8507, 460.8194,  0.0000,    0.0000,    0.0000,
  1051.3610, 390.6048,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1890.1371, 1572.3023, 711.0892,
  0.0000,    0.0000,    1185.1747, 986.7643,  485.8072,  0.0000,    0.0000,    972.1452,  810.5895,
  412.5321,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1629.9126, 1125.4492, 730.8135,  0.0000,    0.0000,
  1040.1066, 734.8918,  503.1910,  0.0000,    0.0000,    859.0221,  613.1365,  428.4259,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    691.5646,  0.0000,    0.0000,    0.0000,    0.0000,    477.5945,  0.0000,
  0.0000,    0.0000,    0.0000,    407.2558,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1664.4640, 669.9917,  0.0000,    0.0000,    0.0000,    1050.0763, 463.2412,  0.0000,    0.0000,
  0.0000,    863.5344,  395.2161,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1593.3696, 656.0092,
  0.0000,    0.0000,    0.0000,    1008.0521, 453.6734,  0.0000,    0.0000,    0.0000,    829.8526,
  387.0905,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1552.0522, 634.6293,  0.0000,    0.0000,
  0.0000,    982.6875,  439.3361,  0.0000,    0.0000,    0.0000,    809.2032,  375.0228,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1514.2016, 639.5705,  0.0000,    0.0000,    0.0000,    959.3598,
  441.4769,  0.0000,    0.0000,    0.0000,    790.1791,  376.4231,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1480.5878, 622.3214,  0.0000,    0.0000,    0.0000,    938.6688,  425.6722,  0.0000,
  0.0000,    0.0000,    773.3122,  361.7114,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1140.4525,
  644.1313,  0.0000,    0.0000,    0.0000,    738.1317,  444.1417,  0.0000,    0.0000,    0.0000,
  613.3959,  378.4806,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1323.5223, 603.5669,  0.0000,
  0.0000,    0.0000,    832.9670,  417.2520,  0.0000,    0.0000,    0.0000,    684.9715,  355.9594,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1271.8937, 617.3535,  0.0000,    0.0000,    0.0000,
  803.2511,  424.5778,  0.0000,    0.0000,    0.0000,    661.4373,  361.4953,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1329.1426, 571.4828,  0.0000,    0.0000,    0.0000,    846.3103,  396.0475,
  0.0000,    0.0000,    0.0000,    698.3448,  338.1899,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1300.2637, 554.6882,  0.0000,    0.0000,    0.0000,    828.2826,  384.7714,  0.0000,    0.0000,
  0.0000,    683.5612,  328.6834,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1273.9026, 551.5239,
  0.0000,    0.0000,    0.0000,    812.0214,  382.2739,  0.0000,    0.0000,    0.0000,    670.2940,
  326.4378,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1260.0764, 581.9866,  0.0000,    0.0000,
  0.0000,    802.5026,  401.5942,  0.0000,    0.0000,    0.0000,    662.1785,  342.2465,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1046.7597, 532.3185,  0.0000,    0.0000,    0.0000,    676.1320,
  369.4718,  0.0000,    0.0000,    0.0000,    561.1890,  315.6639,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1009.7527, 745.6550,  534.3847,  0.0000,    0.0000,    664.1953,  500.5042,  373.3141,
  0.0000,    0.0000,    555.1063,  422.0471,  319.7331,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    910.8426,
  684.2653,  561.7599,  0.0000,    0.0000,    606.2463,  464.6638,  390.1903,  0.0000,    0.0000,
  509.1475,  393.7048,  333.5709,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    762.2660,  617.0747,  515.5680,
  0.0000,    0.0000,    512.5656,  424.1709,  362.7696,  0.0000,    0.0000,    432.5391,  361.1971,
  311.8089,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    771.9567,  630.9388,  464.0894,  0.0000,    0.0000,
  521.3061,  429.2047,  329.8562,  0.0000,    0.0000,    440.5866,  363.9955,  284.7548,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    692.6754,  537.5474,  433.4092,  0.0000,    0.0000,    472.6809,  376.0155,
  310.5758,  0.0000,    0.0000,    401.2280,  322.4625,  269.0419,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  629.2909,  503.7831,  446.5677,  0.0000,    0.0000,    433.1292,  353.9897,  316.6899,  0.0000,
  0.0000,    368.9849,  304.1992,  273.2842,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    518.4595,  480.1081,
  469.9681,  0.0000,    0.0000,    360.4173,  338.2908,  332.8653,  0.0000,    0.0000,    308.4915,
  291.0874,  287.0077,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    482.8089,  459.2862,  0.0000,    0.0000,
  0.0000,    336.9714,  323.6165,  0.0000,    0.0000,    0.0000,    288.9578,  278.5389,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    494.7186,  439.4643,  0.0000,    0.0000,    0.0000,    346.4526,
  312.6922,  0.0000,    0.0000,    0.0000,    297.3762,  270.1130,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    751.4117,  744.9376,  579.9029,  508.9476,  0.0000,    504.2404,  502.4772,  402.5143,
  358.7251,  0.0000,    425.4193,  424.7038,  344.1123,  308.5623,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    723.7046,
  665.8346,  612.2971,  598.0023,  551.0749,  492.5689,  457.8376,  425.1675,  417.0362,  387.8570,
  417.6830,  389.8200,  363.4268,  357.0662,  333.3155,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    653.9337,  638.9836,  620.8581,
  599.3763,  0.0000,    452.6451,  443.9926,  433.2501,  420.3354,  0.0000,    386.3661,  379.5520,
  370.9970,  360.6434,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    617.6998,  616.9108,  613.2064,  0.0000,    0.0000,
  431.8588,  431.9526,  430.1117,  0.0000,    0.0000,    370.1147,  370.4046,  369.0777,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    563.6134,  570.3414,  0.0000,    0.0000,    0.0000,    398.8768,  403.6693,
  0.0000,    0.0000,    0.0000,    343.5805,  347.7047,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  511.3370,  0.0000,    0.0000,    0.0000,    0.0000,    365.9914,  0.0000,    0.0000,    0.0000,
  0.0000,    316.7738,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1981.9822, 762.9614,
  0.0000,    0.0000,    0.0000,    1222.4485, 518.9273,  0.0000,    0.0000,    0.0000,    997.3856,
  440.0217,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1851.1077, 1544.9801, 781.7311,  0.0000,
  0.0000,    1171.5378, 980.7226,  534.7969,  0.0000,    0.0000,    964.6140,  809.2430,  454.3824,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1608.1722, 793.1478,  0.0000,    0.0000,    0.0000,    1034.5633,
  548.0198,  0.0000,    0.0000,    0.0000,    857.2133,  467.3661,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1416.8423, 931.5690,  0.0000,    0.0000,    0.0000,    929.5319,  632.9658,  0.0000,
  0.0000,    0.0000,    776.3662,  536.4947,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1420.7211,
  828.4128,  0.0000,    0.0000,    0.0000,    923.6673,  566.4457,  0.0000,    0.0000,    0.0000,
  768.9612,  481.5173,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1374.9665, 721.9817,  0.0000,
  0.0000,    0.0000,    894.4135,  500.3844,  0.0000,    0.0000,    0.0000,    744.7989,  427.5054,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1433.1563, 692.7026,  0.0000,    0.0000,    0.0000,
  921.2853,  481.5720,  0.0000,    0.0000,    0.0000,    763.5726,  411.9411,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1384.7315, 863.9068,  0.0000,    0.0000,    0.0000,    892.0641,  579.6349,
  0.0000,    0.0000,    0.0000,    739.9621,  489.1400,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  608.5041,  411.1361,  392.3548,  0.0000,    0.0000,    411.1361,  286.9519,  275.9575,  0.0000,
  0.0000,    392.3548,  275.9575,  265.8746,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    508.7742,  398.4662,
  0.0000,    0.0000,    0.0000,    343.6707,  277.6023,  0.0000,    0.0000,    0.0000,    327.8015,
  266.8459,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    533.4134,  390.5770,  0.0000,    0.0000,
  0.0000,    362.6432,  274.6154,  0.0000,    0.0000,    0.0000,    346.6055,  264.5941,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    678.0996,  642.6456,  506.9866,  424.7783,  0.0000,    454.0576,
  432.9973,  349.3149,  298.1562,  0.0000,    432.3183,  412.9408,  334.9874,  287.2026,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    616.7522,  571.5602,  550.7159,  491.3041,  439.9855,  420.1268,  392.1471,  379.2791,
  342.0404,  309.6665,  401.8433,  375.7345,  363.7391,  328.8698,  298.4950,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    540.9125,
  528.9954,  513.0345,  493.0084,  0.0000,    375.0995,  367.7493,  357.8055,  345.2533,  0.0000,
  360.3420,  353.4857,  344.1857,  332.4291,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    497.0959,  496.4313,  491.8812,
  0.0000,    0.0000,    348.6074,  348.3802,  345.6140,  0.0000,    0.0000,    335.7605,  335.5949,
  333.0245,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    444.9662,  449.2061,  0.0000,    0.0000,    0.0000,
  315.9288,  318.8629,  0.0000,    0.0000,    0.0000,    305.1216,  307.9410,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    396.3468,  0.0000,    0.0000,    0.0000,    0.0000,    284.7964,  0.0000,
  0.0000,    0.0000,    0.0000,    275.7577,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1935.8392, 627.0057,  0.0000,    0.0000,    0.0000,    1193.7040, 427.3247,  0.0000,    0.0000,
  0.0000,    1107.7988, 408.6188,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1727.2738, 1436.0400,
  657.9647,  0.0000,    0.0000,    1093.0044, 910.5268,  450.6082,  0.0000,    0.0000,    1024.0901,
  852.7680,  431.4907,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1493.4855, 1034.1628, 677.0271,  0.0000,
  0.0000,    960.1346,  679.6572,  466.8855,  0.0000,    0.0000,    903.9928,  643.4443,  447.9267,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    640.9611,  0.0000,    0.0000,    0.0000,    0.0000,    443.3629,
  0.0000,    0.0000,    0.0000,    0.0000,    425.6143,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1522.4806, 621.0687,  0.0000,    0.0000,    0.0000,    968.8758,  430.0863,  0.0000,
  0.0000,    0.0000,    909.2919,  412.9759,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1458.1671,
  608.1289,  0.0000,    0.0000,    0.0000,    930.2250,  421.2135,  0.0000,    0.0000,    0.0000,
  873.7547,  404.4764,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1420.5469, 588.3919,  0.0000,
  0.0000,    0.0000,    906.8511,  407.9420,  0.0000,    0.0000,    0.0000,    851.9952,  391.8190,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1386.0622, 592.7151,  0.0000,    0.0000,    0.0000,
  885.3477,  409.8444,  0.0000,    0.0000,    0.0000,    831.9541,  393.3803,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1355.4425, 575.9965,  0.0000,    0.0000,    0.0000,    866.2748,  394.9658,
  0.0000,    0.0000,    0.0000,    814.1845,  378.3019,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1047.1279, 596.8654,  0.0000,    0.0000,    0.0000,    682.2073,  412.2532,  0.0000,    0.0000,
  0.0000,    644.6362,  395.6090,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1209.6847, 559.4921,
  0.0000,    0.0000,    0.0000,    768.7904,  387.3909,  0.0000,    0.0000,    0.0000,    720.7315,
  371.9667,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1163.0374, 571.8202,  0.0000,    0.0000,
  0.0000,    741.5149,  394.0563,  0.0000,    0.0000,    0.0000,    695.7803,  377.9042,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1217.6582, 529.9388,  0.0000,    0.0000,    0.0000,    781.2040,
  367.7646,  0.0000,    0.0000,    0.0000,    735.1282,  353.3208,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1191.2962, 514.4346,  0.0000,    0.0000,    0.0000,    764.5705,  357.3192,  0.0000,
  0.0000,    0.0000,    719.5693,  343.3582,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1167.2707,
  511.4434,  0.0000,    0.0000,    0.0000,    749.5779,  354.9728,  0.0000,    0.0000,    0.0000,
  705.5909,  341.0443,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1154.4639, 539.3652,  0.0000,
  0.0000,    0.0000,    740.7392,  372.7391,  0.0000,    0.0000,    0.0000,    697.1131,  357.7685,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    960.9128,  493.7318,  0.0000,    0.0000,    0.0000,
  624.7157,  343.1104,  0.0000,    0.0000,    0.0000,    590.0466,  329.7526,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    929.4676,  688.1448,  496.0739,  0.0000,    0.0000,    614.2531,  463.6824,
  346.8008,  0.0000,    0.0000,    582.9509,  442.1134,  333.7879,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  839.8351,  632.5574,  521.0045,  0.0000,    0.0000,    561.1517,  430.8712,  362.4056,  0.0000,
  0.0000,    534.0983,  411.9669,  348.3184,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    703.7619,  571.4589,
  479.0590,  0.0000,    0.0000,    474.9493,  393.7124,  337.3247,  0.0000,    0.0000,    453.0906,
  377.5050,  325.1416,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    713.1846,  583.4257,  431.8330,  0.0000,
  0.0000,    483.1569,  398.1044,  307.0301,  0.0000,    0.0000,    461.4103,  380.7868,  296.5675,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    640.8968,  499.0781,  403.7487,  0.0000,    0.0000,    438.4677,
  349.5179,  289.3170,  0.0000,    0.0000,    419.7500,  336.4471,  279.9309,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    582.9622,  468.0316,  415.3887,  0.0000,    0.0000,    402.0834,  329.2175,  294.8260,
  0.0000,    0.0000,    385.6667,  317.2071,  284.6094,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    480.9389,
  446.2157,  437.1117,  0.0000,    0.0000,    334.9854,  314.7313,  309.8062,  0.0000,    0.0000,
  321.9839,  303.4215,  299.0109,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    448.1216,  426.8634,  0.0000,
  0.0000,    0.0000,    313.3483,  301.1391,  0.0000,    0.0000,    0.0000,    301.4373,  290.3004,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    459.4282,  409.0280,  0.0000,    0.0000,    0.0000,
  322.1884,  291.1622,  0.0000,    0.0000,    0.0000,    310.1954,  281.2884,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    693.4942,  688.0703,  537.8554,  473.0843,  0.0000,    467.3571,  465.8349,
  373.9549,  333.6771,  0.0000,    445.5561,  444.6818,  359.3493,  321.7342,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  669.3882,  616.7552,  567.9507,  555.0356,  512.1436,  456.8674,  424.9729,  394.9440,  387.5029,
  360.6571,  437.0899,  407.5342,  379.5741,  372.7868,  347.6589,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    606.3128,  592.7690,
  576.3005,  556.7487,  0.0000,    420.3274,  412.4056,  402.5546,  390.6999,  0.0000,    403.6983,
  396.4304,  387.3300,  376.3349,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    573.5099,  572.8955,  569.5929,  0.0000,
  0.0000,    401.3349,  401.4589,  399.7963,  0.0000,    0.0000,    386.3114,  386.5596,  385.1074,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    524.1716,  530.4326,  0.0000,    0.0000,    0.0000,    371.0728,
  375.5218,  0.0000,    0.0000,    0.0000,    358.1189,  362.4211,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    476.2913,  0.0000,    0.0000,    0.0000,    0.0000,    340.8458,  0.0000,    0.0000,
  0.0000,    0.0000,    329.7218,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1805.2792,
  705.4029,  0.0000,    0.0000,    0.0000,    1126.9549, 481.2264,  0.0000,    0.0000,    0.0000,
  1050.1750, 460.2859,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1693.9362, 1413.6504, 723.4494,
  0.0000,    0.0000,    1081.0405, 905.5129,  496.0877,  0.0000,    0.0000,    1015.4760, 850.8433,
  475.1882,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1475.3924, 735.1655,  0.0000,    0.0000,    0.0000,
  955.5359,  508.7346,  0.0000,    0.0000,    0.0000,    901.6018,  488.4310,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1303.6060, 861.2012,  0.0000,    0.0000,    0.0000,    859.6950,  587.0236,
  0.0000,    0.0000,    0.0000,    815.2635,  561.2936,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1305.3320, 766.4086,  0.0000,    0.0000,    0.0000,    853.9373,  525.6960,  0.0000,    0.0000,
  0.0000,    807.8493,  503.3017,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1263.4136, 669.4583,
  0.0000,    0.0000,    0.0000,    826.9445,  464.7906,  0.0000,    0.0000,    0.0000,    782.4275,
  446.4908,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1314.6561, 642.6115,  0.0000,    0.0000,
  0.0000,    851.1916,  447.4308,  0.0000,    0.0000,    0.0000,    802.9025,  430.1169,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1270.6578, 797.1537,  0.0000,    0.0000,    0.0000,    824.2947,
  537.2980,  0.0000,    0.0000,    0.0000,    777.9791,  512.1336,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    426.7450,  333.1583,  0.0000,    0.0000,    0.0000,    333.1583,  268.6130,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    445.8701,
  325.9662,  0.0000,    0.0000,    0.0000,    351.3712,  265.5450,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    567.3303,  537.2058,  423.1021,
  354.1221,  0.0000,    440.2733,  419.6868,  338.1165,  288.2865,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    514.4477,  476.5966,  459.1219,  409.4318,  366.5943,
  406.9029,  379.6335,  367.0907,  330.8354,  299.3318,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    450.6427,  440.7041,  427.3871,  410.6685,  0.0000,    362.8740,  355.7080,
  346.0216,  333.8012,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  414.1512,  413.5913,  409.7995,  0.0000,    0.0000,    337.0131,  336.7771,  334.0775,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    370.9344,  374.4467,
  0.0000,    0.0000,    0.0000,    305.2122,  308.0475,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    330.7646,  0.0000,    0.0000,    0.0000,
  0.0000,    274.9744,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1657.7829, 524.5075,  0.0000,    0.0000,    0.0000,    1162.5520,
  413.7796,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1460.5858, 1219.4904, 549.4299,  0.0000,    0.0000,    1063.3544, 885.4039,  436.2139,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1257.4297,
  870.4102,  564.2490,  0.0000,    0.0000,    933.1680,  659.4710,  451.7417,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    534.5993,  0.0000,    0.0000,
  0.0000,    0.0000,    428.9980,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1286.0441, 518.0207,  0.0000,    0.0000,    0.0000,
  942.3547,  416.1281,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1230.4969, 507.2269,  0.0000,    0.0000,    0.0000,    904.6688,  407.5420,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1198.4194, 490.7833,  0.0000,    0.0000,    0.0000,    881.9071,  394.6814,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1169.0360, 494.5443,
  0.0000,    0.0000,    0.0000,    860.9698,  396.5804,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1142.9352, 481.1524,  0.0000,    0.0000,
  0.0000,    842.3966,  382.4279,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    880.5313,  497.8410,  0.0000,    0.0000,    0.0000,    662.6029,
  398.9285,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1025.6835, 466.6597,  0.0000,    0.0000,    0.0000,    747.7247,  374.8322,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    985.5697,
  477.2912,  0.0000,    0.0000,    0.0000,    721.0103,  381.3842,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1025.3902, 441.8976,  0.0000,
  0.0000,    0.0000,    759.5084,  355.7893,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1002.9797, 428.9424,  0.0000,    0.0000,    0.0000,
  743.3221,  345.6658,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    982.5210,  426.4375,  0.0000,    0.0000,    0.0000,    728.7203,  343.4086,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  971.8093,  449.5606,  0.0000,    0.0000,    0.0000,    720.1654,  360.6692,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    807.4406,  411.5822,
  0.0000,    0.0000,    0.0000,    606.8313,  331.9016,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    777.7995,  575.9550,  413.2739,  0.0000,
  0.0000,    595.9852,  449.3082,  335.2999,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    701.9284,  528.9288,  434.7817,  0.0000,    0.0000,    544.0985,
  417.2647,  350.5137,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    588.7029,  477.4647,  399.7262,  0.0000,    0.0000,    460.2670,  381.0495,  326.0586,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    595.9980,
  488.0001,  360.5629,  0.0000,    0.0000,    468.1084,  385.5420,  296.6430,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    535.2869,  416.6444,  337.2914,
  0.0000,    0.0000,    424.5823,  337.9858,  279.4279,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    486.8131,  390.9201,  347.3619,  0.0000,    0.0000,
  389.1870,  318.3105,  284.9424,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    402.1915,  372.8639,  365.1892,  0.0000,    0.0000,    324.1240,  304.2865,
  299.4363,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  374.9486,  356.9743,  0.0000,    0.0000,    0.0000,    303.1555,  291.1810,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    383.9518,  341.7312,
  0.0000,    0.0000,    0.0000,    311.6354,  281.3753,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    581.2740,  575.9928,  449.1546,  394.8051,
  0.0000,    453.0455,  451.4298,  361.8210,  322.5850,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    559.2710,  514.8930,  473.8893,  462.9202,  427.0415,  442.5095,
  411.3726,  382.0925,  374.7963,  348.6552,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    505.7574,  494.3345,  480.4874,  464.0717,  0.0000,    406.7084,  398.9498,  389.3206,
  377.7464,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    478.2336,
  477.6572,  474.8553,  0.0000,    0.0000,    388.1001,  388.1797,  386.5280,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    437.1628,  442.3361,  0.0000,
  0.0000,    0.0000,    358.5954,  362.8851,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    397.5123,  0.0000,    0.0000,    0.0000,    0.0000,
  329.1990,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1540.3020, 589.9223,  0.0000,    0.0000,    0.0000,    1096.8369, 465.9323,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1429.6950, 1196.8365, 604.0720,  0.0000,    0.0000,    1051.1515, 880.0394,  480.1835,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1240.2274, 613.0271,
  0.0000,    0.0000,    0.0000,    928.3302,  492.2252,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1092.5939, 720.5137,  0.0000,    0.0000,
  0.0000,    834.3179,  568.4774,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1096.8175, 641.8200,  0.0000,    0.0000,    0.0000,    829.1923,
  508.8922,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1061.5457, 559.0440,  0.0000,    0.0000,    0.0000,    802.9809,  449.7034,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1106.8617,
  536.5037,  0.0000,    0.0000,    0.0000,    827.1613,  432.8514,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1069.2791, 668.9805,  0.0000,
  0.0000,    0.0000,    800.9332,  520.7925,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    468.1900,  345.0599,  0.0000,    0.0000,    0.0000,
  345.0599,  263.4508,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    593.3574,  563.0312,  446.1184,  375.1486,  0.0000,    430.3607,  411.1576,
  333.6408,  286.0771,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  541.5490,  502.5513,  484.5759,  433.1992,  388.7621,  400.3474,  374.3430,  362.3966,  327.6519,
  297.3658,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    476.5783,  466.2941,
  452.4998,  435.1777,  0.0000,    359.0555,  352.2132,  342.9362,  331.2119,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    438.8861,  438.3534,  434.4358,  0.0000,
  0.0000,    334.4917,  334.3241,  331.7567,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    393.7655,  397.4979,  0.0000,    0.0000,    0.0000,    303.8410,
  306.6549,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    351.5285,  0.0000,    0.0000,    0.0000,    0.0000,    274.4407,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1663.0447,
  550.2565,  0.0000,    0.0000,    0.0000,    1094.9943, 406.5459,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1493.7369, 1241.2980, 578.1096,
  0.0000,    0.0000,    1016.1802, 845.1580,  429.5551,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1295.9364, 900.7673,  595.7322,  0.0000,    0.0000,
  898.2092,  639.3832,  446.1765,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    564.3910,  0.0000,    0.0000,    0.0000,    0.0000,    423.8910,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1318.2791, 546.9938,  0.0000,    0.0000,    0.0000,    902.6294,  411.2941,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1263.3482, 535.6228,
  0.0000,    0.0000,    0.0000,    867.5938,  402.8281,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1230.9598, 518.3356,  0.0000,    0.0000,
  0.0000,    846.0616,  390.2136,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1201.2473, 521.8571,  0.0000,    0.0000,    0.0000,    826.2261,
  391.7491,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1174.8699, 506.3303,  0.0000,    0.0000,    0.0000,    808.6413,  376.6190,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    911.0796,
  525.4121,  0.0000,    0.0000,    0.0000,    640.7393,  394.0161,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1046.5789, 492.7625,  0.0000,
  0.0000,    0.0000,    714.6206,  370.4592,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1006.8382, 503.1205,  0.0000,    0.0000,    0.0000,
  690.0423,  376.3121,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1056.3718, 466.9433,  0.0000,    0.0000,    0.0000,    730.4286,  351.9076,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1033.6009, 453.3608,  0.0000,    0.0000,    0.0000,    715.0198,  341.9894,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1012.8904, 450.6589,
  0.0000,    0.0000,    0.0000,    701.1829,  339.6919,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1001.6214, 474.8773,  0.0000,    0.0000,
  0.0000,    692.7504,  356.4206,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    835.8310,  435.1594,  0.0000,    0.0000,    0.0000,    586.6830,
  328.4628,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    811.2040,  602.6451,  437.6803,  0.0000,    0.0000,    580.2796,  439.9774,  332.4942,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    734.5659,
  555.1674,  459.1663,  0.0000,    0.0000,    531.7924,  410.0279,  346.8043,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    616.6410,  502.6948,  423.2230,
  0.0000,    0.0000,    450.9360,  375.7548,  323.6569,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    625.4199,  512.2533,  382.2149,  0.0000,    0.0000,
  459.3593,  378.9425,  295.1096,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    563.1205,  440.4737,  357.9013,  0.0000,    0.0000,    417.9082,  334.9141,
  278.4802,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  513.0376,  413.4353,  367.5432,  0.0000,    0.0000,    383.9600,  315.6928,  283.0965,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    424.0390,  394.3855,
  386.6993,  0.0000,    0.0000,    320.3640,  301.9254,  297.5281,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    395.4149,  377.3049,  0.0000,    0.0000,
  0.0000,    299.8626,  288.8038,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    405.6607,  362.1982,  0.0000,    0.0000,    0.0000,    308.7059,
  279.9099,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    607.4560,  603.3005,  474.1015,  418.1898,  0.0000,    443.2118,  442.5069,  357.7662,
  320.3273,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    587.9368,
  542.7164,  500.6629,  489.6613,  452.5780,  435.1964,  405.8302,  378.0150,  371.2868,  346.2500,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    534.1714,  522.5960,  508.4672,
  491.6555,  0.0000,    402.0900,  394.8667,  385.8127,  374.8687,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    506.1686,  505.7567,  502.9946,  0.0000,    0.0000,
  384.7622,  385.0190,  383.5763,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    463.6316,  469.1694,  0.0000,    0.0000,    0.0000,    356.5978,  360.8931,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  422.1393,  0.0000,    0.0000,    0.0000,    0.0000,    328.1840,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1555.0964, 619.1778,
  0.0000,    0.0000,    0.0000,    1039.1920, 457.9909,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1467.4624, 1224.7085, 635.7758,  0.0000,
  0.0000,    1008.1792, 843.9803,  473.0482,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1282.2835, 647.3934,  0.0000,    0.0000,    0.0000,    896.3009,
  486.4884,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1137.1745, 755.9211,  0.0000,    0.0000,    0.0000,    811.1482,  558.6293,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1136.7042,
  673.4287,  0.0000,    0.0000,    0.0000,    803.1520,  500.7569,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1100.3399, 589.8900,  0.0000,
  0.0000,    0.0000,    777.8763,  444.5089,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1142.5196, 566.5780,  0.0000,    0.0000,    0.0000,
  797.7599,  428.2230,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1104.7467, 698.1124,  0.0000,    0.0000,    0.0000,    773.1193,  509.2559,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  757.7397,  716.7957,  561.9006,  468.2521,  0.0000,    716.7957,  678.9920,  534.7248,  447.3269,
  0.0000,    561.9006,  534.7248,  427.9140,  362.7514,  0.0000,    468.2521,  447.3269,  362.7514,
  310.8315,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    685.6138,  634.1195,
  610.3382,  542.8413,  484.6532,  651.1403,  603.0965,  580.9260,  517.8029,  463.2993,  517.1479,
  481.4185,  464.9677,  417.6093,  376.5051,  435.6252,  407.2275,  394.1807,  356.2359,  323.1509,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    598.2891,  584.7110,  566.5642,  543.8198,
  0.0000,    570.3015,  557.6272,  540.6624,  519.3820,  0.0000,    458.7676,  449.3448,  436.6520,
  420.6714,  0.0000,    390.5107,  383.0280,  372.8876,  360.0757,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    548.1267,  547.2913,  542.0891,  0.0000,    0.0000,    523.6131,
  522.8863,  518.0408,  0.0000,    0.0000,    424.4718,  424.0862,  420.5155,  0.0000,    0.0000,
  363.5974,  363.4077,  360.5967,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    488.9709,  493.6625,  0.0000,    0.0000,    0.0000,    468.1680,  472.6441,  0.0000,
  0.0000,    0.0000,    382.6809,  386.2858,  0.0000,    0.0000,    0.0000,    330.0106,  333.0801,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    434.0932,
  0.0000,    0.0000,    0.0000,    0.0000,    416.5053,  0.0000,    0.0000,    0.0000,    0.0000,
  343.1281,  0.0000,    0.0000,    0.0000,    0.0000,    297.7796,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2226.4867, 697.3745,  0.0000,
  0.0000,    0.0000,    2062.6273, 661.8423,  0.0000,    0.0000,    0.0000,    1514.1166, 525.0776,
  0.0000,    0.0000,    0.0000,    1190.0927, 442.0537,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1964.0913, 1635.6158, 730.5114,  0.0000,    0.0000,
  1834.2595, 1525.9278, 694.2560,  0.0000,    0.0000,    1377.5185, 1145.3931, 553.0827,  0.0000,
  0.0000,    1105.9339, 919.0928,  467.1608,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1689.4085, 1164.0480, 749.9911,  0.0000,    0.0000,    1583.8792, 1095.4590,
  714.0617,  0.0000,    0.0000,    1204.5072, 845.7173,  572.0823,  0.0000,    0.0000,    977.8582,
  695.6184,  485.3739,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  709.5009,  0.0000,    0.0000,    0.0000,    0.0000,    675.7911,  0.0000,    0.0000,    0.0000,
  0.0000,    542.3835,  0.0000,    0.0000,    0.0000,    0.0000,    460.8857,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1728.2162, 687.2667,
  0.0000,    0.0000,    0.0000,    1615.9882, 654.7497,  0.0000,    0.0000,    0.0000,    1218.8063,
  525.8956,  0.0000,    0.0000,    0.0000,    982.2388,  447.1551,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1653.5039, 672.8996,  0.0000,    0.0000,
  0.0000,    1547.2492, 641.0897,  0.0000,    0.0000,    0.0000,    1169.3656, 514.9974,  0.0000,
  0.0000,    0.0000,    944.1820,  437.9410,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1610.4142, 650.8890,  0.0000,    0.0000,    0.0000,    1507.2236,
  620.2296,  0.0000,    0.0000,    0.0000,    1139.7842, 498.5669,  0.0000,    0.0000,    0.0000,
  920.7728,  424.1984,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1570.9643, 656.2319,  0.0000,    0.0000,    0.0000,    1470.5492, 624.9431,  0.0000,
  0.0000,    0.0000,    1112.6065, 501.3687,  0.0000,    0.0000,    0.0000,    899.2107,  425.8977,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1535.9254,
  639.2239,  0.0000,    0.0000,    0.0000,    1437.9844, 607.6149,  0.0000,    0.0000,    0.0000,
  1088.4965, 484.4102,  0.0000,    0.0000,    0.0000,    880.0979,  409.4190,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1179.9720, 660.9815,  0.0000,
  0.0000,    0.0000,    1109.2250, 629.3894,  0.0000,    0.0000,    0.0000,    851.5816,  504.6237,
  0.0000,    0.0000,    0.0000,    697.1742,  428.4350,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1375.6067, 619.1366,  0.0000,    0.0000,    0.0000,
  1284.5648, 589.8300,  0.0000,    0.0000,    0.0000,    966.3182,  473.7077,  0.0000,    0.0000,
  0.0000,    777.0365,  402.7499,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1321.5257, 633.7493,  0.0000,    0.0000,    0.0000,    1234.8582, 603.0805,
  0.0000,    0.0000,    0.0000,    931.2135,  482.6219,  0.0000,    0.0000,    0.0000,    750.3549,
  409.1408,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1377.8901, 586.0395,  0.0000,    0.0000,    0.0000,    1291.3513, 558.5785,  0.0000,    0.0000,
  0.0000,    980.6060,  449.3638,  0.0000,    0.0000,    0.0000,    795.0694,  382.5686,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1347.8497, 568.7508,
  0.0000,    0.0000,    0.0000,    1263.3503, 542.1999,  0.0000,    0.0000,    0.0000,    959.6719,
  436.4645,  0.0000,    0.0000,    0.0000,    778.3235,  371.7768,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1320.3887, 565.5647,  0.0000,    0.0000,
  0.0000,    1237.8116, 539.0868,  0.0000,    0.0000,    0.0000,    940.7333,  433.7382,  0.0000,
  0.0000,    0.0000,    763.2869,  369.2991,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1306.2023, 597.1466,  0.0000,    0.0000,    0.0000,    1224.3143,
  568.7674,  0.0000,    0.0000,    0.0000,    929.9326,  456.3409,  0.0000,    0.0000,    0.0000,
  754.1276,  387.6342,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1083.3008, 545.7749,  0.0000,    0.0000,    0.0000,    1018.1407, 520.3763,  0.0000,
  0.0000,    0.0000,    780.8531,  419.0870,  0.0000,    0.0000,    0.0000,    638.5760,  357.0972,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1042.2993,
  768.0103,  547.4380,  0.0000,    0.0000,    983.5647,  727.2164,  522.6366,  0.0000,    0.0000,
  764.1181,  572.3997,  422.7552,  0.0000,    0.0000,    631.8504,  478.6548,  361.4878,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    938.7702,  703.6560,  575.9720,
  0.0000,    0.0000,    887.9251,  667.8087,  549.0979,  0.0000,    0.0000,    695.3446,  529.7480,
  442.2857,  0.0000,    0.0000,    578.9036,  445.8975,  376.9496,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    784.7096,  633.5061,  527.6514,  0.0000,    0.0000,
  743.4035,  602.6649,  504.2597,  0.0000,    0.0000,    585.8808,  481.9745,  409.6194,  0.0000,
  0.0000,    490.4774,  408.4278,  351.5242,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    794.2301,  648.6295,  474.3487,  0.0000,    0.0000,    753.1512,  615.7554,
  454.1122,  0.0000,    0.0000,    595.3890,  488.9642,  371.2576,  0.0000,    0.0000,    499.6804,
  411.9543,  320.2685,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  711.6973,  550.6005,  442.5221,  0.0000,    0.0000,    676.2340,  525.5666,  424.2505,  0.0000,
  0.0000,    538.3114,  425.2390,  348.6585,  0.0000,    0.0000,    454.4014,  363.7717,  302.0368,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    645.8629,  515.7031,
  456.5944,  0.0000,    0.0000,    614.6582,  492.6242,  436.8021,  0.0000,    0.0000,    492.0619,
  399.7040,  356.4323,  0.0000,    0.0000,    417.3058,  342.7290,  307.0662,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    531.4442,  491.2916,  480.5848,  0.0000,
  0.0000,    506.5442,  469.5087,  459.7362,  0.0000,    0.0000,    407.9840,  381.5949,  374.9395,
  0.0000,    0.0000,    347.7941,  327.6646,  322.8342,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    494.6536,  469.9893,  0.0000,    0.0000,    0.0000,    471.7748,
  449.0836,  0.0000,    0.0000,    0.0000,    380.9134,  364.9131,  0.0000,    0.0000,    0.0000,
  325.3871,  313.3121,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    506.6451,  449.1510,  0.0000,    0.0000,    0.0000,    483.6313,  430.0395,  0.0000,
  0.0000,    0.0000,    391.4931,  351.7891,  0.0000,    0.0000,    0.0000,    335.0765,  303.6328,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    773.8833,
  766.6573,  594.6028,  520.8160,  0.0000,    732.5808,  726.6030,  566.7425,  497.8873,  0.0000,
  576.2784,  573.7031,  456.2201,  404.9097,  0.0000,    481.7644,  481.0669,  388.6659,  347.8009,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    743.8797,  683.5217,  627.7921,
  612.7955,  564.0526,  706.4446,  650.4220,  598.5207,  584.7350,  539.1627,  561.3762,  520.4284,
  482.0463,  472.3277,  438.1720,  473.1885,  441.1549,  410.7989,  403.4644,  376.1234,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    670.7354,  655.0919,  636.1713,  613.7787,  0.0000,
  639.1315,  624.6910,  607.1518,  586.3425,  0.0000,    513.7324,  503.4180,  490.6881,  475.4403,
  0.0000,    437.0798,  429.1940,  419.3073,  407.3563,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    632.7833,  631.8602,  627.9310,  0.0000,    0.0000,    604.1082,  603.4075,
  599.8596,  0.0000,    0.0000,    488.8057,  488.7350,  486.4323,  0.0000,    0.0000,    418.1090,
  418.3861,  416.8056,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  576.4869,  583.3654,  0.0000,    0.0000,    0.0000,    551.5844,  558.1846,  0.0000,    0.0000,
  0.0000,    449.8564,  455.2761,  0.0000,    0.0000,    0.0000,    387.2647,  391.9507,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    522.2524,  0.0000,
  0.0000,    0.0000,    0.0000,    500.6786,  0.0000,    0.0000,    0.0000,    0.0000,    411.2899,
  0.0000,    0.0000,    0.0000,    0.0000,    356.1266,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    2067.1731, 784.3364,  0.0000,    0.0000,
  0.0000,    1921.0063, 744.5626,  0.0000,    0.0000,    0.0000,    1423.9693, 591.1792,  0.0000,
  0.0000,    0.0000,    1129.6762, 498.0234,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1921.0215, 1604.2050, 802.9517,  0.0000,    0.0000,    1797.5569,
  1500.5632, 763.2929,  0.0000,    0.0000,    1358.7684, 1135.5611, 608.6290,  0.0000,    0.0000,
  1097.2829, 917.9716,  514.4602,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1665.0502, 813.6674,  0.0000,    0.0000,    0.0000,    1563.7265, 775.1141,  0.0000,
  0.0000,    0.0000,    1195.9642, 622.3426,  0.0000,    0.0000,    0.0000,    975.7591,  528.9870,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1463.1580,
  958.1121,  0.0000,    0.0000,    0.0000,    1379.6361, 909.2621,  0.0000,    0.0000,    0.0000,
  1069.5257, 721.4876,  0.0000,    0.0000,    0.0000,    882.8878,  607.4145,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1469.0715, 851.5874,  0.0000,
  0.0000,    0.0000,    1382.2903, 808.8540,  0.0000,    0.0000,    0.0000,    1064.5406, 644.3323,
  0.0000,    0.0000,    0.0000,    873.8896,  544.1898,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1421.6099, 740.4324,  0.0000,    0.0000,    0.0000,
  1337.7839, 705.5371,  0.0000,    0.0000,    0.0000,    1030.6377, 567.3904,  0.0000,    0.0000,
  0.0000,    846.3364,  482.9836,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1484.0150, 710.0936,  0.0000,    0.0000,    0.0000,    1393.1101, 677.0498,
  0.0000,    0.0000,    0.0000,    1064.4434, 545.6093,  0.0000,    0.0000,    0.0000,    867.8793,
  465.2257,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1433.4370, 890.0256,  0.0000,    0.0000,    0.0000,    1346.2697, 842.2184,  0.0000,    0.0000,
  0.0000,    1030.2277, 662.2469,  0.0000,    0.0000,    0.0000,    841.0964,  553.4386,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    627.5677,  582.7693,
  562.1276,  502.9891,  451.7578,  582.7693,  542.0439,  523.2910,  469.3751,  422.5950,  562.1276,
  523.2910,  505.4148,  453.9195,  409.2008,  502.9891,  469.3751,  453.9195,  409.1453,  370.1674,
  451.7578,  422.5950,  409.2008,  370.1674,  336.1020,  553.3592,  541.5209,  525.6310,  505.6697,
  0.0000,    515.9467,  505.1900,  490.7203,  472.5189,  0.0000,    498.7395,  488.4839,  474.6720,
  457.2860,  0.0000,    448.9769,  440.1085,  428.1222,  413.0024,  0.0000,    405.6849,  398.0011,
  387.5752,  374.3929,  0.0000,    509.9698,  509.3849,  504.8763,  0.0000,    0.0000,    476.6811,
  476.2087,  472.1243,  0.0000,    0.0000,    461.3868,  460.9671,  457.0793,  0.0000,    0.0000,
  416.8945,  416.6107,  413.2653,  0.0000,    0.0000,    378.0963,  377.9250,  375.0423,  0.0000,
  0.0000,    457.7156,  462.0716,  0.0000,    0.0000,    0.0000,    428.9963,  433.0589,  0.0000,
  0.0000,    0.0000,    415.8173,  419.7450,  0.0000,    0.0000,    0.0000,    377.2255,  380.7615,
  0.0000,    0.0000,    0.0000,    343.4912,  346.6856,  0.0000,    0.0000,    0.0000,    408.5952,
  0.0000,    0.0000,    0.0000,    0.0000,    383.9457,  0.0000,    0.0000,    0.0000,    0.0000,
  372.6480,  0.0000,    0.0000,    0.0000,    0.0000,    339.3505,  0.0000,    0.0000,    0.0000,
  0.0000,    310.1806,  0.0000,    0.0000,    0.0000,    0.0000,    1891.9207, 636.7612,  0.0000,
  0.0000,    0.0000,    1716.1526, 591.2764,  0.0000,    0.0000,    0.0000,    1633.6348, 570.2993,
  0.0000,    0.0000,    0.0000,    1409.0375, 510.2857,  0.0000,    0.0000,    0.0000,    1220.0459,
  458.3940,  0.0000,    0.0000,    0.0000,    1710.8832, 1420.0022, 669.7960,  0.0000,    0.0000,
  1561.8289, 1296.6408, 622.6826,  0.0000,    0.0000,    1492.4625, 1239.0351, 600.9779,  0.0000,
  0.0000,    1300.6349, 1080.2049, 538.6735,  0.0000,    0.0000,    1137.6146, 945.5274,  484.6892,
  0.0000,    0.0000,    1489.0440, 1037.3050, 691.3637,  0.0000,    0.0000,    1364.4290, 955.2258,
  643.8177,  0.0000,    0.0000,    1306.5898, 917.1231,  621.9390,  0.0000,    0.0000,    1145.4236,
  810.2212,  558.8413,  0.0000,    0.0000,    1007.8507, 718.6770,  504.0290,  0.0000,    0.0000,
  654.6723,  0.0000,    0.0000,    0.0000,    0.0000,    610.0042,  0.0000,    0.0000,    0.0000,
  0.0000,    589.4528,  0.0000,    0.0000,    0.0000,    0.0000,    530.1369,  0.0000,    0.0000,
  0.0000,    0.0000,    478.5981,  0.0000,    0.0000,    0.0000,    0.0000,    1511.0459, 634.5156,
  0.0000,    0.0000,    0.0000,    1381.1677, 591.3671,  0.0000,    0.0000,    0.0000,    1320.7683,
  571.5166,  0.0000,    0.0000,    0.0000,    1153.3721, 514.1941,  0.0000,    0.0000,    0.0000,
  1010.9240, 464.3765,  0.0000,    0.0000,    0.0000,    1448.8711, 621.3216,  0.0000,    0.0000,
  0.0000,    1325.1151, 579.0951,  0.0000,    0.0000,    0.0000,    1267.6087, 559.6696,  0.0000,
  0.0000,    0.0000,    1107.9903, 503.5686,  0.0000,    0.0000,    0.0000,    972.0426,  454.8102,
  0.0000,    0.0000,    0.0000,    1411.9588, 601.2862,  0.0000,    0.0000,    0.0000,    1291.5707,
  560.5406,  0.0000,    0.0000,    0.0000,    1235.6389, 541.7976,  0.0000,    0.0000,    0.0000,
  1080.3308, 487.6436,  0.0000,    0.0000,    0.0000,    948.0215,  440.5691,  0.0000,    0.0000,
  0.0000,    1378.0830, 605.1903,  0.0000,    0.0000,    0.0000,    1260.7608, 563.8386,  0.0000,
  0.0000,    0.0000,    1206.2616, 544.8078,  0.0000,    0.0000,    0.0000,    1054.8803, 489.9104,
  0.0000,    0.0000,    0.0000,    925.8883,  442.2254,  0.0000,    0.0000,    0.0000,    1348.0216,
  586.3317,  0.0000,    0.0000,    0.0000,    1233.4280, 545.1890,  0.0000,    0.0000,    0.0000,
  1180.2039, 526.2392,  0.0000,    0.0000,    0.0000,    1032.3159, 471.8373,  0.0000,    0.0000,
  0.0000,    906.2740,  424.6928,  0.0000,    0.0000,    0.0000,    1048.0976, 609.4014,  0.0000,
  0.0000,    0.0000,    963.2234,  567.6368,  0.0000,    0.0000,    0.0000,    923.8826,  548.4168,
  0.0000,    0.0000,    0.0000,    813.7102,  492.9882,  0.0000,    0.0000,    0.0000,    719.4208,
  444.8426,  0.0000,    0.0000,    0.0000,    1197.5597, 571.5751,  0.0000,    0.0000,    0.0000,
  1094.0703, 532.6855,  0.0000,    0.0000,    0.0000,    1045.8286, 514.7943,  0.0000,    0.0000,
  0.0000,    912.5542,  463.1355,  0.0000,    0.0000,    0.0000,    799.4055,  418.2405,  0.0000,
  0.0000,    0.0000,    1152.7975, 583.2130,  0.0000,    0.0000,    0.0000,    1053.9748, 542.9404,
  0.0000,    0.0000,    0.0000,    1007.9093, 524.3974,  0.0000,    0.0000,    0.0000,    880.5098,
  471.0117,  0.0000,    0.0000,    0.0000,    772.2715,  424.6821,  0.0000,    0.0000,    0.0000,
  1213.1043, 541.7910,  0.0000,    0.0000,    0.0000,    1111.0005, 505.1927,  0.0000,    0.0000,
  0.0000,    1063.6161, 488.3600,  0.0000,    0.0000,    0.0000,    931.6850,  439.6941,  0.0000,
  0.0000,    0.0000,    819.1008,  397.3735,  0.0000,    0.0000,    0.0000,    1187.1040, 526.0806,
  0.0000,    0.0000,    0.0000,    1087.2901, 490.6416,  0.0000,    0.0000,    0.0000,    1040.9736,
  474.3436,  0.0000,    0.0000,    0.0000,    911.9836,  427.2006,  0.0000,    0.0000,    0.0000,
  801.8905,  386.1954,  0.0000,    0.0000,    0.0000,    1163.4988, 522.9356,  0.0000,    0.0000,
  0.0000,    1065.8196, 487.6285,  0.0000,    0.0000,    0.0000,    1020.4995, 471.3898,  0.0000,
  0.0000,    0.0000,    894.2426,  424.4358,  0.0000,    0.0000,    0.0000,    786.4597,  383.6007,
  0.0000,    0.0000,    0.0000,    1150.4571, 551.0566,  0.0000,    0.0000,    0.0000,    1053.6773,
  513.3804,  0.0000,    0.0000,    0.0000,    1008.7709, 496.0454,  0.0000,    0.0000,    0.0000,
  883.7052,  446.0163,  0.0000,    0.0000,    0.0000,    776.9549,  402.5361,  0.0000,    0.0000,
  0.0000,    961.8402,  505.0671,  0.0000,    0.0000,    0.0000,    883.5921,  471.1069,  0.0000,
  0.0000,    0.0000,    847.3202,  455.4901,  0.0000,    0.0000,    0.0000,    745.7830,  410.2985,
  0.0000,    0.0000,    0.0000,    658.8708,  370.9807,  0.0000,    0.0000,    0.0000,    936.6361,
  696.8105,  508.4799,  0.0000,    0.0000,    863.8075,  645.4042,  474.9574,  0.0000,    0.0000,
  830.1410,  621.6569,  459.5520,  0.0000,    0.0000,    735.0657,  554.1022,  414.8066,  0.0000,
  0.0000,    653.2934,  495.8235,  375.8148,  0.0000,    0.0000,    849.2579,  642.5725,  532.7389,
  0.0000,    0.0000,    785.1771,  596.6150,  497.0041,  0.0000,    0.0000,    755.5917,  575.4163,
  480.5632,  0.0000,    0.0000,    671.6175,  514.7835,  432.9981,  0.0000,    0.0000,    599.2111,
  462.3439,  391.6387,  0.0000,    0.0000,    712.9494,  582.3842,  491.2965,  0.0000,    0.0000,
  660.5539,  542.1055,  459.5686,  0.0000,    0.0000,    636.3750,  523.5547,  444.9961,  0.0000,
  0.0000,    567.5078,  470.1838,  402.5544,  0.0000,    0.0000,    508.0568,  423.9005,  365.5482,
  0.0000,    0.0000,    723.6726,  592.7114,  443.7085,  0.0000,    0.0000,    671.1013,  550.4982,
  415.9204,  0.0000,    0.0000,    646.8560,  531.0329,  403.1695,  0.0000,    0.0000,    577.6432,
  475.3264,  365.8494,  0.0000,    0.0000,    517.8162,  427.1388,  333.2500,  0.0000,    0.0000,
  652.1135,  510.9494,  415.5054,  0.0000,    0.0000,    606.0646,  477.3501,  390.1441,  0.0000,
  0.0000,    584.8506,  461.9058,  378.5160,  0.0000,    0.0000,    524.0042,  417.0826,  344.3376,
  0.0000,    0.0000,    471.2941,  378.0575,  314.4361,  0.0000,    0.0000,    594.4049,  479.4837,
  426.1263,  0.0000,    0.0000,    553.4201,  448.3620,  399.2246,  0.0000,    0.0000,    534.5550,
  434.0633,  386.8735,  0.0000,    0.0000,    480.2351,  392.4836,  350.8096,  0.0000,    0.0000,
  433.0981,  356.2581,  319.3501,  0.0000,    0.0000,    491.0109,  457.2796,  448.5530,  0.0000,
  0.0000,    458.0796,  427.8357,  420.1303,  0.0000,    0.0000,    442.9323,  414.3111,  407.0826,
  0.0000,    0.0000,    399.1543,  374.9396,  368.9891,  0.0000,    0.0000,    361.1221,  340.6257,
  335.7488,  0.0000,    0.0000,    457.7529,  437.1946,  0.0000,    0.0000,    0.0000,    427.3948,
  409.0265,  0.0000,    0.0000,    0.0000,    413.4353,  396.0864,  0.0000,    0.0000,    0.0000,
  373.0290,  358.4386,  0.0000,    0.0000,    0.0000,    337.9078,  325.6411,  0.0000,    0.0000,
  0.0000,    470.0850,  420.2043,  0.0000,    0.0000,    0.0000,    439.2375,  393.9527,  0.0000,
  0.0000,    0.0000,    425.0605,  381.9067,  0.0000,    0.0000,    0.0000,    383.9269,  346.6558,
  0.0000,    0.0000,    0.0000,    348.1233,  315.8629,  0.0000,    0.0000,    0.0000,    701.3354,
  697.2453,  549.5415,  485.3299,  0.0000,    649.4752,  646.4014,  512.5560,  454.1303,  0.0000,
  625.5230,  622.9381,  495.5418,  439.8018,  0.0000,    557.4516,  556.0668,  446.3665,  398.0530,
  0.0000,    498.7690,  498.3275,  403.6231,  361.6355,  0.0000,    680.5752,  628.9089,  580.7053,
  568.2437,  525.5713,  632.1606,  585.4379,  541.6872,  530.5501,  491.6599,  609.8491,  565.4247,
  523.7411,  513.2219,  476.0845,  545.9469,  507.8208,  471.8345,  462.9834,  430.7108,  490.6231,
  457.8340,  426.6919,  419.2433,  391.1250,  619.5827,  606.4077,  590.2650,  571.0158,  0.0000,
  577.5750,  565.7546,  551.1960,  533.7812,  0.0000,    558.2505,  547.0601,  533.2373,  516.6741,
  0.0000,    502.4286,  492.9508,  481.1410,  466.9170,  0.0000,    453.9039,  445.8726,  435.7692,
  423.5320,  0.0000,    587.6097,  587.2526,  584.1601,  0.0000,    0.0000,    548.9328,  548.7765,
  546.0918,  0.0000,    0.0000,    531.1573,  531.0959,  528.6014,  0.0000,    0.0000,    479.5467,
  479.7172,  477.7264,  0.0000,    0.0000,    434.5851,  434.9405,  433.3703,  0.0000,    0.0000,
  538.5713,  545.0623,  0.0000,    0.0000,    0.0000,    504.4140,  510.5057,  0.0000,    0.0000,
  0.0000,    488.7337,  494.6422,  0.0000,    0.0000,    0.0000,    442.9192,  448.2866,  0.0000,
  0.0000,    0.0000,    402.9083,  407.8002,  0.0000,    0.0000,    0.0000,    490.4574,  0.0000,
  0.0000,    0.0000,    0.0000,    460.4353,  0.0000,    0.0000,    0.0000,    0.0000,    446.6683,
  0.0000,    0.0000,    0.0000,    0.0000,    406.2058,  0.0000,    0.0000,    0.0000,    0.0000,
  370.7947,  0.0000,    0.0000,    0.0000,    0.0000,    1773.2620, 716.7123,  0.0000,    0.0000,
  0.0000,    1613.2050, 665.6797,  0.0000,    0.0000,    0.0000,    1538.2573, 642.1473,  0.0000,
  0.0000,    0.0000,    1333.1000, 574.7794,  0.0000,    0.0000,    0.0000,    1159.9029, 516.5085,
  0.0000,    0.0000,    0.0000,    1683.2537, 1403.7977, 736.7435,  0.0000,    0.0000,    1539.6549,
  1284.9412, 685.1258,  0.0000,    0.0000,    1472.9117, 1229.5628, 661.3483,  0.0000,    0.0000,
  1287.6457, 1076.0744, 593.0472,  0.0000,    0.0000,    1129.8719, 945.5414,  533.8514,  0.0000,
  0.0000,    1475.1121, 751.1085,  0.0000,    0.0000,    0.0000,    1353.9743, 699.9415,  0.0000,
  0.0000,    0.0000,    1297.8097, 676.4019,  0.0000,    0.0000,    0.0000,    1140.7848, 608.4348,
  0.0000,    0.0000,    0.0000,    1006.4862, 549.3659,  0.0000,    0.0000,    0.0000,    1311.5880,
  874.7967,  0.0000,    0.0000,    0.0000,    1208.8936, 812.3380,  0.0000,    0.0000,    0.0000,
  1161.3917, 783.5129,  0.0000,    0.0000,    0.0000,    1027.4883, 701.0935,  0.0000,    0.0000,
  0.0000,    912.4622,  629.8247,  0.0000,    0.0000,    0.0000,    1308.5146, 779.2998,  0.0000,
  0.0000,    0.0000,    1203.7043, 724.6244,  0.0000,    0.0000,    0.0000,    1155.1516, 699.3799,
  0.0000,    0.0000,    0.0000,    1018.9158, 627.0734,  0.0000,    0.0000,    0.0000,    902.1993,
  564.5129,  0.0000,    0.0000,    0.0000,    1266.6329, 683.8018,  0.0000,    0.0000,    0.0000,
  1165.2987, 637.5954,  0.0000,    0.0000,    0.0000,    1118.3627, 616.3352,  0.0000,    0.0000,
  0.0000,    986.6337,  554.9249,  0.0000,    0.0000,    0.0000,    873.7655,  501.5645,  0.0000,
  0.0000,    0.0000,    1312.6653, 656.9210,  0.0000,    0.0000,    0.0000,    1204.5686, 612.9205,
  0.0000,    0.0000,    0.0000,    1154.4374, 592.6848,  0.0000,    0.0000,    0.0000,    1014.4405,
  534.1387,  0.0000,    0.0000,    0.0000,    894.8104,  483.2284,  0.0000,    0.0000,    0.0000,
  1269.7368, 805.6716,  0.0000,    0.0000,    0.0000,    1165.7062, 746.0891,  0.0000,    0.0000,
  0.0000,    1117.4761, 718.5424,  0.0000,    0.0000,    0.0000,    982.6596,  640.3360,  0.0000,
  0.0000,    0.0000,    867.3914,  572.9675,  0.0000,    0.0000,    0.0000,    492.9379,  483.0596,
  469.7255,  452.9187,  0.0000,    483.0596,  473.4703,  460.5150,  444.1770,  0.0000,    469.7255,
  460.5150,  448.0573,  432.3357,  0.0000,    452.9187,  444.1770,  432.3357,  417.3790,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    457.1057,  456.7589,  453.0254,  0.0000,
  0.0000,    448.3333,  448.0173,  444.3975,  0.0000,    0.0000,    436.4430,  436.1655,  432.6941,
  0.0000,    0.0000,    421.4187,  421.1871,  417.8991,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    412.9852,  416.8715,  0.0000,    0.0000,    0.0000,    405.4400,
  409.2485,  0.0000,    0.0000,    0.0000,    395.1626,  398.8660,  0.0000,    0.0000,    0.0000,
  382.1376,  385.7084,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    370.9572,  0.0000,    0.0000,    0.0000,    0.0000,    364.5064,  0.0000,    0.0000,
  0.0000,    0.0000,    355.6742,  0.0000,    0.0000,    0.0000,    0.0000,    344.4458,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1566.5042,
  561.2533,  0.0000,    0.0000,    0.0000,    1521.2386, 549.3044,  0.0000,    0.0000,    0.0000,
  1461.4083, 533.2393,  0.0000,    0.0000,    0.0000,    1386.5806, 513.0291,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1442.5135, 1197.3790, 592.2077,
  0.0000,    0.0000,    1403.5743, 1165.3603, 579.8000,  0.0000,    0.0000,    1352.0527, 1122.9068,
  563.1051,  0.0000,    0.0000,    1287.7738, 1069.7955, 542.0984,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1268.2622, 894.7026,  613.9793,  0.0000,    0.0000,
  1235.5723, 873.2287,  601.4334,  0.0000,    0.0000,    1192.2239, 844.5925,  584.5218,  0.0000,
  0.0000,    1138.1053, 808.6931,  563.2228,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    582.1618,  0.0000,    0.0000,    0.0000,    0.0000,    570.3846,  0.0000,
  0.0000,    0.0000,    0.0000,    554.4976,  0.0000,    0.0000,    0.0000,    0.0000,    534.4801,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1278.3406, 564.5753,  0.0000,    0.0000,    0.0000,    1244.3690, 553.2005,  0.0000,    0.0000,
  0.0000,    1199.3914, 537.8508,  0.0000,    0.0000,    0.0000,    1143.2636, 518.5062,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1227.7455, 552.8934,
  0.0000,    0.0000,    0.0000,    1195.3394, 541.7614,  0.0000,    0.0000,    0.0000,    1152.4260,
  526.7389,  0.0000,    0.0000,    0.0000,    1098.8818, 507.8063,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1197.0157, 535.3426,  0.0000,    0.0000,
  0.0000,    1165.4811, 524.6028,  0.0000,    0.0000,    0.0000,    1123.7195, 510.1049,  0.0000,
  0.0000,    0.0000,    1071.6137, 491.8297,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1168.7524, 537.9899,  0.0000,    0.0000,    0.0000,    1138.0116,
  527.0919,  0.0000,    0.0000,    0.0000,    1097.2997, 512.3917,  0.0000,    0.0000,    0.0000,
  1046.5046, 493.8687,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1143.6919, 518.5975,  0.0000,    0.0000,    0.0000,    1113.6574, 507.7568,  0.0000,
  0.0000,    0.0000,    1073.8792, 493.1741,  0.0000,    0.0000,    0.0000,    1024.2500, 474.8294,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    899.5162,
  541.4600,  0.0000,    0.0000,    0.0000,    877.2337,  530.4464,  0.0000,    0.0000,    0.0000,
  847.6165,  515.5966,  0.0000,    0.0000,    0.0000,    810.5952,  496.8907,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1011.2975, 508.5171,  0.0000,
  0.0000,    0.0000,    984.3669,  498.2630,  0.0000,    0.0000,    0.0000,    948.6782,  484.4278,
  0.0000,    0.0000,    0.0000,    904.0756,  466.9936,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    975.4435,  517.4288,  0.0000,    0.0000,    0.0000,
  949.7160,  506.8159,  0.0000,    0.0000,    0.0000,    915.6032,  492.5152,  0.0000,    0.0000,
  0.0000,    872.9520,  474.5058,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1031.8071, 482.6582,  0.0000,    0.0000,    0.0000,    1005.0059, 473.0076,
  0.0000,    0.0000,    0.0000,    969.4956,  459.9774,  0.0000,    0.0000,    0.0000,    925.1907,
  443.5507,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1009.9583, 468.8968,  0.0000,    0.0000,    0.0000,    983.7511,  459.5521,  0.0000,    0.0000,
  0.0000,    949.0275,  446.9312,  0.0000,    0.0000,    0.0000,    905.7052,  431.0179,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    990.2588,  465.9059,
  0.0000,    0.0000,    0.0000,    964.6052,  456.5948,  0.0000,    0.0000,    0.0000,    930.6131,
  444.0225,  0.0000,    0.0000,    0.0000,    888.2036,  428.1726,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    978.6871,  489.8686,  0.0000,    0.0000,
  0.0000,    953.2696,  479.9224,  0.0000,    0.0000,    0.0000,    919.5959,  466.5120,  0.0000,
  0.0000,    0.0000,    877.5875,  449.6202,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    824.6964,  450.3294,  0.0000,    0.0000,    0.0000,    804.1231,
  441.3725,  0.0000,    0.0000,    0.0000,    776.7990,  429.2735,  0.0000,    0.0000,    0.0000,
  742.6605,  414.0167,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    811.4869,  610.2527,  454.9967,  0.0000,    0.0000,    792.2720,  596.7311,  446.1604,
  0.0000,    0.0000,    766.6701,  578.6131,  434.1959,  0.0000,    0.0000,    734.6407,  555.8612,
  419.0873,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    740.5101,
  566.2395,  475.1601,  0.0000,    0.0000,    723.5937,  554.1499,  465.7586,  0.0000,    0.0000,
  700.9976,  537.9048,  453.0459,  0.0000,    0.0000,    672.6897,  517.4749,  437.0018,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    624.9010,  516.4949,  441.1051,
  0.0000,    0.0000,    611.1029,  505.9003,  432.7691,  0.0000,    0.0000,    592.6175,  491.6191,
  421.4512,  0.0000,    0.0000,    569.4157,  473.6285,  407.1354,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    635.8161,  522.6970,  400.3926,  0.0000,    0.0000,
  621.9565,  511.5956,  393.1092,  0.0000,    0.0000,    603.3740,  496.6738,  383.1838,  0.0000,
  0.0000,    580.0413,  477.9062,  370.6012,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    576.1075,  457.2859,  376.4785,  0.0000,    0.0000,    563.9701,  448.4532,
  369.8447,  0.0000,    0.0000,    547.6530,  436.4869,  360.7756,  0.0000,    0.0000,    527.1341,
  421.3693,  349.2565,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  527.4681,  430.0608,  383.9393,  0.0000,    0.0000,    516.6717,  421.8885,  376.8983,  0.0000,
  0.0000,    502.1230,  410.8007,  367.3108,  0.0000,    0.0000,    483.8028,  396.7809,  355.1613,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    437.8209,  410.6777,
  403.9370,  0.0000,    0.0000,    429.1725,  402.9521,  396.4838,  0.0000,    0.0000,    417.4805,
  392.4608,  386.3437,  0.0000,    0.0000,    402.7283,  379.1885,  373.5016,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    408.9427,  392.5551,  0.0000,    0.0000,
  0.0000,    400.9781,  385.1704,  0.0000,    0.0000,    0.0000,    390.1975,  375.1424,  0.0000,
  0.0000,    0.0000,    376.5850,  362.4562,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    420.7932,  379.2822,  0.0000,    0.0000,    0.0000,    412.6887,
  372.3997,  0.0000,    0.0000,    0.0000,    401.7099,  363.0226,  0.0000,    0.0000,    0.0000,
  387.8415,  351.1370,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    613.7965,  611.9984,  489.7839,  436.0471,  0.0000,    600.1676,  598.6193,  480.0484,
  427.8429,  0.0000,    581.9141,  580.6826,  466.8965,  416.7050,  0.0000,    559.0018,  558.1581,
  450.3097,  402.6179,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    600.3714,
  557.8416,  517.7663,  507.8330,  471.9591,  587.6072,  546.3819,  507.4849,  497.9006,  463.0314,
  570.4625,  530.9459,  493.5953,  484.4645,  450.9171,  548.9137,  511.5125,  476.0785,  467.5067,
  435.5995,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    551.5605,  540.9395,  527.7411,
  511.8706,  0.0000,    540.4832,  530.2215,  517.4436,  502.0601,  0.0000,    525.5339,  515.7394,
  503.5103,  488.7637,  0.0000,    506.6931,  497.4742,  485.9225,  471.9635,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    525.8728,  525.9823,  523.7050,  0.0000,    0.0000,
  515.6847,  515.8479,  513.6797,  0.0000,    0.0000,    501.8893,  502.1181,  500.0891,  0.0000,
  0.0000,    484.4680,  484.7740,  482.9144,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    485.0366,  490.9194,  0.0000,    0.0000,    0.0000,    476.0591,  481.8362,
  0.0000,    0.0000,    0.0000,    463.8486,  469.4814,  0.0000,    0.0000,    0.0000,    448.3873,
  453.8368,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  444.2351,  0.0000,    0.0000,    0.0000,    0.0000,    436.3686,  0.0000,    0.0000,    0.0000,
  0.0000,    425.6205,  0.0000,    0.0000,    0.0000,    0.0000,    411.9735,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1480.1255, 632.1327,
  0.0000,    0.0000,    0.0000,    1438.7730, 618.7237,  0.0000,    0.0000,    0.0000,    1384.0410,
  600.6902,  0.0000,    0.0000,    0.0000,    1315.5898, 578.0001,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1426.7831, 1191.5335, 651.8960,  0.0000,
  0.0000,    1389.2118, 1160.5961, 638.3059,  0.0000,    0.0000,    1339.4353, 1119.5215, 620.0107,
  0.0000,    0.0000,    1277.3025, 1068.1281, 596.9827,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1262.0917, 668.1278,  0.0000,    0.0000,    0.0000,    1230.2614,
  654.6342,  0.0000,    0.0000,    0.0000,    1188.0075, 636.4292,  0.0000,    0.0000,    0.0000,
  1135.2332, 613.4893,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1134.4385, 771.0663,  0.0000,    0.0000,    0.0000,    1107.3931, 754.6476,  0.0000,
  0.0000,    0.0000,    1071.3664, 732.5785,  0.0000,    0.0000,    0.0000,    1026.2943, 704.8129,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1125.8498,
  689.0793,  0.0000,    0.0000,    0.0000,    1098.3173, 674.7378,  0.0000,    0.0000,    0.0000,
  1061.6930, 655.4188,  0.0000,    0.0000,    0.0000,    1015.8964, 631.0713,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1090.1053, 609.0253,  0.0000,
  0.0000,    0.0000,    1063.4833, 596.8656,  0.0000,    0.0000,    0.0000,    1028.0688, 580.4423,
  0.0000,    0.0000,    0.0000,    983.7858,  559.7310,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1122.1440, 586.0168,  0.0000,    0.0000,    0.0000,
  1093.7836, 574.4363,  0.0000,    0.0000,    0.0000,    1056.1396, 558.7827,  0.0000,    0.0000,
  0.0000,    1009.1230, 539.0344,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1086.7671, 704.9879,  0.0000,    0.0000,    0.0000,    1059.4592, 689.3625,
  0.0000,    0.0000,    0.0000,    1023.2018, 668.4225,  0.0000,    0.0000,    0.0000,    977.9127,
  642.1174,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  425.5355,  425.3152,  422.0187,  0.0000,    0.0000,    425.3152,  425.1015,  421.8178,  0.0000,
  0.0000,    422.0187,  421.8178,  418.5789,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    386.0997,  389.7029,
  0.0000,    0.0000,    0.0000,    385.9988,  389.5996,  0.0000,    0.0000,    0.0000,    383.1837,
  386.7550,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    348.2239,  0.0000,    0.0000,    0.0000,
  0.0000,    348.2164,  0.0000,    0.0000,    0.0000,    0.0000,    345.8283,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1394.5709, 517.5807,  0.0000,    0.0000,    0.0000,    1389.9562,
  517.0109,  0.0000,    0.0000,    0.0000,    1372.2422, 512.4692,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1295.6354, 1076.7503, 546.9393,  0.0000,    0.0000,    1292.0505, 1073.8698, 546.3872,
  0.0000,    0.0000,    1276.8973, 1061.4185, 541.6776,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1145.5595,
  814.8114,  568.3523,  0.0000,    0.0000,    1142.8009, 813.2828,  567.8637,  0.0000,    0.0000,
  1130.1276, 805.0118,  563.1134,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    539.4167,  0.0000,    0.0000,
  0.0000,    0.0000,    538.9780,  0.0000,    0.0000,    0.0000,    0.0000,    534.5244,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1150.4200, 523.3205,  0.0000,    0.0000,    0.0000,
  1147.3718, 522.9067,  0.0000,    0.0000,    0.0000,    1134.1681, 518.6075,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1105.8143, 512.5245,  0.0000,    0.0000,    0.0000,    1102.9411, 512.1209,
  0.0000,    0.0000,    0.0000,    1090.3536, 507.9139,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1078.3854, 496.4206,  0.0000,    0.0000,    0.0000,    1075.5989, 496.0396,  0.0000,    0.0000,
  0.0000,    1063.3516, 491.9827,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1053.1255, 498.4291,
  0.0000,    0.0000,    0.0000,    1050.4168, 498.0193,  0.0000,    0.0000,    0.0000,    1038.4792,
  493.8976,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1030.7380, 479.0649,  0.0000,    0.0000,
  0.0000,    1028.0990, 478.5801,  0.0000,    0.0000,    0.0000,    1016.4371, 474.4660,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    816.3047,  501.4441,  0.0000,    0.0000,    0.0000,    814.5718,
  501.0205,  0.0000,    0.0000,    0.0000,    805.9652,  496.8526,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    909.9127,  471.3194,  0.0000,    0.0000,    0.0000,    907.4929,  470.9435,  0.0000,
  0.0000,    0.0000,    897.0258,  467.0673,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    878.6753,
  478.8244,  0.0000,    0.0000,    0.0000,    876.4054,  478.3961,  0.0000,    0.0000,    0.0000,
  866.4126,  474.3763,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    931.1239,  447.6960,  0.0000,
  0.0000,    0.0000,    928.8165,  447.3606,  0.0000,    0.0000,    0.0000,    918.4190,  443.7162,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    911.5137,  435.0603,  0.0000,    0.0000,    0.0000,
  909.2616,  434.7424,  0.0000,    0.0000,    0.0000,    899.0951,  431.2148,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    893.9080,  432.1732,  0.0000,    0.0000,    0.0000,    891.7106,  431.8507,
  0.0000,    0.0000,    0.0000,    881.7600,  428.3345,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  883.1919,  453.7243,  0.0000,    0.0000,    0.0000,    881.0037,  453.3459,  0.0000,    0.0000,
  0.0000,    871.1424,  449.5817,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    747.7579,  417.9025,
  0.0000,    0.0000,    0.0000,    746.1308,  417.6022,  0.0000,    0.0000,    0.0000,    738.1763,
  414.2217,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    740.0669,  560.4812,  423.1347,  0.0000,
  0.0000,    738.7354,  559.7227,  422.8902,  0.0000,    0.0000,    731.3413,  554.5564,  419.5653,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    677.9430,  521.9983,  441.1736,  0.0000,    0.0000,    676.8865,
  521.4107,  440.8725,  0.0000,    0.0000,    670.4007,  516.8114,  437.3278,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    574.1584,  477.9825,  411.2390,  0.0000,    0.0000,    573.3887,  477.5563,  411.0585,
  0.0000,    0.0000,    568.1201,  473.5452,  407.9357,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    584.9270,
  482.1223,  374.5042,  0.0000,    0.0000,    584.1896,  481.5919,  374.4114,  0.0000,    0.0000,
  578.9038,  477.3719,  371.6983,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    531.7823,  425.5116,  353.0606,
  0.0000,    0.0000,    531.2209,  425.2725,  353.0274,  0.0000,    0.0000,    526.6101,  421.9537,
  350.5682,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    488.2319,  400.7639,  358.8937,  0.0000,    0.0000,
  487.7978,  400.5716,  358.7861,  0.0000,    0.0000,    483.7108,  397.5083,  356.1612,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    406.6185,  383.0432,  377.3761,  0.0000,    0.0000,    406.3348,  382.8777,
  377.2513,  0.0000,    0.0000,    403.0774,  379.9862,  374.4693,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  380.2911,  366.1526,  0.0000,    0.0000,    0.0000,    380.0529,  365.9920,  0.0000,    0.0000,
  0.0000,    377.0592,  363.2286,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    391.6740,  354.8294,
  0.0000,    0.0000,    0.0000,    391.4533,  354.7399,  0.0000,    0.0000,    0.0000,    388.4099,
  352.1763,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    563.6633,  562.8800,  454.5743,  406.6647,
  0.0000,    562.8815,  562.1551,  454.2435,  406.4893,  0.0000,    557.6754,  557.0521,  450.5709,
  403.4163,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    553.6826,  516.1475,  480.5678,  471.9862,  439.9310,  553.0645,
  515.6769,  480.2227,  471.6875,  439.7315,  548.2096,  511.3353,  476.3434,  467.9467,  436.3838,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    511.3976,  502.1650,  490.5842,  476.5808,  0.0000,    510.9988,  501.8122,  490.2815,
  476.3335,  0.0000,    506.8129,  497.7687,  486.4040,  472.6478,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    489.1640,
  489.5004,  487.6562,  0.0000,    0.0000,    488.8815,  489.2328,  487.4071,  0.0000,    0.0000,
  485.0492,  485.4233,  483.6417,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    452.9726,  458.4777,  0.0000,
  0.0000,    0.0000,    452.8206,  458.3253,  0.0000,    0.0000,    0.0000,    449.4650,  454.9303,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    416.4038,  0.0000,    0.0000,    0.0000,    0.0000,
  416.3558,  0.0000,    0.0000,    0.0000,    0.0000,    413.4353,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    1323.6329, 583.1447,  0.0000,    0.0000,    0.0000,    1319.6282, 582.5163,
  0.0000,    0.0000,    0.0000,    1303.4917, 577.4214,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1285.4608, 1075.3755, 602.3548,  0.0000,    0.0000,    1282.1564, 1072.7423, 601.7662,  0.0000,
  0.0000,    1267.5667, 1060.7432, 596.6111,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1142.9090, 619.1592,
  0.0000,    0.0000,    0.0000,    1140.3381, 618.6624,  0.0000,    0.0000,    0.0000,    1128.0206,
  613.5605,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1033.8769, 711.0022,  0.0000,    0.0000,
  0.0000,    1031.9646, 710.2120,  0.0000,    0.0000,    0.0000,    1021.5531, 703.9665,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    1023.1942, 636.8184,  0.0000,    0.0000,    0.0000,    1021.1167,
  636.1967,  0.0000,    0.0000,    0.0000,    1010.4948, 630.7562,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    990.8696,  565.0183,  0.0000,    0.0000,    0.0000,    988.8657,  564.5964,  0.0000,
  0.0000,    0.0000,    978.5969,  560.0071,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1016.0025,
  544.1812,  0.0000,    0.0000,    0.0000,    1013.6901, 543.8049,  0.0000,    0.0000,    0.0000,
  1002.7172, 539.4399,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    984.6291,  647.5375,  0.0000,
  0.0000,    0.0000,    982.4295,  646.6499,  0.0000,    0.0000,    0.0000,    971.8689,  640.6828,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    351.9667,  355.2175,  0.0000,    0.0000,    0.0000,
  355.2175,  358.4995,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    318.8905,  0.0000,    0.0000,    0.0000,    0.0000,    321.8029,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  1207.5672, 465.0703,  0.0000,    0.0000,    0.0000,    1219.6272, 469.4818,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1131.7221, 942.2524,
  492.1377,  0.0000,    0.0000,    1142.9378, 951.5410,  496.7990,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1006.5104, 722.4932,  512.5389,  0.0000,
  0.0000,    1016.4155, 729.4949,  517.3851,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    487.0333,  0.0000,    0.0000,    0.0000,    0.0000,    491.6150,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    1007.0198, 472.7004,  0.0000,    0.0000,    0.0000,    1016.9588, 477.1430,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    968.7947,
  462.9825,  0.0000,    0.0000,    0.0000,    978.3471,  467.3327,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    944.9814,  448.6020,  0.0000,
  0.0000,    0.0000,    954.2967,  452.8135,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    923.0194,  449.9920,  0.0000,    0.0000,    0.0000,
  932.1166,  454.2236,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    903.5630,  431.2267,  0.0000,    0.0000,    0.0000,    912.4671,  435.2963,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  720.9847,  452.4916,  0.0000,    0.0000,    0.0000,    728.0053,  456.7532,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    796.6995,  425.6942,
  0.0000,    0.0000,    0.0000,    804.5343,  429.6945,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    770.2908,  431.7667,  0.0000,    0.0000,
  0.0000,    777.8548,  435.8349,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    817.3220,  404.6813,  0.0000,    0.0000,    0.0000,    825.3644,
  408.4793,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    800.1918,  393.3829,  0.0000,    0.0000,    0.0000,    808.0654,  397.0728,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    784.8841,
  390.6589,  0.0000,    0.0000,    0.0000,    792.6061,  394.3257,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    775.2091,  409.4407,  0.0000,
  0.0000,    0.0000,    782.8405,  413.3002,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    659.7049,  377.9207,  0.0000,    0.0000,    0.0000,
  666.1479,  381.4663,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    656.8171,  501.3621,  383.4911,  0.0000,    0.0000,    663.1920,  506.1568,
  387.0805,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  604.1918,  468.8257,  399.2387,  0.0000,    0.0000,    610.0143,  473.2751,  402.9787,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    513.8315,  431.0943,
  373.8314,  0.0000,    0.0000,    518.7353,  435.1515,  377.2983,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    524.1275,  433.3183,  341.6844,  0.0000,
  0.0000,    529.1221,  437.4187,  344.8244,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    478.2557,  386.0410,  323.0585,  0.0000,    0.0000,    482.7801,
  389.6303,  326.0059,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    440.4247,  364.2070,  327.3161,  0.0000,    0.0000,    444.5640,  367.5765,  330.3159,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    368.2592,
  348.4721,  343.9165,  0.0000,    0.0000,    371.6810,  351.6847,  347.0768,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    344.9408,  333.1695,  0.0000,
  0.0000,    0.0000,    348.1308,  336.2337,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    355.5497,  323.8510,  0.0000,    0.0000,    0.0000,
  358.8383,  326.8151,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    504.3185,  504.3841,  411.2748,  369.8357,  0.0000,    509.1150,  509.1742,
  415.1143,  373.2539,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  497.4872,  465.3787,  434.7464,  427.5836,  399.7976,  502.1966,  469.7578,  438.8124,  431.5739,
  403.5058,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    462.0834,  454.3277,
  444.4937,  432.5265,  0.0000,    466.4183,  458.5808,  448.6443,  436.5534,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    443.5300,  444.0535,  442.6417,  0.0000,
  0.0000,    447.6649,  448.1906,  446.7618,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    412.4929,  417.5070,  0.0000,    0.0000,    0.0000,    416.3043,
  421.3660,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    380.7463,  0.0000,    0.0000,    0.0000,    0.0000,    384.2311,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1151.6386,
  524.1530,  0.0000,    0.0000,    0.0000,    1163.0702, 529.1245,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1126.5319, 944.5951,  542.2757,
  0.0000,    0.0000,    1137.6470, 953.8631,  547.4091,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    1006.9141, 559.0941,  0.0000,    0.0000,    0.0000,
  1016.7803, 564.3552,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    917.0920,  638.7892,  0.0000,    0.0000,    0.0000,    925.9812,  644.8430,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  905.1141,  573.6121,  0.0000,    0.0000,    0.0000,    913.9075,  579.0143,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    876.6902,  510.9612,
  0.0000,    0.0000,    0.0000,    885.2021,  515.7402,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    895.2321,  492.6132,  0.0000,    0.0000,
  0.0000,    903.9688,  497.2105,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    868.1868,  579.5652,  0.0000,    0.0000,    0.0000,    876.6519,
  585.0709,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    290.2223,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    1043.3955,
  415.7690,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    985.1266,  822.0568,  440.4668,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    880.8202,  637.9590,  459.5735,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    437.2834,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  878.3798,  424.5915,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    845.6703,  415.8938,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    825.0473,  403.1233,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    806.0002,  404.0174,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    789.1320,  386.1460,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    634.2163,
  406.0479,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    695.4350,  382.3429,  0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    673.1394,  387.2187,  0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    714.6477,  363.7360,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  699.7231,  353.6841,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    686.4452,  351.1344,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    677.7544,  367.3841,  0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    579.5911,  339.8125,  0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    580.1377,  446.2641,  345.4999,  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,    0.0000,
  0