## Published NEP models 

* We publish the NEP models and the related training data (also all the inputs and outputs of the `nep` executable) in the following Gitlab repository: https://gitlab.com/brucefan1983/nep-data
* The NEP model files provided here are just used for creating examples/tutorials. Please check the above Gitlab repository for published NEP models in full detail.

| NEP model file   | Paper for the training data      | Paper for the NEP model   | Comments  |
| --------- | -------------------------------------- | -------------------------------------- | ------------------- |
| Si_2022_NEP3_3body.txt; Si_2022_NEP3_4body.txt; Si_2022_NEP3_5body.txt   | Albert P. Bartók et al., [Machine Learning a General-Purpose Interatomic Potential for Silicon](https://doi.org/10.1103/PhysRevX.8.041048), Phys. Rev. X **8**, 041048 (2018).   | Zheyong Fan et al., [GPUMD: A package for constructing accurate machine-learned potentials and performing highly efficient atomistic simulations](https://aip.scitation.org/doi/10.1063/5.0106617), The Journal of Chemical Physics **157**, 114801 (2022). | General-purpose potential for silicon |
| C_2022_NEP3.txt  | Volker L. Deringer et al., [Machine learning based interatomic potential for amorphous carbon](https://doi.org/10.1103/PhysRevB.95.094203), Phys. Rev. B **95**, 094203 (2017).  | Zheyong Fan et al., [GPUMD: A package for constructing accurate machine-learned potentials and performing highly efficient atomistic simulations](https://aip.scitation.org/doi/10.1063/5.0106617), The Journal of Chemical Physics **157**, 114801 (2022).  | Mainly for amorphous carbon |
| C_2024_NEP4.txt  | Patrick Rowe et al., [An accurate and transferable machine learning potential for carbon](https://doi.org/10.1063/5.0005084), J. Chem. Phys. **153**, 034702 (2020);  | Zheyong Fan et al., [Combining linear-scaling quantum transport and machine-learning molecular dynamics to study thermal and electronic transports in complex materials](https://doi.org/10.1088/1361-648X/ad31c2). Journal of Physics: Condensed Matter **36**, 245901 (2024)  | General-purpose potential for carbon |
| Song-2024-UNEP-v1-AgAlAuCrCuMgMoNiPbPdPtTaTiVWZr.txt  | Keke Song et al., [General-purpose machine-learned potential for 16 elemental metals and their alloys](https://doi.org/10.1038/s41467-024-54554-x), Nature Communications **15**, 10208 (2024) | Keke Song et al., [General-purpose machine-learned potential for 16 elemental metals and their alloys](https://doi.org/10.1038/s41467-024-54554-x), Nature Communications **15**, 10208 (2024) | General-purpose potential for 16 metals and their arbitrary alloys |

