import { OeTester } from "src/app/shared/components/shared/testing/common";
import { QueryHistoricTimeseriesDataResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesDataResponse";
import { QueryHistoricTimeseriesEnergyPerPeriodResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyPerPeriodResponse";
import { QueryHistoricTimeseriesEnergyResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyResponse";

export namespace History {

  /**
   * up to 288 datapoints (5 min aggregated values) from a
   *
   * {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const DAY: OeTester.Types.Channels = ({
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ActualEnergy": 92989,
        "_sum/ActiveChargeEnergy": 30996,
        "_sum/ActiveDischargeEnergy": 30996,
        "_sum/ProductionActiveEnergy": 68068,
        "_sum/EssDcChargeEnergy": 1431,
        "_sum/EssDcDischargeEnergy": 0,
        "charger0/ActualEnergy": 191,
        "ess0/ActiveChargeEnergy": 129907,
        "ess0/ActiveDischargeEnergy": 82382,
        "ess1/ActiveChargeEnergy": 129907,
        "ess1/ActiveDischargeEnergy": 82382,
        "ess1/DcChargeEnergy": 129907,
        "ess1/DcDischargeEnergy": 82382,
        "ess2/ActiveChargeEnergy": 459,
        "ess2/ActiveDischargeEnergy": 9907,
      },
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/ActualPower": [null, null, null, 565.8045977011494, 560.5148514851485, 561.425925925926, 573.2169811320755, 565.8080808080808, 587.9803921568628, 584.2389380530974, 607.4818181818182, 605.0275229357799, 595.6407766990292, 602.5294117647059, 578.1684210526316, 581.6813186813187, 649.5166666666667, 560.3, 567.0373831775701, 629.7672413793103, 568.8613861386139, 589.6039603960396, 634.5090909090909, 622.6633663366337, 617.7196261682243, 608.122641509434, 602.78, 650.8155339805825, 605.8877551020408, 594.3904761904762, 576.36, 565.066037735849, 587.495145631068, 626.375, 681.9428571428572, 650.4629629629629, 631.373831775701, 687.25, 560.2452830188679, 527.8952380952381, 620.2222222222222, 546.6355140186915, 587.8130841121496, 604, 616.295918367347, 578.940594059406, 594.3396226415094, 648.1078431372549, null, null, null, 565.2183908045977, 573.6481481481482, 536.5462962962963, 558.081081081081, 574.7543859649123, 574.3557692307693, 596.9047619047619, 654.072072072072, 615.21, 612.8045977011494, 636.11, 613.7948717948718, 538.8857142857142, 537.1157894736842, 551.1634615384615, 558.8809523809524, 559.1222222222223, 618.5576923076923, 654.3287671232877, 616.0574712643678, 588.9056603773585, 578.7096774193549, 583.0360360360361, 572.5700934579439, 595.2631578947369, 745.0888888888888, 820.7323943661971, 2651.1923076923076, 8063.131147540984, 6952.055555555556, 7413.41052631579, 6695.175, 6688.301075268817, 7135.544444444445, 6935.6125, 6768.398148148148, 6962.593220338983, 3449.51968503937, 677.4427860696518, 982.7305699481865, 858.2012987012987, 767.8924050632911, 761.950495049505, 682.1319796954315, 725.4198473282443, 702.1286549707602, 730.9484536082474, 739, 730.572864321608, 754.7467532467532, 657.373417721519, 640.9480519480519, 669.8156424581006, 787.6280991735537, 2931.229357798165, 1954.2808988764045, 777.5346534653465, 1098.538860103627, 1244.1524390243903, 2919.4913793103447, 2987.4188034188032, 3414.029411764706, 1355.2, 2714.2824427480914, 2657.8703703703704, 2873.892307692308, 6140.337078651685, 3966.560606060606, 3021.5789473684213, 1774.1875, 1076.46, 1426.8691588785048, 1261.0386740331492, 1019.3491124260355, 1194.960199004975, 1241.2878787878788, 3323, 3968.45625, 1468.0961538461538, 3630.4166666666665, 2269.5301204819275, 2554.391025641026, 1845.7888888888888, 1728.9767441860465, 2862.08, 2324.1241379310345, 1964.0169491525423, 1808.4, 3466.05035971223, 2297.4397590361446, 2530.0493827160494, 2439.3584905660377, 2007.9060773480662, 1751.5, 1416.3181818181818, 1429.2298850574712, 1452.0298507462687, 1489.720430107527, 1633.095238095238, 1826.2928571428572, 1610.1904761904761, 1680.9292929292928, 2881.743119266055, 3585.1634615384614, 3689.1666666666665, 3657.340277777778, 3643.5348837209303, 3714.8645833333335, 3731.375, 3744.79, 3636.2363636363634, 4273.113924050633, 3446.2, 3538.714285714286, 3790.6065573770493, 3527.675, 3467.671232876712, 3559.5, 3798.2, 5460.666666666667, 1309.4406779661017, 1535.7454545454545, 3423.8260869565215, 3382.3636363636365, 3400.6315789473683, 2950.75, 3386.731707317073, 2506, 1447.1666666666667, 1442.6, 946, 942.578947368421, 950.7142857142857, 947, 976.2857142857143, 1786.2857142857142, 1513.5777777777778, 1499.5625, 1338, 1327.8125, 1273.9175257731958, 1438.7457627118645, 1248.4186046511627, 1286.6693548387098, 1284.8934911242604, 1223.7952755905512, 748.09375, 871.7684210526315, 844.5338983050848, 791.675, 804.1932773109244, 730.3737373737374, 705.5024390243902, 687.2407407407408, 690.9939759036145, 751, 765.139344262295, 686.8717948717949, 669.7434210526316, 1767.8091603053435, 724.6764705882352, 748.2772277227723, 940.1142857142858, 750.368, 1366.0232558139535, 727.4137931034483, 710.719512195122, 689.8555555555556, 739.453488372093, 817.875, 730.4303797468355, 735.5890410958904, 738.2258064516129, 1906.9217391304348, 2290.785714285714, 1207.5072463768115, 1167.5890410958905, 1229.0208333333333, 1192.3777777777777, 1208.871794871795, 1367.715909090909, 1284.2233009708739, 1163.1739130434783, 1152.53, 1161.4545454545455, 1219.5681818181818, 1183.752808988764, 1197.778947368421, 1233.888888888889, 1275.070588235294, 1235.554054054054, 1207.83908045977, 1241.6184210526317, 1159.042735042735, 1138.2948717948718, 1106.9915966386554, 1171.4504504504505, 1223.822429906542, 1122.169642857143, 1018.8928571428571, 981.8285714285714, 998.8363636363637, 6056.572916666667, 7225.528846153846, 7193.834782608696, 7507.321100917431, 7588.695238095238, 7678.689189189189, 9469.633027522936, 10236.186046511628, 10106.608695652174, 9989.125, 9948.229357798165, 9796.030927835052, 9704.217391304348, 8454.028571428571, 6813.476190476191, 6706.782608695652, 6523.452173913043, 6661.553571428572, 5620.777777777777, 812.3142857142857, 809.5892857142857, 866.4786324786324, 877.8319327731092, 810.8141592920354, 815.7121212121212, 770.6470588235294, 763.3157894736842, 781.5151515151515, 807.5833333333334, 824.743119266055, 876.2151898734177, 882.424, 750.2213114754098, 675.9549549549549, 637.1222222222223],
        "_sum/ActivePower": [null, null, null, 188.60153256704982, 186.83828382838283, 187.141975308642, 191.07232704402517, 188.60269360269362, 195.99346405228758, 194.7463126843658, 202.4939393939394, 201.6758409785933, 198.54692556634305, 200.84313725490196, 192.7228070175439, 193.89377289377288, 216.50555555555556, 186.76666666666665, 189.01246105919003, 209.92241379310346, 189.6204620462046, 196.53465346534654, 211.5030303030303, 207.55445544554456, 205.90654205607476, 202.7075471698113, 200.92666666666665, 216.93851132686083, 201.9625850340136, 198.13015873015874, 192.12, 188.35534591194968, 195.831715210356, 208.79166666666666, 227.31428571428572, 216.820987654321, 210.45794392523365, 229.08333333333334, 186.74842767295596, 175.9650793650794, 206.74074074074073, 182.21183800623052, 195.93769470404985, 201.33333333333334, 205.43197278911566, 192.98019801980197, 198.11320754716982, 216.0359477124183, null, null, null, 188.40613026819923, 191.21604938271605, 178.84876543209876, 186.027027027027, 191.58479532163744, 191.4519230769231, 198.96825396825398, 218.02402402402402, 205.07000000000002, 204.26819923371647, 212.03666666666666, 204.59829059829062, 179.6285714285714, 179.03859649122808, 183.72115384615384, 186.2936507936508, 186.3740740740741, 206.18589743589743, 218.1095890410959, 205.35249042145594, 196.30188679245282, 192.90322580645162, 194.34534534534535, 190.85669781931463, 198.42105263157896, 248.36296296296294, 273.57746478873236, 883.7307692307692, 2687.7103825136614, 2317.3518518518517, 2471.1368421052634, 2231.725, 2229.4336917562723, 2378.514814814815, 2311.8708333333334, 2256.1327160493825, 2320.864406779661, 1149.8398950131234, 225.81426202321725, 327.5768566493955, 286.06709956709955, 255.96413502109704, 253.983498349835, 227.37732656514382, 241.80661577608143, 234.04288499025338, 243.64948453608247, 246.33333333333334, 243.52428810720266, 251.58225108225108, 219.12447257383965, 213.64935064935062, 223.27188081936686, 262.5426997245179, 977.0764525993883, 651.4269662921348, 259.1782178217822, 366.1796200345423, 414.7174796747968, 973.1637931034483, 995.8062678062678, 1138.0098039215686, 451.73333333333335, 904.7608142493638, 885.9567901234568, 957.9641025641026, 2046.7790262172284, 1322.1868686868686, 1007.1929824561404, 591.3958333333334, 358.82, 475.6230529595016, 420.3462246777164, 339.78303747534517, 398.3200663349917, 413.76262626262627, 1107.6666666666667, 1322.8187500000001, 489.3653846153846, 1210.138888888889, 756.5100401606425, 851.4636752136753, 615.2629629629629, 576.3255813953489, 954.0266666666666, 774.7080459770115, 654.6723163841808, 602.8000000000001, 1155.3501199040768, 765.8132530120482, 843.3497942386831, 813.1194968553459, 669.3020257826887, 583.8333333333334, 472.10606060606057, 476.4099616858237, 484.00995024875624, 496.57347670250897, 544.3650793650794, 608.7642857142857, 536.7301587301587, 560.3097643097643, 960.5810397553518, 1195.054487179487, 1229.7222222222222, 1219.1134259259259, 1214.5116279069769, 1238.2881944444446, 1243.7916666666667, 1248.2633333333333, 1212.0787878787878, 1424.3713080168775, 1148.7333333333333, 1179.5714285714287, 1263.535519125683, 1175.8916666666667, 1155.890410958904, 1186.5, 1266.0666666666666, 1820.2222222222224, 436.48022598870057, 511.91515151515154, 1141.2753623188405, 1127.4545454545455, 1133.5438596491229, 983.5833333333334, 1128.910569105691, 835.3333333333334, 482.3888888888889, 480.8666666666666, 315.3333333333333, 314.1929824561403, 316.90476190476187, 315.6666666666667, 325.42857142857144, 595.4285714285714, 504.52592592592595, 499.8541666666667, 446, 442.6041666666667, 424.63917525773195, 479.5819209039548, 416.1395348837209, 428.8897849462366, 428.29783037475346, 407.93175853018374, 249.36458333333334, 290.58947368421053, 281.51129943502826, 263.89166666666665, 268.0644257703081, 243.45791245791247, 235.16747967479674, 229.08024691358025, 230.33132530120483, 250.33333333333334, 255.04644808743168, 228.95726495726498, 223.24780701754386, 589.2697201017812, 241.55882352941174, 249.42574257425744, 313.37142857142857, 250.12266666666667, 455.3410852713178, 242.47126436781608, 236.90650406504065, 229.95185185185187, 246.484496124031, 272.625, 243.47679324894514, 245.19634703196346, 246.07526881720432, 635.640579710145, 763.5952380952381, 402.50241545893715, 389.1963470319635, 409.6736111111111, 397.4592592592592, 402.95726495726495, 455.905303030303, 428.074433656958, 387.72463768115944, 384.1766666666667, 387.1515151515152, 406.52272727272725, 394.5842696629213, 399.25964912280705, 411.2962962962963, 425.0235294117647, 411.8513513513513, 402.61302681992333, 413.8728070175439, 386.34757834757835, 379.43162393162396, 368.99719887955183, 390.4834834834835, 407.94080996884736, 374.05654761904765, 339.63095238095235, 327.2761904761905, 332.94545454545454, 2018.857638888889, 2408.5096153846152, 2397.9449275362317, 2502.440366972477, 2529.5650793650793, 2559.563063063063, 3156.544342507645, 3412.062015503876, 3368.8695652173915, 3329.7083333333335, 3316.0764525993886, 3265.343642611684, 3234.7391304347825, 2818.0095238095237, 2271.15873015873, 2235.5942028985505, 2174.4840579710144, 2220.5178571428573, 1873.5925925925924, 270.77142857142854, 269.86309523809524, 288.8262108262108, 292.6106442577031, 270.27138643067843, 271.9040404040404, 256.88235294117646, 254.43859649122805, 260.5050505050505, 269.19444444444446, 274.914373088685, 292.07172995780587, 294.1413333333333, 250.0737704918033, 225.31831831831832, 212.3740740740741],
        "_sum/ActualReserveSoc": [null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, null, 0, 4104.142857142857, 5829.969696969697, 5806.212121212121, 6195.333333333333, 5777.333333333333, 5786.25, 5789.727272727273, 5789.571428571428, 5783.0526315789475, 5772.657142857143, 4864.8421052631575, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0, null, null, 0, 0, null, 0, 0, null, 0, 0, null, 0, 0, 0, 0, 0, 0, null, 0, null, null, 0, 0, null, null, 0, 0, 0, null, 0, null, null, 0, 0, null, 0, null, null, null, null, 0, null, 0, 0, null, null, null, null, null, 0, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 0, null, 0, null, 0, 0, 0, 0, 0, 0, null, null, 0, 0, null, 0, 0, 0, null, null, 0, 0, null, 0, 0, null, null, null, 0, null, null, null, null, null, null, 0, 0, 0, null, 0, 0, 0, 0, null, 0, null, 0, null, 0, 0, 0, null, 0, 0, 0, 0, 0, 5213.0952380952385, 5787.580645161291, 5789.484848484848, 5790.818181818182, 5807.34375, 5820.136363636364, 5798.862068965517, 5809.041666666667, 5805.5625, 5794.346153846154, 5798, 5740.214285714285, 5727.242424242424, 5742.542857142857, 5753.424242424242, 5752.4, 5731.966666666666, 5734.323529411765, 5335.586206896552, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null],
        "_sum/EssSoc": [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 12, 12, 12, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        "charger0/ActualPower": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, null, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.002, 0.011, 0.02, 0.02, 0.027, 0.041, 0.02, 0.019, 0.019, 0.02, 0.02, 0.017, 0.02, 0.02, 0.019, 0.02, 0.02, 0.02, 0.039, 0.053, 0.074, 0.086, 0.103, 0.157, 0.224, 0.215, 0.245, 0.208, 0.149, 0.178, 0.238, 0.317, 0.219, 0.12, 0.173, 0.199, 0.124, 0.165, 0.215, 0.241, 0.186, 0.202, 0.206, 0.161, 0.149, 0.123, 0.088, 0.045, 0.056, 0.086, 0.086, 0.081, 0.084, 0.089, 0.072, 0.058, 0.04, 0.04, 0.035, 0.02, 0.019, 0.009, 0.003, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        "ess0/ActivePower": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -438, 632, 2180, -2021, -4651, -8742, -15726, -17880, -7107, -722, -784, -948, -5133, -42889, -51210, -62500, -21660, -39364, -45349, -44230, -22220, -9591, -807, -15097, -67130, -66233, -72154, -69315, -69929, -76115, -36219, -4486, -42639, -39104, -18703, -33955, -2112, 0, -7703, 0, 0, 0, -56976, -52859, -45461, -57056, -54724, -58968, -63517, -65445, -44248, -21334, -7053, -3971, -1906, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 403, 2424, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1360, 22224, 22913, 21936, 23195, 21004, 22355, 23392, 21680, 21382, 21621, 23047, 21772, 22248, 21580, 21329, 21263, 22300, 20878, 21109, 22926, 21874, 21585, 21344, 22371, 21639, 21425, 21239, 20585, 17524, 812, 741, 817, 758, 709, 764, 779, 776, 760, 801, 774, 807, 823, 916, 895, 836, 843, 932, 979, 1041, 972, 18636, 22675, 22373, 22476, 22604, 22799, 21397, 23524, 22456, 22706, 23878, 23514, 15044, 12421, 12782, 11917, 12258, 492, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        "ess1/Soc": [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 12, 12, 12, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        "ess1/ActivePower": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -438, 632, 2180, -2021, -4651, -8742, -15726, -17880, -7107, -722, -784, -948, -5133, -42889, -51210, -62500, -21660, -39364, -45349, -44230, -22220, -9591, -807, -15097, -67130, -66233, -72154, -69315, -69929, -76115, -36219, -4486, -42639, -39104, -18703, -33955, -2112, 0, -7703, 0, 0, 0, -56976, -52859, -45461, -57056, -54724, -58968, -63517, -65445, -44248, -21334, -7053, -3971, -1906, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 403, 2424, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1360, 22224, 22913, 21936, 23195, 21004, 22355, 23392, 21680, 21382, 21621, 23047, 21772, 22248, 21580, 21329, 21263, 22300, 20878, 21109, 22926, 21874, 21585, 21344, 22371, 21639, 21425, 21239, 20585, 17524, 812, 741, 817, 758, 709, 764, 779, 776, 760, 801, 774, 807, 823, 916, 895, 836, 843, 932, 979, 1041, 972, 18636, 22675, 22373, 22476, 22604, 22799, 21397, 23524, 22456, 22706, 23878, 23514, 15044, 12421, 12782, 11917, 12258, 492, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        "ess1/DcDischargePower": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -438, 632, 2180, -2021, -4651, -8742, -15726, -17880, -7107, -722, -784, -948, -5133, -42889, -51210, -62500, -21660, -39364, -45349, -44230, -22220, -9591, -807, -15097, -67130, -66233, -72154, -69315, -69929, -76115, -36219, -4486, -42639, -39104, -18703, -33955, -2112, 0, -7703, 0, 0, 0, -56976, -52859, -45461, -57056, -54724, -58968, -63517, -65445, -44248, -21334, -7053, -3971, -1906, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 403, 2424, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1360, 22224, 22913, 21936, 23195, 21004, 22355, 23392, 21680, 21382, 21621, 23047, 21772, 22248, 21580, 21329, 21263, 22300, 20878, 21109, 22926, 21874, 21585, 21344, 22371, 21639, 21425, 21239, 20585, 17524, 812, 741, 817, 758, 709, 764, 779, 776, 760, 801, 774, 807, 823, 916, 895, 836, 843, 932, 979, 1041, 972, 18636, 22675, 22373, 22476, 22604, 22799, 21397, 23524, 22456, 22706, 23878, 23514, 15044, 12421, 12782, 11917, 12258, 492, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
        "ess2/ActivePower": [-33, -31, -31, -29, -28, -29, -29, -30, -32, -33, -30, -32, -31, -31, -29, -31, -31, -29, -28, -30, -28, -29, -28, -28, -29, -29, -31, -31, -31, -31, -29, -28, -30, -31, -29, -29, -30, -31, -30, -28, -28, -29, -28, -29, -29, -27, -27, -26, -26, -28, -29, -29, -28, -29, -27, -27, -29, -28, -27, -30, -31, -31, -29, -31, -30, -30, -30, -31, -31, -30, -29, -30, -28, -28, -27, -30, -29, -28, -28, -29, -29, -31, -30, -29, -29, -27, -29, -31, -29, -30, -28, -28, -28, -31, -29, -28, -28, -28, -26, -28, -27, -28, -28, -28, -28, -27, -39, -27, -36, -30, -34, -30, -36, -38, -25, -35, -23, -20, -32, -39, -46, -35, -29, -32, -32, -35, 423, 303, 307, 293, 328, 364, 408, 400, 501, 512, 612, 566, 578, 537, 549, 556, 608, 967, 1034, 1001, 1054, 1132, 2166, 3200, 3000, 1137, 2122, 2569, 1669, 3115, 4551, 4142, 3169, 2002, 723, 683, 658, 697, 702, 921, 961, 558, 614, 642, 448, 395, 1042, 586, 3192, 3678, 3101, 1940, 1039, 1013, 1057, 1103, 958, 912, 897, 1013, 1429, 2393, 1972, 2177, 474, 430, 397, 481, 542, 495, 782, 839, 895, 874, 911, 568, 475, 528, 572, 580, 585, 675, 1576, 1708, 759, 623, 582, 595, 584, 608, 1144, 1240, 1140, 594, 955, 912, 1947, 850, 729, 671, 720, 644, 1496, 2712, 1649, -30, -30, -31, -30, -31, -30, -30, -30, -29, -31, -31, -31, -32, -31, -31, -30, -31, -30, -30, -30, -30, -28, -29, -30, -29, -30, -30, -29, -31, -30, -30, -30, -30, -31, -30, -30, -29, -28, -26, -29, -29, -30, -30, -32, -32, -32, -33, -32, -32, -32, -32, -32, -31, -31, -33, -32, -32],
        "ctrlEmergencyCapacityReserve0/ActualReserveSoc": [24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, null, 24, null, null, null, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24],
        "_sum/EssActivePower": [-4.615384615384615, -5.15625, -4.827586206896552, -4.883720930232558, -4.933333333333334, -4.920634920634921, -5, -4.929577464788732, -4.814814814814815, -4.880952380952381, -5, -5, -5.070422535211268, -3.3333333333333335, -4.285714285714286, -5, -5, -5, -4.782608695652174, -5, -5, -4.838709677419355, -5, -5.3061224489795915, -5.2, -4.6875, -5.09433962264151, -5.208333333333333, -5, -5, -4.666666666666667, -4.883720930232558, -4.615384615384615, -4.848484848484849, -4.878048780487805, -4.838709677419355, -4.8, -5.161290322580645, -4.827586206896552, -4.680851063829787, -5, -4.9397590361445785, -5.116279069767442, -5, -4.8936170212765955, -4.788732394366197, -4.8979591836734695, -5, -5.087719298245614, -5, -4.90566037735849, -4.901960784313726, -4.888888888888889, -5, -5.128205128205129, -4.7368421052631575, -4.782608695652174, -4.594594594594595, -4.827586206896552, -5, -5.384615384615385, -5, -5.384615384615385, -5, -4.814814814814815, -4.918032786885246, -4.814814814814815, -5.147058823529412, -4.791666666666667, -5, -4.7368421052631575, -5.090909090909091, -4.7368421052631575, -4.888888888888889, -5, -5.090909090909091, -4.883720930232558, -4.615384615384615, -4.848484848484849, -4.864864864864865, -4.666666666666667, -4.8936170212765955, -4.814814814814815, -5.084745762711864, -4.895833333333333, -4.864864864864865, -5, -5.116279069767442, -4.945054945054945, -4.8, -5, -4.925373134328358, -4.827586206896552, -4.705882352941177, -5, -5.189873417721519, -4.861111111111111, -4.90566037735849, -4.871794871794871, -5.15625, -4.871794871794871, -5.277777777777778, -4.6875, -5, -5, -5, -5, -5, -4.888888888888889, -5, -4.814814814814815, -5, -5, -5, -5, -5, -5, -4.705882352941177, -5, -5, -5, 0, -5.384615384615385, -4.285714285714286, -5, -5, -5, -5, -5, -5, -3.888888888888889, -5, -4.666666666666667, -4.8, -5.2631578947368425, -4.545454545454546, -4, -4.545454545454546, -4.444444444444445, -4.545454545454546, -4, -4.444444444444445, -4.444444444444445, -5, -3.3333333333333335, -4.705882352941177, -5, -5, -5, -5, -2.5, -4.705882352941177, -979.2307692307693, -4.666666666666667, -5, -5.555555555555555, -4.2105263157894735, -10, null, -4.705882352941177, -2086.5, -828.3870967741935, -1907.6190476190477, -5, -2640.8045977011493, -147.03703703703704, -330, -258.019801980198, -6051.4049586776855, -3775.757575757576, -4634.96, -796.8, -4.333333333333333, -12.580645161290322, -8.947368421052632, -10.491803278688524, -5.238095238095238, -4.666666666666667, -5.2272727272727275, -4.285714285714286, -5, -6.666666666666667, -4.615384615384615, 0, 0, -10, -3.75, 0, 0, -4.666666666666667, -4.444444444444445, -5, -4.444444444444445, -4.545454545454546, -4.615384615384615, -5, 0, -4.444444444444445, -5.217391304347826, -3.75, -4.285714285714286, -5, -3.3333333333333335, -5.454545454545454, -4.814814814814815, -4.8, -4.285714285714286, -3.75, -4.848484848484849, -5, -4.782608695652174, -5, -4.285714285714286, -5.185185185185185, -4.761904761904762, -4.5, -4.545454545454546, -5, -5.135135135135135, -4.5, -4.482758620689655, -4.6938775510204085, -5.238095238095238, -4.8936170212765955, -4.6875, -5, -4.545454545454546, -5, -4.2105263157894735, -4.878048780487805, -5.090909090909091, -4.838709677419355, -4.782608695652174, -4.8, -5, -5.166666666666667, -4.782608695652174, -5, -4.6, -4.8979591836734695, -5.185185185185185, -4.666666666666667, -4.791666666666667, -5, -5.1063829787234045, -5, -4.871794871794871, -5.5, -5, -4.888888888888889, -4.864864864864865, -5, -5.087719298245614, -4.791666666666667, -5, -4.782608695652174, -4.901960784313726, -4.880952380952381, -4.705882352941177, -4.7368421052631575, -5, -4.918032786885246, -5.172413793103448, -4.852941176470588, -5.125, -4.285714285714286, -4.90566037735849, -4.7368421052631575, -4.814814814814815, -4.583333333333333, -5, -4.814814814814815, -4.8076923076923075, -4.769230769230769, -5.2, -5.283018867924528, -5, -4.912280701754386, -5.079365079365079, -4.927536231884058, -4.680851063829787, -4.791666666666667, -4.827586206896552, -5, -5, -4.545454545454546, -4.705882352941177, -5],
        "_sum/ProductionDcActualPower": [null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
      },
      timestamps: ["2023-07-02T22:00:00Z", "2023-07-02T22:05:00Z", "2023-07-02T22:10:00Z", "2023-07-02T22:15:00Z", "2023-07-02T22:20:00Z", "2023-07-02T22:25:00Z", "2023-07-02T22:30:00Z", "2023-07-02T22:35:00Z", "2023-07-02T22:40:00Z", "2023-07-02T22:45:00Z", "2023-07-02T22:50:00Z", "2023-07-02T22:55:00Z", "2023-07-02T23:00:00Z", "2023-07-02T23:05:00Z", "2023-07-02T23:10:00Z", "2023-07-02T23:15:00Z", "2023-07-02T23:20:00Z", "2023-07-02T23:25:00Z", "2023-07-02T23:30:00Z", "2023-07-02T23:35:00Z", "2023-07-02T23:40:00Z", "2023-07-02T23:45:00Z", "2023-07-02T23:50:00Z", "2023-07-02T23:55:00Z", "2023-07-03T00:00:00Z", "2023-07-03T00:05:00Z", "2023-07-03T00:10:00Z", "2023-07-03T00:15:00Z", "2023-07-03T00:20:00Z", "2023-07-03T00:25:00Z", "2023-07-03T00:30:00Z", "2023-07-03T00:35:00Z", "2023-07-03T00:40:00Z", "2023-07-03T00:45:00Z", "2023-07-03T00:50:00Z", "2023-07-03T00:55:00Z", "2023-07-03T01:00:00Z", "2023-07-03T01:05:00Z", "2023-07-03T01:10:00Z", "2023-07-03T01:15:00Z", "2023-07-03T01:20:00Z", "2023-07-03T01:25:00Z", "2023-07-03T01:30:00Z", "2023-07-03T01:35:00Z", "2023-07-03T01:40:00Z", "2023-07-03T01:45:00Z", "2023-07-03T01:50:00Z", "2023-07-03T01:55:00Z", "2023-07-03T02:00:00Z", "2023-07-03T02:05:00Z", "2023-07-03T02:10:00Z", "2023-07-03T02:15:00Z", "2023-07-03T02:20:00Z", "2023-07-03T02:25:00Z", "2023-07-03T02:30:00Z", "2023-07-03T02:35:00Z", "2023-07-03T02:40:00Z", "2023-07-03T02:45:00Z", "2023-07-03T02:50:00Z", "2023-07-03T02:55:00Z", "2023-07-03T03:00:00Z", "2023-07-03T03:05:00Z", "2023-07-03T03:10:00Z", "2023-07-03T03:15:00Z", "2023-07-03T03:20:00Z", "2023-07-03T03:25:00Z", "2023-07-03T03:30:00Z", "2023-07-03T03:35:00Z", "2023-07-03T03:40:00Z", "2023-07-03T03:45:00Z", "2023-07-03T03:50:00Z", "2023-07-03T03:55:00Z", "2023-07-03T04:00:00Z", "2023-07-03T04:05:00Z", "2023-07-03T04:10:00Z", "2023-07-03T04:15:00Z", "2023-07-03T04:20:00Z", "2023-07-03T04:25:00Z", "2023-07-03T04:30:00Z", "2023-07-03T04:35:00Z", "2023-07-03T04:40:00Z", "2023-07-03T04:45:00Z", "2023-07-03T04:50:00Z", "2023-07-03T04:55:00Z", "2023-07-03T05:00:00Z", "2023-07-03T05:05:00Z", "2023-07-03T05:10:00Z", "2023-07-03T05:15:00Z", "2023-07-03T05:20:00Z", "2023-07-03T05:25:00Z", "2023-07-03T05:30:00Z", "2023-07-03T05:35:00Z", "2023-07-03T05:40:00Z", "2023-07-03T05:45:00Z", "2023-07-03T05:50:00Z", "2023-07-03T05:55:00Z", "2023-07-03T06:00:00Z", "2023-07-03T06:05:00Z", "2023-07-03T06:10:00Z", "2023-07-03T06:15:00Z", "2023-07-03T06:20:00Z", "2023-07-03T06:25:00Z", "2023-07-03T06:30:00Z", "2023-07-03T06:35:00Z", "2023-07-03T06:40:00Z", "2023-07-03T06:45:00Z", "2023-07-03T06:50:00Z", "2023-07-03T06:55:00Z", "2023-07-03T07:00:00Z", "2023-07-03T07:05:00Z", "2023-07-03T07:10:00Z", "2023-07-03T07:15:00Z", "2023-07-03T07:20:00Z", "2023-07-03T07:25:00Z", "2023-07-03T07:30:00Z", "2023-07-03T07:35:00Z", "2023-07-03T07:40:00Z", "2023-07-03T07:45:00Z", "2023-07-03T07:50:00Z", "2023-07-03T07:55:00Z", "2023-07-03T08:00:00Z", "2023-07-03T08:05:00Z", "2023-07-03T08:10:00Z", "2023-07-03T08:15:00Z", "2023-07-03T08:20:00Z", "2023-07-03T08:25:00Z", "2023-07-03T08:30:00Z", "2023-07-03T08:35:00Z", "2023-07-03T08:40:00Z", "2023-07-03T08:45:00Z", "2023-07-03T08:50:00Z", "2023-07-03T08:55:00Z", "2023-07-03T09:00:00Z", "2023-07-03T09:05:00Z", "2023-07-03T09:10:00Z", "2023-07-03T09:15:00Z", "2023-07-03T09:20:00Z", "2023-07-03T09:25:00Z", "2023-07-03T09:30:00Z", "2023-07-03T09:35:00Z", "2023-07-03T09:40:00Z", "2023-07-03T09:45:00Z", "2023-07-03T09:50:00Z", "2023-07-03T09:55:00Z", "2023-07-03T10:00:00Z", "2023-07-03T10:05:00Z", "2023-07-03T10:10:00Z", "2023-07-03T10:15:00Z", "2023-07-03T10:20:00Z", "2023-07-03T10:25:00Z", "2023-07-03T10:30:00Z", "2023-07-03T10:35:00Z", "2023-07-03T10:40:00Z", "2023-07-03T10:45:00Z", "2023-07-03T10:50:00Z", "2023-07-03T10:55:00Z", "2023-07-03T11:00:00Z", "2023-07-03T11:05:00Z", "2023-07-03T11:10:00Z", "2023-07-03T11:15:00Z", "2023-07-03T11:20:00Z", "2023-07-03T11:25:00Z", "2023-07-03T11:30:00Z", "2023-07-03T11:35:00Z", "2023-07-03T11:40:00Z", "2023-07-03T11:45:00Z", "2023-07-03T11:50:00Z", "2023-07-03T11:55:00Z", "2023-07-03T12:00:00Z", "2023-07-03T12:05:00Z", "2023-07-03T12:10:00Z", "2023-07-03T12:15:00Z", "2023-07-03T12:20:00Z", "2023-07-03T12:25:00Z", "2023-07-03T12:30:00Z", "2023-07-03T12:35:00Z", "2023-07-03T12:40:00Z", "2023-07-03T12:45:00Z", "2023-07-03T12:50:00Z", "2023-07-03T12:55:00Z", "2023-07-03T13:00:00Z", "2023-07-03T13:05:00Z", "2023-07-03T13:10:00Z", "2023-07-03T13:15:00Z", "2023-07-03T13:20:00Z", "2023-07-03T13:25:00Z", "2023-07-03T13:30:00Z", "2023-07-03T13:35:00Z", "2023-07-03T13:40:00Z", "2023-07-03T13:45:00Z", "2023-07-03T13:50:00Z", "2023-07-03T13:55:00Z", "2023-07-03T14:00:00Z", "2023-07-03T14:05:00Z", "2023-07-03T14:10:00Z", "2023-07-03T14:15:00Z", "2023-07-03T14:20:00Z", "2023-07-03T14:25:00Z", "2023-07-03T14:30:00Z", "2023-07-03T14:35:00Z", "2023-07-03T14:40:00Z", "2023-07-03T14:45:00Z", "2023-07-03T14:50:00Z", "2023-07-03T14:55:00Z", "2023-07-03T15:00:00Z", "2023-07-03T15:05:00Z", "2023-07-03T15:10:00Z", "2023-07-03T15:15:00Z", "2023-07-03T15:20:00Z", "2023-07-03T15:25:00Z", "2023-07-03T15:30:00Z", "2023-07-03T15:35:00Z", "2023-07-03T15:40:00Z", "2023-07-03T15:45:00Z", "2023-07-03T15:50:00Z", "2023-07-03T15:55:00Z", "2023-07-03T16:00:00Z", "2023-07-03T16:05:00Z", "2023-07-03T16:10:00Z", "2023-07-03T16:15:00Z", "2023-07-03T16:20:00Z", "2023-07-03T16:25:00Z", "2023-07-03T16:30:00Z", "2023-07-03T16:35:00Z", "2023-07-03T16:40:00Z", "2023-07-03T16:45:00Z", "2023-07-03T16:50:00Z", "2023-07-03T16:55:00Z", "2023-07-03T17:00:00Z", "2023-07-03T17:05:00Z", "2023-07-03T17:10:00Z", "2023-07-03T17:15:00Z", "2023-07-03T17:20:00Z", "2023-07-03T17:25:00Z", "2023-07-03T17:30:00Z", "2023-07-03T17:35:00Z", "2023-07-03T17:40:00Z", "2023-07-03T17:45:00Z", "2023-07-03T17:50:00Z", "2023-07-03T17:55:00Z", "2023-07-03T18:00:00Z", "2023-07-03T18:05:00Z", "2023-07-03T18:10:00Z", "2023-07-03T18:15:00Z", "2023-07-03T18:20:00Z", "2023-07-03T18:25:00Z", "2023-07-03T18:30:00Z", "2023-07-03T18:35:00Z", "2023-07-03T18:40:00Z", "2023-07-03T18:45:00Z", "2023-07-03T18:50:00Z", "2023-07-03T18:55:00Z", "2023-07-03T19:00:00Z", "2023-07-03T19:05:00Z", "2023-07-03T19:10:00Z", "2023-07-03T19:15:00Z", "2023-07-03T19:20:00Z", "2023-07-03T19:25:00Z", "2023-07-03T19:30:00Z", "2023-07-03T19:35:00Z", "2023-07-03T19:40:00Z", "2023-07-03T19:45:00Z", "2023-07-03T19:50:00Z", "2023-07-03T19:55:00Z", "2023-07-03T20:00:00Z", "2023-07-03T20:05:00Z", "2023-07-03T20:10:00Z", "2023-07-03T20:15:00Z", "2023-07-03T20:20:00Z", "2023-07-03T20:25:00Z", "2023-07-03T20:30:00Z", "2023-07-03T20:35:00Z", "2023-07-03T20:40:00Z", "2023-07-03T20:45:00Z", "2023-07-03T20:50:00Z", "2023-07-03T20:55:00Z", "2023-07-03T21:00:00Z", "2023-07-03T21:05:00Z", "2023-07-03T21:10:00Z", "2023-07-03T21:15:00Z", "2023-07-03T21:20:00Z", "2023-07-03T21:25:00Z", "2023-07-03T21:30:00Z", "2023-07-03T21:35:00Z", "2023-07-03T21:40:00Z", "2023-07-03T21:45:00Z", "2023-07-03T21:50:00Z", "2023-07-03T21:55:00Z"],
    }),
  });

  /**
   * up to 164 datapoints(1 hour values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const WEEK: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ActualEnergy": 354079,
        "_sum/ActiveChargeEnergy": 157027,
        "_sum/ActiveDischargeEnergy": 100000,
        "_sum/EssDcChargeEnergy": 30996,
        "_sum/EssDcDischargeEnergy": 13720,
        "_sum/ProductionActiveEnergy": 15930,
        "charger0/ActualEnergy": 4959,
        "ess0/ActiveChargeEnergy": 22453,
        "ess0/ActiveDischargeEnergy": 42199,
        "ess1/ActiveChargeEnergy": 2151,
        "ess1/ActiveDischargeEnergy": 42671,
        "ess1/DcChargeEnergy": 2151,
        "ess1/DcDischargeEnergy": 42671,
        "ess2/ActiveChargeEnergy": 3531,
        "ess2/ActiveDischargeEnergy": 21013,
      },
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/ActualPower": [663.9876181166504, 937.5188284518829, 761.5839462743844, 599.7653758542141, 989.6435035552682, 666.2890016920473, 1054.177495462795, 1042.9070871481858, 661.1515631183221, 734.2340980187696, 845.5174603174603, 969.5830886670582, 591.8473777253978, 1960.0339449541284, 919.7469512195122, 1232.6632911392405, 562.9648946840522, 786.2627471383975, 931.422932330827, 837.381753312946, 1112.3010184835912, 902.5108194395176, 807.5094273743017, 988.311229946524, 614.0189035916824, 868.6555377207062, 906.9389035667107, 673.3970826580227, 827.6491228070175, 851.9108776685869, 852.9105374823197, 867.4681647940075, 1303.01722614841, 950.6813929313929, 1124.7157794676807, 908.7814790139906, 1554.5020215633424, 4743.944086021505, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "_sum/ActivePower": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4586.923076923077, 4846.2192982456145, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "_sum/EssActivePower": [27.956773446545736, 27.93238434163701, 28.003065134099618, 27.952205882352942, 27.998854961832063, 28.116988416988416, 27.987117552334944, 28.404306220095695, 22.10508757297748, 24.58289572393098, 25.521831735889243, 33.94027565084227, 66.40016920473774, 74.85995085995086, 56.30216802168022, 40.562390158172235, 42.72727272727273, 41.85823488533704, 29.56647864625302, 26.93582887700535, 29.227223427331886, 31.081920903954803, 29.50079575596817, 29.29895178197065, 27.74064837905237, 27.340638930163447, 27.272103350827614, 27.199391171993913, 26.97577592732778, 26.88116057233704, 27.04352806414662, 26.709154929577466, 24.765209940017137, 20.726594301221166, 24.283930058284763, 27.086363636363636, 47.70666666666666, 53.07067510548523, 52.73466476462197, 54.75776892430279, 50.23135033050047, 41.280141843971634, 31.509341199606688, 26.471978392977718, 31.050412465627865, 29.384710234278668, 27.95327604726101, 28.357904496986556, 25.56408588158751, null, 26.944094488188977, 27.036082474226806, 26.367164179104478, 25.185562632696392, 26.994444444444444, 25.911782850092536, 13.431970713849909, 24.309846431797652, 25.234712230215827, 26.126705653021443, 60.64339781328848, 39.96433289299868, 37.667578659370726, 50.66542750929368, 41.89218523878437, 29.88109495295124, 26.93968253968254, 25.741935483870968, 28.64, 31.331460674157302, 30.017262638717632, 28.636402753872634, 28.408956692913385, 28.14567233384853, 28.25509028044564, 28.12612966601179, 28.175675675675677, 27.409126063418405, 27.54943984413054, 27.246363209760677, 22.96663244353183, 21.65732959850607, 22.306306306306308, 25.892307692307693, 51.8, 52.903225806451616, 59.02597402597402, 39.35110294117647, 33.87375113533152, 29.98160073597056, 26.481973434535103, 29.473684210526315, 28.432854465958776, 29.162214983713355, 28.663861386138613, 28.23558082859464, 28.460033305578683, 29.076231430805315, 28.803389830508475, 28.62062404870624, 28.578023655093475, 28.370570107858242, 27.46546431312356, 27.873293515358363, 25.733505154639175, 26.357802874743328, 27.692853246044734, 24.205128205128204, null, 26.746031746031747, 23.178571428571427, 26.16861826697892, 28.333646616541355, 26.758232235701907, 23.993934142114384, 24.71902131018153, 28.23051948051948, 28.74572127139364, 28.485825458588103, 28.22232263895165, 28.392755392755394, 28.338354151359294, 27.164207340143776, 26.949324324324323, 26.942610652663166, 27.8092203898051, 27.980593607305938, 28.26596758817922, 29.656794425087107, 25.145056246299585, 25.203214100570243, 28.82728749323227, 32.22576966932725, 31.200444197667963, 30.594259988745076, 43.34990059642147, 46.15876288659794, 33.40802469135802, 27.489320388349515, 25.818808777429467, 27.95967741935484, 28.96995139195758, 27.5499557913351, 28.341370558375633, 28.25076053889613, 27.812838360402164, 28.10333080999243, 27.840314136125656, 27.800384615384615, 27.97958397534669, 27.235769230769233, 26.924960505529224, 29.03847980997625, 27.93128390596745, 34.10349373764008, 32.7387339055794, 29.509929906542055, 37.00855745721272, 32.240085744908896, 27.701363636363638, 30.787037037037038, 25.786028602860284, 29.997148966500358, 32.89406099518459, 35.328729281767956, 25.65564738292011, 27.46238030095759, 28.27226647356988],
        "_sum/ProductionDcActualPower": [null, null, null, 188.60153256704982, 186.83828382838283, 187.141975308642, 191.07232704402517, 188.60269360269362, 195.99346405228758, 194.7463126843658, 202.4939393939394, 201.6758409785933, 198.54692556634305, 200.84313725490196, 192.7228070175439, 193.89377289377288, 216.50555555555556, 186.76666666666665, 189.01246105919003, 209.92241379310346, 189.6204620462046, 196.53465346534654, 211.5030303030303, 207.55445544554456, 205.90654205607476, 202.7075471698113, 200.92666666666665, 216.93851132686083, 201.9625850340136, 198.13015873015874, 192.12, 188.35534591194968, 195.831715210356, 208.79166666666666, 227.31428571428572, 216.820987654321, 210.45794392523365, 229.08333333333334, 186.74842767295596, 175.9650793650794, 206.74074074074073, 182.21183800623052, 195.93769470404985, 201.33333333333334, 205.43197278911566, 192.98019801980197, 198.11320754716982, 216.0359477124183, null, null, null, 188.40613026819923, 191.21604938271605, 178.84876543209876, 186.027027027027, 191.58479532163744, 191.4519230769231, 198.96825396825398, 218.02402402402402, 205.07000000000002, 204.26819923371647, 212.03666666666666, 204.59829059829062, 179.6285714285714, 179.03859649122808, 183.72115384615384, 186.2936507936508, 186.3740740740741, 206.18589743589743, 218.1095890410959, 205.35249042145594, 196.30188679245282, 192.90322580645162, 194.34534534534535, 190.85669781931463, 198.42105263157896, 248.36296296296294, 273.57746478873236, 883.7307692307692, 2687.7103825136614, 2317.3518518518517, 2471.1368421052634, 2231.725, 2229.4336917562723, 2378.514814814815, 2311.8708333333334, 2256.1327160493825, 2320.864406779661, 1149.8398950131234, 225.81426202321725, 327.5768566493955, 286.06709956709955, 255.96413502109704, 253.983498349835, 227.37732656514382, 241.80661577608143, 234.04288499025338, 243.64948453608247, 246.33333333333334, 243.52428810720266, 251.58225108225108, 219.12447257383965, 213.64935064935062, 223.27188081936686, 262.5426997245179, 977.0764525993883, 651.4269662921348, 259.1782178217822, 366.1796200345423, 414.7174796747968, 973.1637931034483, 995.8062678062678, 1138.0098039215686, 451.73333333333335, 904.7608142493638, 885.9567901234568, 957.9641025641026, 2046.7790262172284, 1322.1868686868686, 1007.1929824561404, 591.3958333333334, 358.82, 475.6230529595016, 420.3462246777164, 339.78303747534517, 398.3200663349917, 413.76262626262627, 1107.6666666666667, 1322.8187500000001, 489.3653846153846, 1210.138888888889, 756.5100401606425, 851.4636752136753, 615.2629629629629, 576.3255813953489, 954.0266666666666, 774.7080459770115, 654.6723163841808, 602.8000000000001, 1155.3501199040768, 765.8132530120482, 843.3497942386831, 813.1194968553459, 669.3020257826887, 583.8333333333334, 472.10606060606057, 476.4099616858237, 484.00995024875624, 496.57347670250897, 544.3650793650794, 608.7642857142857, 536.7301587301587, 560.3097643097643, 960.5810397553518, 1195.054487179487, 1229.7222222222222, 1219.1134259259259, 1214.5116279069769, 1238.2881944444446, 1243.7916666666667, 1248.2633333333333, 1212.0787878787878, 1424.3713080168775, 1148.7333333333333, 1179.5714285714287, 1263.535519125683, 1175.8916666666667, 1155.890410958904, 1186.5, 1266.0666666666666, 1820.2222222222224, 436.48022598870057, 511.91515151515154, 1141.2753623188405, 1127.4545454545455, 1133.5438596491229, 983.5833333333334, 1128.910569105691, 835.3333333333334, 482.3888888888889, 480.8666666666666, 315.3333333333333, 314.1929824561403, 316.90476190476187, 315.6666666666667, 325.42857142857144, 595.4285714285714, 504.52592592592595, 499.8541666666667, 446, 442.6041666666667, 424.63917525773195, 479.5819209039548, 416.1395348837209, 428.8897849462366, 428.29783037475346, 407.93175853018374, 249.36458333333334, 290.58947368421053, 281.51129943502826, 263.89166666666665, 268.0644257703081, 243.45791245791247, 235.16747967479674, 229.08024691358025, 230.33132530120483, 250.33333333333334, 255.04644808743168, 228.95726495726498, 223.24780701754386, 589.2697201017812, 241.55882352941174, 249.42574257425744, 313.37142857142857, 250.12266666666667, 455.3410852713178, 242.47126436781608, 236.90650406504065, 229.95185185185187, 246.484496124031, 272.625, 243.47679324894514, 245.19634703196346, 246.07526881720432, 635.640579710145, 763.5952380952381, 402.50241545893715, 389.1963470319635, 409.6736111111111, 397.4592592592592, 402.95726495726495, 455.905303030303, 428.074433656958, 387.72463768115944, 384.1766666666667, 387.1515151515152, 406.52272727272725, 394.5842696629213, 399.25964912280705, 411.2962962962963, 425.0235294117647, 411.8513513513513, 402.61302681992333, 413.8728070175439, 386.34757834757835, 379.43162393162396, 368.99719887955183, 390.4834834834835, 407.94080996884736, 374.05654761904765, 339.63095238095235, 327.2761904761905, 332.94545454545454, 2018.857638888889, 2408.5096153846152, 2397.9449275362317, 2502.440366972477, 2529.5650793650793, 2559.563063063063, 3156.544342507645, 3412.062015503876, 3368.8695652173915, 3329.7083333333335, 3316.0764525993886, 3265.343642611684, 3234.7391304347825, 2818.0095238095237, 2271.15873015873, 2235.5942028985505, 2174.4840579710144, 2220.5178571428573, 1873.5925925925924, 270.77142857142854, 269.86309523809524, 288.8262108262108, 292.6106442577031, 270.27138643067843, 271.9040404040404, 256.88235294117646, 254.43859649122805, 260.5050505050505, 269.19444444444446, 274.914373088685, 292.07172995780587, 294.1413333333333, 250.0737704918033, 225.31831831831832, 212.3740740740741],
        "_sum/ActualReserveSoc": [null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, null, 0, 4104.142857142857, 5829.969696969697, 5806.212121212121, 6195.333333333333, 5777.333333333333, 5786.25, 5789.727272727273, 5789.571428571428, 5783.0526315789475, 5772.657142857143, 4864.8421052631575, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0, null, null, 0, 0, null, 0, 0, null, 0, 0, null, 0, 0, 0, 0, 0, 0, null, 0, null, null, 0, 0, null, null, 0, 0, 0, null, 0, null, null, 0, 0, null, 0, null, null, null, null, 0, null, 0, 0, null, null, null, null, null, 0, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 0, null, 0, null, 0, 0, 0, 0, 0, 0, null, null, 0, 0, null, 0, 0, 0, null, null, 0, 0, null, 0, 0, null, null, null, 0, null, null, null, null, null, null, 0, 0, 0, null, 0, 0, 0, 0, null, 0, null, 0, null, 0, 0, 0, null, 0, 0, 0, 0, 0, 5213.0952380952385, 5787.580645161291, 5789.484848484848, 5790.818181818182, 5807.34375, 5820.136363636364, 5798.862068965517, 5809.041666666667, 5805.5625, 5794.346153846154, 5798, 5740.214285714285, 5727.242424242424, 5742.542857142857, 5753.424242424242, 5752.4, 5731.966666666666, 5734.323529411765, 5335.586206896552, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null],
        "charger0/ActualPower": [0, 0, 0, 0, 0, 0, 0, 0, 9.083333333333334, 48.083333333333336, 99.25, 51.083333333333336, 23.75, 17.75, 21.25, 0.8333333333333334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21.583333333333332, 135.16666666666666, 238.83333333333334, 311.8333333333333, 168.08333333333334, 76.83333333333333, 31.416666666666668, 13.833333333333334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13.833333333333334, 24.916666666666668, 114.5, 83.58333333333333, 157.66666666666666, 173.83333333333334, 146.5, 40.083333333333336, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 78.33333333333333, 230.75, 167.41666666666666, 87, 77.25, 121.83333333333333, 12.666666666666666, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.833333333333334, 32.5, 52.583333333333336, 181.91666666666666, 319.4166666666667, 249.83333333333334, 68.75, 20.833333333333332, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.75, 19.333333333333332, 57.416666666666664, 204.91666666666666, 155, 36.166666666666664, 14.416666666666666, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23.916666666666668, 58, 81.16666666666667, 60.916666666666664, 107.58333333333333, 299.4166666666667, 60.083333333333336, 28.333333333333332, 0.75, 0, 0, 0, 0, 0, 0, 0],
        "charger0/ActualPower1": [0, 0, 0, 0, 0, 0, 0, 0, 9.083333333333334, 48.083333333333336, 99.25, 51.083333333333336, 23.75, 17.75, 21.25, 0.8333333333333334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21.583333333333332, 135.16666666666666, 238.83333333333334, 311.8333333333333, 168.08333333333334, 76.83333333333333, 31.416666666666668, 13.833333333333334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13.833333333333334, 24.916666666666668, 114.5, 83.58333333333333, 157.66666666666666, 173.83333333333334, 146.5, 40.083333333333336, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 78.33333333333333, 230.75, 167.41666666666666, 87, 77.25, 121.83333333333333, 12.666666666666666, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.833333333333334, 32.5, 52.583333333333336, 181.91666666666666, 319.4166666666667, 249.83333333333334, 68.75, 20.833333333333332, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.75, 19.333333333333332, 57.416666666666664, 204.91666666666666, 155, 36.166666666666664, 14.416666666666666, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23.916666666666668, 58, 81.16666666666667, 60.916666666666664, 107.58333333333333, 299.4166666666667, 60.083333333333336, 28.333333333333332, 0.75, 0, 0, 0, 0, 0, 0, 0],
        "charger0/ActualPower2": [0, 0, 0, 0, 0, 0, 0, 0, 9.083333333333334, 48.083333333333336, 99.25, 51.083333333333336, 23.75, 17.75, 21.25, 0.8333333333333334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21.583333333333332, 135.16666666666666, 238.83333333333334, 311.8333333333333, 168.08333333333334, 76.83333333333333, 31.416666666666668, 13.833333333333334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13.833333333333334, 24.916666666666668, 114.5, 83.58333333333333, 157.66666666666666, 173.83333333333334, 146.5, 40.083333333333336, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 78.33333333333333, 230.75, 167.41666666666666, 87, 77.25, 121.83333333333333, 12.666666666666666, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.833333333333334, 32.5, 52.583333333333336, 181.91666666666666, 319.4166666666667, 249.83333333333334, 68.75, 20.833333333333332, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8.75, 19.333333333333332, 57.416666666666664, 204.91666666666666, 155, 36.166666666666664, 14.416666666666666, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23.916666666666668, 58, 81.16666666666667, 60.916666666666664, 107.58333333333333, 299.4166666666667, 60.083333333333336, 28.333333333333332, 0.75, 0, 0, 0, 0, 0, 0, 0],
        "ess0/ActivePower": [-124.58333333333333, -124.5, -124.33333333333333, -124.5, -123.5, -123.58333333333333, -121.83333333333333, -111.75, -89.16666666666667, -244.41666666666666, -696.1666666666666, -462.75, -647.5, 558.5833333333334, 360.25, 147.41666666666666, 178.25, 700.3333333333334, 769.75, 592.5833333333334, 284.6666666666667, 707.9166666666666, 157.91666666666666, 246.5, 199.83333333333334, 200.33333333333334, -38.166666666666664, -121.83333333333333, -123.16666666666667, -122.66666666666667, -123.16666666666667, -104.58333333333333, -72.5, -343.5833333333333, -331.9166666666667, -114.75, -435.9166666666667, -377.75, 70.33333333333333, 1865.25, 3189.5833333333335, -121.83333333333333, -125.16666666666667, -125.75, -125, -125.25, -125.75, -124.83333333333333, -126.5, -124.75, -126.33333333333333, -126.41666666666667, -125.33333333333333, -125.91666666666667, -124.16666666666667, -109.91666666666667, -130, -328.0833333333333, -243.5, 254.75, 658.4166666666666, 1756.5, 1358.5833333333333, 117.25, 35.916666666666664, 41.666666666666664, 86, 2029.9166666666667, 2356.4166666666665, -127.25, -127.91666666666667, -126.33333333333333, -126.5, -127.25, -127.66666666666667, -125.91666666666667, -128, -127.33333333333333, -127.5, -111.16666666666667, -95.33333333333333, -287.75, 181.75, -55.666666666666664, -123.41666666666667, 2517.1666666666665, 2751.8333333333335, 3.4166666666666665, 302.8333333333333, 208.08333333333334, -121.25, -121.33333333333333, -122, -122.08333333333333, -123.16666666666667, -122.91666666666667, -123.58333333333333, -123.16666666666667, -124.33333333333333, -125.08333333333333, -125.25, -124.83333333333333, -125.25, -111.08333333333333, -71.33333333333333, -229.33333333333334, -489.8333333333333, -481.4166666666667, -835.4166666666666, 137.33333333333334, 515.0833333333334, 44.75, 2198.5, 1947.9166666666667, 294.9166666666667, 183, -125.75, -127, -128.66666666666666, -127.5, -129.16666666666666, -129.91666666666666, -129.33333333333334, -128.41666666666666, -127.5, -128.75, -128.08333333333334, -113.75, -81.33333333333333, -319.75, -429.0833333333333, 2383.75, 1902.9166666666667, 9.916666666666666, -598.75, 187.41666666666666, 858.75, 326.25, 159.91666666666666, 256.75, 399.25, 659.25, -125.58333333333333, -127.41666666666667, -128.33333333333334, -129.16666666666666, -128.91666666666666, -128.41666666666666, -128.75, -127.66666666666667, -128.16666666666666, -110.5, -135.41666666666666, -460.5833333333333, -484.9166666666667, -214.75, -625.9166666666666, 363.5, 402.25, 62.916666666666664, 145, 61.25, 294.3333333333333, 321.3333333333333, 223.91666666666666, 133.33333333333334, 147.41666666666666, 141.83333333333334],
        "ess1/Soc": [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11.666666666666666, 13.75, 10.75, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.583333333333334, 10.25, 11.416666666666666, 10.583333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.25, 11.166666666666666, 10.083333333333334, 11.333333333333334, 10.916666666666666, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.166666666666666, 12.416666666666666, 16.083333333333332, 17.166666666666668, 12.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11.916666666666666, 19.916666666666668, 31.75, 39.333333333333336, 39.916666666666664, 32, 21.916666666666668, 13.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.5, 10, 10, 10.833333333333334, 10.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10],
        "ess1/ActivePower": [235.25, 112.83333333333333, 105.08333333333333, 126.91666666666667, 80.83333333333333, 70.33333333333333, 169.91666666666666, 102.41666666666667, 66.41666666666667, 342.8333333333333, 221.75, 350, 1363.9166666666667, 2371.25, 1981, 677.3333333333334, 527.4166666666666, 292.6666666666667, 252.5, 393.5, 362.9166666666667, 268.3333333333333, 349.75, 367.3333333333333, 132.91666666666666, 139.08333333333334, 85.25, 70.75, 123.91666666666667, 107.25, 172.08333333333334, 169.91666666666666, 258.6666666666667, 285.1666666666667, 107.08333333333333, 182.83333333333334, 153.66666666666666, 1404.25, 736.5833333333334, 263.6666666666667, 186.58333333333334, 476, 53.75, -40.5, -42.333333333333336, -40.833333333333336, -39.5, -41, -40.333333333333336, -39.75, -42.083333333333336, -40.666666666666664, -40.666666666666664, -40.333333333333336, -40.833333333333336, -39.583333333333336, -34.166666666666664, 385.1666666666667, 241.66666666666666, 362.0833333333333, 2664.3333333333335, 1904.5, 2025.090909090909, 865.5, 219.66666666666666, 575.4166666666666, 422.1666666666667, 786.25, 289.0833333333333, 257, 232, 347.8333333333333, 160.5, 59.083333333333336, 79.41666666666667, 116.25, 59.416666666666664, 54.083333333333336, 145.25, 137.91666666666666, 259, 356.5833333333333, 187.75, 155.41666666666666, 240.5, 1560.4166666666667, 1042, 215, 126.08333333333333, 301.4166666666667, 365.25, 251.75, 538.5833333333334, 246.33333333333334, 309.8333333333333, 310.6666666666667, 112.08333333333333, 117.08333333333333, 111.83333333333333, 86.91666666666667, 73.25, 113.91666666666667, 366.6666666666667, 91.16666666666667, 134.33333333333334, 280, 211.91666666666666, 173.33333333333334, 393.3333333333333, 178, 622.0833333333334, 178, 352.5833333333333, 223.66666666666666, 194, 681.25, 242.58333333333334, 224.66666666666666, 385.3333333333333, 172.91666666666666, 106.41666666666667, 148.33333333333334, 36.833333333333336, -18.416666666666668, -19.583333333333332, -20.333333333333332, -20.25, -19.583333333333332, -40.81818181818182, -30.333333333333332, 77, 227.75, 290.5, 604.4166666666666, 211.58333333333334, 4.083333333333333, -29.666666666666668, -33, -33.75, -34, -31.5, -32.5, -32.833333333333336, -32.416666666666664, -31.583333333333332, -34.333333333333336, -31.75, -31.5, -31.75, -32.833333333333336, -30.583333333333332, -31.083333333333332, -27.916666666666668, -31.583333333333332, -35, -29.583333333333332, -37.416666666666664, -38.25, -35.333333333333336, -35.833333333333336, -32.916666666666664, -33.75, -34.75, -33.416666666666664, -30.25, -29.583333333333332, -30, -32.416666666666664],
        "ess1/DcDischargePower": [235.25, 112.83333333333333, 105.08333333333333, 126.91666666666667, 80.83333333333333, 70.33333333333333, 169.91666666666666, 102.41666666666667, 66.41666666666667, 342.8333333333333, 221.75, 350, 1363.9166666666667, 2371.25, 1981, 677.3333333333334, 527.4166666666666, 292.6666666666667, 252.5, 393.5, 362.9166666666667, 268.3333333333333, 349.75, 367.3333333333333, 132.91666666666666, 139.08333333333334, 85.25, 70.75, 123.91666666666667, 107.25, 172.08333333333334, 169.91666666666666, 258.6666666666667, 285.1666666666667, 107.08333333333333, 182.83333333333334, 153.66666666666666, 1404.25, 736.5833333333334, 263.6666666666667, 186.58333333333334, 476, 53.75, -40.5, -42.333333333333336, -40.833333333333336, -39.5, -41, -40.333333333333336, -39.75, -42.083333333333336, -40.666666666666664, -40.666666666666664, -40.333333333333336, -40.833333333333336, -39.583333333333336, -34.166666666666664, 385.1666666666667, 241.66666666666666, 362.0833333333333, 2664.3333333333335, 1904.5, 2025.090909090909, 865.5, 219.66666666666666, 575.4166666666666, 422.1666666666667, 786.25, 289.0833333333333, 257, 232, 347.8333333333333, 160.5, 59.083333333333336, 79.41666666666667, 116.25, 59.416666666666664, 54.083333333333336, 145.25, 137.91666666666666, 259, 356.5833333333333, 187.75, 155.41666666666666, 240.5, 1560.4166666666667, 1042, 215, 126.08333333333333, 301.4166666666667, 365.25, 251.75, 538.5833333333334, 246.33333333333334, 309.8333333333333, 310.6666666666667, 112.08333333333333, 117.08333333333333, 111.83333333333333, 86.91666666666667, 73.25, 113.91666666666667, 366.6666666666667, 91.16666666666667, 134.33333333333334, 280, 211.91666666666666, 173.33333333333334, 393.3333333333333, 178, 622.0833333333334, 178, 352.5833333333333, 223.66666666666666, 194, 681.25, 242.58333333333334, 224.66666666666666, 385.3333333333333, 172.91666666666666, 106.41666666666667, 148.33333333333334, 36.833333333333336, -18.416666666666668, -19.583333333333332, -20.333333333333332, -20.25, -19.583333333333332, -40.81818181818182, -30.333333333333332, 77, 227.75, 290.5, 604.4166666666666, 211.58333333333334, 4.083333333333333, -29.666666666666668, -33, -33.75, -34, -31.5, -32.5, -32.833333333333336, -32.416666666666664, -31.583333333333332, -34.333333333333336, -31.75, -31.5, -31.75, -32.833333333333336, -30.583333333333332, -31.083333333333332, -27.916666666666668, -31.583333333333332, -35, -29.583333333333332, -37.416666666666664, -38.25, -35.333333333333336, -35.833333333333336, -32.916666666666664, -33.75, -34.75, -33.416666666666664, -30.25, -29.583333333333332, -30, -32.416666666666664],
        "ess2/ActivePower": [-29.166666666666668, -30.083333333333332, -28.25, -29.083333333333332, -30, -30.416666666666668, -29, -28.166666666666668, -25.916666666666668, 34.166666666666664, 261.3333333333333, 576.3333333333334, 579.3333333333334, 568.9166666666666, 518.25, 93.16666666666667, -21.916666666666668, -26, -25.916666666666668, -26.25, -24.916666666666668, -26.25, -25.916666666666668, -28.583333333333332, -28, -28.5, -28.25, -27, -27.75, -27.75, -28.583333333333332, -29.166666666666668, -28.25, -23.916666666666668, 32.083333333333336, 70.25, 353.75, 215, 68.41666666666667, -4.75, -26.583333333333332, -28, -29.333333333333332, -27.583333333333332, -25, -25.916666666666668, -26.666666666666668, -27.583333333333332, -27.916666666666668, -27.333333333333332, -29.666666666666668, -27.833333333333332, -26.083333333333332, -25, -24.666666666666668, -25.333333333333332, -25, 78.58333333333333, 395.0833333333333, 372.9166666666667, 454, 397, 382.0833333333333, 1555.1666666666667, 935.6666666666666, 91.41666666666667, -29.5, -28.5, -27.416666666666668, -27.916666666666668, -29.666666666666668, -29.25, -29.75, -29.5, -29.5, -30.333333333333332, -29.083333333333332, -29.75, -30.583333333333332, -29.166666666666668, -25, 147.33333333333334, 344.25, 493, 512.1666666666666, 1415.0833333333333, 1176.8333333333333, 64.66666666666667, -31.333333333333332, -30.833333333333332, -31, -32.25, -30.666666666666668, -32.166666666666664, -31.5, -31.25, -31.25, -30.75, -30.5, -30.333333333333332, -30.25, -30.416666666666668, -29.916666666666668, -31.583333333333332, -31.5, 4.25, 23, 32.5, 86.75, 199.83333333333334, 92.75, -22.666666666666668, -29.5, -27.916666666666668, -29, -28.75, -29.166666666666668, -30, -30.166666666666668, -29.333333333333332, -27.333333333333332, -30.25, -31.083333333333332, -30.75, -30.916666666666668, -28.416666666666668, -28.333333333333332, -27.333333333333332, -28, -10, 153.75, 228.5, 157, 105, 28, -21.083333333333332, -29.5, -28.416666666666668, -27.833333333333332, -29.25, -28.833333333333332, -30.583333333333332, -29.75, -29.166666666666668, -29.25, -29, -27.333333333333332, -27.75, -28, -29.083333333333332, -29.166666666666668, -30.333333333333332, -29, 50.666666666666664, 692.75, 1013.1666666666666, 1973, 740.5, 1410.5, 1613.1666666666667, 125.83333333333333, -29.666666666666668, -31.583333333333332, -31.833333333333332, -32.583333333333336, -31.5, -32.25, -29.5],
        "ctrlEmergencyCapacityReserve0/ActualReserveSoc": [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
        "_sum/EssSoc": [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11.666666666666666, 13.75, 10.75, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.583333333333334, 10.25, 11.416666666666666, 10.583333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.25, 11.166666666666666, 10.083333333333334, 11.333333333333334, 10.916666666666666, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.166666666666666, 12.416666666666666, 16.083333333333332, 17.166666666666668, 12.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11.916666666666666, 19.916666666666668, 31.75, 39.333333333333336, 39.916666666666664, 32, 21.916666666666668, 13.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.5, 10, 10, 10.833333333333334, 10.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10],
      },
      timestamps: ["2023-06-25T22:00:00Z", "2023-06-25T23:00:00Z", "2023-06-26T00:00:00Z", "2023-06-26T01:00:00Z", "2023-06-26T02:00:00Z", "2023-06-26T03:00:00Z", "2023-06-26T04:00:00Z", "2023-06-26T05:00:00Z", "2023-06-26T06:00:00Z", "2023-06-26T07:00:00Z", "2023-06-26T08:00:00Z", "2023-06-26T09:00:00Z", "2023-06-26T10:00:00Z", "2023-06-26T11:00:00Z", "2023-06-26T12:00:00Z", "2023-06-26T13:00:00Z", "2023-06-26T14:00:00Z", "2023-06-26T15:00:00Z", "2023-06-26T16:00:00Z", "2023-06-26T17:00:00Z", "2023-06-26T18:00:00Z", "2023-06-26T19:00:00Z", "2023-06-26T20:00:00Z", "2023-06-26T21:00:00Z", "2023-06-26T22:00:00Z", "2023-06-26T23:00:00Z", "2023-06-27T00:00:00Z", "2023-06-27T01:00:00Z", "2023-06-27T02:00:00Z", "2023-06-27T03:00:00Z", "2023-06-27T04:00:00Z", "2023-06-27T05:00:00Z", "2023-06-27T06:00:00Z", "2023-06-27T07:00:00Z", "2023-06-27T08:00:00Z", "2023-06-27T09:00:00Z", "2023-06-27T10:00:00Z", "2023-06-27T11:00:00Z", "2023-06-27T12:00:00Z", "2023-06-27T13:00:00Z", "2023-06-27T14:00:00Z", "2023-06-27T15:00:00Z", "2023-06-27T16:00:00Z", "2023-06-27T17:00:00Z", "2023-06-27T18:00:00Z", "2023-06-27T19:00:00Z", "2023-06-27T20:00:00Z", "2023-06-27T21:00:00Z", "2023-06-27T22:00:00Z", "2023-06-27T23:00:00Z", "2023-06-28T00:00:00Z", "2023-06-28T01:00:00Z", "2023-06-28T02:00:00Z", "2023-06-28T03:00:00Z", "2023-06-28T04:00:00Z", "2023-06-28T05:00:00Z", "2023-06-28T06:00:00Z", "2023-06-28T07:00:00Z", "2023-06-28T08:00:00Z", "2023-06-28T09:00:00Z", "2023-06-28T10:00:00Z", "2023-06-28T11:00:00Z", "2023-06-28T12:00:00Z", "2023-06-28T13:00:00Z", "2023-06-28T14:00:00Z", "2023-06-28T15:00:00Z", "2023-06-28T16:00:00Z", "2023-06-28T17:00:00Z", "2023-06-28T18:00:00Z", "2023-06-28T19:00:00Z", "2023-06-28T20:00:00Z", "2023-06-28T21:00:00Z", "2023-06-28T22:00:00Z", "2023-06-28T23:00:00Z", "2023-06-29T00:00:00Z", "2023-06-29T01:00:00Z", "2023-06-29T02:00:00Z", "2023-06-29T03:00:00Z", "2023-06-29T04:00:00Z", "2023-06-29T05:00:00Z", "2023-06-29T06:00:00Z", "2023-06-29T07:00:00Z", "2023-06-29T08:00:00Z", "2023-06-29T09:00:00Z", "2023-06-29T10:00:00Z", "2023-06-29T11:00:00Z", "2023-06-29T12:00:00Z", "2023-06-29T13:00:00Z", "2023-06-29T14:00:00Z", "2023-06-29T15:00:00Z", "2023-06-29T16:00:00Z", "2023-06-29T17:00:00Z", "2023-06-29T18:00:00Z", "2023-06-29T19:00:00Z", "2023-06-29T20:00:00Z", "2023-06-29T21:00:00Z", "2023-06-29T22:00:00Z", "2023-06-29T23:00:00Z", "2023-06-30T00:00:00Z", "2023-06-30T01:00:00Z", "2023-06-30T02:00:00Z", "2023-06-30T03:00:00Z", "2023-06-30T04:00:00Z", "2023-06-30T05:00:00Z", "2023-06-30T06:00:00Z", "2023-06-30T07:00:00Z", "2023-06-30T08:00:00Z", "2023-06-30T09:00:00Z", "2023-06-30T10:00:00Z", "2023-06-30T11:00:00Z", "2023-06-30T12:00:00Z", "2023-06-30T13:00:00Z", "2023-06-30T14:00:00Z", "2023-06-30T15:00:00Z", "2023-06-30T16:00:00Z", "2023-06-30T17:00:00Z", "2023-06-30T18:00:00Z", "2023-06-30T19:00:00Z", "2023-06-30T20:00:00Z", "2023-06-30T21:00:00Z", "2023-06-30T22:00:00Z", "2023-06-30T23:00:00Z", "2023-07-01T00:00:00Z", "2023-07-01T01:00:00Z", "2023-07-01T02:00:00Z", "2023-07-01T03:00:00Z", "2023-07-01T04:00:00Z", "2023-07-01T05:00:00Z", "2023-07-01T06:00:00Z", "2023-07-01T07:00:00Z", "2023-07-01T08:00:00Z", "2023-07-01T09:00:00Z", "2023-07-01T10:00:00Z", "2023-07-01T11:00:00Z", "2023-07-01T12:00:00Z", "2023-07-01T13:00:00Z", "2023-07-01T14:00:00Z", "2023-07-01T15:00:00Z", "2023-07-01T16:00:00Z", "2023-07-01T17:00:00Z", "2023-07-01T18:00:00Z", "2023-07-01T19:00:00Z", "2023-07-01T20:00:00Z", "2023-07-01T21:00:00Z", "2023-07-01T22:00:00Z", "2023-07-01T23:00:00Z", "2023-07-02T00:00:00Z", "2023-07-02T01:00:00Z", "2023-07-02T02:00:00Z", "2023-07-02T03:00:00Z", "2023-07-02T04:00:00Z", "2023-07-02T05:00:00Z", "2023-07-02T06:00:00Z", "2023-07-02T07:00:00Z", "2023-07-02T08:00:00Z", "2023-07-02T09:00:00Z", "2023-07-02T10:00:00Z", "2023-07-02T11:00:00Z", "2023-07-02T12:00:00Z", "2023-07-02T13:00:00Z", "2023-07-02T14:00:00Z", "2023-07-02T15:00:00Z", "2023-07-02T16:00:00Z", "2023-07-02T17:00:00Z", "2023-07-02T18:00:00Z", "2023-07-02T19:00:00Z", "2023-07-02T20:00:00Z", "2023-07-02T21:00:00Z"],
    }),
  };

  /**
  * up to 31 datapoints(1 day values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const MONTH: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ActualEnergy": 1033427,
        "_sum/ActiveChargeEnergy": 328451,
        "_sum/ActiveDischargeEnergy": 21649,
        "_sum/EssDcChargeEnergy": 30996,
        "_sum/EssDcDischargeEnergy": 13720,
        "_sum/ProductionActiveEnergy": 1547213,
        "charger0/ActualEnergy": 32098,
        "ess0/ActiveChargeEnergy": 16092,
        "ess0/ActiveDischargeEnergy": 68553,
        "ess1/ActiveChargeEnergy": 16092,
        "ess1/ActiveDischargeEnergy": 68553,
        "ess1/DcChargeEnergy": 16092,
        "ess1/DcDischargeEnergy": 68553,
        "ess2/ActiveChargeEnergy": 16092,
        "ess2/ActiveDischargeEnergy": 68553,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ActualEnergy": [1784.3478512581187, 955.1978135997077, 1604.9176251387696, 1821.5474663613152, 1204.011627189301, 1037.408900359932, 1287.891020875591, 1183.057735422114, 1027.8784377276404, 1412.783196754379, 737.2379614126091, 730.6143394985477, 1727.4568452231197, 2045.4827463867603, 1289.9867373938441, 1866.5731598778827, 896.448259060122, 1271.0485678635469, 1489.7323302960576, 1367.9696489029907, 2375.6092366846033, 2368.729102836224, 2686.60326649514, 1597.0390753045413, 972.6650191463931, 1774.233690168573, 2953.838257099637, 917.3087792235759, 1172.9800154902882, null, null],
          "_sum/ActiveChargeEnergy": [598.058461158158, 0, 607.3861225965935, 891.3491768679577, 269.6236843407865, 0, 306.41009901340226, 220.51407209843148, 50.15525733301707, 356.42246970726825, 0, 0, 880.0942036863182, 977.4033026217928, 210.23831546417276, 787.0712558876392, 0, 165.50743075023163, 513.2605942604259, 149.06825174512016, 883.6100586172083, 1203.117101530366, 1467.2314708234808, 553.6230686820822, 0, 714.8486366912176, 1836.7765179313803, 0, 300.374916784946, null, null],
          "_sum/ActiveDischargeEnergy": [15.53700680772126, 13.97856617670663, 16.22420643945345, 15.425155003970989, 16.41557086346929, 15.280936198647838, 15.028196655704793, 15.146427851947054, 15.567356482244767, 17.404197969735606, 17.635152684968116, 14.140394156739468, 16.107488806188936, 16.75001277671301, 15.512752420609466, 14.951999780788457, 13.733457057782298, 16.868671206682027, 14.770978996449593, 16.47697124898351, 16.772182319685665, 16.288562161254703, 15.417362341926745, 15.892028990939403, 13.811584043067414, 14.81782772305683, 14.165639305307824, 16.223347257543285, 14.495672387672808, null, null],
          "_sum/EssDcChargeEnergy": [1784.3478512581187, 955.1978135997077, 1604.9176251387696, 1821.5474663613152, 1204.011627189301, 1037.408900359932, 1287.891020875591, 1183.057735422114, 1027.8784377276404, 1412.783196754379, 737.2379614126091, 730.6143394985477, 1727.4568452231197, 2045.4827463867603, 1289.9867373938441, 1866.5731598778827, 896.448259060122, 1271.0485678635469, 1489.7323302960576, 1367.9696489029907, 2375.6092366846033, 2368.729102836224, 2686.60326649514, 1597.0390753045413, 972.6650191463931, 1774.233690168573, 2953.838257099637, 917.3087792235759, 1172.9800154902882, null, null],
          "_sum/EssDcDischargeEnergy": [1784.3478512581187, 955.1978135997077, 1604.9176251387696, 1821.5474663613152, 1204.011627189301, 1037.408900359932, 1287.891020875591, 1183.057735422114, 1027.8784377276404, 1412.783196754379, 737.2379614126091, 730.6143394985477, 1727.4568452231197, 2045.4827463867603, 1289.9867373938441, 1866.5731598778827, 896.448259060122, 1271.0485678635469, 1489.7323302960576, 1367.9696489029907, 2375.6092366846033, 2368.729102836224, 2686.60326649514, 1597.0390753045413, 972.6650191463931, 1774.233690168573, 2953.838257099637, 917.3087792235759, 1172.9800154902882, null, null],
          "_sum/ProductionActiveEnergy": [17036, 48347, 67364, 64160, 63717, 65720, 65949, 64060, 62792, 66792, 56974, 55889, 65503, 59092, 54974, 63091, 56808, 52431, 39579, 37225, 47909, 42285, 56340, 44752, 60867, 46001, 37628, 21260, 18416, 44252],
          "charger0/ActualEnergy": [2553, 2197, 858, 2446, 1321, 2165, 1588, 2108, 1993, 1271, 182, 419, 387, 932, 1407, 1462, 1874, 1412, 271, 1264, 1144, 997, 1076, 715, 52, 0, 0, 0, 4, 0],
          "ess0/ActiveChargeEnergy": [418, 415, 547, 478, 538, 545, 483, 562, 536, 619, 533, 524, 553, 525, 489, 523, 527, 487, 523, 522, 582, 546, 568, 564, 520, 511, 558, 469, 476, 452, 470],
          "ess0/ActiveDischargeEnergy": [4540, 5400, 2924, 1032, 62, 112, 4694, 154, 4568, 557, 1280, 1059, 953, 1825, 5037, 451, 4239, 485, 347, 4883, 695, 1810, 1241, 255, 2489, 2752, 936, 2367, 3588, 6111, 1707],
          "ess1/ActiveChargeEnergy": [418, 415, 547, 478, 538, 545, 483, 562, 536, 619, 533, 524, 553, 525, 489, 523, 527, 487, 523, 522, 582, 546, 568, 564, 520, 511, 558, 469, 476, 452, 470],
          "ess1/ActiveDischargeEnergy": [4540, 5400, 2924, 1032, 62, 112, 4694, 154, 4568, 557, 1280, 1059, 953, 1825, 5037, 451, 4239, 485, 347, 4883, 695, 1810, 1241, 255, 2489, 2752, 936, 2367, 3588, 6111, 1707],
          "ess1/DcChargeEnergy": [418, 415, 547, 478, 538, 545, 483, 562, 536, 619, 533, 524, 553, 525, 489, 523, 527, 487, 523, 522, 582, 546, 568, 564, 520, 511, 558, 469, 476, 452, 470],
          "ess1/DcDischargeEnergy": [4540, 5400, 2924, 1032, 62, 112, 4694, 154, 4568, 557, 1280, 1059, 953, 1825, 5037, 451, 4239, 485, 347, 4883, 695, 1810, 1241, 255, 2489, 2752, 936, 2367, 3588, 6111, 1707],
          "ess2/ActiveChargeEnergy": [418, 415, 547, 478, 538, 545, 483, 562, 536, 619, 533, 524, 553, 525, 489, 523, 527, 487, 523, 522, 582, 546, 568, 564, 520, 511, 558, 469, 476, 452, 470],
          "ess2/ActiveDischargeEnergy": [4540, 5400, 2924, 1032, 62, 112, 4694, 154, 4568, 557, 1280, 1059, 953, 1825, 5037, 451, 4239, 485, 347, 4883, 695, 1810, 1241, 255, 2489, 2752, 936, 2367, 3588, 6111, 1707],

        },
        timestamps: ["2023-05-31T22:00:00Z", "2023-06-01T22:00:00Z", "2023-06-02T22:00:00Z", "2023-06-03T22:00:00Z", "2023-06-04T22:00:00Z", "2023-06-05T22:00:00Z", "2023-06-06T22:00:00Z", "2023-06-07T22:00:00Z", "2023-06-08T22:00:00Z", "2023-06-09T22:00:00Z", "2023-06-10T22:00:00Z", "2023-06-11T22:00:00Z", "2023-06-12T22:00:00Z", "2023-06-13T22:00:00Z", "2023-06-14T22:00:00Z", "2023-06-15T22:00:00Z", "2023-06-16T22:00:00Z", "2023-06-17T22:00:00Z", "2023-06-18T22:00:00Z", "2023-06-19T22:00:00Z", "2023-06-20T22:00:00Z", "2023-06-21T22:00:00Z", "2023-06-22T22:00:00Z", "2023-06-23T22:00:00Z", "2023-06-24T22:00:00Z", "2023-06-25T22:00:00Z", "2023-06-26T22:00:00Z", "2023-06-27T22:00:00Z", "2023-06-28T22:00:00Z", "2023-06-29T22:00:00Z"],
      }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/EssSoc": [48.09059233449477, 67.87847222222223, 70.86153846153846, 70.07986111111111, 70.07581227436823, 69.78397212543554, 74.21527777777777, 73.95833333333333, 71.9198606271777, 63.97569444444444, 66.65972222222223, 67.01760563380282, 63.30902777777778, 68.12152777777777, 67.68989547038328, 60.71875, 60.927083333333336, 70.82291666666667, 65.125, 61.22826086956522, 68.71527777777777, 60.78472222222222, 61.28125, 68.38541666666667, 71.98958333333333, 70.86805555555556, 69.70486111111111, 65.93728222996516, 54.99293286219081, 73.9090909090909],
        "ctrlEmergencyCapacityReserve0/ActualReserveSoc": [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
      },
      timestamps: ["2023-11-31T22:00:00Z", "2023-12-01T22:00:00Z", "2023-12-02T22:00:00Z", "2023-12-03T22:00:00Z", "2023-12-04T22:00:00Z", "2023-12-05T22:00:00Z", "2023-12-06T22:00:00Z", "2023-12-07T22:00:00Z", "2023-12-08T22:00:00Z", "2023-12-09T22:00:00Z", "2023-12-10T22:00:00Z", "2023-12-11T22:00:00Z", "2023-12-12T22:00:00Z", "2023-12-13T22:00:00Z", "2023-12-14T22:00:00Z", "2023-12-15T22:00:00Z", "2023-12-16T22:00:00Z", "2023-12-17T22:00:00Z", "2023-12-18T22:00:00Z", "2023-12-19T22:00:00Z", "2023-12-20T22:00:00Z", "2023-12-21T22:00:00Z", "2023-12-22T22:00:00Z", "2023-12-23T22:00:00Z", "2023-12-24T22:00:00Z", "2023-12-25T22:00:00Z", "2023-12-26T22:00:00Z", "2023-12-27T22:00:00Z", "2023-12-28T22:00:00Z", "2023-12-29T22:00:00Z"],
    }),
  };

  /**
  * up to 12 datapoints(1 month values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const YEAR: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ActualEnergy": 14863655,
        "_sum/ActiveChargeEnergy": 4954551,
        "_sum/ActiveDischargeEnergy": 4954551,
        "_sum/EssDcChargeEnergy": 1205373,
        "_sum/EssDcDischargeEnergy": 1063240,
        "_sum/ProductionActiveEnergy": 1908650,
        "charger0/ActualEnergy": 50263,
        "ess0/ActiveChargeEnergy": 15193,
        "ess0/ActiveDischargeEnergy": 12867,
        "ess1/ActiveChargeEnergy": 630352,
        "ess1/ActiveDischargeEnergy": 563231,
        "ess1/DcChargeEnergy": 15193,
        "ess1/DcDischargeEnergy": 12867,
        "ess2/ActiveChargeEnergy": 751000,
        "ess2/ActiveDischargeEnergy": 648000,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ActualEnergy": [1682941, 1834729, 1805222, 1934144, 1757577, 1511352, 2306988, 2029933, 0, 0, 0, 0],
          "_sum/ActiveChargeEnergy": [560980.3333333334, 611576.3333333334, 601740.6666666666, 644714.6666666666, 585859, 503784, 768996, 676644.3333333334, 0, 0, 0, 0],
          "_sum/ActiveDischargeEnergy": [560980.3333333334, 611576.3333333334, 601740.6666666666, 644714.6666666666, 585859, 503784, 768996, 676644.3333333334, 0, 0, 0, 0],
          "_sum/EssDcChargeEnergy": [119370, 181427, 336099, 29022, 468619, 70836, null, null, null, null, null, null],
          "_sum/EssDcDischargeEnergy": [101231, 145815, 293974, 30014, 441409, 50797, null, null, null, null, null, null],
          "evcs0/EssDcDischargeEnergy": [69104, 131703, 25773, 51085, 169943, 332522, 748189, 540740, 0, 0, 0, 0],
          "meter0/ProductionActiveEnergy": [338070, 312380, 298930, 317700, 200210, 151160, 145880, 144280, 0, 0, 0, 0],
          "charger0/ActualEnergy": [null, null, 18239, 267922, 425688, 514475, 480714, 354661, 186380, 88861, null, 21770],
          "ess0/ActiveChargeEnergy": [294606, 1673109, 3337772, 3074303, 2495947, 3944328, 372595, 0, 0, 0, 0, 0],
          "ess0/ActiveDischargeEnergy": [208491, 1339036, 2911126, 2555138, 2123751, 3394430, 335402, 0, 0, 0, 0, 0],
          "ess1/ActiveChargeEnergy": [61371, 99427, 179099, null, 249619, 40836, null, null, null, null, null, null],
          "ess1/ActiveDischargeEnergy": [56232, 79816, 156976, null, 241410, 28797, null, null, null, null, null, null],
          "ess2/ActiveChargeEnergy": [58000, 82000, 157000, 205000, 219000, 30000, null, null, null, null, null, null],
          "ess2/ActiveDischargeEnergy": [45000, 66000, 137000, 178000, 200000, 22000, null, null, null, null, null, null],
          "ess1/DcChargeEnergy": [294606, 1673109, 3337772, 3074303, 2495947, 3944328, 372595, 0, 0, 0, 0, 0],
          "ess1/DcDischargeEnergy": [208491, 1339036, 2911126, 2555138, 2123751, 3394430, 335402, 0, 0, 0, 0, 0],
        },
        timestamps: ["2022-12-31T23:00:00Z", "2023-01-31T23:00:00Z", "2023-02-28T23:00:00Z", "2023-03-31T22:00:00Z", "2023-04-30T22:00:00Z", "2023-05-31T22:00:00Z", "2023-06-30T22:00:00Z", "2023-07-31T22:00:00Z", "2023-08-31T22:00:00Z", "2023-09-30T22:00:00Z", "2023-10-31T23:00:00Z", "2023-11-30T23:00:00Z"],
      }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/EssSoc": [1512.72, 1339.56, 1936.55, 1842.80, 1933.25, 1999.03, 1946.60, 1664.45, 1596.29, 973.61, 482.09, 1999.03],
        "ctrlEmergencyCapacityReserve0/ActualReserveSoc": [10, 10, 10, 10, 10, 10, 10, 10, 10, 10],
      },
      timestamps: ["2023-01-31T23:00:00Z", "2023-02-28T23:00:00Z", "2023-03-31T22:00:00Z", "2023-04-30T22:00:00Z", "2023-05-31T22:00:00Z", "2023-06-30T22:00:00Z", "2023-07-31T22:00:00Z", "2023-08-31T22:00:00Z", "2023-09-30T22:00:00Z", "2023-10-31T23:00:00Z", "2023-11-30T23:00:00Z", "2023-12-31T23:00:00Z"],
    }),

  };
}
