// @ts-strict-ignore
import { Component, Input } from "@angular/core";
import { JsonrpcResponseError } from "src/app/shared/jsonrpc/base";

@Component({
    selector: "oe-history-data-error",
    template: `
    @if (type !== null) {
      <ion-item lines="full" color="warning">
        <ion-icon size="large" slot="start" name="warning-outline"></ion-icon>
        <ion-label class="ion-text-wrap" style="text-align: center">
          @switch (type) {
            @case ('TOO_LONG') {
              <span [innerHTML]="'EDGE.INDEX.ENERGYMONITOR.ERROR_TOO_LONG' | translate"></span>
            }
            @case ('TEMPORARY') {
              <span translate>EDGE.INDEX.ENERGYMONITOR.ERROR_TEMPORARY</span>
            }
          }
        </ion-label>
      </ion-item>
    }`,
    standalone: false,
})
export class HistoryDataErrorComponent {

    protected type: ErrorType;

    @Input()
    set response(response: JsonrpcResponseError | null) {
        this.type = toType(response);
    }
}

type ErrorType = "TEMPORARY" | "TOO_LONG" | null;

function toType(response: JsonrpcResponseError | null): ErrorType {
    const message = response?.error?.message;
    if (message === undefined) {
        return null;
    }
    switch (message) {
        case "Die Anzeige und der Export von Daten über einen längeren Zeitraum ist derzeit leider nicht möglich":
            return "TOO_LONG";
        default:
            return "TEMPORARY";
    }
}
