import { DummyConfig } from "src/app/shared/components/edge/edgeconfig.spec";
import { History } from "src/app/shared/components/shared/testing/channels.spec";
import { OeTester } from "src/app/shared/components/shared/testing/common";
import { TestContext, TestingUtils } from "src/app/shared/components/shared/testing/utils.spec";
import { ChartAxis } from "src/app/shared/utils/utils";
import { DATA, LABELS } from "../../../energy/chart/chart.constants.spec";
import { expectEssChartViewToEqual } from "../../shared/chart.constants.spec";

describe("History EssChart", () => {
  const defaultEMS = DummyConfig.from(
    DummyConfig.Component.ESS_GENERIC_MANAGEDSYMMETRIC("ess1"),
  );

  let TEST_CONTEXT: TestContext;
  beforeEach(async () =>
    TEST_CONTEXT = await TestingUtils.sharedSetup(),
  );

  it("#getChartData()", () => {
    {

      // Line-Chart, no phases, no phasecolors
      expectEssChartViewToEqual(TEST_CONTEXT, "line", History.DAY,
        {
          datasets: {
            data: [
              DATA("Beladung: 129,9 kWh", [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.438, 0, 0, 2.021, 4.651, 8.742, 15.726, 17.88, 7.107, 0.722, 0.784, 0.948, 5.133, 42.889, 51.21, 62.5, 21.66, 39.364, 45.349, 44.23, 22.22, 9.591, 0.807, 15.097, 67.13, 66.233, 72.154, 69.315, 69.929, 76.115, 36.219, 4.486, 42.639, 39.104, 18.703, 33.955, 2.112, 0, 7.703, 0, 0, 0, 56.976, 52.859, 45.461, 57.056, 54.724, 58.968, 63.517, 65.445, 44.248, 21.334, 7.053, 3.971, 1.906, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
              DATA("Entladung: 82,4 kWh", [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.632, 2.18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.403, 2.424, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1.36, 22.224, 22.913, 21.936, 23.195, 21.004, 22.355, 23.392, 21.68, 21.382, 21.621, 23.047, 21.772, 22.248, 21.58, 21.329, 21.263, 22.3, 20.878, 21.109, 22.926, 21.874, 21.585, 21.344, 22.371, 21.639, 21.425, 21.239, 20.585, 17.524, 0.812, 0.741, 0.817, 0.758, 0.709, 0.764, 0.779, 0.776, 0.76, 0.801, 0.774, 0.807, 0.823, 0.916, 0.895, 0.836, 0.843, 0.932, 0.979, 1.041, 0.972, 18.636, 22.675, 22.373, 22.476, 22.604, 22.799, 21.397, 23.524, 22.456, 22.706, 23.878, 23.514, 15.044, 12.421, 12.782, 11.917, 12.258, 0.492, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
              DATA("Ladezustand", [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 12, 12, 12, 11, 11, 11, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10])],
            labels: LABELS(History.DAY.dataChannelWithValues?.result?.timestamps ?? []),
            options: OeTester.ChartOptions.MULTI_LINE_OPTIONS("hour", "line", {
              [ChartAxis.RIGHT]: { scale: { beginAtZero: true, title: { text: "%" }, grid: { display: true }, type: "linear" } },
            }),
          },
        }, Object.values(defaultEMS.components)[0], defaultEMS);
    }

    {
      // Line-Chart, no phases, no phasecolors
      expectEssChartViewToEqual(TEST_CONTEXT, "line", History.WEEK,
        {
          datasets: {
            data: [
              DATA("Beladung: 2,2 kWh", [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0405, 0.042333333333333334, 0.04083333333333333, 0.0395, 0.041, 0.04033333333333334, 0.03975, 0.042083333333333334, 0.04066666666666666, 0.04066666666666666, 0.04033333333333334, 0.04083333333333333, 0.03958333333333334, 0.034166666666666665, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.018416666666666668, 0.01958333333333333, 0.02033333333333333, 0.02025, 0.01958333333333333, 0.04081818181818182, 0.030333333333333334, 0, 0, 0, 0, 0, 0, 0.029666666666666668, 0.033, 0.03375, 0.034, 0.0315, 0.0325, 0.03283333333333333, 0.03241666666666666, 0.03158333333333333, 0.034333333333333334, 0.03175, 0.0315, 0.03175, 0.03283333333333333, 0.03058333333333333, 0.03108333333333333, 0.02791666666666667, 0.03158333333333333, 0.035, 0.029583333333333333, 0.03741666666666667, 0.03825, 0.035333333333333335, 0.035833333333333335, 0.032916666666666664, 0.03375, 0.03475, 0.033416666666666664, 0.03025, 0.029583333333333333, 0.03, 0.03241666666666666]),
              DATA("Entladung: 42,7 kWh", [0.23525, 0.11283333333333333, 0.10508333333333333, 0.12691666666666668, 0.08083333333333333, 0.07033333333333333, 0.16991666666666666, 0.10241666666666667, 0.06641666666666667, 0.3428333333333333, 0.22175, 0.35, 1.3639166666666667, 2.37125, 1.981, 0.6773333333333333, 0.5274166666666666, 0.2926666666666667, 0.2525, 0.3935, 0.36291666666666667, 0.2683333333333333, 0.34975, 0.3673333333333333, 0.13291666666666666, 0.13908333333333334, 0.08525, 0.07075, 0.12391666666666667, 0.10725, 0.17208333333333334, 0.16991666666666666, 0.2586666666666667, 0.2851666666666667, 0.10708333333333332, 0.18283333333333335, 0.15366666666666665, 1.40425, 0.7365833333333334, 0.26366666666666666, 0.18658333333333335, 0.476, 0.05375, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.3851666666666667, 0.24166666666666667, 0.3620833333333333, 2.6643333333333334, 1.9045, 2.025090909090909, 0.8655, 0.21966666666666665, 0.5754166666666666, 0.4221666666666667, 0.78625, 0.2890833333333333, 0.257, 0.232, 0.3478333333333333, 0.1605, 0.059083333333333335, 0.07941666666666668, 0.11625, 0.059416666666666666, 0.05408333333333334, 0.14525, 0.13791666666666666, 0.259, 0.3565833333333333, 0.18775, 0.15541666666666665, 0.2405, 1.5604166666666668, 1.042, 0.215, 0.12608333333333333, 0.30141666666666667, 0.36525, 0.25175, 0.5385833333333334, 0.24633333333333335, 0.3098333333333333, 0.3106666666666667, 0.11208333333333333, 0.11708333333333333, 0.11183333333333333, 0.08691666666666667, 0.07325, 0.11391666666666667, 0.3666666666666667, 0.09116666666666667, 0.13433333333333333, 0.28, 0.21191666666666667, 0.17333333333333334, 0.3933333333333333, 0.178, 0.6220833333333333, 0.178, 0.3525833333333333, 0.22366666666666665, 0.194, 0.68125, 0.24258333333333335, 0.22466666666666665, 0.3853333333333333, 0.17291666666666666, 0.10641666666666667, 0.14833333333333334, 0.036833333333333336, 0, 0, 0, 0, 0, 0, 0, 0.077, 0.22775, 0.2905, 0.6044166666666666, 0.21158333333333335, 0.004083333333333333, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]),
              DATA("Ladezustand", [10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11.666666666666666, 13.75, 10.75, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.583333333333334, 10.25, 11.416666666666666, 10.583333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.25, 11.166666666666666, 10.083333333333334, 11.333333333333334, 10.916666666666666, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.166666666666666, 12.416666666666666, 16.083333333333332, 17.166666666666668, 12.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11.916666666666666, 19.916666666666668, 31.75, 39.333333333333336, 39.916666666666664, 32, 21.916666666666668, 13.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10.5, 10, 10, 10.833333333333334, 10.083333333333334, 10, 10, 10, 10, 10, 10, 10, 10])],
            labels: LABELS(History.WEEK.dataChannelWithValues?.result?.timestamps ?? []),
            options: OeTester.ChartOptions.MULTI_LINE_OPTIONS("day", "line", {
              [ChartAxis.RIGHT]: { scale: { beginAtZero: true, title: { text: "%" }, grid: { display: true }, type: "linear" } },
            }),
          },
        }, Object.values(defaultEMS.components)[0], defaultEMS);
    }

    {
      // Bar-Chart, no phases, no phasecolors
      expectEssChartViewToEqual(TEST_CONTEXT, "bar", History.MONTH,
        {
          datasets: {
            data: [
              DATA("Beladung: 16,1 kWh", [0.418, 0.415, 0.547, 0.478, 0.538, 0.545, 0.483, 0.562, 0.536, 0.619, 0.533, 0.524, 0.553, 0.525, 0.489, 0.523, 0.527, 0.487, 0.523, 0.522, 0.582, 0.546, 0.568, 0.564, 0.52, 0.511, 0.558, 0.469, 0.476, 0.452, 0.47]),
              DATA("Entladung: 68,6 kWh", [4.54, 5.4, 2.924, 1.032, 0.062, 0.112, 4.694, 0.154, 4.568, 0.557, 1.28, 1.059, 0.953, 1.825, 5.037, 0.451, 4.239, 0.485, 0.347, 4.883, 0.695, 1.81, 1.241, 0.255, 2.489, 2.752, 0.936, 2.367, 3.588, 6.111, 1.707])],
            labels: LABELS(History.MONTH.energyPerPeriodChannelWithValues?.result?.timestamps ?? []),
            options: OeTester.ChartOptions.BAR_CHART_OPTIONS("day", "bar", {}),
          },
        }, Object.values(defaultEMS.components)[0], defaultEMS);
    }

    {
      // Bar-Chart, no phases, no phasecolors
      expectEssChartViewToEqual(TEST_CONTEXT, "bar", History.YEAR,
        {
          datasets: {
            data: [
              DATA("Beladung: 15,2 kWh", [294.606, 1673.109, 3337.772, 3074.303, 2495.947, 3944.328, 372.595, 0, 0, 0, 0, 0]),
              DATA("Entladung: 12,9 kWh", [208.491, 1339.036, 2911.126, 2555.138, 2123.751, 3394.43, 335.402, 0, 0, 0, 0, 0])],
            labels: LABELS(History.YEAR.energyPerPeriodChannelWithValues?.result?.timestamps ?? []),
            options: OeTester.ChartOptions.BAR_CHART_OPTIONS("month", "bar", {}),
          },
        }, Object.values(defaultEMS.components)[0], defaultEMS);
    }

    {
      // Non-hybrid-ess
      const ems = DummyConfig.from(
        DummyConfig.Component.EDGE_2_EDGE_WEBSOCKET_ESS("ess1"),
      );
      expectEssChartViewToEqual(TEST_CONTEXT, "bar", History.YEAR,
        {
          datasets: {
            data: [
              DATA("Beladung: 630,4 kWh", [61.371, 99.427, 179.099, null, 249.619, 40.836, null, null, null, null, null, null]),
              DATA("Entladung: 563,2 kWh", [56.232, 79.816, 156.976, null, 241.41, 28.797, null, null, null, null, null, null])],
            labels: LABELS(History.YEAR.energyPerPeriodChannelWithValues?.result?.timestamps ?? []),
            options: OeTester.ChartOptions.BAR_CHART_OPTIONS("month", "bar", {}),
          },
        }, Object.values(ems.components)[0], ems);
    }
  });
});
