import { TimeUnit } from "chart.js";
import { ChartConstants } from "src/app/shared/components/chart/chart.constants";
import { OeTester } from "src/app/shared/components/shared/testing/common";
import { OeChartTester } from "src/app/shared/components/shared/testing/tester";
import { QueryHistoricTimeseriesDataResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesDataResponse";
import { QueryHistoricTimeseriesEnergyPerPeriodResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyPerPeriodResponse";
import { QueryHistoricTimeseriesEnergyResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyResponse";

export namespace History {

  export const LINE_CHART_OPTIONS = (period: string, chartType: "line" | "bar", options: { [key: string]: { scale: { min: number, max: number; } | null, ticks?: { stepSize: number }; }; }): OeChartTester.Dataset.Option => ({
    type: "option",
    options: {
      "interaction": {
        "mode": "index",  // Detect x-axis alignment
        "intersect": false,  // Allow hovering over line, not just points
      },
      "responsive": true,
      "maintainAspectRatio": false,
      "elements": {
        "point": { "radius": 0, "hitRadius": 0, "hoverRadius": 0 },
        "line": { "stepped": false, "fill": true },
      },
      "datasets": { "bar": {}, "line": {} },
      "plugins": {
        "colors": { "enabled": false },
        "legend": {
          "display": true, "position": "bottom", "labels": {
            "color": "",
            "usePointStyle": true,
            "textAlign": "center",
          },
        },
        "tooltip": {
          "intersect": false, "mode": "index", "callbacks": {}, "enabled": true,
          "usePointStyle": true,
          "caretSize": 0,
        },
        "annotation": {
          annotations: {},
        },
        "datalabels": {
          display: false,
        },
      },
      "scales": {
        "x": {
          "stacked": true,
          "offset": false,
          "type": "time",
          "ticks": { "source": "auto", "maxTicksLimit": 31 },
          "bounds": "ticks",
          "adapters": { "date": { "locale": { "code": "de", "formatLong": {}, "localize": {}, "match": {}, "options": { "weekStartsOn": 1, "firstWeekContainsDate": 4 } } } },
          "time": { "unit": period as TimeUnit, "displayFormats": { "datetime": "yyyy-MM-dd HH:mm:ss", "millisecond": "SSS [ms]", "second": "HH:mm:ss a", "minute": "HH:mm", "hour": "HH:00", "day": "dd", "week": "ll", "month": "MM", "quarter": "[Q]Q - YYYY", "year": "yyyy" } },
        },
        "left": {
          ...options["left"]?.scale,
          ...(chartType === "line"
            ? { stacked: false }
            : {}),
          "beginAtZero": true,
          "title": { "text": "kW", "display": false, "padding": 5, "font": { "size": 11 } },
          "position": "left", "grid": { "display": true },
          "ticks": { ...options["left"]?.ticks, "color": "", "padding": 5, "maxTicksLimit": ChartConstants.NUMBER_OF_Y_AXIS_TICKS },
        },
        "right": {
          ...options["right"]?.scale, ...(chartType === "line" ? { stacked: false } : {}),
          "beginAtZero": true,
          "type": "linear",
          "title": { "text": "%", "display": false, "font": { "size": 11 }, "padding": 5 },
          "position": "right", "grid": { "display": false },
          "ticks": {
            ...options["right"]?.ticks,
            "color": "",
            "padding": 5,
            "maxTicksLimit": ChartConstants.NUMBER_OF_Y_AXIS_TICKS,
          },
        },
      },
    },
  });
  export const BAR_CHART_OPTIONS = (period: string, chartType: "line" | "bar", options: { [key: string]: { scale: { min?: number, max?: number; }, ticks: { stepSize?: number; }; }; }): OeChartTester.Dataset.Option => ({
    type: "option",
    options: {
      "interaction": {
        "mode": "index",  // Detect x-axis alignment
        "intersect": false,  // Allow hovering over line, not just points
      },
      "responsive": true,
      "maintainAspectRatio": false,
      "elements": {
        "point": { "radius": 0, "hitRadius": 0, "hoverRadius": 0 },
        "line": { "stepped": false, "fill": true },
      },
      "datasets": { "bar": { "barPercentage": 1 }, "line": {} },
      "plugins": {
        "colors": { "enabled": false },
        "legend": {
          "display": true, "position": "bottom", "labels": {
            "color": "", "usePointStyle": true,
            "textAlign": "center",
          },
        },
        "tooltip": {
          "intersect": false, "mode": "x", "callbacks": {}, "enabled": true, "usePointStyle": true, "caretSize": 0,
        },
        "annotation": {
          annotations: {},
        },
        "datalabels": {
          display: false,
        },
      },
      "scales": {
        "x": {
          "stacked": true,
          "offset": true,
          "type": "time",
          "ticks": { "source": "auto", "maxTicksLimit": 31 },
          "bounds": "ticks",
          "adapters": { "date": { "locale": { "code": "de", "formatLong": {}, "localize": {}, "match": {}, "options": { "weekStartsOn": 1, "firstWeekContainsDate": 4 } } } },
          "time": { "unit": period as TimeUnit, "displayFormats": { "datetime": "yyyy-MM-dd HH:mm:ss", "millisecond": "SSS [ms]", "second": "HH:mm:ss a", "minute": "HH:mm", "hour": "HH:00", "day": "dd", "week": "ll", "month": "MM", "quarter": "[Q]Q - YYYY", "year": "yyyy" } },
        },

        "left": {
          "beginAtZero": true,
          ...options["left"]?.scale, ...(chartType === "line" ? { stacked: false } : {}),
          "title": { "text": "kWh", "display": false, "padding": 5, "font": { "size": 11 } },
          "position": "left",
          "grid": { "display": true },
          "stacked": true,
          "ticks": {
            ...options["left"]?.ticks,
            "color": "",
            "padding": 5,
            "maxTicksLimit": ChartConstants.NUMBER_OF_Y_AXIS_TICKS,
          },
        },
      },
    },
  });

  /**
   * up to 288 datapoints (5 min aggregated values) from a
   *
   * {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const DAY: OeTester.Types.Channels = ({
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/GridBuyActiveEnergy": 938,
        "_sum/ConsumptionActiveEnergy": 24364,
        "_sum/EssDcChargeEnergy": 15766,
        "_sum/EssDcDischargeEnergy": 7209,
        "_sum/GridSellActiveEnergy": 15615,
        "_sum/ProductionActiveEnergy": 47597,
      },
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/ConsumptionActivePower": [null, null, null, 112, 262, 392, 240, 230, 229, 227, 317, 224, 133, 135, 133, 192, 209, 90, 95, 96, 164, 297, 184, 182, 183, 198, 333, 183, 93, 97, 98, 197, 266, 177, 144, 140, 173, 304, 305, 237, 232, 227, 283, 344, 135, 96, 95, null, null, null, null, 102, 129, 140, 301, 248, 267, 319, 310, 452, 451, 280, 234, 226, 249, 390, 242, 199, 179, 166, 280, 239, 192, 187, 187, 190, 303, 146, 62, 62, 64, 887, 1119, 1070, 1057, 596, 138, 233, 152, 209, 192, 202, 308, 254, 175, 122, 108, 137, 216, 947, 599, 203, 232, 328, 299, 520, 1213, 641, 1030, 442, 374, 1758, 249, 260, 346, 1879, 230, 484, 1260, 1317, 1488, 1451, 1892, 1466, 1332, 523, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "_sum/GridActivePower": [null, null, null, 31, 18, -6, 20, 16, 15, 14, 9, 20, 25, 25, 25, 21, 12, 9, 10, 11, 5, 3, -4, 15, 18, 23, -4, 0, 0, 2, 2, 3, 15, 8, 22, 27, 16, 3, 2, -5, 28, 27, 17, 1, 0, -1, -2, null, null, null, null, 11, 10, 4, 6, 7, 18, 8, 12, 9, 4, 13, 15, 12, 0, -1, -4, 2, -4, 5, 1, 30, 62, -5, -13, -6, -4, -17, -15, -17, -11, 15, 5, 4, 7, -29, -15, -13, -19, -14, -7, -16, 5, -18, -22, 0, -12, -11, -7, 21, -33, -7, -3, -4, -11, 3, -38, 4, 0, -19, 32, -16, -14, -18, 0, -1119, -3453, -3608, -3941, -4392, -3786, -4805, -4688, -3095, -2320, -2851, -3058, -4044, -5011, -2789, -6530, -5029, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        // 'GridSell': [6476, 6488, -1000, 0],
        "_sum/EssSoc": [null, null, null, 80, 80, 80, 79, 79, 79, 79, 79, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 77, 77, 77, 77, 77, 77, 77, 77, 76, 76, 76, 76, 76, 76, 76, 76, 75, 75, 75, 75, 75, 75, 75, null, null, null, null, 74, 74, 74, 74, 74, 74, 74, 74, 73, 73, 73, 73, 73, 73, 73, 73, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 73, 73, 73, 73, 73, 72, 72, 72, 73, 73, 73, 74, 75, 75, 75, 76, 77, 78, 78, 79, 79, 79, 80, 81, 83, 83, 84, 85, 86, 87, 89, 91, 92, 93, 95, 97, 98, 99, 100, 100, 100, 100, 100, 100, 100, 100, 100, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "_sum/EssActivePower": [null, null, null, 81, 244, 398, 221, 214, 214, 214, 308, 204, 108, 109, 108, 171, 197, 81, 84, 85, 160, 295, 188, 167, 165, 175, 337, 183, 93, 95, 95, 194, 251, 169, 122, 113, 156, 301, 303, 242, 204, 200, 266, 343, 135, 97, 96, null, null, null, null, 91, 119, 136, 295, 241, 249, 311, 298, 444, 447, 267, 218, 214, 249, 391, 246, 197, 183, 161, 280, 209, 130, 192, 200, 196, 307, 163, 77, 78, 76, 872, 1115, 1066, 1049, 625, 153, 246, 171, 223, 199, 218, 303, 272, 198, 122, 120, 148, 223, 926, 633, 210, 235, 332, 310, 517, 1251, 637, 1030, 462, 342, 1773, 263, 278, 346, 2998, 3683, 4092, 5200, 5709, 5273, 6256, 6579, 4561, 3652, 3374, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "_sum/ProductionActivePower": [null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, null, 2, 30, 27, 30, 39, 74, 93, 120, 120, 116, 106, 99, 101, 113, 131, 141, 131, 132, 105, 139, 165, 195, 255, 385, 458, 402, 428, 560, 615, 715, 700, 807, 796, 790, 813, 854, 832, 1052, 1427, 1481, 1765, 1291, 1625, 2138, 1686, 1367, 1562, 1271, 1176, 2542, 2910, 2616, 2193, 2039, 2376, 2919, 3862, 3793, 4309, 3932, 4126, 4406, 4757, 4728, 5231, 4400, 4169, 5232, 5770, 5300, 6327, 6636, 4573, 3678, 3422, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "_sum/ProductionDcActualPower": [null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, null, 2, 30, 27, 30, 39, 74, 93, 120, 120, 116, 106, 99, 101, 113, 131, 141, 131, 132, 105, 139, 165, 195, 255, 385, 458, 402, 428, 560, 615, 715, 700, 807, 796, 790, 813, 854, 832, 1052, 1427, 1481, 1765, 1291, 1625, 2138, 1686, 1367, 1562, 1271, 1176, 2542, 2910, 2616, 2193, 2039, 2376, 2919, 3862, 3793, 4309, 3932, 4126, 4406, 4757, 4728, 5231, 4400, 4169, 5232, 5770, 5300, 6327, 6636, 4573, 3678, 3422, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
      },
      timestamps: ["2023-07-02T22:00:00Z", "2023-07-02T22:05:00Z", "2023-07-02T22:10:00Z", "2023-07-02T22:15:00Z", "2023-07-02T22:20:00Z", "2023-07-02T22:25:00Z", "2023-07-02T22:30:00Z", "2023-07-02T22:35:00Z", "2023-07-02T22:40:00Z", "2023-07-02T22:45:00Z", "2023-07-02T22:50:00Z", "2023-07-02T22:55:00Z", "2023-07-02T23:00:00Z", "2023-07-02T23:05:00Z", "2023-07-02T23:10:00Z", "2023-07-02T23:15:00Z", "2023-07-02T23:20:00Z", "2023-07-02T23:25:00Z", "2023-07-02T23:30:00Z", "2023-07-02T23:35:00Z", "2023-07-02T23:40:00Z", "2023-07-02T23:45:00Z", "2023-07-02T23:50:00Z", "2023-07-02T23:55:00Z", "2023-07-03T00:00:00Z", "2023-07-03T00:05:00Z", "2023-07-03T00:10:00Z", "2023-07-03T00:15:00Z", "2023-07-03T00:20:00Z", "2023-07-03T00:25:00Z", "2023-07-03T00:30:00Z", "2023-07-03T00:35:00Z", "2023-07-03T00:40:00Z", "2023-07-03T00:45:00Z", "2023-07-03T00:50:00Z", "2023-07-03T00:55:00Z", "2023-07-03T01:00:00Z", "2023-07-03T01:05:00Z", "2023-07-03T01:10:00Z", "2023-07-03T01:15:00Z", "2023-07-03T01:20:00Z", "2023-07-03T01:25:00Z", "2023-07-03T01:30:00Z", "2023-07-03T01:35:00Z", "2023-07-03T01:40:00Z", "2023-07-03T01:45:00Z", "2023-07-03T01:50:00Z", "2023-07-03T01:55:00Z", "2023-07-03T02:00:00Z", "2023-07-03T02:05:00Z", "2023-07-03T02:10:00Z", "2023-07-03T02:15:00Z", "2023-07-03T02:20:00Z", "2023-07-03T02:25:00Z", "2023-07-03T02:30:00Z", "2023-07-03T02:35:00Z", "2023-07-03T02:40:00Z", "2023-07-03T02:45:00Z", "2023-07-03T02:50:00Z", "2023-07-03T02:55:00Z", "2023-07-03T03:00:00Z", "2023-07-03T03:05:00Z", "2023-07-03T03:10:00Z", "2023-07-03T03:15:00Z", "2023-07-03T03:20:00Z", "2023-07-03T03:25:00Z", "2023-07-03T03:30:00Z", "2023-07-03T03:35:00Z", "2023-07-03T03:40:00Z", "2023-07-03T03:45:00Z", "2023-07-03T03:50:00Z", "2023-07-03T03:55:00Z", "2023-07-03T04:00:00Z", "2023-07-03T04:05:00Z", "2023-07-03T04:10:00Z", "2023-07-03T04:15:00Z", "2023-07-03T04:20:00Z", "2023-07-03T04:25:00Z", "2023-07-03T04:30:00Z", "2023-07-03T04:35:00Z", "2023-07-03T04:40:00Z", "2023-07-03T04:45:00Z", "2023-07-03T04:50:00Z", "2023-07-03T04:55:00Z", "2023-07-03T05:00:00Z", "2023-07-03T05:05:00Z", "2023-07-03T05:10:00Z", "2023-07-03T05:15:00Z", "2023-07-03T05:20:00Z", "2023-07-03T05:25:00Z", "2023-07-03T05:30:00Z", "2023-07-03T05:35:00Z", "2023-07-03T05:40:00Z", "2023-07-03T05:45:00Z", "2023-07-03T05:50:00Z", "2023-07-03T05:55:00Z", "2023-07-03T06:00:00Z", "2023-07-03T06:05:00Z", "2023-07-03T06:10:00Z", "2023-07-03T06:15:00Z", "2023-07-03T06:20:00Z", "2023-07-03T06:25:00Z", "2023-07-03T06:30:00Z", "2023-07-03T06:35:00Z", "2023-07-03T06:40:00Z", "2023-07-03T06:45:00Z", "2023-07-03T06:50:00Z", "2023-07-03T06:55:00Z", "2023-07-03T07:00:00Z", "2023-07-03T07:05:00Z", "2023-07-03T07:10:00Z", "2023-07-03T07:15:00Z", "2023-07-03T07:20:00Z", "2023-07-03T07:25:00Z", "2023-07-03T07:30:00Z", "2023-07-03T07:35:00Z", "2023-07-03T07:40:00Z", "2023-07-03T07:45:00Z", "2023-07-03T07:50:00Z", "2023-07-03T07:55:00Z", "2023-07-03T08:00:00Z", "2023-07-03T08:05:00Z", "2023-07-03T08:10:00Z", "2023-07-03T08:15:00Z", "2023-07-03T08:20:00Z", "2023-07-03T08:25:00Z", "2023-07-03T08:30:00Z", "2023-07-03T08:35:00Z", "2023-07-03T08:40:00Z", "2023-07-03T08:45:00Z", "2023-07-03T08:50:00Z", "2023-07-03T08:55:00Z", "2023-07-03T09:00:00Z", "2023-07-03T09:05:00Z", "2023-07-03T09:10:00Z", "2023-07-03T09:15:00Z", "2023-07-03T09:20:00Z", "2023-07-03T09:25:00Z", "2023-07-03T09:30:00Z", "2023-07-03T09:35:00Z", "2023-07-03T09:40:00Z", "2023-07-03T09:45:00Z", "2023-07-03T09:50:00Z", "2023-07-03T09:55:00Z", "2023-07-03T10:00:00Z", "2023-07-03T10:05:00Z", "2023-07-03T10:10:00Z", "2023-07-03T10:15:00Z", "2023-07-03T10:20:00Z", "2023-07-03T10:25:00Z", "2023-07-03T10:30:00Z", "2023-07-03T10:35:00Z", "2023-07-03T10:40:00Z", "2023-07-03T10:45:00Z", "2023-07-03T10:50:00Z", "2023-07-03T10:55:00Z", "2023-07-03T11:00:00Z", "2023-07-03T11:05:00Z", "2023-07-03T11:10:00Z", "2023-07-03T11:15:00Z", "2023-07-03T11:20:00Z", "2023-07-03T11:25:00Z", "2023-07-03T11:30:00Z", "2023-07-03T11:35:00Z", "2023-07-03T11:40:00Z", "2023-07-03T11:45:00Z", "2023-07-03T11:50:00Z", "2023-07-03T11:55:00Z", "2023-07-03T12:00:00Z", "2023-07-03T12:05:00Z", "2023-07-03T12:10:00Z", "2023-07-03T12:15:00Z", "2023-07-03T12:20:00Z", "2023-07-03T12:25:00Z", "2023-07-03T12:30:00Z", "2023-07-03T12:35:00Z", "2023-07-03T12:40:00Z", "2023-07-03T12:45:00Z", "2023-07-03T12:50:00Z", "2023-07-03T12:55:00Z", "2023-07-03T13:00:00Z", "2023-07-03T13:05:00Z", "2023-07-03T13:10:00Z", "2023-07-03T13:15:00Z", "2023-07-03T13:20:00Z", "2023-07-03T13:25:00Z", "2023-07-03T13:30:00Z", "2023-07-03T13:35:00Z", "2023-07-03T13:40:00Z", "2023-07-03T13:45:00Z", "2023-07-03T13:50:00Z", "2023-07-03T13:55:00Z", "2023-07-03T14:00:00Z", "2023-07-03T14:05:00Z", "2023-07-03T14:10:00Z", "2023-07-03T14:15:00Z", "2023-07-03T14:20:00Z", "2023-07-03T14:25:00Z", "2023-07-03T14:30:00Z", "2023-07-03T14:35:00Z", "2023-07-03T14:40:00Z", "2023-07-03T14:45:00Z", "2023-07-03T14:50:00Z", "2023-07-03T14:55:00Z", "2023-07-03T15:00:00Z", "2023-07-03T15:05:00Z", "2023-07-03T15:10:00Z", "2023-07-03T15:15:00Z", "2023-07-03T15:20:00Z", "2023-07-03T15:25:00Z", "2023-07-03T15:30:00Z", "2023-07-03T15:35:00Z", "2023-07-03T15:40:00Z", "2023-07-03T15:45:00Z", "2023-07-03T15:50:00Z", "2023-07-03T15:55:00Z", "2023-07-03T16:00:00Z", "2023-07-03T16:05:00Z", "2023-07-03T16:10:00Z", "2023-07-03T16:15:00Z", "2023-07-03T16:20:00Z", "2023-07-03T16:25:00Z", "2023-07-03T16:30:00Z", "2023-07-03T16:35:00Z", "2023-07-03T16:40:00Z", "2023-07-03T16:45:00Z", "2023-07-03T16:50:00Z", "2023-07-03T16:55:00Z", "2023-07-03T17:00:00Z", "2023-07-03T17:05:00Z", "2023-07-03T17:10:00Z", "2023-07-03T17:15:00Z", "2023-07-03T17:20:00Z", "2023-07-03T17:25:00Z", "2023-07-03T17:30:00Z", "2023-07-03T17:35:00Z", "2023-07-03T17:40:00Z", "2023-07-03T17:45:00Z", "2023-07-03T17:50:00Z", "2023-07-03T17:55:00Z", "2023-07-03T18:00:00Z", "2023-07-03T18:05:00Z", "2023-07-03T18:10:00Z", "2023-07-03T18:15:00Z", "2023-07-03T18:20:00Z", "2023-07-03T18:25:00Z", "2023-07-03T18:30:00Z", "2023-07-03T18:35:00Z", "2023-07-03T18:40:00Z", "2023-07-03T18:45:00Z", "2023-07-03T18:50:00Z", "2023-07-03T18:55:00Z", "2023-07-03T19:00:00Z", "2023-07-03T19:05:00Z", "2023-07-03T19:10:00Z", "2023-07-03T19:15:00Z", "2023-07-03T19:20:00Z", "2023-07-03T19:25:00Z", "2023-07-03T19:30:00Z", "2023-07-03T19:35:00Z", "2023-07-03T19:40:00Z", "2023-07-03T19:45:00Z", "2023-07-03T19:50:00Z", "2023-07-03T19:55:00Z", "2023-07-03T20:00:00Z", "2023-07-03T20:05:00Z", "2023-07-03T20:10:00Z", "2023-07-03T20:15:00Z", "2023-07-03T20:20:00Z", "2023-07-03T20:25:00Z", "2023-07-03T20:30:00Z", "2023-07-03T20:35:00Z", "2023-07-03T20:40:00Z", "2023-07-03T20:45:00Z", "2023-07-03T20:50:00Z", "2023-07-03T20:55:00Z", "2023-07-03T21:00:00Z", "2023-07-03T21:05:00Z", "2023-07-03T21:10:00Z", "2023-07-03T21:15:00Z", "2023-07-03T21:20:00Z", "2023-07-03T21:25:00Z", "2023-07-03T21:30:00Z", "2023-07-03T21:35:00Z", "2023-07-03T21:40:00Z", "2023-07-03T21:45:00Z", "2023-07-03T21:50:00Z", "2023-07-03T21:55:00Z"],
    }),
  });

  /**
   * up to 164 datapoints(1 hour values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const WEEK: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/GridBuyActiveEnergy": 2368,
        "_sum/ConsumptionActiveEnergy": 76690,
        "_sum/EssDcChargeEnergy": 38671,
        "_sum/EssDcDischargeEnergy": 31809,
        "_sum/GridSellActiveEnergy": 119692,
        "_sum/ProductionActiveEnergy": 200875,
      },
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/ConsumptionActivePower": [160.22222222222223, 165.16666666666666, 149.91666666666666, 242.45454545454547, 248.66666666666666, 267.9166666666667, 196.58333333333334, 157.75, 540.8333333333334, 764.0833333333334, 1916.3333333333333, 664.5833333333334, 2004.4166666666667, 2195.0833333333335, 1631.25, 788.0833333333334, 241.16666666666666, 109.5, 362.1666666666667, 140.41666666666666, 982.4166666666666, 459.8333333333333, 318.0833333333333, 869.9166666666666, 157, 146.16666666666666, 172.58333333333334, 125.9090909090909, 194.44444444444446, 223.83333333333334, 377.25, 725.0833333333334, 385, 1390.75, 262.75, 194.33333333333334, 105.16666666666667, 201, 307.75, 197.16666666666666, 200.83333333333334, 491.0833333333333, 398, 428.25, 756.75, 393.5, 169.33333333333334, 248.41666666666666, 335.4166666666667, 222.33333333333334, 182.5, 172.0909090909091, 179, 256.8333333333333, 336.4166666666667, 840.3333333333334, 415.5, 617.1666666666666, 778.5, 574.6666666666666, 1538.75, 619.3333333333334, 992.25, 431.9166666666667, 929.75, 1018.9166666666666, 224.33333333333334, 600.4166666666666, 441.0833333333333, 897.3333333333334, 589.5, 245.41666666666666, 138.36363636363637, 213.66666666666666, 180.75, 166.54545454545453, 257.8888888888889, 251.41666666666666, 523.6666666666666, 1243.1666666666667, 737.9166666666666, 973.5833333333334, 351.25, 2583.8333333333335, 1748.0833333333333, 1242.1666666666667, 2356.75, 1592.1666666666667, 1193.75, 178.08333333333334, 246.83333333333334, 624.8181818181819, 470.44444444444446, 961.9166666666666, 204.33333333333334, 637.6666666666666, 149.58333333333334, 191.25, 147.83333333333334, 208, 228.66666666666666, 248.91666666666666, 150.5, 674.5, 768.5, 554.5833333333334, 503.25, 514.8333333333334, 1989.3333333333333, 1216.1666666666667, 665.1666666666666, 150.25, 126.25, 53.166666666666664, 496.3333333333333, 2545.75, 1324.6666666666667, 2115, 669.8333333333334, 154.58333333333334, 159.75, 139.16666666666666, 122.66666666666667, 202.9090909090909, 231.22222222222223, 533, 156.75, 136.25, 2067, 790.3333333333334, 988.3333333333334, 446.0833333333333, 279.0833333333333, 1800.5, 819.8333333333334, 2605.25, 1832.25, 2153.3333333333335, 1072, 1204.3333333333333, 605.1666666666666, 1136.75, 333.0833333333333, 343.8333333333333, 648.6666666666666, 480.25, 171.16666666666666, 153.8181818181818, 197.22222222222223, 228.58333333333334, 220.16666666666666, 167.58333333333334, 1326.3636363636363, 905.6666666666666, 543.2857142857143, 897.5, 2457.222222222222, 1166.8, 1392.0833333333333, 3111.909090909091, 678.5, 451, 1089, 171.3, 691.9, 444.625, 569.6, 131.5],
        "_sum/GridActivePower": [-2.3333333333333335, 11.916666666666666, 16.333333333333332, 6.090909090909091, 15.333333333333334, 11.666666666666666, 2.4166666666666665, -14.166666666666666, -28.083333333333332, -954.6666666666666, -4150.583333333333, -6431.333333333333, -5737.583333333333, -5671.416666666667, -5873.333333333333, -5049.083333333333, -3122, -1037.4166666666667, -228.08333333333334, -20, 24.25, 4.416666666666667, 3.5833333333333335, -8.333333333333334, -3.0833333333333335, -8.333333333333334, 44.416666666666664, -7.7272727272727275, 13.11111111111111, 1, -2.75, -13.833333333333334, -17.416666666666668, -6.083333333333333, -564.6666666666666, -2225.1666666666665, -2033.75, -3997.25, -4990.083333333333, -3012.8333333333335, -2484.4166666666665, -1378, -659.75, 1.1666666666666667, -1, -6.916666666666667, -8.166666666666666, 1.5833333333333333, 13.333333333333334, 20.416666666666668, 11.25, 19.727272727272727, 12.444444444444445, 9.583333333333334, -4.083333333333333, -10.583333333333334, -11.166666666666666, -1261, -5308.833333333333, -6604, -6321.166666666667, -6488.333333333333, -6784.25, -6052.083333333333, -2583.9166666666665, -529, -16.166666666666668, -5.5, 7.666666666666667, -0.6666666666666666, 2.3333333333333335, 12.5, 16.09090909090909, 20.166666666666668, 14.083333333333334, 6.363636363636363, 19.555555555555557, 48.416666666666664, 11.166666666666666, -2.4166666666666665, -12.5, -706.5, -5835.416666666667, -4770.25, -6039.25, -6844.583333333333, -5370.333333333333, -4490.166666666667, -2350.6666666666665, -765.0833333333334, -85.83333333333333, -11.454545454545455, 14.222222222222221, 2.25, -5.666666666666667, 3.6666666666666665, 32.916666666666664, 14.666666666666666, 13.5, 17.363636363636363, 13.333333333333334, 22.083333333333332, -3.3333333333333335, -4.083333333333333, -20.333333333333332, -23.166666666666668, -1410.6666666666667, -858.8333333333334, -1.5833333333333333, -6.583333333333333, -10.083333333333334, -341.0833333333333, -2929.0833333333335, -1117.5833333333333, -485.8333333333333, 0.9166666666666666, 0, 2.1666666666666665, -0.6666666666666666, -17.916666666666668, -4, 0.5, 48.416666666666664, -1, 5.555555555555555, 27.166666666666668, 17.333333333333332, -23.583333333333332, -6.416666666666667, -8.166666666666666, -3.1666666666666665, -9.916666666666666, -2725.4166666666665, -1837.25, -2632.25, -2217.0833333333335, -529, 2.3333333333333335, 8.333333333333334, 3, 15.916666666666666, 3.25, -0.3333333333333333, 4.333333333333333, 1, -11.416666666666666, -11.083333333333334, 19.545454545454547, 1.7777777777777777, 6.416666666666667, 17.666666666666668, -8.333333333333334, -8.818181818181818, -15.333333333333334, -18.857142857142858, -24.833333333333332, -10.88888888888889, -2217.4, -3921.4166666666665, -1624.8181818181818, -1937, -1789, -19.5, -14.3, 5.8, 5.625, -9, -18.875],
        // 'GridSell': [6476, 6488, -1000, 0],
        "_sum/EssSoc": [76.11111111111111, 74.83333333333333, 73.75, 72.54545454545455, 71, 70.08333333333333, 69.5, 70.83333333333333, 78.5, 93.16666666666667, 100, 100, 100, 100, 100, 100, 99.58333333333333, 99, 99, 99, 98.25, 93.5, 90.75, 86.5, 83.58333333333333, 82.41666666666667, 81.58333333333333, 80.0909090909091, 79, 78, 77.91666666666667, 75.75, 79.41666666666667, 81.33333333333333, 89.08333333333333, 99.91666666666667, 100, 100, 100, 100, 100, 99, 99, 98.66666666666667, 96.33333333333333, 93.41666666666667, 91.58333333333333, 90.5, 88.08333333333333, 86.75, 85.66666666666667, 84.63636363636364, 83, 81.66666666666667, 81, 80.08333333333333, 84.33333333333333, 96.16666666666667, 100, 100, 100, 100, 100, 100, 99.5, 99.25, 99, 98.41666666666667, 95.91666666666667, 91.83333333333333, 88, 85.08333333333333, 83.72727272727273, 82.5, 81.33333333333333, 80.18181818181819, 78.22222222222223, 77.41666666666667, 76.91666666666667, 73.83333333333333, 76.75, 91.5, 100, 100, 100, 100, 100, 100, 99.58333333333333, 99, 99, 98.54545454545455, 95.66666666666667, 91, 88.41666666666667, 85.91666666666667, 83.08333333333333, 82, 80.83333333333333, 79.54545454545455, 78.11111111111111, 77.08333333333333, 77.16666666666667, 79.16666666666667, 84.08333333333333, 91.66666666666667, 99.5, 99.91666666666667, 96.66666666666667, 87.58333333333333, 86.5, 92.41666666666667, 100, 100, 99.83333333333333, 92.75, 81.75, 73.33333333333333, 62.25, 60.416666666666664, 59.166666666666664, 57.75, 56.583333333333336, 55.45454545454545, 53.888888888888886, 51.833333333333336, 51, 53.916666666666664, 58.583333333333336, 58.333333333333336, 60.166666666666664, 77.25, 99, 98.83333333333333, 98.75, 99.33333333333333, 99.08333333333333, 96.16666666666667, 88.25, 84.25, 79.75, 75.75, 71, 68.83333333333333, 65.41666666666667, 62.5, 59.5, 58.45454545454545, 56.888888888888886, 55.916666666666664, 55, 55, 56.18181818181818, 61.333333333333336, 66.14285714285714, 71, 79.88888888888889, 97.2, 100, 99.72727272727273, 100, 100, 89.66666666666667, 90.3, 88.9, 85.875, 83.7, 80.5],
        "_sum/EssActivePower": [162.55555555555554, 153.08333333333334, 133.58333333333334, 236.45454545454547, 233.22222222222223, 256.4166666666667, 194.16666666666666, 172, 568.8333333333334, 1718.5, 6066.75, 7096, 7742.25, 7866.5, 7504.666666666667, 5837, 3363.0833333333335, 1146.9166666666667, 590.4166666666666, 160.33333333333334, 958.0833333333334, 455.5833333333333, 314.3333333333333, 878.25, 159.83333333333334, 154.33333333333334, 128.08333333333334, 133.36363636363637, 181.11111111111111, 222.91666666666666, 380, 738.8333333333334, 402.4166666666667, 1396.8333333333333, 827.4166666666666, 2419.4166666666665, 2139.0833333333335, 4198.333333333333, 5297.75, 3210.1666666666665, 2685.25, 1869.1666666666667, 1057.9166666666667, 427.25, 757.75, 400.3333333333333, 177.5, 246.91666666666666, 322.25, 201.91666666666666, 171.16666666666666, 152.27272727272728, 166.33333333333334, 247.41666666666666, 340.5, 851, 426.75, 1878.1666666666667, 6087.083333333333, 7178.916666666667, 7859.666666666667, 7107.666666666667, 7776.5, 6484.166666666667, 3513.75, 1547.75, 240.75, 605.75, 433.1666666666667, 897.9166666666666, 587.25, 233, 122.45454545454545, 193.41666666666666, 166.75, 160.1818181818182, 238.33333333333334, 203.08333333333334, 512.6666666666666, 1245.4166666666667, 750.25, 1680.1666666666667, 6186.583333333333, 7354.166666666667, 7787.416666666667, 8086.583333333333, 7726.916666666667, 6082.333333333333, 3544.5, 943.25, 332.5833333333333, 636.2727272727273, 456.3333333333333, 959.8333333333334, 210.08333333333334, 633.9166666666666, 116.58333333333333, 176.58333333333334, 134.25, 190.72727272727272, 215.11111111111111, 226.41666666666666, 154, 678.4166666666666, 789, 577.5833333333334, 1913.8333333333333, 1373.5833333333333, 1991, 1222.75, 675.3333333333334, 491.1666666666667, 3055.3333333333335, 1170.6666666666667, 982.1666666666666, 2544.6666666666665, 1324.3333333333333, 2112.75, 670.25, 172.66666666666666, 163.91666666666666, 138.58333333333334, 74.41666666666667, 203.8181818181818, 225.66666666666666, 505.8333333333333, 139.41666666666666, 159.83333333333334, 2073.6666666666665, 798.75, 991.3333333333334, 456.1666666666667, 3004.4166666666665, 3637.5, 3451.9166666666665, 4822.416666666667, 2361.0833333333335, 2151.0833333333335, 1063.6666666666667, 1201.4166666666667, 589.4166666666666, 1133.4166666666667, 333.25, 339.5, 647.4166666666666, 491.6666666666667, 182.08333333333334, 134.36363636363637, 195.55555555555554, 222.16666666666666, 202.5, 176, 1334.909090909091, 920.8333333333334, 562.1428571428571, 922.5, 2468.1111111111113, 3384.2, 5313.416666666667, 4736.727272727273, 2615.8333333333335, 2239, 1108.5, 185.6, 686.2, 439.375, 578.7, 150.375],
        "_sum/ProductionActivePower": [0, 0, 0, 0, 68.77777777777777, 106.41666666666667, 248.08333333333334, 934.3333333333334, 2706.9166666666665, 4602.25, 6107.5, 7152.166666666667, 7810.5, 7919.833333333333, 7557.5, 5898.916666666667, 3422.5, 1208.25, 631.5833333333334, 434.8333333333333, 116.25, 55.5, 0, 0, 0, 0, 0, 0, 55.666666666666664, 116.16666666666667, 415.3333333333333, 809.75, 1323.3333333333333, 1524.6666666666667, 4180.416666666667, 2543.3333333333335, 2198.1666666666665, 4257.916666666667, 5337.583333333333, 3255, 2737.0833333333335, 1929.8333333333333, 1046.0833333333333, 507.5, 126.33333333333333, 57.5, 0, 0, 0, 0, 0, 0, 32.666666666666664, 82.33333333333333, 393.3333333333333, 1098.75, 1889.25, 4037.1666666666665, 6144.166666666667, 7233.5, 7912.333333333333, 7173.5, 7830.25, 6541.166666666667, 3715.5, 1372, 471.3333333333333, 298.75, 128.91666666666666, 60.5, 1.4166666666666667, 0, 0, 0, 0, 0, 70.55555555555556, 126, 229.75, 936.9166666666666, 2791.4166666666665, 4741.666666666667, 6264.666666666667, 7398.416666666667, 7854.166666666667, 8138.5, 7774.083333333333, 6136.583333333333, 3593.75, 994.6666666666666, 392.0833333333333, 306.90909090909093, 120.22222222222223, 58.5, 0.08333333333333333, 0, 0, 0, 0, 0, 46.44444444444444, 123, 477.3333333333333, 1267.4166666666667, 2032.3333333333333, 2606.75, 2398.25, 1240.4166666666667, 743.0833333333334, 722.75, 706, 2840.9166666666665, 3128.4166666666665, 1239.75, 738.8333333333334, 369.0833333333333, 114.75, 57.25, 0, 0, 0, 0, 0, 0, 36.22222222222222, 110.33333333333333, 414.25, 1295.5833333333333, 2024.4166666666667, 1616.3333333333333, 1624, 5705, 4261.5, 2996.4166666666665, 4293.333333333333, 4474.083333333333, 2637.3333333333335, 576.0833333333334, 717.0833333333334, 357.5, 165.66666666666666, 61, 0, 0, 0, 0, 0, 0, 41.22222222222222, 96.33333333333333, 183.25, 427.5, 1859.8181818181818, 3429, 1226.2857142857142, 2923, 4695, 4456.8, 5333.916666666667, 4859.545454545455, 2662.5, 2284, 713.1666666666666, 449.1, 156.1, 61.5, 0.6, 0],
        "_sum/ProductionDcActualPower": [0, 0, 0, 0, 68.77777777777777, 106.41666666666667, 248.08333333333334, 934.3333333333334, 2706.9166666666665, 4602.25, 6107.5, 7152.166666666667, 7810.5, 7919.833333333333, 7557.5, 5898.916666666667, 3422.5, 1208.25, 631.5833333333334, 434.8333333333333, 116.25, 55.5, 0, 0, 0, 0, 0, 0, 55.666666666666664, 116.16666666666667, 415.3333333333333, 809.75, 1323.3333333333333, 1524.6666666666667, 4180.416666666667, 2543.3333333333335, 2198.1666666666665, 4257.916666666667, 5337.583333333333, 3255, 2737.0833333333335, 1929.8333333333333, 1046.0833333333333, 507.5, 126.33333333333333, 57.5, 0, 0, 0, 0, 0, 0, 32.666666666666664, 82.33333333333333, 393.3333333333333, 1098.75, 1889.25, 4037.1666666666665, 6144.166666666667, 7233.5, 7912.333333333333, 7173.5, 7830.25, 6541.166666666667, 3715.5, 1372, 471.3333333333333, 298.75, 128.91666666666666, 60.5, 1.4166666666666667, 0, 0, 0, 0, 0, 70.55555555555556, 126, 229.75, 936.9166666666666, 2791.4166666666665, 4741.666666666667, 6264.666666666667, 7398.416666666667, 7854.166666666667, 8138.5, 7774.083333333333, 6136.583333333333, 3593.75, 994.6666666666666, 392.0833333333333, 306.90909090909093, 120.22222222222223, 58.5, 0.08333333333333333, 0, 0, 0, 0, 0, 46.44444444444444, 123, 477.3333333333333, 1267.4166666666667, 2032.3333333333333, 2606.75, 2398.25, 1240.4166666666667, 743.0833333333334, 722.75, 706, 2840.9166666666665, 3128.4166666666665, 1239.75, 738.8333333333334, 369.0833333333333, 114.75, 57.25, 0, 0, 0, 0, 0, 0, 36.22222222222222, 110.33333333333333, 414.25, 1295.5833333333333, 2024.4166666666667, 1616.3333333333333, 1624, 5705, 4261.5, 2996.4166666666665, 4293.333333333333, 4474.083333333333, 2637.3333333333335, 576.0833333333334, 717.0833333333334, 357.5, 165.66666666666666, 61, 0, 0, 0, 0, 0, 0, 41.22222222222222, 96.33333333333333, 183.25, 427.5, 1859.8181818181818, 3429, 1226.2857142857142, 2923, 4695, 4456.8, 5333.916666666667, 4859.545454545455, 2662.5, 2284, 713.1666666666666, 449.1, 156.1, 61.5, 0.6, 0],
      },
      timestamps: ["2023-06-25T22:00:00Z", "2023-06-25T23:00:00Z", "2023-06-26T00:00:00Z", "2023-06-26T01:00:00Z", "2023-06-26T02:00:00Z", "2023-06-26T03:00:00Z", "2023-06-26T04:00:00Z", "2023-06-26T05:00:00Z", "2023-06-26T06:00:00Z", "2023-06-26T07:00:00Z", "2023-06-26T08:00:00Z", "2023-06-26T09:00:00Z", "2023-06-26T10:00:00Z", "2023-06-26T11:00:00Z", "2023-06-26T12:00:00Z", "2023-06-26T13:00:00Z", "2023-06-26T14:00:00Z", "2023-06-26T15:00:00Z", "2023-06-26T16:00:00Z", "2023-06-26T17:00:00Z", "2023-06-26T18:00:00Z", "2023-06-26T19:00:00Z", "2023-06-26T20:00:00Z", "2023-06-26T21:00:00Z", "2023-06-26T22:00:00Z", "2023-06-26T23:00:00Z", "2023-06-27T00:00:00Z", "2023-06-27T01:00:00Z", "2023-06-27T02:00:00Z", "2023-06-27T03:00:00Z", "2023-06-27T04:00:00Z", "2023-06-27T05:00:00Z", "2023-06-27T06:00:00Z", "2023-06-27T07:00:00Z", "2023-06-27T08:00:00Z", "2023-06-27T09:00:00Z", "2023-06-27T10:00:00Z", "2023-06-27T11:00:00Z", "2023-06-27T12:00:00Z", "2023-06-27T13:00:00Z", "2023-06-27T14:00:00Z", "2023-06-27T15:00:00Z", "2023-06-27T16:00:00Z", "2023-06-27T17:00:00Z", "2023-06-27T18:00:00Z", "2023-06-27T19:00:00Z", "2023-06-27T20:00:00Z", "2023-06-27T21:00:00Z", "2023-06-27T22:00:00Z", "2023-06-27T23:00:00Z", "2023-06-28T00:00:00Z", "2023-06-28T01:00:00Z", "2023-06-28T02:00:00Z", "2023-06-28T03:00:00Z", "2023-06-28T04:00:00Z", "2023-06-28T05:00:00Z", "2023-06-28T06:00:00Z", "2023-06-28T07:00:00Z", "2023-06-28T08:00:00Z", "2023-06-28T09:00:00Z", "2023-06-28T10:00:00Z", "2023-06-28T11:00:00Z", "2023-06-28T12:00:00Z", "2023-06-28T13:00:00Z", "2023-06-28T14:00:00Z", "2023-06-28T15:00:00Z", "2023-06-28T16:00:00Z", "2023-06-28T17:00:00Z", "2023-06-28T18:00:00Z", "2023-06-28T19:00:00Z", "2023-06-28T20:00:00Z", "2023-06-28T21:00:00Z", "2023-06-28T22:00:00Z", "2023-06-28T23:00:00Z", "2023-06-29T00:00:00Z", "2023-06-29T01:00:00Z", "2023-06-29T02:00:00Z", "2023-06-29T03:00:00Z", "2023-06-29T04:00:00Z", "2023-06-29T05:00:00Z", "2023-06-29T06:00:00Z", "2023-06-29T07:00:00Z", "2023-06-29T08:00:00Z", "2023-06-29T09:00:00Z", "2023-06-29T10:00:00Z", "2023-06-29T11:00:00Z", "2023-06-29T12:00:00Z", "2023-06-29T13:00:00Z", "2023-06-29T14:00:00Z", "2023-06-29T15:00:00Z", "2023-06-29T16:00:00Z", "2023-06-29T17:00:00Z", "2023-06-29T18:00:00Z", "2023-06-29T19:00:00Z", "2023-06-29T20:00:00Z", "2023-06-29T21:00:00Z", "2023-06-29T22:00:00Z", "2023-06-29T23:00:00Z", "2023-06-30T00:00:00Z", "2023-06-30T01:00:00Z", "2023-06-30T02:00:00Z", "2023-06-30T03:00:00Z", "2023-06-30T04:00:00Z", "2023-06-30T05:00:00Z", "2023-06-30T06:00:00Z", "2023-06-30T07:00:00Z", "2023-06-30T08:00:00Z", "2023-06-30T09:00:00Z", "2023-06-30T10:00:00Z", "2023-06-30T11:00:00Z", "2023-06-30T12:00:00Z", "2023-06-30T13:00:00Z", "2023-06-30T14:00:00Z", "2023-06-30T15:00:00Z", "2023-06-30T16:00:00Z", "2023-06-30T17:00:00Z", "2023-06-30T18:00:00Z", "2023-06-30T19:00:00Z", "2023-06-30T20:00:00Z", "2023-06-30T21:00:00Z", "2023-06-30T22:00:00Z", "2023-06-30T23:00:00Z", "2023-07-01T00:00:00Z", "2023-07-01T01:00:00Z", "2023-07-01T02:00:00Z", "2023-07-01T03:00:00Z", "2023-07-01T04:00:00Z", "2023-07-01T05:00:00Z", "2023-07-01T06:00:00Z", "2023-07-01T07:00:00Z", "2023-07-01T08:00:00Z", "2023-07-01T09:00:00Z", "2023-07-01T10:00:00Z", "2023-07-01T11:00:00Z", "2023-07-01T12:00:00Z", "2023-07-01T13:00:00Z", "2023-07-01T14:00:00Z", "2023-07-01T15:00:00Z", "2023-07-01T16:00:00Z", "2023-07-01T17:00:00Z", "2023-07-01T18:00:00Z", "2023-07-01T19:00:00Z", "2023-07-01T20:00:00Z", "2023-07-01T21:00:00Z", "2023-07-01T22:00:00Z", "2023-07-01T23:00:00Z", "2023-07-02T00:00:00Z", "2023-07-02T01:00:00Z", "2023-07-02T02:00:00Z", "2023-07-02T03:00:00Z", "2023-07-02T04:00:00Z", "2023-07-02T05:00:00Z", "2023-07-02T06:00:00Z", "2023-07-02T07:00:00Z", "2023-07-02T08:00:00Z", "2023-07-02T09:00:00Z", "2023-07-02T10:00:00Z", "2023-07-02T11:00:00Z", "2023-07-02T12:00:00Z", "2023-07-02T13:00:00Z", "2023-07-02T14:00:00Z", "2023-07-02T15:00:00Z", "2023-07-02T16:00:00Z", "2023-07-02T17:00:00Z", "2023-07-02T18:00:00Z", "2023-07-02T19:00:00Z", "2023-07-02T20:00:00Z", "2023-07-02T21:00:00Z"],
    }),
  };

  /**
  * up to 31 datapoints(1 day values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const MONTH: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/GridBuyActiveEnergy": 773000,
        "_sum/ConsumptionActiveEnergy": 9976102,
        "_sum/EssDcChargeEnergy": 3944328,
        "_sum/EssDcDischargeEnergy": 3394430,
        "_sum/GridSellActiveEnergy": 12738000,
        "_sum/ProductionActiveEnergy": 22491000,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ConsumptionActiveEnergy": [320342, 346615, 341433, 333054, 358458, 347872, 289283, null, 556510, 311366, 314722, 355556, 381671, 384558, 366190, 349336, 303696, 288727, 357434, 388659, 402625, null, 713771, 320238, 332099, null, 756429, 384136, 371322, null],
          "_sum/EssDcChargeEnergy": [113476, 162917, 150189, 157158, 149782, 159833, 155084, null, 228757, 128138, 157539, 59414, 156504, 107339, 156392, 158925, 158578, 121505, 120971, 154566, 173235, null, 204273, 156676, 143745, null, 247673, 157410, 104249, null],
          "_sum/EssDcDischargeEnergy": [112818, 126532, 139622, 133212, 169240, 98705, 109367, null, 204267, 118504, 121261, 74970, 144175, 89897, 141582, 111261, 122274, 106232, 139405, 132225, 143860, null, 235044, 63914, 123844, null, 242102, 130546, 59571, null],
          "_sum/GridBuyActiveEnergy": [16000, 6000, 3000, 3000, 5000, 48000, 4000, null, 5000, 26000, 17000, 62000, 8000, 66000, 13000, 21000, 4000, 3000, 18000, 27000, 29000, null, 118000, 85000, 2000, null, 72000, 28000, 84000, null],
          "_sum/GridSellActiveEnergy": [603000, 590000, 551000, 572000, 69000, 236000, 626000, null, 1003000, 261000, 518000, 698000, 640000, 388000, 471000, 373000, 373000, 677000, 286000, 406000, 249000, null, 446000, 369000, 558000, null, 776000, 425000, 574000, null],
          "_sum/ProductionActiveEnergy": [908000, 967000, 900000, 926000, 403000, 597000, 957000, null, 1579000, 556000, 852000, 976000, 1026000, 724000, 839000, 749000, 709000, 978000, 607000, 790000, 652000, null, 1011000, 697000, 908000, null, 1466000, 808000, 906000, null],
        },
        timestamps: ["2023-05-31T22:00:00Z", "2023-06-01T22:00:00Z", "2023-06-02T22:00:00Z", "2023-06-03T22:00:00Z", "2023-06-04T22:00:00Z", "2023-06-05T22:00:00Z", "2023-06-06T22:00:00Z", "2023-06-07T22:00:00Z", "2023-06-08T22:00:00Z", "2023-06-09T22:00:00Z", "2023-06-10T22:00:00Z", "2023-06-11T22:00:00Z", "2023-06-12T22:00:00Z", "2023-06-13T22:00:00Z", "2023-06-14T22:00:00Z", "2023-06-15T22:00:00Z", "2023-06-16T22:00:00Z", "2023-06-17T22:00:00Z", "2023-06-18T22:00:00Z", "2023-06-19T22:00:00Z", "2023-06-20T22:00:00Z", "2023-06-21T22:00:00Z", "2023-06-22T22:00:00Z", "2023-06-23T22:00:00Z", "2023-06-24T22:00:00Z", "2023-06-25T22:00:00Z", "2023-06-26T22:00:00Z", "2023-06-27T22:00:00Z", "2023-06-28T22:00:00Z", "2023-06-29T22:00:00Z"],
      }),
  };

  /**
  * up to 12 datapoints(1 month values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const YEAR: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/GridBuyActiveEnergy": 23209000,
        "_sum/ConsumptionActiveEnergy": 58573394,
        "_sum/EssDcChargeEnergy": 15296815,
        "_sum/EssDcDischargeEnergy": 12898209,
        "_sum/GridSellActiveEnergy": 30703000,
        "_sum/ProductionActiveEnergy": 68466000,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ConsumptionActiveEnergy": [11634885, 8207927, 8976354, 8311835, 10341804, 9976102, 975807, null, null, null, null, null],
          "_sum/EssDcChargeEnergy": [294606, 1673109, 3337772, 3074303, 2495947, 3944328, 372595, null, null, null, null, null],
          "_sum/EssDcDischargeEnergy": [208491, 1339036, 2911126, 2555138, 2123751, 3394430, 335402, null, null, null, null, null],
          "_sum/GridBuyActiveEnergy": [9829000, 4812000, 2915000, 2036000, 2712000, 773000, 94000, null, null, null, null, null],
          "_sum/GridSellActiveEnergy": [20000, 86000, 677000, 3657000, 12839000, 12738000, 627000, null, null, null, null, null],
          "_sum/ProductionActiveEnergy": [1912000, 3816000, 7165000, 10452000, 20841000, 22491000, 1546000, null, null, null, null, null],
        },
        timestamps: [
          "2022-12-31T23:00:00Z",
          "2023-01-31T23:00:00Z",
          "2023-02-28T23:00:00Z",
          "2023-03-31T22:00:00Z",
          "2023-04-30T22:00:00Z",
          "2023-05-31T22:00:00Z",
          "2023-06-30T22:00:00Z",
          "2023-07-31T22:00:00Z",
          "2023-08-31T22:00:00Z",
          "2023-09-30T22:00:00Z",
          "2023-10-31T23:00:00Z",
          "2023-11-30T23:00:00Z",
        ],
      }),
  };
}
