import { OeTester } from "src/app/shared/components/shared/testing/common";
import { QueryHistoricTimeseriesDataResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesDataResponse";
import { QueryHistoricTimeseriesEnergyPerPeriodResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyPerPeriodResponse";
import { QueryHistoricTimeseriesEnergyResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyResponse";

export namespace History {

  /**
   * up to 288 datapoints (5 min aggregated values) from a
   *
   * {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const DAY: OeTester.Types.Channels = ({
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ConsumptionActiveEnergy": 92989,
        "_sum/ConsumptionActiveEnergyL1": 30996,
        "_sum/ConsumptionActiveEnergyL2": 30996,
        "_sum/ConsumptionActiveEnergyL3": 30996,
        "evcs0/ActiveConsumptionEnergy": 13720,
        "meter0/ActiveProductionEnergy": 15930,
        "heat0/ActiveProductionEnergy": 15930,
      },
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/ConsumptionActivePower": [null, null, null, 565.8045977011494, 560.5148514851485, 561.425925925926, 573.2169811320755, 565.8080808080808, 587.9803921568628, 584.2389380530974, 607.4818181818182, 605.0275229357799, 595.6407766990292, 602.5294117647059, 578.1684210526316, 581.6813186813187, 649.5166666666667, 560.3, 567.0373831775701, 629.7672413793103, 568.8613861386139, 589.6039603960396, 634.5090909090909, 622.6633663366337, 617.7196261682243, 608.122641509434, 602.78, 650.8155339805825, 605.8877551020408, 594.3904761904762, 576.36, 565.066037735849, 587.495145631068, 626.375, 681.9428571428572, 650.4629629629629, 631.373831775701, 687.25, 560.2452830188679, 527.8952380952381, 620.2222222222222, 546.6355140186915, 587.8130841121496, 604, 616.295918367347, 578.940594059406, 594.3396226415094, 648.1078431372549, null, null, null, 565.2183908045977, 573.6481481481482, 536.5462962962963, 558.081081081081, 574.7543859649123, 574.3557692307693, 596.9047619047619, 654.072072072072, 615.21, 612.8045977011494, 636.11, 613.7948717948718, 538.8857142857142, 537.1157894736842, 551.1634615384615, 558.8809523809524, 559.1222222222223, 618.5576923076923, 654.3287671232877, 616.0574712643678, 588.9056603773585, 578.7096774193549, 583.0360360360361, 572.5700934579439, 595.2631578947369, 745.0888888888888, 820.7323943661971, 2651.1923076923076, 8063.131147540984, 6952.055555555556, 7413.41052631579, 6695.175, 6688.301075268817, 7135.544444444445, 6935.6125, 6768.398148148148, 6962.593220338983, 3449.51968503937, 677.4427860696518, 982.7305699481865, 858.2012987012987, 767.8924050632911, 761.950495049505, 682.1319796954315, 725.4198473282443, 702.1286549707602, 730.9484536082474, 739, 730.572864321608, 754.7467532467532, 657.373417721519, 640.9480519480519, 669.8156424581006, 787.6280991735537, 2931.229357798165, 1954.2808988764045, 777.5346534653465, 1098.538860103627, 1244.1524390243903, 2919.4913793103447, 2987.4188034188032, 3414.029411764706, 1355.2, 2714.2824427480914, 2657.8703703703704, 2873.892307692308, 6140.337078651685, 3966.560606060606, 3021.5789473684213, 1774.1875, 1076.46, 1426.8691588785048, 1261.0386740331492, 1019.3491124260355, 1194.960199004975, 1241.2878787878788, 3323, 3968.45625, 1468.0961538461538, 3630.4166666666665, 2269.5301204819275, 2554.391025641026, 1845.7888888888888, 1728.9767441860465, 2862.08, 2324.1241379310345, 1964.0169491525423, 1808.4, 3466.05035971223, 2297.4397590361446, 2530.0493827160494, 2439.3584905660377, 2007.9060773480662, 1751.5, 1416.3181818181818, 1429.2298850574712, 1452.0298507462687, 1489.720430107527, 1633.095238095238, 1826.2928571428572, 1610.1904761904761, 1680.9292929292928, 2881.743119266055, 3585.1634615384614, 3689.1666666666665, 3657.340277777778, 3643.5348837209303, 3714.8645833333335, 3731.375, 3744.79, 3636.2363636363634, 4273.113924050633, 3446.2, 3538.714285714286, 3790.6065573770493, 3527.675, 3467.671232876712, 3559.5, 3798.2, 5460.666666666667, 1309.4406779661017, 1535.7454545454545, 3423.8260869565215, 3382.3636363636365, 3400.6315789473683, 2950.75, 3386.731707317073, 2506, 1447.1666666666667, 1442.6, 946, 942.578947368421, 950.7142857142857, 947, 976.2857142857143, 1786.2857142857142, 1513.5777777777778, 1499.5625, 1338, 1327.8125, 1273.9175257731958, 1438.7457627118645, 1248.4186046511627, 1286.6693548387098, 1284.8934911242604, 1223.7952755905512, 748.09375, 871.7684210526315, 844.5338983050848, 791.675, 804.1932773109244, 730.3737373737374, 705.5024390243902, 687.2407407407408, 690.9939759036145, 751, 765.139344262295, 686.8717948717949, 669.7434210526316, 1767.8091603053435, 724.6764705882352, 748.2772277227723, 940.1142857142858, 750.368, 1366.0232558139535, 727.4137931034483, 710.719512195122, 689.8555555555556, 739.453488372093, 817.875, 730.4303797468355, 735.5890410958904, 738.2258064516129, 1906.9217391304348, 2290.785714285714, 1207.5072463768115, 1167.5890410958905, 1229.0208333333333, 1192.3777777777777, 1208.871794871795, 1367.715909090909, 1284.2233009708739, 1163.1739130434783, 1152.53, 1161.4545454545455, 1219.5681818181818, 1183.752808988764, 1197.778947368421, 1233.888888888889, 1275.070588235294, 1235.554054054054, 1207.83908045977, 1241.6184210526317, 1159.042735042735, 1138.2948717948718, 1106.9915966386554, 1171.4504504504505, 1223.822429906542, 1122.169642857143, 1018.8928571428571, 981.8285714285714, 998.8363636363637, 6056.572916666667, 7225.528846153846, 7193.834782608696, 7507.321100917431, 7588.695238095238, 7678.689189189189, 9469.633027522936, 10236.186046511628, 10106.608695652174, 9989.125, 9948.229357798165, 9796.030927835052, 9704.217391304348, 8454.028571428571, 6813.476190476191, 6706.782608695652, 6523.452173913043, 6661.553571428572, 5620.777777777777, 812.3142857142857, 809.5892857142857, 866.4786324786324, 877.8319327731092, 810.8141592920354, 815.7121212121212, 770.6470588235294, 763.3157894736842, 781.5151515151515, 807.5833333333334, 824.743119266055, 876.2151898734177, 882.424, 750.2213114754098, 675.9549549549549, 637.1222222222223],
        "_sum/ConsumptionActivePowerL1": [null, null, null, 188.60153256704982, 186.83828382838283, 187.141975308642, 191.07232704402517, 188.60269360269362, 195.99346405228758, 194.7463126843658, 202.4939393939394, 201.6758409785933, 198.54692556634305, 200.84313725490196, 192.7228070175439, 193.89377289377288, 216.50555555555556, 186.76666666666665, 189.01246105919003, 209.92241379310346, 189.6204620462046, 196.53465346534654, 211.5030303030303, 207.55445544554456, 205.90654205607476, 202.7075471698113, 200.92666666666665, 216.93851132686083, 201.9625850340136, 198.13015873015874, 192.12, 188.35534591194968, 195.831715210356, 208.79166666666666, 227.31428571428572, 216.820987654321, 210.45794392523365, 229.08333333333334, 186.74842767295596, 175.9650793650794, 206.74074074074073, 182.21183800623052, 195.93769470404985, 201.33333333333334, 205.43197278911566, 192.98019801980197, 198.11320754716982, 216.0359477124183, null, null, null, 188.40613026819923, 191.21604938271605, 178.84876543209876, 186.027027027027, 191.58479532163744, 191.4519230769231, 198.96825396825398, 218.02402402402402, 205.07000000000002, 204.26819923371647, 212.03666666666666, 204.59829059829062, 179.6285714285714, 179.03859649122808, 183.72115384615384, 186.2936507936508, 186.3740740740741, 206.18589743589743, 218.1095890410959, 205.35249042145594, 196.30188679245282, 192.90322580645162, 194.34534534534535, 190.85669781931463, 198.42105263157896, 248.36296296296294, 273.57746478873236, 883.7307692307692, 2687.7103825136614, 2317.3518518518517, 2471.1368421052634, 2231.725, 2229.4336917562723, 2378.514814814815, 2311.8708333333334, 2256.1327160493825, 2320.864406779661, 1149.8398950131234, 225.81426202321725, 327.5768566493955, 286.06709956709955, 255.96413502109704, 253.983498349835, 227.37732656514382, 241.80661577608143, 234.04288499025338, 243.64948453608247, 246.33333333333334, 243.52428810720266, 251.58225108225108, 219.12447257383965, 213.64935064935062, 223.27188081936686, 262.5426997245179, 977.0764525993883, 651.4269662921348, 259.1782178217822, 366.1796200345423, 414.7174796747968, 973.1637931034483, 995.8062678062678, 1138.0098039215686, 451.73333333333335, 904.7608142493638, 885.9567901234568, 957.9641025641026, 2046.7790262172284, 1322.1868686868686, 1007.1929824561404, 591.3958333333334, 358.82, 475.6230529595016, 420.3462246777164, 339.78303747534517, 398.3200663349917, 413.76262626262627, 1107.6666666666667, 1322.8187500000001, 489.3653846153846, 1210.138888888889, 756.5100401606425, 851.4636752136753, 615.2629629629629, 576.3255813953489, 954.0266666666666, 774.7080459770115, 654.6723163841808, 602.8000000000001, 1155.3501199040768, 765.8132530120482, 843.3497942386831, 813.1194968553459, 669.3020257826887, 583.8333333333334, 472.10606060606057, 476.4099616858237, 484.00995024875624, 496.57347670250897, 544.3650793650794, 608.7642857142857, 536.7301587301587, 560.3097643097643, 960.5810397553518, 1195.054487179487, 1229.7222222222222, 1219.1134259259259, 1214.5116279069769, 1238.2881944444446, 1243.7916666666667, 1248.2633333333333, 1212.0787878787878, 1424.3713080168775, 1148.7333333333333, 1179.5714285714287, 1263.535519125683, 1175.8916666666667, 1155.890410958904, 1186.5, 1266.0666666666666, 1820.2222222222224, 436.48022598870057, 511.91515151515154, 1141.2753623188405, 1127.4545454545455, 1133.5438596491229, 983.5833333333334, 1128.910569105691, 835.3333333333334, 482.3888888888889, 480.8666666666666, 315.3333333333333, 314.1929824561403, 316.90476190476187, 315.6666666666667, 325.42857142857144, 595.4285714285714, 504.52592592592595, 499.8541666666667, 446, 442.6041666666667, 424.63917525773195, 479.5819209039548, 416.1395348837209, 428.8897849462366, 428.29783037475346, 407.93175853018374, 249.36458333333334, 290.58947368421053, 281.51129943502826, 263.89166666666665, 268.0644257703081, 243.45791245791247, 235.16747967479674, 229.08024691358025, 230.33132530120483, 250.33333333333334, 255.04644808743168, 228.95726495726498, 223.24780701754386, 589.2697201017812, 241.55882352941174, 249.42574257425744, 313.37142857142857, 250.12266666666667, 455.3410852713178, 242.47126436781608, 236.90650406504065, 229.95185185185187, 246.484496124031, 272.625, 243.47679324894514, 245.19634703196346, 246.07526881720432, 635.640579710145, 763.5952380952381, 402.50241545893715, 389.1963470319635, 409.6736111111111, 397.4592592592592, 402.95726495726495, 455.905303030303, 428.074433656958, 387.72463768115944, 384.1766666666667, 387.1515151515152, 406.52272727272725, 394.5842696629213, 399.25964912280705, 411.2962962962963, 425.0235294117647, 411.8513513513513, 402.61302681992333, 413.8728070175439, 386.34757834757835, 379.43162393162396, 368.99719887955183, 390.4834834834835, 407.94080996884736, 374.05654761904765, 339.63095238095235, 327.2761904761905, 332.94545454545454, 2018.857638888889, 2408.5096153846152, 2397.9449275362317, 2502.440366972477, 2529.5650793650793, 2559.563063063063, 3156.544342507645, 3412.062015503876, 3368.8695652173915, 3329.7083333333335, 3316.0764525993886, 3265.343642611684, 3234.7391304347825, 2818.0095238095237, 2271.15873015873, 2235.5942028985505, 2174.4840579710144, 2220.5178571428573, 1873.5925925925924, 270.77142857142854, 269.86309523809524, 288.8262108262108, 292.6106442577031, 270.27138643067843, 271.9040404040404, 256.88235294117646, 254.43859649122805, 260.5050505050505, 269.19444444444446, 274.914373088685, 292.07172995780587, 294.1413333333333, 250.0737704918033, 225.31831831831832, 212.3740740740741],
        "_sum/ConsumptionActivePowerL2": [null, null, null, 188.60153256704982, 186.83828382838283, 187.141975308642, 191.07232704402517, 188.60269360269362, 195.99346405228758, 194.7463126843658, 202.4939393939394, 201.6758409785933, 198.54692556634305, 200.84313725490196, 192.7228070175439, 193.89377289377288, 216.50555555555556, 186.76666666666665, 189.01246105919003, 209.92241379310346, 189.6204620462046, 196.53465346534654, 211.5030303030303, 207.55445544554456, 205.90654205607476, 202.7075471698113, 200.92666666666665, 216.93851132686083, 201.9625850340136, 198.13015873015874, 192.12, 188.35534591194968, 195.831715210356, 208.79166666666666, 227.31428571428572, 216.820987654321, 210.45794392523365, 229.08333333333334, 186.74842767295596, 175.9650793650794, 206.74074074074073, 182.21183800623052, 195.93769470404985, 201.33333333333334, 205.43197278911566, 192.98019801980197, 198.11320754716982, 216.0359477124183, null, null, null, 188.40613026819923, 191.21604938271605, 178.84876543209876, 186.027027027027, 191.58479532163744, 191.4519230769231, 198.96825396825398, 218.02402402402402, 205.07000000000002, 204.26819923371647, 212.03666666666666, 204.59829059829062, 179.6285714285714, 179.03859649122808, 183.72115384615384, 186.2936507936508, 186.3740740740741, 206.18589743589743, 218.1095890410959, 205.35249042145594, 196.30188679245282, 192.90322580645162, 194.34534534534535, 190.85669781931463, 198.42105263157896, 248.36296296296294, 273.57746478873236, 883.7307692307692, 2687.7103825136614, 2317.3518518518517, 2471.1368421052634, 2231.725, 2229.4336917562723, 2378.514814814815, 2311.8708333333334, 2256.1327160493825, 2320.864406779661, 1149.8398950131234, 225.81426202321725, 327.5768566493955, 286.06709956709955, 255.96413502109704, 253.983498349835, 227.37732656514382, 241.80661577608143, 234.04288499025338, 243.64948453608247, 246.33333333333334, 243.52428810720266, 251.58225108225108, 219.12447257383965, 213.64935064935062, 223.27188081936686, 262.5426997245179, 977.0764525993883, 651.4269662921348, 259.1782178217822, 366.1796200345423, 414.7174796747968, 973.1637931034483, 995.8062678062678, 1138.0098039215686, 451.73333333333335, 904.7608142493638, 885.9567901234568, 957.9641025641026, 2046.7790262172284, 1322.1868686868686, 1007.1929824561404, 591.3958333333334, 358.82, 475.6230529595016, 420.3462246777164, 339.78303747534517, 398.3200663349917, 413.76262626262627, 1107.6666666666667, 1322.8187500000001, 489.3653846153846, 1210.138888888889, 756.5100401606425, 851.4636752136753, 615.2629629629629, 576.3255813953489, 954.0266666666666, 774.7080459770115, 654.6723163841808, 602.8000000000001, 1155.3501199040768, 765.8132530120482, 843.3497942386831, 813.1194968553459, 669.3020257826887, 583.8333333333334, 472.10606060606057, 476.4099616858237, 484.00995024875624, 496.57347670250897, 544.3650793650794, 608.7642857142857, 536.7301587301587, 560.3097643097643, 960.5810397553518, 1195.054487179487, 1229.7222222222222, 1219.1134259259259, 1214.5116279069769, 1238.2881944444446, 1243.7916666666667, 1248.2633333333333, 1212.0787878787878, 1424.3713080168775, 1148.7333333333333, 1179.5714285714287, 1263.535519125683, 1175.8916666666667, 1155.890410958904, 1186.5, 1266.0666666666666, 1820.2222222222224, 436.48022598870057, 511.91515151515154, 1141.2753623188405, 1127.4545454545455, 1133.5438596491229, 983.5833333333334, 1128.910569105691, 835.3333333333334, 482.3888888888889, 480.8666666666666, 315.3333333333333, 314.1929824561403, 316.90476190476187, 315.6666666666667, 325.42857142857144, 595.4285714285714, 504.52592592592595, 499.8541666666667, 446, 442.6041666666667, 424.63917525773195, 479.5819209039548, 416.1395348837209, 428.8897849462366, 428.29783037475346, 407.93175853018374, 249.36458333333334, 290.58947368421053, 281.51129943502826, 263.89166666666665, 268.0644257703081, 243.45791245791247, 235.16747967479674, 229.08024691358025, 230.33132530120483, 250.33333333333334, 255.04644808743168, 228.95726495726498, 223.24780701754386, 589.2697201017812, 241.55882352941174, 249.42574257425744, 313.37142857142857, 250.12266666666667, 455.3410852713178, 242.47126436781608, 236.90650406504065, 229.95185185185187, 246.484496124031, 272.625, 243.47679324894514, 245.19634703196346, 246.07526881720432, 635.640579710145, 763.5952380952381, 402.50241545893715, 389.1963470319635, 409.6736111111111, 397.4592592592592, 402.95726495726495, 455.905303030303, 428.074433656958, 387.72463768115944, 384.1766666666667, 387.1515151515152, 406.52272727272725, 394.5842696629213, 399.25964912280705, 411.2962962962963, 425.0235294117647, 411.8513513513513, 402.61302681992333, 413.8728070175439, 386.34757834757835, 379.43162393162396, 368.99719887955183, 390.4834834834835, 407.94080996884736, 374.05654761904765, 339.63095238095235, 327.2761904761905, 332.94545454545454, 2018.857638888889, 2408.5096153846152, 2397.9449275362317, 2502.440366972477, 2529.5650793650793, 2559.563063063063, 3156.544342507645, 3412.062015503876, 3368.8695652173915, 3329.7083333333335, 3316.0764525993886, 3265.343642611684, 3234.7391304347825, 2818.0095238095237, 2271.15873015873, 2235.5942028985505, 2174.4840579710144, 2220.5178571428573, 1873.5925925925924, 270.77142857142854, 269.86309523809524, 288.8262108262108, 292.6106442577031, 270.27138643067843, 271.9040404040404, 256.88235294117646, 254.43859649122805, 260.5050505050505, 269.19444444444446, 274.914373088685, 292.07172995780587, 294.1413333333333, 250.0737704918033, 225.31831831831832, 212.3740740740741],
        "_sum/ConsumptionActivePowerL3": [null, null, null, 188.60153256704982, 186.83828382838283, 187.141975308642, 191.07232704402517, 188.60269360269362, 195.99346405228758, 194.7463126843658, 202.4939393939394, 201.6758409785933, 198.54692556634305, 200.84313725490196, 192.7228070175439, 193.89377289377288, 216.50555555555556, 186.76666666666665, 189.01246105919003, 209.92241379310346, 189.6204620462046, 196.53465346534654, 211.5030303030303, 207.55445544554456, 205.90654205607476, 202.7075471698113, 200.92666666666665, 216.93851132686083, 201.9625850340136, 198.13015873015874, 192.12, 188.35534591194968, 195.831715210356, 208.79166666666666, 227.31428571428572, 216.820987654321, 210.45794392523365, 229.08333333333334, 186.74842767295596, 175.9650793650794, 206.74074074074073, 182.21183800623052, 195.93769470404985, 201.33333333333334, 205.43197278911566, 192.98019801980197, 198.11320754716982, 216.0359477124183, null, null, null, 188.40613026819923, 191.21604938271605, 178.84876543209876, 186.027027027027, 191.58479532163744, 191.4519230769231, 198.96825396825398, 218.02402402402402, 205.07000000000002, 204.26819923371647, 212.03666666666666, 204.59829059829062, 179.6285714285714, 179.03859649122808, 183.72115384615384, 186.2936507936508, 186.3740740740741, 206.18589743589743, 218.1095890410959, 205.35249042145594, 196.30188679245282, 192.90322580645162, 194.34534534534535, 190.85669781931463, 198.42105263157896, 248.36296296296294, 273.57746478873236, 883.7307692307692, 2687.7103825136614, 2317.3518518518517, 2471.1368421052634, 2231.725, 2229.4336917562723, 2378.514814814815, 2311.8708333333334, 2256.1327160493825, 2320.864406779661, 1149.8398950131234, 225.81426202321725, 327.5768566493955, 286.06709956709955, 255.96413502109704, 253.983498349835, 227.37732656514382, 241.80661577608143, 234.04288499025338, 243.64948453608247, 246.33333333333334, 243.52428810720266, 251.58225108225108, 219.12447257383965, 213.64935064935062, 223.27188081936686, 262.5426997245179, 977.0764525993883, 651.4269662921348, 259.1782178217822, 366.1796200345423, 414.7174796747968, 973.1637931034483, 995.8062678062678, 1138.0098039215686, 451.73333333333335, 904.7608142493638, 885.9567901234568, 957.9641025641026, 2046.7790262172284, 1322.1868686868686, 1007.1929824561404, 591.3958333333334, 358.82, 475.6230529595016, 420.3462246777164, 339.78303747534517, 398.3200663349917, 413.76262626262627, 1107.6666666666667, 1322.8187500000001, 489.3653846153846, 1210.138888888889, 756.5100401606425, 851.4636752136753, 615.2629629629629, 576.3255813953489, 954.0266666666666, 774.7080459770115, 654.6723163841808, 602.8000000000001, 1155.3501199040768, 765.8132530120482, 843.3497942386831, 813.1194968553459, 669.3020257826887, 583.8333333333334, 472.10606060606057, 476.4099616858237, 484.00995024875624, 496.57347670250897, 544.3650793650794, 608.7642857142857, 536.7301587301587, 560.3097643097643, 960.5810397553518, 1195.054487179487, 1229.7222222222222, 1219.1134259259259, 1214.5116279069769, 1238.2881944444446, 1243.7916666666667, 1248.2633333333333, 1212.0787878787878, 1424.3713080168775, 1148.7333333333333, 1179.5714285714287, 1263.535519125683, 1175.8916666666667, 1155.890410958904, 1186.5, 1266.0666666666666, 1820.2222222222224, 436.48022598870057, 511.91515151515154, 1141.2753623188405, 1127.4545454545455, 1133.5438596491229, 983.5833333333334, 1128.910569105691, 835.3333333333334, 482.3888888888889, 480.8666666666666, 315.3333333333333, 314.1929824561403, 316.90476190476187, 315.6666666666667, 325.42857142857144, 595.4285714285714, 504.52592592592595, 499.8541666666667, 446, 442.6041666666667, 424.63917525773195, 479.5819209039548, 416.1395348837209, 428.8897849462366, 428.29783037475346, 407.93175853018374, 249.36458333333334, 290.58947368421053, 281.51129943502826, 263.89166666666665, 268.0644257703081, 243.45791245791247, 235.16747967479674, 229.08024691358025, 230.33132530120483, 250.33333333333334, 255.04644808743168, 228.95726495726498, 223.24780701754386, 589.2697201017812, 241.55882352941174, 249.42574257425744, 313.37142857142857, 250.12266666666667, 455.3410852713178, 242.47126436781608, 236.90650406504065, 229.95185185185187, 246.484496124031, 272.625, 243.47679324894514, 245.19634703196346, 246.07526881720432, 635.640579710145, 763.5952380952381, 402.50241545893715, 389.1963470319635, 409.6736111111111, 397.4592592592592, 402.95726495726495, 455.905303030303, 428.074433656958, 387.72463768115944, 384.1766666666667, 387.1515151515152, 406.52272727272725, 394.5842696629213, 399.25964912280705, 411.2962962962963, 425.0235294117647, 411.8513513513513, 402.61302681992333, 413.8728070175439, 386.34757834757835, 379.43162393162396, 368.99719887955183, 390.4834834834835, 407.94080996884736, 374.05654761904765, 339.63095238095235, 327.2761904761905, 332.94545454545454, 2018.857638888889, 2408.5096153846152, 2397.9449275362317, 2502.440366972477, 2529.5650793650793, 2559.563063063063, 3156.544342507645, 3412.062015503876, 3368.8695652173915, 3329.7083333333335, 3316.0764525993886, 3265.343642611684, 3234.7391304347825, 2818.0095238095237, 2271.15873015873, 2235.5942028985505, 2174.4840579710144, 2220.5178571428573, 1873.5925925925924, 270.77142857142854, 269.86309523809524, 288.8262108262108, 292.6106442577031, 270.27138643067843, 271.9040404040404, 256.88235294117646, 254.43859649122805, 260.5050505050505, 269.19444444444446, 274.914373088685, 292.07172995780587, 294.1413333333333, 250.0737704918033, 225.31831831831832, 212.3740740740741],
        "evcs0/ChargePower": [null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, null, 0, 4104.142857142857, 5829.969696969697, 5806.212121212121, 6195.333333333333, 5777.333333333333, 5786.25, 5789.727272727273, 5789.571428571428, 5783.0526315789475, 5772.657142857143, 4864.8421052631575, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 0, null, null, 0, 0, null, 0, 0, null, 0, 0, null, 0, 0, 0, 0, 0, 0, null, 0, null, null, 0, 0, null, null, 0, 0, 0, null, 0, null, null, 0, 0, null, 0, null, null, null, null, 0, null, 0, 0, null, null, null, null, null, 0, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0, 0, null, 0, null, 0, 0, 0, 0, 0, 0, null, null, 0, 0, null, 0, 0, 0, null, null, 0, 0, null, 0, 0, null, null, null, 0, null, null, null, null, null, null, 0, 0, 0, null, 0, 0, 0, 0, null, 0, null, 0, null, 0, 0, 0, null, 0, 0, 0, 0, 0, 5213.0952380952385, 5787.580645161291, 5789.484848484848, 5790.818181818182, 5807.34375, 5820.136363636364, 5798.862068965517, 5809.041666666667, 5805.5625, 5794.346153846154, 5798, 5740.214285714285, 5727.242424242424, 5742.542857142857, 5753.424242424242, 5752.4, 5731.966666666666, 5734.323529411765, 5335.586206896552, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null],
        "meter0/ActivePower": [124.28571428571429, 0, null, 0, 173.33333333333334, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 110, 113.33333333333333, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 0, 0, 0, 0, 0, 0, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 113.33333333333333, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, null, 113.33333333333333, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 130, 0, 0, 0, 0, 0, null, null, null, null, 0, 0, 0, 0, 0, null, 0, null, 140, null, null, null, 2126.875, 175, 176, null, 180, 180, 185, 180, null, 185, 190, 180, 180, 176.25, 175.83333333333334, 170, 175, 170, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "heat0/ActivePower": [124, 0, null, 0, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 110, 113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 0, 0, 0, 0, 0, 0, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 113, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, null, 113, 0, 0, null, 0, 0, 0, 0, 0, 0, 0, null, 0, 0, 0, 0, 0, 0, 130, 0, 0, 0, 0, 0, null, null, null, null, 0, 0, 0, 0, 0, null, 0, null, 140, null, null, null, 2127, 175, 176, null, 180, 180, 185, 180, null, 185, 190, 180, 180, 176, 176, 170, 175, 170, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
      },
      timestamps: ["2023-07-02T22:00:00Z", "2023-07-02T22:05:00Z", "2023-07-02T22:10:00Z", "2023-07-02T22:15:00Z", "2023-07-02T22:20:00Z", "2023-07-02T22:25:00Z", "2023-07-02T22:30:00Z", "2023-07-02T22:35:00Z", "2023-07-02T22:40:00Z", "2023-07-02T22:45:00Z", "2023-07-02T22:50:00Z", "2023-07-02T22:55:00Z", "2023-07-02T23:00:00Z", "2023-07-02T23:05:00Z", "2023-07-02T23:10:00Z", "2023-07-02T23:15:00Z", "2023-07-02T23:20:00Z", "2023-07-02T23:25:00Z", "2023-07-02T23:30:00Z", "2023-07-02T23:35:00Z", "2023-07-02T23:40:00Z", "2023-07-02T23:45:00Z", "2023-07-02T23:50:00Z", "2023-07-02T23:55:00Z", "2023-07-03T00:00:00Z", "2023-07-03T00:05:00Z", "2023-07-03T00:10:00Z", "2023-07-03T00:15:00Z", "2023-07-03T00:20:00Z", "2023-07-03T00:25:00Z", "2023-07-03T00:30:00Z", "2023-07-03T00:35:00Z", "2023-07-03T00:40:00Z", "2023-07-03T00:45:00Z", "2023-07-03T00:50:00Z", "2023-07-03T00:55:00Z", "2023-07-03T01:00:00Z", "2023-07-03T01:05:00Z", "2023-07-03T01:10:00Z", "2023-07-03T01:15:00Z", "2023-07-03T01:20:00Z", "2023-07-03T01:25:00Z", "2023-07-03T01:30:00Z", "2023-07-03T01:35:00Z", "2023-07-03T01:40:00Z", "2023-07-03T01:45:00Z", "2023-07-03T01:50:00Z", "2023-07-03T01:55:00Z", "2023-07-03T02:00:00Z", "2023-07-03T02:05:00Z", "2023-07-03T02:10:00Z", "2023-07-03T02:15:00Z", "2023-07-03T02:20:00Z", "2023-07-03T02:25:00Z", "2023-07-03T02:30:00Z", "2023-07-03T02:35:00Z", "2023-07-03T02:40:00Z", "2023-07-03T02:45:00Z", "2023-07-03T02:50:00Z", "2023-07-03T02:55:00Z", "2023-07-03T03:00:00Z", "2023-07-03T03:05:00Z", "2023-07-03T03:10:00Z", "2023-07-03T03:15:00Z", "2023-07-03T03:20:00Z", "2023-07-03T03:25:00Z", "2023-07-03T03:30:00Z", "2023-07-03T03:35:00Z", "2023-07-03T03:40:00Z", "2023-07-03T03:45:00Z", "2023-07-03T03:50:00Z", "2023-07-03T03:55:00Z", "2023-07-03T04:00:00Z", "2023-07-03T04:05:00Z", "2023-07-03T04:10:00Z", "2023-07-03T04:15:00Z", "2023-07-03T04:20:00Z", "2023-07-03T04:25:00Z", "2023-07-03T04:30:00Z", "2023-07-03T04:35:00Z", "2023-07-03T04:40:00Z", "2023-07-03T04:45:00Z", "2023-07-03T04:50:00Z", "2023-07-03T04:55:00Z", "2023-07-03T05:00:00Z", "2023-07-03T05:05:00Z", "2023-07-03T05:10:00Z", "2023-07-03T05:15:00Z", "2023-07-03T05:20:00Z", "2023-07-03T05:25:00Z", "2023-07-03T05:30:00Z", "2023-07-03T05:35:00Z", "2023-07-03T05:40:00Z", "2023-07-03T05:45:00Z", "2023-07-03T05:50:00Z", "2023-07-03T05:55:00Z", "2023-07-03T06:00:00Z", "2023-07-03T06:05:00Z", "2023-07-03T06:10:00Z", "2023-07-03T06:15:00Z", "2023-07-03T06:20:00Z", "2023-07-03T06:25:00Z", "2023-07-03T06:30:00Z", "2023-07-03T06:35:00Z", "2023-07-03T06:40:00Z", "2023-07-03T06:45:00Z", "2023-07-03T06:50:00Z", "2023-07-03T06:55:00Z", "2023-07-03T07:00:00Z", "2023-07-03T07:05:00Z", "2023-07-03T07:10:00Z", "2023-07-03T07:15:00Z", "2023-07-03T07:20:00Z", "2023-07-03T07:25:00Z", "2023-07-03T07:30:00Z", "2023-07-03T07:35:00Z", "2023-07-03T07:40:00Z", "2023-07-03T07:45:00Z", "2023-07-03T07:50:00Z", "2023-07-03T07:55:00Z", "2023-07-03T08:00:00Z", "2023-07-03T08:05:00Z", "2023-07-03T08:10:00Z", "2023-07-03T08:15:00Z", "2023-07-03T08:20:00Z", "2023-07-03T08:25:00Z", "2023-07-03T08:30:00Z", "2023-07-03T08:35:00Z", "2023-07-03T08:40:00Z", "2023-07-03T08:45:00Z", "2023-07-03T08:50:00Z", "2023-07-03T08:55:00Z", "2023-07-03T09:00:00Z", "2023-07-03T09:05:00Z", "2023-07-03T09:10:00Z", "2023-07-03T09:15:00Z", "2023-07-03T09:20:00Z", "2023-07-03T09:25:00Z", "2023-07-03T09:30:00Z", "2023-07-03T09:35:00Z", "2023-07-03T09:40:00Z", "2023-07-03T09:45:00Z", "2023-07-03T09:50:00Z", "2023-07-03T09:55:00Z", "2023-07-03T10:00:00Z", "2023-07-03T10:05:00Z", "2023-07-03T10:10:00Z", "2023-07-03T10:15:00Z", "2023-07-03T10:20:00Z", "2023-07-03T10:25:00Z", "2023-07-03T10:30:00Z", "2023-07-03T10:35:00Z", "2023-07-03T10:40:00Z", "2023-07-03T10:45:00Z", "2023-07-03T10:50:00Z", "2023-07-03T10:55:00Z", "2023-07-03T11:00:00Z", "2023-07-03T11:05:00Z", "2023-07-03T11:10:00Z", "2023-07-03T11:15:00Z", "2023-07-03T11:20:00Z", "2023-07-03T11:25:00Z", "2023-07-03T11:30:00Z", "2023-07-03T11:35:00Z", "2023-07-03T11:40:00Z", "2023-07-03T11:45:00Z", "2023-07-03T11:50:00Z", "2023-07-03T11:55:00Z", "2023-07-03T12:00:00Z", "2023-07-03T12:05:00Z", "2023-07-03T12:10:00Z", "2023-07-03T12:15:00Z", "2023-07-03T12:20:00Z", "2023-07-03T12:25:00Z", "2023-07-03T12:30:00Z", "2023-07-03T12:35:00Z", "2023-07-03T12:40:00Z", "2023-07-03T12:45:00Z", "2023-07-03T12:50:00Z", "2023-07-03T12:55:00Z", "2023-07-03T13:00:00Z", "2023-07-03T13:05:00Z", "2023-07-03T13:10:00Z", "2023-07-03T13:15:00Z", "2023-07-03T13:20:00Z", "2023-07-03T13:25:00Z", "2023-07-03T13:30:00Z", "2023-07-03T13:35:00Z", "2023-07-03T13:40:00Z", "2023-07-03T13:45:00Z", "2023-07-03T13:50:00Z", "2023-07-03T13:55:00Z", "2023-07-03T14:00:00Z", "2023-07-03T14:05:00Z", "2023-07-03T14:10:00Z", "2023-07-03T14:15:00Z", "2023-07-03T14:20:00Z", "2023-07-03T14:25:00Z", "2023-07-03T14:30:00Z", "2023-07-03T14:35:00Z", "2023-07-03T14:40:00Z", "2023-07-03T14:45:00Z", "2023-07-03T14:50:00Z", "2023-07-03T14:55:00Z", "2023-07-03T15:00:00Z", "2023-07-03T15:05:00Z", "2023-07-03T15:10:00Z", "2023-07-03T15:15:00Z", "2023-07-03T15:20:00Z", "2023-07-03T15:25:00Z", "2023-07-03T15:30:00Z", "2023-07-03T15:35:00Z", "2023-07-03T15:40:00Z", "2023-07-03T15:45:00Z", "2023-07-03T15:50:00Z", "2023-07-03T15:55:00Z", "2023-07-03T16:00:00Z", "2023-07-03T16:05:00Z", "2023-07-03T16:10:00Z", "2023-07-03T16:15:00Z", "2023-07-03T16:20:00Z", "2023-07-03T16:25:00Z", "2023-07-03T16:30:00Z", "2023-07-03T16:35:00Z", "2023-07-03T16:40:00Z", "2023-07-03T16:45:00Z", "2023-07-03T16:50:00Z", "2023-07-03T16:55:00Z", "2023-07-03T17:00:00Z", "2023-07-03T17:05:00Z", "2023-07-03T17:10:00Z", "2023-07-03T17:15:00Z", "2023-07-03T17:20:00Z", "2023-07-03T17:25:00Z", "2023-07-03T17:30:00Z", "2023-07-03T17:35:00Z", "2023-07-03T17:40:00Z", "2023-07-03T17:45:00Z", "2023-07-03T17:50:00Z", "2023-07-03T17:55:00Z", "2023-07-03T18:00:00Z", "2023-07-03T18:05:00Z", "2023-07-03T18:10:00Z", "2023-07-03T18:15:00Z", "2023-07-03T18:20:00Z", "2023-07-03T18:25:00Z", "2023-07-03T18:30:00Z", "2023-07-03T18:35:00Z", "2023-07-03T18:40:00Z", "2023-07-03T18:45:00Z", "2023-07-03T18:50:00Z", "2023-07-03T18:55:00Z", "2023-07-03T19:00:00Z", "2023-07-03T19:05:00Z", "2023-07-03T19:10:00Z", "2023-07-03T19:15:00Z", "2023-07-03T19:20:00Z", "2023-07-03T19:25:00Z", "2023-07-03T19:30:00Z", "2023-07-03T19:35:00Z", "2023-07-03T19:40:00Z", "2023-07-03T19:45:00Z", "2023-07-03T19:50:00Z", "2023-07-03T19:55:00Z", "2023-07-03T20:00:00Z", "2023-07-03T20:05:00Z", "2023-07-03T20:10:00Z", "2023-07-03T20:15:00Z", "2023-07-03T20:20:00Z", "2023-07-03T20:25:00Z", "2023-07-03T20:30:00Z", "2023-07-03T20:35:00Z", "2023-07-03T20:40:00Z", "2023-07-03T20:45:00Z", "2023-07-03T20:50:00Z", "2023-07-03T20:55:00Z", "2023-07-03T21:00:00Z", "2023-07-03T21:05:00Z", "2023-07-03T21:10:00Z", "2023-07-03T21:15:00Z", "2023-07-03T21:20:00Z", "2023-07-03T21:25:00Z", "2023-07-03T21:30:00Z", "2023-07-03T21:35:00Z", "2023-07-03T21:40:00Z", "2023-07-03T21:45:00Z", "2023-07-03T21:50:00Z", "2023-07-03T21:55:00Z"],
    }),
  });

  /**
   * up to 164 datapoints(1 hour values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const WEEK: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ConsumptionActiveEnergy": 354079,
        "evcs0/ActiveConsumptionEnergy": 157027,
        "meter0/ActiveProductionEnergy": 100000,
        "heat0/ActiveProductionEnergy": 21649,
      },
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "_sum/ConsumptionActivePower": [663.9876181166504, 937.5188284518829, 761.5839462743844, 599.7653758542141, 989.6435035552682, 666.2890016920473, 1054.177495462795, 1042.9070871481858, 661.1515631183221, 734.2340980187696, 845.5174603174603, 969.5830886670582, 591.8473777253978, 1960.0339449541284, 919.7469512195122, 1232.6632911392405, 562.9648946840522, 786.2627471383975, 931.422932330827, 837.381753312946, 1112.3010184835912, 902.5108194395176, 807.5094273743017, 988.311229946524, 614.0189035916824, 868.6555377207062, 906.9389035667107, 673.3970826580227, 827.6491228070175, 851.9108776685869, 852.9105374823197, 867.4681647940075, 1303.01722614841, 950.6813929313929, 1124.7157794676807, 908.7814790139906, 1554.5020215633424, 4743.944086021505, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "evcs0/ChargePower": [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4586.923076923077, 4846.2192982456145, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null],
        "meter0/ActivePower": [27.956773446545736, 27.93238434163701, 28.003065134099618, 27.952205882352942, 27.998854961832063, 28.116988416988416, 27.987117552334944, 28.404306220095695, 22.10508757297748, 24.58289572393098, 25.521831735889243, 33.94027565084227, 66.40016920473774, 74.85995085995086, 56.30216802168022, 40.562390158172235, 42.72727272727273, 41.85823488533704, 29.56647864625302, 26.93582887700535, 29.227223427331886, 31.081920903954803, 29.50079575596817, 29.29895178197065, 27.74064837905237, 27.340638930163447, 27.272103350827614, 27.199391171993913, 26.97577592732778, 26.88116057233704, 27.04352806414662, 26.709154929577466, 24.765209940017137, 20.726594301221166, 24.283930058284763, 27.086363636363636, 47.70666666666666, 53.07067510548523, 52.73466476462197, 54.75776892430279, 50.23135033050047, 41.280141843971634, 31.509341199606688, 26.471978392977718, 31.050412465627865, 29.384710234278668, 27.95327604726101, 28.357904496986556, 25.56408588158751, null, 26.944094488188977, 27.036082474226806, 26.367164179104478, 25.185562632696392, 26.994444444444444, 25.911782850092536, 13.431970713849909, 24.309846431797652, 25.234712230215827, 26.126705653021443, 60.64339781328848, 39.96433289299868, 37.667578659370726, 50.66542750929368, 41.89218523878437, 29.88109495295124, 26.93968253968254, 25.741935483870968, 28.64, 31.331460674157302, 30.017262638717632, 28.636402753872634, 28.408956692913385, 28.14567233384853, 28.25509028044564, 28.12612966601179, 28.175675675675677, 27.409126063418405, 27.54943984413054, 27.246363209760677, 22.96663244353183, 21.65732959850607, 22.306306306306308, 25.892307692307693, 51.8, 52.903225806451616, 59.02597402597402, 39.35110294117647, 33.87375113533152, 29.98160073597056, 26.481973434535103, 29.473684210526315, 28.432854465958776, 29.162214983713355, 28.663861386138613, 28.23558082859464, 28.460033305578683, 29.076231430805315, 28.803389830508475, 28.62062404870624, 28.578023655093475, 28.370570107858242, 27.46546431312356, 27.873293515358363, 25.733505154639175, 26.357802874743328, 27.692853246044734, 24.205128205128204, null, 26.746031746031747, 23.178571428571427, 26.16861826697892, 28.333646616541355, 26.758232235701907, 23.993934142114384, 24.71902131018153, 28.23051948051948, 28.74572127139364, 28.485825458588103, 28.22232263895165, 28.392755392755394, 28.338354151359294, 27.164207340143776, 26.949324324324323, 26.942610652663166, 27.8092203898051, 27.980593607305938, 28.26596758817922, 29.656794425087107, 25.145056246299585, 25.203214100570243, 28.82728749323227, 32.22576966932725, 31.200444197667963, 30.594259988745076, 43.34990059642147, 46.15876288659794, 33.40802469135802, 27.489320388349515, 25.818808777429467, 27.95967741935484, 28.96995139195758, 27.5499557913351, 28.341370558375633, 28.25076053889613, 27.812838360402164, 28.10333080999243, 27.840314136125656, 27.800384615384615, 27.97958397534669, 27.235769230769233, 26.924960505529224, 29.03847980997625, 27.93128390596745, 34.10349373764008, 32.7387339055794, 29.509929906542055, 37.00855745721272, 32.240085744908896, 27.701363636363638, 30.787037037037038, 25.786028602860284, 29.997148966500358, 32.89406099518459, 35.328729281767956, 25.65564738292011, 27.46238030095759, 28.27226647356988],
        "heat0/ActiveProductionEnergy": [16, 14, 16, 15, 16, 15, 15, 15, 16, 17, 18, 14, 16, 17, 16, 15, 14, 17, 15, 16, 17, 16, 15, 16, 14, 15, 14, 16, 14, null, null],
      },
      timestamps: ["2023-06-25T22:00:00Z", "2023-06-25T23:00:00Z", "2023-06-26T00:00:00Z", "2023-06-26T01:00:00Z", "2023-06-26T02:00:00Z", "2023-06-26T03:00:00Z", "2023-06-26T04:00:00Z", "2023-06-26T05:00:00Z", "2023-06-26T06:00:00Z", "2023-06-26T07:00:00Z", "2023-06-26T08:00:00Z", "2023-06-26T09:00:00Z", "2023-06-26T10:00:00Z", "2023-06-26T11:00:00Z", "2023-06-26T12:00:00Z", "2023-06-26T13:00:00Z", "2023-06-26T14:00:00Z", "2023-06-26T15:00:00Z", "2023-06-26T16:00:00Z", "2023-06-26T17:00:00Z", "2023-06-26T18:00:00Z", "2023-06-26T19:00:00Z", "2023-06-26T20:00:00Z", "2023-06-26T21:00:00Z", "2023-06-26T22:00:00Z", "2023-06-26T23:00:00Z", "2023-06-27T00:00:00Z", "2023-06-27T01:00:00Z", "2023-06-27T02:00:00Z", "2023-06-27T03:00:00Z", "2023-06-27T04:00:00Z", "2023-06-27T05:00:00Z", "2023-06-27T06:00:00Z", "2023-06-27T07:00:00Z", "2023-06-27T08:00:00Z", "2023-06-27T09:00:00Z", "2023-06-27T10:00:00Z", "2023-06-27T11:00:00Z", "2023-06-27T12:00:00Z", "2023-06-27T13:00:00Z", "2023-06-27T14:00:00Z", "2023-06-27T15:00:00Z", "2023-06-27T16:00:00Z", "2023-06-27T17:00:00Z", "2023-06-27T18:00:00Z", "2023-06-27T19:00:00Z", "2023-06-27T20:00:00Z", "2023-06-27T21:00:00Z", "2023-06-27T22:00:00Z", "2023-06-27T23:00:00Z", "2023-06-28T00:00:00Z", "2023-06-28T01:00:00Z", "2023-06-28T02:00:00Z", "2023-06-28T03:00:00Z", "2023-06-28T04:00:00Z", "2023-06-28T05:00:00Z", "2023-06-28T06:00:00Z", "2023-06-28T07:00:00Z", "2023-06-28T08:00:00Z", "2023-06-28T09:00:00Z", "2023-06-28T10:00:00Z", "2023-06-28T11:00:00Z", "2023-06-28T12:00:00Z", "2023-06-28T13:00:00Z", "2023-06-28T14:00:00Z", "2023-06-28T15:00:00Z", "2023-06-28T16:00:00Z", "2023-06-28T17:00:00Z", "2023-06-28T18:00:00Z", "2023-06-28T19:00:00Z", "2023-06-28T20:00:00Z", "2023-06-28T21:00:00Z", "2023-06-28T22:00:00Z", "2023-06-28T23:00:00Z", "2023-06-29T00:00:00Z", "2023-06-29T01:00:00Z", "2023-06-29T02:00:00Z", "2023-06-29T03:00:00Z", "2023-06-29T04:00:00Z", "2023-06-29T05:00:00Z", "2023-06-29T06:00:00Z", "2023-06-29T07:00:00Z", "2023-06-29T08:00:00Z", "2023-06-29T09:00:00Z", "2023-06-29T10:00:00Z", "2023-06-29T11:00:00Z", "2023-06-29T12:00:00Z", "2023-06-29T13:00:00Z", "2023-06-29T14:00:00Z", "2023-06-29T15:00:00Z", "2023-06-29T16:00:00Z", "2023-06-29T17:00:00Z", "2023-06-29T18:00:00Z", "2023-06-29T19:00:00Z", "2023-06-29T20:00:00Z", "2023-06-29T21:00:00Z", "2023-06-29T22:00:00Z", "2023-06-29T23:00:00Z", "2023-06-30T00:00:00Z", "2023-06-30T01:00:00Z", "2023-06-30T02:00:00Z", "2023-06-30T03:00:00Z", "2023-06-30T04:00:00Z", "2023-06-30T05:00:00Z", "2023-06-30T06:00:00Z", "2023-06-30T07:00:00Z", "2023-06-30T08:00:00Z", "2023-06-30T09:00:00Z", "2023-06-30T10:00:00Z", "2023-06-30T11:00:00Z", "2023-06-30T12:00:00Z", "2023-06-30T13:00:00Z", "2023-06-30T14:00:00Z", "2023-06-30T15:00:00Z", "2023-06-30T16:00:00Z", "2023-06-30T17:00:00Z", "2023-06-30T18:00:00Z", "2023-06-30T19:00:00Z", "2023-06-30T20:00:00Z", "2023-06-30T21:00:00Z", "2023-06-30T22:00:00Z", "2023-06-30T23:00:00Z", "2023-07-01T00:00:00Z", "2023-07-01T01:00:00Z", "2023-07-01T02:00:00Z", "2023-07-01T03:00:00Z", "2023-07-01T04:00:00Z", "2023-07-01T05:00:00Z", "2023-07-01T06:00:00Z", "2023-07-01T07:00:00Z", "2023-07-01T08:00:00Z", "2023-07-01T09:00:00Z", "2023-07-01T10:00:00Z", "2023-07-01T11:00:00Z", "2023-07-01T12:00:00Z", "2023-07-01T13:00:00Z", "2023-07-01T14:00:00Z", "2023-07-01T15:00:00Z", "2023-07-01T16:00:00Z", "2023-07-01T17:00:00Z", "2023-07-01T18:00:00Z", "2023-07-01T19:00:00Z", "2023-07-01T20:00:00Z", "2023-07-01T21:00:00Z", "2023-07-01T22:00:00Z", "2023-07-01T23:00:00Z", "2023-07-02T00:00:00Z", "2023-07-02T01:00:00Z", "2023-07-02T02:00:00Z", "2023-07-02T03:00:00Z", "2023-07-02T04:00:00Z", "2023-07-02T05:00:00Z", "2023-07-02T06:00:00Z", "2023-07-02T07:00:00Z", "2023-07-02T08:00:00Z", "2023-07-02T09:00:00Z", "2023-07-02T10:00:00Z", "2023-07-02T11:00:00Z", "2023-07-02T12:00:00Z", "2023-07-02T13:00:00Z", "2023-07-02T14:00:00Z", "2023-07-02T15:00:00Z", "2023-07-02T16:00:00Z", "2023-07-02T17:00:00Z", "2023-07-02T18:00:00Z", "2023-07-02T19:00:00Z", "2023-07-02T20:00:00Z", "2023-07-02T21:00:00Z"],
    }),
  };

  /**
  * up to 31 datapoints(1 day values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const MONTH: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ConsumptionActiveEnergy": 1033427,
        "evcs0/ActiveConsumptionEnergy": 328451,
        "meter0/ActiveProductionEnergy": 21649,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ConsumptionActiveEnergy": [1784.3478512581187, 955.1978135997077, 1604.9176251387696, 1821.5474663613152, 1204.011627189301, 1037.408900359932, 1287.891020875591, 1183.057735422114, 1027.8784377276404, 1412.783196754379, 737.2379614126091, 730.6143394985477, 1727.4568452231197, 2045.4827463867603, 1289.9867373938441, 1866.5731598778827, 896.448259060122, 1271.0485678635469, 1489.7323302960576, 1367.9696489029907, 2375.6092366846033, 2368.729102836224, 2686.60326649514, 1597.0390753045413, 972.6650191463931, 1774.233690168573, 2953.838257099637, 917.3087792235759, 1172.9800154902882, null, null],
          "evcs0/ActiveConsumptionEnergy": [598.058461158158, 0, 607.3861225965935, 891.3491768679577, 269.6236843407865, 0, 306.41009901340226, 220.51407209843148, 50.15525733301707, 356.42246970726825, 0, 0, 880.0942036863182, 977.4033026217928, 210.23831546417276, 787.0712558876392, 0, 165.50743075023163, 513.2605942604259, 149.06825174512016, 883.6100586172083, 1203.117101530366, 1467.2314708234808, 553.6230686820822, 0, 714.8486366912176, 1836.7765179313803, 0, 300.374916784946, null, null],
          "meter0/ActiveProductionEnergy": [15.53700680772126, 13.97856617670663, 16.22420643945345, 15.425155003970989, 16.41557086346929, 15.280936198647838, 15.028196655704793, 15.146427851947054, 15.567356482244767, 17.404197969735606, 17.635152684968116, 14.140394156739468, 16.107488806188936, 16.75001277671301, 15.512752420609466, 14.951999780788457, 13.733457057782298, 16.868671206682027, 14.770978996449593, 16.47697124898351, 16.772182319685665, 16.288562161254703, 15.417362341926745, 15.892028990939403, 13.811584043067414, 14.81782772305683, 14.165639305307824, 16.223347257543285, 14.495672387672808, null, null],
        },
        timestamps: ["2023-05-31T22:00:00Z", "2023-06-01T22:00:00Z", "2023-06-02T22:00:00Z", "2023-06-03T22:00:00Z", "2023-06-04T22:00:00Z", "2023-06-05T22:00:00Z", "2023-06-06T22:00:00Z", "2023-06-07T22:00:00Z", "2023-06-08T22:00:00Z", "2023-06-09T22:00:00Z", "2023-06-10T22:00:00Z", "2023-06-11T22:00:00Z", "2023-06-12T22:00:00Z", "2023-06-13T22:00:00Z", "2023-06-14T22:00:00Z", "2023-06-15T22:00:00Z", "2023-06-16T22:00:00Z", "2023-06-17T22:00:00Z", "2023-06-18T22:00:00Z", "2023-06-19T22:00:00Z", "2023-06-20T22:00:00Z", "2023-06-21T22:00:00Z", "2023-06-22T22:00:00Z", "2023-06-23T22:00:00Z", "2023-06-24T22:00:00Z", "2023-06-25T22:00:00Z", "2023-06-26T22:00:00Z", "2023-06-27T22:00:00Z", "2023-06-28T22:00:00Z", "2023-06-29T22:00:00Z"],
      }),
  };

  /**
  * up to 12 datapoints(1 month values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const YEAR: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/ConsumptionActiveEnergy": 14863655,
        "_sum/ConsumptionActiveEnergyL1": 4954551,
        "_sum/ConsumptionActiveEnergyL2": 4954551,
        "_sum/ConsumptionActiveEnergyL3": 4954551,
        "evcs0/ActiveConsumptionEnergy": 2071139,
        "meter0/ActiveProductionEnergy": 1908650,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ConsumptionActiveEnergy": [1682941, 1834729, 1805222, 1934144, 1757577, 1511352, 2306988, 2029933, 0, 0, 0, 0],
          "_sum/ConsumptionActiveEnergyL1": [560980.3333333334, 611576.3333333334, 601740.6666666666, 644714.6666666666, 585859, 503784, 768996, 676644.3333333334, 0, 0, 0, 0],
          "_sum/ConsumptionActiveEnergyL2": [560980.3333333334, 611576.3333333334, 601740.6666666666, 644714.6666666666, 585859, 503784, 768996, 676644.3333333334, 0, 0, 0, 0],
          "_sum/ConsumptionActiveEnergyL3": [560980.3333333334, 611576.3333333334, 601740.6666666666, 644714.6666666666, 585859, 503784, 768996, 676644.3333333334, 0, 0, 0, 0],
          "evcs0/ActiveConsumptionEnergy": [69104, 131703, 25773, 51085, 169943, 332522, 748189, 540740, 0, 0, 0, 0],
          "meter0/ActiveProductionEnergy": [338070, 312380, 298930, 317700, 200210, 151160, 145880, 144280, 0, 0, 0, 0],
        },
        timestamps: ["2022-12-31T23:00:00Z", "2023-01-31T23:00:00Z", "2023-02-28T23:00:00Z", "2023-03-31T22:00:00Z", "2023-04-30T22:00:00Z", "2023-05-31T22:00:00Z", "2023-06-30T22:00:00Z", "2023-07-31T22:00:00Z", "2023-08-31T22:00:00Z", "2023-09-30T22:00:00Z", "2023-10-31T23:00:00Z", "2023-11-30T23:00:00Z"],
      }),
  };
}
