import { TimeUnit } from "chart.js";
import { ChartConstants } from "src/app/shared/components/chart/chart.constants";
import { OeTester } from "src/app/shared/components/shared/testing/common";
import { OeChartTester } from "src/app/shared/components/shared/testing/tester";
import { QueryHistoricTimeseriesDataResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesDataResponse";
import { QueryHistoricTimeseriesEnergyPerPeriodResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyPerPeriodResponse";
import { QueryHistoricTimeseriesEnergyResponse } from "src/app/shared/jsonrpc/response/queryHistoricTimeseriesEnergyResponse";

export namespace History {

  export const LINE_CHART_OPTIONS = (period: string, chartType: "line" | "bar", options: { [key: string]: { scale: { min: number, max: number; }, ticks: { stepSize: number; }; }; }): OeChartTester.Dataset.Option => ({
    type: "option",
    options: {
      "responsive": true, "maintainAspectRatio": false, "elements": { "point": { "radius": 0, "hitRadius": 0, "hoverRadius": 0 }, "line": { "stepped": false, "fill": true } }, "datasets": { "bar": {}, "line": {} }, "plugins": { "colors": { "enabled": false }, "legend": { "display": true, "position": "bottom", "labels": { "color": "" } }, "tooltip": { "intersect": false, "mode": "index", "callbacks": {} } }, "scales": {
        "x": { "stacked": true, "offset": false, "type": "time", "ticks": { "source": "auto", "maxTicksLimit": 31 }, "bounds": "ticks", "adapters": { "date": { "locale": { "code": "de", "formatLong": {}, "localize": {}, "match": {}, "options": { "weekStartsOn": 1, "firstWeekContainsDate": 4 } } } }, "time": { "unit": period as TimeUnit, "displayFormats": { "datetime": "yyyy-MM-dd HH:mm:ss", "millisecond": "SSS [ms]", "second": "HH:mm:ss a", "minute": "HH:mm", "hour": "HH:00", "day": "dd", "week": "ll", "month": "MM", "quarter": "[Q]Q - YYYY", "year": "yyyy" } } },
        "left": {
          ...options["right"]?.scale, ...(chartType === "line" ? { stacked: false } : {}), "beginAtZero": true, "max": 100, "min": 0, "type": "linear", "title": { "text": "%", "display": true, "font": { "size": 11 }, "padding": 5 }, "position": "right", "grid": { "display": false },
          "ticks": {
            ...options["right"]?.ticks,
            "color": "",
            "padding": 5,
            "maxTicksLimit": ChartConstants.NUMBER_OF_Y_AXIS_TICKS,
          },
        },
      },
    },
  });
  export const BAR_CHART_OPTIONS = (period: string, chartType: "line" | "bar", options: { [key: string]: { scale: { min?: number, max?: number; }, ticks: { stepSize?: number; }; }; }): OeChartTester.Dataset.Option => ({
    type: "option",
    options: {
      "responsive": true, "maintainAspectRatio": false, "elements": { "point": { "radius": 0, "hitRadius": 0, "hoverRadius": 0 }, "line": { "stepped": false, "fill": true } }, "datasets": { "bar": { "barPercentage": 1 }, "line": {} }, "plugins": { "colors": { "enabled": false }, "legend": { "display": true, "position": "bottom", "labels": { "color": "" } }, "tooltip": { "intersect": false, "mode": "x", "callbacks": {} } }, "scales": {
        "x": { "stacked": true, "offset": true, "type": "time", "ticks": { "source": "auto", "maxTicksLimit": 31 }, "bounds": "ticks", "adapters": { "date": { "locale": { "code": "de", "formatLong": {}, "localize": {}, "match": {}, "options": { "weekStartsOn": 1, "firstWeekContainsDate": 4 } } } }, "time": { "unit": period as TimeUnit, "displayFormats": { "datetime": "yyyy-MM-dd HH:mm:ss", "millisecond": "SSS [ms]", "second": "HH:mm:ss a", "minute": "HH:mm", "hour": "HH:00", "day": "dd", "week": "ll", "month": "MM", "quarter": "[Q]Q - YYYY", "year": "yyyy" } } },
        "left": {
          ...options["left"]?.scale, ...(chartType === "line" ? { stacked: false } : {}), "title": { "text": "kWh", "display": true, "padding": 5, "font": { "size": 11 } }, "position": "left", "grid": { "display": true },
          "ticks": {
            ...options["left"]?.ticks,
            "color": "",
            "padding": 5,
            "maxTicksLimit": ChartConstants.NUMBER_OF_Y_AXIS_TICKS,
          },
        },
      },
    },
  });

  /**
   * up to 288 datapoints (5 min aggregated values) from a
   *
   * {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const DAY: OeTester.Types.Channels = ({
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {},
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "ctrlApiModbusTcp0/Ess0SetActivePowerEquals": [null,
          null,
          null,
          112,
          262,
          392,
          240,
          230,
          229,
          227,
          317,
          224,
          133,
          135,
          133,
          192,
          209,
          90,
          95,
          96,
          164,
          297,
          184,
          182,
          183,
          198,
          333,
          183,
          93,
          97,
          98,
          197,
          266,
          177,
          144,
          140,
          173,
          304,
          305,
          237,
          232,
          227,
          283,
          344,
          135,
          96,
          95,
          null,
          null,
          null,
          null,
          102,
          129,
          140,
          301,
          248,
          267,
          319,
          310,
          452,
          451,
          280,
          234,
          226,
          249,
          390,
          242,
          199,
          179,
          166,
          280,
          239,
          192,
          187,
          187,
          190,
          303,
          146,
          62,
          62,
          64,
          887,
          1119,
          1070,
          1057,
          596,
          138,
          233,
          152,
          209,
          192,
          202,
          308,
          254,
          175,
          122,
          108,
          137,
          216,
          947,
          599,
          203,
          232,
          328,
          299,
          520,
          1213,
          641,
          1030,
          442,
          374,
          1758,
          249,
          260,
          346,
          1879,
          230,
          484,
          1260,
          1317,
          1488,
          1451,
          1892,
          1466,
          1332,
          523,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null,
          null],
      },
      timestamps: [
        "2023-07-02T22:00:00Z",
        "2023-07-02T22:05:00Z",
        "2023-07-02T22:10:00Z",
        "2023-07-02T22:15:00Z",
        "2023-07-02T22:20:00Z",
        "2023-07-02T22:25:00Z",
        "2023-07-02T22:30:00Z",
        "2023-07-02T22:35:00Z",
        "2023-07-02T22:40:00Z",
        "2023-07-02T22:45:00Z",
        "2023-07-02T22:50:00Z",
        "2023-07-02T22:55:00Z",
        "2023-07-02T23:00:00Z",
        "2023-07-02T23:05:00Z",
        "2023-07-02T23:10:00Z",
        "2023-07-02T23:15:00Z",
        "2023-07-02T23:20:00Z",
        "2023-07-02T23:25:00Z",
        "2023-07-02T23:30:00Z",
        "2023-07-02T23:35:00Z",
        "2023-07-02T23:40:00Z",
        "2023-07-02T23:45:00Z",
        "2023-07-02T23:50:00Z",
        "2023-07-02T23:55:00Z",
        "2023-07-03T00:00:00Z",
        "2023-07-03T00:05:00Z",
        "2023-07-03T00:10:00Z",
        "2023-07-03T00:15:00Z",
        "2023-07-03T00:20:00Z",
        "2023-07-03T00:25:00Z",
        "2023-07-03T00:30:00Z",
        "2023-07-03T00:35:00Z",
        "2023-07-03T00:40:00Z",
        "2023-07-03T00:45:00Z",
        "2023-07-03T00:50:00Z",
        "2023-07-03T00:55:00Z",
        "2023-07-03T01:00:00Z",
        "2023-07-03T01:05:00Z",
        "2023-07-03T01:10:00Z",
        "2023-07-03T01:15:00Z",
        "2023-07-03T01:20:00Z",
        "2023-07-03T01:25:00Z",
        "2023-07-03T01:30:00Z",
        "2023-07-03T01:35:00Z",
        "2023-07-03T01:40:00Z",
        "2023-07-03T01:45:00Z",
        "2023-07-03T01:50:00Z",
        "2023-07-03T01:55:00Z",
        "2023-07-03T02:00:00Z",
        "2023-07-03T02:05:00Z",
        "2023-07-03T02:10:00Z",
        "2023-07-03T02:15:00Z",
        "2023-07-03T02:20:00Z",
        "2023-07-03T02:25:00Z",
        "2023-07-03T02:30:00Z",
        "2023-07-03T02:35:00Z",
        "2023-07-03T02:40:00Z",
        "2023-07-03T02:45:00Z",
        "2023-07-03T02:50:00Z",
        "2023-07-03T02:55:00Z",
        "2023-07-03T03:00:00Z",
        "2023-07-03T03:05:00Z",
        "2023-07-03T03:10:00Z",
        "2023-07-03T03:15:00Z",
        "2023-07-03T03:20:00Z",
        "2023-07-03T03:25:00Z",
        "2023-07-03T03:30:00Z",
        "2023-07-03T03:35:00Z",
        "2023-07-03T03:40:00Z",
        "2023-07-03T03:45:00Z",
        "2023-07-03T03:50:00Z",
        "2023-07-03T03:55:00Z",
        "2023-07-03T04:00:00Z",
        "2023-07-03T04:05:00Z",
        "2023-07-03T04:10:00Z",
        "2023-07-03T04:15:00Z",
        "2023-07-03T04:20:00Z",
        "2023-07-03T04:25:00Z",
        "2023-07-03T04:30:00Z",
        "2023-07-03T04:35:00Z",
        "2023-07-03T04:40:00Z",
        "2023-07-03T04:45:00Z",
        "2023-07-03T04:50:00Z",
        "2023-07-03T04:55:00Z",
        "2023-07-03T05:00:00Z",
        "2023-07-03T05:05:00Z",
        "2023-07-03T05:10:00Z",
        "2023-07-03T05:15:00Z",
        "2023-07-03T05:20:00Z",
        "2023-07-03T05:25:00Z",
        "2023-07-03T05:30:00Z",
        "2023-07-03T05:35:00Z",
        "2023-07-03T05:40:00Z",
        "2023-07-03T05:45:00Z",
        "2023-07-03T05:50:00Z",
        "2023-07-03T05:55:00Z",
        "2023-07-03T06:00:00Z",
        "2023-07-03T06:05:00Z",
        "2023-07-03T06:10:00Z",
        "2023-07-03T06:15:00Z",
        "2023-07-03T06:20:00Z",
        "2023-07-03T06:25:00Z",
        "2023-07-03T06:30:00Z",
        "2023-07-03T06:35:00Z",
        "2023-07-03T06:40:00Z",
        "2023-07-03T06:45:00Z",
        "2023-07-03T06:50:00Z",
        "2023-07-03T06:55:00Z",
        "2023-07-03T07:00:00Z",
        "2023-07-03T07:05:00Z",
        "2023-07-03T07:10:00Z",
        "2023-07-03T07:15:00Z",
        "2023-07-03T07:20:00Z",
        "2023-07-03T07:25:00Z",
        "2023-07-03T07:30:00Z",
        "2023-07-03T07:35:00Z",
        "2023-07-03T07:40:00Z",
        "2023-07-03T07:45:00Z",
        "2023-07-03T07:50:00Z",
        "2023-07-03T07:55:00Z",
        "2023-07-03T08:00:00Z",
        "2023-07-03T08:05:00Z",
        "2023-07-03T08:10:00Z",
        "2023-07-03T08:15:00Z",
        "2023-07-03T08:20:00Z",
        "2023-07-03T08:25:00Z",
        "2023-07-03T08:30:00Z",
        "2023-07-03T08:35:00Z",
        "2023-07-03T08:40:00Z",
        "2023-07-03T08:45:00Z",
        "2023-07-03T08:50:00Z",
        "2023-07-03T08:55:00Z",
        "2023-07-03T09:00:00Z",
        "2023-07-03T09:05:00Z",
        "2023-07-03T09:10:00Z",
        "2023-07-03T09:15:00Z",
        "2023-07-03T09:20:00Z",
        "2023-07-03T09:25:00Z",
        "2023-07-03T09:30:00Z",
        "2023-07-03T09:35:00Z",
        "2023-07-03T09:40:00Z",
        "2023-07-03T09:45:00Z",
        "2023-07-03T09:50:00Z",
        "2023-07-03T09:55:00Z",
        "2023-07-03T10:00:00Z",
        "2023-07-03T10:05:00Z",
        "2023-07-03T10:10:00Z",
        "2023-07-03T10:15:00Z",
        "2023-07-03T10:20:00Z",
        "2023-07-03T10:25:00Z",
        "2023-07-03T10:30:00Z",
        "2023-07-03T10:35:00Z",
        "2023-07-03T10:40:00Z",
        "2023-07-03T10:45:00Z",
        "2023-07-03T10:50:00Z",
        "2023-07-03T10:55:00Z",
        "2023-07-03T11:00:00Z",
        "2023-07-03T11:05:00Z",
        "2023-07-03T11:10:00Z",
        "2023-07-03T11:15:00Z",
        "2023-07-03T11:20:00Z",
        "2023-07-03T11:25:00Z",
        "2023-07-03T11:30:00Z",
        "2023-07-03T11:35:00Z",
        "2023-07-03T11:40:00Z",
        "2023-07-03T11:45:00Z",
        "2023-07-03T11:50:00Z",
        "2023-07-03T11:55:00Z",
        "2023-07-03T12:00:00Z",
        "2023-07-03T12:05:00Z",
        "2023-07-03T12:10:00Z",
        "2023-07-03T12:15:00Z",
        "2023-07-03T12:20:00Z",
        "2023-07-03T12:25:00Z",
        "2023-07-03T12:30:00Z",
        "2023-07-03T12:35:00Z",
        "2023-07-03T12:40:00Z",
        "2023-07-03T12:45:00Z",
        "2023-07-03T12:50:00Z",
        "2023-07-03T12:55:00Z",
        "2023-07-03T13:00:00Z",
        "2023-07-03T13:05:00Z",
        "2023-07-03T13:10:00Z",
        "2023-07-03T13:15:00Z",
        "2023-07-03T13:20:00Z",
        "2023-07-03T13:25:00Z",
        "2023-07-03T13:30:00Z",
        "2023-07-03T13:35:00Z",
        "2023-07-03T13:40:00Z",
        "2023-07-03T13:45:00Z",
        "2023-07-03T13:50:00Z",
        "2023-07-03T13:55:00Z",
        "2023-07-03T14:00:00Z",
        "2023-07-03T14:05:00Z",
        "2023-07-03T14:10:00Z",
        "2023-07-03T14:15:00Z",
        "2023-07-03T14:20:00Z",
        "2023-07-03T14:25:00Z",
        "2023-07-03T14:30:00Z",
        "2023-07-03T14:35:00Z",
        "2023-07-03T14:40:00Z",
        "2023-07-03T14:45:00Z",
        "2023-07-03T14:50:00Z",
        "2023-07-03T14:55:00Z",
        "2023-07-03T15:00:00Z",
        "2023-07-03T15:05:00Z",
        "2023-07-03T15:10:00Z",
        "2023-07-03T15:15:00Z",
        "2023-07-03T15:20:00Z",
        "2023-07-03T15:25:00Z",
        "2023-07-03T15:30:00Z",
        "2023-07-03T15:35:00Z",
        "2023-07-03T15:40:00Z",
        "2023-07-03T15:45:00Z",
        "2023-07-03T15:50:00Z",
        "2023-07-03T15:55:00Z",
        "2023-07-03T16:00:00Z",
        "2023-07-03T16:05:00Z",
        "2023-07-03T16:10:00Z",
        "2023-07-03T16:15:00Z",
        "2023-07-03T16:20:00Z",
        "2023-07-03T16:25:00Z",
        "2023-07-03T16:30:00Z",
        "2023-07-03T16:35:00Z",
        "2023-07-03T16:40:00Z",
        "2023-07-03T16:45:00Z",
        "2023-07-03T16:50:00Z",
        "2023-07-03T16:55:00Z",
        "2023-07-03T17:00:00Z",
        "2023-07-03T17:05:00Z",
        "2023-07-03T17:10:00Z",
        "2023-07-03T17:15:00Z",
        "2023-07-03T17:20:00Z",
        "2023-07-03T17:25:00Z",
        "2023-07-03T17:30:00Z",
        "2023-07-03T17:35:00Z",
        "2023-07-03T17:40:00Z",
        "2023-07-03T17:45:00Z",
        "2023-07-03T17:50:00Z",
        "2023-07-03T17:55:00Z",
        "2023-07-03T18:00:00Z",
        "2023-07-03T18:05:00Z",
        "2023-07-03T18:10:00Z",
        "2023-07-03T18:15:00Z",
        "2023-07-03T18:20:00Z",
        "2023-07-03T18:25:00Z",
        "2023-07-03T18:30:00Z",
        "2023-07-03T18:35:00Z",
        "2023-07-03T18:40:00Z",
        "2023-07-03T18:45:00Z",
        "2023-07-03T18:50:00Z",
        "2023-07-03T18:55:00Z",
        "2023-07-03T19:00:00Z",
        "2023-07-03T19:05:00Z",
        "2023-07-03T19:10:00Z",
        "2023-07-03T19:15:00Z",
        "2023-07-03T19:20:00Z",
        "2023-07-03T19:25:00Z",
        "2023-07-03T19:30:00Z",
        "2023-07-03T19:35:00Z",
        "2023-07-03T19:40:00Z",
        "2023-07-03T19:45:00Z",
        "2023-07-03T19:50:00Z",
        "2023-07-03T19:55:00Z",
        "2023-07-03T20:00:00Z",
        "2023-07-03T20:05:00Z",
        "2023-07-03T20:10:00Z",
        "2023-07-03T20:15:00Z",
        "2023-07-03T20:20:00Z",
        "2023-07-03T20:25:00Z",
        "2023-07-03T20:30:00Z",
        "2023-07-03T20:35:00Z",
        "2023-07-03T20:40:00Z",
        "2023-07-03T20:45:00Z",
        "2023-07-03T20:50:00Z",
        "2023-07-03T20:55:00Z",
        "2023-07-03T21:00:00Z",
        "2023-07-03T21:05:00Z",
        "2023-07-03T21:10:00Z",
        "2023-07-03T21:15:00Z",
        "2023-07-03T21:20:00Z",
        "2023-07-03T21:25:00Z",
        "2023-07-03T21:30:00Z",
        "2023-07-03T21:35:00Z",
        "2023-07-03T21:40:00Z",
        "2023-07-03T21:45:00Z",
        "2023-07-03T21:50:00Z",
        "2023-07-03T21:55:00Z",
      ],
    }),
  });

  /**
   * up to 164 datapoints(1 hour values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}
   * */
  export const WEEK: OeTester.Types.Channels = ({
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {},
    }),
    dataChannelWithValues: new QueryHistoricTimeseriesDataResponse("0", {
      data: {
        "ctrlApiModbusTcp0/Ess0SetActivePowerEquals": [
          112,
          262,
          392,
          240,
          230,
          229,
          227,
          317,
          224,
          133,
          135,
          133,
          192,
          209,
          90,
          95,
          96,
          164,
          297,
          184,
          182,
          183,
          198,
          333,
          183,
          93,
          97,
          98,
          197,
          266,
          177,
        ],
      },
      timestamps: [
        "2023-07-01T00:00:00Z",
        "2023-07-02T00:00:00Z",
        "2023-07-03T00:00:00Z",
        "2023-07-04T00:00:00Z",
        "2023-07-05T00:00:00Z",
        "2023-07-06T00:00:00Z",
        "2023-07-07T00:00:00Z",
        "2023-07-08T00:00:00Z",
        "2023-07-09T00:00:00Z",
        "2023-07-10T00:00:00Z",
        "2023-07-11T00:00:00Z",
        "2023-07-12T00:00:00Z",
        "2023-07-13T00:00:00Z",
        "2023-07-14T00:00:00Z",
        "2023-07-15T00:00:00Z",
        "2023-07-16T00:00:00Z",
        "2023-07-17T00:00:00Z",
        "2023-07-18T00:00:00Z",
        "2023-07-19T00:00:00Z",
        "2023-07-20T00:00:00Z",
        "2023-07-21T00:00:00Z",
        "2023-07-22T00:00:00Z",
        "2023-07-23T00:00:00Z",
        "2023-07-24T00:00:00Z",
        "2023-07-25T00:00:00Z",
        "2023-07-26T00:00:00Z",
        "2023-07-27T00:00:00Z",
        "2023-07-28T00:00:00Z",
        "2023-07-29T00:00:00Z",
        "2023-07-30T00:00:00Z",
        "2023-07-31T00:00:00Z",
      ],
    }),
  });


  /**
  * up to 31 datapoints(1 day values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const MONTH: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/GridBuyActiveEnergy": 773000,
        "_sum/ConsumptionActiveEnergy": 9976102,
        "_sum/EssDcChargeEnergy": 3944328,
        "_sum/EssDcDischargeEnergy": 3394430,
        "_sum/GridSellActiveEnergy": 12738000,
        "_sum/ProductionActiveEnergy": 22491000,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ConsumptionActiveEnergy": [320342,
            346615,
            341433,
            333054,
            358458,
            347872,
            289283,
            null,
            556510,
            311366,
            314722,
            355556,
            381671,
            384558,
            366190,
            349336,
            303696,
            288727,
            357434,
            388659,
            402625,
            null,
            713771,
            320238,
            332099,
            null,
            756429,
            384136,
            371322,
            null],
          "_sum/EssDcChargeEnergy": [
            113476,
            162917,
            150189,
            157158,
            149782,
            159833,
            155084,
            null,
            228757,
            128138,
            157539,
            59414,
            156504,
            107339,
            156392,
            158925,
            158578,
            121505,
            120971,
            154566,
            173235,
            null,
            204273,
            156676,
            143745,
            null,
            247673,
            157410,
            104249,
            null,
          ],
          "_sum/EssDcDischargeEnergy": [
            112818,
            126532,
            139622,
            133212,
            169240,
            98705,
            109367,
            null,
            204267,
            118504,
            121261,
            74970,
            144175,
            89897,
            141582,
            111261,
            122274,
            106232,
            139405,
            132225,
            143860,
            null,
            235044,
            63914,
            123844,
            null,
            242102,
            130546,
            59571,
            null,
          ],
          "_sum/GridBuyActiveEnergy": [
            16000,
            6000,
            3000,
            3000,
            5000,
            48000,
            4000,
            null,
            5000,
            26000,
            17000,
            62000,
            8000,
            66000,
            13000,
            21000,
            4000,
            3000,
            18000,
            27000,
            29000,
            null,
            118000,
            85000,
            2000,
            null,
            72000,
            28000,
            84000,
            null,
          ],
          "_sum/GridSellActiveEnergy": [
            603000,
            590000,
            551000,
            572000,
            69000,
            236000,
            626000,
            null,
            1003000,
            261000,
            518000,
            698000,
            640000,
            388000,
            471000,
            373000,
            373000,
            677000,
            286000,
            406000,
            249000,
            null,
            446000,
            369000,
            558000,
            null,
            776000,
            425000,
            574000,
            null,
          ],
          "_sum/ProductionActiveEnergy": [
            908000,
            967000,
            900000,
            926000,
            403000,
            597000,
            957000,
            null,
            1579000,
            556000,
            852000,
            976000,
            1026000,
            724000,
            839000,
            749000,
            709000,
            978000,
            607000,
            790000,
            652000,
            null,
            1011000,
            697000,
            908000,
            null,
            1466000,
            808000,
            906000,
            null,
          ],
        },
        timestamps: [
          "2023-05-31T22:00:00Z",
          "2023-06-01T22:00:00Z",
          "2023-06-02T22:00:00Z",
          "2023-06-03T22:00:00Z",
          "2023-06-04T22:00:00Z",
          "2023-06-05T22:00:00Z",
          "2023-06-06T22:00:00Z",
          "2023-06-07T22:00:00Z",
          "2023-06-08T22:00:00Z",
          "2023-06-09T22:00:00Z",
          "2023-06-10T22:00:00Z",
          "2023-06-11T22:00:00Z",
          "2023-06-12T22:00:00Z",
          "2023-06-13T22:00:00Z",
          "2023-06-14T22:00:00Z",
          "2023-06-15T22:00:00Z",
          "2023-06-16T22:00:00Z",
          "2023-06-17T22:00:00Z",
          "2023-06-18T22:00:00Z",
          "2023-06-19T22:00:00Z",
          "2023-06-20T22:00:00Z",
          "2023-06-21T22:00:00Z",
          "2023-06-22T22:00:00Z",
          "2023-06-23T22:00:00Z",
          "2023-06-24T22:00:00Z",
          "2023-06-25T22:00:00Z",
          "2023-06-26T22:00:00Z",
          "2023-06-27T22:00:00Z",
          "2023-06-28T22:00:00Z",
          "2023-06-29T22:00:00Z",
        ],
      }),
  };

  /**
  * up to 12 datapoints(1 month values) from a {@link Day.energyPerPeriodChannelWithValues} and {@link Day.dataChannelWithValues}*/
  export const YEAR: OeTester.Types.Channels = {
    energyChannelWithValues: new QueryHistoricTimeseriesEnergyResponse("0", {
      data: {
        "_sum/GridBuyActiveEnergy": 23209000,
        "_sum/ConsumptionActiveEnergy": 58573394,
        "_sum/EssDcChargeEnergy": 15296815,
        "_sum/EssDcDischargeEnergy": 12898209,
        "_sum/GridSellActiveEnergy": 30703000,
        "_sum/ProductionActiveEnergy": 68466000,
      },
    }),
    energyPerPeriodChannelWithValues:
      new QueryHistoricTimeseriesEnergyPerPeriodResponse("0", {
        data: {
          "_sum/ConsumptionActiveEnergy": [11634885,
            8207927,
            8976354,
            8311835,
            10341804,
            9976102,
            975807,
            null,
            null,
            null,
            null,
            null],
          "_sum/EssDcChargeEnergy": [
            294606,
            1673109,
            3337772,
            3074303,
            2495947,
            3944328,
            372595,
            null,
            null,
            null,
            null,
            null,
          ],
          "_sum/EssDcDischargeEnergy": [
            208491,
            1339036,
            2911126,
            2555138,
            2123751,
            3394430,
            335402,
            null,
            null,
            null,
            null,
            null,
          ],
          "_sum/GridBuyActiveEnergy": [9829000,
            4812000,
            2915000,
            2036000,
            2712000,
            773000,
            94000,
            null,
            null,
            null,
            null,
            null],
          "_sum/GridSellActiveEnergy": [20000,
            86000,
            677000,
            3657000,
            12839000,
            12738000,
            627000,
            null,
            null,
            null,
            null,
            null],
          "_sum/ProductionActiveEnergy": [1912000,
            3816000,
            7165000,
            10452000,
            20841000,
            22491000,
            1546000,
            null,
            null,
            null,
            null,
            null],
        },
        timestamps: [
          "2022-12-31T23:00:00Z",
          "2023-01-31T23:00:00Z",
          "2023-02-28T23:00:00Z",
          "2023-03-31T22:00:00Z",
          "2023-04-30T22:00:00Z",
          "2023-05-31T22:00:00Z",
          "2023-06-30T22:00:00Z",
          "2023-07-31T22:00:00Z",
          "2023-08-31T22:00:00Z",
          "2023-09-30T22:00:00Z",
          "2023-10-31T23:00:00Z",
          "2023-11-30T23:00:00Z",
        ],
      }),
  };
}
