package io.openems.edge.timeofusetariff.entsoe;

import static io.openems.common.test.TestUtils.createDummyClock;
import static io.openems.edge.timeofusetariff.entsoe.Utils.getDuration;
import static io.openems.edge.timeofusetariff.entsoe.Utils.parseCurrency;
import static io.openems.edge.timeofusetariff.entsoe.Utils.parsePrices;
import static org.junit.Assert.assertEquals;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;

import org.junit.Test;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableTable;

import io.openems.edge.common.currency.Currency;
import io.openems.edge.timeofusetariff.api.TimeOfUsePrices;

public class ParserTest {

	private static String XML = """
			<?xml version="1.0" encoding="UTF-8"?>
			<Publication_MarketDocument xmlns="urn:iec62325.351:tc57wg16:451-3:publicationdocument:7:0">
				<mRID>946edcf0cf33426aa666e1069ececbe7</mRID>
				<revisionNumber>1</revisionNumber>
				<type>A44</type>
				<sender_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</sender_MarketParticipant.mRID>
				<sender_MarketParticipant.marketRole.type>A32</sender_MarketParticipant.marketRole.type>
				<receiver_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</receiver_MarketParticipant.mRID>
				<receiver_MarketParticipant.marketRole.type>A33</receiver_MarketParticipant.marketRole.type>
				<createdDateTime>2023-06-01T12:40:44Z</createdDateTime>
				<period.timeInterval>
					<start>2023-05-31T22:00Z</start>
					<end>2023-06-01T22:00Z</end>
				</period.timeInterval>
				<TimeSeries>
					<mRID>1</mRID>
					<businessType>A62</businessType>
					<in_Domain.mRID codingScheme="A01">10Y1001A1001A82H</in_Domain.mRID>
					<out_Domain.mRID codingScheme="A01">10Y1001A1001A82H</out_Domain.mRID>
					<currency_Unit.name>EUR</currency_Unit.name>
					<price_Measure_Unit.name>MWH</price_Measure_Unit.name>
					<curveType>A01</curveType>
						<Period>
							<timeInterval>
								<start>2023-05-31T22:00Z</start>
								<end>2023-06-01T22:00Z</end>
							</timeInterval>
							<resolution>PT15M</resolution>
								<Point>
									<position>1</position>
									<price.amount>109.93</price.amount>
								</Point>
								<Point>
									<position>2</position>
									<price.amount>85.84</price.amount>
								</Point>
								<Point>
									<position>3</position>
									<price.amount>65.09</price.amount>
								</Point>
								<Point>
									<position>4</position>
									<price.amount>55.07</price.amount>
								</Point>
								<Point>
									<position>5</position>
									<price.amount>90.10</price.amount>
								</Point>
								<Point>
									<position>6</position>
									<price.amount>78.30</price.amount>
								</Point>
								<Point>
									<position>7</position>
									<price.amount>71.20</price.amount>
								</Point>
								<Point>
									<position>8</position>
									<price.amount>60.80</price.amount>
								</Point>
								<Point>
									<position>9</position>
									<price.amount>79.70</price.amount>
								</Point>
								<Point>
									<position>10</position>
									<price.amount>70.60</price.amount>
								</Point>
								<Point>
									<position>11</position>
									<price.amount>75.10</price.amount>
								</Point>
								<Point>
									<position>12</position>
									<price.amount>66.14</price.amount>
								</Point>
								<Point>
									<position>13</position>
									<price.amount>74.00</price.amount>
								</Point>
								<Point>
									<position>14</position>
									<price.amount>70.60</price.amount>
								</Point>
								<Point>
									<position>15</position>
									<price.amount>70.20</price.amount>
								</Point>
								<Point>
									<position>16</position>
									<price.amount>71.34</price.amount>
								</Point>
								<Point>
									<position>17</position>
									<price.amount>52.70</price.amount>
								</Point>
								<Point>
									<position>18</position>
									<price.amount>62.10</price.amount>
								</Point>
								<Point>
									<position>19</position>
									<price.amount>77.40</price.amount>
								</Point>
								<Point>
									<position>20</position>
									<price.amount>93.40</price.amount>
								</Point>
								<Point>
									<position>21</position>
									<price.amount>40.60</price.amount>
								</Point>
								<Point>
									<position>22</position>
									<price.amount>56.20</price.amount>
								</Point>
								<Point>
									<position>23</position>
									<price.amount>87.20</price.amount>
								</Point>
								<Point>
									<position>24</position>
									<price.amount>144.06</price.amount>
								</Point>
								<Point>
									<position>25</position>
									<price.amount>50.68</price.amount>
								</Point>
								<Point>
									<position>26</position>
									<price.amount>96.20</price.amount>
								</Point>
								<Point>
									<position>27</position>
									<price.amount>117.60</price.amount>
								</Point>
								<Point>
									<position>28</position>
									<price.amount>121.50</price.amount>
								</Point>
								<Point>
									<position>29</position>
									<price.amount>125.10</price.amount>
								</Point>
								<Point>
									<position>30</position>
									<price.amount>111.80</price.amount>
								</Point>
								<Point>
									<position>31</position>
									<price.amount>91.80</price.amount>
								</Point>
								<Point>
									<position>32</position>
									<price.amount>77.46</price.amount>
								</Point>
								<Point>
									<position>33</position>
									<price.amount>179.06</price.amount>
								</Point>
								<Point>
									<position>34</position>
									<price.amount>111.90</price.amount>
								</Point>
								<Point>
									<position>35</position>
									<price.amount>69.50</price.amount>
								</Point>
								<Point>
									<position>36</position>
									<price.amount>30.10</price.amount>
								</Point>
								<Point>
									<position>37</position>
									<price.amount>151.70</price.amount>
								</Point>
								<Point>
									<position>38</position>
									<price.amount>96.20</price.amount>
								</Point>
								<Point>
									<position>39</position>
									<price.amount>69.91</price.amount>
								</Point>
								<Point>
									<position>40</position>
									<price.amount>7.20</price.amount>
								</Point>
								<Point>
									<position>41</position>
									<price.amount>114.91</price.amount>
								</Point>
								<Point>
									<position>42</position>
									<price.amount>75.20</price.amount>
								</Point>
								<Point>
									<position>43</position>
									<price.amount>49.90</price.amount>
								</Point>
								<Point>
									<position>44</position>
									<price.amount>1.20</price.amount>
								</Point>
								<Point>
									<position>45</position>
									<price.amount>89.91</price.amount>
								</Point>
								<Point>
									<position>46</position>
									<price.amount>64.90</price.amount>
								</Point>
								<Point>
									<position>47</position>
									<price.amount>29.20</price.amount>
								</Point>
								<Point>
									<position>48</position>
									<price.amount>-11.47</price.amount>
								</Point>
								<Point>
									<position>49</position>
									<price.amount>69.80</price.amount>
								</Point>
								<Point>
									<position>50</position>
									<price.amount>34.90</price.amount>
								</Point>
								<Point>
									<position>51</position>
									<price.amount>6.10</price.amount>
								</Point>
								<Point>
									<position>52</position>
									<price.amount>-20.00</price.amount>
								</Point>
								<Point>
									<position>53</position>
									<price.amount>44.20</price.amount>
								</Point>
								<Point>
									<position>54</position>
									<price.amount>24.91</price.amount>
								</Point>
								<Point>
									<position>55</position>
									<price.amount>-12.03</price.amount>
								</Point>
								<Point>
									<position>56</position>
									<price.amount>-19.94</price.amount>
								</Point>
								<Point>
									<position>57</position>
									<price.amount>-25.30</price.amount>
								</Point>
								<Point>
									<position>58</position>
									<price.amount>-13.50</price.amount>
								</Point>
								<Point>
									<position>59</position>
									<price.amount>18.83</price.amount>
								</Point>
								<Point>
									<position>60</position>
									<price.amount>39.90</price.amount>
								</Point>
								<Point>
									<position>61</position>
									<price.amount>-49.90</price.amount>
								</Point>
								<Point>
									<position>62</position>
									<price.amount>-10.80</price.amount>
								</Point>
								<Point>
									<position>63</position>
									<price.amount>21.40</price.amount>
								</Point>
								<Point>
									<position>64</position>
									<price.amount>61.62</price.amount>
								</Point>
								<Point>
									<position>65</position>
									<price.amount>-61.69</price.amount>
								</Point>
								<Point>
									<position>66</position>
									<price.amount>7.16</price.amount>
								</Point>
								<Point>
									<position>67</position>
									<price.amount>58.60</price.amount>
								</Point>
								<Point>
									<position>68</position>
									<price.amount>109.92</price.amount>
								</Point>
								<Point>
									<position>69</position>
									<price.amount>-35.10</price.amount>
								</Point>
								<Point>
									<position>70</position>
									<price.amount>39.93</price.amount>
								</Point>
								<Point>
									<position>71</position>
									<price.amount>109.93</price.amount>
								</Point>
								<Point>
									<position>72</position>
									<price.amount>139.94</price.amount>
								</Point>
								<Point>
									<position>73</position>
									<price.amount>29.91</price.amount>
								</Point>
								<Point>
									<position>74</position>
									<price.amount>54.10</price.amount>
								</Point>
								<Point>
									<position>75</position>
									<price.amount>105.11</price.amount>
								</Point>
								<Point>
									<position>76</position>
									<price.amount>149.91</price.amount>
								</Point>
								<Point>
									<position>77</position>
									<price.amount>75.05</price.amount>
								</Point>
								<Point>
									<position>78</position>
									<price.amount>93.33</price.amount>
								</Point>
								<Point>
									<position>79</position>
									<price.amount>130.10</price.amount>
								</Point>
								<Point>
									<position>80</position>
									<price.amount>139.96</price.amount>
								</Point>
								<Point>
									<position>81</position>
									<price.amount>139.92</price.amount>
								</Point>
								<Point>
									<position>82</position>
									<price.amount>110.22</price.amount>
								</Point>
								<Point>
									<position>83</position>
									<price.amount>95.08</price.amount>
								</Point>
								<Point>
									<position>84</position>
									<price.amount>95.05</price.amount>
								</Point>
								<Point>
									<position>85</position>
									<price.amount>139.98</price.amount>
								</Point>
								<Point>
									<position>86</position>
									<price.amount>114.80</price.amount>
								</Point>
								<Point>
									<position>87</position>
									<price.amount>90.09</price.amount>
								</Point>
								<Point>
									<position>88</position>
									<price.amount>80.07</price.amount>
								</Point>
								<Point>
									<position>89</position>
									<price.amount>134.70</price.amount>
								</Point>
								<Point>
									<position>90</position>
									<price.amount>100.68</price.amount>
								</Point>
								<Point>
									<position>91</position>
									<price.amount>80.03</price.amount>
								</Point>
								<Point>
									<position>92</position>
									<price.amount>70.02</price.amount>
								</Point>
								<Point>
									<position>93</position>
									<price.amount>119.70</price.amount>
								</Point>
								<Point>
									<position>94</position>
									<price.amount>82.41</price.amount>
								</Point>
								<Point>
									<position>95</position>
									<price.amount>75.10</price.amount>
								</Point>
								<Point>
									<position>96</position>
									<price.amount>65.07</price.amount>
								</Point>
						</Period>
				</TimeSeries>
				<TimeSeries>
					<mRID>2</mRID>
					<businessType>A62</businessType>
					<in_Domain.mRID codingScheme="A01">10Y1001A1001A82H</in_Domain.mRID>
					<out_Domain.mRID codingScheme="A01">10Y1001A1001A82H</out_Domain.mRID>
					<currency_Unit.name>EUR</currency_Unit.name>
					<price_Measure_Unit.name>MWH</price_Measure_Unit.name>
					<curveType>A01</curveType>
						<Period>
							<timeInterval>
								<start>2023-05-31T22:00Z</start>
								<end>2023-06-01T22:00Z</end>
							</timeInterval>
							<resolution>PT60M</resolution>
								<Point>
									<position>1</position>
									<price.amount>84.15</price.amount>
								</Point>
								<Point>
									<position>2</position>
									<price.amount>74.30</price.amount>
								</Point>
								<Point>
									<position>3</position>
									<price.amount>70.10</price.amount>
								</Point>
								<Point>
									<position>4</position>
									<price.amount>66.72</price.amount>
								</Point>
								<Point>
									<position>5</position>
									<price.amount>67.70</price.amount>
								</Point>
								<Point>
									<position>6</position>
									<price.amount>80.45</price.amount>
								</Point>
								<Point>
									<position>7</position>
									<price.amount>97.04</price.amount>
								</Point>
								<Point>
									<position>8</position>
									<price.amount>108.23</price.amount>
								</Point>
								<Point>
									<position>9</position>
									<price.amount>99.07</price.amount>
								</Point>
								<Point>
									<position>10</position>
									<price.amount>87.30</price.amount>
								</Point>
								<Point>
									<position>11</position>
									<price.amount>68.19</price.amount>
								</Point>
								<Point>
									<position>12</position>
									<price.amount>59.92</price.amount>
								</Point>
								<Point>
									<position>13</position>
									<price.amount>38.86</price.amount>
								</Point>
								<Point>
									<position>14</position>
									<price.amount>9.35</price.amount>
								</Point>
								<Point>
									<position>15</position>
									<price.amount>3.01</price.amount>
								</Point>
								<Point>
									<position>16</position>
									<price.amount>13.35</price.amount>
								</Point>
								<Point>
									<position>17</position>
									<price.amount>56.14</price.amount>
								</Point>
								<Point>
									<position>18</position>
									<price.amount>72.00</price.amount>
								</Point>
								<Point>
									<position>19</position>
									<price.amount>87.86</price.amount>
								</Point>
								<Point>
									<position>20</position>
									<price.amount>100.46</price.amount>
								</Point>
								<Point>
									<position>21</position>
									<price.amount>120.04</price.amount>
								</Point>
								<Point>
									<position>22</position>
									<price.amount>103.43</price.amount>
								</Point>
								<Point>
									<position>23</position>
									<price.amount>95.41</price.amount>
								</Point>
								<Point>
									<position>24</position>
									<price.amount>86.53</price.amount>
								</Point>
						</Period>
				</TimeSeries>
			</Publication_MarketDocument>
						""";

	private static String MISSING_DATA_AND_MULTIPLE_PERIODS_XML = """
			<?xml version="1.0" encoding="utf-8"?>
			<Publication_MarketDocument xmlns="urn:iec62325.351:tc57wg16:451-3:publicationdocument:7:3">
			  <mRID>b29cfa5b47e54691a8cc110df00a748b</mRID>
			  <revisionNumber>1</revisionNumber>
			  <type>A44</type>
			  <sender_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</sender_MarketParticipant.mRID>
			  <sender_MarketParticipant.marketRole.type>A32</sender_MarketParticipant.marketRole.type>
			  <receiver_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</receiver_MarketParticipant.mRID>
			  <receiver_MarketParticipant.marketRole.type>A33</receiver_MarketParticipant.marketRole.type>
			  <createdDateTime>2024-10-23T12:43:41Z</createdDateTime>
			  <period.timeInterval>
			    <start>2024-10-22T22:00Z</start>
			    <end>2024-10-24T22:00Z</end>
			  </period.timeInterval>
			      <TimeSeries>
			        <mRID>1</mRID>
			        <auction.type>A01</auction.type>
			        <businessType>A62</businessType>
			        <in_Domain.mRID codingScheme="A01">10Y1001A1001A46L</in_Domain.mRID>
			        <out_Domain.mRID codingScheme="A01">10Y1001A1001A46L</out_Domain.mRID>
			        <contract_MarketAgreement.type>A01</contract_MarketAgreement.type>
			        <currency_Unit.name>EUR</currency_Unit.name>
			        <price_Measure_Unit.name>MWH</price_Measure_Unit.name>
			        <curveType>A03</curveType>
			            <Period>
			              <timeInterval>
			                <start>2024-10-23T22:00Z</start>
			                <end>2024-10-24T22:00Z</end>
			              </timeInterval>
			              <resolution>PT60M</resolution>
			                  <Point>
			                    <position>1</position>
			                        <price.amount>-1</price.amount>
			                  </Point>
			                  <Point>
			                    <position>3</position>
			                        <price.amount>-0.8</price.amount>
			                  </Point>
			                  <Point>
			                    <position>4</position>
			                        <price.amount>-0.52</price.amount>
			                  </Point>
			                  <Point>
			                    <position>5</position>
			                        <price.amount>0</price.amount>
			                  </Point>
			                  <Point>
			                    <position>6</position>
			                        <price.amount>0.84</price.amount>
			                  </Point>
			                  <Point>
			                    <position>7</position>
			                        <price.amount>15.47</price.amount>
			                  </Point>
			                  <Point>
			                    <position>8</position>
			                        <price.amount>27.59</price.amount>
			                  </Point>
			                  <Point>
			                    <position>9</position>
			                        <price.amount>31.86</price.amount>
			                  </Point>
			                  <Point>
			                    <position>10</position>
			                        <price.amount>36.97</price.amount>
			                  </Point>
			                  <Point>
			                    <position>11</position>
			                        <price.amount>32.96</price.amount>
			                  </Point>
			                  <Point>
			                    <position>12</position>
			                        <price.amount>31.14</price.amount>
			                  </Point>
			                  <Point>
			                    <position>13</position>
			                        <price.amount>29.92</price.amount>
			                  </Point>
			                  <Point>
			                    <position>14</position>
			                        <price.amount>29.55</price.amount>
			                  </Point>
			                  <Point>
			                    <position>15</position>
			                        <price.amount>29.71</price.amount>
			                  </Point>
			                  <Point>
			                    <position>16</position>
			                        <price.amount>29.76</price.amount>
			                  </Point>
			                  <Point>
			                    <position>17</position>
			                        <price.amount>29.98</price.amount>
			                  </Point>
			                  <Point>
			                    <position>18</position>
			                        <price.amount>59.65</price.amount>
			                  </Point>
			                  <Point>
			                    <position>19</position>
			                        <price.amount>79.41</price.amount>
			                  </Point>
			                  <Point>
			                    <position>20</position>
			                        <price.amount>39.97</price.amount>
			                  </Point>
			                  <Point>
			                    <position>21</position>
			                        <price.amount>29.93</price.amount>
			                  </Point>
			                  <Point>
			                    <position>22</position>
			                        <price.amount>27.68</price.amount>
			                  </Point>
			                  <Point>
			                    <position>23</position>
			                        <price.amount>24.95</price.amount>
			                  </Point>
			                  <Point>
			                    <position>24</position>
			                        <price.amount>13.27</price.amount>
			                  </Point>
			            </Period>
			      </TimeSeries>
			      <TimeSeries>
			        <mRID>2</mRID>
			        <auction.type>A01</auction.type>
			        <businessType>A62</businessType>
			        <in_Domain.mRID codingScheme="A01">10Y1001A1001A46L</in_Domain.mRID>
			        <out_Domain.mRID codingScheme="A01">10Y1001A1001A46L</out_Domain.mRID>
			        <contract_MarketAgreement.type>A01</contract_MarketAgreement.type>
			        <currency_Unit.name>EUR</currency_Unit.name>
			        <price_Measure_Unit.name>MWH</price_Measure_Unit.name>
			        <curveType>A03</curveType>
			            <Period>
			              <timeInterval>
			                <start>2024-10-22T22:00Z</start>
			                <end>2024-10-23T22:00Z</end>
			              </timeInterval>
			              <resolution>PT60M</resolution>
			                  <Point>
			                    <position>1</position>
			                        <price.amount>0</price.amount>
			                  </Point>
			                  <Point>
			                    <position>2</position>
			                        <price.amount>-0.04</price.amount>
			                  </Point>
			                  <Point>
			                    <position>3</position>
			                        <price.amount>-0.54</price.amount>
			                  </Point>
			                  <Point>
			                    <position>4</position>
			                        <price.amount>-0.8</price.amount>
			                  </Point>
			                  <Point>
			                    <position>5</position>
			                        <price.amount>-0.58</price.amount>
			                  </Point>
			                  <Point>
			                    <position>6</position>
			                        <price.amount>0</price.amount>
			                  </Point>
			                  <Point>
			                    <position>7</position>
			                        <price.amount>0.48</price.amount>
			                  </Point>
			                  <Point>
			                    <position>8</position>
			                        <price.amount>4.96</price.amount>
			                  </Point>
			                  <Point>
			                    <position>9</position>
			                        <price.amount>4.9</price.amount>
			                  </Point>
			                  <Point>
			                    <position>10</position>
			                        <price.amount>2.15</price.amount>
			                  </Point>
			                  <Point>
			                    <position>11</position>
			                        <price.amount>0.92</price.amount>
			                  </Point>
			                  <Point>
			                    <position>12</position>
			                        <price.amount>0.01</price.amount>
			                  </Point>
			                  <Point>
			                    <position>13</position>
			                        <price.amount>-0.01</price.amount>
			                  </Point>
			                  <Point>
			                    <position>14</position>
			                        <price.amount>-0.06</price.amount>
			                  </Point>
			                  <Point>
			                    <position>15</position>
			                        <price.amount>-0.11</price.amount>
			                  </Point>
			                  <Point>
			                    <position>16</position>
			                        <price.amount>-0.01</price.amount>
			                  </Point>
			                  <Point>
			                    <position>17</position>
			                        <price.amount>0</price.amount>
			                  </Point>
			                  <Point>
			                    <position>18</position>
			                        <price.amount>0.8</price.amount>
			                  </Point>
			                  <Point>
			                    <position>19</position>
			                        <price.amount>0.96</price.amount>
			                  </Point>
			                  <Point>
			                    <position>20</position>
			                        <price.amount>0.01</price.amount>
			                  </Point>
			                  <Point>
			                    <position>21</position>
			                        <price.amount>0</price.amount>
			                  </Point>
			                  <Point>
			                    <position>23</position>
			                        <price.amount>-0.09</price.amount>
			                  </Point>
			                  <Point>
			                    <position>24</position>
			                        <price.amount>-0.81</price.amount>
			                  </Point>
			            </Period>
			      </TimeSeries>
			</Publication_MarketDocument>
						""";

	private static String MISSING_DATA_FOR_QUARTER_DURATION = """
						<Publication_MarketDocument
				xmlns="urn:iec62325.351:tc57wg16:451-3:publicationdocument:7:3">
				<mRID>b800016070e147898e51672e789e6503</mRID>
				<revisionNumber>1</revisionNumber>
				<type>A44</type>
				<sender_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</sender_MarketParticipant.mRID>
				<sender_MarketParticipant.marketRole.type>A32</sender_MarketParticipant.marketRole.type>
				<receiver_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</receiver_MarketParticipant.mRID>
				<receiver_MarketParticipant.marketRole.type>A33</receiver_MarketParticipant.marketRole.type>
				<createdDateTime>2025-01-17T14:45:02Z</createdDateTime>
				<period.timeInterval>
					<start>2025-01-16T23:00Z</start>
					<end>2025-01-18T23:00Z</end>
				</period.timeInterval>
				<TimeSeries>
					<mRID>1</mRID>
					<auction.type>A01</auction.type>
					<businessType>A62</businessType>
					<in_Domain.mRID codingScheme="A01">10Y1001A1001A82H</in_Domain.mRID>
					<out_Domain.mRID codingScheme="A01">10Y1001A1001A82H</out_Domain.mRID>
					<contract_MarketAgreement.type>A01</contract_MarketAgreement.type>
					<currency_Unit.name>EUR</currency_Unit.name>
					<price_Measure_Unit.name>MWH</price_Measure_Unit.name>
					<classificationSequence_AttributeInstanceComponent.position>1</classificationSequence_AttributeInstanceComponent.position>
					<curveType>A03</curveType>
					<Period>
						<timeInterval>
							<start>2025-01-16T23:00Z</start>
							<end>2025-01-17T23:00Z</end>
						</timeInterval>
						<resolution>PT60M</resolution>
						<Point>
							<position>1</position>
							<price.amount>118.87</price.amount>
						</Point>
						<Point>
							<position>2</position>
							<price.amount>118.39</price.amount>
						</Point>
						<Point>
							<position>3</position>
							<price.amount>115.71</price.amount>
						</Point>
						<Point>
							<position>4</position>
							<price.amount>114.72</price.amount>
						</Point>
						<Point>
							<position>5</position>
							<price.amount>115.48</price.amount>
						</Point>
						<Point>
							<position>6</position>
							<price.amount>122.16</price.amount>
						</Point>
						<Point>
							<position>7</position>
							<price.amount>140.8</price.amount>
						</Point>
						<Point>
							<position>8</position>
							<price.amount>175.01</price.amount>
						</Point>
						<Point>
							<position>9</position>
							<price.amount>208.13</price.amount>
						</Point>
						<Point>
							<position>10</position>
							<price.amount>175.34</price.amount>
						</Point>
						<Point>
							<position>11</position>
							<price.amount>158</price.amount>
						</Point>
						<Point>
							<position>12</position>
							<price.amount>140.73</price.amount>
						</Point>
						<Point>
							<position>13</position>
							<price.amount>126.44</price.amount>
						</Point>
						<Point>
							<position>14</position>
							<price.amount>124.03</price.amount>
						</Point>
						<Point>
							<position>15</position>
							<price.amount>132.99</price.amount>
						</Point>
						<Point>
							<position>16</position>
							<price.amount>151.98</price.amount>
						</Point>
						<Point>
							<position>17</position>
							<price.amount>170.21</price.amount>
						</Point>
						<Point>
							<position>18</position>
							<price.amount>178.79</price.amount>
						</Point>
						<Point>
							<position>19</position>
							<price.amount>179.92</price.amount>
						</Point>
						<Point>
							<position>20</position>
							<price.amount>174.22</price.amount>
						</Point>
						<Point>
							<position>21</position>
							<price.amount>157.91</price.amount>
						</Point>
						<Point>
							<position>22</position>
							<price.amount>145</price.amount>
						</Point>
						<Point>
							<position>23</position>
							<price.amount>139.97</price.amount>
						</Point>
						<Point>
							<position>24</position>
							<price.amount>126.84</price.amount>
						</Point>
					</Period>
				</TimeSeries>
				<TimeSeries>
					<mRID>2</mRID>
					<auction.type>A01</auction.type>
					<businessType>A62</businessType>
					<in_Domain.mRID codingScheme="A01">10Y1001A1001A82H</in_Domain.mRID>
					<out_Domain.mRID codingScheme="A01">10Y1001A1001A82H</out_Domain.mRID>
					<contract_MarketAgreement.type>A01</contract_MarketAgreement.type>
					<currency_Unit.name>EUR</currency_Unit.name>
					<price_Measure_Unit.name>MWH</price_Measure_Unit.name>
					<classificationSequence_AttributeInstanceComponent.position>2</classificationSequence_AttributeInstanceComponent.position>
					<curveType>A03</curveType>
					<Period>
						<timeInterval>
							<start>2025-01-17T23:00Z</start>
							<end>2025-01-18T23:00Z</end>
						</timeInterval>
						<resolution>PT15M</resolution>
						<Point>
							<position>1</position>
							<price.amount>145.2</price.amount>
						</Point>
						<Point>
							<position>2</position>
							<price.amount>127.6</price.amount>
						</Point>
						<Point>
							<position>3</position>
							<price.amount>116.3</price.amount>
						</Point>
						<Point>
							<position>4</position>
							<price.amount>115.32</price.amount>
						</Point>
						<Point>
							<position>5</position>
							<price.amount>138.6</price.amount>
						</Point>
						<Point>
							<position>6</position>
							<price.amount>120.54</price.amount>
						</Point>
						<Point>
							<position>7</position>
							<price.amount>115.55</price.amount>
						</Point>
						<Point>
							<position>8</position>
							<price.amount>109.3</price.amount>
						</Point>
						<Point>
							<position>9</position>
							<price.amount>122.07</price.amount>
						</Point>
						<Point>
							<position>10</position>
							<price.amount>121.6</price.amount>
						</Point>
						<Point>
							<position>11</position>
							<price.amount>119</price.amount>
						</Point>
						<Point>
							<position>12</position>
							<price.amount>116.6</price.amount>
						</Point>
						<Point>
							<position>13</position>
							<price.amount>122.9</price.amount>
						</Point>
						<Point>
							<position>14</position>
							<price.amount>119</price.amount>
						</Point>
						<Point>
							<position>15</position>
							<price.amount>118</price.amount>
						</Point>
						<Point>
							<position>16</position>
							<price.amount>114.91</price.amount>
						</Point>
						<Point>
							<position>17</position>
							<price.amount>116.9</price.amount>
						</Point>
						<Point>
							<position>18</position>
							<price.amount>117.3</price.amount>
						</Point>
						<Point>
							<position>19</position>
							<price.amount>120.8</price.amount>
						</Point>
						<Point>
							<position>20</position>
							<price.amount>117.81</price.amount>
						</Point>
						<Point>
							<position>21</position>
							<price.amount>120.2</price.amount>
						</Point>
						<Point>
							<position>22</position>
							<price.amount>116.8</price.amount>
						</Point>
						<Point>
							<position>23</position>
							<price.amount>110.9</price.amount>
						</Point>
						<Point>
							<position>24</position>
							<price.amount>124.8</price.amount>
						</Point>
						<Point>
							<position>25</position>
							<price.amount>108.25</price.amount>
						</Point>
						<Point>
							<position>26</position>
							<price.amount>116.6</price.amount>
						</Point>
						<Point>
							<position>27</position>
							<price.amount>124.6</price.amount>
						</Point>
						<Point>
							<position>28</position>
							<price.amount>141.7</price.amount>
						</Point>
						<Point>
							<position>29</position>
							<price.amount>102.11</price.amount>
						</Point>
						<Point>
							<position>30</position>
							<price.amount>132.9</price.amount>
						</Point>
						<Point>
							<position>31</position>
							<price.amount>147.1</price.amount>
						</Point>
						<Point>
							<position>32</position>
							<price.amount>162.5</price.amount>
						</Point>
						<Point>
							<position>33</position>
							<price.amount>142</price.amount>
						</Point>
						<Point>
							<position>34</position>
							<price.amount>148.2</price.amount>
						</Point>
						<Point>
							<position>35</position>
							<price.amount>150.4</price.amount>
						</Point>
						<Point>
							<position>36</position>
							<price.amount>143.5</price.amount>
						</Point>
						<Point>
							<position>37</position>
							<price.amount>160.1</price.amount>
						</Point>
						<Point>
							<position>38</position>
							<price.amount>145.3</price.amount>
						</Point>
						<Point>
							<position>39</position>
							<price.amount>139.9</price.amount>
						</Point>
						<Point>
							<position>40</position>
							<price.amount>132.7</price.amount>
						</Point>
						<Point>
							<position>41</position>
							<price.amount>164.9</price.amount>
						</Point>
						<Point>
							<position>42</position>
							<price.amount>145.6</price.amount>
						</Point>
						<Point>
							<position>43</position>
							<price.amount>134.57</price.amount>
						</Point>
						<Point>
							<position>44</position>
							<price.amount>117.1</price.amount>
						</Point>
						<Point>
							<position>45</position>
							<price.amount>144.3</price.amount>
						</Point>
						<Point>
							<position>46</position>
							<price.amount>128.4</price.amount>
						</Point>
						<Point>
							<position>47</position>
							<price.amount>120.2</price.amount>
						</Point>
						<Point>
							<position>48</position>
							<price.amount>100.93</price.amount>
						</Point>
						<Point>
							<position>49</position>
							<price.amount>141.55</price.amount>
						</Point>
						<Point>
							<position>50</position>
							<price.amount>120.2</price.amount>
						</Point>
						<Point>
							<position>51</position>
							<price.amount>114.2</price.amount>
						</Point>
						<Point>
							<position>52</position>
							<price.amount>106.5</price.amount>
						</Point>
						<Point>
							<position>53</position>
							<price.amount>117.1</price.amount>
						</Point>
						<Point>
							<position>54</position>
							<price.amount>116.5</price.amount>
						</Point>
						<Point>
							<position>55</position>
							<price.amount>116.9</price.amount>
						</Point>
						<Point>
							<position>56</position>
							<price.amount>120.6</price.amount>
						</Point>
						<Point>
							<position>57</position>
							<price.amount>95.07</price.amount>
						</Point>
						<Point>
							<position>58</position>
							<price.amount>115.49</price.amount>
						</Point>
						<Point>
							<position>59</position>
							<price.amount>128.6</price.amount>
						</Point>
						<Point>
							<position>60</position>
							<price.amount>141.2</price.amount>
						</Point>
						<Point>
							<position>61</position>
							<price.amount>98.23</price.amount>
						</Point>
						<Point>
							<position>62</position>
							<price.amount>124.9</price.amount>
						</Point>
						<Point>
							<position>63</position>
							<price.amount>139.3</price.amount>
						</Point>
						<Point>
							<position>64</position>
							<price.amount>169.5</price.amount>
						</Point>
						<Point>
							<position>65</position>
							<price.amount>107.58</price.amount>
						</Point>
						<Point>
							<position>66</position>
							<price.amount>133.8</price.amount>
						</Point>
						<Point>
							<position>67</position>
							<price.amount>160.6</price.amount>
						</Point>
						<Point>
							<position>68</position>
							<price.amount>195.8</price.amount>
						</Point>
						<Point>
							<position>69</position>
							<price.amount>140.06</price.amount>
						</Point>
						<Point>
							<position>70</position>
							<price.amount>147.5</price.amount>
						</Point>
						<Point>
							<position>71</position>
							<price.amount>155.08</price.amount>
						</Point>
						<Point>
							<position>72</position>
							<price.amount>187</price.amount>
						</Point>
						<Point>
							<position>73</position>
							<price.amount>176.5</price.amount>
						</Point>
						<Point>
							<position>74</position>
							<price.amount>164.11</price.amount>
						</Point>
						<Point>
							<position>75</position>
							<price.amount>170.9</price.amount>
						</Point>
						<Point>
							<position>76</position>
							<price.amount>167.5</price.amount>
						</Point>
						<Point>
							<position>77</position>
							<price.amount>209.6</price.amount>
						</Point>
						<Point>
							<position>78</position>
							<price.amount>166.3</price.amount>
						</Point>
						<Point>
							<position>79</position>
							<price.amount>147.58</price.amount>
						</Point>
						<Point>
							<position>80</position>
							<price.amount>132.57</price.amount>
						</Point>
						<Point>
							<position>81</position>
							<price.amount>189.93</price.amount>
						</Point>
						<Point>
							<position>82</position>
							<price.amount>150.6</price.amount>
						</Point>
						<Point>
							<position>83</position>
							<price.amount>133.6</price.amount>
						</Point>
						<Point>
							<position>84</position>
							<price.amount>119</price.amount>
						</Point>
						<Point>
							<position>85</position>
							<price.amount>163.1</price.amount>
						</Point>
						<Point>
							<position>86</position>
							<price.amount>140.9</price.amount>
						</Point>
						<Point>
							<position>87</position>
							<price.amount>128.8</price.amount>
						</Point>
						<Point>
							<position>88</position>
							<price.amount>123.99</price.amount>
						</Point>
						<Point>
							<position>89</position>
							<price.amount>143.3</price.amount>
						</Point>
						<Point>
							<position>90</position>
							<price.amount>131</price.amount>
						</Point>
						<Point>
							<position>91</position>
							<price.amount>135.2</price.amount>
						</Point>
						<Point>
							<position>92</position>
							<price.amount>118.52</price.amount>
						</Point>
						<Point>
							<position>93</position>
							<price.amount>147.82</price.amount>
						</Point>
						<Point>
							<position>94</position>
							<price.amount>126.9</price.amount>
						</Point>
						<Point>
							<position>95</position>
							<price.amount>116.1</price.amount>
						</Point>
						<Point>
							<position>96</position>
							<price.amount>107</price.amount>
						</Point>
					</Period>
				</TimeSeries>
				<TimeSeries>
					<mRID>3</mRID>
					<auction.type>A01</auction.type>
					<businessType>A62</businessType>
					<in_Domain.mRID codingScheme="A01">10Y1001A1001A82H</in_Domain.mRID>
					<out_Domain.mRID codingScheme="A01">10Y1001A1001A82H</out_Domain.mRID>
					<contract_MarketAgreement.type>A01</contract_MarketAgreement.type>
					<currency_Unit.name>EUR</currency_Unit.name>
					<price_Measure_Unit.name>MWH</price_Measure_Unit.name>
					<classificationSequence_AttributeInstanceComponent.position>1</classificationSequence_AttributeInstanceComponent.position>
					<curveType>A03</curveType>
					<Period>
						<timeInterval>
							<start>2025-01-17T23:00Z</start>
							<end>2025-01-18T23:00Z</end>
						</timeInterval>
						<resolution>PT60M</resolution>
						<Point>
							<position>1</position>
							<price.amount>125.29</price.amount>
						</Point>
						<Point>
							<position>2</position>
							<price.amount>121.05</price.amount>
						</Point>
						<Point>
							<position>3</position>
							<price.amount>120.98</price.amount>
						</Point>
						<Point>
							<position>4</position>
							<price.amount>118.85</price.amount>
						</Point>
						<Point>
							<position>5</position>
							<price.amount>116.46</price.amount>
						</Point>
						<Point>
							<position>6</position>
							<price.amount>119.77</price.amount>
						</Point>
						<Point>
							<position>7</position>
							<price.amount>119.75</price.amount>
						</Point>
						<Point>
							<position>8</position>
							<price.amount>133.39</price.amount>
						</Point>
						<Point>
							<position>9</position>
							<price.amount>145.63</price.amount>
						</Point>
						<Point>
							<position>10</position>
							<price.amount>144.1</price.amount>
						</Point>
						<Point>
							<position>11</position>
							<price.amount>131.21</price.amount>
						</Point>
						<Point>
							<position>12</position>
							<price.amount>121.56</price.amount>
						</Point>
						<Point>
							<position>13</position>
							<price.amount>118.87</price.amount>
						</Point>
						<Point>
							<position>14</position>
							<price.amount>115.01</price.amount>
						</Point>
						<Point>
							<position>15</position>
							<price.amount>119.32</price.amount>
						</Point>
						<Point>
							<position>16</position>
							<price.amount>133.32</price.amount>
						</Point>
						<Point>
							<position>17</position>
							<price.amount>149.71</price.amount>
						</Point>
						<Point>
							<position>18</position>
							<price.amount>164.59</price.amount>
						</Point>
						<Point>
							<position>19</position>
							<price.amount>167.57</price.amount>
						</Point>
						<Point>
							<position>20</position>
							<price.amount>167.85</price.amount>
						</Point>
						<Point>
							<position>21</position>
							<price.amount>156.12</price.amount>
						</Point>
						<Point>
							<position>22</position>
							<price.amount>143.42</price.amount>
						</Point>
						<Point>
							<position>23</position>
							<price.amount>136.4</price.amount>
						</Point>
						<Point>
							<position>24</position>
							<price.amount>129.36</price.amount>
						</Point>
					</Period>
				</TimeSeries>
			</Publication_MarketDocument>
									""";

	private static String MISSING_DATA_FOR_HOUR_DURATION = """
						<Publication_MarketDocument
				xmlns="urn:iec62325.351:tc57wg16:451-3:publicationdocument:7:3">
				<mRID>b800016070e147898e51672e789e6503</mRID>
				<revisionNumber>1</revisionNumber>
				<type>A44</type>
				<sender_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</sender_MarketParticipant.mRID>
				<sender_MarketParticipant.marketRole.type>A32</sender_MarketParticipant.marketRole.type>
				<receiver_MarketParticipant.mRID codingScheme="A01">10X1001A1001A450</receiver_MarketParticipant.mRID>
				<receiver_MarketParticipant.marketRole.type>A33</receiver_MarketParticipant.marketRole.type>
				<createdDateTime>2025-01-17T14:45:02Z</createdDateTime>
				<period.timeInterval>
					<start>2025-01-16T23:00Z</start>
					<end>2025-01-18T23:00Z</end>
				</period.timeInterval>
				<TimeSeries>
					<mRID>1</mRID>
					<auction.type>A01</auction.type>
					<businessType>A62</businessType>
					<in_Domain.mRID codingScheme="A01">10Y1001A1001A82H</in_Domain.mRID>
					<out_Domain.mRID codingScheme="A01">10Y1001A1001A82H</out_Domain.mRID>
					<contract_MarketAgreement.type>A01</contract_MarketAgreement.type>
					<currency_Unit.name>EUR</currency_Unit.name>
					<price_Measure_Unit.name>MWH</price_Measure_Unit.name>
					<classificationSequence_AttributeInstanceComponent.position>1</classificationSequence_AttributeInstanceComponent.position>
					<curveType>A03</curveType>
					<Period>
						<timeInterval>
							<start>2025-01-16T23:00Z</start>
							<end>2025-01-17T23:00Z</end>
						</timeInterval>
						<resolution>PT60M</resolution>
						<Point>
							<position>1</position>
							<price.amount>118.87</price.amount>
						</Point>
						<Point>
							<position>2</position>
							<price.amount>118.39</price.amount>
						</Point>
						<Point>
							<position>3</position>
							<price.amount>115.71</price.amount>
						</Point>
						<Point>
							<position>4</position>
							<price.amount>114.72</price.amount>
						</Point>
						<Point>
							<position>5</position>
							<price.amount>115.48</price.amount>
						</Point>
						<Point>
							<position>6</position>
							<price.amount>122.16</price.amount>
						</Point>
						<Point>
							<position>7</position>
							<price.amount>140.8</price.amount>
						</Point>
						<Point>
							<position>8</position>
							<price.amount>175.01</price.amount>
						</Point>
						<Point>
							<position>9</position>
							<price.amount>208.13</price.amount>
						</Point>
						<Point>
							<position>10</position>
							<price.amount>175.34</price.amount>
						</Point>
						<Point>
							<position>11</position>
							<price.amount>158</price.amount>
						</Point>
						<Point>
							<position>12</position>
							<price.amount>140.73</price.amount>
						</Point>
						<Point>
							<position>13</position>
							<price.amount>126.44</price.amount>
						</Point>
						<Point>
							<position>14</position>
							<price.amount>124.03</price.amount>
						</Point>
						<Point>
							<position>15</position>
							<price.amount>132.99</price.amount>
						</Point>
						<Point>
							<position>16</position>
							<price.amount>151.98</price.amount>
						</Point>
						<Point>
							<position>17</position>
							<price.amount>170.21</price.amount>
						</Point>
						<Point>
							<position>18</position>
							<price.amount>178.79</price.amount>
						</Point>
						<Point>
							<position>19</position>
							<price.amount>179.92</price.amount>
						</Point>
						<Point>
							<position>20</position>
							<price.amount>174.22</price.amount>
						</Point>
						<Point>
							<position>21</position>
							<price.amount>157.91</price.amount>
						</Point>
						<Point>
							<position>22</position>
							<price.amount>145</price.amount>
						</Point>
						<Point>
							<position>23</position>
							<price.amount>139.97</price.amount>
						</Point>
						<Point>
							<position>24</position>
							<price.amount>126.84</price.amount>
						</Point>
					</Period>
				</TimeSeries>
				<TimeSeries>
					<mRID>2</mRID>
					<auction.type>A01</auction.type>
					<businessType>A62</businessType>
					<in_Domain.mRID codingScheme="A01">10Y1001A1001A82H</in_Domain.mRID>
					<out_Domain.mRID codingScheme="A01">10Y1001A1001A82H</out_Domain.mRID>
					<contract_MarketAgreement.type>A01</contract_MarketAgreement.type>
					<currency_Unit.name>EUR</currency_Unit.name>
					<price_Measure_Unit.name>MWH</price_Measure_Unit.name>
					<classificationSequence_AttributeInstanceComponent.position>2</classificationSequence_AttributeInstanceComponent.position>
					<curveType>A03</curveType>
					<Period>
						<timeInterval>
							<start>2025-01-17T23:00Z</start>
							<end>2025-01-18T23:00Z</end>
						</timeInterval>
						<resolution>PT15M</resolution>
						<Point>
							<position>1</position>
							<price.amount>145.2</price.amount>
						</Point>
						<Point>
							<position>2</position>
							<price.amount>127.6</price.amount>
						</Point>
						<Point>
							<position>3</position>
							<price.amount>116.3</price.amount>
						</Point>
						<Point>
							<position>4</position>
							<price.amount>115.32</price.amount>
						</Point>
						<Point>
							<position>5</position>
							<price.amount>138.6</price.amount>
						</Point>
						<Point>
							<position>6</position>
							<price.amount>120.54</price.amount>
						</Point>
						<Point>
							<position>7</position>
							<price.amount>115.55</price.amount>
						</Point>
						<Point>
							<position>8</position>
							<price.amount>109.3</price.amount>
						</Point>
						<Point>
							<position>9</position>
							<price.amount>122.07</price.amount>
						</Point>
						<Point>
							<position>10</position>
							<price.amount>121.6</price.amount>
						</Point>
						<Point>
							<position>11</position>
							<price.amount>119</price.amount>
						</Point>
						<Point>
							<position>12</position>
							<price.amount>116.6</price.amount>
						</Point>
						<Point>
							<position>13</position>
							<price.amount>122.9</price.amount>
						</Point>
						<Point>
							<position>14</position>
							<price.amount>119</price.amount>
						</Point>
						<Point>
							<position>15</position>
							<price.amount>118</price.amount>
						</Point>
						<Point>
							<position>16</position>
							<price.amount>114.91</price.amount>
						</Point>
						<Point>
							<position>17</position>
							<price.amount>116.9</price.amount>
						</Point>
						<Point>
							<position>18</position>
							<price.amount>117.3</price.amount>
						</Point>
						<Point>
							<position>19</position>
							<price.amount>120.8</price.amount>
						</Point>
						<Point>
							<position>20</position>
							<price.amount>117.81</price.amount>
						</Point>
						<Point>
							<position>21</position>
							<price.amount>120.2</price.amount>
						</Point>
						<Point>
							<position>22</position>
							<price.amount>116.8</price.amount>
						</Point>
						<Point>
							<position>23</position>
							<price.amount>110.9</price.amount>
						</Point>
						<Point>
							<position>24</position>
							<price.amount>124.8</price.amount>
						</Point>
						<Point>
							<position>25</position>
							<price.amount>108.25</price.amount>
						</Point>
						<Point>
							<position>26</position>
							<price.amount>116.6</price.amount>
						</Point>
						<Point>
							<position>27</position>
							<price.amount>124.6</price.amount>
						</Point>
						<Point>
							<position>28</position>
							<price.amount>141.7</price.amount>
						</Point>
						<Point>
							<position>29</position>
							<price.amount>102.11</price.amount>
						</Point>
						<Point>
							<position>30</position>
							<price.amount>132.9</price.amount>
						</Point>
						<Point>
							<position>31</position>
							<price.amount>147.1</price.amount>
						</Point>
						<Point>
							<position>32</position>
							<price.amount>162.5</price.amount>
						</Point>
						<Point>
							<position>33</position>
							<price.amount>142</price.amount>
						</Point>
						<Point>
							<position>34</position>
							<price.amount>148.2</price.amount>
						</Point>
						<Point>
							<position>35</position>
							<price.amount>150.4</price.amount>
						</Point>
						<Point>
							<position>36</position>
							<price.amount>143.5</price.amount>
						</Point>
						<Point>
							<position>37</position>
							<price.amount>160.1</price.amount>
						</Point>
						<Point>
							<position>38</position>
							<price.amount>145.3</price.amount>
						</Point>
						<Point>
							<position>39</position>
							<price.amount>139.9</price.amount>
						</Point>
						<Point>
							<position>40</position>
							<price.amount>132.7</price.amount>
						</Point>
						<Point>
							<position>41</position>
							<price.amount>164.9</price.amount>
						</Point>
						<Point>
							<position>42</position>
							<price.amount>145.6</price.amount>
						</Point>
						<Point>
							<position>43</position>
							<price.amount>134.57</price.amount>
						</Point>
						<Point>
							<position>44</position>
							<price.amount>117.1</price.amount>
						</Point>
						<Point>
							<position>45</position>
							<price.amount>144.3</price.amount>
						</Point>
						<Point>
							<position>46</position>
							<price.amount>128.4</price.amount>
						</Point>
						<Point>
							<position>47</position>
							<price.amount>120.2</price.amount>
						</Point>
						<Point>
							<position>48</position>
							<price.amount>100.93</price.amount>
						</Point>
						<Point>
							<position>49</position>
							<price.amount>141.55</price.amount>
						</Point>
						<Point>
							<position>50</position>
							<price.amount>120.2</price.amount>
						</Point>
						<Point>
							<position>51</position>
							<price.amount>114.2</price.amount>
						</Point>
						<Point>
							<position>52</position>
							<price.amount>106.5</price.amount>
						</Point>
						<Point>
							<position>53</position>
							<price.amount>117.1</price.amount>
						</Point>
						<Point>
							<position>54</position>
							<price.amount>116.5</price.amount>
						</Point>
						<Point>
							<position>55</position>
							<price.amount>116.9</price.amount>
						</Point>
						<Point>
							<position>56</position>
							<price.amount>120.6</price.amount>
						</Point>
						<Point>
							<position>57</position>
							<price.amount>95.07</price.amount>
						</Point>
						<Point>
							<position>58</position>
							<price.amount>115.49</price.amount>
						</Point>
						<Point>
							<position>59</position>
							<price.amount>128.6</price.amount>
						</Point>
						<Point>
							<position>60</position>
							<price.amount>141.2</price.amount>
						</Point>
						<Point>
							<position>61</position>
							<price.amount>98.23</price.amount>
						</Point>
						<Point>
							<position>62</position>
							<price.amount>124.9</price.amount>
						</Point>
						<Point>
							<position>63</position>
							<price.amount>139.3</price.amount>
						</Point>
						<Point>
							<position>64</position>
							<price.amount>169.5</price.amount>
						</Point>
						<Point>
							<position>65</position>
							<price.amount>107.58</price.amount>
						</Point>
						<Point>
							<position>66</position>
							<price.amount>133.8</price.amount>
						</Point>
						<Point>
							<position>67</position>
							<price.amount>160.6</price.amount>
						</Point>
						<Point>
							<position>68</position>
							<price.amount>195.8</price.amount>
						</Point>
						<Point>
							<position>69</position>
							<price.amount>140.06</price.amount>
						</Point>
						<Point>
							<position>70</position>
							<price.amount>147.5</price.amount>
						</Point>
						<Point>
							<position>71</position>
							<price.amount>155.08</price.amount>
						</Point>
						<Point>
							<position>72</position>
							<price.amount>187</price.amount>
						</Point>
						<Point>
							<position>73</position>
							<price.amount>176.5</price.amount>
						</Point>
						<Point>
							<position>74</position>
							<price.amount>164.11</price.amount>
						</Point>
						<Point>
							<position>75</position>
							<price.amount>170.9</price.amount>
						</Point>
						<Point>
							<position>76</position>
							<price.amount>167.5</price.amount>
						</Point>
						<Point>
							<position>77</position>
							<price.amount>209.6</price.amount>
						</Point>
						<Point>
							<position>78</position>
							<price.amount>166.3</price.amount>
						</Point>
						<Point>
							<position>79</position>
							<price.amount>147.58</price.amount>
						</Point>
						<Point>
							<position>80</position>
							<price.amount>132.57</price.amount>
						</Point>
						<Point>
							<position>81</position>
							<price.amount>189.93</price.amount>
						</Point>
						<Point>
							<position>82</position>
							<price.amount>150.6</price.amount>
						</Point>
						<Point>
							<position>83</position>
							<price.amount>133.6</price.amount>
						</Point>
						<Point>
							<position>84</position>
							<price.amount>119</price.amount>
						</Point>
						<Point>
							<position>85</position>
							<price.amount>163.1</price.amount>
						</Point>
						<Point>
							<position>86</position>
							<price.amount>140.9</price.amount>
						</Point>
						<Point>
							<position>87</position>
							<price.amount>128.8</price.amount>
						</Point>
						<Point>
							<position>88</position>
							<price.amount>123.99</price.amount>
						</Point>
						<Point>
							<position>89</position>
							<price.amount>143.3</price.amount>
						</Point>
						<Point>
							<position>90</position>
							<price.amount>131</price.amount>
						</Point>
						<Point>
							<position>91</position>
							<price.amount>135.2</price.amount>
						</Point>
						<Point>
							<position>92</position>
							<price.amount>118.52</price.amount>
						</Point>
						<Point>
							<position>93</position>
							<price.amount>147.82</price.amount>
						</Point>
						<Point>
							<position>94</position>
							<price.amount>126.9</price.amount>
						</Point>
						<Point>
							<position>95</position>
							<price.amount>116.1</price.amount>
						</Point>
						<Point>
							<position>96</position>
							<price.amount>107</price.amount>
						</Point>
					</Period>
				</TimeSeries>
			</Publication_MarketDocument>
									""";

	@Test
	public void testParsePrices() throws Exception {
		var currencyExchangeValue = 1.0;

		// Quarterly resolution.
		var preferredResolution = Resolution.QUARTERLY;
		var prices = parsePrices(XML, currencyExchangeValue, preferredResolution);
		var startTime = prices.firstKey();
		assertEquals(109.93, prices.firstEntry().getValue(), 0.001);

		var secondPrice = prices.get(startTime.plusMinutes(15));
		assertEquals(85.84, secondPrice, 0.001);

		var thirdPrice = prices.get(startTime.plusMinutes(30));
		assertEquals(65.09, thirdPrice, 0.001);

		// Last price
		assertEquals(65.07, prices.get(prices.lastKey()), 0.001);

		// Hourly resolution.
		preferredResolution = Resolution.HOURLY;
		prices = parsePrices(XML, currencyExchangeValue, preferredResolution);
		assertEquals(84.15, prices.firstEntry().getValue(), 0.001);

		secondPrice = prices.get(startTime.plusMinutes(15));
		assertEquals(84.15, secondPrice, 0.001);

		thirdPrice = prices.get(startTime.plusMinutes(60));
		assertEquals(74.3, thirdPrice, 0.001);

		// Last price
		assertEquals(86.53, prices.get(prices.lastKey()), 0.001);
	}

	@Test
	public void testParsePrices2() throws Exception {
		var currencyExchangeValue = 1.0;
		var preferredResolution = Resolution.QUARTERLY;
		var prices = parsePrices(MISSING_DATA_AND_MULTIPLE_PERIODS_XML, currencyExchangeValue, preferredResolution);
		assertEquals(192, prices.size());
		var array = prices.values().toArray(new Double[0]);
		assertEquals(array[96], array[97], 0.001); // Missing value check
		assertEquals(array[0], 0, 0.001); // Making sure that Periods are sorted before prices are stored.
	}

	@Test
	public void testParsePrices3() throws Exception {
		var currencyExchangeValue = 1.0;
		var preferredResolution = Resolution.QUARTERLY;
		var prices = parsePrices(MISSING_DATA_FOR_QUARTER_DURATION, currencyExchangeValue, preferredResolution);

		var priceArray = prices.values().toArray(new Double[0]);
		assertEquals(192, priceArray.length);
		assertEquals(118.87, priceArray[0], 0.001); // Missing data but added from PT60M duration.

		prices = parsePrices(MISSING_DATA_FOR_HOUR_DURATION, currencyExchangeValue, preferredResolution);
		priceArray = prices.values().toArray(new Double[0]);
		assertEquals(192, priceArray.length);
		assertEquals(107.0, priceArray[191], 0.001); // Missing data, but added from PT15M duration.
	}

	@Test
	public void testParseCurrency() throws Exception {
		var res = parseCurrency(XML);
		assertEquals(res, Currency.EUR.toString());
	}

	@Test
	public void testPreferredResolutionExists() {
		final var clock = createDummyClock();
		// Create sample data
		var table = ImmutableTable.<Duration, ZonedDateTime, Double>builder()
				.put(Duration.ofMinutes(15), ZonedDateTime.now(clock), 100.0)
				.put(Duration.ofMinutes(15), ZonedDateTime.now(clock).plusMinutes(15), 200.0)
				.put(Duration.ofMinutes(60), ZonedDateTime.now(clock), 300.0) //
				.build();

		// Preferred resolution
		var preferredResolution = Resolution.QUARTERLY;

		// Call the method
		var result = getDuration(table, preferredResolution);

		// Assert
		assertEquals("The preferred resolution should match.", Duration.ofMinutes(15), result);
	}

	@Test
	public void testPreferredResolutionDoesNotExist() {
		// Create sample data
		var table = ImmutableTable.<Duration, ZonedDateTime, Double>builder()
				.put(Duration.ofMinutes(15), ZonedDateTime.now(), 100.0)
				.put(Duration.ofMinutes(15), ZonedDateTime.now().plusMinutes(15), 200.0)
				.put(Duration.ofMinutes(15), ZonedDateTime.now().plusMinutes(30), 300.0).build();

		// Preferred resolution that does not exist
		var preferredResolution = Resolution.HOURLY;

		// Call the method
		var result = getDuration(table, preferredResolution);

		// Assert
		assertEquals("The shortest duration should be returned when preferred is unavailable.", Duration.ofMinutes(15),
				result);
	}

	@Test
	public void testProcessPricesNormalCase() {
		var baseTime = ZonedDateTime.parse("2023-01-01T00:00:00Z");
		var clock = Clock.fixed(baseTime.toInstant(), baseTime.getZone());

		var timePriceMap = ImmutableSortedMap.<ZonedDateTime, Double>naturalOrder() //
				.put(baseTime, 10.0)//
				.put(baseTime.plusMinutes(15), 20.0) //
				.put(baseTime.plusMinutes(30), 30.0) //
				.build();

		Double[] gridFees = { 1.0, 2.0, 3.0 }; // Length 3
		var gridFeesObject = TimeOfUsePrices.from(baseTime, gridFees);
		var exchangeRate = 1.0;

		var result = Utils.processPrices(clock, timePriceMap, exchangeRate, gridFeesObject);

		assertEquals(3, result.asArray().length);
		assertEquals(20.0, result.getAt(baseTime), 0.001);
		assertEquals(40.0, result.getAt(baseTime.plusMinutes(15)), 0.001);
		assertEquals(60.0, result.getAt(baseTime.plusMinutes(30)), 0.001);

		Double[] gridFees2 = { 1.0, 2.0, 3.0, 4.0, 5.0 }; // Length 5
		gridFeesObject = TimeOfUsePrices.from(baseTime, gridFees2);
		result = Utils.processPrices(clock, timePriceMap, exchangeRate, gridFeesObject);

		// Ensures that excess grid fees are truncated when the grid fees array is
		// longer than the number of price entries.
		assertEquals(3, result.asArray().length);
	}
}
