package io.openems.edge.tesla.powerwall2.battery;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

import io.openems.edge.common.type.Phase.SinglePhase;

@ObjectClassDefinition(name = "Tesla Powerwall 2 Battery", //
		description = "Implements the Tesla Powerwall 2 Battery.")
@interface Config {

	@AttributeDefinition(name = "Component-ID", description = "Unique ID of this Component")
	String id() default "ess0";

	@AttributeDefinition(name = "Alias", description = "Human-readable name of this Component; defaults to Component-ID")
	String alias() default "";

	@AttributeDefinition(name = "Is enabled?", description = "Is this Component enabled?")
	boolean enabled() default true;

	@AttributeDefinition(name = "Phase", description = "On which Phase is the Powerwall connected?")
	SinglePhase phase() default SinglePhase.L1;

	@AttributeDefinition(name = "Core-ID", description = "Component-ID of \"Tesla Powerwall 2 Core\" component ?")
	String core_id() default "tesla0";

	@AttributeDefinition(name = "Core target filter", description = "This is auto-generated by 'Core-ID'.")
	String core_target() default "(enabled=true)";

	String webconsole_configurationFactory_nameHint() default "Tesla Powerwall 2 Battery [{id}]";

}
