package io.openems.edge.scheduler.jscalendar;

import io.openems.common.test.AbstractComponentConfig;

@SuppressWarnings("all")
public class MyConfig extends AbstractComponentConfig implements Config {

	protected static class Builder {
		private String id;
		private String jsCalendar;
		private String[] alwaysRunAfterControllerIds;
		private String[] alwaysRunBeforeControllerIds;

		private Builder() {
		}

		public Builder setId(String id) {
			this.id = id;
			return this;
		}

		public Builder setAlwaysRunAfterControllerIds(String... alwaysRunAfterControllerIds) {
			this.alwaysRunAfterControllerIds = alwaysRunAfterControllerIds;
			return this;
		}

		public Builder setAlwaysRunBeforeControllerIds(String... alwaysRunBeforeControllerIds) {
			this.alwaysRunBeforeControllerIds = alwaysRunBeforeControllerIds;
			return this;
		}

		// CHECKSTYLE:OFF
		public Builder setJSCalendar(String jsCalendar) {
			// CHECKSTYLE:ON
			this.jsCalendar = jsCalendar;
			return this;
		}

		public MyConfig build() {
			return new MyConfig(this);
		}
	}

	/**
	 * Create a Config builder.
	 *
	 * @return a {@link Builder}
	 */
	public static Builder create() {
		return new Builder();
	}

	private final Builder builder;

	private MyConfig(Builder builder) {
		super(Config.class, builder.id);
		this.builder = builder;
	}

	@Override
	public String[] alwaysRunBeforeController_ids() {
		return this.builder.alwaysRunBeforeControllerIds;
	}

	@Override
	public String jsCalendar() {
		return this.builder.jsCalendar;
	}

	@Override
	public String[] alwaysRunAfterController_ids() {
		return this.builder.alwaysRunAfterControllerIds;
	}
}